/*
$VerboseHistory: last.e$
*/
#include 'slick.sh'
/* This module should be link after parseoption, .... ... */
/* function have been loaded. Also the keyboard should be functional */
/* before this module can be useful. */

_str st_batch_mode=0;    /* True if compiling batch program with -p option. */
#define ST_COMMAND '0 vstw'

_command st(...) name_info(','VSARG2_REQUIRES_MDI_EDITORCTL)
{
   return(vstw(arg(1),arg(2),arg(3)));

}
_command vstw() name_info(','VSARG2_REQUIRES_MDI_EDITORCTL)
{
  name=arg(1);
  tconvert='';
  st_command=ST_COMMAND;
  quiet=0;


  errfile='';
  if ( st_batch_mode ) {
     qparams='';
  } else {
     _error_file=absolute(COMPILE_ERROR_FILE);
     qparams="-q -e "COMPILE_ERROR_FILE" ";
     quit_error_file();
     errfile=_error_file;
  }
  
  for (;;) {
     option=parse_file(name)
     if (option=='') break;
     uoption=upcase(option);
     ch=substr(uoption,1,1);
     if (ch!='-' && ch!='+') {
        name=name' 'maybe_quote_filename(option);
        break;
     }
     switch (substr(uoption,2)) {
     case 'Q':
        qparams=qparams:+option' ';
        break;
     case 'W':
        quiet=1;
        break;
     case 'F':
        option=parse_file(name);
        qparams=qparams:+' -F 'option' ';
        break;
     case 'T':
        tconvert='-t '
        st_command=st_command:+'17';
        break;
     case 'TD':
        tconvert='-tu ';
        break;
     case 'TU':
        tconvert='-tu ';
        break;
     default:
        if (substr(uoption,2,1)=='I') {
           qparams=qparams:+maybe_quote_filename(option)' ';
           break;
        }
        _message_box('Invalid option uoption='uoption);
        return(1);
     }
  }
  if ( name=='' ) {
    extension=get_extension(p_buf_name)
    if ( file_eq('.'extension,_macro_ext) || file_eq(extension,'cmd') ||
       (file_eq(extension,'sh') && tconvert!='') ) {
      if ( p_modify ) {
         status=save()
         if ( status ) {
            return(status);
         }
      }
      name=maybe_quote_filename(p_buf_name);
    } else {
       prompt('',nls('Compile macro'))
    }
  }
  if ( ! quiet ) { message nls('Compiling') }
  rc=0
  if (_win32s()==1) {
     line=st_command " "tconvert:+qparams;
     /* Since can't pass environment to compiler, use -i switch. */
     /* -i switch might already have been specified. */
     if (!pos(' -i( |)',name,1,'r') ) {
        value=get_env('VSLICKINCLUDE')
        if (value!='') {
           name='-i 'value' 'name;
        }
     }
     line=line:+name;
     if (errfile!='') {
        status=delete_file(errfile);
        if (status && status!=FILE_NOT_FOUND_RC) {
           _message_box(nls("Unable to delete '%s'",errfile))
           return(status);
        }
     }
     status=shell(line,'n')
     if (status==0 && errfile!='' && file_match('-p 'errfile,1)!='') {
        status=1;
     }
  } else {
     line=st_command" "tconvert:+qparams:+name
     //messageNwait('line='line);
     status=shell(line,'n')
  }

  if ( status==FILE_NOT_FOUND_RC ) {
     message nls('ST program not found')
     return(status)
  }
  if ( status<0 ) {  /* error from shelling st? */
     message get_message(status)
     return(status)
  }
  if ( status!=0 ) {
     p_window_id=_mdi.p_child;
     status=st_position_on_error()
     /* Must return 1 since the built in make facililty needs to know */
     /* that the message has already been displayed by st_position_on_error. */
     return(1)
  } else {
    if ( ! quiet ) { message nls('Compilation completed successfully.') }
  }
  return(0);

}
_str st_position_on_error()
{
  if (arg(1)!='') {
     _error_file=arg(1);
  }
  if (_in_firstinit) {
     index=find_index('st_position_on_error',PROC_TYPE);
     _post_call(index,_error_file);
     return(1);
  }
  status=load_files('+d +l 'maybe_quote_filename(_error_file));
  if ( status ) {
     if (status==NEW_FILE_RC) {
        _delete_buffer();
     }
     return(1)
  }
  //status=delete_file(_error_file);
  get_line msg
  if ( substr(msg,1,16)=="Slick Translator" ) {
     _delete_line();
     _delete_line();
  }
  if ( p_Noflines>0 ) {
    get_line(last_line);
    _delete_buffer();
    //parse last_line with filename ' ' line col ':' msg
    temp=last_line;
    filename=parse_file(temp);
    parse temp with line col':'msg;
    if ( filename=='' || ! isinteger(line) || ! isinteger(col) || msg=='' ) {
       msg=last_line;
    } else {
       status=edit(filename);
       if ( ! status && line!='' && col!='' ) {
          name=strip_filename(filename,'P');
          oldscroll_style=_scroll_style();
          _scroll_style('C');
          if ( col<=0 ) {
            p_line=line-1;    /* compiler is off by 1 */
            get_line(currentline);
            p_col=length(currentline);
          } else {
            p_col=col;
            p_line=line;
          }
          _scroll_style(oldscroll_style);
       }
    }
  } else {
    if ( msg=='' ) msg=nls('No errors');
    _delete_buffer();
  }
  refresh();  /* Don't want message to go to shell window. */
              /* Refresh will close shell window and redraw editor screen. */
  message(msg);
  st_compile_error=1;
  return(0);

}
void _UpdateSlickCStack(int ignoreNStackItems=0,int errorCode=0,_str DumpFileName="")
{
   if (!index_callable(find_index('tbShow',PROC_TYPE|COMMAND_TYPE)) ||
       !_hit_defmain
        ) {
      if (errorCode<0) {
         say(get_message(errorCode));
      }
      _StackDump(0,1,ignoreNStackItems+1);
      return;
   }
   wid=_find_object('_tbslickc_stack_form');
   if (!wid) {
      tbShow('_tbslickc_stack_form');
      wid=_find_object('_tbslickc_stack_form');
      if (!wid) {
         return;
      }
   }
   _nocheck _control edit1;
   wid.edit1._lbclear();
   if (DumpFileName!='') {
      wid.edit1.insert_line(' Stack trace written to file: 'DumpFileName);
   }
   if (errorCode<0) {
      wid.edit1.insert_line(' 'get_message(errorCode));
   }
   wid.edit1._StackInsertList(ignoreNStackItems+1);
   wid.edit1.top();wid.edit1.down();
}

defeventtab slickc_stack_keys
def 'ENTER'=slickc_stack_goto
def 'LBUTTON-DOUBLE-CLICK'=slickc_stack_goto

_command void slickc_stack_goto() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_MDI|VSARG2_EDITORCTL)
{
   if ( command_state() || p_window_state:=='I' ) {
      try_calling(eventtab_index(_default_keys,
                          _default_keys,event2index(ENTER)));
      return;
   }
   get_view_id(edit1_view_id);edit1_buf_id=p_buf_id;
   get_line(line);
   if (line=="" || substr(line,1,1)=="") {
      _beep();
      return;
   }
   parse line with filename offset proc_name'(';
   ext=get_extension(filename,1);
   if (file_eq(ext,DLLEXT)) {
      // This is a dll entry
      status=find_tag('-e c 'proc_name);
      if (status) {
         return;
      }
   } else {
      filename=strip_filename(filename,'E');
      filename=filename:+_macro_ext;
      found=slick_path_search(filename);
      if (found=="") {
         _message_box(nls("File %s not found",filename));
         return;
      }
      filename=found;
      status=edit(maybe_quote_filename(filename));
      if (status) {
         return;
      }
      status=st('-f 'offset);
      /*if (status) {
         return;
      } */
   }
   get_view_id(view_id);buf_id=p_buf_id;
   activate_view(edit1_view_id);
   p_buf_id=edit1_buf_id;
   save_pos(p);
   top();up();
   for (;;) {
      if (down()) {
         break;
      }
      _lineflags(0,CURLINEBITMAP_LF);
   }
   restore_pos(p);
   _lineflags(CURLINEBITMAP_LF,CURLINEBITMAP_LF);
   activate_view(view_id);p_buf_id=buf_id;
}
_command void slickc_stack_mode() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_MDI)
{
  p_mode_name='Slick-C Stack';
  p_extension="";
  p_mode_eventtab=find_index('slickc_stack_keys',EVENTTAB_TYPE)
  //_message_box('p_mode_eventtab='p_mode_eventtab);
}
#define SLICKC_STACK_BUFNAME ".slickc_stack"
#define EditWindowBufferID edit1.p_user
defeventtab _tbslickc_stack_form
void edit1.on_create()
{
   EditWindowBufferID=p_buf_id;
   status=load_files("+q +b "SLICKC_STACK_BUFNAME);
   if (status) {
      load_files("+q +t");
      p_buf_name=SLICKC_STACK_BUFNAME;
      p_buf_flags|=HIDE_BUFFER|THROW_AWAY_CHANGES;
   }
   slickc_stack_mode();
   //p_readonly_mode=1;
   p_window_flags|=(OVERRIDE_CURLINE_RECT_WFLAG|CURLINE_RECT_WFLAG);
   p_MouseActivate=MA_NOACTIVATE;
}
void edit1.on_destroy()
{
   if (EditWindowBufferID!=p_buf_id) {
      /*if (p_buf_flags&HIDE_BUFFER) {
         if (!_DialogViewingBuffer(p_buf_id,p_window_id)) {
            call_list('_cbquit_');
            _delete_buffer();
         }
      } */
      load_files('+q +m +bi 'EditWindowBufferID);
   }
}
void _tbslickc_stack_form.on_resize()
{

   formWid=p_active_form;
   edit1_wid=edit1;
   if (formWid.p_isbutton_bar) {
      //say('got here');
      name1='ctlgrabbar1';
      name2='ctlgrabbar2';
      grabbar1_wid=_find_control(name1);
      if (formWid.p_isbutton_bar==BBSIDE_TOP || formWid.p_isbutton_bar==BBSIDE_BOTTOM) {
         x1=_twips_per_pixel_x()*1;
         y1=_twips_per_pixel_y()*2;
         width1=0;
         height1=formWid.p_height-_twips_per_pixel_y()*4;

         x2=x1+_twips_per_pixel_x()*(3+1);
         y2=y1;
         width2=width1;
         height2=height1;

         start_x=x2+_twips_per_pixel_x()*(3+2);
         start_y=0;
         style=PSPIC_GRABBARVERT;
      } else {
         x1=_twips_per_pixel_x()*2;
         y1=_twips_per_pixel_y()*1;
         width1=formWid.p_width-_twips_per_pixel_x()*4;
         height1=0;

         x2=x1;
         y2=y1+_twips_per_pixel_y()*(3+1);
         width2=width1;
         height2=height1;

         start_x=0;
         start_y=y2+_twips_per_pixel_y()*(3+2);
         style=PSPIC_GRABBARHORZ;
      }
      if (!grabbar1_wid) {
         get_view_id(orig_view_id);
         grabbar1_wid=_create_window(OI_IMAGE,formWid,"",x1,y1,width1,height1,CW_CHILD,BDS_NONE);
         grabbar1_wid.p_name=name1;
         grabbar1_wid.p_style=style;
         grabbar2_wid=_create_window(OI_IMAGE,formWid,"",x2,y2,width2,height2,CW_CHILD,BDS_NONE);
         grabbar2_wid.p_style=style;
         grabbar2_wid.p_name=name2;
         activate_view(orig_view_id);
      } else {
         grabbar2_wid=_find_control(name2);
         grabbar1_wid._move_window(x1,y1,width1,height1);
         grabbar2_wid._move_window(x2,y2,width2,height2);
      }
      edit1_wid.p_x=start_x;
      edit1_wid.p_y=start_y;

      edit1_wid.p_width = _dx2lx(SM_TWIP,formWid.p_client_width) - start_x-0;
      edit1_wid.p_height = _dy2ly(SM_TWIP,formWid.p_client_height) - start_y-0;
      return;
   }

   edit1.p_width=_dx2lx(SM_TWIP,p_active_form.p_client_width)-edit1.p_x*2;
   edit1.p_height=_dy2ly(SM_TWIP,p_active_form.p_client_height)-edit1.p_y*2;
}
void _on_slickc_error(int errorCode,_str filename)
{
   _UpdateSlickCStack(1,errorCode,filename);
   //_StackDump(0,1,1);
}
