/*
$VerboseHistory: makefile.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:33a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:32a
 * Comment:
 * Added support for Explorer style open dialog.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/09/1997 02:26p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'
#define NO_MAKEFILE_INI_FILES 1
#define CurrentAssociation ctlassociate.p_user
defeventtab _makefile_form

static _str IniFileInfo:[]:[];

definit()
{
   IniFileInfo._makeempty();
}

static void InitIniFileInfo()
{
   IniFileInfo:["Borland C++"]:["VSearch"]='# Borland C++ IDE generated makefile';
   IniFileInfo:["Borland C++"]:["VBefore"]=3;
   IniFileInfo:["Borland C++"]:["VFileExt"]='mak';
   IniFileInfo:["Borland C++"]:["SourceLine"]='^:p\.obj @\: @{:p}$';
   IniFileInfo:["Borland C++"]:["SourceList"]='';
   IniFileInfo:["Borland C++"]:["VariableStart"]='$(';
   IniFileInfo:["Borland C++"]:["VariableEnd"]=')';
   IniFileInfo:["Borland C++"]:["ContinuationChar"]='\';

   IniFileInfo:["Microsoft Visual C++"]:["VSearch"]='# Microsoft Developer Studio';
   IniFileInfo:["Microsoft Visual C++"]:["VBefore"]=2;
   IniFileInfo:["Microsoft Visual C++"]:["VFileExt"]='mak dsp';
   IniFileInfo:["Microsoft Visual C++"]:["SourceLine"]='^SOURCE={(:p)|("?@")}$';
   IniFileInfo:["Microsoft Visual C++"]:["SourceList"]='^DEP_CPP_?@={?@}$';
   IniFileInfo:["Microsoft Visual C++"]:["VariableStart"]='$(';
   IniFileInfo:["Microsoft Visual C++"]:["VariableEnd"]=')';
   IniFileInfo:["Microsoft Visual C++"]:["ContinuationChar"]='\';
}

static int GetAssociation(_str &AssociatedFilename,.../*MakefileType*/)
{
   parse CurrentAssociation with AssociatedFilename "\t" MakefileType;
   return(0);
}

static int DisplayAssociation()
{
   parse p_active_form.p_caption with 'Makefile Association - ' ProjectFilename;
   parse CurrentAssociation with MakefileName "\t" MakefileType;
   if (MakefileName=='' || MakefileType=='') {  
      label2.p_caption='This project is not associated to a makefile';
      return(0);
   }else{
      filename=MakefileName;
      type=MakefileType;
      label2.p_caption='This project is associated to 'filename' ':+type;
   }
   return(0);
}

ctlassociate.on_create()
{
   if (IniFileInfo._isempty()) {
      InitIniFileInfo();
   }
   ProjectFilename=arg(1);
   p_active_form.p_caption='Makefile Association - 'ProjectFilename;
   CurrentAssociation=arg(2);
   DisplayAssociation();
   ctlbreak.p_enabled=pos('is associated to',label2.p_caption)!=0;
#if __UNIX__
   ctlassociate.p_enabled = false;
   ctlbreak.p_enabled = false;
#endif
   return(0);
}

#define MAKEFILE_INI_FILENAME 'makefile.ini'

static int GetSourceFileSearchString(_str Type,_str &SearchRE)
{
#if NO_MAKEFILE_INI_FILES
   SearchRE=IniFileInfo:[Type]:['SourceLine'];
   return(0);
#else
   INIFilename=slick_path_search(MAKEFILE_INI_FILENAME);
   if (INIFilename=='') return(FILE_NOT_FOUND_RC);;
   status=_ini_get_value(INIFilename,Type,'SourceLine',SearchRE,'');
   return(status);
#endif
}

static _str GetVariableValue(_str VarName,_str (&vartab):[])
{
   line='';
   if (!vartab._indexin(VarName)) {
      save_pos(p);
      p_line=0;
      status=search('^'_escape_re_chars(VarName)' @=','r@');
      if (status) {
         restore_pos(p);
      }else{
         get_line(line);
         lp=lastpos('=',line);
         if (!lp) return('');
         filename=substr(line,lp+1);
         filename=strip(filename);
         line=filename;
         vartab:[VarName]=line;
         restore_pos(p);
         return(line);
      }
   }else{
      line=vartab:[VarName];
      return(line);
   }
   if (line=='') {
      line=get_env(VarName);
      if (line=='') return('');
      vartab:[VarName]=line;
      return(line);
   }
   return(line);
}

//Ok, here I am just going to cheat and grab the list.
//We can add more stuff to the ini file later if we have to
static void AddVariableValueToList(_str VarName,_str &FileList,
                                   _str VariableStart,_str VariableEnd,
                                   _str ProjectDir,_str ContinuationChar,
                                   boolean (&hashtab):[],
                                   _str (&vartab):[])
{
   VarName=substr(VarName,length(VariableStart)+1);
   VarName=substr(VarName,1,length(VarName)-length(VariableEnd));
   //orig_dir=getcwd();chdir(ProjectDir,1);
   GetVariableValue(VarName,vartab);
   save_pos(p);
   //get_line(line);
   line=vartab:[VarName];
   for (;;) {
      if (line._varformat()==VF_EMPTY) {
         break;
      }
      line=strip(line);
      stripped=0;
      if (last_char(line)==ContinuationChar) {
         line=substr(line,1,length(line)-1);
         stripped=1;
      }
      if (strip(line)!='') {
         filename=absolute(line);
         if (!hashtab._indexin(filename)) {
            hashtab:[filename]=1;
            filename=maybe_quote_filename(filename);
            FileList=FileList' 'filename;
         }
      }
      if (!stripped) break;
      down();
      get_line(line);
   }
   //chdir(orig_dir,1);
   restore_pos(p);
}


static _str PathsExpanded(_str filename,_str VariableStart,_str VariableEnd,
                          boolean (&hashtab):[],_str (&vartab):[])
{
   if (!pos('{',filename)) {
      return(filename);
   }
   p=pos('{'_escape_re_chars(VariableStart):+'?@'_escape_re_chars(VariableEnd)'}',
         filename,1,'r');
   if (p) {
      varname=substr(filename,pos('s0'),pos('0'));
      varname=substr(varname,length(VariableStart)+1);
      varname=substr(varname,1,length(varname)-length(VariableEnd));
      val=GetVariableValue(varname,vartab);
      rfilename=substr(filename,pos('}',filename)+1);
      rfilename=strip(rfilename,'B','"');
      if (val=='') return('');
      list='';
      for (;;) {
         parse val with cur (PATHSEP) val;
         if (cur=='') break;
         filename=cur:+rfilename;
         if (file_match(filename' -p',1)!='') {
            if (list=='') {
               list=maybe_quote_filename(filename);
            }else{
               list=list' 'maybe_quote_filename(filename);
            }
         }
      }
      return(list);
   }
   return('');
}

static int GetFileListFromMakefile(_str MakefileName,_str Type,_str &FileList)
{
   FileList="";
#if __UNIX__
   //say("GetFileListFromMakefile Searching "MakefileName);
   FileList = "\"dummyFile 1\"";
   FileList = FileList :+ " ";
   FileList = FileList :+ "dummyFile2";
   return(0);
#else
   INIFilename=slick_path_search(MAKEFILE_INI_FILENAME);
   if (!INIFilename) FILE_NOT_FOUND_RC;
#if NO_MAKEFILE_INI_FILES
   VariableStart=IniFileInfo:[Type]:['VariableStart'];
   VariableEnd=IniFileInfo:[Type]:['VariableEnd'];
   SourceList=IniFileInfo:[Type]:['SourceList'];
   ContinuationChar=IniFileInfo:[Type]:['ContinuationChar'];
#else
   _ini_get_value(INIFilename,Type,'VariableStart',VariableStart,'');
   _ini_get_value(INIFilename,Type,'VariableEnd',VariableEnd,'');
   _ini_get_value(INIFilename,Type,'ContinuationChar',ContinuationChar,'');
   _ini_get_value(INIFilename,Type,'SourceList',SourceList,'');
#endif

   ProjectDir=strip_filename(MakefileName,'N');
   status=GetSourceFileSearchString(Type,SourceFileRE);
   if (status||SourceFileRE=='') return(status);
   status=_open_temp_view(MakefileName,temp_view_id,orig_view_id);
   if (status) {
      if (status==NEW_FILE_RC) {
         p_view_id=orig_view_id;
         _delete_temp_view(temp_view_id);
      }
      return(status);
   }
   p_line=0;
   FileList='';
   boolean hashtab:[];
   hashtab._makeempty();
   _str vartab:[];
   vartab._makeempty();
   orig_dir=getcwd();
   chdir(ProjectDir,1);
   for (;;) {
      status=search(SourceFileRE,'@r>');
      if (status) break;
      filename=get_text(match_length('0'),match_length('S0'));
      varend=substr(filename,(length(filename)+1)-length(VariableEnd),length(VariableEnd));
      if ( (substr(filename,1,length(VariableStart))==VariableStart && VariableStart!='')||
           (substr(filename,length(filename)-length(VariableEnd),length(VariableEnd))==VariableEnd) && VariableEnd!='') {
         AddVariableValueToList(filename,FileList,VariableStart,VariableEnd,ProjectDir,ContinuationChar,hashtab,vartab);
      }else{
         filename=absolute(filename);
         if (!hashtab._indexin(filename)) {
            hashtab:[filename]=1;
            filename=maybe_quote_filename(filename);
            FileList=FileList' 'filename;
         }
      }
   }
   p_line=0;
   if (SourceList!='') {
      for (;;) {
         status=search(SourceList,'@r>');
         if (status) break;
         line=get_text(match_length('0'),match_length('S0'));
         for (;;) {
            line=strip(line);
            stripped=0;
            if (last_char(line)==ContinuationChar) {
               line=substr(line,1,length(line)-1);
               stripped=1;
            }
            if (strip(line)!='') {
#if 0
               filename=absolute(line);
               if (!hashtab._indexin(filename)) {
                  hashtab:[filename]=1;
                  filename=maybe_quote_filename(filename);
                  FileList=FileList' 'filename;
               }
#else
               if (!pos('{',line)) {
                  filename=absolute(line);
                  if (!hashtab._indexin(filename)) {
                     hashtab:[filename]=1;
                     filename=maybe_quote_filename(filename);
                     FileList=FileList' 'filename;
                  }
               }else{
                  list=PathsExpanded(line,VariableStart,VariableEnd,hashtab,vartab);
                  for (;;) {
                     cur=parse_file(list);
                     if (cur=='') break;
                     if (!hashtab._indexin(cur)) {
                        FileList=FileList' 'cur;
                        hashtab:[cur]=1;
                     }
                  }
               }
#endif
            }
            if (!stripped) break;
            down();
            get_line(line);
         }
      }
   }
   chdir(orig_dir,1);
   FileList=strip(FileList);
   p_view_id=orig_view_id;
   _delete_temp_view(temp_view_id);
   return(0);
#endif
}

#define MSVC_HEADER_STRING '# Microsoft Developer Studio'
#define MAKEFILE_INI_FILE 'makefile.ini'

static int GetMakefileType(_str Filename,_str &MakefileType)
{
#if !__UNIX__
   MakefileType='';
   status=_open_temp_view(Filename,MakefileViewId,orig_view_id);
   p_line=0;
   //p_view_id=orig_view_id;
#if NO_MAKEFILE_INI_FILES
   for (i._makeempty();;) {
      IniFileInfo._nextel(i);
      if (i._isempty()) break;
      VSearch=IniFileInfo:[i]:['VSearch'];
      VBefore=IniFileInfo:[i]:['VBefore'];
      VFileExt=IniFileInfo:[i]:['VFileExt'];
      if (VSearch!='') {
         p_line=0;
         status=search(VSearch,'@');
         lineno=p_line;
         if (status || lineno>VBefore) continue;
      }
      if (VFileExt!='') {
         ext=get_extension(Filename);
         if (!pos(' 'ext' ',' 'VFileExt' ',1,_fpos_case)) continue;
      }
      MakefileType=i;
      break;
   }
   p_view_id=orig_view_id;
   _delete_temp_view(MakefileViewId);
#else
   TypeFilename=slick_path_search(MAKEFILE_INI_FILE);
   if (TypeFilename=='') return(FILE_NOT_FOUND_RC);
   orig_view_id=_create_temp_view(TypeListViewId);
   _ini_list_sections(TypeFilename);
   Done=0;
   p_line=0;
   while (!down()) {
      get_line(line);
      TypeName=strip(line);
      _ini_get_value(TypeFilename,TypeName,'VSearch',VSearch,'');
      _ini_get_value(TypeFilename,TypeName,'VBefore',VBefore,'');
      _ini_get_value(TypeFilename,TypeName,'VFileExt',VFileExt,'');
      //_ini_get_value(TypeFilename,TypeName,'SourceLine',SourceLine,'');o
      if (VSearch!='') {
         p_view_id=MakefileViewId;
         p_line=0;
         status=search(VSearch,'@');
         lineno=p_line;
         p_view_id=TypeListViewId;
         if (status || lineno>VBefore) continue;
      }
      if (VFileExt!='') {
         ext=get_extension(Filename);
         if (!pos(' 'ext' ',' 'VFileExt' ',1,_fpos_case)) continue;
      }
      MakefileType=TypeName;
      break;
   }
   p_view_id=orig_view_id;
   _delete_temp_view(MakefileViewId);
   _delete_temp_view(TypeListViewId);
#endif
#endif
   return(0);
}

ctladd_files.lbutton_up()
{
   olddir=getcwd();
   ProjectDir=strip_filename(_project_name,'n');
   if (!file_eq(olddir,ProjectDir)) {
      chdir(ProjectDir,1);
   }
   result=_OpenDialog('-modal '_stdform('_open_form'),
               'Get Project Files from Makefile',
#if __UNIX__
               'make*;Make*;*.mak',
               'Makefiles (make*;Make*;*.mak),All Files ('ALLFILES_RE')',
#else
               '*.mak;*.dsp',
               'Makefiles (*.mak;*.dsp),All Files ('ALLFILES_RE')',
#endif
               OFN_FILEMUSTEXIST,
               '',
               '',
               '');
   chdir(olddir,1);
   if (result=='') return(COMMAND_CANCELLED_RC);
   status=GetMakefileType(result,type);
   status=GetFileListFromMakefile(result,type,FileList);
   if (status) {
      return(status);
   }
   list=FileList;
   orig_view_id=_create_temp_view(temp_view_id);
   p_view_id=temp_view_id;
   for (;;) {
      filename=parse_file(list);
      filename=strip(filename,'b','"');
      //if (file_match(filename' -p',1)=='') continue;
      if (filename=='') break;
      insert_line(' 'filename);
   }
   p_view_id=orig_view_id;
   result=show('-modal _sellist_form',
               'Select Files to Add to Project',
               SL_VIEWID|SL_SELECTALL|SL_INVERT|SL_ALLOWMULTISELECT,// flags
               temp_view_id);
   if (result=='') return(COMMAND_CANCELLED_RC);
   FileList=result;
   _param1=1;
   _param2=FileList;
   p_active_form._delete_window(CurrentAssociation);
}

//Optional third argument is a character to put in front of files that come
//from an associated makefile(I recommend using '*', because it is invalid).
//This is to identify the files as being members of an associated makefile...
int GetProjectFiles(_str ProjectFilename,int &FileViewId,
                    _str MakefileIndicator="",
                    _str Makefilename=null,// null means get makefile and type from project file.
                                           // Anything else means already 
                                           // have Makefilename and MakeFileType
                    _str MakefileType="")
{
   if (IniFileInfo._isempty()) {
      InitIniFileInfo();
   }
   ch=MakefileIndicator;
   status=_ini_get_section(ProjectFilename,"FILES",FileViewId);
   if (status) {
      orig_view_id=_create_temp_view(FileViewId);
      activate_view(orig_view_id);
   }
   if (_project_name=='') return(FILE_NOT_FOUND_RC);
   if (Makefilename==null) {
      status=_ini_get_value(ProjectFilename,"ASSOCIATION",'makefile',result,'');
      if (status) return(0);//Other part succeeded
      Makefilename=result;
      status=_ini_get_value(ProjectFilename,"ASSOCIATION",'makefiletype',result,'');
      if (status) return(status);
      MakefileType=result;
   }
   if ((Makefilename!='' && Makefilename!=null) || MakefileType!='') {
      GetFileListFromMakefile(Makefilename,MakefileType,FileList);
      orig_view_id=p_view_id;
      p_view_id=FileViewId;
      for (;;) {
         curfile=parse_file(FileList);
         if (curfile=='') break;
         p_line=0;
         filename=strip(curfile,'b','"');
         for (;;) {
            status=search('^'_escape_re_chars(filename)'$','r@'_fpos_case);
            if (status) break;
            _delete_line();
         }
         insert_line(ch:+filename);
      }
      p_view_id=orig_view_id;
   }
   return(0);
}

ctlassociate.lbutton_up()
{
   olddir=getcwd();
   ProjectDir=strip_filename(_project_name,'n');
   if (!file_eq(olddir,ProjectDir)) {
      chdir(ProjectDir,1);
   }
   result=_OpenDialog('-modal '_stdform('_open_form'),
               'Choose Makefile to Associate to Project',
               '*.mak;*.dsp',
               'Makefiles (*.mak;*.dsp),All Files ('ALLFILES_RE')',
               OFN_FILEMUSTEXIST,
               '',
               '',
               '');
   chdir(olddir,1);
   if (result=='') return(COMMAND_CANCELLED_RC);
   parse p_active_form.p_caption with 'Makefile Association - ' ProjectFilename;
   status=GetMakefileType(result,type);
   MakefileName=maybe_quote_filename(result);
   if (type=='') {
      _message_box(nls("Visual SlickEdit cannot recognize the file %s",MakefileName));
      return(0);
   }
   ctlbreak.p_enabled=pos('is associated to',label2.p_caption)!=0;
   //return(status);
   _param1=1;
   p_active_form._delete_window(MakefileName"\t"type);
}

ctlbreak.lbutton_up()
{
   status=GetAssociation(MakefileName);
   if (status||MakefileName=='') return(0);
   parse p_active_form.p_caption with 'Makefile Association - ' ProjectFilename;
   orig_view_id=_create_temp_view(temp_view_id);
   p_view_id=orig_view_id;
   ctlbreak.p_enabled=pos('is associated to',label2.p_caption)!=0;
   //return(status);
   _param1=1;
   p_active_form._delete_window('');
}

ctlcancel.lbutton_up()
{
   p_active_form._delete_window(CurrentAssociation);
}
