/*
$VerboseHistory: math.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:35a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:34a
 * Comment:
 * Changed math commands to use message line when there
 * are no MDI Child edit windows.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"

  static int index;
  static _str input;
  static _str exp_stack
  static _str sym
  static _str gdefine_names;  // name1=value1 name2=value2
                              // "=" for null
  static _str gdefault_value;
  static _str gwarning;             // Warning message with one %s.
  static _str *gpalready_warned_list; // List of space delimited variable names

_command void add() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK|VSARG2_REQUIRES_AB_SELECTION)
{
   if ( _select_type()!='' ) {
      column_math('+')
   } else {
      message get_message(TEXT_NOT_SELECTED_RC)
   }

#if 0
    /* We have removed this command because we don't think it is useful. */
defc mult==
   if ( _select_type()!='' ) {
      column_math('*')
   } else {
      message get_message(TEXT_NOT_SELECTED_RC)
   }
#endif

}
_str column_math(default_operator)
{
   _get_selinfo first_col,last_col,buf_id
   if ( default_operator=='+' ) {
      result=0
   } else {
      result=1
   }
   filter_init()
   for (;;) {
      status= filter_get_string(line)
      if ( status ) { break }
      if ( line=='' ) { continue }   /* Ignore blank lines. */
#if 0
      // When converting data from mainframe or data base might want
      // to striping leading zeros so the data is not interpreted
      // as octal numbers.
      line=strip(line,"L",'0');
#endif
      status=eval_exp(tempresult,line,'')
      if ( status!=0) {
         message get_message(status);
         return(1)
      } else {
        if ( default_operator=='+' ) {
           result=result+tempresult
        } else {
           result=result*tempresult
        }
      }
   }
   _end_select
   insert_line substr('',1,first_col-1):+result
   return(0)
}
/*
   Input:    hex       0xNNNN, xNNNN, or NNNN  represent a valid hex number 
                       0NNNN, Octal number
                       0bNNNN, bNNNN  represent a valid binary number 
            [base]     input base. Defaults to 16. 
    If input is invalid '' is returned 
*/
_str hex2dec(_str hex,...)
{
   hex=strip(hex)
   sign= 1
   if ( substr(hex,1,1)=='-' ) {
      sign= -1
      hex=substr(hex,2)
   }
   base="";
   if ( arg(2)!='' ) base=arg(2);
   if ( upcase(substr(hex,1,2))=='0B' ) {
      hex=substr(hex,3);
      base=2;
   } else if ( upcase(substr(hex,1,1))=='B' ) {
      hex=substr(hex,2);
      base=2;
   } else if ( upcase(substr(hex,1,2))=='0X' ) {
      base=16;
      hex=substr(hex,3);
   } else if ( upcase(substr(hex,1,1))=='X' ) {
      hex=substr(hex,2);
      base=16;
   } else if (substr(hex,1,1)=='0' && base=="") {
      base=8;
      hex=substr(hex,2);
   }
   if ( hex=='' ) {   /* bad input. return null*/
     return('')
   }
   if (base=="") {
      base=16;
   }
   result=0;
   for (;;) {
      ch=upcase(substr(hex,1,1))
      if ( ch=='' ) { break }
      i=pos(ch,'0123456789ABCDEF')
      if ( ! i ) { return('') }
      result=result*base -1 +i
      hex=substr(hex,2)
   }
   return(result*sign)
}
/* Input:  */
/*      number          decimal number  */
/*      [base]          may be 2 or 8 or 16. */
/* Output:  base=16    0xNNNN */
/*          base=8     0NNNN */
/*          base=2     0bNNNN */
/* If number is invalid '' is returned */
_str dec2hex(long number,... /*int base*/)
{
   if ( arg(2)!='' ) {
      base=arg(2)
      if ( base=='2' ) {
         prefix='0b'
      } else if ( base=='8' ) {
         prefix='0'
      } else {
         prefix='0x'
      }
   } else {
      base=16;prefix='0x'
   }
   if ( ! isinteger(number) ) { return('') }
   sign=''
   if ( number<0 ) {
      sign='-'
      number=-number
   }
   result=''
   while ( number>0 ) {
      i=number intdiv base
      result=substr('0123456789ABCDEF',number-i*base+1,1):+result
      number=i
   }
   if ( result=='' ) { result='0' } /* number must have been 0 */
   if (base==8 && result=='0') {
      return('0')
   }
   return(sign:+prefix:+result)


}
_command void math()
{
   math_base(arg(1),10,'');

}
_command void mathx()
{
   math_base(arg(1),16,'x');

}
_command void matho()
{
   math_base(arg(1),8,'o');

}
_command void mathb()
{
   math_base(arg(1),2,'b');

}
long _negative2dec(long result,int base,_str &msg)
{
   parse result with '-' number
   number=hex2dec(number,base);
   if ( number<pow(2,15) ) {
      msg='16 bit'
      number=(pow(2,16))-number
   } else if ( number<pow(2,31) ) {
      msg='32 bit'
      number=(pow(2,32))-number
   } else {
      /* 64 bits should be big enough.  Have up to 106 bits. */
      msg='64 bit'
      number=(pow(2,64))-number
   }
   return(number)

}
static _str math_base(input,base,num_prefix)
{
   input=prompt(input)
   i=lastpos('=',input);
   if (i && (i==1 || !pos(substr(input,i-1,1),'=!><'))) {
      input=substr(input,1,i-1);
   }
   //messageNwait('math_base: input='input);
   status=eval_exp(result,input,base);
   if (status!=0) {
      message get_message(status)
      return(1);
   }
   /* IF base not 10 and result is negative. */
   if ( base!=10 && pos('-',result) ) {
      number=_negative2dec(result,base,msg)
      msg=msg' result='dec2hex(number,base);
   } else {
      temp=hex2dec(result,base)
      if ( pos('.',temp) ) {   /* Can't display float in hex. */
         msg='dec='temp;
      } else {
         if ( pos('-',temp) ) {
            number=dec2hex(_negative2dec(temp,10,msg))
         } else {
            number=dec2hex(temp);
         }
         msg='dec='temp' hex='number;
         /*
           It would be nice to display hex numbers with
           high bit set as negative decimal number.
           // If this could be a negative decimal number
           if (substr(number,3,1)=='F') {
              //msg=msg' -dec='temp;
           }
         */
      }
   }
   line='math'num_prefix " "input'= 'result;
   //command_put(line);sticky_message(msg);
   append_retrieve_command(line);
   sticky_message(line'  'msg);
   return(0)

}
static void exp_error()
{
   rc=nls('Syntax error')
   _resume

}
static void nextsym()
{
   /* Skip leading spaces */
   index=verify(input,' '\t,'',index)
   if ( ! index ) {
      sym='$';return;
   }
   sym=substr(input,index,1)
   //IF is is the start of a decimal number or operator
   if ( pos(sym,'123456789.><!=~#^&|+-/*%()') ||
      (sym:=='0' && substr(input,index+1,1):=='.') ) {
      if ( isinteger(sym) || sym=='.' ) {
        oldi=index
        if ( sym=='.' ) { index=index+1 }
        sym=substr(input,index,1)
        if ( ! isinteger(substr(input,index,1)) ) { call exp_error() }
        j=verify(input,'0123456789','',index)
        if ( ! j ) { j=length(input)+1 }
        index=j
        sym=substr(input,index,1)
        if ( sym=='.' ) {
          index=index+1
          j=verify(input,'0123456789','',index)
          if ( ! j ) { j=length(input)+1 }
          index=j
          sym=substr(input,index,1)
        }
        if ( upcase(sym)=='E' ) {
          index=index+1
          sym=substr(input,index,1)
          if ( sym=='+' || sym=='-' ) {
            index=index+1
          }
          if ( ! isinteger(substr(input,index,1)) ) { call exp_error() }
          j=verify(input,'0123456789','',index)
          if ( ! j ) { j=length(input)+1 }
        }
        sym=substr(input,oldi,j-oldi)
        index=j
      } else if ( sym=='*' ) {
        index=index+1
        if ( substr(input,index,1)=='*' ) {
          index=index+1
          sym='#'
        }
      } else if ( sym=='>' ) {
         index=index+1
         switch (substr(input,index,1)) {
         case '>':
            index=index+1
            sym='>>';
            break;
         case '=':
            index=index+1
            sym='>=';
            break;
         }
      } else if ( sym=='<' ) {
        index=index+1
        switch (substr(input,index,1)) {
        case '<':
           index=index+1
           sym='<<';
           break;
        case '=':
           index=index+1
           sym='<=';
           break;
        }
      } else if ( sym=='=' ) {
         index=index+1
         switch (substr(input,index,1)) {
         case '=':
            index=index+1
            sym='==';
            break;
         default:
            exp_error();
         }
      } else if ( sym=='!' ) {
         index=index+1
         switch (substr(input,index,1)) {
         case '=':
            index=index+1
            sym='!=';
            break;
         }
      } else if ( sym=='&' ) {
         index=index+1
         switch (substr(input,index,1)) {
         case '&':
            index=index+1
            sym='&&';
            break;
         }
      } else if ( sym=='|' ) {
         index=index+1
         switch (substr(input,index,1)) {
         case '|':
            index=index+1
            sym='||';
            break;
         }
      } else {
        index=index+1
      }
   } else if ( sym=='0' ) {
      first_ch=upcase(substr(input,index+1,1))
      if ( first_ch=='X' ) {
         lex_number(16,verify(input,'0123456789ABCDEFabcdef','',index+2))
      } else if ( first_ch=='B' ) {
         lex_number(2,verify(input,'01','',index+2))
      } else {
         index=index-1
         lex_number(8,verify(input,'01234567','',index+1))
      }
   } else if ( upcase(sym)=='X' && pos(substr(input,index+1,1),'0123456789ABCDEFabcdef') ) {
      lex_number(16,verify(input,'0123456789ABCDEFabcdef','',index+1))
   } else if ( upcase(sym)=='O' && pos(substr(input,index+1,1),'01234567') ) {
      lex_number(8,verify(input,'01234567','',index+1))
   } else if ( upcase(sym)=='B' && pos(substr(input,index+1,1),'01') ) {
      lex_number(2,verify(input,'01','',index+1))
   } else if ( isalpha(sym) || sym=='_') {
      /* get the variable. */
      for (;;) {
        index=index+1
        if ( index>length(input) ) { break }
        ch=substr(input,index,1)
        if ( ! isalnum(ch) ) {
          if ( ch!='_' ) { break }
          //ch='-'
        }
        sym=sym:+ch
      }
      if (gdefine_names!="") {
         if (gdefine_names=="=") {
            value="";
         } else {
            value=eq_name2value(sym,gdefine_names);
         }
         if (!isnumber(value)) {
            value=hex2dec(strip(value));
            if (value=="") {
               if (gwarning!='' && !pos(' 'sym' ',*gpalready_warned_list,1,'i')) {
                  *gpalready_warned_list=*gpalready_warned_list' 'sym' ';
                  _message_box(nls(gwarning,sym));
               }
            }
         }
         sym=value
         if (!isnumber(sym)) {
            sym=gdefault_value;
         }
      } else {
         index=find_index(sym,VAR_TYPE)
         if ( ! index ) {
            rc=nls("Can't find variable '%s'",sym);_resume
         }
         sym= _get_var(index)
      }
   } else {
      exp_error()
   }

}
static void lex_number(base,j)
{
   if ( ! j ) { j=length(input)+1 }
   sym=substr(input,index+1,j-index-1)
   sym=hex2dec(sym,base)
   if ( sym:=='' ) {
     exp_error()
   }
   index=j
}
static void unary_exp()
{
  if ( sym=='-' ) {
    nextsym()
    unary_exp()
    parse exp_stack with e1 exp_stack
    exp_stack=-e1 " "exp_stack
  } else if ( sym=='~' ) {
    nextsym()
    unary_exp()
    parse exp_stack with e1 exp_stack
    exp_stack=~e1 " "exp_stack

  } else if ( sym=='!' ) {
    nextsym()
    unary_exp()
    parse exp_stack with e1 exp_stack
    exp_stack=!e1 " "exp_stack
  } else if ( sym=='+' ) {
    nextsym()
    unary_exp()
  } else if ( sym=='(' ) {
    nextsym()
    exp()
    if ( sym!=')' ) { exp_error() }
     nextsym()
  } else if ( ! verify(sym,'.0123456789eE+-') ) {  /* float? */
    /* This if statement should check for float more closely. */
    exp_stack=sym " "exp_stack
    nextsym()
  } else {
    exp_error()
  }

}
static void reduce_dualop(...)
{

  parse exp_stack with e2 e1 exp_stack
  if ( arg(1)=='&' ) {
    exp_stack=(e1&e2) " "exp_stack
  } else if ( arg(1)=='|' ) {
    exp_stack=(e1|e2) " "exp_stack
  } else if ( arg(1)=='+' ) {
    exp_stack=e1+e2 " "exp_stack
  } else if ( arg(1)=='-' ) {
    exp_stack=e1-e2 " "exp_stack
  } else if ( arg(1)=='*' ) {
    exp_stack=e1*e2 " "exp_stack
#if 0
  } else if ( arg(1)=='???' ) {
    exp_stack=e1 intdiv e2 " "exp_stack
#endif
  } else if ( arg(1)=='%' ) {
    exp_stack=(e1%e2)" "exp_stack
  } else if ( arg(1)=='/' ) {
    exp_stack=(e1/e2)" "exp_stack
  } else if ( arg(1)=='#' ) {
    exp_stack=pow(e1,e2)" "exp_stack
  } else if ( arg(1)=='^' ) {
    exp_stack=(e1^e2) " "exp_stack
  } else if ( arg(1)=='||' ) {
    exp_stack=(e1||e2) " "exp_stack
  } else if ( arg(1)=='&&' ) {
    exp_stack=(e1&&e2) " "exp_stack
  } else if ( arg(1)=='==' ) {
    exp_stack=(e1==e2) " "exp_stack
  } else if ( arg(1)=='!=' ) {
    exp_stack=(e1!=e2) " "exp_stack
  } else if ( arg(1)=='<=' ) {
    exp_stack=(e1<=e2) " "exp_stack
  } else if ( arg(1)=='>=' ) {
    exp_stack=(e1>=e2) " "exp_stack
  } else if ( arg(1)=='>' ) {
    exp_stack=(e1>e2) " "exp_stack
  } else if ( arg(1)=='<' ) {
    exp_stack=(e1<e2) " "exp_stack
  } else if ( arg(1)=='<<' ) {
    exp_stack=(e1<<e2) " "exp_stack
  } else if ( arg(1)=='>>' ) {
    exp_stack=(e1>>e2)" "exp_stack;
  }
}
static int prec_tab:[]={
   '$'=>0,

   '||'=>3,   //??
   '&&'=>4,   //??

   '|'=>6,   //??
   '^'=>7,   //??
   '&'=>8,   //??

   '!='=>9,  //??
   '=='=>9,  //??

   '<'=>10,
   '>'=>10,
   '<='=>10,
   '>='=>10,

   ':+'=>11,
   '<<'=>12,
   '>>'=>12,
   '+'=>13,
   '-'=>13,
   '*'=>14,
   '/'=>14,
   '%'=>14,
   '#'=>15,  // Raise to power operator
};
static void exp()
{
   op_stack[0]='$';vtop=0;
   for (;;) {
      unary_exp()
      if ( !prec_tab._indexin(sym) || sym=='$') {  /* Not binary operator? */
         if ( verify(sym,'.0123456789eE+-') ) {  /* not a float */
             break;
         }
         orig_sym=sym;
         sym='+'
      } else {
         orig_sym=''
      }
      while ( prec_tab:[op_stack[vtop]]>=prec_tab:[sym] ) {
         reduce_dualop(op_stack[vtop])
         --vtop;
      }
      op_stack[++vtop]=sym
      if ( orig_sym=='' ) {
         nextsym()
      } else {
         sym=orig_sym;
      }
   }
   for (; vtop>0; --vtop) {
      reduce_dualop(op_stack[vtop]);
   }
}
/* Upon successful evaluation 0 is returned and */
/* result is set. On error 1 is returned.  */
int eval_exp(_str &result,_str source,int base)
{
   gdefine_names=arg(4);
   gdefault_value=arg(5);
   gwarning=arg(6);
   gpalready_warned_list= &arg(7);
   if (arg()>=4 && gdefine_names=="") gdefine_names="=";
   source=stranslate(source,'',',')
   source=stranslate(source,'','$')
   _suspend
   if ( rc ) {
      if (isinteger(rc) && rc<0 ) {
         message get_message(rc)
         return(rc)
      }
      if ( rc==1 ) {  /* No error? */
         return(0)
      } else {
         return(rc)
      }
   }
   index=1;input=source;nextsym()
   exp_stack=''
   exp()
   if ( sym!='$' ) {
      exp_error()
   }
   result=strip(exp_stack)
   if ( base!=10 && base!='' ) {
      parse result with l ".";
      result=dec2hex(l,base)
   }
   if ( result=='' ) {
      /* dec2hex will fail to convert float to hex or octal. */
      message  nls('Computation resulted in floating point number %s',exp_stack)
   }
   rc=1;_resume
   // never hit this return
   return(1);
}


// Miller-Rabin primality test algorithm, using 32 samples
// Theoretical error rate is 2^-32, providing integer is at
// most 32-bit.
#define MILLER_RABIN_SAMPLES 32

static int seed = 231;
static int random(int low, int high)
{
   for (i=481; i<511; i++) {
      seed = 1 + seed*seed % (13*(high-low+31) + 143*i);
      if (seed < 0) {
         seed = -seed;
      }
   }
   return (seed % (high-low+1)) + low;
}

static int witness(int a, int n)
{
   d=1;
   k=31;
   m=n-1;
   while (k>0 && (m>>k)==0) {
      --k;
   }
   while (k>=0) {
      x = d;
      d = (d*d) % n;
      //_message_box("a="a" d="d" x="x" k="k);
      if (d==1 && x!=1 && x!=n-1) {
         return 1;
      }
      if ((m>>k) & 1) {
         d = (d*a) % n;
      }
      --k;
   }

   //_message_box("d="d);
   return (d!=1)? 1:0;
}

_command isprime() name_info(TAG_ARG','VSARG2_EDITORCTL)
{
   int n;
   n=arg(1);

   if (n <= 3) {
      message(n" is a prime number.");
      return 1;
   }

   if (n % 2 == 0) {
      message(n" is disible by 2.");
      return 0;
   }

   for (j=1; j<32; j++) {
      a = random(1, n-1);
      if (witness(a, n)) {
         message(n" is a composite number.");
         return 0;
      }
   }

   message(n" is a prime number.");
   return 1;
}
