/*
$VerboseHistory: recmacro.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:55a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:55a
 * Comment:
 * Added support for editor control.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:37p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

static typeless _macro_view_id;

   boolean _defining_macro;
   boolean _macro_defined;
   _str _macro_filename;
   static _str
      previous_cmd_index_list
      ,previous_key_index_list
      ,in_pause
      ,_macro_cmdname
      ,_orig_item_text
      ,_orig_help_string
      

   _str def_save_macro   // Prompt to save on end_recording

   #define DEFAULT_MACRO 'last_recorded_macro'  /* Name or last macro recorded. */


definit()
{
   _defining_macro=false;
   in_pause=''
   _macro_filename=''
   previous_cmd_index_list=''
   previous_key_index_list=''
   _macro_view_id=''
   _orig_item_text=''

   index=find_index('last_recorded_macro',COMMAND_TYPE)
   module_index= index_callable(index)
   module_name=name_name(module_index)
   if ( module_name!='recmacro'_macro_ext'x' ) {
      _macro_defined=true;
   } else {
      _macro_defined=false;
   }
}
static void _make_macro_filename()
{
   if ( _macro_filename=='' ) {
      _macro_filename=absolute(_macro_path():+'lastmac'_macro_ext)
   }

}
_str _macro_path(...)
{
   filename='';
   for (i=1;i<=arg();++i) {
      filename=slick_path_search(arg(i));
      if (filename!='') break;
   }
   if (filename=='') {
      filename=slick_path_search(USERDEFS_FILE:+_macro_ext);
      if (filename=='') {
         filename=slick_path_search(USEROBJS_FILE:+_macro_ext);
         if (filename=='') {
            filename=slick_path_search('windefs'_macro_ext'x');
         }
      }
   }
   if (filename=='' || _use_config_path(absolute(filename))) {
      return(_config_path());
   }
   return(strip_filename(filename,'n'))
}
int _OnUpdate_record_macro_toggle(CMDUI &cmdui,int target_wid,_str command)
{
   enabled=MF_ENABLED;
   /*if ( !target_wid || !target_wid._isEditorCtl()) {
      enabled=MF_GRAYED;
   } */
   /*if (!p_mdi_child || p_window_state:=='I') {
      enabled=MF_GRAYED;
   } */
   menu_handle=cmdui.menu_handle;
   button_wid=cmdui.button_wid;
   if (button_wid) {
      if ( !_defining_macro ) {
         button_wid.p_picture=find_index('bbsmrec.bmp',PICTURE_TYPE);
         button_wid.p_message="Stops macro recording";
         button_wid.p_command="record-macro-toggle";
      } else {
         button_wid.p_picture=find_index('bbmrec.bmp',PICTURE_TYPE);
         button_wid.p_message="Starts macro recording";
         button_wid.p_command="record-macro-toggle";
      }
      return(enabled);
   }
   if (cmdui.menu_handle) {
      parse _orig_item_text with keys ',' text
      if ( keys!=def_keys || text=='') {
         _menu_get_state(menu_handle,'record-macro-toggle',flags,'m',new_text,junk,junk,junk,_orig_help_string);
         if (keys==def_keys || text=='') {
            text=new_text;
         }
         _orig_item_text=def_keys','text
         //message '_orig_item_text='_orig_item_text;delay(300);
      }
      parse _orig_item_text with \t key_name
      if ( !_defining_macro ) {
         _menu_set_state(menu_handle,
                         cmdui.menu_pos,enabled,'p',
                      text,
                      'record-macro-toggle','','',
                      _orig_help_string);
      } else {
         enabled=MF_ENABLED;
         status=_menu_set_state(menu_handle,
                                cmdui.menu_pos,enabled,'p',

                      'Stop &Recording Macro'\t:+key_name,
                      'record-macro-toggle','','',
                      'Stops macro recording');
      }
   }
   return(enabled);
}
//_command void record_macro_toggle() name_info(','VSARG2_MARK|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
_command void record_macro_toggle() name_info(','VSARG2_EDITORCTL)
{
   if ( !_defining_macro) {  /* not defining anthing? */
      start_recording()
   } else {
      end_recording()
   }

}
int _OnUpdate_record_macro_end_execute(CMDUI &cmdui,int target_wid,_str command)
{
   if ( _defining_macro ) {  /* defining macro? */
      return(MF_ENABLED);
   }
   return(_OnUpdate_last_macro(cmdui,target_wid,command));
}
_command void record_macro_end_execute() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)
{
   if ( _defining_macro ) {  /* defining macro? */
      end_recording(1 /* don't want to be prompted to bind and save */)
   }
   last_macro()
}

int _OnUpdate_start_recording(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdate_record_macro_toggle(cmdui,target_wid,command));
}
_command start_recording() name_info(','VSARG2_EDITORCTL)
{
   if ( !_defining_macro ) {  /* not defining anthing? */
      status=init_kbd_macro();
      if ( status ) {
         return(status)
      }
      _defining_macro=true;in_pause='';
      previous_cmd_index_list='';
      previous_key_index_list='';
      cancel_index=find_index('cancel_recording',COMMAND_TYPE);
      previous_key_index_list= cancel_key_index();
      previous_cmd_index_list= eventtab_index(_default_keys,_default_keys,
                                            cancel_key_index());
      set_eventtab_index( _default_keys,cancel_key_index(),cancel_index);
      sticky_message(nls("Recording macro"));
      get_view_id(view_id);
      activate_view(_macro_view_id);
      _macro('B');
      activate_view(view_id);
      //_tbChangeButton('BBMREC.BMP','BBSMREC.BMP','end-recording','Stops macro recording');
      return(0)
   }
   message nls('Already defining macro')
   return(1)

}
int _OnUpdate_end_recording(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdate_record_macro_toggle(cmdui,target_wid,command));
}
_command end_recording() name_info(','VSARG2_EDITORCTL)
{
   if ( !_defining_macro ) {  /* not defining anthing? */
     message(nls('Macro not being recorded'));
     return(1);
   }
   orig_wid=p_window_id;
   kbd_macro_terminate();
   get_view_id(view_id);
   activate_view(_macro_view_id);
   bottom();
   // Ouput is only recorded for mdi child, mdi window, cmdline.
   //if (orig_wid.p_mdi_child || orig_wid==_mdi || orig_wid==_cmdline) {
      _delete_line();
   //}
   bottom();insert_line('}');
   p_buf_name=_macro_filename;
   status=_save_file(def_save_options);
   if ( status ) {
      _message_box(nls('Unable to save macro to file "%s"',_macro_filename)'.  'get_message(status));
   }
   activate_view(view_id);
   if ( ! status ) {
      qfilename=maybe_quote_filename(_macro_filename);
      status=st(qfilename)
      if ( ! status ) {
         unload(qfilename)
         status=_load(qfilename)
      }
      if ( ! status ) {
         _macro_defined=true;
         message nls('Macro command %s saved in temp macro file "%s"',DEFAULT_MACRO,_macro_filename)
      }
   }
   if (!status && def_save_macro && arg(1)=='') {
      status=gui_save_macro();
      if (!status) {
         list_macros(_macro_cmdname);
      }
   }
   //_tbChangeButton('BBSMREC.BMP','BBMREC.BMP','start-recording','Starts macro recording');
   return(status)


}
_command list_macros() name_info(','VSARG2_EDITORCTL)
{
   was_recording=_macro();
   result=show('-modal _b2k_form',
               1,         // Allow edit and run buttons
               '',        // Optional title
               arg(1),    //
               MACRO_ARG  //Completion
               );
   _macro('m',was_recording);
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   _macro_delete_line();
   if (result!=1) {
      _macro_call('execute',result);
      return(execute(result,""));
   }
   return(0);

}
static void kbd_macro_terminate()
{
   for (;;) {
      if ( previous_cmd_index_list=='' ) { break }
      parse  previous_cmd_index_list with index previous_cmd_index_list
      parse  previous_key_index_list with keyindex previous_key_index_list
      set_eventtab_index    _default_keys,keyindex,index
   }
   get_view_id view_id
   activate_view _macro_view_id
   indent_kbd_macro()
   activate_view view_id
   in_pause=''
   clear_message
   _macro('E');
   _defining_macro=false;

}

// returns number of views to absolute buffer name buf_name
static int _count_views(buf_name)
{
   last=_last_window_id()
   //option=upcase(arg(2))
   Nofviews=0;
   for (i=1;i<=last;++i) {
      if (_iswindow_valid(i) && i.p_view_id<0 && i.p_buf_name==buf_name) {
         ++Nofviews;
      }
   }
   return(Nofviews)
}
_command void cancel_recording() name_info(','VSARG2_EDITORCTL)
{
   if ( !_defining_macro) {  /* not defining anthing? */
     message(nls('Nothing to cancel'));
   } else {
     kbd_macro_terminate()
     _make_macro_filename()
     if (_count_views(_macro_filename)<=1) {
        get_view_id view_id
        activate_view HIDDEN_VIEW_ID
        status=find_view(_macro_filename)
        if (!status ) {
           _delete_buffer();
           _quit_view();
        }
        activate_view(view_id);
     }
     //_tbChangeButton('BBSMREC.BMP','BBMREC.BMP','start-recording','Starts macro recording');
     message nls('Keyboard macro cancelled. last-recorded-macro not saved.')
   }

}
int _OnUpdate_last_macro(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   if (!p_mdi_child || p_window_state:=='I') {
      return(MF_GRAYED);
   }
   if ( _macro_defined ) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command void last_macro() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   execute(DEFAULT_MACRO,"");
}
_command last_recorded_macro() name_info(','VSARG2_EDITORCTL)
{
   message nls('No macro defined')
}
defeventtab _savekmac_form
ctledit.lbutton_up()
{
   _param1=1;
   p_active_form._delete_window(0);
}
_b2kcommand.on_change(reason)
{
   lbtext=p_cb_list_box._lbget_text();
   _svkmacok.p_enabled=!check_macroid(p_text);
   if (lbtext=='' || !name_eq(lbtext,p_text)) {
      ctledit.p_enabled=1;
      _b2kdelete.p_enabled=0;
      return('')
   }
   _b2kdelete.p_enabled=1;
   ctledit.p_enabled=0;
}
_b2kcommand.on_create()
{
   // Force on_change event.
   _b2kcommand.p_text='';

   p_completion= MACRO_ARG;
   parse p_completion with prefix ':' flags;
   index=find_index(prefix'-match',PROC_TYPE);
   name=call_index('',1,index);
   for (;;) {
      if (name=='') break;
      p_cb_list_box._lbadd_item(name);
      name=call_index('',0,index);
   }
   ctlrequires_mdi_editorctl.p_value=1;
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
      ctledit.p_visible=0;
      //ctlrequires_mdi_editorctl.p_visible=0;
      //ctlrequires_mdi_editorctl.p_value=0;

      if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
         ctleditorctl.p_visible=0;
      }
      ctlicon.p_visible=0;
   }
   wid=_form_parent();
   if (wid && !wid.p_mdi_child) {
      ctledit.p_visible=0;
   }
}
void ctlrequires_mdi_editorctl.lbutton_up()
{
   if (p_value) {
      ctlread_only.p_enabled=true;
      ctlicon.p_enabled=true;
   } else {
      ctlread_only.p_enabled=false;
      ctlicon.p_enabled=false;
      ctlread_only.p_value=0;
      ctlicon.p_value=0;

   }
}
_svkmacok.lbutton_up()
{
   _param1=0;
   name=_b2kcommand.p_text;
   status=check_macroid(name);
   if (status){
      if (status==1) {
         _message_box(nls("Invalid macro name"))
      } else {
         _message_box(nls("This name has already been used.  Please select another name."));
      }
      p_window_id=_b2kcommand;
      _set_sel(1,length(name)+1);_set_focus();
      return('')
   }
   flag_names=''
   if (ctlread_only.p_value) {
      if (flag_names!='') flag_names=flag_names:+'|';
      flag_names=flag_names:+'VSARG2_READ_ONLY';
   }
   if (ctlicon.p_value) {
      if (flag_names!='') flag_names=flag_names:+'|';
      flag_names=flag_names:+'VSARG2_ICON';
   }
   if (_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW) {
      if (ctleditorctl.p_value) {
         if (flag_names!='') flag_names=flag_names:+'|';
         if (ctlrequires_mdi_editorctl.p_value) {
            flag_names=flag_names:+'VSARG2_REQUIRES_EDITORCTL';
         } else {
            flag_names=flag_names:+'VSARG2_EDITORCTL';
         }
      } else if (ctlrequires_mdi_editorctl.p_value) {
         if (flag_names!='') flag_names=flag_names:+'|';
         flag_names=flag_names:+'VSARG2_REQUIRES_MDI_EDITORCTL';
      }
   } else {
      if (ctlrequires_mdi_editorctl.p_value) {
         if (flag_names!='') flag_names=flag_names:+'|';
         flag_names=flag_names:+'VSARG2_REQUIRES_EDITORCTL';
      }
   }
   p_active_form._delete_window(name' 'flag_names);
}

static _str check_macroid(name)
{

   name=translate(name,'_','-');
   if (substr(name,1,1)=='_' || ! isid_valid(name) ) {
      return(1)
   }
   if ( find_index(name,OBJECT_TYPE|EVENTTAB_TYPE|PROC_TYPE|COMMAND_TYPE) &&
        !name_eq(translate(name,'-','_'),DEFAULT_MACRO)
        /*|| h_match_exact(name)!=''*/
      ) {
      return(2)
   }
   return(0);

}
int _OnUpdate_gui_save_macro(CMDUI &cmdui,int target_wid,_str command)
{
   if ( _macro_filename!='' && !_defining_macro) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command gui_save_macro() name_info(','VSARG2_EDITORCTL)
{
   if ( _defining_macro) {
      _macro_delete_line();
      _message_box(nls("Can't save macro while recording"));
      return(1);
   }
   if (_macro_filename=='') {
      _macro_delete_line();
      _message_box(nls("No macro defined"));
      return(1);
   }
   _make_macro_filename();
   if ( file_match('-p 'maybe_quote_filename(_macro_filename),1)=='' ) {
      _message_box(nls('No macro to save.  File %s not found',_macro_filename))
      return(1);
   }
   result=show('-modal _savekmac_form');
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   if (_param1) {
      status=find_proc("-n "DEFAULT_MACRO);
      if (status) {
         _message_box(nls("%s could not be found.", DEFAULT_MACRO));
         return(status);
      }
      return(2); // Use wanted to edit last macro, nothing saved.
   }
   return(save_macro(result));
}
_command save_macro() name_info(','VSARG2_EDITORCTL)
{
   if ( _defining_macro ) {
      _macro_delete_line()
      _message_box(nls("Can't save macro while recording"))
      return(1)
   }
   if (_macro_filename=='') {
      _macro_delete_line()
      _message_box(nls("No macro defined"));
      return(1);
   }
   _make_macro_filename()
   if ( file_match('-p 'maybe_quote_filename(_macro_filename),1)=='' ) {
      message nls('No macro to save.  File %s not found',_macro_filename)
      return(1)
   }
   flag_names='VSARG2_MACRO|VSARG2_MARK'
   if (arg(1)!='') {
      parse arg(1) with name add_flag_names
      if (flag_names!='' && add_flag_names!='') flag_names=flag_names:+'|';
      flag_names=flag_names:+add_flag_names
   } else {
      status=get_string(name,nls('Macro Name:')' ','-.save_macro')
      if ( status ) { return(status) }
   }
   /* Check if the name is an allowed identifier. */
   status=check_macroid(name);
   if (status ) {
      if (status==1) {
         message nls("Invalid macro name")
      } else {
         message nls("This name has already been used.  Please select another name.")
      }
      return(1)
   }

   usermacs_filename=_macro_path(USERMACS_FILE:+_macro_ext)USERMACS_FILE:+_macro_ext;
   mark=_alloc_selection()
   if ( mark<0) {
      return(TOO_MANY_SELECTIONS_RC)
   }
   // Update old cursor info for buffer.
   _next_buffer 'h';_prev_buffer 'h';
   status=load_files('+u:32000 +c 'maybe_quote_filename(_macro_filename))
   if ( status ) {
      if (status==NEW_FILE_RC) {
         _delete_buffer();_quit_view();
      }
      _free_selection mark
      return(status)
   }
   top();
   search('^_command','ri@');
   defc_rc=rc;
   if ( ! defc_rc ) {
      get_line(line);
      modify=p_modify;
      linenum=p_line;
      _macro_cmdname=translate(name,'-','_');  // Store name for caller in global
      name=translate(name,'_','-');
      replace_line "_command "name"() name_info(','"flag_names")"
   }
   _select_line(mark);
   bottom();_select_line(mark);
   orig_mark=_duplicate_selection('');
   _show_selection(mark);
   old_buf_id=p_buf_id;
   qfilename=maybe_quote_filename(usermacs_filename);
   status=append(qfilename,'','-d')
   if ( status==NEW_FILE_RC || status==FILE_NOT_FOUND_RC ) {
      p_buf_id=old_buf_id
      top();_deselect;_select_line;bottom;_select_line();
      status=put(qfilename)
   }
   _show_selection orig_mark
   if ( ! defc_rc ) {
      p_modify=modify;
      p_line=linenum;
      replace_line(line);
   }
   _free_selection(mark);
   _delete_buffer();_quit_view();
   if ( ! status ) {
      status=st(qfilename);
      if ( ! status ) {
         unload(qfilename);
         status=_load(qfilename);
         _config_modify|=CFGMODIFY_USERMACS;
      }
      if ( ! status ) {
         message(nls('Macro command %s saved in file "%s"',name,usermacs_filename));
      }
   }
   return(status)

}
_command void pause_recording() name_info(','VSARG2_EDITORCTL)
{
   if ( !_defining_macro) {  /* not defining anthing? */
      message nls('Key strokes not being recorded')
      return;
   }
   if ( in_pause=='1' ) {
      in_pause=''
      get_view_id view_id
      activate_view _macro_view_id
      _macro('B');
      activate_view view_id
      sticky_message(nls("Recording macro"));
   } else {
      sticky_message(nls('Macro recording paused'));
      _macro_delete_line()
      _macro('E');
      in_pause=1
   }
}
static _str init_kbd_macro()
{
   /*_make_macro_filename()
   status=_open_temp_view(_macro_filename,_macro_view_id,orig_view_id);
   if (status) {
      orig_view_id=_create_temp_view(_macro_view_id);
   } else {
      _lbclear();
   } */

   get_view_id(window_group_view_id);
   activate_view(HIDDEN_VIEW_ID);
   _safe_hidden_window();
   _make_macro_filename()
   status=find_view(_macro_filename)
   if ( ! status ) {
      _lbclear();
   } else {
      clear_message
      status=load_files('+u:32000 +q +c +b '_macro_filename);
      if ( status ) {
         load_files('+u:32000 +c +t '_macro_filename);
         if ( rc ) {
            return(rc)
         }
      }
      p_buf_name=_macro_filename;_lbclear();
      p_buf_flags= THROW_AWAY_CHANGES|HIDE_BUFFER|KEEP_ON_QUIT
      select_edit_mode();
   }
   get_view_id _macro_view_id
   insert_line('#include "slick.sh"');
   insert_line("_command "DEFAULT_MACRO"() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)");
   insert_line('{');
   insert_line("_macro('R',1);");
   activate_view window_group_view_id
   return(0)

}
static void indent_kbd_macro()
{
   parse name_info(p_index) with . expand .;
   syntax_indent=p_SyntaxIndent;
   if ( syntax_indent<=0) {
      syntax_indent=3;
   }
   top();up();
   search('^_command','ri@');
   down();
   for (;;) {
      down();
      if ( rc ) {
         break
      }
      get_line(line);
      replace_line(reindent_line(line,syntax_indent));
   }
}
_str _macro_get_line()
{
   if ( _macro()) {
      get_view_id(view_id);
      activate_view(_macro_view_id);
      bottom();get_line(line);
      activate_view(view_id);
      return(line);
   }
   return('');
}
#if 0
void _macro_debug(var last_line,var prev_line,var Noflines)
{
   if ( _macro('s')) {
      get_view_id view_id
      activate_view _macro_view_id
      bottom;get_line last_line
      up;get_line prev_line;bottom;
      Noflines=p_Noflines;
      activate_view view_id
   }
}
#endif
void _macro_delete_line()
{
   if ( _macro() ) {
      get_view_id view_id
      activate_view _macro_view_id
      bottom;_delete_line
      activate_view view_id
   }

}
void _macro_append(string)
{
   if ( _macro() ) {
      get_view_id view_id
      activate_view _macro_view_id
      bottom;insert_line string
      activate_view view_id
   }

}
void _macro_replace_line(string)
{
   if ( _macro() ) {
      get_view_id view_id
      activate_view _macro_view_id
      bottom;replace_line string
      activate_view view_id
   }

}
void _macro_call(proc_name)
{
   if ( ! _macro() ) {
      return
   }
   string=proc_name'('
   for (i=2; i<=arg() ; ++i) {
      if ( i:==2 ) {
         string=string:+_quote(arg(i))
      } else {
         new_string=string','_quote(arg(i))
         if ( length(new_string)>79 ) {
            _macro_append(string',')
            string=substr('',1,length(proc_name)+1):+_quote(arg(i))
         } else {
            string=new_string
         }
      }
   }
   _macro_append(string');')

}
static _str gEscapeTab[]={
      "\\b","\\f","\\n","\\r","\\t","\\000","\\\"","\\\\"
     };
_str _quote(string)
{
   // Check if string has does not have and special characters
   special_chars="\b\f\n\r\t\0"
   if(verify(string,special_chars,'M')) {
      //chars2='bfnrt0';
      // Escape special chars with backslash
      i=1
      special_chars=special_chars:+'"\';
      for (;;) {
          j=verify(string,special_chars,'M',i)
          if ( ! j ) break;
          if (substr(string,j,1)=='"') {
             string=substr(string,1,j-1):+'\':+substr(string,j)
          } else {
             i=pos(substr(string,j,1),special_chars)
             string=substr(string,1,j-1):+gEscapeTab[i-1]:+substr(string,j+1)
#if 0
             parse dec2hex(_asc(substr(string,j,1))) with 'x' hex
             if (length(hex)<=1) {
                hex='0'hex
             }
             string=substr(string,1,j-1):+'\x'hex:+substr(string,j+1)
#endif
          }
          i=j+2
      }
      return('"'string'"')
   }
   /* Replace each single quote in string with 2 single quotes. */
   i=1
   for (;;) {
       j=pos("'",string,i)
       if ( ! j ) { break }
       string=substr(string,1,j-1):+"'":+substr(string,j)
       i=j+2
   }
   return("'"string"'")
}

static int _set_macro_enable_flags(_str macro_name,_str reqflag_names)
{
   if (macro_name=='') {
      return(0);
   }
   macro_name=translate(macro_name,"_","-");
   index=find_index(macro_name,COMMAND_TYPE);
   if (!index) {
      _message_box(nls("Macro %s does not exist or is not loaded.",macro_name));
      return(COMMAND_CANCELLED_RC);
   }
   module_name_index=index_callable(index);
   if (!module_name_index) {
      // This error is a very strange error
      return(0);
   }
   module_name=name_name(module_name_index);
   module_name=strip_filename(module_name, 'e'):+_macro_ext;
   get_view_id(start_view_id);
   filename=slick_path_search(module_name);
   status=_open_temp_view(filename,temp_view_id,orig_view_id);
   if (status) {
      activate_view(start_view_id);
      if (status==FILE_NOT_FOUND_RC) {
         _message_box(nls("File '%s' not found.\n\nMake sure your VSLICKMACROS path in vslick.ini is correct.\n\nIn addition, you may need to install macro source code.",filename));
      } else {
         _message_box(nls("Unable to open file %s\n\n"get_message(status), filename));
      }
      return(status);
   }
   select_edit_mode('e');
   top();
   status=e_proc_search(macro_name,1);
   if (status) {
      _message_box(nls("Macro %s could not be found.", macro_name));
      _delete_temp_view(temp_view_id);
      activate_view(start_view_id);
      return(status);
   }
   // Skip over command parameters
   status=search('(','xcs');
   if (status) {
      _message_box(nls("Unable to parse macro source"));
      _delete_temp_view(temp_view_id);
      activate_view(start_view_id);
      return(status);
   }
   status=find_matching_paren();
   if (status) {
      _message_box(nls("Unable to parse macro source"));
      _delete_temp_view(temp_view_id);
      activate_view(start_view_id);
      return(status);
   }
   right();
   save_pos(p);
   _clex_skip_blanks();

   // No name info?
   if (cur_word(junk)!='name_info') {
      restore_pos(p);
      _insert_text(" name_info(','"reqflag_names")");
   } else {
      right();_clex_skip_blanks();
      // Search for a comma or close paren
      // We can assume that if a comma is found, it must
      // be in a string
      status=search('[,)]','@rxc');
      if (status) {
         _message_box(nls("Unable to parse name_info source"));
         _delete_temp_view(temp_view_id);
         activate_view(start_view_id);
         return(status);
      }
      if (get_text()==')') {
         if (_clex_find(0,'g')==CFG_STRING) {
            _message_box(nls("Unable to parse name_info source"));
            _delete_temp_view(temp_view_id);
            activate_view(start_view_id);
            return(status);
         }           
         _insert_text(" ','"reqflag_names);
      } else if (get_text()==',') {
         if (_clex_find(0,'g')!=CFG_STRING) {
            _message_box(nls("Unable to parse name_info source"));
            _delete_temp_view(temp_view_id);
            activate_view(start_view_id);
            return(status);
         }
         status=_clex_find(STRING_CLEXFLAG,"N");
         if (status) {
            _message_box(nls("Unable to parse name_info source"));
            _delete_temp_view(temp_view_id);
            activate_view(start_view_id);
            return(status);
         }
         start_offset=point('s');
         status=search(')','xcs');
         if (status) {
            _message_box(nls("Unable to parse name_info source"));
            _delete_temp_view(temp_view_id);
            activate_view(start_view_id);
            return(status);
         }
         end_offset=point('s');
         goto_point(start_offset);
         Nofbytes=end_offset-start_offset;
         flag_names=get_text(Nofbytes);
         _delete_text(Nofbytes);
         preserve_names="";
         for (;;) {
            parse flag_names with name '|' flag_names;
            if (name=="") {
               break;
            }
            switch (name) {
            case "VSARG2_EDITORCTL":
            case "EDITORCTL_ARG2":
            case "VSARG2_REQUIRES_FILEMAN_MODE":
            case "VSARG2_READ_ONLY":
            case "READ_ONLY_ARG2":
            case "VSARG2_ICON":
            case "ICON_ARG2":
            case "VSARG2_REQUIRES_AB_SELECTION":
            case "VSARG2_REQUIRES_BLOCK_SELECTION":
            case "VSARG2_REQUIRES_CLIPBOARD":
            case "VSARG2_REQUIRES_SELECTION":
            case "VSARG2_REQUIRES_FILEMAN_MODE":
            case "VSARG2_REQUIRES_MDI_EDITORCTL":
            case "VSARG2_REQUIRES_TAGGING":
            //case "VSARG2_REQUIRES_MDI":
               break;
            default:
               if (preserve_names!="") {
                  preserve_names=preserve_names:+"|";
               }
               preserve_names=preserve_names:+name;
            }
         }
         if (preserve_names!="") {
            if (reqflag_names!="") {
               reqflag_names=reqflag_names:+"|";
            }
            reqflag_names=reqflag_names:+preserve_names;
         }
         _insert_text(reqflag_names);
      }
   }
   if (!status) {
      status=save("",SV_RETURNSTATUS);
      if (status) {
         _message_box(nls('Make sure you have write access to the file %s',filename));
      }
   }
   activate_view(temp_view_id);
   _delete_temp_view(temp_view_id);
   if (!status) {
      status=load(filename);
      _tbSetRefreshBy(VSTBREFRESHBY_SWITCHBUF);  // Just force a refresh
   }
   activate_view(start_view_id);
   return(status);
}
int _delete_macro(_str macro_name)
{
   if (macro_name=='') {
      return(0);
   }
   macro_name=translate(macro_name,"_","-");
   index=find_index(macro_name,COMMAND_TYPE);
   if (!index) {
      _message_box(nls("%s does not exist or is not loaded.",macro_name));
      return(COMMAND_CANCELLED_RC);
   }
   module_name_index=index_callable(index);
   if (!module_name_index) {
      delete_name(index);
      name=name_name(index);
      if (name!='') {
         _message_box(nls('Macro %s will still be listed because another macro calls this macro.  However, its code has been deleted.  Fix your other macros which call %s.',name,name));
      }
      return(0);
   }
   module_name=name_name(module_name_index);
   module_name=strip_filename(module_name, 'e'):+_macro_ext;
   get_view_id(start_view_id);
   filename=slick_path_search(module_name);
   file_already_loaded=0;
   if (filename!='') {
      file_already_loaded=_isfile_loaded(filename);
   }
   status=_open_temp_view(filename,temp_view_id,orig_view_id);
   if (status) {
      activate_view(start_view_id);
      _message_box(nls("%s could not be found.", macro_name));
      return(status);
   }
   select_edit_mode('e');
   top();
   status=e_proc_search(macro_name,1);
   if (status) {
      _message_box(nls("%s could not be found.", macro_name));
   }
   if (!status) {
      mark_id=_alloc_selection();
      status=select_proc('',mark_id);
      if (status) {
         _free_selection(mark_id);
         _message_box(nls("Unable to select macro function text"));
      }
      if (!status) {
         _delete_selection(mark_id);
         _free_selection(mark_id);
         status=_save_file(def_save_options);
         if (!status) {
            delete_name(index);
            name=name_name(index);
            if (name!='') {
               _message_box(nls('Macro %s will still be listed because another macro calls this macro.  However, its code has been deleted.  Fix your other macros which call %s.',name,name));
            }
         }
      }
   }
   _delete_temp_view(temp_view_id,!file_already_loaded);
   if (!status) {
      load(maybe_quote_filename(filename));
   }
   activate_view(start_view_id);
   return(status);
}
#define ENABLE_ONUPDATE  ctlok.p_user
#define MACRO_NAME  p_active_form.p_user
defeventtab _autoenable_form
void ctlok.lbutton_up()
{
   reqflag_names="";
   if (ctleditorctl.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_EDITORCTL";
   } 
   if (ctlrequires_fileman_mode.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_REQUIRES_FILEMAN_MODE";
   }
   if (ctlread_only.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_READ_ONLY";
   }
   if (ctlicon.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_ICON";
   }
   if (ctlrequires_ab_selection.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_REQUIRES_AB_SELECTION";
   }
   if (ctlrequires_block_selection.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_REQUIRES_BLOCK_SELECTION";
   }
   if (ctlrequires_clipboard.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_REQUIRES_CLIPBOARD";
   }
   if (ctlrequires_selection.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_REQUIRES_SELECTION";
   }
   if (ctlrequires_fileman_mode.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_REQUIRES_FILEMAN_MODE";
   }
   if (ctlrequires_mdi_editorctl.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_REQUIRES_MDI_EDITORCTL";
   }
   if (ctlrequires_tagging.p_value) {
      if (reqflag_names!='') reqflag_names=reqflag_names:+'|';
      reqflag_names=reqflag_names:+"VSARG2_REQUIRES_TAGGING";
   }
   status=_set_macro_enable_flags(MACRO_NAME,reqflag_names);
   if (!status) {
      p_active_form._delete_window();
   }
}
void ctlrequires_mdi_editorctl.lbutton_up()
{
   if (p_value) {
      ctlread_only.p_enabled=true;
      ctlicon.p_enabled=true;
      ctlrequires_ab_selection.p_enabled=ENABLE_ONUPDATE;
      ctlrequires_tagging.p_enabled=ENABLE_ONUPDATE;
      ctlrequires_fileman_mode.p_enabled=ENABLE_ONUPDATE;
      return;
   }
   ctlread_only.p_enabled=false;
   ctlread_only.p_value=0;
   ctlicon.p_enabled=false;
   ctlicon.p_value=0;
   ctlrequires_ab_selection.p_enabled=false;
   ctlrequires_ab_selection.p_value=0;
   ctlrequires_tagging.p_enabled=false;
   ctlrequires_tagging.p_value=0;
   ctlrequires_fileman_mode.p_enabled=false;
   ctlrequires_fileman_mode.p_value=0;
}
void ctlok.on_create(_str cmdname="mac1" /* something for testing */)
{
   MACRO_NAME=cmdname;
   index=find_index(cmdname,COMMAND_TYPE);
   if (!index) {
      p_active_form._delete_window();
      return;
   }
   p_active_form.p_caption=p_active_form.p_caption' 'cmdname;
   update_index=find_index('_OnUpdate_'cmdname,PROC_TYPE);
   if (update_index) {
      ENABLE_ONUPDATE=false;
      // If this is an _OnUpdate function, many of the
      // requires flags have no effect.  This 
      // may change in the future.
      ctlrequires_block_selection.p_enabled=false;
      ctlrequires_clipboard.p_enabled=false;
      ctlrequires_selection.p_enabled=false;
      ctlrequires_fileman_mode.p_enabled=false;
      ctlrequires_tagging.p_enabled=false;
   } else {
      ENABLE_ONUPDATE=true;
   }
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
      //ctlrequires_mdi_editorctl.p_visible=0;
      //ctlrequires_mdi_editorctl.p_value=0;
      //ctlrequires_editorctl.p_value=1;
      ctlicon.p_visible=0;
   }
   parse name_info(index) with ',' flags;
   if (!isinteger(flags)) flags=0;
   if (flags &VSARG2_EDITORCTL) {
      ctleditorctl.p_value=1;
   } 
   if (flags & VSARG2_REQUIRES_FILEMAN_MODE) {
      ctlrequires_fileman_mode.p_value=1;
   }
   if (flags & VSARG2_READ_ONLY) {
      ctlread_only.p_value=1;
   }
   if (flags & VSARG2_ICON) {
      ctlicon.p_value=1;
   }
   if (flags & VSARG2_REQUIRES_AB_SELECTION) {
      ctlrequires_ab_selection.p_value=1;
   }
   if (flags & VSARG2_REQUIRES_BLOCK_SELECTION) {
      ctlrequires_block_selection.p_value=1;
   }
   if (flags & VSARG2_REQUIRES_CLIPBOARD) {
      ctlrequires_clipboard.p_value=1;
   }
   if (flags & VSARG2_REQUIRES_SELECTION) {
      ctlrequires_selection.p_value=1;
   }
   if (flags & VSARG2_REQUIRES_FILEMAN_MODE) {
      ctlrequires_fileman_mode.p_value=1;
   }
   if (flags & VSARG2_REQUIRES_TAGGING) {
      ctlrequires_tagging.p_value=1;
   }
   if (flags & VSARG2_REQUIRES_MDI_EDITORCTL) {
      ctlrequires_mdi_editorctl.p_value=1;
   } else {
      ctlrequires_mdi_editorctl.call_event(ctlrequires_mdi_editorctl,LBUTTON_UP);
   }
}
