/*
$VerboseHistory: restore.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:56a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:55a
 * Comment:
 * Added support for editor control.
 * Change message box to display question mark icon.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'
static int window_config_id;
static _str clean_up_buf_ids;

#define READONLY_ON 0x1
#define READONLY_SET_BY_USER 0x2
_str _no_resize

_str restore_path(...)
{
   path=get_env(_SLICKRESTORE)
   if ( rc ) {
      path=_config_path('n')
#if !__UNIX__
      if (path=='') {
         path=editor_name('p');
      }
#endif
      /* If directory must exist and it does not.  */
      if ( arg(1) && ! isdirectory(path) ) {
         path=''
      }
   }
   if ( path!='' && last_char(path):!=FILESEP ) {
      path=path:+FILESEP
   }
   return(path)

}
/*
  Read in the window configuration file and create the same window/buffer
  size and positions.

    arg(1)     _str restore_option (Optional).  String of one or more
               of the following option letters.

                 N indicates restore without restore files.
                 R indicates restore everything.
                 G Just restore global info because we already
                   restore other information from the project file.
                 I Restoring from editor invocation.

    arg(2)     _str view_id (Optional).  View id which correndponds
               to restore file data.  Cursor should be at first
               line of restore information.

  To auto restore your own data define a global (not static)
  function that starts with "_sr_" or "_srg_".  The return type
  of your function is int.  Return 0 if successful.

  When SAVING restore information your function is called as follows:

    _sr_mymarker();    The function must use LOWER CASE letters only.
                       Sorry, we needed this for backward compatibility.
                       Your function should use insert_line(...) to
                       insert a header line as follows:

                         mymarker:  NoflinesWhichFollowThisLine [UserData]

                       mymarker: Must be the same name as the function
                       after the "_sr_".  UserData is optional.

  Note:  If you want your restore information stored globally
         (Not per project), prefix your function name with
         "_srg_" instead of "_sr_".

  When RESTORING, your function is called as follows

    _sr_mymarker(_str restore_option,_str LineAfterColon,
                boolean RestoringFromInvocation);

       restore_option     "N" or "R".  The N option indicates that files
                          are not being restored.  This occurs when the
                          user specifies a file argument from the command
                          line.
       LineAfterColon     Header line from auto restore buffer not including
                          leading mymarker: data.

       RestoringFromInvocation   TRUE if restoring from an editor invocation.
                                 You may not want you information changed
                                 when the user switches projects.

*/
static boolean gHitToolbarsSection;
static boolean gHitGlobalSection;

_command restore(_str options="",_str alternate_view_id="")
{
   RestoringFromInvocation=false;
   restore_options=upcase(options);
   if (pos("I",restore_options)) {
      RestoringFromInvocation=true;
   }
   if ((_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
      _mdi._ShowWindow();
   }
   if (alternate_view_id!='') {
      clean_up_buf_ids='';
      activate_view((int)alternate_view_id);
      alternate_buf_id=p_buf_id;
   } else {
      activate_view(HIDDEN_VIEW_ID);
      restore_filename=editor_name("r");
      if (restore_filename==''){
         restore_filename=editor_name('p'):+_WINDOW_CONFIG_FILE;
         if (restore_filename==''){
            return(0);
         }
      }
      /* p_window_id=_mdi._edit_window() */
      status=load_files("+q "maybe_quote_filename(restore_filename));
      if ( status ) {
         if ( status==NEW_FILE_RC ) {
            _delete_buffer();
         }
         tbResetAll();
         return(1)
      }
      clean_up_buf_ids=p_buf_id;
   }
   gHitToolbarsSection=false;
   gHitGlobalSection=false;
   status=restore2(options);
   if (!gHitToolbarsSection && 
          (  gHitGlobalSection || 
             (alternate_view_id=="" && 
               file_eq(strip_filename(restore_filename,'P'),_WINDOW_CONFIG_FILE)
              ) 
          )
      ) {
      tbResetAll();
   }
   if (alternate_view_id!='') {
      get_view_id view_id
      activate_view((int) alternate_view_id);
      p_buf_id=alternate_buf_id;
      activate_view view_id;
   }
   return(status);
}
static int restore2(_str restore_options)
{
   get_view_id(view_id);
   load_files("+c +v "view_id);
   get_view_id(window_config_id);

   first_window=0;
   do_one_window=0;mdi_state="";
   JustRestoreGlobalInfo=false;
   RestoringFromInvocation=false;
   restore_options=upcase(restore_options);
   if (pos("I",restore_options)) {
      restore_options=stranslate(restore_options,"","I");
      RestoringFromInvocation=true;
   }
   // IF we already restored from project and just want to restore
   //    global auto restore info.
   if (pos("G",restore_options)) {
      restore_options=stranslate(restore_options,"","G");
      JustRestoreGlobalInfo=true;
      restore_options="N";
   }
   callback_prefix="_sr_";
   screen_size_line="";
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_SAVERESTORE_EDIT_WINDOWS)) {
      restore_options='N';
   }
   for (;;) {
      get_line(line);
      parse line with rtype line;

      //messageNwait('restore_options='restore_options' ln='p_line' rtype=<'rtype'> 'line);
      // IF we are restoring files
      if ( restore_options!='N' ) {
         if ( rtype == 'WINDOW:' ) {
            status=down(); get_line(buf);
            parse buf with type bufferline;
            if ( ! status && type=='BUFFER:' ) {
               down();get_line(v);
               activate_view(view_id);
               parse v with . viewline;
               status=process_window(line,bufferline,viewline,first_window);
            } else {
               if ( ! status ) up();
               if (_no_child_windows() && _Nofbuffers()<2) {
                  status=0;
               } else {
                  activate_view(view_id);
                  status=process_window(line,"","",first_window);
               }
            }
            if ( status ) {
               clean_up();
               if ( status!=NEW_FILE_RC ) {
                  _message_box('Restore: 'get_message(status))
               }
               return(status);
            }
            get_view_id(view_id);
         } else if ( rtype == 'BUFFER:' ) {
            down();
            get_line(bi_info);
            parse bi_info with ntype bi_info;
            down();
            get_line(viewline);
            parse viewline with ntype viewline;
            activate_view(view_id);
            status = process_buffer(line,'',bi_info);
            if ( status ) {
               call clean_up()
               if ( status!=NEW_FILE_RC ) {
                  _message_box('Restore: 'get_message(status))
               }
               return(status)
            }
            process_view(viewline);
         } else if ( rtype=='MARK:' ) {
            restore_select_data();
         }
      }
      if ( rtype=='RETRIEVE:' ) {
         restore_retrieve_data(line);
      } else if ( rtype=="DIALOGS:") {
         _xsrg_dialogs('R',line,RestoringFromInvocation);
      } else if ( rtype=="GSTART:") {
         gHitGlobalSection=true;
         callback_prefix="_srg_";
      } else if (rtype=="GEND:") {
         callback_prefix="_sr_";
         if (JustRestoreGlobalInfo) {
            //messageNwait("restore2: JustRestoreGlobalInfo="JustRestoreGlobalInfo);
            break;
         }
      } else if ( rtype=='SCREEN:' && !JustRestoreGlobalInfo) {
         screen_size_line=line;
      } else if ( rtype=='CWD:' && (def_restore_flags & RF_CWD) && 
                  (_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_SAVERESTORE_CWD)
                  ) {
         if (!JustRestoreGlobalInfo) {
            //chdir(line,1);
            // Don't have to call cd here, but we must do call_list
            // and it make sense to do process_cd
            cd(maybe_quote_filename(line));
         }
      }
      if (rtype=='TOOLBARS3:') {
         gHitToolbarsSection=true;
      }
      if ( ! pos(rtype,'SCREEN:GSTART:GEND:CWD:RETRIEVE:DIALOGS:MARK:WINDOW:BUFFER:BI:VIEW:') ) {
         //_mdi.p_visible=1;messageNwait("rtype="rtype);
         name=callback_prefix:+strip(lowcase(rtype),'',':');
         index=find_index(name,PROC_TYPE);
         // IF there is a callable function
         if ( index_callable(index)) {
            a1=restore_options;
            if ( a1=="" ) {
               a1="R";
            }
            status=call_index(a1,line,RestoringFromInvocation,index)
            if ( status ) {
               clean_up();
               return(status);
            }
         } else {
            /* Skip over lines that can't be processed. */
            parse line with count .;
            down(count);
         }
      }
      activate_view(window_config_id);
      if ( down()) {
         break;
      }
   }
   //messageNwait('after loop');
   activate_view(view_id);
   clean_up();

   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_SAVERESTORE_EDIT_WINDOWS)) {
   } else {
      if (screen_size_line!="") {
         set_screen_size(screen_size_line,do_one_window,mdi_state,RestoringFromInvocation);
      }
   }
   // IF we are restoring files AND MDI screen size changed AND
   //    we are not in one file per window mode
   if (restore_options!='N' && do_one_window && def_one_file=='') {
      one_window();
   }
#if 0
   if (mdi_state!='') {
      // Unfortunately change the state to iconized does not work.
      if (mdi_state!='I') {
         _mdi.p_window_state=mdi_state
      }
   }
#endif
   old_line=line;
   return(0)
}
static void restore_select_data()
{
   get_line(line);
   parse line with line_type 'MT='mt'BN='buf_name'SL='start_line'SC='start_col'LL='last_line'EC='end_col;
   get_view_id(this_buf);
   status=load_files('+c +b 'strip(strip(buf_name),'B','"'));
   if ( status) {
      clear_message();
      return;
   }
   _deselect();
   _goto_rpoint(start_line);p_col=start_col;call select_it(mt,'');
   _goto_rpoint(last_line);p_col=end_col;call select_it(mt,'');
   _quit_view();
   activate_view(this_buf);

}
static _str process_window(line,bufferline,viewline,var first_window)
{
   parse line with x y width height icon_x icon_y state 'WF=' wf 'WT=' wt '"' font_info '"' .
   parse font_info with font_name "," font_size "," font_flags","charset;
   if (!isinteger(charset)) {
      charset=VSCHARSET_DEFAULT;
   }
   get_view_id view_id
   if ( first_window ) {  /* Use first window? */
      status=process_buffer(bufferline,'');
   } else {
      _no_resize=1
      status=process_buffer(bufferline,'+i:'x' 'y' 'width' 'height' 'state)
      _no_resize=''
   }
   /* messageNwait('status='status) */
   first_window=0
   if ( status ) {
      return(status)
   }
   p_old_x=x;p_old_y=y;p_old_width=width;p_old_height=height
   if (icon_x>=0) {
      _no_resize=1
      _MDIChildSetWindow(x,y,width,height,'N',icon_x,icon_y);
      _no_resize=''
   }
   /* p_window_state=state */
   p_window_flags=wf;
   p_tile_id=wt;

   //Process Font Information
   p_redraw=0;
   p_font_name = font_name;
   p_font_size = font_size;
   p_font_bold = font_flags & F_BOLD;
   p_font_italic = font_flags & F_ITALIC;
   p_font_strike_thru = font_flags & F_STRIKE_THRU;
   p_font_underline = font_flags & F_UNDERLINE;
   p_font_charset= charset;
   p_redraw=1;
   //End Process Font Information

   return(process_view(viewline))
}
static _str process_view(line)
{
   if ( line!='' && p_buf_name!='.process') {
      parse line with 'LN=' ln ' CL=' cl ' LE=' le ' CX=' cx ' CY=' cy ' WI=' wi ' BI=' bi ' HT='hex_toppage' HN='hex_nibble' HF='hex_field' HC='hex_Nofcols;
      cy=cy*p_font_height;
      cx=cx*p_font_width;
      _goto_rpoint(ln)
      if (hex_toppage!='') {
         p_hex_toppage=hex_toppage;
         p_hex_nibble=hex_nibble;p_hex_field=hex_field;
         p_hex_Nofcols=hex_Nofcols;
      }
      /* if (pos('test.e',p_buf_name)) {trace} */
      set_scroll_pos le,cy
      /* message 'buf_name='p_buf_name' cy='cy' p_cursor_y='p_cursor_y' p_ch='p_client_height' font_name='p_font_name;get_event('r'); */
      p_col=cl
   }
   return(0)

}
static _str process_buffer(buf_info,window_options)
{
#if 0
   parse buf_info with 'MN=' mode_name ' BN=' rest;
   // IF mode name not present (old format )
   if (rest=='') {
      parse buf_info with 'BN=' rest;
   }
#endif
   parse buf_info with 'BN=' rest;
   bn=parse_file(rest);
   DocumentName=strip(parse_file(rest),'B','"');
   buf_width='';
   if ( arg(3)!='' ) {
      parse arg(3) with 'MA=' margins ' TABS=' tabs ' WWS=' word_wrap_style ' IWT=' indent_with_tabs 'ST=' ShowSpecialChars 'IN=' indent_style 'BW=' buf_width 'US=' undo_steps 'RO='readonly_flags 'SE=' showeof 'SN='shownlchars 'BIN='binary 'MN='mode_name"\t" 'HM='hex_mode' MF='ModifyFlags .;
   }
   // We don't want to use the edit command with +v because we don't want
   // switch buf to be called.  This screwed up the HP softbench support because
   // quit() must be called for every switchbuf and not _delete_buffer
   use_edit_command=1;
   if ( bn =='' ) {
      use_edit_command=0;
      if ( window_options=='' ) {
         bn='+v'
      } else {
         bn='+v 'window_config_id;
      }
   }
   if ( buf_width==0 || buf_width=='' ) {
      buf_width='';
   } else {
      buf_width='+'buf_width
   }
   /* messageNwait('window_options='window_options); */
   /* messageNwait('bn='bn); */
   if (strip(bn,'B','"')=='.process') {
      status=load_files('-w +q 'window_options' +b .process');
      if (status) {
         /* messageNwait('edit window_options='window_options); */
         status=edit('-w 'window_options " "buf_width " +t",EDIT_NOUNICONIZE,0)
         if (!status) {
            p_buf_name='.process';
            old_one_file=def_one_file;def_one_file='';
            start_process(true,true,false,false /* do not uniconize window*/);
            def_one_file=old_one_file;
         }
         /* messageNwait('h2'); */
      }
   } else {
      if (use_edit_command) {
         options='';
         if (arg(3)!='') {
            if (strip(binary))  {
               options=options' +lb';
            } else {
               if (strip(shownlchars)) options=options' +ln';
               if (strip(showeof)) options=options' +le';
            }
         }
         status=edit('-w 'window_options" "options" "buf_width " "bn,EDIT_NOUNICONIZE,0)
      } else {
         status=load_files('-w 'window_options " "buf_width " "bn);
      }
   }
   if ( status ) {
      if ( status!=NEW_FILE_RC && status!=FILE_NOT_FOUND_RC && status!=PATH_NOT_FOUND_RC) {
         return(status)
      }
      result=_message_box("Restore:  ":+
                           nls("File '%s' not found.\n\nContinue?",bn),'',MB_YESNOCANCEL|MB_ICONQUESTION)
      if (status==NEW_FILE_RC) {
         clean_up_buf_ids=clean_up_buf_ids" "p_buf_id
      }
      if (result!=IDYES) {
         return(status)
      }
   } else {
      if (DocumentName!="") {
         docname(DocumentName);
      }
      if (arg(3)!='') {
         // IF we are in readonly mode
         readonly_flags=strip(readonly_flags);
         if (!isinteger(readonly_flags)) readonly_flags=0;
         if (strip(bn,'B','"')!='.process') {
            _restore_filepos(p_buf_name);
         }
         if( readonly_flags & READONLY_ON) {
            read_only_mode();
            p_readonly_set_by_user=(readonly_flags & READONLY_SET_BY_USER);
            if (def_actapp&ACTAPP_AUTOREADONLY) maybe_set_readonly();
         // IF have mode name
         } else if (mode_name!='') {
            // Get extension from mode name
            ext=_bufnameNmode2ext(p_buf_name,mode_name);
            select_edit_mode(ext);
            if (def_actapp&ACTAPP_AUTOREADONLY) maybe_set_readonly();
#if 0
            // Get extension from mode name
            ext=_modename2ext(mode_name,junk);
            if (ext=='') {
               if (_modename_eq(mode_name,'Fundamental')) {
                  fundamental_mode();
               }
            } else {
               select_edit_mode(ext);
            }
#endif
         }
      }
   }
#if 0
   switch (lowcase(mode_name)) {
   case 'read only':
      read_only_mode();
   }
#endif
   if ( arg(3)!='' ) {
      /* call select_edit_mode() */
      p_margins=margins;
      p_tabs=tabs;
      p_word_wrap_style=word_wrap_style;
      p_indent_with_tabs=indent_with_tabs;
      p_ShowSpecialChars=ShowSpecialChars;
      p_indent_style=indent_style;
      p_undo_steps=undo_steps;
      if (hex_mode!='') {
         if (!p_hex_mode && hex_mode) {
            hex();
         } else {
            p_hex_mode=hex_mode;
         }
      }
      if (isinteger(ModifyFlags)) {
         p_ModifyFlags|=(ModifyFlags& MODIFYFLAG_FTP_NEED_TO_SAVE);
      }
   }
   return(0)


}
static void clean_up()
{
   get_view_id(orig_view_id);
   activate_view(window_config_id);
   _quit_view();
   for (;;) {
      parse clean_up_buf_ids with id clean_up_buf_ids;
      if ( id=='' ) {
         break
      }
      load_files('+c +bi 'id);
      /*
          Here we are using close_buffer() instead of _delete_buffer()
          to fix a bug in our X windows HP SoftBench support.  Note 
          that it is possible for close_buffer() to be called here
          where the buffer was not created by calling the edit()
          command.
      */
      if (last_buffer()) {
         //_delete_buffer
         //_delete_edit_windows()
         close_buffer('',
                      0 /* Allow delete_buffer on hidden window. */);
         break;
      } else {
         //_delete_buffer();
         close_buffer('',
                      0 /* Allow delete_buffer on hidden window. */);
         _quit_view();
      }
   }
   p_window_id=_mdi._edit_window();
}
boolean _project_save_restore_done;
//------------------------------------------------------------------------
_command save_window_config()
{
   _save_all_filepos();
   get_view_id orig_view_id
   p_window_id=_mdi.p_child;
   get_view_id home_view
   activate_view(HIDDEN_VIEW_ID);
   rpath=restore_path(0);

   project_info_only=(lowcase(arg(2))=='p');
   alternate_view_id=arg(3);
   check_exists=arg(4);
   exiting_editor=arg(5)!="";

   if (alternate_view_id!='') {
      activate_view(alternate_view_id);
   } else {
      status=load_files('+c +t 'maybe_quote_filename(rpath:+_WINDOW_CONFIG_FILE));
      if ( status ) {
         message(get_message(status));
         return(status);
      }
      top();
   }
   if ((_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_MDI_WINDOW)) {
      _mdi._get_window(mdi_x,mdi_y,mdi_width,mdi_height,'N',mdi_ix,mdi_iy);
      window_state=_mdi.p_window_state;
      if (window_state=='I'){
         window_state='N';
      }
      _mdi._MDIClientGetWindow(junk,junk,mdiclient_width,mdiclient_height);
   } else {
      mdi_x=0;mdi_y=0;mdi_width=0;mdi_height=0;mdi_ix=0;mdi_iy=0;
      mdiclient_width=0;mdiclient_height=0;
      window_state='N';
   }
   // SCREEN: must be first item in vrestore.slk because vs executable
   // expects this line to be first.  This is because vs creates
   // the MDI window visible.  This is likely to change in the future.
   screen_line='SCREEN: '_screen_width()' '_screen_height()' 'mdi_x' 'mdi_y' 'mdi_width:+
                   ' 'mdi_height' 'mdi_ix' 'mdi_iy' 'window_state' 0 0 0 0 'mdiclient_width' 'mdiclient_height;
   get_view_id(restore_view_id);
   buf_id=p_buf_id;
   if (alternate_view_id!='') {
      insert_line(screen_line);
   } else {
      replace_line(screen_line);
   }
   insert_line("CWD: "getcwd());
   if (!project_info_only) {
      insert_line("GSTART:");
      save_pos(gstart);
      // Add the retrieve information.
      write_retrieve_data(restore_view_id);
      /* call external global save/restore functions. */
      _project_save_restore_done=0;
      _srg_project();
      _project_save_restore_done=1;
      call_list('_srg_');
      _project_save_restore_done=0;

      _save_pos2(p);
      if (exiting_editor) {
         if (find_index('_tbexiting_editor',PROC_TYPE)) {
            _tbexiting_editor();
         }
      }

      restore_pos(gstart);
      _xsrg_dialogs();
      _restore_pos2(p);
      insert_line("GEND:");
   }


   /* For each buffer write non-active view information. */
   activate_view(HIDDEN_VIEW_ID);
   status=load_files("+m +v "restore_view_id);
   if ( status ) {
      message(get_message(status));
      _delete_buffer();
      return(status)
   }
   get_view_id(restore_view_id2);
   not_on_disk_list="";
   restore_process=(def_restore_flags & RF_PROCESS);
   for (;;) {
      _next_buffer('H');
      if ( p_buf_id==buf_id ) {
         break;
      }
      parse p_buf_name with word rest;
      if (!(p_buf_flags & HIDE_BUFFER) && 
          (
            (_need_to_save() && p_buf_name != '') || 
            (p_buf_name=='.process' && restore_process)
          )) {
         if ( (!check_exists || file_match(' -p 'maybe_quote_filename(p_buf_name),1)!='') ||
              (p_buf_name=='.process' && restore_process)) {
            write_buffer_data(restore_view_id,1);
            write_view_data(restore_view_id);
         } else {
            not_on_disk_list=not_on_disk_list' 'p_buf_id;
         }
      }
   }
   /* for every window enter window, buffer, and view info */
   activate_view(home_view);
#if 1
   if (!_no_child_windows()) {
      first_window_id=p_window_id;
      for (;;) {
         _next_window("HF");
         /* write out the window's data */
         if ( p_window_id!=HIDDEN_WINDOW_ID ) {
            if (def_one_file=='') write_window_data(restore_view_id);
            /* for every view */
            /* write out the buffer and view data */
            parse p_buf_name with word rest
            if ( (!_modename_eq(p_mode_name,'FILEMAN') && word != 'Help' &&
               ! (p_buf_flags &THROW_AWAY_CHANGES) && p_buf_name != '' &&
               p_buf_name!='.main' && ! pos(' 'p_buf_id' ',not_on_disk_list' ')
                 ) || (p_buf_name=='.process' && restore_process)
                   ) {
               if (def_one_file!='') write_window_data(restore_view_id);
               write_buffer_data(restore_view_id)
               write_view_data(restore_view_id)
            }
         }
         if ( p_window_id==first_window_id ) {
            break
         }
      }
   }
#endif
   /* save and exit the status file */
   activate_view(restore_view_id);
   write_select_data();
   //IF we are save data to global auto restore file.
   /* call external save/restore functions. */
   call_list('-sr-');
   status=0;
   if (alternate_view_id=='') {
      if ( rpath!='' && rpath==_config_path() ) {
         status=_create_config_path();
      }
      if ( ! status ) {
         status=_save_file('+o');
         /* Don't care if get error. */
         status=0;
      }
      _delete_buffer();_quit_view();
      //activate_view home_view
      if ( status<0 ) {
         message(get_message(status));
      }
   }
   activate_view(orig_view_id);
   return(status);

}
static void write_select_data()
{
   if ( _select_type()!='' && _select_type('','S')!='C' ) {
      get_view_id this_buf
      _get_selinfo start_col,end_col,buf_id,'',buf_name
      status=load_files("+c +b "buf_name);
      if ( status ) {
         clear_message();
      } else {
         _begin_select;start_line=_get_rpoint();
         _end_select;last_line=_get_rpoint();
         _quit_view();
         activate_view(this_buf);
         insert_line("MARK: MT="_select_type()' BN="'buf_name'" SL='start_line' SC='start_col' LL='last_line' EC='end_col);
      }
   }
}
static void write_window_data(buf)
{
   get_view_id(this_buf);
   _MDIChildGetWindow(x,y,width,height,'N',icon_x,icon_y);
   out='WINDOW: '
   font_info = '"':+p_font_name:+",":+p_font_size",":+_font_props2flags()",":+p_font_charset:+'"';
   out=out:+x' 'y' 'width:+' 'height' 'icon_x' 'icon_y' 'p_window_state' ':+
       ' WF='p_window_flags:+' WT='p_tile_id' ' font_info;
   activate_view(buf);
   insert_line(out);
   activate_view(this_buf);
}
static void write_view_data(buf)
{
   get_view_id(this_buf);
   out="VIEW: ";
   cx=p_cursor_x;cy=p_cursor_y;
   cy=cy intdiv p_font_height;
   cx=cx intdiv p_font_width;
   out=out:+'LN='_get_rpoint()' CL='p_col' LE='p_left_edge' CX='cx:+
       ' CY='cy' WI='p_window_id' BI='p_buf_id' HT='p_hex_toppage' HN='p_hex_nibble' HF='p_hex_field' HC='p_hex_Nofcols
   activate_view(buf);
   insert_line(out);
   activate_view(this_buf);
}
static void write_buffer_data(buf)
{
   get_view_id(this_buf);
   if (p_DocumentName!="") {
      out='BUFFER: BN="'p_buf_name'"' '"'p_DocumentName'"';
   } else {
      out='BUFFER: BN="'p_buf_name'"';
   }
   readonly_flags=(p_readonly_mode)?READONLY_ON:0;
   if (p_readonly_set_by_user) {
      readonly_flags|=READONLY_SET_BY_USER;
   }
   out2='BI: MA='p_margins:+' TABS='p_tabs:+' WWS='p_word_wrap_style:+' IWT='p_indent_with_tabs:+' ST='p_ShowSpecialChars:+' IN='p_indent_style' BW='p_buf_width:+' US='p_undo_steps' RO='readonly_flags' SE=' p_showeof' SN=0 BIN='p_binary' MN='p_mode_name"\tHM="p_hex_mode" MF="p_ModifyFlags;
   activate_view(buf);
   insert_line(out);
   if ( arg(2)!='' ) {  /* Insert buffer info? */
      insert_line(out2);
   }
   activate_view(this_buf);
}
static void write_retrieve_data(view_id)
{
   activate_view(RETRIEVE_VIEW_ID);
   mark=_alloc_selection();
   if ( mark<0) {
      return;
   }
   activate_view(RETRIEVE_VIEW_ID);
   top();
   // Check for embedded carriage return or line feed
   // Can't save retrieve info if there is an embedded cr or lf
   if (_embedded_crlf()) {
      bottom();
      activate_view(view_id);
      _free_selection(mark);
      return;
   }
   _select_line(mark);
   bottom();
   _select_line(mark);
   Noflines=count_lines_in_selection(mark);
   activate_view(view_id);
   insert_line("RETRIEVE: "Noflines);
   _copy_to_cursor(mark);
   bottom();
   _free_selection(mark);
}
static void restore_retrieve_data(Noflines)
{
   if ( ! Noflines ) {
      return;
   }
   mark=_alloc_selection()
   if ( mark<0) {
      down Noflines
      return;
   }
   get_view_id view_id
   down
   _select_line mark
   down Noflines-1
   _select_line mark
   activate_view RETRIEVE_VIEW_ID
   if ( !_line_length()) {
      _delete_line
   }
   _copy_to_cursor mark
   _free_selection(mark);
   bottom
   activate_view view_id
}
static void set_screen_size(line,var do_one_window,var mdi_state,boolean RestoreFromInvocation)
{
   parse line with width height mdi_x mdi_y mdi_width mdi_height mdi_ix mdi_iy mdi_state ifl dft ifr ufb client_width client_height
   /* If screen size different */
   if ( _screen_height()!=height || _screen_width()!=width ) {
      do_one_window=1;
   }
#if 0
   if ( ifl<_mdi.p_in_from_left || dft<_mdi.p_down_from_top || ifr<_mdi.p_in_from_right || ufb<_mdi.p_up_from_bottom) {
      do_one_window=1
   }
#endif
   _mdi._MDIClientGetWindow(junk,junk,mdiclient_width,mdiclient_height);
   if ( client_width=="" || client_width>mdiclient_width || client_height>mdiclient_height) {
      //do_one_window=1;
   }
   if (!RestoreFromInvocation) {
      // Don't want to restore position of icon.  Let Windows determine position
      // so that the icon does not overlap an existing icon.
      if (mdi_state!='M' && mdi_state!='N') {
         mdi_state='N';
      }
      if (mdi_width && mdi_height) {
         _mdi._move_window(mdi_x,mdi_y,mdi_width,mdi_height,"N" /*mdi_state*/);
         _mdi.p_window_state=mdi_state;
      }
   }
}

static void _goto_rpoint(line)
{
   line=strip(line);
   if ( substr(line,1,1)=='.' ) {
      p=substr(line,2)
      status=_GoToROffset(p);
      if ( status ) {
         clear_message();
         if ( p>0 ) {
            bottom();
         }
      }
      _begin_line();
   } else {
      p_RLine=line;
   }
}
static _str _get_rpoint()
{
   return('.'_QROffset());
}

