/*
  To install this macro, perform use
  the Load module dialog box ("Macro", "Load Module...").
  

*/
#include 'slick.sh'

#define EXTENSION 'rul'
#define MODE_NAME 'InstallScript'
#define VLXLEXERNAME  'InstallScript'
#define IDENTIFIER_CHARS  'A-Za-z0-9_'

#define MAXSKIPPREPROCESSING   100

boolean def_rul_smartpaste=1;

/* 
 cache name and seek position of last function
 we got function help on (for performance)
*/
static _str gLastContext_FunctionName;
static int gLastContext_FunctionOffset;

/* 
 regular expressions and strings
 used for picking out Rul keywords
*/
#define RUL_COMMON_END_OF_STATEMENT_RE 'abort|begin|case|default|downto|else|elseif|end|endfor|endif|endprogram|endswitch|endwhile|exit|for|function|goto|if|program|prototype|repeat|return|step|switch|then|to|typedef|until|while'
#define RUL_NOT_FUNCTION_WORDS  ' abort case downto elseif exit for goto if return step switch to until while '

defload()
{
   setup_info='MN='MODE_NAME',TABS=+4,MA=1 74 1,':+
               'KEYTAB=rul-keys,WW=1,IWT=0,ST=0,IN=2,WC='IDENTIFIER_CHARS',LN='VLXLEXERNAME',CF=1,';
   compile_info='';
   // The first two number are syntax_indent amount and expand on/off
   // the restore of 
   syntax_info='4 1 ':+   // <Syntax indent amount>  <expansion on/off>
               '1 1 0 0';   // <min abbrev> <not used> <begin/end style> <indent-case>
   be_info='';
   create_ext(kt_index,EXTENSION,'',MODE_NAME,setup_info,compile_info,
              syntax_info,be_info);
   set_eventtab_index(kt_index,event2index(ENTER),find_index('rul-enter',COMMAND_TYPE));
   set_eventtab_index(kt_index,event2index(' '),find_index('rul-space',COMMAND_TYPE));

}

/* 
   keymaps for Rul language to trigger
   auto function help or auto code help
*/
defeventtab rul_keys
def ';'=rul_semi
def '('=auto_functionhelp_key
def '.'=auto_codehelp_key
def '>'=auto_codehelp_key
def 'C- '=codehelp_complete

_command rul_mode()  name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode('rul');
}
_command void rul_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) ||
         rul_expand_enter(p_SyntaxIndent) ) {
      call_root_key(ENTER);
   } else if (_argument=='') {
      _undo('S');
   }

}
_command void rul_semi() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL)
{
   // check if the word at the cursor is end
   cfg=_clex_find(0,'g');
   get_line(line);
   if (cfg==CFG_COMMENT || cfg==CFG_STRING || lowcase(line)!='end') {
      keyin(';');
      return;
   }
   save_pos(orig_pos);
   up();_end_line();
   col=_rul_find_block_col(block_info);
   restore_pos(orig_pos);
   if (col) {
      replace_line(indent_string(col-1)strip(line)';');_end_line();
   } else {
      keyin(';');
   }

}
_command rul_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   was_space=(last_event():==' ');
   parse name_info(_edit_window().p_index) with . expand . . be_style . ;
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      rul_expand_space(p_SyntaxIndent) ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ');
         } else {
            keyin(' ');
         }
      }
   } else if (_argument=='') {
      _undo('S');
   }
}

   static _str space_words[]={
      'if','while','case','switch','default','repeat','return',
      'end','else','elseif','for','program','function','prototype','typedef',
      'begin'
   };



/*
    Returns true if nothing is done.
*/
static boolean rul_expand_space(int syntax_indent)
{
   status=0;
   get_line(orig_line);
   line=strip(orig_line,'T');
   orig_word=strip(line);
   if ( p_col!=text_col(line)+1 ) {
      return(1);
   }
   if_special_case=0;
   aliasfilename='';
   word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename);
   if (aliasfilename!=''&&word!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   if ( word=='') return(1);

   line=substr(line,1,length(line)-length(orig_word)):+word;
   width=text_col(line,length(line)-length(word)+1,'i')-1;
   orig_word=word;
   word=lowcase(word);
   if ( word=='if' ) {
      replace_line(line:+'  then');
      insert_line(indent_string(width)'endif;');
      up();_end_line();p_col-=5;
   } else if (word=='while') {
      replace_line(line:+' ()');
      insert_line(indent_string(width)'endwhile;');
      up();_end_line();p_col-=1;
   } else if (word=='case') {
      parse name_info(_edit_window().p_index) with . expand . . be_style indent_case .;
      save_pos(p2);
      up();_end_line();
      col=_rul_find_block_col(block_info);
      restore_pos(p2);
      if (col) {
         if (indent_case) {
            col+=syntax_indent;
         }
         replace_line(indent_string(col-1)orig_word' :');
      } else {
         replace_line(line:+' :');
      }
      _end_line();--p_col;
   } else if (word=='switch') {
      replace_line(line:+' ()');
      insert_line(indent_string(width)'endswitch;');
      up();_end_line();p_col-=1;
   } else if (word=='default') {
      replace_line(line:+':');
      _end_line();
   } else if (word=='repeat') {
      replace_line(line);
      //insert_line('');
      insert_line(indent_string(width)'until ();');
      up();_end_line();++p_col;
      //up();p_col=width+syntax_indent+1;
      rul_enter();
   } else if (word=='return') {
      replace_line(line:+' ');
      _end_line();
   } else if (word=='end') {
      save_pos(p2);
      up();_end_line();
      col=_rul_find_block_col(block_info);
      restore_pos(p2);
      if (col) {
         replace_line(indent_string(col-1)orig_word' ');
         _end_line();
      } else {
         replace_line(line);
         _end_line();++p_col;
      }
   } else if (word=='else') {
      save_pos(p2);
      col=_rul_find_block_col(block_info);
      restore_pos(p2);
      if (col) {
         replace_line(indent_string(col-1)orig_word);
         _end_line();++p_col;
      } else {
         replace_line(line);
         _end_line();++p_col;
      }
   } else if (word=='elseif') {
      save_pos(p2);
      col=_rul_find_block_col(block_info);
      restore_pos(p2);
      if (col) {
         replace_line(indent_string(col-1)orig_word'  then');
         _end_line();p_col-=5;
      } else {
         replace_line(line'  then');
         _end_line();p_col-=5;
      }
   } else if (word=='for') {
      replace_line(line:+'  step 1');
      insert_line(indent_string(width)'endfor;');
      up();_end_line();p_col-=7;
   } else if (word=='program') {
      replace_line(line);
      //insert_line('');
      insert_line(indent_string(width)'endprogram');
      up();_end_line();++p_col;
      rul_enter();
      //up();p_col=width+syntax_indent+1;
   } else if (word=='function') {
      replace_line(line);
      //insert_line('');
      insert_line(indent_string(width)'begin');
      insert_line(indent_string(width)'end;');
      up(2);_end_line();++p_col;
      //up();p_col=width+syntax_indent+1;
   } else if (word=='prototype') {
      replace_line(line);
      //insert_line('');
      _end_line();++p_col;
      //up();p_col=width+syntax_indent+1;
   } else if (word=='typedef') {
      replace_line(line);
      insert_line(indent_string(width)'begin');
      insert_line(indent_string(width)'end;');
      up(2);_end_line();++p_col;
   } else if (word=='begin') {
      save_pos(p2);
      col=_rul_find_block_col(block_info);
      restore_pos(p2);
      if (col) {
         replace_line(indent_string(col-1)orig_word);
         insert_line(indent_string(col-1)'end;');
         _end_line();++p_col;
      } else {
         replace_line(line);
         insert_line(indent_string(width)'end;');
         _end_line();++p_col;
      }
      up;_end_line();++p_col;
   } else {
     status=1
   }
   return status

}
/*
    Returns true if nothing is done
*/
static boolean rul_expand_enter(syntax_indent)
{
   save_pos(p);
   orig_linenum=p_line;
   orig_col=p_col;
   enter_cmd=name_on_key(ENTER);
   if (enter_cmd=='nosplit-insert-line') {
      _end_line();
   }
   get_line(line);
   if ((line=='else' || line=='begin') && p_col==_text_colc()+1) {
      col=_rul_find_block_col(block_info);
      if (col) {
         replace_line(indent_string(col-1)strip(line));_end_line();
         save_pos(p);
      }

   }

   begin_col=rul_begin_stat_col(false /* No RestorePos */,
                              false /* Don't skip first begin statement marker */,
                              false /* Don't return first non-blank */,
                              1  /* Return 0 if no code before cursor. */,
                              '',
                              1
                              );
   if (!begin_col /*|| (p_line>orig_linenum)*/) {
      restore_pos(p);
      return(1);
   }
   restore_pos(p);
   col=_rul_indent_col(0);
   indent_on_enter('',col);
   return(0)
}

/*

   while expr
   endwhile;
   repeat
   until expr;
   
   if expr goto name;
   
   if expr then
   elseif 
   else
   endif
   program
   endprogram
   switch expr
   endswitch
   function name(a,b,c)
   begin
   end;
   typedef name
   begin
   end

*/
int _rul_find_block_col(_str &block_info /* currently just block word */)
{
   save_pos(orig_pos);
   int nesting;
   nesting=1;
   //event|end|case|if|while|for|begin|class|interface
   beginend_word_re='while|endwhile|repeat|until|if|endif|program|endprogram|switch|endswitch|function|begin|end|typedef';
   status=search(beginend_word_re,'@-wrxcs');
   //status=search('xxx','@-wrxcs');
   for (;;) {
      if (status) {
         restore_pos(orig_pos);
         return(0);
      }
      word=lowcase(get_text(match_length(),match_length('S')));
      switch (word) {
      case 'while':
      case 'repeat':
      case 'program':
      case 'switch':
         --nesting;
         break;
      case 'endwhile':
      case 'until':
      case 'endprogram':
      case 'endswitch':
         ++nesting;
         break;
      case 'if':
         // Could have "if expr then" or "if expr goto" or may be
         // the user has not finished typing in the statement.
         save_pos(orig_p2);
         save_search(p1,p2,p3,p4);
         right();
         status=search('then|;|goto|'beginend_word_re,'@wrxcs');
         word=get_text(match_length(''),match_length('S'));
         restore_search(p1,p2,p3,p4);
         restore_pos(orig_p2);
         if (!status) {
             if (word=='then') {
                --nesting;
             }
         }
         break;
      case 'function':
      case 'typedef':
         if (nesting>0) {
            nesting=0;
         }
         break;
      }
      //messageNwait('word='word' nesting='nesting);
      if (nesting<=0) {
         block_info=cur_word(junk);
         first_non_blank();
         col=p_col;
         restore_pos(orig_pos);
         return(col);
      }
      status=repeat_search();
   }
}

/*

  
   while expr
   endwhile;
   repeat
   until expr;
   
   if expr goto name;
   
   if expr then
   elseif 
   else
   endif
   program
   endprogram
   switch expr
   endswitch
   function name(a,b,c)
   begin
   end;
   typedef name
   begin
   end

   Return beginning of statement column.  0 if not found.
   
*/
static int rul_begin_stat_col(boolean RestorePos,boolean SkipFirstHit,boolean ReturnFirstNonBlank,...)
{

   orig_linenum=p_line;orig_col=p_col;
   FailIfNoPrecedingText=(arg(4)!="");
   AlreadyRecursed=(arg(5)!="");
   FailWithMinus1_IfNoTextAfterCursor=(arg(6)!="");
   //ReturnCurColIfCursorBetweenOpenBraceAndEOF=1;
   save_pos(p);
   status=search('[;:]|then|else|elseif|begin|program|function|typedef|end|endprogram','-R@xcs');
   nesting=0;
   hit_top=false;
   MaxSkipPreprocessing=MAXSKIPPREPROCESSING;
   for (;;) {
      if (status) {
         top();
         hit_top=true;
      } else {
         cfg=_clex_find(0,'g');
         if (cfg==CFG_COMMENT || cfg==CFG_STRING) {
            SkipFirstHit=false;
            status=repeat_search();
            continue;
         }
         if (SkipFirstHit || nesting) {
            FailIfNoPrecedingText=false;
            SkipFirstHit=false;
            status=repeat_search();
            continue;
         }
         if (_in_c_preprocessing()) {
            --MaxSkipPreprocessing;
            if (MaxSkipPreprocessing<=0) {
               status=STRING_NOT_FOUND_RC;
               continue;
            }
            SkipFirstHit=false;
            begin_line();
            status=repeat_search();
            continue;
         }
         ch=get_text();
         if (!AlreadyRecursed && ch:==':') {
            save_pos(p2);
            col=rul_begin_stat_col(false,true,false,"",1);
            word=cur_word(junk);
            if (word=='case' || word=='default') {
               restore_pos(p2);
               right();
            }
         } else {
            if (isalpha(ch)) {
               if(cfg!=CFG_KEYWORD) {
                  FailIfNoPrecedingText=false;
                  status=repeat_search();
                  continue;
               }
            } else {
               right();
            }
         }
      }
      status=_clex_skip_blanksNpp();
      if (status) {
         restore_pos(p);
         /*
             Would could have an open brace followed by blanks and eof.
         */
         if (!hit_top) {
            if (!FailWithMinus1_IfNoTextAfterCursor) {
               return(p_col);
            }
            return(-1);
         }
         return(0);
      }
      if (ReturnFirstNonBlank) {
         first_non_blank();
      }
      col=p_col;
      if (hit_top && FailIfNoPrecedingText && (p_line>orig_linenum || (p_line==orig_linenum)&& p_col>orig_col)) {
         return(0);
      }
      if (RestorePos) {
         restore_pos(p);
      }
      return(col);
   }
}
static int NoSyntaxIndentCase(int non_blank_col,int orig_linenum,int orig_col,typeless p,int syntax_indent)
{
   //_message_box("This case not handled yet");
   // Smart paste should set the non_blank_col
   if (non_blank_col) {
      //messageNwait("fall through case 1");
      restore_pos(p);
      return(non_blank_col);
   }
   restore_pos(p);
   begin_stat_col=rul_begin_stat_col(false /* No RestorePos */,
                                   false /* Don't skip first begin statement marker */,
                                   true  /* Don't return first non-blank */
                                   );

   if (begin_stat_col && (p_line<orig_linenum ||
                          (p_line==orig_linenum && p_col<=orig_col)
                         )
      ) {
      /*
         Check if partial statement ends with close paren.  This
         could be a function declaration.

         Another to handle this is to to indent any way and then
         move the open brace to the correct colmun position when
         the users types it.
      */
      save_pos(p2);
      p_line=orig_linenum;p_col=orig_col;
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      _clex_skip_blanks("-");
      ch=get_text();
      if (ch:==")") {
         restore_pos(p);
         return(begin_stat_col);
      }
      restore_pos(p2);
      /*
         Here we have something like
         int i;
            int k,<ENTER>
               <Cursor goes here>
               OR
         VOID<ENTER>
         <Cursor goes here>myproc()      
      */
      col=p_col;
      // Here we assume that functions start in column 1 and
      // variable declarations or statement continuations do not.
      // This seems to be a common solution.
      if (p_col==1 && ch!=',') {
         restore_pos(p);
         return(col);
      }
      nextline_indent=syntax_indent;
      restore_pos(p);
      return(col+nextline_indent);
   }
   restore_pos(p);
   get_line(line);line=expand_tabs(line);
   if (line=="") {
      restore_pos(p);
      return(p_col);
   }
   //messageNwait("fall through case 3");
   first_non_blank();
   col=p_col;
   restore_pos(p);
   return(col);
}
static int HandlePartialStatement(int statdelim_linenum,
                                  int sameline_indent,
                                  int nextline_indent,
                                  int orig_linenum,int orig_col)
{
   orig_ch=get_text();
   save_pos(orig_pos);
   //linenum=p_line;col=p_col;

   begin_stat_col=rul_begin_stat_col(false /* No RestorePos */,
                                   false /* Don't skip first begin statement marker. */,
                                   false /* Don't return first non-blank */,
                                   '',
                                   '',
                                   1   // Fail if no text after cursor
                                   );
   if (begin_stat_col>0 && (p_line<orig_linenum || (p_line==orig_linenum && p_col<orig_col))
        /* && (linenum!=p_line || col!=p_col) */
      ) {
      // Now get the first non-blank column.
      begin_stat_col=rul_begin_stat_col(false /* No RestorePos */,
                                      false /* Don't skip first begin statement marker. */,
                                      true /* Return first non-blank */
                                      );
      save_pos(p);
      p_line=orig_linenum;p_col=orig_col;
      if (p_col==1) {
         up();_end_line();
      } else {
         left();
      }
      _clex_skip_blanks("-");
      ch=get_text();
#if 0
      if (ch:==")") {
         return(begin_stat_col);
      }
#endif      
      restore_pos(p);
      /*
         IF semicolon is on same line as extra characters

         Example
            then b=<ENTER>
      */
      if (p_line==statdelim_linenum) {
         return(begin_stat_col+sameline_indent);
      }
      /*
         Here we have something like
         int i;
            int k,<ENTER>
               <Cursor goes here>
               OR
         VOID<ENTER>
         <Cursor goes here>myproc()      
      */
      col=p_col;
      // Here we assume that functions start in column 1 and
      // variable declarations or statement continuations do not.
      // This seems to be a common solution.
      if (p_col==1 && ch!=',') {
         return(col);
      }
      return(col+nextline_indent);
   }
   return(0);
}
/*
   This code is just here incase we get fancy
*/
int _rul_indent_col(int non_blank_col)
{
   orig_col=p_col;
   orig_linenum=p_line;
   save_pos(p);
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_case .;
   syntax_indent=p_SyntaxIndent;
   // IF user does not want syntax indenting
   if ( syntax_indent<=0) {
      // Find non-blank-col
      return(NoSyntaxIndentCase(non_blank_col,orig_linenum,orig_col,p,0));
   }
   //style1=be_style & STYLE1_FLAG;
   //style2=be_style & STYLE2_FLAG;
   enter_cmd=name_on_key(ENTER);
   if (enter_cmd=='nosplit-insert-line') {
      _end_line();
   }

   nesting=0;OpenParenCol=0;
   if (p_col==1) {
      up();_end_line();
   } else {
      left();
   }

   status=search('[;:()]|then|else|elseif|begin|program|function|typedef|end|endprogram|while|switch|if|for|repeat','-R@xcs');
   for (;;) {
      if (status) {
         if (nesting<0) {
            restore_pos(p);
            return(OpenParenCol+1/*+def_c_space_after_paren*/);
         }
         return(NoSyntaxIndentCase(non_blank_col,orig_linenum,orig_col,p,syntax_indent));
      }

      ch=get_text();
      switch (ch) {
      case '(':
         if (!nesting && !OpenParenCol) {
            typeless p3;
            save_pos(p3);
            save_search(ss1,ss2,ss3,ss4);
            col=p_col;
            ++p_col;
            status=_clex_skip_blanks();
            if (!status && (p_line<orig_linenum || 
                            (p_line==orig_linenum && p_col<=orig_col)
                           )) {
               col=p_col-1;
            }
            restore_search(ss1,ss2,ss3,ss4);
            OpenParenCol=col;
            restore_pos(p3);
         }
         --nesting;
         status=repeat_search();
         continue;
      case ')':
         ++nesting;
         status=repeat_search();
         continue;
      default:
         if (nesting<0) {
            //messageNwait("nesting case");
            restore_pos(p);
            return(OpenParenCol+1/*+def_c_space_after_paren*/);
         }
      }
      if (nesting ) {
         status=repeat_search();
         continue;
      }
      if (_in_c_preprocessing()) {
         begin_line();
         status=repeat_search();
         continue;
      }
      word=get_text(match_length(),match_length('S'));
      if (word!=';' && word!=':' && word!=cur_word(junk)) {
         status=repeat_search();
         continue;
      }
      word=lowcase(word);

      //messageNwait("c_indent_col2: ch="ch);
      switch (word) {
      case ';':
         //messageNwait("case ;");
         save_pos(p2);
         statdelim_linenum=p_line;
         begin_stat_col=rul_begin_stat_col(false /* RestorePos */,
                                    true /* skip first begin statement marker */,
                                    true /* return first non-blank */
                                    );
         get_line(line);
         parse lowcase(line) with word1 word2 ';';
         if ((word1=='begin' && word2!='class') || word1=='program') {
            begin_stat_col+=syntax_indent;
         }
         restore_pos(p2);
         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }
         restore_pos(p);
         return(begin_stat_col);
      case ':':
         //messageNwait("case :");
         if (p_col!=1) {
            left();
            if (get_text()==":") {
               status=repeat_search();
               continue;
            }
            right();
         }

         save_pos(p2);

         /* Now check if there are any characters between the
            beginning of the previous statement and the original
            cursor position

            Could have
             case 'a':
                 int i,<ENTER>
         */
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }

         restore_pos(p2);


         /*

             default:<ENTER>
             case ???:<ENTER>
             (abc)? a: b;<ENTER>
         */
         begin_stat_col=c_begin_stat_col(false /* RestorePos */,
                                    true /* skip first begin statement marker */,
                                    true /* return first non-blank */,
                                    1
                                    );

         if (p_line==orig_linenum) {
            word=cur_word(junk);
            if (word=='case' || word=='default') {
               first_non_blank();
               // IF the 'case' word is the first non-blank on this line
               if (p_col==begin_stat_col) {
                  col=p_col;
                  restore_pos(p);
                  return(col);
               }
            }
         }
         restore_pos(p);
         return(begin_stat_col+syntax_indent);
      case 'then':

         statdelim_linenum=p_line;
         save_pos(p2);
         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position
         //p_col+=length(word);
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }
         restore_pos(p2);

         left();   // Don't worry about then in column 1.
         _clex_skip_blanks('-');
         search('if','-@wxcs');
         /*  IF expression THEN
         
         */
         first_non_blank();
         col=p_col+syntax_indent;
         restore_pos(p);
         return(col);

      /*
         For the words below, we indent based on the first
         non-blank.
      */
      case 'else':
      case 'elseif':
      case 'begin':
      case 'program':
      case 'function':
      case 'typedef':
         statdelim_linenum=p_line;
         save_pos(p2);
         // Now check if there are any characters between the
         // beginning of the previous statement and the original
         // cursor position
         //p_col+=length(word);
         col=HandlePartialStatement(statdelim_linenum,
                                    syntax_indent,syntax_indent,
                                    orig_linenum,orig_col);
         if (col) {
            restore_pos(p);
            return(col);
         }
         restore_pos(p2);

         first_non_blank();
         col=p_col+syntax_indent;
         restore_pos(p);
         return(col);
      case 'end':
      case 'endprogram':
         first_non_blank();
         col=p_col;
         restore_pos(p);
         return(col);
      case 'while':
      case 'switch':
      case 'if':
      case 'for':
      case 'repeat':
         /*
            Cases
              while ()
                 if () <ENTER>
              switch <ENTER>
         */
         first_non_blank();
         col=p_col+syntax_indent;
         restore_pos(p);
         return(col);
      default:
         _message_box('unknown word='word);
      }
      status=repeat_search();
   }

}
int rul_smartpaste(boolean char_cbtype,int first_col)
{

   comment_col='';
   //If pasted stuff starts with comment and indent is different than code,
   // do nothing.
   get_line first_line
   i=verify(first_line,' '\t);
   if ( i ) p_col=text_col(first_line,i,'I');
   if ( first_line!='' && _clex_find(0,'g')==CFG_COMMENT) {
      comment_col=p_col;
   }

   comment_col=p_col;
   // Look for first piece of code not in a comment
   status=_clex_skip_blanks('m');
   // IF (no code found AND pasting comment) OR
   //   (code found AND pasting comment AND code col different than comment indent)
   if ((status && comment_col!='') || (!status && comment_col!='' && p_col!=comment_col)) {
      return(0);
   }

   parse name_info(_edit_window().p_index) with . expand . . be_style . ;
   syntax_indent=p_SyntaxIndent;
   word=lowcase(cur_word(junk));
   if (!status && (word=='end' || word=='endprogram' || word=='elseif' || 
                   word=='else' || word=='until' || word=='case' || word=='default')) {
      //messageNwait('it was an end');
      save_pos(p2);
      up();_end_line();
      enter_col=_rul_find_block_col(block_info);
      restore_pos(p2);
      if (enter_col && word=='case') {
         parse name_info(_edit_window().p_index) with . expand . . be_style indent_case .;
         if (indent_case) {
            enter_col+=p_SyntaxIndent;
         }
      }
      if (!enter_col) {
         enter_col='';
      }
      _begin_select;get_line first_line;up();
   } else {
      _begin_select;get_line first_line;up();
      _end_line();
      save_pos(p2);
      // Check if we are pasting into the middle of an SQL or start task statement
      begin_col=rul_begin_stat_col(false /* No RestorePos */,
                                 false /* Don't skip first begin statement marker */,
                                 false /* Don't return first non-blank */,
                                 1  /* Return 0 if no code before cursor. */,
                                 '',
                                 1
                                 );
      restore_pos(p2);
      enter_col=rul_enter_col();
      status=0;
   }
   //IF no code found/want to give up OR ... OR want to give up 
   if (status || enter_col==1 || enter_col=='' ||
      (substr(first_line,1,1)!='' && (!char_cbtype ||first_col<=1))) {
      return(0);
   }
   return(enter_col);
}

static _str rul_enter_col()
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .
   if ( command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      rul_enter_col2(enter_col) ) {
      return('');
   }
   return(enter_col);
}


static boolean rul_enter_col2(int &enter_col)
{
   enter_col=_rul_indent_col(0);
   return(0);
}

defeventtab _rul_extform
_ok.on_create()
{
   parse p_active_form.p_name with '_' ext '_extform';
   index = find_index('def-options-'ext, MISC_TYPE);
   if (!index) {
      return('');
   }
   info = name_info(index);
   parse name_info(index) with rem rem2 minexpkwdlen rem3 bestyle indent_case .;
   if (!isinteger(indent_case)) {
      indent_case=0;
   }
   _minimum.p_text=minexpkwdlen;
   //messageNwait('before comments comment:'comment' ic:'indentcase);
    index=find_index('def_'ext'_smartpaste',VAR_TYPE);
   _smartp.p_value=_get_var(index);
   _minimum.p_text = minexpkwdlen;
   _indent_case.p_value=indent_case;
}
_ok.lbutton_up()
{
   parse p_active_form.p_name with '_' ext '_' .;
   index = find_index('def-options-'ext, MISC_TYPE)
   if (!index) {
      return('')
   }
   parse name_info(index) with rem rem2 minexpkwdlen rem3 bestyle indent_case .;
   if (!isinteger(_minimum.p_text)) {
      _minimum.p_text = 1;
   }
   info = rem' 'rem2' '_minimum.p_text' 'rem3' 'bestyle' '_indent_case.p_value;
   _setext(ext, 'options', info);
   spindex=find_index('def_'ext'_smartpaste',VAR_TYPE);
   if (_smartp.p_value&&_smartp.p_enabled) {
      _set_var(spindex,1);
   }else{
      _set_var(spindex,0);
   }
   p_active_form._delete_window(0);
}

/*
 <B>Purpose</B>
    This function is used to get information about the code at
    the current buffer location, including the current ID under
    the cursor, the expression before the current ID, and other
    supplementary information useful to list-tags.
 <B>Parameters</B>
    <CODE>errorArgs         </CODE>array of strings for error message arguments
    <CODE>                  </CODE>refer to codehelp.e VSCODEHELPRC_*
    <CODE>PossibleOperator  </CODE>Last character might be an operator?
    <CODE>prefixexp         </CODE>(reference), returns prefix of expression
    <CODE>lastid            </CODE>(reference), returns last identifier in expression
    <CODE>lastidstart_col   </CODE>(reference), start column of last identifier
    <CODE>lastidstart_offset </CODE>(reference), seek position of last identifier
    <CODE>info_flags        </CODE>(reference), bitset of VS_CODEHELPFLAG_*
    <CODE>otherinfo         </CODE>(reference), used in some cases for extra information
    <CODE>                  </CODE>             tied to info_flags
 <B>Returns</B>
    0 if successful
    1 if expression too complex
    2 if not valid operator
*/
int _rul_get_idexp(_str (&errorArgs)[],
                   boolean PossibleOperator,
                   _str &prefixexp,
                   _str &lastid,int &lastidstart_col,
                   int &lastidstart_offset,
                   int &info_flags,
                   typeless &otherinfo
                  )
{
   return _c_get_idexp(errorArgs,PossibleOperator,prefixexp,
                       lastid,lastidstart_col,lastidstart_offset,
                       info_flags,otherinfo);
}

/*
 <B>Purpose</B>
    Context tagging hook function for filling in the member help dialog.
    Based on the current prefix expression, last identifier and other
    information about the current context, fills in the tree control
    (which is the current window upon entry) with the set of symbols
    (possibly divided into categories) that could be used in that
    context.  For example, the list of members of a class (FooBar::<here>)
    
    On entry, the tree is either empty, indicating that this is the
    first time in this function and the list needs to be created.
    Otherwise, the tree already contains items and needs to be updated
    incrementally (because lastid_prefix and lastid changing).
 <B>Parameters</B>
    <CODE>errorArgs         </CODE>array of strings for error message arguments
    <CODE>                  </CODE>refer to codehelp.e VSCODEHELPRC_*
    <CODE>editorctl_wid     </CODE>window ID of editor control context tagging
    <CODE>                  </CODE>was invoked from.
    <CODE>prefixexp         </CODE>prefix of expression (from _<ext>_get_idexp
    <CODE>lastid            </CODE>last identifier in expression
    <CODE>lastid_prefix     </CODE>prefix of lastid to the left of the cursor
    <CODE>lastidstart_offset </CODE>seek position of last identifier
    <CODE>expected_type     </CODE>expected return type (not implemented fully)
    <CODE>info_flags        </CODE>bitset of VS_CODEHELPFLAG_*
    <CODE>otherinfo         </CODE>used in some cases for extra information
    <CODE>                  </CODE>tied to info_flags
 <B>Returns</B>
    0 on success, <0 on error (one of VSCODEHELPRC_*, errorArgs must be set)
*/
int _rul_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,
                             _str prefixexp,_str lastid,
                             _str lastid_prefix,int lastidstart_offset,
                             _str expected_type,int info_flags,typeless otherinfo)
{
   return _c_insert_context_tags(errorArgs,editorctl_wid,prefixexp,
                                 lastid,lastid_prefix,lastidstart_offset,
                                 expected_type,info_flags,otherinfo);
}

/*
 <B>Purpose</B>
    Find a list of tags matching the given identifier after
    evaluating the prefix expression.
 <B>Parameters</B>
    <CODE>errorArgs         </CODE>array of strings for error message arguments
    <CODE>                  </CODE>refer to codehelp.e VSCODEHELPRC_*
    <CODE>prefixexp         </CODE>prefix of expression (from _<ext>_get_idexp
    <CODE>lastid            </CODE>last identifier in expression
    <CODE>lastidstart_offset </CODE>seek position of last identifier
    <CODE>info_flags        </CODE>bitset of VS_CODEHELPFLAG_*
    <CODE>otherinfo         </CODE>used in some cases for extra information
    <CODE>                  </CODE>tied to info_flags
    <CODE>find_parents      </CODE>for a virtual class function, list all
    <CODE>                  </CODE>overloads of this function
    <CODE>max_matches       </CODE>maximum number of matches to locate
    <CODE>exact_match       </CODE>if true, do an exact match, otherwise
    <CODE>                  </CODE>perform a prefix match on lastid
    <CODE>case_sensitive    </CODE>if true, do case sensitive name comparisons
 <B>Returns</B>
    The number of matches found or <0 on error (one of VSCODEHELPRC_*,
    errorArgs must be set).
*/
int _rul_find_context_tags(_str (&errorArgs)[],_str prefixexp,
                         _str lastid,int lastidstart_offset,
                         int info_flags,typeless otherinfo,
                         boolean find_parents,int max_matches,
                         boolean exact_match,int case_sensitive)
{
   return _c_find_context_tags(errorArgs,prefixexp,
                               lastid,lastidstart_offset,
                               info_flags,otherinfo,find_parents,
                               max_matches,exact_match,case_sensitive);
}

/*
 <B>Purpose</B>
    Context tagging hook function for function help.  Finds the start
    location of a function call and the function name.
 <B>Parameters</B>
    <CODE>errorArgs                </CODE>array of strings for error message arguments
    <CODE>                         </CODE>refer to codehelp.e VSCODEHELPRC_*
    <CODE>OperatorTyped            </CODE>When true, user has just typed last
    <CODE>                         </CODE>character of operator.
    <CODE>                         </CODE>Example: <CODE>p-></CODE><Cursor Here>
    <CODE>                         </CODE>This should be false if cursorInsideArgumentList is true.
    <CODE>cursorInsideArgumentList </CODE>When true, user requested function help
    <CODE>                         </CODE>when the cursor was inside an argument list.
    <CODE>                         </CODE>Example: <CODE>MessageBox(...,</CODE><Cursor Here><CODE>...)</CODE>
    <CODE>                         </CODE>Here we give help on MessageBox
    <CODE>FunctionNameOffset       </CODE>(reference) Offset to start of function name.
    <CODE>ArgumentStartOffset      </CODE>(reference) Offset to start of first argument
    <CODE>flags                    </CODE>(reference) function help flags
 <B>Returns</B>
    0    Successful
    VSCODEHELPRC_CONTEXT_NOT_VALID
    VSCODEHELPRC_NOT_IN_ARGUMENT_LIST
    VSCODEHELPRC_NO_HELP_FOR_FUNCTION
*/
int _rul_fcthelp_get_start(_str (&errorArgs)[],
                           boolean OperatorTyped,
                           boolean cursorInsideArgumentList,
                           int &FunctionNameOffset,
                           int &ArgumentStartOffset,
                           int &flags
                          )
{
   return _c_fcthelp_get_start(errorArgs,OperatorTyped,cursorInsideArgumentList,
                               FunctionNameOffset,ArgumentStartOffset,flags);
}

/*
 <B>Purpose</B>
    Context tagging hook function for retrieving the information about
    each function possibly matching the current function call that
    function help has been requested on.
    
    REMARKS
      If there is no help for the first function, a non-zero value
      is returned and message is usually displayed.
  
      If the end of the statement is found, a non-zero value is
      returned.  This happens when a user to the closing brace
      to the outer most function caller or does some weird
      paste of statements.
  
      If there is no help for a function and it is not the first
      function, FunctionHelp_list is filled in with a message
          FunctionHelp_list._makeempty();
          FunctionHelp_list[0].proctype=message;
          FunctionHelp_list[0].argstart[0]=1;
          FunctionHelp_list[0].arglength[0]=0;
          FunctionHelp_list[0].return_type=0;
  
 <B>Parameters</B>
    <CODE>errorArgs                 </CODE>array of strings for error message arguments
    <CODE>                          </CODE>refer to codehelp.e VSCODEHELPRC_*
    <CODE>FunctionHelp_list         </CODE>Structure is initially empty.
    <CODE>                          </CODE>FunctionHelp_list._isempty()==true
    <CODE>                          </CODE>You may set argument lengths to 0.
    <CODE>                          </CODE>See VSAUTOCODE_ARG_INFO structure in slick.sh.
    <CODE>FunctionHelp_list_changed </CODE>(reference)Indicates whether the data in
    <CODE>                          </CODE>FunctionHelp_list has been changed.
    <CODE>                          </CODE>Also indicates whether current
    <CODE>                          </CODE>parameter being edited has changed.
    <CODE>FunctionHelp_cursor_x     </CODE>(reference) Indicates the cursor x position
    <CODE>                          </CODE>in pixels relative to the edit window
    <CODE>                          </CODE>where to display the argument help.
    <CODE>FunctionNameStartOffset   </CODE>The text between this point and
    <CODE>                          </CODE>ArgumentEndOffset needs to be parsed
    <CODE>                          </CODE>to determine the new argument help.
    <CODE>ArgumentEndOffset         </CODE>see FunctionNameStartOffset (above)
    <CODE>flags                     </CODE>function help flags (from fcthelp_get_start)
 
 <B>Returns</B>
    Returns 0 if we want to continue with function argument
    help.  Otherwise a non-zero value is returned and a
    message is usually displayed.
       1   Not a valid context
       2-9  (not implemented yet)
       10   Context expression too complex
       11   No help found for current function
       12   Unable to evaluate context expression
*/
int _rul_fcthelp_get(_str (&errorArgs)[],
                   VSAUTOCODE_ARG_INFO (&FunctionHelp_list)[],
                   boolean &FunctionHelp_list_changed,
                   int &FunctionHelp_cursor_x,
                   _str &FunctionHelp_HelpWord,
                   int FunctionNameStartOffset,
                   int flags
                   )
{
   return _c_fcthelp_get(errorArgs,FunctionHelp_list,
                         FunctionHelp_list_changed,FunctionHelp_cursor_x,
                         FunctionHelp_HelpWord,FunctionNameStartOffset,flags);
}

/*
 <B>Purpose</B>
    Merges prototypes (which have argument signatures only
    with functions (which have argument names only) for display
    using function help.
 <B>Parameters</B>
    <CODE>match_list                </CODE>array of function info of the form
    <CODE>                          </CODE>func_name \t type \t sig \t returns
*/
void _rul_merge_and_remove_duplicates(_str (&match_list)[])
{
   int i=1;
   while (i<match_list._length()) {
      _str item1=match_list[i];
      _str item2=match_list[i-1];
      parse item1 with name1 "\t" type1 "\t" sig1 "\t" ret1;
      parse item2 with name2 "\t" type2 "\t" sig2 "\t" ret2;
      if (name1:==name2) {

         parse sig1 with part1 ',' .;
         part1=strip(stranslate(part1,"","POINTER|BYREF",'rw'));
         if (pos(' ',part1)) {
            match_list[i-1]=item1;
            match_list[i]=item2;
            i++;
            continue;
         }
         parse sig2 with part2 ',' .;
         part2=strip(stranslate(part2,"","POINTER|BYREF",'rw'));
         if (pos(' ',part2)) {
            i++;
            continue;
         }

         if (type1=='proto' && type2=='func') {
            name2=sig2;
            sig2=sig1;
            sig1=name2;
            type1=type2;
         } else if (type1=='func' && type2=='proto') {
         } else {
            i++;
            continue;
         }

         _str sig_types[]; sig_types._makeempty();
         _str sig_names[]; sig_names._makeempty();
         while (sig1!='') {
            parse sig1 with arg1 ',' sig1;
            sig_names[sig_names._length()]=strip(arg1);
         }
         while (sig2!='') {
            parse sig2 with arg1 ',' sig2;
            sig_types[sig_types._length()]=strip(arg1);
         }
         if (sig_types._length()==sig_names._length()) {
            sig1='';
            if (sig_types._length()>0) {
               sig1=sig_types[0]' 'sig_names[0];
            }
            for (j=1; j<sig_types._length(); j++) {
               strappend(sig1,', 'sig_types[j]' 'sig_names[j]);
            }
            match_list._deleteel(i);
            match_list[i-1]=name1"\tfunc\t"sig1"\t"ret1;
            i=i+2;
         }
      }
      i++;
   }
}

// Since InstallScript functions only have the variable names in
// the signature, not their types, we need this in order to locate
// the corresponding function prototype in the database and find
// the return types of each parameter.
//
void _rul_after_UpdateLocals()
{
   // find the current function name
   int context_id = tag_current_context();
   if (context_id <= 0) {
      return;
   }
   tag_get_detail2(VS_TAGDETAIL_context_name,context_id,func_name);
   tag_get_detail2(VS_TAGDETAIL_context_type,context_id,type_name);
   tag_get_detail2(VS_TAGDETAIL_context_args,context_id,func_args);
   if (type_name != 'func' || func_args == '') {
      return;
   }

   // try to find corresponding prototype in current context
   _str proto_args='';
   int proto_id=tag_find_context(func_name,true,true);
   while (proto_id>0) {
      tag_get_detail2(VS_TAGDETAIL_context_args,proto_id,proto_args);
      tag_get_detail2(VS_TAGDETAIL_context_type,proto_id,proto_type);
      if (proto_type=='proto' && proto_args!='') {
         break;
      }
      proto_args='';
      proto_id=tag_next_context(func_name,true,true);
   }

   // nothing found in current context, try tag files
   if (proto_args=='') {
      typeless tag_files=tags_filenamea('rul');
      for (i=0;;i++) {
         _str tag_filename=next_tag_filea(tag_files,i,false,true);
         if (tag_filename=='') {
            break;
         }
         int status=tag_find_tag(func_name,'proto','');
         while (!status) {
            tag_get_detail(VS_TAGDETAIL_arguments,proto_args);
            if (proto_args!='') {
               break;
            }
            status=tag_next_tag(func_name,'proto','');
         }
      }
   }
   if (proto_args=='') {
      return;
   }

   // save/append the current locals to an array
   VS_TAG_BROWSE_INFO outer_locals[];
   outer_locals._makeempty();
   n=tag_get_num_of_locals();
   for (i=1; i<=n; i++) {
      VS_TAG_BROWSE_INFO cm;
      tag_get_local2(i, cm.member_name, cm.type_name, cm.file_name,
                     cm.line_no, cm.seekpos,
                     cm.scope_line_no, cm.scope_seekpos,
                     cm.end_line_no, cm.end_seekpos,
                     cm.class_name, cm.flags, cm.arguments, cm.return_type);
      if (cm.type_name:=='param') {
         parse proto_args with argument ',' proto_args;
         cm.return_type = strip(argument);
      }
      outer_locals[outer_locals._length()] = cm;
   }

   // re-insert the locals
   tag_clear_locals(0)
   n=outer_locals._length();
   for (i=0; i<n; i++) {
      VS_TAG_BROWSE_INFO cm = outer_locals[i];
      _str local_sig = cm.return_type;
      if (cm.arguments!='') {
         strappend(local_sig, VS_TAGSEPARATOR_args:+cm.arguments);
      }
      k=tag_insert_local2(cm.member_name, cm.type_name, cm.file_name,
                          cm.line_no, cm.seekpos,
                          cm.scope_line_no, cm.scope_seekpos,
                          cm.end_line_no, cm.end_seekpos,
                          cm.class_name, cm.flags, local_sig);
   }

   // that's all folks
   return;
}

#if !__UNIX__
/*
 <B>Purpose</B>
    Get installation path for InstallShield from registry.
 <B>Returns</B>
    '' if InstallShield not found, path if it is found.
*/
static _str gInstallShieldList[]={
   "Software\\InstallShield\\InstallShield Professional",
   "Software\\InstallShield\\InstallShield Express",
   "Software\\InstallShield\\InstallShield Free Edition"
};
_str _InstallShieldIncludePath()
{
   for (i=0;i<gInstallShieldList._length();++i) {
      int status=_ntRegFindVersionKeyName(HKEY_LOCAL_MACHINE,gInstallShieldList[i],0,"main",name);
      if (!status) {
         _str path=_ntRegQueryValue(HKEY_LOCAL_MACHINE,name,"","Path");
         if (path!="") {
            if (last_char(path)!=FILESEP) {
               path=path:+FILESEP;
            }
            path=path:+"Include";
            if (file_match(maybe_quote_filename(path), 1)!='') {
               return(path:+FILESEP);
            }
         }
      }
   }
   return('');
}

/*
 <B>Purpose</B>
    Build tag file for InstallShield's InstallScript language
    standard header files.  Uses registry to locate InstallShield
    and tags all the headers and .rul files under their include
    directory.
 <B>Parameters</B>
    <CODE>tfindex    </CODE>Tag file index
*/
int _rul_MaybeBuildTagFile(int &tfindex)
{
   // Only works on Windows 9x and NT
   if (substr(machine(),1,2):!='NT') {
      return(1);
   }
   // get installation path for InstallShield
   _str path=_InstallShieldIncludePath();
   if (path=='') {
      return(1);
   }
   // check def-var for InstallScript tag files
   tfindex=find_index('def-tagfiles-rul',MISC_TYPE);

   // IF the user does not have an extension specific tag file for InstallScript
   int status=0;
   _str ext='rul';
   _str name_part=ext'tags.vtg';
   _str tagfilename=absolute(_config_path():+name_part);
   if (!tfindex || !pos(name_part,name_info(tfindex),1,_fpos_case) ||
       tag_read_db(tagfilename)==FILE_NOT_FOUND_RC) {
      tag_close_db(tagfilename,true);
      slickc_filename=path_search('maketags'_macro_ext,'VSLICKMACROS');
      if (slickc_filename=="") {
         slickc_filename=path_search('maketags'_macro_ext'x','VSLICKMACROS');
      }
      if (slickc_filename!='') {
         _str extra_file=get_env('VSROOT'):+'builtins.'ext;
         extra_file=file_match('-p 'maybe_quote_filename(extra_file),1);
         status=shell('maketags -n "InstallScript Run-Times" -t -o 'maybe_quote_filename(tagfilename)' 'maybe_quote_filename(path:+'*.h')' 'maybe_quote_filename(path:+'*.rul')' 'maybe_quote_filename(extra_file));
         set_exttagfiles(ext" "tagfilename,true);
         _config_modify|=CFGMODIFY_DEFDATA;
      } else {
         status=1;
      }
   }
   return(status);
}
#endif
