/*
$VerboseHistory: seldisp.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:09:59a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 09:59a
 * Comment:
 * Adde support for faster tagging.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include "slick.sh"
_command int plusminus() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   pm= _lineflags()&(PLUSBITMAP_LF|MINUSBITMAP_LF);
   if (pm==PLUSBITMAP_LF) {
      start_level=_lineflags()&LEVEL_LF;
      show_level=start_level+NEXTLEVEL_LF;
      get_event('B');
      _lineflags(MINUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF);
      save_pos(p);
      for(;;) {
         if(down()) break;
         level=_lineflags()&LEVEL_LF;
         // IF a strange condition occurred or we hit the start of a new expansion
         //    at the same level
         if (level<start_level || 
             (level==start_level && _lineflags()&(PLUSBITMAP_LF|MINUSBITMAP_LF))
             ) {
            break;
         }
         if (def_seldisp_flags &SELDISP_EXPANDSUBLEVELS) {
            if (_lineflags() & PLUSBITMAP_LF) {
               _lineflags(MINUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF);
            }
            // Turn off HIDDEN
            _lineflags(0,HIDDEN_LF);
         } else if (def_seldisp_flags &SELDISP_COLLAPSESUBLEVELS) {
            if (_lineflags() & MINUSBITMAP_LF) {
               _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF);
            }
         }
         if (level>=show_level) {
            if (level<=show_level) {
               if ( _lineflags()&MINUSBITMAP_LF) {
                  show_level=level+NEXTLEVEL_LF;
               }
               // Turn off HIDDEN
               _lineflags(0,HIDDEN_LF);
            }
         } else {
            if (level<show_level) {
               show_level=level;
               // Turn off HIDDEN
               _lineflags(0,HIDDEN_LF);
            /*} else if ( level==show_level ) {
               // Turn off HIDDEN
               _lineflags(0,HIDDEN_LF);
               if ( _lineflags()&PLUSBITMAP_LF) {
                  show_level=level-NEXTLEVEL_LF;
               }*/
            }
         }
      }
      restore_pos(p);
      return(0);
   } else if (pm==MINUSBITMAP_LF) {
      start_level=_lineflags()&LEVEL_LF;
      get_event('B');
      _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF);
      save_pos(p);
      for(;;) {
         if(down()) break;
         level=_lineflags()&LEVEL_LF;
         // IF a strange condition occurred or we hit the start of a new expansion
         //    at the same level
         if (level<=start_level
             // ||(level==start_level && _lineflags()&(PLUSBITMAP_LF|MINUSBITMAP_LF))
             ) {
            break;
         }
         //Turn on HIDDEN
         _lineflags(HIDDEN_LF);
      }
      restore_pos(p);
      return(0);
   }
   return(1);
}
/*
    This function performs the following to the selection
    specified
       *  Character selection is converted to a line selection
          if it encompasses lines.

    For line selections or converted character selections
    the following actions are performed.
       *  If the last line of selection has a plus bitmap,
          hidden lines below the plus bitmap are selected.
          In addition, hidden lines at the end of new selection
          that are blank or just comments are removed from
          the selection.
       *  If the line before the first line of the selection
          contains a plus bitmap, the line selection is
          extended to contain the comments before the
          first line of the selection.
RETURN
    true if selection was modified          
*/
boolean _extend_outline_selection(markid)
{
   if (_select_type(markid)!="LINE" || _select_type(markid)=="") return(false);

   persistant=(def_persistent_select=='Y')?'P':'';
   mstyle='N'persistant;
   orig_buf_id=p_buf_id;
   _get_selinfo(start_col,end_col,bufid,markid);
   p_buf_id=bufid;
   save_pos(p);
   if (!_isnull_selection(markid) && _select_type(markid)=='CHAR') {
      if (start_col==1 && end_col==1 && !_select_type(markid,"I")) {
         _begin_select(markid);save_pos(begin);
         _end_select(markid);save_pos(vend);
         _deselect(markid);
         restore_pos(begin);_select_line(markid,mstyle);
         restore_pos(vend);up();_select_line(markid,mstyle);
      }

   }
   if (_select_type(markid)=="CHAR") {
      restore_pos(p);
      p_buf_id=orig_buf_id;
      return(false);
   }
   if (markid=="") markid=_duplicate_selection("");
   new_markid=_duplicate_selection(markid);
   if (_select_type(markid,'S')=='C') {
      _select_type(markid,'S','E');
   }
   _end_select(new_markid);
   pm= _lineflags()&(PLUSBITMAP_LF|MINUSBITMAP_LF);
   _free_selection(new_markid);
   // IF there is a plus bitmap displayed on this line.
   result=false;
   if (pm==PLUSBITMAP_LF) {
#if 0
      if (p_lexer_name!="") {
         start_line=p_line;
      }
#endif
      for(;;) {
         if(down()) break;
         if (!(_lineflags()&HIDDEN_LF)) {
            up();
            break;
         }
      }
#if 0
      if (p_lexer_name!="") {
         // Don't include comments at the end of the selection
         _end_line();
         // Search backwards skipping blanks and comments
         _clex_skip_blanks("h-");
         if (p_line<start_line) {
            p_line=start_line;
         }
      }
#endif
      save_pos(vend);
      _begin_select(markid);save_pos(begin);

      _deselect(markid);
      restore_pos(begin);_select_line(markid,mstyle);
      restore_pos(vend);_select_line(markid,mstyle);
      result=true;
   }
   restore_pos(p);
   p_buf_id=orig_buf_id;
   return(result);
}
boolean _preprocessing_supported()
{
   ext=_bufnameNmode2ext(p_buf_name,p_mode_name);
   return(ext=='c' || ext=='pas' || ('.'ext==_macro_ext));
#if 0
   if ( def_keys=='vi-keys' ) {
      if ( upcase(vi_get_vi_mode())=='C' ) {
         etab_name=vi_name_on_key('','IK');
      } else {
         etab_name=name_name(p_mode_eventtab);
      }
   } else {
      etab_name=name_name(p_mode_eventtab);
   }
   //etab_name=name_name(p_mode_eventtab);
   return(etab_name=='c-keys' || etab_name=='slick-keys' || etab_name=='pas-keys' /*|| 
          etab_name=='awk-keys' || etab_name=='perl-keys' */);
#endif
}
_command void hide_all_comments() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   mou_hour_glass(1);
   save_pos(p);
   top();
   status=_clex_find(COMMENT_CLEXFLAG);
   for (;;) {
      if (status) {
         break;
      }
      orig_line=p_line;
      hide_comments();
      p_line=orig_line;
      _end_line();
      status=_clex_find(COMMENT_CLEXFLAG,'N');
      if (status) {
         break;
      }
      status=_clex_find(COMMENT_CLEXFLAG);
   }
   mou_hour_glass(0);
   restore_pos(p);
}
/*
Some case analysis

   [1]         [2]           [3]            [4]         [5]
   
    1           1+            1              1+          2
 -->1       --->2         --->1+         --->2+      --->1+
    ...         ...           ...            ...         ...
    1           2             2              3           2
-------------------------------------------------------------
   2 OK       NO              2 OK         NO           NO
          Could Use second       
          Line of selection
          but it must be at
          same level       
End of selection considerations
 * Make sure selection does not extend past end of this level
     2                  2
 --->2               -->2
     2                  2 <---shorten selection to here
 --->1+              -->1+
 
  Just stop 
  
* Also make sure encompass all inner levels
   1
-->1  
   1+
-->2
   2
   2 <--  Extend selection to here
   1 
   1
   
*/
void _hide_lines(int first_line,last_line)
{
   if (first_line>last_line) {
      p_line=last_line;
      return;
   }
   p_line=first_line;
   // IF we are on line#0 and we are not displaying tof line
   if (_on_line0() && !_default_option('t')) {
      ++first_line;
      status=down();
      if (status || first_line>=last_line) {
         p_line=last_line;
         return;
      }
   }
   cur_lineflags=_lineflags();
   up();
   prev_lineflags=_lineflags();
   // IF this is case 1 or 3
   if (!(prev_lineflags & (PLUSBITMAP_LF|MINUSBITMAP_LF)) &&
       (prev_lineflags & LEVEL_LF)==(cur_lineflags & LEVEL_LF)) {
      new_level=(prev_lineflags& LEVEL_LF) + NEXTLEVEL_LF;
      //messageNwait("hide_selection: case 1 or 3");
   // IF  this is case 2
   } else if ((prev_lineflags & (PLUSBITMAP_LF|MINUSBITMAP_LF)) && 
              !(cur_lineflags & (PLUSBITMAP_LF|MINUSBITMAP_LF))
              ) {
      p_line=last_line;
      return;
/*
      //messageNwait("hide_selection: case 2");
       down();
       // IF we are left with only one line
       if (p_line>=last_line) {
          p_line=last_line;
          return;
       }
       new_level=(cur_lineflags&LEVEL_LF) + NEXTLEVEL_LF;
*/       
   // IF  this is case 4 or 5
   } else {
      p_line=last_line;
      return;
   }

   _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF);
   down();
   start_level=new_level-NEXTLEVEL_LF;
   doEndLastLevel=true;
   for (;;) {
      level=(_lineflags() & LEVEL_LF);
      // IF a strange condition occurred or we hit the start of a new expansion
      //    at the same level
      if (level<start_level 
          //||(level==start_level && _lineflags()&(PLUSBITMAP_LF|MINUSBITMAP_LF))
          ) {
         doEndLastLevel=false;
         break;
      }
      new_level= (_lineflags() & LEVEL_LF)+NEXTLEVEL_LF;
      _lineflags(HIDDEN_LF|new_level,HIDDEN_LF|LEVEL_LF);
      status=down();
      if (status) {
         doEndLastLevel=false;
         break;
      }
      if (p_line>last_line) {
         break;
      }
   }
   if (doEndLastLevel) {
      for (;;) {
         new_level= (_lineflags() & LEVEL_LF)+NEXTLEVEL_LF;
         if (new_level /*(_lineflags() & LEVEL_LF)*/<=start_level+NEXTLEVEL_LF) {
            break;
         }
         _lineflags(HIDDEN_LF|new_level,HIDDEN_LF|LEVEL_LF);
         status=down();
         if (status) break;
      }
   }
   p_line=last_line;
}
static void _show_lines(int first_line,last_line)
{
   p_line=first_line;
   up();
   if (p_line<=1) {
      p_line=0;
      new_level=0;
   } else {
      new_level=_lineflags()&LEVEL_LF;
      if(!up()) {
         new_level=_lineflags()&LEVEL_LF;
         down();
      } 
   }
   for (;;) {
      if (p_line>last_line) break;
      level=(_lineflags() & LEVEL_LF);
      _lineflags(new_level,HIDDEN_LF|LEVEL_LF|PLUSBITMAP_LF|MINUSBITMAP_LF);
      status=down();
      if (status) {
         break;
      }
      if (p_line>last_line) {
         break;
      }
   }
   p_line=last_line;
}

_command void show_selection(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_REQUIRES_AB_SELECTION)
{
   save_pos(p);
   hide_selection("",1);
   restore_pos(p);
}
_command void hide_selection(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_REQUIRES_AB_SELECTION)
{
   markid=arg(1);
   doshow=arg(2)!="";
   if (!select_active(markid)) {
      _message_box(get_message(TEXT_NOT_SELECTED_RC));
      return;
   }
   save_pos(p);
   _begin_select(markid);
   first_line=p_line;
   _end_select(markid);
   last_line=p_line;
   if (_select_type(markid)=='CHAR' && !_select_type(markid,'i')) {
      _get_selinfo(start_col,end_col,buf_id,markid);
      if (end_col==1) {
         --last_line;
      }
   }
   if (doshow) {
      _show_lines(first_line,last_line);
   } else {
      _hide_lines(first_line,last_line);
   }
   deselect(markid);
   restore_pos(p);

}
_command void selective_display() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   show('_seldisp_form',arg(1));
}  
static void hide_comments(...)
{
   prev_level=0;
   // Search for beginning of comments
   status=_clex_skip_blanks("h-");
   if (status) {
      top();
   } else {
      _end_line();  // Skip to end of line so we don't find comment after non-blank text.
      prev_level=_lineflags()&LEVEL_LF;
      _clex_find(COMMENT_CLEXFLAG,"O");
   }
   // Changed this release to put plus + on first line of comment.
   // This allows the user to more easily collapse comments separately
   // from functions
#if 1
   old_line=p_line;
   // IF there is nothing to collapse
   if (down()) {
      return;
   }
   _begin_line();search('[~ \t]|$','@rh');  // first_non_blank("h");
   // IF there is nothing to collapse
   if (_clex_find(0,'g')!=CFG_COMMENT) {
      return;
   }
#endif
   start_line=p_line;
   // Find end of comment
   status=_clex_skip_blanks("h");
   if (status) {
      bottom();
   } else {
      old_line=p_line;
      _clex_find(COMMENT_CLEXFLAG,"-O");
      // IF there is any non-comment or blank text on this line
      // This occurs when line starts with comment but after comment is some code.
      if (p_line==old_line) {
         up();
         // IF there is nothing to collapse
         if (p_line<=start_line) {
            return;
         }
      }
   }
   last_line=p_line;
   if (arg(1)!="") {
      _show_lines(start_line,last_line);
   } else {
      _hide_lines(start_line,last_line);
   }
}
int _OnUpdate_hide_code_block(CMDUI &cmdui,int target_wid,_str command) 
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   if(_isSelectCodeBlock_supported()) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command void hide_code_block() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   // Check to see if the very last command executed is the same command:
   expandBlock = 0;
   name = name_name( prev_index( '', 'C' ) );
   if ( name == "hide-code-block" ) expandBlock = 1;
   //say( '******* name='name );

   //Check if the first non-blank character of this line is a comment
   save_pos(p);
   first_non_blank();
   if (_clex_find(0,'g')==CFG_COMMENT) {
      hide_comments()
      return;
   }

   restore_pos(p);
   status=cs_hide_code_block( expandBlock );
   if (!status) {
      hide_selection();
      restore_pos(p);
   } else {
      _beep();
      sticky_message("Code block not found or language not supported");
   }

   // Make this command the last command executed:
   last_index( find_index( 'hide_code_block', COMMAND_TYPE ), 'C' );
}
_command void show_code_block() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   expandBlock = 0;
   name = name_name( prev_index( '', 'C' ) );
   if ( name == "show-code-block" ) expandBlock = 1;
   //Check if the first non-blank character of this line is a comment
   save_pos(p);
   _begin_line();search('[~ \t]|$','@rh');
   if (_clex_find(0,'g')==CFG_COMMENT) {
      hide_comments(1)
      return;
   }
   restore_pos(p);
   status=cs_hide_code_block( expandBlock );
   if (!status) {
      hide_selection("","1");
      restore_pos(p);
   } else {
      _beep();
      sticky_message("Code block not found or language not supported");
   }
   last_index( find_index( 'show-code-block', COMMAND_TYPE ), 'C' );
}
#if 0
_command void hide_all() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   top();
   // IF we are displaying the top of file line (line0)
   if (_default_option('t')) {
      // Put the plus sign there.
      up();
   } else {
      // IF there are not lines in this file.
      if (_on_line0()) {
         return;
      }
   }
   _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF);
   for (;;) {
      if ( down()) break;
      _lineflags(HIDDEN_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF);
   }
}
#endif
_command void show_all() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   save_pos(p);
   top();
   up();
   _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
   for (;;) {
      if ( down()) break;
      _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
   }
   restore_pos(p);
}

static void _hide_lines2(int start_skip_linenum,int end_exp_linenum)
{
   //say("s="start_skip_linenum" e="end_exp_linenum);if(start_skip_linenum==1) trace();
   save_pos(p);
   p_line=start_skip_linenum;
   new_level=(_lineflags() & LEVEL_LF)+NEXTLEVEL_LF;
   if (!up()) {
      if (!(_lineflags() & HIDDEN_LF)) {
         _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
      }
      down();
   }
   for (;p_line<=end_exp_linenum;) {
      _lineflags(HIDDEN_LF|new_level,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
      if (down()) break;
   }
   restore_pos(p);
}
static int find_directive(_str &directive,int find_first,boolean isdelphi)
{
   if (isdelphi) {
      if (find_first) {
         status=search('(\(\*|\{)\${ifdef|ifndef|ifopt|else|endif|define|undef}',"hr@");
         //status=search('(\(\*|\{)\${[a-zA-Z](\+|)}',"hr@");
      } else {
         status=repeat_search();
      }
      for (;;) {
         if (status) {
            return(status);
         }

         // IF we are not in a nested comment AND we are in a comment
         if (!(_lineflags()&MLCOMMENTLEVEL_LF) && _clex_find(0,'g')==CFG_COMMENT) {
            // IF we are not sure this is the start of the multi-line comment
            if (p_col!=1) {
               left();
               // IF we are in a line comment
               if (_clex_find(0,'g')==CFG_COMMENT) {
                  status=repeat_search();
                  continue;
               }
            }
            directive=get_text(match_length('0'),match_length('S0'));
#if 0
            if (pos(' 'directive' ',' ifdef ifndef ifopt else endif define undef ',1,'i')) {
               return(0);
            }
            ch=last_char(directive);
            // IF this is a compiler switch
            if (ch=='+' || ch=='-') {
               return(directive);
            }
#endif

            return(0);
         }
         status=repeat_search();
      }
   }
   if (find_first) {
      status=search('^ *\#([ \t]*)\c{ifdef|ifndef|if|elif|else|endif|define|undef}',"hr@");
      //status=search('^ *\#\c([ \t]*){if|elif|else|endif}','hr@');
   } else {
      status=repeat_search();
   }
   for (;;) {
      if (status) {
         return(status);
      }
      if (_clex_find(0,'g')==CFG_PPKEYWORD) {
         directive=get_text(match_length('0'),match_length('S0'));
         return(0);
      }
      status=repeat_search();
   }
}
/*
   Call this function after calling find_directive to 
   get directive parameters
*/
static void get_line_cont(_str &line,boolean isdelphi)
{
   if (isdelphi) {
      //p_col+=match_length('0');   // Skip over ppkeyword
      line=_expand_tabsc(p_col,-1,'E');
      parse line with '$' ppkeyword '[ \t]#','r' line '[~A-Za-z0-9_$+]','r';
      return;
   }
   //len=match_length('s')+match_length()+1;
   p_col+=match_length('0');   // Skip over ppkeyword
   line=_expand_tabsc(p_col,-1,'E');
   //line=get_text(_line_length()-match_length()-1,match_length('s')+match_length()+1);
   // Don't want to count trailing \ if comment on preprocessing line.
   old_len=length(line);
   parse line with line '//';
   // If there was not a line comment
   if (old_len==length(line)) {
      _end_line();
      for (;;) {
         RemoveLastChar=0;
         if (_clex_find(0,'g')!=CFG_COMMENT) {
            RemoveLastChar=(last_char(line)=='\');
            if (!RemoveLastChar) break;
         }
         p_col=1;
         down();
         get_line(line2);
         if (RemoveLastChar) {
            line=substr(line,1,length(line)-1);
         }
         old_len=length(line2);
         parse line2 with line2 '//';
         // If there was a line comment
         line=line:+line2;
         if (old_len!=length(line2)) break;
         _end_line();
      }
   }
   //messageNwait("get_line_cont: h2 line="line);
   /*
       Strip multiline comments
   */
   // Don't support Slick-C nested comments yet.
   // This does not support Slick-C strings with /* in them yet.
   // To do this we need to skip of strings.
   for (i=1;;) {
      i=pos('/*',line,i);
      if (!i) break;
      j=pos('*/',line,i+2);
      if (!j) {
         line=substr(line,1,i-1);
         break;
      }
      line=substr(line,1,i-1):+substr(line,j+2);
   }
   //messageNwait('get_line_cont: OUT line='line);
}
static int isopt(_str &define_names,_str name)
{
   return(pos('(^| )'_escape_re_chars(name)'\+',define_names,1,'r'));
}
static int isdefined(_str &define_names,_str name)
{
   return(pos('(^| )'_escape_re_chars(name)'(=([~ ]@)|)( |$)',define_names,1,'r'));
}
static void remove_define(_str &define_names,_str name)
{
   i=isdefined(define_names,name);
   if (i) {
      define_names=strip(substr(define_names,1,i-1):+" ":+
                         substr(define_names,i+pos('')));
      //messageNwait('remove_define: remove names='define_names);
   }
}
static void replace_defined_calls(_str &define_names,_str &exp)
{
   for (i=1;;) {
      //j=pos('(^|[~a-zA-Z0-9_]){defined[ \t]*\([ \t]*[ \t]*)}',exp,i,'r');
      j=pos('(^|[~a-zA-Z0-9_$]){defined[ \t]*\([ \t]*{[a-zA-Z0-9_$]*}[ \t]*\)}',exp,i,'r');
      //j=pos('(^|[~a-zA-Z0-9_]){defined\({V1}\)}',exp,i,'r');
      //messageNwait('replace_defined_calls: j='j);
      if (!j) {
         return;
      }
      name=substr(exp,pos('S1'),pos('1'));
      start=pos('S0');len=pos('0');
      result=isdefined(define_names,name);
      leftstr=substr(exp,1,start-1):+result;
      i=length(leftstr)+1;
      exp=leftstr:+substr(exp,start+len);
      //messageNwait('exp='exp);
   }
}

#define STATE0       0    /* No if has been processed. */
#define PROCESSCASE  1    /* last case was processed. */
#define SKIPCASE     2    /* last case was skipped. */
#define SKIPREST     4    /* Skip all cases that follow */
#define DIDELSE      16    /* Can have (SKIPREST|DIDELSE) or
                             (PROCESSCASE |DIDELSE)
                          */
/*
    Currently only C++ style preprocessing is supported.  Only
    C++ operators in the Slick-C language are supported
    including floating point.  Slick-C string operators are 
    not yet supported.
*/
_command void preprocess(...) name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   define_names=arg(1);
   warning="%s value not defined or not valid number.  Default value is 0";
   parse define_names with warnoption rest
   if (upcase(warnoption)=='+W') {
      define_names=rest;
   } else if (upcase(warnoption)=='-W') {
      define_names=rest;
      warning="";
   }
   if (!_preprocessing_supported()) {
      _message_box("Preprocessing is not supported for this file type");
      return;
   }
   ext=_bufnameNmode2ext(p_buf_name,p_mode_name);
   isdelphi=file_eq(ext,"pas");
   already_warned_list="";
   save_pos(p);
   mou_hour_glass(1);
   show_all();
   top();
   state=STATE0;
   state_stack='';
   status=find_directive(directive,1,isdelphi);
   start_skip_linenum=0;
   for (;;) {
      if (status) {
         break;
      }
      state_change=1;
      switch (directive) {
      case 'if':     // Not Delphi
      case 'ifdef':
      case 'ifndef':
      case 'ifopt':  // Delphi only
         state_stack=strip(state' 'state_stack);
         start_exp_linenum=p_line;
         //messageNwait('preprocess: start='p_line);
         get_line_cont(exp,isdelphi);
         end_exp_linenum=p_line;
         if (state&(SKIPCASE|SKIPREST)) {
            new_state=SKIPREST;
         } else {
            switch (directive) {
            case 'if':
               result=0;
               replace_defined_calls(define_names,exp);
               status=eval_exp(result,exp,10,define_names,0,warning,already_warned_list);
               break;
            case 'ifdef':
               parse exp with name .
               result=isdefined(define_names,name);
               break;
            case 'ifndef':
               parse exp with name .
               result=!isdefined(define_names,name);
               break;
            case 'ifopt':
               parse exp with name .;
               if(last_char(name)=='+') {
                  name=strip(name,"T","+");
                  result=isopt(define_names,name);
               } else {
                  name=strip(name,"T","-");
                  result=!isopt(define_names,name);
               }
               break;
            }
            new_state=(result)?PROCESSCASE:SKIPCASE;
         }
         break;
      case 'elif':
         start_exp_linenum=p_line;
         get_line_cont(exp,isdelphi);
         end_exp_linenum=p_line;
         switch (state) {
         case SKIPCASE:
            result=0;
            replace_defined_calls(define_names,exp);
            status=eval_exp(result,exp,10,define_names,0,warning,already_warned_list);
            new_state=(result)?PROCESSCASE:SKIPCASE;
            break;
         case PROCESSCASE:
            new_state=SKIPREST;
            break;
         case SKIPREST:
            new_state=SKIPREST;
            break;
         default:
            //Error
            new_state=state;
         }
         break;
      case 'else':
         start_exp_linenum=end_exp_linenum=p_line;
         if (state & DIDELSE) {
            // ERROR
            new_state=state;
         } else {
            switch (state) {
            case SKIPCASE:
               new_state=PROCESSCASE|DIDELSE;
               break;
            case PROCESSCASE:
               new_state=SKIPREST|DIDELSE;
               break;
            case SKIPREST:
               new_state=SKIPREST;
               break;
            default:
               //Error
               new_state=state;
            }
         }
         break;
      case 'endif':
         start_exp_linenum=end_exp_linenum=p_line;
         if (!state) {
            // Error
            new_state=state;
         } else {
            parse state_stack with new_state state_stack;
         }
         break;
      case 'define':
         state_change=0;
         get_line_cont(line,isdelphi);
         parse line with name exp;
         if (isinteger(exp) || hex2dec(exp)!="") {
            remove_define(define_names,name);
            define_names=define_names' 'name'='exp;
            //messageNwait('preprocess: define_names='define_names);
         } else {
            define_names=define_names' 'name;
         }
         break;
      case 'undef':
         get_line_cont(line,isdelphi);
         parse line with name .
         remove_define(define_names,name);
         //messageNwait('preprocess: undef='define_names);
         state_change=0;
         break;
      }
      //messageNwait('state='state' new='new_state' start='start_exp_linenum' end='end_exp_linenum);
      if (state_change) {
         if ((state&(SKIPCASE|SKIPREST)) ) {
            if ((new_state&PROCESSCASE) || new_state==STATE0) {
               _hide_lines2(start_skip_linenum,end_exp_linenum);
            }
         } else {
            // STATE0 or PROCESSCASE
            if (new_state & (SKIPCASE|SKIPREST)) {
               start_skip_linenum=start_exp_linenum;
            } else {
               _hide_lines2(start_exp_linenum,end_exp_linenum);
            }
         }
         state=new_state;
      }
      _end_line();
      status=find_directive(directive,0,isdelphi);
   }
   mou_hour_glass(0);
   restore_pos(p);
}
static _str _get_define_names() 
{
   ext=_bufnameNmode2ext(p_buf_name,p_mode_name);
   isdelphi=file_eq(ext,"pas");
   already_found_names=" ";
   already_found_opt_names=" ";
   save_pos(p);
   top();
   mou_hour_glass(1);
   define_names="";
   status=find_directive(directive,1,isdelphi);
   get_view_id(orig_view_id);
outerloop:
   for (;;) {
      if (status) {
         break;
      }
      state_change=1;
      switch (directive) {
      case "ifdef":
      case "ifndef":
         get_line_cont(exp,isdelphi);
         parse exp with name .;
         if (!pos(" "name" ",already_found_names)) {
            result=_message_box(nls("Define %s?",name),nls("Found #%s %s",directive,name),MB_YESNOCANCEL|MB_ICONQUESTION);
            already_found_names=" "name:+already_found_names;
            if (result==IDYES) {
               define_names=strip(define_names" "name);
            } else if (result==IDNO) {
            } else {
               break outerloop;
            }
         }
         break;
      case "ifopt":
         get_line_cont(exp,isdelphi);
         parse exp with name .;
         parse name with name '[+-]','r';
         if (!pos(" "name" ",already_found_opt_names)) {
            result=_message_box(nls("Is switch '%s' on?",name),nls("Found option #ifopt %s",name),MB_YESNOCANCEL|MB_ICONQUESTION);
            already_found_opt_names=" "name:+already_found_opt_names;
            if (result==IDYES) {
               define_names=strip(define_names" "name"+");
            } else if (result==IDNO) {
            } else {
               break outerloop;
            }
         }
         break;
      case "if":
      case "elif":
         get_line_cont(exp,isdelphi);
         last_was_defined=0;
         for (i=1;;) {
            j=pos("{[A-Za-z0-9_$]#}",exp,i,"r");
            //j=pos("{[A-Za-z_$][A-Za-z0-9_$]@}",exp,i,"r");
            if (!j) {
               break;
            }
            if (isdigit(substr(exp,j,1))) {
               i=j+pos('0');
               continue;
            }
            //messageNwait('exp='exp' name='name);
            name=substr(exp,pos('S0'),pos('0'));
            rest=strip(substr(exp,j+length(name)));
            // Skip defined( or macro(
            //messageNwait('_get_define_names: rest='rest);
            if (substr(rest,1,1)!='(') {
               if (!pos(" "name" ",already_found_names)) {
                  if (last_was_defined) {
                     result=_message_box(nls("Define %s?",name),nls("Found #%s ...defined(%s)...",directive,name),MB_YESNOCANCEL|MB_ICONQUESTION);
                     already_found_names=" "name:+already_found_names;
                     if (result==IDYES) {
                        define_names=strip(define_names" "name);
                     } else if (result==IDNO) {
                     } else {
                        break outerloop;
                     }
                  } else {
                     result = show('-modal _textbox_form',
                                   nls("Found %s in if/elif expression",name),  // Form caption
                                   0, //flags
                                   '',   //use default textbox width
                                   '',   //Help item.
                                   '',   //Font (not yet supported)
                                   '',   //Retrieve Name
                                   nls("Value for %s",name)":0"
                                  );
                     if (result=='') {
                        break outerloop;
                     }
                     if (!isnumber(_param1)) {
                        _param1=0;
                     }
                     define_names=strip(define_names" "name"="strip(_param1));
                     already_found_names=" "name:+already_found_names;
                  }
                  last_was_defined=0;
               }
            } else if (name=='defined') {
               last_was_defined=1;
            }
            i=j+length(name);
         }
         break;
      case "else":
      case "endif":
         break;
      case "define":
         get_line_cont(line,isdelphi);
         break;
      case "undef":
         break;
      }
      _end_line();
      status=find_directive(directive,0,isdelphi);
   }
   activate_view(orig_view_id);
   mou_hour_glass(0);
   restore_pos(p);
   return(define_names);
}

typeless old_search_flags;
_str
   old_search_string
   ,old_word_re
   ,old_replace_string;

_command void all(...) name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   recording_macro=_macro();
   /* Restore word_re */
   restore_search old_search_string,old_search_flags,'['p_word_chars']';
   old_search_flags = (old_search_flags &~(WRAP_SEARCH|POSITIONONLASTCHAR_SEARCH|INCREMENTAL_SEARCH|NO_MESSAGE_SEARCH));
   if ( arg()>1 ) {
      // Default search options for case and re etc. not used when
      // this function is called with two arguments. This is so that
      // user defined keyboard macros work correctly when default
      // search options are changed.
      old_search_string=arg(1);old_search_flags=arg(2);
   } else if ( arg(1)=='' || arg(1)=='/' ) {
      old_search_string=prompt('',nls('All Search For'));
      old_search_flags=prompt('',nls('All Options'));
   } else {
      donot=0;
      arg1=arg(1);
      if (substr(arg1,1,1)=='~') {
         donot=1;
         arg1=substr(arg1,2);
      }
      parse arg1 with  1 delim +1 old_search_string (delim) search_flags
      if (donot) {
         _macro('m',recording_macro);
         _macro_delete_line();
         _macro_call('allnot',old_search_string,old_search_flags);
         allnot(old_search_string,search_flags);
         return;
      }
      old_search_flags=search_flags;
      old_search_flags=make_search_options(_default_option('s')&(WRAP_SEARCH|IGNORECASE_SEARCH|RE_SEARCH|UNIXRE_SEARCH)):+old_search_flags;
   }
   _macro('m',recording_macro);
   _macro_delete_line();
   _macro_call('all',old_search_string,old_search_flags);

   if (old_search_string:=='') status=STRING_NOT_FOUND_RC;
   dohide_all=1;

   save_pos(p);

   top();
   if (!_default_option('t')) {
      // IF there are 0 or 1 lines in this file.
      if (_on_line0() || down()) {
         restore_pos(p);
         search_flags_str=old_search_flags;   //Dan Added here
         save_search junk,old_search_flags,old_word_re;
         _menu_add_searchhist(old_search_string,search_flags_str);
         return;
      }
      _begin_line();
   }
   mou_hour_glass(1);
   status=search(old_search_string,'h@'old_search_flags);
   if (status) {
      _beep();
      message(get_message(STRING_NOT_FOUND_RC));
   }
   for (;;) {
      if (status) break;
      if (dohide_all) {
         save_pos(p2);
         top();
         if (_default_option('t')) {
            up();
            _lineflags(NEXTLEVEL_LF,HIDDEN_LF|LEVEL_LF|PLUSBITMAP_LF|MINUSBITMAP_LF);
         }
         for (;;) {
            if ( down()) break;
            _lineflags(HIDDEN_LF|NEXTLEVEL_LF,HIDDEN_LF|LEVEL_LF|PLUSBITMAP_LF|MINUSBITMAP_LF);
         }
         restore_pos(p2);
         dohide_all=0;
      }
      up();
      if (!(_lineflags()&HIDDEN_LF)) {
         _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
      }
      down();
      if (down()) {
         _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
         break;
      }
      if (_lineflags() & HIDDEN_LF) {
         up();
         _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
      } else {
         up();
      }
      status=repeat_search();
   }

   maybe_plus_first_line();
   mou_hour_glass(0);

   search_flags_str=old_search_flags;   //Dan Added here
   save_search junk,old_search_flags,old_word_re
   _menu_add_searchhist(old_search_string,search_flags_str);
   restore_pos(p);
   //return(status)
}
/*
   This command currently only pefectly supports selective display created
   by the all, allnot, less commands.
*/   
_command void more(...) name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   recording_macro=_macro();
   /* Restore word_re */
   restore_search old_search_string,old_search_flags,'['p_word_chars']';
   old_search_flags = (old_search_flags &~(WRAP_SEARCH|POSITIONONLASTCHAR_SEARCH|INCREMENTAL_SEARCH|NO_MESSAGE_SEARCH));
   if ( arg()>1 ) {
      // Default search options for case and re etc. not used when
      // this function is called with two arguments. This is so that
      // user defined keyboard macros work correctly when default
      // search options are changed.
      old_search_string=arg(1);old_search_flags=arg(2);
   } else if ( arg(1)=='' || arg(1)=='/' ) {
      old_search_string=prompt('',nls('All Search For'));
      old_search_flags=prompt('',nls('All Options'));
   } else {
      arg1=arg(1);
      parse arg1 with  1 delim +1 old_search_string (delim) search_flags;
      old_search_flags=search_flags;
      old_search_flags=make_search_options(_default_option('s')&(WRAP_SEARCH|IGNORECASE_SEARCH|RE_SEARCH|UNIXRE_SEARCH)):+old_search_flags;
   }
   _macro('m',recording_macro);
   _macro_delete_line();
   _macro_call('more',old_search_string,old_search_flags);

   if (old_search_string:=='') status=STRING_NOT_FOUND_RC;

   save_pos(p);

   top();
   if (!_default_option('t')) {
      // IF there are 0 or 1 lines in this file.
      if (_on_line0() || down()) {
         restore_pos(p);
         search_flags_str=old_search_flags;   //Dan Added here
         save_search(junk,old_search_flags,old_word_re);
         _menu_add_searchhist(old_search_string,search_flags_str);
         return;
      }
      _begin_line();
   }
   mou_hour_glass(1);
   status=search(old_search_string,'h@'old_search_flags);
   for (;;) {
      if (status) break;
      lf=_lineflags();
      if ((lf&HIDDEN_LF) && 
          !(lf & (PLUSBITMAP_LF|MINUSBITMAP_LF)) /*&& !(lf&LEVEL_LF)*/) {
         // Make sure the line below is at the same level
         if(down()) {
            _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
            break;
         }
         lf2=_lineflags();
         if ((lf2 & (HIDDEN_LF|PLUSBITMAP_LF|MINUSBITMAP_LF|LEVEL_LF))==
             (lf & (HIDDEN_LF|PLUSBITMAP_LF|MINUSBITMAP_LF|LEVEL_LF))
            ) {
            up();
            level=(lf &LEVEL_LF)-NEXTLEVEL_LF;
            if (level<0) level=0;
            _lineflags(PLUSBITMAP_LF|level,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
         } else {
            up();
            _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
         }
         up();
         if (_lineflags() & (PLUSBITMAP_LF|MINUSBITMAP_LF)) {
            _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
         }
         down();
      }
      _end_line();
      status=repeat_search();
   }

   maybe_plus_first_line();
   mou_hour_glass(0);

   search_flags_str=old_search_flags;   //Dan Added here
   save_search junk,old_search_flags,old_word_re
   _menu_add_searchhist(old_search_string,search_flags_str);
   restore_pos(p);
   //return(status)
}
_command void less(...) name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   recording_macro=_macro();
   if ( arg()>1 ) {
      // Default search options for case and re etc. not used when
      // this function is called with two arguments. This is so that
      // user defined keyboard macros work correctly when default
      // search options are changed.
      old_search_string=arg(1);search_options=arg(2);
      less=(arg(3)!="");
   } else if ( arg(1)=='' || arg(1)=='/' ) {
      old_search_string=prompt('',nls('All Search For'));
      old_search_flags=prompt('',nls('All Options'));
   } else {
      parse arg(1) with  1 delim +1 old_search_string (delim) search_options;
      search_options=make_search_options(_default_option('s')&(WRAP_SEARCH|IGNORECASE_SEARCH|RE_SEARCH|UNIXRE_SEARCH)):+search_options;
   }
   _macro('m',recording_macro);
   _macro_delete_line();
   _macro_call('less',old_search_string,search_options);
   allnot(old_search_string,search_options,1);
}
_command void allnot() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   recording_macro=_macro();
   /* Restore word_re */
   restore_search(old_search_string,old_search_flags,'['p_word_chars']');
   //old_search_flags= (old_search_flags &~(WRAP_SEARCH|POSITIONONLASTCHAR_SEARCH|INCREMENTAL_SEARCH|NO_MESSAGE_SEARCH));
   doless=false;
   if ( arg()>1 ) {
      // Default search options for case and re etc. not used when
      // this function is called with two arguments. This is so that
      // user defined keyboard macros work correctly when default
      // search options are changed.
      old_search_string=arg(1);search_options=arg(2);
      doless=(arg(3)!="");
   } else if ( arg(1)=='' || arg(1)=='/' ) {
      old_search_string=prompt('',nls('All Search For'));
      old_search_flags=prompt('',nls('All Options'));
   } else {
      parse arg(1) with  1 delim +1 old_search_string (delim) search_options;
      search_options=make_search_options(_default_option('s')&(WRAP_SEARCH|IGNORECASE_SEARCH|RE_SEARCH|UNIXRE_SEARCH)):+search_options;
   }
   _macro('m',recording_macro);
   _macro_delete_line();
   _macro_call('allnot',old_search_string,search_options);

   save_pos(p);

   top();
   mou_hour_glass(1);
   if (!doless) {
      show_all();
   }
   status=search(old_search_string,'h@'search_options);
   for (;;) {
      if (status) break;
      up();
      if (!(_lineflags()&HIDDEN_LF)) {
         new_level=(_lineflags() & LEVEL_LF)+NEXTLEVEL_LF;
         _lineflags(PLUSBITMAP_LF|(new_level-NEXTLEVEL_LF),PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
         down();
      } else {
         new_level=(_lineflags() & LEVEL_LF);
         down();
      }
      _lineflags(HIDDEN_LF|new_level,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
      _end_line();
      status=repeat_search();
   }

   //maybe_plus_first_line();
   mou_hour_glass(0);

   save_search junk,old_search_flags,old_word_re
   _menu_add_searchhist(old_search_string,search_options);
   restore_pos(p);
   //return(status)
}

void e_find_lastprocparam()
{
   c_find_lastprocparam();
   return;
}
void c_find_lastprocparam()
{
   orig_line=p_line;
   // Find open paren
   status=search('(','h@');
   //reset_all();
   //stop();
   for (;;) {
      if (status) {
         p_line=orig_line;
         return;
      }
      cfg=_clex_find(0,'g');
      if (cfg!=CFG_COMMENT && cfg!=CFG_STRING) {
         break;
      }
      status=repeat_search();
   }
   // Search for close paren
   right();
   nesting=1;
   status=search('[()]','rh@');
   for (;;) {
      if (status) {
         p_line=orig_line;
         return;
      }
      cfg=_clex_find(0,'g');
      if (cfg!=CFG_COMMENT && cfg!=CFG_STRING) {
         switch (get_text()) {
         case ")":
            --nesting;
            if (!nesting) return;
            break;
         case "(":
            ++nesting;
         }
      }
      status=repeat_search();
   }
}

//static _ProcOnlySearch2(ext,index,findfirst)
//{
//   seekpos=_nrseek();
//   for (;;) {
//      proc_name="";
//      status=call_index(proc_name,findfirst,ext,seekpos,index);
//      if (status) {
//         return(status);
//      }
//      //parse proc_name with name '(' idtype ')'
//      //if (idtype=='' || pos('proc',idtype)) {
//      //   return(0);
//      //}
//      tag_tree_decompose_tag(proc_name, name, dc, idtype, df);
//      if (tag_tree_type_is_func(idtype) && (idtype:!='proto')) {
//         return(0);
//      }
//      findfirst=0;
//   }
//}

_command show_procs(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_REQUIRES_TAGGING)
{
   seldisp_flags=arg(1);
   if (seldisp_flags=="") {
      seldisp_flags=def_seldisp_flags;
   }
   ext=p_extension;
   //index=find_index('vs'ext'_list_tags',PROC_TYPE);
   proc_search_index=find_index(ext'_proc_search',PROC_TYPE);
   if ( ! index_callable(proc_search_index) ) {
      _message_box('Function scanning not supported for files of this extension.  Make sure support module is loaded.')
      return('');   //No support for this extension
   }
   find_lastprocparam_index=find_index(ext'_find_lastprocparam',PROC_TYPE);
   if (!index_callable(find_lastprocparam_index) ) find_lastprocparam_index=0;

   // get the line numbers from the context info
   mou_hour_glass(1);
   _UpdateContext(true);
   //say("show_procs");

   save_pos(p);
   top();up();
   old_lastparam_linenum=p_line;
   if (!_default_option('t')) ++old_lastparam_linenum;
   boolean done_status=false;
   int num_context_tags = tag_get_num_of_context();
   for (i=1; !done_status; i++) {
      // only do this for functions
      tag_get_detail2(VS_TAGDETAIL_context_type, i, tag_type);
      if (i > num_context_tags) {
         linenum=p_Noflines;
         done_status=true;
         bottom(); down();
         done_hidden_linenum=p_Noflines;
      } else if (!tag_tree_type_is_func(tag_type)) {
         continue;
      } else {
         tag_get_detail2(VS_TAGDETAIL_context_line, i, linenum);
         p_RLine=linenum;p_col=1;

         //messageNwait("show_procs: h1");
         next_linenum=p_line;
         done_hidden_linenum=next_linenum-1;
         if (seldisp_flags & (SELDISP_COLLAPSEPROCCOMMENTS|SELDISP_SHOWPROCCOMMENTS)) {
            save_search(s1,s2,s3,s4);
            old_col=p_col;
            /*
               Process comments separately from function 
            */
            up();
            end_comment_line=p_line;
            _end_line();
            // Look for a non-blank character
            status=search("[^ \t]","@-rh");
            //messageNwait("show_procs: status="status" p_line="p_line);
            // If we found a non-blank character and
            //    it is comment text
            if (!status && _clex_find(0,'g')==CFG_COMMENT) {
               //messageNwait("show_procs: h2");
               // Skip blank lines and comments
               if (_clex_skip_blanks("h-")) {
                  // There is at least one line of comments
                  // We hit top of file.
                  top();up();
               }
               down();start_comment_line=p_line;
               // If we did skip any comments
               if (p_line<end_comment_line-1) {
                  //messageNwait("show_procs: h3");
                  _begin_line();
                  // Now skip over blank lines to find start of comments
                  status=search("^~([ \t]*$)","r@h");
                  if (!status && p_line<end_comment_line) {
                     start_comment_line=p_line;
                  }
               }
               if (start_comment_line<=end_comment_line) {
                  if (start_comment_line==end_comment_line) {
                     _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
                  } else {
                     //messageNwait("show_procs: start="start_comment_line" end="end_comment_line);
                     p_line=start_comment_line;
                     if ((seldisp_flags&SELDISP_COLLAPSEPROCCOMMENTS)) {
                        _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
                        down();
                        for (;p_line<=end_comment_line;) {
                           _lineflags(HIDDEN_LF|NEXTLEVEL_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
                           if (down()) break;
                        }
                     } else {
                        _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
                        down();
                        for (;p_line<=end_comment_line;) {
                           _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
                           if (down()) break;
                        }
                     }
                  }
               }
               done_hidden_linenum=start_comment_line-1;
            }
            p_col=old_col;
            restore_search(s1,s2,s3,s4);
         }
      }
      if (old_lastparam_linenum<done_hidden_linenum) {
         //_hide_lines(old_lastparam_linenum,done_hidden_linenum);
         p_line=old_lastparam_linenum;
         _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
         down();
         for (;p_line<=done_hidden_linenum;) {
            _lineflags(HIDDEN_LF|NEXTLEVEL_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
            if (down()) break;
         }
      }
      if (done_status) {
         break;
      }
      p_line=next_linenum;
      //messageNwait("show_procs: next_linenum="next_linenum);
      if (find_lastprocparam_index) {
         //message('p_line='p_line);  //delay(100);clear_message();
         save_search(a,b,c,d);
         call_index(find_lastprocparam_index);
         restore_search(a,b,c,d);
      }
      old_lastparam_linenum=p_line;
   }

   mou_hour_glass(0);
   //maybe_plus_first_line();
   clear_message();
   restore_pos(p);
}
static void maybe_plus_first_line()
{
   top();
   if (_default_option('t')) up();
   status=down();
   if (status) return;
   if (_lineflags() & HIDDEN_LF) {
      up();
      _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF|LEVEL_LF);
   }
}
_command show_col1() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   all('^[~ \t]','r');
}

   _nocheck _control ctlLimit;

#define UserSelDispParent   ctlok.p_user
defeventtab _SelDispControls_form
ctlscan.lbutton_up()
{
   _nocheck _control ctlok;
   _macro('m',_macro('s'))
   _macro_append('define_names=_get_define_names();');
   ctldefines.p_text=UserSelDispParent._get_define_names();
   ctldefines._set_sel(1);
   ctldefines._set_focus();
}
void ctlCheckLimit.lbutton_up()
{
   ctlLimit.p_enabled=(p_value!=0);
   ctlLimit.p_next.p_enabled=(p_value!=0);
}
void ctlshowcomments.lbutton_up()
{
   if (p_window_id==ctlshowcomments) {
      if (ctlcollapsecomments.p_value) {
         ctlcollapsecomments.p_value=0;
      }
      return;
   }
   if (ctlshowcomments.p_value && ctlcollapsecomments.p_value) {
      ctlshowcomments.p_value=0;
   }
}

static void _FormGetMessage2(_str ControlName)
{
   _nocheck _control ctlhelplabel;
   string=_FormGetMessage('_SelDispControls_form',ControlName);
   ctlhelplabel.p_caption=ctlhelplabel.p_user:+"\r\r"string;
}
static _str _FormGetMessage(_str FormName,_str ControlName)
{
   index=find_index(FormName,oi2type(OI_FORM));

   firstchild=child=index.p_child;
   if (child) {
      for (;;) {
         if (child.p_name==ControlName){
            return(child.p_message);
         }
         child=child.p_next;
         if (child==firstchild) break;
      }
   }
   return("");
}
_nocheck _control ctlHideMatchedLines,ctlre,ctlmatchcase,ctlwarning;
_nocheck _control ctlcollapsecomments,ctlshowcomments;
_nocheck _control ctldefines,ctlsearchstring,ctlmatchword;
_nocheck _control ctlResetSelDisp;
defeventtab _seldisp_form
ctlok.on_create()
{
   options=arg(1);
   for (;;) {
      parse options with option options;
      if (option=='') {
         break;
      }
      if (lowcase(option)=='-df') {
         ctlshowprocs.p_enabled=false;
      }
   }
   _macro('m',_macro('s'));
   _macro_delete_line();
   UserSelDispParent=_form_parent();
   ctlhelplabel.p_user=ctlhelplabel.p_caption;
   // Load child pictures
   index=find_index('_SelDispControls_form',oi2type(OI_FORM));
   firstchild=child=index.p_child;
   if (child) {
      for (;;) {
         if (child.p_object!=OI_IMAGE) {
            //form_wid=_load_template(index, _mdi, 'HA', 1);
            // Center the form to the MDI window while the form is invisible
            form_wid=_load_template(child,_control ctlsettings,'H');
            form_wid._center_window();
            form_wid.p_y+=60;
         }
         child=child.p_next;
         if (child==firstchild) break;
      }
   }
   // This removes duplicates.  However, if we delete lines
   // below, there may be a duplicate because the lines are
   // not adjacent.
   ctldefines._retrieve_list();  
   ctlsearchstring._retrieve_list();
   // Remove blank lines from ctldefines combo box list.
   p_window_id=ctldefines.p_cb_list_box;
   Nofhits=0;_lbtop();
   for (;;) {
      status=_lbsearch("");
      if (status) {
         if (!Nofhits) {
            break;
         }
         _lbtop();Nofhits=0;
         break;
      } else {
         _lbdelete_item();
         ++Nofhits;
      }
   }

   p_window_id=ctlok;
   if (def_seldisp_flags&SELDISP_SHOWPROCCOMMENTS) {
      ctlshowcomments.p_value=1;
   } else if (def_seldisp_flags&SELDISP_COLLAPSEPROCCOMMENTS) {
      ctlcollapsecomments.p_value=1;
   }
   _retrieve_prev_form();
   if (ctlpreprocess.p_value) {
      if (!UserSelDispParent._preprocessing_supported()) {
         ctlsearch.p_value=1;
      }
   }

   ctlHideSelection.p_enabled=(UserSelDispParent.select_active2())
   if (!ctlHideSelection.p_enabled && ctlHideSelection.p_value) {
      ctlsearch.p_value=1;
   }
   if (!UserSelDispParent._preprocessing_supported()) {
      ctlpreprocess.p_enabled=0;
   }
   if (ctlsearchstring.p_text:=='') {
      flags=_default_option('s');
      ctlmatchcase.p_value= (int)!(flags & IGNORECASE_SEARCH);
      ctlmatchword.p_value=flags & WORD_SEARCH;
      ctlre.p_value=flags & (RE_SEARCH|UNIXRE_SEARCH);
   }
   if (ctlLimit.p_text=="") {
      ctlLimit.p_text=def_seldisp_maxlevel;
   }
   if (def_seldisp_flags & SELDISP_EXPANDSUBLEVELS) {
      ctlExpandSubLevels.p_value=1;
   } else if (def_seldisp_flags & SELDISP_COLLAPSESUBLEVELS) {
      ctlCollapseSubLevels.p_value=1;
   } else {
      ctlRememberSubLevels.p_value=1;
   }
}
_seldisp_form.on_load()
{
   ctlsearch.call_event(ctlsearch,LBUTTON_UP);
} 
ctlok.lbutton_up()
{
   _macro('m',_macro('s'))
   if (ctlpreprocess.p_value && ctldefines.p_text!='') {
      _append_retrieve(ctldefines,ctldefines.p_text);
   }
   if (ctlsearch.p_value) {
      if (ctlmatchcase.p_value) {
         search_options= '';
      } else {
         search_options='I';
      }
      if (ctlmatchword.p_value) {
         search_options=search_options'W';
      }
      if (ctlre.p_value) {
         if (def_re_search==UNIXRE_SEARCH) {
            search_options=search_options'U';
         } else {
            search_options=search_options'R';
         }
      }
      if (ctlsearchstring.p_text:!='') {
         if (ctlHideMatchedLines.p_value) {
            if (ctlResetSelDisp.p_value) {
               _macro_call('allnot',ctlsearchstring.p_text,search_options);
               UserSelDispParent.allnot(ctlsearchstring.p_text,search_options);
            } else {
               _macro_call('less',ctlsearchstring.p_text,search_options);
               UserSelDispParent.less(ctlsearchstring.p_text,search_options);
            }
         } else {
            if (ctlResetSelDisp.p_value) {
               _macro_call('all',ctlsearchstring.p_text,search_options);
               UserSelDispParent.all(ctlsearchstring.p_text,search_options);
            } else {
               _macro_call('more',ctlsearchstring.p_text,search_options);
               UserSelDispParent.more(ctlsearchstring.p_text,search_options);
            }
         }
         _append_retrieve(ctlsearchstring,ctlsearchstring.p_text);
      }
   /*} else if (ctlshowcol1.p_value) {
      _macro_call('show_col1');
      UserSelDispParent.show_col1();*/
   } else if (ctlshowprocs.p_value) {
      flags=get_seldisp_flags();
      _macro_call('show_procs',flags);
      UserSelDispParent.show_procs(flags);
   } else if (ctlpreprocess.p_value) {
      warning="";
      if (!ctlwarning.p_value) {
         warning="-W ";
      }
      _macro_call('preprocess',warning:+ctldefines.p_text);
      UserSelDispParent.preprocess(warning:+ctldefines.p_text);
   } else if (ctlHideSelection.p_value) {
      _macro_call('hide_selection');
      UserSelDispParent.hide_selection();
   } else if (ctlMultiLevel.p_value) {
      _nocheck _control ctlbraces,ctlLimit;
      limitlevels="";
      if (ctlLimit.p_enabled) {
         limitlevels=ctlLimit.p_text;
      }
      if (ctlbraces.p_value) {
         if (limitlevels!="") {
            _macro_call('show_braces',limitlevels);
         } else {
            _macro_call('show_braces');
         }
         UserSelDispParent.show_braces(limitlevels);
      } else {
         if (limitlevels!="") {
            _macro_call('show_indent',limitlevels);
         } else {
            _macro_call('show_indent');
         }
         UserSelDispParent.show_indent(limitlevels);
      }
   } else if (ctlParagraphs.p_value) {
      _macro_call('show_paragraphs');
      UserSelDispParent.show_paragraphs();
   }
   _save_form_response();

   cur_flag=def_seldisp_flags & (SELDISP_EXPANDSUBLEVELS|SELDISP_COLLAPSESUBLEVELS);
   if (ctlExpandSubLevels.p_value) {
      new_flag_str="SELDISP_EXPANDSUBLEVELS";
      new_flag=SELDISP_EXPANDSUBLEVELS;
      ctlExpandSubLevels.p_value=1;
   } else if (ctlCollapseSubLevels.p_value) {
      new_flag_str="SELDISP_COLLAPSESUBLEVELS";
      new_flag=SELDISP_COLLAPSESUBLEVELS;
   } else {
      new_flag=0;
      ctlRememberSubLevels.p_value=1;
   }
   if (cur_flag!=new_flag) {
      _macro_append('def_seldisp_flags&=~(SELDISP_EXPANDSUBLEVELS|SELDISP_COLLAPSESUBLEVELS);');
      _macro_append('def_seldisp_flags|='new_flag_str';');
      def_seldisp_flags&=~(SELDISP_EXPANDSUBLEVELS|SELDISP_COLLAPSESUBLEVELS);
      def_seldisp_flags|=new_flag;
      _config_modify|=CFGMODIFY_DEFVAR;
   }

   p_active_form._delete_window(0);


}
ctlsearch.lbutton_up()
{
   _nocheck _control ctlMultiLevelPic,ctlPreprocessPic,ctlFunctionPic,ctlSearchPic;
   _nocheck _control ctlNoSettings;
   hit_one=0;
   ctlSearchPic.p_visible=(ctlsearch.p_value!=0);
   if (ctlsearch.p_value) {
      _FormGetMessage2("ctlSearchMsg");
      ctlsearch._set_focus();
      hit_one=1;
   }
   ctlFunctionPic.p_visible=(ctlshowprocs.p_value!=0);
   if (ctlshowprocs.p_value) {
      ctlshowprocs._set_focus();
      _FormGetMessage2("ctlFunctionMsg");
      hit_one=2;
   }
   ctlPreprocessPic.p_visible=(ctlpreprocess.p_value!=0);
   if (ctlpreprocess.p_value) {
      _FormGetMessage2("ctlDefineMsg");
      ctlpreprocess._set_focus();
      hit_one=3;
   }
   ctlMultiLevelPic.p_visible=(ctlMultiLevel.p_value!=0);
   if (ctlMultiLevel.p_value) {
      ctlMultiLevel._set_focus();
      _FormGetMessage2("ctlMultiLevelMsg");
      hit_one=4;
   }
   ctlNoSettings.p_visible=hit_one==0;
   if (ctlParagraphs.p_value) {
      ctlParagraphs._set_focus();
      _FormGetMessage2("ctlParagraphsMsg");
   }
   if (ctlHideSelection.p_value) {
      ctlHideSelection._set_focus();
      _FormGetMessage2("ctlHideSelectionMsg");
   }
#if 0
   if (ctlsearch.p_value) {
      value=1;
   } else {
      value=0;
   }
   ctlResetSelDisp.p_enabled=ctlmatchcase.p_enabled=ctlmatchword.p_enabled=
                          ctlre.p_enabled=ctlsearchstring.p_enabled=value;
   if (ctlpreprocess.p_value) {
      ctlscan.p_enabled=ctldefines.p_prev.p_enabled=ctldefines.p_enabled=ctlwarning.p_enabled=1;
   } else {
      ctlscan.p_enabled=ctldefines.p_prev.p_enabled=ctldefines.p_enabled=ctlwarning.p_enabled=0;
   }
   ctlsavesettings.p_enabled=ctlshowcomments.p_enabled=ctlcollapsecomments.p_enabled=ctlshowprocs.p_value!=0;
#endif
}
#if 0
ctlsavesettings.lbutton_up()
{
   def_seldisp_flags=get_seldisp_flags();
   _config_modify|= CFGMODIFY_DEFVAR;
   save_config();
   _macro('m',_macro('s'));
   _macro_append("_config_modify|= CFGMODIFY_DEFVAR;");
   _macro_append("def_seldisp_flags="def_seldisp_flags";");
}
#endif
static int get_seldisp_flags()
{
   if (ctlshowcomments.p_value) {
      return(SELDISP_SHOWPROCCOMMENTS);
   } else if (ctlcollapsecomments.p_value) {
      return(SELDISP_COLLAPSEPROCCOMMENTS);
   }
   return(0);
}

struct LEVELINFO {
   int OpenBraceLineNum;
   int PrevLevel;
};
void _ShowLevels(int (*pfnFind)(int firstfirst,boolean &FoundStart),int maxlevel)
{
   save_pos(p);
   //mou_hour_glass(1);
   //show_all();
   options="";
   if (p_lexer_name!="") {
      options="xcs";  // Exclude comments and strings
   } 
   top();
   level=0;
   LastLineSameLevel=0;
   LEVELINFO stack[];
   findfirst=1;
   maxlevel=vsIndex2Level(maxlevel);
   for (;;) {
      //status=search('\{|\}','h@r'options);
      status=(*pfnFind)(findfirst,FoundStart);
      if (!status && FoundStart) {
         //messageNwait("show_braces: { stlen="stack._length());
         OpenBraceLineNum=p_line;
         p_line=LastLineSameLevel;
         hidden_lf=0;
         if (stack._length()) {
            hidden_lf=HIDDEN_LF;
         } 
         for (;p_line<=OpenBraceLineNum;) {
            _lineflags(hidden_lf|level,HIDDEN_LF|LEVEL_LF|PLUSBITMAP_LF|MINUSBITMAP_LF)
            if(down())break;
         }
         p_line=OpenBraceLineNum;
         hidden_lf=HIDDEN_LF;
         LEVELINFO *plevelinfo;
         plevelinfo=&stack[stack._length()];
         plevelinfo->OpenBraceLineNum=OpenBraceLineNum;
         plevelinfo->PrevLevel=level;
         if (OpenBraceLineNum>=LastLineSameLevel && level<maxlevel) {
            level+=NEXTLEVEL_LF;
         }
         LastLineSameLevel=OpenBraceLineNum+1;

      } else {
         // IF there is a previous level
         if (stack._length()) {
            //messageNwait("show_braces: } l="p_line"status="status);
            if (status) {
               CloseBraceLineNum=p_Noflines+1;
               if (LastLineSameLevel>p_Noflines) {
                  CloseBraceLineNum=p_line;
               } else {
                  p_line=LastLineSameLevel;
               }
            } else {
               CloseBraceLineNum=p_line;
               p_line=LastLineSameLevel;
            }
            for (;p_line<CloseBraceLineNum;) {
               //messageNwait('level='level' l='p_line);
               _lineflags(HIDDEN_LF|level,HIDDEN_LF|LEVEL_LF|PLUSBITMAP_LF|MINUSBITMAP_LF)
               if(down()) break;
            }
            p_line=CloseBraceLineNum;
            // End the previous level
            while ((stack._length() && status) || !status) {
               hidden_lf=HIDDEN_LF;
               if (stack._length()<=1) {
                  hidden_lf=0;
               }
               LEVELINFO levelinfo;
               levelinfo=stack[stack._length()-1];
               stack._deleteel(stack._length()-1);
               // IF level number changed for this brace pair AND
               //    there is at least one line inside these braces
               if (levelinfo.PrevLevel!=level &&
                   levelinfo.OpenBraceLineNum+1<CloseBraceLineNum) {
                  orig_line=p_line;
                  p_line=levelinfo.OpenBraceLineNum;
                  //messageNwait('open level='levelinfo.PrevLevel' l='p_line);
                  _lineflags(PLUSBITMAP_LF|hidden_lf|levelinfo.PrevLevel,HIDDEN_LF|LEVEL_LF|PLUSBITMAP_LF|MINUSBITMAP_LF)
                  p_line=orig_line;
               }
               level=levelinfo.PrevLevel;
               if (CloseBraceLineNum>LastLineSameLevel) {
                  LastLineSameLevel=CloseBraceLineNum;
               }
               if (!status) {
                  break;
               }
            }
            if (status) {
               break;
            }
         }
         if (status) {
            p_line=LastLineSameLevel;
            for (;;) {
               //messageNwait('close level='level' l='p_line);
               _lineflags(level,HIDDEN_LF|LEVEL_LF|PLUSBITMAP_LF|MINUSBITMAP_LF)
               if(down()) break;
            }
            break;
         }
      }
      findfirst=0;
   }
   
   //mou_hour_glass(0);
   //maybe_plus_first_line();
   p_line=0;
   pm= _lineflags()&(PLUSBITMAP_LF|MINUSBITMAP_LF);
   if (pm==PLUSBITMAP_LF) {
      plusminus();
      //if (!_default_option('t')) {
      //   _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|HIDDEN_LF);
      //}
   } 

   restore_pos(p);
}
static _str gFindOptions;
static int _FindBraces(int findfirst,boolean &FoundStart)
{
   if (findfirst) {
      gFindOptions="";
      if (p_lexer_name!="") {
         gFindOptions="xcs";  // Exclude comments and strings
      } 
   } else {
      right();
   }
   status=search('\{|\}','h@r'gFindOptions);
   FoundStart=get_text()=='{';
   return(status);
}
_command show_braces(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   maxlevel=arg(1);
   if (!isinteger(maxlevel)) maxlevel=def_seldisp_maxlevel;
   _ShowLevels(_FindBraces,maxlevel);
}
static int gstate;
static int gNewIndent;
static int gStackIndent[];

static int GetNextIndent()
{
   orig_line=p_line;
   if (p_line!=1 /*|| _default_option('t')*/) {
      if(down()) {
         return(0);
      }
   }
   // Skip blank lines
   for (;;) {
      get_line(line);
      if (line!="") {
         break;
      }
      if(down()) return(0);
   }
   i=verify(line," \t");
   // Remember first non-blank column
   Indent=_text_colc(i,'I');
   p_line=orig_line;
   return(Indent);
}
static int _FindIndent(int findfirst,boolean &FoundStart)
{
   if (findfirst) {
      gStackIndent._makeempty();
      /*if (!_default_option('t')) {
         p_line=1;p_col=1;
      } else {*/
         p_line=0;p_col=1;
      //}
      gStackIndent[0]=GetNextIndent();
      FoundStart=true;
      gstate=0;
      return(0);
   }
   if (gstate==1) {
      if (gStackIndent._length()<=0) {
         gStackIndent[0]=GetNextIndent();
         FoundStart=true;
      } else {
         TopIndent=gStackIndent[gStackIndent._length()-1];
         if (gNewIndent<TopIndent) {
            gStackIndent._deleteel(gStackIndent._length()-1);
            FoundStart=false;
            //messageNwait("_FindIndent: close l="p_line);
            return(0);
         }
         if (gNewIndent>TopIndent) {
            //messageNwait("st=1 _FindIndent: open l="p_line" g="gNewIndent" t="TopIndent);
            FoundStart=true;
            gstate=2;
            //messageNwait("_FindIndent: got here");
            gStackIndent[gStackIndent._length()]=gNewIndent;
            return(0);
         }
      }
   }
   if (!gstate && (1 /*p_line!=1 || _default_option('t')*/)) {
      if(down()) {
         return(1);
      }
   }
   // Skip blank lines
   for (;;) {
      get_line(line);
      if (line!="") {
         break;
      }
      if(down()) return(1);
   }
   i=verify(line," \t");
   // Remember first non-blank column
   gNewIndent=_text_colc(i,'I');
   
   TopIndent=gStackIndent[gStackIndent._length()-1];
   //messageNwait("_FindIndent: gNewIndent="gNewIndent" TopIndent="TopIndent);
   if (gNewIndent<TopIndent) {
      up();
      //messageNwait("_FindIndent: state=1");
      gstate=1;
      return(_FindIndent(0,FoundStart));
   }
   for (;;) {
      // Skip lines with the same indent
      get_line(line);
      if (line=="") {
         if(down()) {
            return(1);
         }
         continue;
      }
      i=verify(line," \t");
      NextIndent=_text_colc(i,'I');
      if (gNewIndent!=NextIndent) {
         /*if (!gStackIndent._length()) {
            messageNwait('got here');
         } */
         if (NextIndent>gNewIndent /*|| !gStackIndent._length()*/) {
            up();
            FoundStart=true;
            gstate=0;
            gStackIndent[gStackIndent._length()]=NextIndent;
            //messageNwait("_FindIndent: open l="p_line" g="gNewIndent" t="TopIndent);
            return(0);
         } 
         gNewIndent=NextIndent;
         gstate=1;
         return(_FindIndent(0,FoundStart));
      }
      if(down()) {
         return(1);
      }
   }
   return(0);
}
_command void show_indent(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   maxlevel=arg(1);
   if (!isinteger(maxlevel)) maxlevel=def_seldisp_maxlevel;
   _ShowLevels(_FindIndent,maxlevel);
}
_command void show_paragraphs(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   save_pos(p);
   mou_hour_glass(1);
   top();up();
   _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|LEVEL_LF|HIDDEN_LF);
   if (down()) {
      mou_hour_glass(0);
      restore_pos(p);
      return;
   }
   // Skip blank lines
   for (;;) {
      get_line(line);
      if (line!="") break;
      _lineflags(0,PLUSBITMAP_LF|MINUSBITMAP_LF|LEVEL_LF|HIDDEN_LF);
      if (down()) {
         status=1;
         break;
      }
   }
   status=0;
   for (;;) {
      // Put plus on first line of paragraph
      _lineflags(PLUSBITMAP_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|LEVEL_LF|HIDDEN_LF);
      // Hide lines that follow that are not blank
      for (;;) {
         if(down()) {
            status=1;
            break;
         }
         get_line(line);
         if (line=="") break;
         _lineflags(HIDDEN_LF|NEXTLEVEL_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|LEVEL_LF|HIDDEN_LF);
      }
      if (status) {
         break;
      }
      // Skip blank lines
      for (;;) {
         get_line(line);
         if (line!="") break;
         _lineflags(HIDDEN_LF|NEXTLEVEL_LF,PLUSBITMAP_LF|MINUSBITMAP_LF|LEVEL_LF|HIDDEN_LF);
         if (down()) {
            status=1;
            break;
         }
      }
      if (status) {
         break;
      }
   }
   mou_hour_glass(0);
   restore_pos(p);
}
