/*
$VerboseHistory: slickc.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:12a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:12a
 * Comment:
 * Added support for Explorer style open dialog.
 * 
 * Fixed _nocomment_search function so that it
 * would not longer get into an infinite loop.
 * This fixed problem where editor hungup when
 * listing tags for awk or rexx.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:34p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
/*
  Options for SLICK-C syntax expansion/indenting may be accessed from SLICK's
  file extension setup menu (CONFIG, "File extension setup...").

  The extension specific options is a string of five numbers separated
  with spaces with the following meaning:

    Position       Option
       1             Minimum abbreviation.  Defaults to 1.  Specify large
                     value to avoid abbreviation expansion.
       2             reserved.
       3             begin/end style.  Begin/end style may be 0,1, or 2
                     as show below.  Add 4 to the begin end style if you
                     want braces inserted when syntax expansion occurs
                     (main and do insert braces anyway).  Typing a begin
                     brace, '{', inserts an end brace when appropriate
                     (unless you unbind the key).  If you want a blank
                     line inserted in between, add 8 to the begin end
                     style.  Default is 4.

                      Style 0
                          if () {
                             ++i;
                          }

                      Style 1
                          if ()
                          {
                             ++i;
                          }

                      Style 2
                          if ()
                            {
                            ++i;
                            }


       4             Indent first level of code.  Default is 1.
                     Specify 0 if you want first level statements to
                     start in column 1.
       5             (reserved)
       6             Indent CASE from SWITCH.  Default is 0.  Specify
                     1 if you want CASE statements indented from the
                     SWITCH statement. Begin/end style 2 not supported.
*/
#include 'slick.sh'

#define STYLE1_FLAG 1
#define STYLE2_FLAG 2
#define BRACE_INSERT_FLAG 4
#define BRACE_INSERT_LINE_FLAG 8
#define NO_SPACE_BEFORE_PAREN 16   // "if(" or "if ("

static int recurse;
int suffix_cmd()
{
   if (recurse) return(1);
   status=load_files('+c +v');
   if ( ! status ) {
      top;get_line(line);
      parse line with '/*' +0 startcomment
      if (startcomment!='') {
         index=find_index('rexx-mode',COMMAND_TYPE);
         if (!index) {
            //if (machine()!='OS2386') return(1);
            status=check_and_load_support('cmd',index);
            if (status) return(1);
         }
         ++recurse;
         rexx_mode();
         --recurse;
      } else {
         _quit_view();
         return(1);
         //++recurse;
         //fundamental_mode();
         //--recurse;
      }
      _quit_view();
      return(0);
   }
   return(1);
}
/*
    Note that this function is really here to check if a .sh file
    is really a UNIX Bourne Shell source file.
*/
int suffix_e()
{
   if (recurse) return(1);
   status=load_files('+c +v');
   if ( ! status ) {
      top;get_line(line);
      parse line with '#!' +0 startcomment
      startcomment = strip_filename(startcomment,'P');
      if (startcomment=='sh' || startcomment=='bash' ||
                 startcomment=='ksh' || startcomment=='zsh' 
                 ) {
         ++recurse;
         select_edit_mode("bourneshell");
         --recurse;
      } else if (startcomment=='csh' || startcomment=='tcsh') {
         ++recurse;
         select_edit_mode("csh");
         --recurse;
      } else {
         ++recurse;
         select_edit_mode("e");
         --recurse;
      }
      _quit_view();
      return(0);
   }
   return(1);
}
int suffix_fundamental()
{
   if (recurse) return(1);
   status=load_files('+c +v');
   if ( ! status ) {
      top;
      int lineLength;
      lineLength = _line_length();
      if (lineLength > 1000) {
         line = get_text(1000);
      } else {
         get_line(line);
      }
      parse line with '#!' +0 startcomment .
      startcomment = strip_filename(startcomment,'P');
      if (startcomment=='perl') {
         check_and_load_support('pl',setup_index,'.pl');
         ++recurse;
         perl_mode();
         --recurse;
      } else if (startcomment=='sh' || startcomment=='bash' ||
                 startcomment=='ksh' || startcomment=='zsh' 
                 ) {
         ++recurse;
         select_edit_mode("bourneshell");
         --recurse;
      } else if (startcomment=='csh' || startcomment=='tcsh') {
         ++recurse;
         select_edit_mode("csh");
         --recurse;
      } else {
         ++recurse;
         fundamental_mode();
         --recurse;
      }
      _quit_view();
      return(0);
   }
   return(1);
}

_command void rexx_star() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY)
{
   keyin(last_event());
   if (!command_state() && p_line==1 && file_eq(get_extension(p_buf_name),'cmd')) {
      suffix_cmd();
   }
}
_command void rexx_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   ++recurse;
   select_edit_mode('cmd')
   --recurse;
}

_command void html_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode('html');
}
_command void slickc_mode() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY|VSARG2_ICON)
{
   select_edit_mode(substr(_macro_ext,2))
}
_command void slick_enter() name_info(','VSARG2_CMDLINE|VSARG2_ICON|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl . indent_case .
   if (command_state() || p_window_state:=='I' ||
      p_SyntaxIndent<0 || p_indent_style!=INDENT_SMART ||
      _in_comment(1) ||
         _c_expand_enter(p_SyntaxIndent,expand,be_style,indent_fl,indent_case) ) {
      call_root_key(ENTER)
   } else if (_argument=='') {
      _undo 'S'
   }
}
_command void slick_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   was_space=(last_event():==' ')
   parse name_info(_edit_window().p_index) with . expand . . be_style indent_fl .
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      slick_expand_space(p_SyntaxIndent,be_style,indent_fl) ) {
      if ( was_space ) {
         if ( command_state() ) {
            call_root_key(' ')
         } else {
            keyin ' ';
         }
      }
   } else if (_argument=='') {
      _undo 'S'
   }
}

   /* Words must be in sorted order */
#define EXPAND_WORDS (' #define #elif #else #endif #error #if #ifdef #ifndef':+\
                ' #include #pragma #undef _buffer _command const def defeventtab':+\
                ' else typedef _str struct static union ')

static _str space_words[]={'#define', '#elif',  '#else',   '#endif','#error', '#if',
                          '#ifdef',  '#ifndef','#include','#pragma','#undef','_buffer',
                          '_command','break',  'case',    'const',  'continue','def',
                          'default','defeventtab','definit','defload','defmain',
                          'defproc','do','else','for','if','return',' static',
                          'struct','switch','typedef','_str','union','while'};

static _str slick_expand_space(syntax_indent,be_style,indent_fl)
{
   status=0;
   get_line(orig_line);
   line=strip(orig_line,'T');
   orig_word=strip(line);
   if ( p_col!=text_col(line)+1 ) {
      return(1);
   }
   if_special_case=0;
   aliasfilename='';
   word=min_abbrev2(orig_word,space_words,name_info(p_index),aliasfilename);
   if (aliasfilename!=''&&word!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         _insert_text(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   if ( word=='') {
      // Check for } else
      parse orig_line with first_word second_word rest
      if (first_word=='}' && second_word!='' && rest=='' && second_word:==substr('els',1,length(second_word))) {
         keyin(substr('else ',length(second_word)+1));
         return(0)
      }
      // Check for else if or } else if
      if (first_word=='else' && orig_word==substr('else if',1,length(orig_word))) {
         word='else if';
         if_special_case=1;
      } else if (second_word=='else' && rest!='' && orig_word==substr('} else if',1,length(orig_word))) {
         word='} else if';
         if_special_case=1;
      } else if (first_word=='}else' && second_word!='' && orig_word==substr('}else if',1,length(orig_word))) {
         word='}else if';
         if_special_case=1;
      } else {
         return(1);
      }
   }
   maybespace=(be_style & NO_SPACE_BEFORE_PAREN)?'':' ';
   line=substr(line,1,length(line)-length(orig_word)):+word;
   width=text_col(line,length(line)-length(word)+1,'i')-1;
   style1=be_style & STYLE1_FLAG;
   style2=be_style & STYLE2_FLAG;
   e1=' {';
   if (! (word=='do' && !style2 && !style1) ) {
      if ( (be_style & (STYLE1_FLAG|STYLE2_FLAG)) ||
         ! (be_style & BRACE_INSERT_FLAG) ) {
         e1='';
      }
   }
   if ( word=='main' ) {
      status=c_insert_main()
   } else if ( word=='if' || if_special_case) {
      replace_line line:+maybespace:+'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( word=='for' ) {
      replace_line line:+maybespace'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( word=='while' ) {
      replace_line line:+maybespace'()'e1
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( (word=='public' || word=='private')) {
      replace_line(line':');_end_line();
      _c_do_colon();
   } else if ( word=='switch' ) {
      replace_line(line:+maybespace'()'e1);
      maybe_insert_braces(syntax_indent,be_style,width,word)
   } else if ( word=='do' ) {
      // Always insert braces for do loop unless braces are on separate
      // line from do and while statements
      replace_line(line:+e1);
      if ( ! style2 ) {
         if (style1 ) {
            insert_line(indent_string(width)'{');
         }
         insert_line(indent_string(width)'} while':+maybespace'(  );');
         up();
      } else if ( style2 ) {
         if (be_style & BRACE_INSERT_FLAG) {
            insert_line(indent_string(width+syntax_indent)'{');
            insert_line(indent_string(width+syntax_indent)'}');
            insert_line(indent_string(width)'while':+maybespace'(  );');
            up(2);
            syntax_indent=0;
         } else {
            insert_line(indent_string(width)'while'maybespace:+'(  );');
            up(1);
            //syntax_indent=0
         }
      }
      nosplit_insert_line();
      p_col=p_col+syntax_indent;
   } else if ( word=='printf' ) {
      replace_line(indent_string(width)'printf("');
      _end_line();
   } else if ( word=='return' ) {
      if (orig_word=='return') {
         keyin(' ');
      } else {
         replace_line(indent_string(width)'return');
         _end_line();
      }
   } else if ( word=='continue' || word=='break' ) {
      // Slick-C allows labels to follow continue or break
#if 1
      if (orig_word==word) {
         replace_line(indent_string(width)word' ');
      } else {
         replace_line(indent_string(width)word);
      }
#endif
      //replace_line indent_string(width)word' '
      _end_line();
   } else if ( word=='case' ) {
      if ( name_on_key(ENTER):=='nosplit-insert-line' ) {
         replace_line(indent_string(width)word' :');
         _end_line;_c_do_colon();p_col=p_col-1;
         if ( ! _insert_state() ) _insert_toggle();
      } else {
#if 1
         // Code which inserts case
         replace_line(indent_string(width)word' :');
         _end_line();_c_do_colon();_rubout();
#else
         // Code which inserts case and colon and
         // puts user in insert mode.
         replace_line(indent_string(width)word' :');
         _end_line();_c_do_colon();p_col=p_col-1;
         if ( ! _insert_state() ) _insert_toggle();
#endif
      }
   } else if ( word=='default' ) {
      replace_line(indent_string(width)word':');_end_line();
      _c_do_colon();
   } else if ( pos(' 'word' ',EXPAND_WORDS) ) {
      replace_line indent_string(width)word' '
      _end_line
   } else if ( pos(' 'word' ',' definit defload defmain ') ) {
      replace_line(word'()');
      insert_line('{');
      insert_line('}');
      up();insert_line('');p_col=syntax_indent+1;
   } else {
     status=1;
   }
   return(status);
}
static _str prev_stat_has_semi()
{
   status=1
   up;
   if ( ! rc ) {
      col=p_col;_end_line;get_line line
      parse line with line '\#|/\*','r'
      /* parse line with line '{' +0 last_word */
      /* parse line with first_word rest */
      /* status=stat_has_semi() or line='}' or line='' or last_word='{' or first_word='case' */
      status=last_char(strip(line))!=')' && ! pos('(\}|)else$',strip(line),1,'r')
      down
      p_col=col
   }
   return(status)
}
static _str stat_has_semi()
{
   get_line line
   parse line with line '/*'
   line=strip(line,'T')
   name=name_on_key(ENTER)
   return(last_char(line):==';' &&
            (
               ! (( name=='split-insert-line' ||
                     (name=='maybe-split-insert-line' && _insert_state())
                    ) && (p_col<=text_col(line) && arg(1)=='')
                   )
            )
         )

}
static void maybe_insert_braces(syntax_indent,be_style,width,word)
{
   col=width+length(word)+3
   if (be_style & NO_SPACE_BEFORE_PAREN) --col;
   if ( be_style & STYLE2_FLAG ) {
      width=width+syntax_indent
   }
   if ( be_style & BRACE_INSERT_FLAG ) {
      up_count=1
      if ( be_style & (STYLE1_FLAG|STYLE2_FLAG) ) {
         up_count=up_count+1
         insert_line  indent_string(width)'{'
      }
      if ( be_style & BRACE_INSERT_LINE_FLAG ) {
         up_count=up_count+1
         insert_line indent_string(width+syntax_indent)
      }
      insert_line indent_string(width)'}'
      up up_count;
   }
   p_col=col
   if ( ! _insert_state() ) { _insert_toggle }
}

_command  int gui_find_proc() name_info(','VSARG2_REQUIRES_MDI)
{
   status=_e_MaybeBuildTagFile(tfindex);
   if (!status) {
      _macro_delete_line();
      for (;;) {
         result = show('-modal -reinit _tagbookmark_form',"","","e");
         if (result == '') {
            return(COMMAND_CANCELLED_RC)
         }
         status = find_proc(result);
         if(status != 1) {  /* Tag not found? */
            _macro('m',_macro('s'))
            _macro_call('find_proc', result);
            return(status);
         }
         orig_buf_id = p_buf_id;
         status = load_files('+b .command');
         if (!status) {
            bottom();
            status = search("\\@cb _tagbookmark_form.ctlTag", 'r-');
            _delete_line(); up(); _delete_line();
            p_buf_id = orig_buf_id;
         }
      }
      return(0);
   }
   result=_list_matches2(
                  'Find Procedure',   // title
                  SL_VIEWID|SL_SELECTPREFIXMATCH|SL_COMBO|SL_MUSTEXIST|SL_MATCHCASE,        // flags
                  '',       // buttons
                  'gui_find_proc',   // help_item
                  '',       // font
                  '',       // callback
                  'find_proc',       // retrieve_name
                  MACROTAG_ARG,  // completion
                  '',       // min list width
                  EVENTTAB_TYPE|PCB_TYPE|oi2type(OI_FORM)
                  );
   if (result=='') {
      return(COMMAND_CANCELLED_RC)
   }
   return(find_proc(result));
}
static void _UntagSlickCFile(_str filename)
{
   filename=absolute(filename);
   if (get_extension(filename)=="") {
      filename=filename:+_macro_ext;
   }
   int tfindex=find_index('def-tagfiles-e',MISC_TYPE);
   if (!tfindex) {
      return;
   }
   _str tagfile_list=_replace_envvars(name_info(tfindex));
   boolean doRefresh=false;
   for (;;) {
      _str tagfilename=next_tag_file2(tagfile_list,false,true);
      if (tagfilename=="") {
         break;
      }
      int status=tag_get_date(filename,junk);
      if (!status) {
         status=tag_open_db(tagfilename);
         if (!status) {
            doRefresh=true;
            tag_remove_from_file(filename,1);
            tag_close_db(tagfilename,1);
            _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX,tagfilename);
         }
      }
   }
   if (doRefresh) {
      _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
   }
}
static void _MaybeTagSlickCFile(_str filename,int tfindex)
{
   filename=absolute(filename);
   if (get_extension(filename)=="") {
      filename=filename:+_macro_ext;
   }
   _str vsroot=get_env("VSROOT");
   // IF this file is not within this installation of VSE AND
   //    this macro file is from a different VSE installation
   _str path=strip_filename(filename,'N');
   if (!file_eq(vsroot,substr(filename,1,length(vsroot))) &&
                (file_match('-p 'maybe_quote_filename(path):+"emulate.ex",1)!=''
                ||
                 file_match('-p 'maybe_quote_filename(path):+"emulate.e",1)!=''
                )
                ) {
      // DON'T tag this file
      return;
   }
   date_of_file=_file_date(filename,'B');
   _str tagfile_list=_replace_envvars(name_info(tfindex));
   _str tagfilename;
   for (;;) {
      tagfilename=next_tag_file2(tagfile_list,false,true);
      if (tagfilename=="") {
         break;
      }
      status=tag_get_date(filename,date_tagged);
      if (!status) {
         if (date_tagged==date_of_file) {
            return;
         }
      }
   }
   status=_open_temp_view(filename,temp_view_id,orig_view_id);
   if (!status) {
      tagfile_list=_replace_envvars(name_info(tfindex));
      tagfilename=next_tag_file2(tagfile_list);
      if (tagfilename!="") {
         status=tag_open_db(tagfilename);
         if (!status) {
            select_edit_mode();
            RetagCurrentFile();
            tag_close_db(tagfilename,1);
            _TagCallList(TAGFILE_MODIFIED_CALLBACK_PREFIX,tagfilename);
            _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
         }
      }
      _delete_temp_view(temp_view_id);
      activate_view(orig_view_id);
   }
}
int _e_MaybeBuildTagFile(int &tfindex)
{
   ext='e';
   tfindex=find_index('def-tagfiles-'ext,MISC_TYPE);
   // IF the user does not have an extension specific tag file for Slick-C
   status=0;
#if __UNIX__
   //tagfilename=absolute(_macro_path():+'uslickc.vtg');
   tagfilename=absolute(_config_path():+'uslickc.vtg');
#else
   //tagfilename=absolute(_macro_path():+'slickc.vtg');
   tagfilename=absolute(_config_path():+'slickc.vtg');
#endif
   if (!tfindex || name_info(tfindex)=='' || 
       tag_read_db(tagfilename)==FILE_NOT_FOUND_RC) {
      // Tag the Slick-C macros
      tag_close_db(tagfilename);
      //status=tag_create_db(filename);
      slickc_filename=macro_path_search('maketags'_macro_ext);
      if (slickc_filename=="") {
         slickc_filename=macro_path_search('maketags'_macro_ext'x');
      }
      if (slickc_filename!='') {
         path=strip_filename(slickc_filename,'n');
         status=shell('maketags -n "Slick-C Run-Times" -o 'maybe_quote_filename(tagfilename)' 'maybe_quote_filename(path:+'*.e')' 'maybe_quote_filename(path:+'*.sh'));
         if (!status) {
#if __UNIX__
            otherfiles=maybe_quote_filename(path:+'sysobjs.e')' ':+
                       maybe_quote_filename(path:+'vusrobjs.e')' ':+
                       maybe_quote_filename(path:+'vusrdefs.e')' ':+
                       maybe_quote_filename(path:+'vusrs*.e');
#else
            otherfiles=maybe_quote_filename(path:+'usysobjs.e')' ':+
                       maybe_quote_filename(path:+'vunxobjs.e')' ':+
                       maybe_quote_filename(path:+'vunxdefs.e')' ':+
                       maybe_quote_filename(path:+'vunxs*.e');
#endif
            status=shell('maketags -d -o 'maybe_quote_filename(tagfilename)' 'otherfiles);
         }
         if (!tfindex) {
            tfindex=insert_name('def-tagfiles-'ext,MISC_TYPE,_encode_vsroot(tagfilename,true,false));
         } else {
            set_name_info(tfindex,_encode_vsroot(tagfilename,true,false));
         }
         _config_modify|=CFGMODIFY_DEFDATA;
         _TagCallList(TAGFILE_ADD_REMOVE_CALLBACK_PREFIX,'','');
         _TagCallList(TAGFILE_REFRESH_CALLBACK_PREFIX);
         //stop();
         //_message('abort');
         //return(0);
      } else {
         status=1;
      }

   }
   return(status);
}
/* You can replace this procedure by copying this source into */
/* another macro module and loading the module. */
/* Have this function return a non-zero number if you want */
/* no special processing on main keyword. */
_command fp,find_proc() name_info(MACROTAG_ARG','VSARG2_REQUIRES_MDI)
{
   name=strip(prompt(arg(1)));
   parse name with option rest;
   boolean useNamesTable=false;
   // IF use names table
   if (lowcase(option)=='-n') {
      useNamesTable=true;
      name=rest;
   }
   parse name with help_name type_name;
   //help_name=translate(help_name,'-','_');
   //if ( type_name=='' ) {
     type=PROC_TYPE|COMMAND_TYPE|oi2type(OI_FORM)|EVENTTAB_TYPE;
   /*} else {         
     type=eq_name2value(type_name,PCB_TYPES)
     if ( type=='' ) {
       message nls("Unknown  type.  Use '?' to list types.")
       return(1)
     }
   }
   */
   index= find_index(help_name,type)
   if (!useNamesTable) {
      status=_e_MaybeBuildTagFile(tfindex);
      if (!status) {
         module_name='';
         filename='';
         // Tag any potential new file if necessary
         if(name_type(index)&(OBJECT_TYPE|EVENTTAB_TYPE) &&
            !(type2oi(name_type(index))==OI_MENU)){
             filename=_find_form_eventtab(help_name,true);
         } else if ( index && ! ((name_type(index) & (PROC_TYPE|COMMAND_TYPE)) &&
                            ! index_callable(index)) ) {
           module_index= index_callable(index);
           module_name=name_name(module_index);
         } else {
            /*if (_isEditorCtl()) {
               filename=p_buf_name;
            } */
         }
         if (_isEditorCtl()) {
            ext=get_extension(p_buf_name)
            if ( _modename_eq(p_mode_name,"slick-c") &&
                (file_eq('.'ext,_macro_ext) || file_eq(ext,'sh')) ) {
                _MaybeTagSlickCFile(p_buf_name,tfindex);
            }
         }
         if (module_name!='') {
            module_name=substr(module_name,1,length(module_name)-1);
            //messageNwait('module_name='module_name);
            filename= path_search(module_name,'VSLICKMACROS');
            //if (filename=="") slick_path_search(module_name);
         }
         //messageNwait('filename='filename);
         if (filename!='') {
            _MaybeTagSlickCFile(filename,tfindex);
         }
         // This code isn't the greatest 
         if(name_type(index)&(DLLCALL_TYPE)){
            return(find_tag('-sc 'help_name));
         }
         return(find_tag('-e e 'help_name));
      }

   }


  /* check if this is a macro procedure or command. */
  index= find_index(help_name,type)
  if(name_type(index)&(DLLCALL_TYPE)){
     return(find_tag(name));
  }
  if(name_type(index)&(OBJECT_TYPE|EVENTTAB_TYPE)){
      status=_find_form_eventtab(help_name);
      return(status);
  } else if ( index && ! ((name_type(index) & (PROC_TYPE|COMMAND_TYPE)) &&
                     ! index_callable(index)) ) {
    /* check if it is unique. */
    if ( find_index(help_name,type & ~name_type(index)) ) {
      command_put('find-proc')
      name=list_matches(help_name,'pcbNt',nls('Select a procedure to find'))
      _cmdline.set_command '',1;cursor_data
      if ( name=='' ) return(COMMAND_CANCELLED_RC);
      parse name with help_name type_name
      type=eq_name2value(type_name,PCB_TYPES)
      index=find_index(help_name,type)
    }
    module_index= index_callable(index)
    module_name=name_name(module_index)
    if ( module_name=='' ) {
       //proc_name=translate(help_name,'_','-')
       //return(find_tag(proc_name));
       status=nls('No source for %s',help_name)
    } else {
       status=search_for_proc(module_name,help_name);
    }
    if ( status ) {
       _message_box(status)
    }
  } else {
     proc_name=translate(help_name,'_','-');
     mark=_alloc_selection()
     status=(mark<0)?mark:0;
     if ( ! status ) {
        _select_char(mark);
        save_pos(p);
        top();
        status=e_proc_search(proc_name,1)
        if ( ! status ) {
           _free_selection(mark);
           linenum=p_line;col=p_col;
           restore_pos(p);
           goto_line(linenum);p_col=col;
           return(0)
        }
        _begin_select mark
        _free_selection mark
     }
     help_name=translate(help_name,'_','-');
     if (h_match_exact(help_name)!='') {
        return(help(help_name));
     }
     _message_box(nls("Can't find proc '%s'",help_name))
     //return(find_tag(proc_name));
  }
  return(status)

}
_str search_for_proc(module_name,proc_name)
{
  proc_name= translate(proc_name,'_','-');
  ext=get_extension(module_name);
  if ( ! file_eq('.'ext,_macro_ext) ) {
     module_name= substr(module_name,1,length(module_name)-length(ext)-1):+_macro_ext
  }
  filename= slick_path_search(module_name)
  if ( filename=='' ) {
    return(nls("File '%s' not found",module_name));
  }
  /* check if file exists in memory already */
  rc=edit('+b 'absolute(filename));
  file_exists= ! rc;
  if ( ! file_exists ) {
    clear_message();
    status= edit(maybe_quote_filename(filename));
    if ( status ) {
      return(get_message(status));
    }
  } else {
    top();
  }
  save_pos(p);
  status=e_proc_search(proc_name,1)
  if ( ! status ) {
     linenum=p_line;col=p_col;
     restore_pos(p);
     goto_line(linenum);p_col=col;
     return(0)
  }
  if ( ! file_exists ) { call quit() }
  return(nls("Could not find procedure '%s' in '%s'",proc_name,filename))

}
_command set_var() name_info(VAR_ARG','VSARG2_EDITORCTL)
{
   parse arg(1) with var_name ' ' content
   var_name=prompt(var_name)
   index=find_index(var_name,VAR_TYPE|BUFFER_TYPE)
   if ( ! index ) {
     message nls("Can't find variable '%s'",var_name)
     return(1)
   }
   if ( content=='' ) {
      typeless *pv;
      pv= &_get_var(index);
      format=pv->_varformat();
      if (format==VF_HASHTAB || format==VF_ARRAY) {
         // Assume variable is modified.
         if (substr(var_name,1,3)=='def') {
            _config_modify|=CFGMODIFY_DEFVAR;
         } else {
            _config_modify|=CFGMODIFY_MUSTSAVESTATE;
         }
         if (name_name(index)=='def-cfgfiles') {
            _config_modify|=CFGMODIFY_MUSTSAVESTATE;
         }
         show('_var_editor_form',var_name,pv);
         return(0)
      }
      if (format==VF_EMPTY) {
         if ( get_string(content,nls('Variable value(EMPTY):')' ',';.set_var','') ) {
            return 1
         }
      } else {
         if ( get_string(content,nls('Variable value:')' ',';.set_var',_get_var(index)) ) {
            return 1
         }
      }
   }
   if (substr(var_name,1,3)=='def') {
      _config_modify|=CFGMODIFY_DEFVAR;
   } else {
      _config_modify|=CFGMODIFY_MUSTSAVESTATE;
   }
   name=name_name(index);
   if ((name=='def-cfgfiles' && def_cfgfiles)||
       (name=="def-localsta" && def_localsta)) {
      _config_modify|=CFGMODIFY_MUSTSAVESTATE;
   }
   _set_var index,content
   return(0)

}

defeventtab _set_var_form

_ok.on_create()
{
   combo1.p_cb_list_box._insert_name_list(VAR_TYPE|BUFFER_TYPE);
   combo1.p_cb_list_box._lbsort();
   _ctlsv_edit.p_enabled=0;
   text1.p_enabled=0;//Had to have these to compile
   text1.p_prev.p_enabled=0;
}

combo1.on_change(reason)
{
   lbtext=p_cb_list_box._lbget_text()
   if (!name_eq(lbtext,combo1.p_text)) {
      _ctlsv_edit.p_enabled=0;
      return('')
   }
   index = find_index(combo1.p_text, VAR_TYPE|BUFFER_TYPE);
   if ( ! index ) {
      _ctlsv_edit.p_enabled=0;
      return('')
   }
   var_p=&_get_var(index);
   switch (var_p->_varformat()) {
   case VF_LSTR:
   case VF_INT:
      _ctlsv_edit.p_enabled=0;
      text1.p_enabled=1;
      text1.p_prev.p_enabled=1;
      text1.p_text=*var_p;
      break;
   case VF_PTR:
   case VF_ARRAY:
   case VF_HASHTAB:
      _ctlsv_edit.p_enabled=1;
      text1.p_enabled=0;
      text1.p_text='';
      text1.p_prev.p_enabled=0;
   }
}

void _ctlsv_edit.lbutton_up()
{
   index = find_index(combo1.p_text, VAR_TYPE|BUFFER_TYPE);
   if ( ! index ) {
     return;
   }
   var_p=&_get_var(index);
   wid=show('-mdi -hidden _var_editor_form',combo1.p_text,var_p);
   wid.p_x=p_active_form.p_x+p_active_form.p_width;
   wid._show_entire_form();
   wid.p_visible=1;
   text1.p_text='';
   text1.p_enabled=0;
}

_ok.lbutton_up()
{
   if (text1.p_enabled) {
      index = find_index(combo1.p_text, VAR_TYPE|BUFFER_TYPE);
      if ( ! index ) {
        p_active_form._delete_window(1);
      }
      _config_modify|=CFGMODIFY_DEFVAR;
      _set_var(index, text1.p_text);
      _macro('m',_macro('s'))
      _macro_append(combo1.p_text'='text1.p_text";");
   }
   p_active_form._delete_window(0);
}

_command gui_set_var()  name_info(VAR_ARG','VSARG2_EDITORCTL)
{
   _macro_delete_line();
   result = show('_set_var_form');
   if (result == '') {
      return(COMMAND_CANCELLED_RC);
   }
   return(0);
}
_str _default_state_filename()
{
   filename=editor_name('s')
   if ( filename=='' || '.'get_extension(filename)=='.'_macro_ext'x' ) {
      filename=slick_path_search(STATE_FILENAME)
      if ( filename=='' ) {
         filename=STATE_FILENAME
      }
   }
   /* If state file not local to user or _SLICKCONFIG directory. */
   if ( _use_config_path(absolute(filename)) ) {
      local_dir=_config_path()
      filename=local_dir:+STATE_FILENAME
   }
   return(filename)
}
_command write_state() name_info(FILE_ARG',')
{
   arg1=arg(1)
   if ( arg1=='' ) {
      filename=_default_state_filename();
      arg1=prompt('',nls('Save config to'),filename)
   }
   message nls('Saving configuration to %s',arg1)
   /* If path on filename is users config directory. */
   if ( file_eq(_config_path(),substr(arg1,1,pathlen(arg1))) ) {
      if ( _create_config_path() ) {
         return(1)
      }
   }
   call_list("_b4wrst_");
   _delete_unused()
   mou_hour_glass(1);
   status=_write_state(arg1);
   mou_hour_glass(0);
   if ( status ) {
      popup_message(nls("Failed to save configuration to '%s'.",arg1)"\n\n"get_message(status))
      return(rc)
   }
   clear_message();
   if (machine()=='OS2386') {
      _origMdiMenuFont=_default_font(CFG_MENU);
   }
   if (_need_to_save_cfgfiles()) {
      _config_modify&= ~(CFGMODIFY_MUSTSAVESTATE|CFGMODIFY_DELRESOURCE);
   } else {
      _config_modify=0;
   }
   return(0)
}
_command gui_load()
{
   _macro_delete_line();
   initial_filename="";
   if (p_view_id<0) {
      initial_filename=p_buf_name;
      extension=get_extension(initial_filename)
      if ( ! file_eq('.'extension,_macro_ext) && ! file_eq(extension,'cmd') ) {
         initial_filename=''
      }
   }
   result=_OpenDialog(_stdform('_open_form')' -modal',
        'Load Module', '*.e',
        "Visual Slick Edit (*.e),All Files ("ALLFILES_RE")",
        OFN_FILEMUSTEXIST,
        substr(_macro_ext, 2), // Default extensions
        initial_filename,      // Initial filename
        '',                    // Initial directory
        'gui_load',             // Retrieve name
        'load module dialog box' // Help item
        );
   if (result == '') {
      return(COMMAND_CANCELLED_RC);
   }
   _macro('m',_macro('s'))
   _macro_call('load', result);
   status = load(result);
   return(status);
}
/*
   DLL interface.  Load DLL.
*/
_command dload() name_info(FILE_ARG',')
{
   filename=arg(1);
   if (filename=='') {
     filename=prompt('',nls('Load DLL'))
   }
   if (filename=='') {
      return(1);
   }
   ext=get_extension(filename)
   if (ext=='') {
      filename=filename:+DLLEXT;
   }
   _str oriFilename;
   oriFilename = filename;
#if __UNIX__
   // UNIX version does not have DLL support yet.  Faking DLL support
   // for cparse.dll.  Which actually code linked into the editor.
   switch (filename) {
   case 'cparse':
   case 'cparse.dll':
      _config_modify|=CFGMODIFY_LOADDLL;
      _dllload('cparse.dll');
      return(0);
   case 'dparse':
   case 'dparse.dll':
      _config_modify|=CFGMODIFY_LOADDLL;
      _dllload('dparse.dll');
      return(0);
   case 'vsvcs':
   case 'vsvcs.dll':
      _config_modify|=CFGMODIFY_LOADDLL;
      _dllload('vsvcs.dll');
      return(0);
   case 'cformat':
   case 'cformat.dll':
      _config_modify|=CFGMODIFY_LOADDLL;
      _dllload('cformat.dll');
      return(0);
   case 'vshlp':
   case 'vshlp.dll':
      _config_modify|=CFGMODIFY_LOADDLL;
      _dllload('vshlp.dll');
      return(0);
   case 'tagsdb':
   case 'tagsdb.dll':
      _config_modify|=CFGMODIFY_LOADDLL;
      _dllload('tagsdb.dll');
      return(0);
   case 'vsockapi':
   case 'vsockapi.dll':
      _config_modify|=CFGMODIFY_LOADDLL;
      _dllload('vsockapi.dll');
      return(0);
   }

   // Translate NAME.dll to libNAME.so to do a file existence check.
   _str modName;
   modExt = substr(filename,lastpos(".",filename));
   if (modExt == DLLEXT) {
      _str sharedLibExt;
      sharedLibExt = ".so";
      if (machine() == "HP9000") sharedLibExt = ".sl";
      filename = strip_filename(filename, "EN") :+ "lib" :+ strip_filename(filename, "PE") :+ sharedLibExt;
   }
#endif
   path=slick_path_search(filename);
   if (path=='') {
      _message_box(nls('File %s not found',oriFilename))
      return(FILE_NOT_FOUND_RC);
   }
#if __UNIX__
   // Convert name back to original format:  NAME.dll
   path = oriFilename;
#endif
   present=_macfile_present(path,DLLEXT);
   status=_dllload(path);
   if (status) {
      _message_box(nls('Failed to load DLL %s',path)'.  'get_message(status));
   }
   if (!status) {
      _config_modify|=CFGMODIFY_LOADDLL;
      _macfile_add(path,DLLEXT,present);
   }
   return(status);
}
_command dunload() name_info(DLLMODULE_ARG',')
{
   filename=arg(1);
   if (filename=='') {
     filename=prompt('',nls('Unload DLL'))
   }
   if (filename=='') {
      return(1);
   }
   ext=get_extension(filename)
   if (ext=='') {
      filename=filename:+DLLEXT;
   }
#if __UNIX__
   // UNIX version does not have DLL support yet.  Faking DLL support
   // for cparse.dll.  Which actually code linked into the editor.
   switch (filename) {
   case 'cparse':
   case 'cparse.dll':
      _config_modify|=CFGMODIFY_LOADDLL;
      _dllload('cparse.dll','u');
      return(0);
   }
#endif
   status=_dllload(filename,'u');
   if (status==FILE_NOT_FOUND_RC) {
      _message_box(nls('File %s not loaded',filename));
   }
   if (!status) {
      _config_modify|=CFGMODIFY_LOADDLL;
      _macfile_delete(filename,DLLEXT);
   }
   return(status);
}
_command load() name_info(FILE_ARG',')    /* make and load module */
{
  arg1=strip(arg(1),'B','"');
  default_buf_name=(_no_child_windows())?'':p_buf_name;
  if ( arg1=='<' || (arg1=='' && _no_child_windows())) {
     arg1=prompt('',nls('Load module'),default_buf_name)
  }
  if ( arg1=='' || (p_view_id<0 && file_eq(p_buf_name,absolute(arg1)) )) {
     extension=get_extension(p_buf_name);
     if ( ! file_eq('.'extension,_macro_ext) && ! file_eq(extension,'cmd') ) {
        _message_box(nls('File %s does not have a macro extension',p_buf_name));
        return(1)
     }
     if ( p_modify ) {
        status=save();
        if ( status ) {
           return(status);
        }
     }
     module=maybe_quote_filename(default_buf_name);
  } else {
     module=maybe_quote_filename(arg1);
  }
  message nls('Making %s',module);
  _make(module);
  make_rc=rc;
  if ( make_rc ) {
    if ( make_rc==FILE_NOT_FOUND_RC ) {
      popup_message(nls("Can't find module '%s'",module))
    } else {
      if ( make_rc==1  ) {  /* rc from Slick Translator? */
        /* Don't display message if ST macro already has */
        /* has displayed the error. */
        if ( ! find_index('st',COMMAND_TYPE) ) {
          popup_message(nls("Unable to make '%s",module)'.  ':+
              nls('Compilation failure.'))
        }
      } else {
        popup_message(nls("Unable to make '%s'",module)".  "get_message(make_rc))
      }
    }
    return(make_rc);
  }
  already_present=_macfile_present(module,_macro_ext'x');
  status=_load(module,'r');
  if ( !status) {
    _macfile_add(module,_macro_ext'x',already_present);
    message nls('Module(s) loaded');
    name=strip_filename(module,'P');
    if (file_eq(USERMACS_FILE:+_macro_ext,name)) {
       _config_modify |=CFGMODIFY_USERMACS;
    } else {
       _config_modify |=CFGMODIFY_LOADMACRO;
    }
     // Event tables may have changed
     if (_display_wid) {
        // LOAD command must post_command since modules are not
        // loaded immediately.
        _post_call(find_index('_deupdate',PROC_TYPE));
     }
  } else {
     _message_box(nls("Unable to load module '%s'.",module)"  "get_message(status));
  }
  return(status);
  /* call messageNwait('rc='rc) */
}
_command gui_unload()
{
   result=_list_matches2(
                  'Unload Module',   // title
                  SL_VIEWID|SL_SELECTPREFIXMATCH|SL_COMBO|SL_MUSTEXIST,        // flags
                  '',       // buttons
                  'gui_unload',       // help_item
                  '',       // font
                  '',       // callback
                  'unload',    // retrieve_name
                  MODULE_ARG); // completion
   if (result=='') {
      return(COMMAND_CANCELLED_RC)
   }
   unload(result);
}
_command void unload() name_info(MODULE_ARG',')
{
   filename=prompt(arg(1),'Unload module');
   _load filename,'u'
   if ( ! rc ) {
      _UntagSlickCFile(strip(filename,'B','"'));
      name=strip_filename(filename,'P');
      if (file_eq(USERMACS_FILE:+_macro_ext,name)) {
         _config_modify |=CFGMODIFY_USERMACS;
      } else {
         _config_modify |=CFGMODIFY_LOADMACRO;
         _macfile_delete(filename,_macro_ext'x');
      }
   }
}
boolean isid_valid(name)
{
   /* name must not be null */
   if (name=='') {
      return(0)
   }
   /*  name must consist of valid identifier characters. */
   if ( pos('[~A-Za-z0-9_$]',name,1,'r') ) {
      return(0)
   }
   /*  First character must not be number. */
   if (isinteger(substr(name,1,1))) {
      return(0)
   }
   if (name_eq(substr(name,1,2),'p_')) {
      return(0);
   }
   return(1)
}
void create_ext(int &kt_index,_str extension,_str ref_extension /* ,mode_name,
                   setup_info,compile_info,syntax_info,be_info,include_info,
                   word_chars,lexer_name,color_flags */)
{
   if ( ref_extension!='' ) {
      if ( file_eq(extension,ref_extension) ) {
         return
      }
      name='def-setup-'extension
      ref_extension='@'refer_ext(ref_extension);
      index=find_index(name,MISC_TYPE)
      if ( ! index ) {
         index=insert_name(name,MISC_TYPE,ref_extension)
      }
      set_name_info index,ref_extension
      return;
   }
   mode_name=arg(4);setup_info=arg(5);compile_info=arg(6)
   syntax_info=arg(7);be_info=arg(8);include_info=arg(9)
   word_chars=arg(10)
   lexer_name=arg(11)
   color_flags=arg(12)
   parse setup_info with 'KEYTAB=' keytab_name ','
   keytab_name=lowcase(strip(keytab_name));
   if ( keytab_name=='' ) {
      keytab_name='default-keys'
   }
   if ( keytab_name!='default-keys' ) {
      kt_index=find_index(keytab_name,EVENTTAB_TYPE)
      if ( ! kt_index ) {
         kt_index=insert_name(keytab_name,EVENTTAB_TYPE)
      }
      set_eventtab_index(kt_index,event2index(ENTER),find_index(lowcase(mode_name)'-enter',COMMAND_TYPE));
      set_eventtab_index(kt_index,event2index(' '),find_index(lowcase(mode_name)'-space',COMMAND_TYPE));
   }
   name='def-setup-'extension
   index=find_index(name,MISC_TYPE);
   if ( ! index ) {

      parse setup_info with 'MN=' mode_name ',' 'TABS=' tabs ',' \
        'MA=' margins ',' 'KEYTAB=' keytab_name ',' 'WW='word_wrap_style ',' \
         'IWT='indent_with_tabs ',' 'ST='show_tabs',' 'IN=' indent_style',' \
          'WC='tword_chars',' 'LN='tlexer_name',' 'CF='tcolor_flags','
      if (tlexer_name=='') tlexer_name=lexer_name;
      if (tcolor_flags=='') tcolor_flags=color_flags;
      if (tword_chars=='') tword_chars=word_chars;
      //if (word_chars=='') tword_chars='A-Za-z0-9_$';
      if (word_wrap_style=='') word_wrap_style=3;
      if (indent_with_tabs=='') indent_with_tabs=0;
      if (show_tabs=='') show_tabs=0;
      if (indent_style=='') indent_style=INDENT_SMART;
      if(keytab_name=='') keytab_name='default-keys';
      keytab_name=lowcase(keytab_name);
      setup_info='MN=' mode_name ',' 'TABS=' tabs ',' 'MA=' margins ',' \
         'KEYTAB=' keytab_name ',' 'WW='word_wrap_style ',' \
         'IWT='indent_with_tabs ',' 'ST='show_tabs',' \
         'IN=' indent_style',' 'WC='tword_chars',' 'LN='tlexer_name',' \
         'CF='tcolor_flags','

      insert_name(name,MISC_TYPE,setup_info)
   } else {
      parse name_info(index) with 'MN='.','middle'KEYTAB=' . ','rest
      set_name_info index,'MN='mode_name','middle'KEYTAB='keytab_name','rest
   }
   if ( compile_info!='' ) {
      name='def-compile-'extension
      index=find_index(name,MISC_TYPE)
      if ( ! index ) {
         insert_name(name,MISC_TYPE,compile_info)
      }
   }
   if ( syntax_info!='' ) {
      name='def-options-'extension
      index=find_index(name,MISC_TYPE)
      if ( ! index ) {
         insert_name(name,MISC_TYPE,syntax_info)
      }
   }
   if ( be_info!='' ) {
      name='def-begin-end-'extension
      index=find_index(name,MISC_TYPE)
      if ( ! index ) {
         insert_name(name,MISC_TYPE,be_info)
      }
   }
#if 0
   // Reserved for future use
   if ( include_info!='' ) {
      name='def-include-'extension
      index=find_index(name,MISC_TYPE)
      if ( ! index ) {
         insert_name(name,MISC_TYPE,include_info)
      }
   }
#endif
}
_command insert_var() name_info(VAR_ARG','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)
{
   result=arg(1);
   if (result=='') {
      result=_list_matches2(
                     'Insert Variable Source',   // title
                     SL_VIEWID|SL_SELECTPREFIXMATCH|SL_COMBO|SL_MUSTEXIST /*|SL_DEFAULTCALLBACK*/,      // flags
                     '',       // buttons
                     'insert_var',   // help_item
                     '',       // font
                     '',  //'_open_form_callback', //callback
                     'insert_var',       // retrieve_name
                     VAR_ARG,            // completion
                     '',                    // min list width
                     ''                     // fast complete
                     );
      if (result=='') {
         return(COMMAND_CANCELLED_RC)
      }
   }
   index=find_index(strip(result),VAR_TYPE|BUFFER_TYPE)
   if (!index) {
      popup_message(nls('Could not variable "%s".',strip(result)));
      return(1)
   }
   status=maybe_delete_selection();
   if(status){
      if (status==4) {
         _delete_line();
      } else {
         up();
      }
   }
   syntax_indent=p_SyntaxIndent;
   if (syntax_indent<=0) syntax_indent=3;
   _insert_var_source(_get_var(index),name_name(index),indent_string(syntax_indent),1)
   return(0);
}
/*
    Generates source for simple or complex variable.
    No source is genarated for pointer or function pointer values.
*/
void _insert_var_source(_str &a,_str varname,_str indent, int level)
{
   //messageNwait('vf='a._varformat()' level='level);
   varname=translate(varname,'_','-');
   switch (a._varformat()) {
   case VF_ARRAY:
   case VF_HASHTAB:
      isarray=0;
      if (a._varformat()==VF_ARRAY) isarray=1;
      i._makeempty();
      for (;;) {
         p= &a._nextel(i);
         if (i._isempty()) break;
         switch (p->_varformat()) {
         case VF_INT:
         case VF_LSTR:
            if (level<=1) {
               insert_line(indent:+varname:+makeindex(i,isarray)'='_quote(*p)';');
            } else {
               insert_line(indent'p'(level-1)'->'makeindex(i,isarray)'='_quote(*p)';');
            }
            break;
         case VF_ARRAY:
         case VF_HASHTAB:
            vnotinit._makeempty();
            //if (_varformat(_varnextel(*p,vnotinit))==VF_NOTINIT) {
            if (p->_nextel(vnotinit)._isempty()) {
               // No initialized elements
               break;
            }
            if (level<=1) {
               insert_line(indent'p'level'=&'varname:+makeindex(i,isarray)';');
            } else {
               insert_line(indent'p'level'=&p'(level-1)'->':+makeindex(i,isarray)';');
            }
            _insert_var_source(*p,'',indent,level+1);
         }
      }
      break;
   case VF_INT:
   case VF_LSTR:
   case VF_PTR:
   case VF_FUNPTR:
      // Simple variable case
      insert_line(indent:+varname'='_quote(a)';');
   }
}
static _str makeindex(_str i,boolean isarray)
{
   if (isarray) {
      return('['i']');
   }
   return(':['_quote(i)']');
}
int _nocomment_search(_str string,_str options)
{
   return(search(string,'xcs,'options));
}

int _macfile_present(_str filename,_str extension)
{
   filename=strip(filename,'B','"');
   // Don't try to support VSLICKEXT environment variable
   if (!file_eq(_macro_ext,'.e')) return(0);
   // Don't quote module here.  Symbol tables does not quote symbols.
   module=strip_filename(filename,(extension=='')? 'P':'PE');
#if __UNIX__
   // Convert libDLLNAME.so to DLLNAME.dll for a quick check.
   if (pos("lib", module) == 1) {
      module = substr(module, 4) :+ extension;
   } else {
      module = module :+extension;
   }
#else
   module=module:+extension;
#endif
   index=find_index(module,MODULE_TYPE|DLLMODULE_TYPE);
   return(index);
}
void _macfile_delete(filename,extension)
{
   filename=strip(filename,'B','"');
   // Don't try to support VSLICKEXT environment variable
   if (!file_eq(_macro_ext,'.e')) return;
   module=strip_filename(filename,(extension=='')? 'P':'PE');
   module=maybe_quote_filename(module:+extension);
   i=pos(' 'module' ',' 'def_macfiles' ',1,_fpos_case);
   if (i) {
      rest=substr(def_macfiles,i);
      parse_file(rest);
      def_macfiles=strip(substr(def_macfiles,1,i-1)' 'rest);
      _config_modify|=CFGMODIFY_DEFVAR;
   }
}
void _macfile_add(_str filename,_str extension,int alreadyPresent=0,boolean supportMacro=false)
{
   filename=strip(filename,'B','"');
   // Don't try to support VSLICKEXT environment variable
   if (!file_eq(_macro_ext,'.e')) return;
   if (alreadyPresent) return;
   module=strip_filename(filename,(extension=='')? 'P':'PE');
   module=maybe_quote_filename(module:+extension);
   if (pos(' 'module' ',' 'def_macfiles' ',1,_fpos_case)) {
      return;
   }
   _config_modify|=CFGMODIFY_DEFVAR;
   def_macfiles=def_macfiles' 'module;
   if ((file_eq(extension,'.e') ||
       file_eq(extension,'.ex')) &&
       !supportMacro
       ) {
      if (!_in_firstinit) {
         if(!_e_MaybeBuildTagFile(tfindex) ) {
            _MaybeTagSlickCFile(filename,tfindex);
         }
      }
   }
}
/*
    Call this function when the cursor is at the first character of the
    definition of a procedure and which is usually NOT the name.
*/
static void _start_of_proc_comments()
{
   save_pos(p2);
   if (p_col!=1) {
      left();
   } else {
      up();_end_line();
   }
   //Search backward for first non-blank character
   status=search('[~ \t]','r@-');
   if (!status && _in_comment()) {
      status=_clex_skip_blanks('-');
      if (status) {
         //messageNwait('case1');
         top();
      } else {
         //messageNwait('case2');
         right();
         // Search forward for beginning of line or [blank-chars]non-blank-char
         search('^|[ \t]*[~ \t]','r@');
      }
      return;  // We found some comments and we may have found blanks and/or blank-lines
   }
   if (status) {
      //messageNwait('case4');
      top();
   } else {
      //messageNwait('case5');
      right();
      // Search forward for beginning of line or [blank-chars]non-blank-char
      search('^|[ \t]*[~ \t]','r@');
   }
   // No comments found but we may have found blanks and/or blank-lines
}
static c_select_proc_common(p,markid)
{
   status=prev_proc('q');
   if (status) {
      restore_pos(p);
      return(status);
   }
   _deselect(markid);
   if (p_line>=1) {
      _start_of_proc_comments();
   }
   _select_char(markid,translate(def_select_style,'N','I'));
   tag_tree_decompose_tag(_proc_found, proc_name, dc, dt, df);
   if (dt=='proto') {
      status=search(';','@xcs');
      if (status) {
         _deselect(markid);
         restore_pos(p);
         return(status);
      }
      right;
   } else {
      // Assume that next pair of braces belong to this function.
      status=search('{','@xcs');
      for (;;) {
         if (status) {
            _deselect(markid);
            restore_pos(p);
            return(status);
         }
         color=_clex_find(0,'g');
         if (color!=CFG_COMMENT && color!=CFG_STRING) {
            break;
         }
         status=repeat_search();
      }
      status=_find_matching_paren(def_pmatch_max_diff);
      if (status) {
         _deselect(markid);
         restore_pos(p);
         return(status);
      }
      right;
   }
   return(status);
}
/*
    arg(1)   reserved
    arg(2)   markid.  Can be '' for active selection

*/
_command int select_proc() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   ext=p_extension;
   index=find_index(ext'-select-proc',PROC_TYPE)
   if ( index_callable(index) ) {
      old_scroll_style=_scroll_style();
      _scroll_style('c');
      status=call_index(arg(1),arg(2),index);
      _scroll_style(old_scroll_style);
      return(status);
   }  else {
      index=find_index(ext'-proc-search',PROC_TYPE)
      if ( index_callable(index) ) {
         return(_select_proc(arg(1),arg(2)));
      }
   }
   if (arg(3)=='') {
      _message_box('Select procedure not supported for files of this extension.')
   }
   return(1);
}

/*
   This function is a generic select_proc.  It assumes that
   function headers can be selected with a line selection.
   It also assumes that there are no declarations between
   function definitions. To improve this function, write
   a language specific function which finds the end a function.
*/
static int _select_proc()
{
   markid=arg(2);
   save_pos(orig_pos);
   _clex_skip_blanks();
   // We could already be sitting on the function cursor down
   // to try to hit this one.
   down();
   status=prev_proc('q');
   if (status) {
      status=next_proc('q');
      if (status) {
         restore_pos(orig_pos);
         return(-1);
      }
   }
   _deselect(markid);
   save_pos(start_proc_pos);
   _begin_line();
   up();
   if (_in_comment()) {
      status=_clex_skip_blanks('-');
      if (!status) {
         down();
      }
   } else {
      down();
   }
   _select_line(markid,translate(def_select_style,'N','I'));
   restore_pos(start_proc_pos);
   // Here it would be better to search for the end of the
   // function instead of the beginning of the next function
   // because we may pick up declarations we don't want.
   status=next_proc('q');
   if (status) {
      bottom();
   } else {
      up();
      _clex_skip_blanks('-');
   }
   _select_line(markid,translate(def_select_style,'N','I'));
   return(0);
}
java_select_proc()
{
   return(c_select_proc(arg(1),arg(2)));
}
js_select_proc()
{
   return(c_select_proc(arg(1),arg(2)));
}
/*
    Note that this proc search function does not support Slick-C function
    definitions which do not start in column 1 (Same limit as find-proc).  The
    work around for this is to modify cparse.dll to support compiling Slick-C
    source.  This will require support the following extensions:


    Lexer additions.
       *  \ddd
       *  Nested /* */ comments
       *  Single quoted strings like REXX

       _commmand  [type-list] [name,name,string] (...)  [name_info(...)]
       [type-list] name. {string[-string]|name}[, another] (...)


*/
e_select_proc()
{
   return(c_select_proc(arg(1),arg(2)));
}
c_select_proc()
{
   count=arg(1);
   markid=arg(2);
   if (!isinteger(count)) count=1;
   orig_offset=_nrseek();
   hit_bottom=0;
   save_pos(p);
   for (i=1;i<=count;++i) {
      status=next_proc('q');
      if (status) {
         hit_bottom=1;
         bottom();
         break;
      }
   }
   // Now find the end of the previous procedure.
   status=c_select_proc_common(p,markid);
   if (status) {
      return(status);
   }
   // IF we were after the close brace
   if (!hit_bottom && _nrseek()<=orig_offset) {
      // We selected the wrong procedure.  Select the next procedure
      status=next_proc('q');
      status=next_proc('q');
      hit_bottom=1;
      if (status) {
         bottom();
      }
      // Now find the end of the previous procedure.
      status=c_select_proc_common(p,markid);
      if (status) {
         return(status);
      }
   }
   _select_char(markid,translate(def_select_style,'N','I'));
   // Now try to select the new line character
   _get_selinfo(start_col,end_col,junk,markid);
   if (start_col==1) {
      _skip_blanks_or_find_BOL(markid);
   }
   return(0);
}
static int _skip_blanks_or_find_BOL(markid)
{
   search_options='@r';
   for (;;) {
      // search backward for non-blank character
      status=search('[~ \t]|$',search_options);
      if (status) return(1);
      if (!match_length()) {
         right();
#if 1
            _select_type(markid,'T','LINE');
#else
            if (!down()) _begin_line();
#endif
         return(0);
      }
      if (_in_comment()) {
         old_linenum=p_line;save_pos(p);
         status=_clex_find(COMMENT_CLEXFLAG,'n');
         if (status) return(1);
         if (p_line!=old_linenum) {
            restore_pos(p);
#if 1
            _select_type(markid,'T','LINE');
#else
            search('$','@r');right();
            if (!down()) _begin_line();
#endif
            return(0);
         }
         continue;
      }
      return(0);
   }
}
defeventtab slick_keys
def '_'=auto_codehelp_key 
def '.'=auto_codehelp_key 
def '>'=auto_codehelp_key 
def '('=auto_functionhelp_key 
def 'C- '=codehelp_complete

defeventtab ext_keys
def ' '=ext_space
/* This command is bound to the SPACE BAR key.  It looks at the text around */
/* the cursor to decide whether insert an expanded template.  If it does not, */
/* the root key table definition for the SPACE BAR key is called. */
_command void ext_space() name_info(','VSARG2_CMDLINE|VSARG2_LASTKEY|VSARG2_REQUIRES_EDITORCTL)
{
   parse name_info(_edit_window().p_index) with . expand .
   if ( command_state() || ! expand || p_SyntaxIndent<0 ||
      _in_comment() ||
      ext_expand_space(p_SyntaxIndent) ) {
      if ( command_state() ) {
         call_root_key(' ');
      } else {
         keyin(' ');
      }
   } else if (_argument=='') {
      _undo('S');
   }

}
static _str space_words2[];

/* Returns non-zero number if fall through to space bar key required */
static _str ext_expand_space(syntax_indent)
{
   /* Put first word of line in lower case into word variable. */
   get_line(line);
   line=strip(line,'T')
   orig_word=lowcase(strip(line))
   if ( p_col!=text_col(line)+1 ) {
      return(1)
   }
   aliasfilename='';
   word=min_abbrev2(orig_word,space_words2,name_info(p_index),aliasfilename);
   if (word!=''&&aliasfilename!='') {
      if (orig_word:==word && orig_word==get_alias(word,mult_line_info,1,aliasfilename)) {
         if (!_insert_state()) insert_toggle();
         keyin(' ');
         return(0);
      }
      col=p_col-length(orig_word);
      if (col==1) {
         line_prefix='';
      }else{
         line_prefix=indent_string(col-1);
      }
      replace_line(line_prefix);
      p_col=col;
      return(expand_alias(word,'',aliasfilename));
   }
   /* Insert the appropriate template based on the key word. */
   //line=substr(line,1,length(line)-length(orig_word)):+word
   //width=text_col(line,length(line)-length(word)+1,'i')-1
   return(1);
}
/*
   WARNING:  These lexer names are case senstive.
   If some one changes the case of lexer names in vslick.vlx, we will get
   burned.
*/   
_str _EmbeddedLexer2Ext:[]={
   'cpp'=> 'c',
   'JavaScript'=> 'js',
   'VBScript'=> 'bas',
   'Perl'=> 'pl',
   'Java'=> 'java',
};

void NoEmbeddedLanguageProcessing(_str key)
{
   switch (key) {
   /*case ':':
   case ' ':
   case '{':
   case '}':
      keyin(key);
      return;*/
   case ENTER:
      call_root_key(ENTER);
   default:
      if (length(key):==1) {
         keyin(key);
      }
   }
}
/*

   Returns 2 to indicate that there is embedded language
   code, but in comment/in string like default processing
   should be performed.
   
   Return 1,  indicates that the mode has been
   switch to the embedded language.  Caller must
   call _EmbeddedEnd(orig_values)
   
   Returns 0 if there is no embedded language
   
   Returns 3 if mode name is the same.

*/
int _EmbeddedStart(typeless &orig_values,_str key)
{
   orig_values._makeempty();
   //messageNwait('h1');
   EmbeddedLexerName=p_EmbeddedLexerName;
   if (EmbeddedLexerName=='') {
      // No embedded language here
      return(0);
   }
   if (EmbeddedLexerName:!='' && !_EmbeddedLexer2Ext._indexin(EmbeddedLexerName)) {
      // There is no support for this embedded language
      // However, there may be color coding.
      //messageNwait('h2');
      return(2);
   }
   // Convert EmbeddedLexerName to actual language
   extension=_EmbeddedLexer2Ext:[EmbeddedLexerName];
   //messageNwait('extension='extension);

   buf_name='.'extension;
   check_and_load_support(extension,setup_index,buf_name);
   parse name_info(setup_index) with 'MN=' mode_name ',' . 'KEYTAB=' keytab_name ',';

   options_index=find_index('def-options-'extension,MISC_TYPE);
   // IF we are already in this mode. (ex Embedded Perl in Perl)
   if (_modename_eq(mode_name,p_mode_name)) {
      //messageNwait('mode name same')
      return(3);
   }


   mode_eventtab=find_index(keytab_name,EVENTTAB_TYPE);
   //messageNwait('h4 mode_eventtab='mode_eventtab' mode_name='mode_name' keytab_name='keytab_name);
   if (!mode_eventtab || keytab_name=='' || translate(keytab_name,'_','-'):=='default_keys' ||
      (key:!='' && !eventtab_index(mode_eventtab,mode_eventtab,event2index(key)))
      ) {
      return(2);
   }
   //messageNwait('YES');
   orig_values[0]=p_mode_name;
   p_mode_name=mode_name;

   orig_values[1]=p_mode_eventtab;
   p_mode_eventtab=mode_eventtab;

   orig_values[2]=p_index;
   p_index=options_index;

   orig_values[3]=p_indent_style;
   p_indent_style=INDENT_SMART;

   orig_values[4]=p_SyntaxIndent;
   parse name_info(p_index) with syntax_indent .;
   if (isinteger(syntax_indent)) {
      p_SyntaxIndent=syntax_indent;
   } else {
      p_SyntaxIndent=0;
   }
   orig_values[5]=p_extension;
   p_extension=extension;

   _default_option(VSOPTION_EMBEDDED,VSEMBEDDED_ONLY);
   return(1);
   
}
void _EmbeddedEnd(typeless orig_values)
{
   if (orig_values._isempty()) {
      return;
   }
   p_mode_name=orig_values[0];
   p_mode_eventtab=orig_values[1];
   p_index=orig_values[2];
   p_indent_style=orig_values[3];
   p_SyntaxIndent=orig_values[4];
   p_extension=orig_values[5];
   _default_option(VSOPTION_EMBEDDED,0);
}
/*
   Returns 1 if all processing for this key was completed.
   Otherwise 0 is returned, which indicates the caller
   needs to process this key.
*/
int _EmbeddedLanguageKey(_str key)
{
   switch(_EmbeddedStart(orig_values,key)) {
   case 2:  
      NoEmbeddedLanguageProcessing(key);
      return(1); // Processing done for this key
   case 0:  
   case 3:
      return(0); // Caller needs to process this key
   }
   call_key(key);
   _EmbeddedEnd(orig_values);
   return(1); // Processing done for this key
}

defeventtab html_keys
_command void html_key() name_info(','VSARG2_CMDLINE|VSARG2_REQUIRES_EDITORCTL|VSARG2_ICON|VSARG2_LASTKEY)
{
   if (command_state()) {
      call_root_key(last_event());
      //NoEmbeddedLanguageProcessing(last_event());
      return;
   }
   if(_EmbeddedLanguageKey(last_event())) return;
   NoEmbeddedLanguageProcessing(last_event());
}

int _html_fcthelp_get(_str (&errorArgs)[],
                      VSAUTOCODE_ARG_INFO (&FunctionHelp_list)[],
                      boolean &FunctionHelp_list_changed,
                      int &FunctionHelp_cursor_x,
                      _str &FunctionHelp_HelpWord,
                      int FunctionNameStartOffset,
                      int flags
                      )
{
   errorArgs._makeempty();
   _UpdateContext(true);
   status=_EmbeddedStart(orig_values,'');
   if (status!=1) {
      return(1);
   }
   index=find_index('_'p_extension'_fcthelp_get',PROC_TYPE);
   if (!index) {
      _EmbeddedEnd(orig_values);
      //_message_box('Auto function help not supported for this language');
      return(1);
   }
   //status=call_index(false,prefixexp,lastid,lastidstart_col,info_flags,get_idexp_index);
   status=call_index(errorArgs,FunctionHelp_list,FunctionHelp_list_changed,
                     FunctionHelp_cursor_x,FunctionHelp_HelpWord,
                     FunctionNameStartOffset,flags,
                     index);
   _EmbeddedEnd(orig_values);
   return(status);
}
int _html_fcthelp_get_start(_str (&errorArgs)[],
                            boolean OperatorTyped,
                         boolean cursorInsideArgumentList,
                         int &FunctionNameOffset,
                         int &ArgumentStartOffset,
                         int &flags
                         )
{
   errorArgs._makeempty();
   _UpdateContext(true);
   status=_EmbeddedStart(orig_values,'');
   if (status!=1) {
      return(1);
   }
   index=find_index('_'p_extension'_fcthelp_get_start',PROC_TYPE);
   if (!index) {
      _EmbeddedEnd(orig_values);
      //_message_box('Auto function help not supported for this language');
      return(1);
   }
   //status=call_index(false,prefixexp,lastid,lastidstart_col,info_flags,get_idexp_index);
   status=call_index(errorArgs,OperatorTyped,cursorInsideArgumentList,
                     FunctionNameOffset,ArgumentStartOffset,flags,
                     index);
   _EmbeddedEnd(orig_values);
   return(status);
}
int _html_find_context_tags(_str (&errorArgs)[],_str prefixexp,
                            _str lastid,int lastidstart_offset,
                            int info_flags,typeless otherinfo,
                            boolean find_parents,int max_matches,
                            boolean exact_match,boolean case_sensitive)
{
   errorArgs._makeempty();
   status=_EmbeddedStart(orig_values,'');
   if (status!=1) {
      // This is odd?
      errorArgs[1]=lastid;
      return(VSCODEHELPRC_NO_SYMBOLS_FOUND);
   }
   find_context_tags_index=find_index('_'p_extension'_find_context_tags',PROC_TYPE);
   if (find_context_tags_index) {
      status=call_index(errorArgs,
                 prefixexp, lastid, lastidstart_col, 
                 info_flags, otherinfo, find_parents,
                 max_matches, exact_match, case_sensitive,
                 find_context_tags_index);
      _EmbeddedEnd(orig_values);
      //_message_box('Auto function help not supported for this language');
      return(status);
   }

   _EmbeddedEnd(orig_values);
   status=_do_default_find_context_tags(errorArgs,
                       prefixexp, lastid, lastidstart_col, 
                       info_flags, otherinfo, find_parents,
                       max_matches, exact_match, case_sensitive);
   return(status);
}
void _html_replace_context_tag(int relcol,
                 _str last_id, _str caption, 
                 _str terminationKey, int info_flags)
{

   status=_EmbeddedStart(orig_values,'');
   if (status!=1) {
      // This is odd?
      return;
   }
   replace_context_tag_index=find_index('_'p_extension'_replace_context_tag',PROC_TYPE);
   if (replace_context_tag_index) {
      call_index(relcol,last_id,caption,terminationKey,info_flags,replace_context_tag_index);
      _EmbeddedEnd(orig_values);
      //_message_box('Auto function help not supported for this language');
      return;
   }
   _EmbeddedEnd(orig_values);
   _do_default_replace_context_tag(
              relcol,last_id,caption,
              terminationKey,info_flags
              );

}
int _html_insert_context_tags(_str (&errorArgs)[],int editorctl_wid,_str prefixexp,
                              _str lastid,_str lastid_prefix,int lastidstart_offset,
                              _str expected_type,int info_flags,typeless otherinfo)
{
   errorArgs._makeempty();
   status=editorctl_wid._EmbeddedStart(orig_values,'');
   if (status!=1) {
      errorArgs[1]=lastid;
      return(VSCODEHELPRC_NO_SYMBOLS_FOUND);
   }
   insert_tags_index=find_index('_'editorctl_wid.p_extension'_insert_context_tags',PROC_TYPE);
   if (!insert_tags_index) {
      editorctl_wid._EmbeddedEnd(orig_values);
      //_message_box('Auto function help not supported for this language');
      return(1);
   }
   //status=call_index(false,prefixexp,lastid,lastidstart_col,info_flags,get_idexp_index);
   status=call_index(errorArgs,editorctl_wid,prefixexp,
                     lastid,lastid_prefix,lastidstart_offset,
                     expected_type,info_flags,otherinfo,insert_tags_index);
   editorctl_wid._EmbeddedEnd(orig_values);
   return(status);
}
int _html_MaybeBuildTagFile(int &tfindex)
{
   status=_EmbeddedStart(orig_values,'');
   if (status!=1) {
      return(1);
   }
   MaybeBuildTagFile_index=find_index('_'p_extension'_MaybeBuildTagFile',PROC_TYPE);
   if (!MaybeBuildTagFile_index) {
      _EmbeddedEnd(orig_values);
      //_message_box('Auto function help not supported for this language');
      return(1);
   }
   status=call_index(tfindex,MaybeBuildTagFile_index);
   _EmbeddedEnd(orig_values);
   return(status);
}
int _html_get_idexp(_str (&errorArgs)[],
                    boolean PossibleOperator,
                    _str &prefixexp,
                    _str &lastid,
                    int &lastidstart_col,
                    int &lastidstart_offset,
                    int &info_flags,
                    typeless &otherinfo
                   )
{
   errorArgs._makeempty();
   _UpdateContext(true);
   status=_EmbeddedStart(orig_values,'');
   if (status!=1) {
      return(1);
   }
   get_idexp_index=find_index('_'p_extension'_get_idexp',PROC_TYPE);
   if (!get_idexp_index) {
      _EmbeddedEnd(orig_values);
      //_message_box('Auto function help not supported for this language');
      return(1);
   }
   //status=call_index(false,prefixexp,lastid,lastidstart_col,info_flags,get_idexp_index);
   status=call_index(errorArgs,
                     PossibleOperator,
                     prefixexp,
                     lastid,
                     lastidstart_col,
                     lastidstart_offset,
                     info_flags,
                     otherinfo,
                     get_idexp_index);
   _EmbeddedEnd(orig_values);
   return(status);
}

static typeless gpfnouter_proc_search;
static typeless gpfncur_proc_search;
static int gend_linenum;
static _str gorig_proc_name;
static int grecursion;
static boolean gdo_search;
int _EmbeddedProcSearch(typeless pfnouter_proc_search,_str &proc_name,int find_first,...)
{
   if (grecursion) {
      if (!pfnouter_proc_search) {
         return(1);
      }
      return((*pfnouter_proc_search)(proc_name,find_first,arg(4),arg(5)));
   }
   grecursion=1;
   if (find_first) {
      gpfnouter_proc_search=pfnouter_proc_search;
      gend_linenum=p_line-1;
      if (gend_linenum<0) gend_linenum=0;
      gpfncur_proc_search=gpfnouter_proc_search;
      gorig_proc_name=proc_name;
      gdo_search=0;
      first_time=1;
   } else {
      first_time=0;
   }
   seekpos=arg(5);
outer_loop:
   for (;;) {
      //messageNwait('do='gdo_search' e='gend_linenum' h1 gpfncur_proc_search='gpfncur_proc_search);
      if (gdo_search) {
         if (gpfncur_proc_search) {
            status=_EmbeddedStart(orig_values,'');
            proc_name=gorig_proc_name;
            if (find_first) {
               seekpos=_nrseek();
            }
            //messageNwait('case1 find_first='find_first' proc_name='proc_name);
            //messageNwait('e='p_EmbeddedLexerName' L='p_line' c='p_col' ff='find_first' p='gorig_proc_name' sk='seekpos' gpfn='gpfncur_proc_search);
            status=(*gpfncur_proc_search)(proc_name,find_first,arg(4),seekpos);
            //messageNwait('status='status' proc_name='proc_name);
            _EmbeddedEnd(orig_values);
         } else {
            status=1;
         }
         if (!status) {
            // IF this line is within this embedded range
            if (p_line<=gend_linenum) {
               //say('found one proc_name='proc_name' gend_linenum='gend_linenum);
               grecursion=0;
               return(0);
            }
            //find_first=0;
            //continue outer_loop;
         }
      }
      gdo_search=1;
      ++gend_linenum;
      if (gend_linenum>p_Noflines) {
         grecursion=0;
         return(STRING_NOT_FOUND_RC);
      }
      p_line=gend_linenum;
      start_line=p_line;
      if (p_EmbeddedLexerName!='') {
         for (;;) {
            if (down()) {
               break;
            }
            if (!(_lineflags()&EMBEDDEDLANGAUGEMASK_LF)) {
               up();
               break;
            }
         }
         if (p_EmbeddedLexerName=="") up();
      } else {
         for (;;) {
            if (down()) {
               break;
            }
            if (_lineflags()&EMBEDDEDLANGAUGEMASK_LF) {
               up();
               break;
            }
         }
      }
      if (!first_time) {
         p_col=1;
      }
      gend_linenum=p_line;

      p_line=start_line;
      //messageNwait('start');
      /*Returns 2 to indicate that there is embedded language
      code, but in comment/in string like default processing
      should be performed.
      
      Return 1,  indicates that the mode has been
      switch to the embedded language.  Caller must
      call _EmbeddedEnd(orig_values)
      
      Returns 0 if there is no embedded language
      
      Returns 3 if mode name is the same.
      */
      status=_EmbeddedStart(orig_values,'');
      switch(status) {
      case 2:  
         // Skip this unknown embedded text.
         gdo_search=0;
         break;
      case 1:
         // Must do embedded processing for this mode
         ext=p_extension;
         index=find_index(ext'-proc-search',PROC_TYPE)
         if ( !index_callable(index) ) {
            gdo_search=0;
         } else {
            //messageNwait('do embedded');
            gpfncur_proc_search=name_index2funptr(index);
            find_first=1;
            //messageNwait('name='name_name(index)' 'gpfncur_proc_search);
            break;
         }
      case 3:  //embedded mode name is the same.
      case 0:  //We are not in an embedded language
         // We are not in an embedded language
         gpfncur_proc_search=gpfnouter_proc_search;
         find_first=1;
         //messageNwait('not embedded');
      }
      _EmbeddedEnd(orig_values);
      first_time=0;
   }
   grecursion=0;
   return(1);
}

int html_proc_search(_str &proc_name,int find_first)
{
   return(_EmbeddedProcSearch(0,proc_name,find_first,arg(3),arg(4)));
}
int csh_proc_search(_str &proc_name,int find_first)
{
   return(_EmbeddedProcSearch(0,proc_name,find_first,arg(3),arg(4)));
}
int bourneshell_proc_search(_str &proc_name,int find_first)
{
   return(_EmbeddedProcSearch(0,proc_name,find_first,arg(3),arg(4)));
}
