#include "slick.sh"

// Default height and width when docking tool bar with SIZEBARS
#define TBDEFAULT_DOCK_WIDTH  (3500/_twips_per_pixel_x())
#define TBDEFAULT_DOCK_HEIGHT (1800/_twips_per_pixel_y())
// Default height and width when undocking tool bar with SIZEBARS
#define TBDEFAULT_UNDOCK_WIDTH  (3500/_twips_per_pixel_x())
#define TBDEFAULT_UNDOCK_HEIGHT (1800/_twips_per_pixel_y())

  // This table is modified during editor execution and
  // autorestored.
  _TOOLBAR def_toolbartab[]={
     {"_tbstandard_form",TBFLAG_NEW_TOOLBAR,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbtools_form",TBFLAG_NEW_TOOLBAR,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbedit_form",TBFLAG_NEW_TOOLBAR,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbseldisp_form",TBFLAG_NEW_TOOLBAR,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbprops_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbslickc_stack_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbFTPClient_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbproject_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
     {"_tboutput_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
  };
  // This table should not be changed durring editor execution.
  // def_toolbartab is initialized to this table.
  static _TOOLBAR init_toolbartab[]={
     {"_tbstandard_form",TBFLAG_NEW_TOOLBAR,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbtools_form",TBFLAG_NEW_TOOLBAR,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbedit_form",TBFLAG_NEW_TOOLBAR,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbseldisp_form",TBFLAG_NEW_TOOLBAR,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbprops_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbslickc_stack_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbFTPClient_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
     {"_tbproject_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
     {"_tboutput_form",TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0,0,0,0,0,0,0,0,0,0,0},
  };
#define USER_FORM_PREFIX "tbform"

struct BBDOCKINFO {
// NOTE: A rowbreak is necessary if one of the previous tool bares has the
// TBFLAG_SIZEBARS flag.
#define BBDOCKINFO_ROWBREAK   0
   int wid;      // wid of toolbox or one of the constants above
   int twspace;  // wid>0 && !(tbflags & TBFLAG_SIZEBARS): Space in twips before this control
                 // wid>0 && (tbflags & TBFLAG_SIZEBARS): Initial width (TOP/BOT) or height (LEFT/RIGHT)
                 // wid=BBDOCKINFO_ROWBREAK:  !=0 Means window id of SIZEBAR
                 //                    for the entire row.
   int sizebarAfterWid;
                 // wid>0 && wid.p_border!=BDS_NONE: wid of SIZEBAR
                 // wid>0 && wid.p_border==BDS_NONE: wid of line
   int tbflags;
   int docked_row;  // wid=BBDOCKINFO_ROWBREAK:  Restore row index
                     // When a row is inserted we insert a restore row number
                     // to perform smart redocking.
};

// First index of this array is with p_isbutton_bar 1..4. 0 is null
BBDOCKINFO gbbdockinfo[/* 1..4*/][];

static struct TBCONTROL {
   _str name;     // Name of bitmap. If starts with tab character,
                  // one of the following special names
                  //    button
                  //    _tbsearch_hist_etab
                  //    space1
                  //    space2
                  //    space3
                  //    space4
                  //    space5
                  //    space6

   _str command;  // Command to execute, can be ""
   _str msg;      // tool tip message, can be ""
};

struct TBDEFAULTLIST {
   _str FormName;
   TBCONTROL CtrlList[];   // Bitmap info
};
#define BB_XSPACE 90
struct SPECIALCONTROL {
   int object;
   int width;  // width in twips.  Can be zero
   int height;  // height in twips. Can be zero
   _str name;
   _str eventtab_name;
   _str eventtab2_name;
   _str description;  // Help description for what control does
};
#define CUSTOMIZE_HELP_STRING "Click with right mouse button and select \"Properties...\" to customize."
static SPECIALCONTROL gtwSpecialControlTab:[]={
   '_tbsearch_hist_etab'=>{OI_COMBO_BOX,2500,0,"_tbsearch_hist_etab","_tbsearch_hist_etab","_ul2_combobx","Search History"},
   '_tbcontext_combo_etab'=>{OI_COMBO_BOX,2500,0,"_tbcontext_combo_etab","_tbcontext_combo_etab","_ul2_combobx","Current Context"},
   'button'=>{OI_IMAGE,0,0,"","","",CUSTOMIZE_HELP_STRING},
   //'button'=>{OI_BUTTON,380,1220,"","",""},
   'space1'=>{OI_IMAGE,BB_XSPACE,0,"","_ul2_picture","",""},
   'space2'=>{OI_IMAGE,BB_XSPACE*2,0,"","_ul2_picture","",""},
   'space3'=>{OI_IMAGE,BB_XSPACE*3,0,"","_ul2_picture","",""},
   'space4'=>{OI_IMAGE,BB_XSPACE*4,0,"","_ul2_picture","",""},
   'space5'=>{OI_IMAGE,BB_XSPACE*5,0,"","_ul2_picture","",""},
   'space6'=>{OI_IMAGE,BB_XSPACE*6,0,"","_ul2_picture","",""},
};
static TBDEFAULTLIST gToolbarDefaultTab[] = {
   { "_tbstandard_form",
      {
         { 'bbnew.bmp','new','Creates an empty file to edit'}
         ,{ 'bbopen.bmp','gui-open','Opens a file for editing'}
         ,{ 'bbsave.bmp','save','Saves current file'}
         ,{ 'bbprint.bmp','gui-print','Prints current file'}
         ,{ "\tspace1",'',''}
         ,{ 'bbcut.bmp','cut','Deletes selected text and copies it to the clipboard'}
         ,{ 'bbcopy.bmp','copy-to-clipboard','Copies selected text to the clipboard'}
         ,{ 'bbpaste.bmp','paste','Inserts clipboard into current file'}
         ,{ "\tspace1",'',''}
         ,{ 'bbundo.bmp','undo','Undoes the last edit operation'}
         ,{ 'bbfind.bmp','gui-find','Searches for a string you specify'}
         ,{ 'bbfindn.bmp','find-next','Searches for the next occurence of the string you last searched'}
         ,{ "\tspace1",'',''}
         ,{ 'bbreplac.bmp','gui-replace','Searches for a string and replace it with another string'}
         ,{ 'bbnexter.bmp','next-error','Processes the next compile or make error message'}
         ,{ 'bbmake.bmp','project-make','Runs the make command for the current project'}
         ,{ 'bbcomp.bmp','project-compile','Runs the compile command for the current project'}
         ,{ "\tspace1",'',''}
         ,{ 'bbqmark.bmp','wh','SDK or Slick-C help on word at cursor'}
         ,{ 'bbchkin.bmp','vccheckin','Checks in current file into version control system'}
         ,{ 'bbchkout.bmp','vccheckout','Checks out current file from version control system'}
         ,{ "\tspace1",'',''}
         ,{ 'bbselcbk.bmp','select-code-block','Select lines in the current code block'}
         ,{ 'bbhtview.bmp','html-preview','Brings up WEB browser or displays HTML file in WEB browser'}
         //,{ 'bbbeauty.bmp','gui_beautify','Displays C/C++/Java Beautify dialog box'},
      },
   },
   { "_tbtools_form",
     {
        { 'bbbeauty.bmp','c_beautify_selection','Beautify selection or entire buffer'},
        { 'bbdiff.bmp','diff','Runs the diff editor on two files you choose'},
        { 'bbmerge.bmp','merge','Merge two sets of changes made to a file'},
        { 'bbffile.bmp','find-file','Searches for file'},
        { 'bbcalc.bmp','calculator','Displays calculator dialog box'},
        { 'bbcprmt.bmp','dos','Runs the operating system command shell'},
        { 'bbspell.bmp','spell-check M','Spell checks from cursor or selected text'},
        { 'bbhexed.bmp','hex','Toggles hex editing'},
     }
   },
   { "_tbedit_form",
     {
        { 'bblcase.bmp','maybe-lowcase-selection','Translates characters in current word or selection to lower case'},
        { 'bbupcase.bmp','maybe-upcase-selection','Translates characters in current word or selection to upper case'},
        { 'bbbkshfl.bmp','shift-selection-left','Left shifts selection'},
        { 'bbbkshfr.bmp','shift-selection-right','Right shifts selection'},
        { 'bbreflow.bmp','reflow-selection','Word wraps current paragraph or selection'},
        { 'bbisel.bmp','indent-selection','Indents selected text'},
        { 'bbuisel.bmp','unindent-selection','Unindents selected text'},
        { 'bbt2s.bmp','convert_tabs2spaces','Converts tabs to spaces'},
        { 'bbs2t.bmp','convert_spaces2tabs','Converts indentation spaces to tabs'},
        { 'bbpmatch.bmp','find-matching-paren','Finds the matching parenthesis or begin/end structure pairs'},
     }
   },
   { "_tbseldisp_form",
     {
        { 'bbfnhdr.bmp','show-procs','Outlines current file with function headings'},
        { 'bbhidcbk.bmp','hide-code-block','Hides lines inside current code block'},
        { 'bbseldis.bmp','selective-display','Displays Selective Display dialog box'},
        { 'bbhidsel.bmp','hide-selection','Hides selected lines'},
        { 'bbshall.bmp','show-all','Ends selective display.  All lines are displayed and outline bitmaps are removed.'},
     }
   },
};
static struct _BBE_CBITMAP {
   _str name;
   _str command;
   _str msg;
};


static struct TBCATLIST {
   _str name;                // Category name
   TBCONTROL CtrlList[];   // Bitmap info
};

// Some of these entries are replicated throughout the array.
static TBCATLIST gToolbarCatTab[] = {
   { "Custom Button",
      {
         { "\tbutton",'',''},
      }
   },
   { "User Definable Tools",
      {
        { 'bbtool1.bmp','',CUSTOMIZE_HELP_STRING},
        { 'bbtool2.bmp','',CUSTOMIZE_HELP_STRING},
        { 'bbtool3.bmp','',CUSTOMIZE_HELP_STRING},
        { 'bbtool4.bmp','',CUSTOMIZE_HELP_STRING},
        { 'bbtool5.bmp','',CUSTOMIZE_HELP_STRING},
        { 'bbtool6.bmp','',CUSTOMIZE_HELP_STRING},
        { 'bbtool7.bmp','',CUSTOMIZE_HELP_STRING},
        { 'bbtool8.bmp','',CUSTOMIZE_HELP_STRING},
        { 'bbtool9.bmp','',CUSTOMIZE_HELP_STRING},
      }
   },
   { "Edits and Selections",
      {
         { 'bbcut.bmp','cut','Deletes selected text and copies it to the clipboard'},
         { 'bbcopy.bmp','copy-to-clipboard','Copies selected text to the clipboard'},
         { 'bbpaste.bmp','paste','Inserts clipboard into current file'},
         { 'bbundo.bmp','undo','Undoes the last edit operation'},
         { 'bbredo.bmp','redo','Redoes the undos'},
         { 'bblstclp.bmp','list-clipboards','Inserts a clipboard selected from a list of your recently created clipboards'},
         { 'bbselcbk.bmp','select-code-block','Select lines in the current code block'},
         { 'bbpmatch.bmp','find-matching-paren','Finds the matching parenthesis or begin/end structure pairs'},
         { 'bbisel.bmp','indent-selection','Indents selected text'},
         { 'bbuisel.bmp','unindent-selection','Unindents selected text'},
         { 'bblcase.bmp','maybe-lowcase-selection','Translates characters in current word or selection to lower case'},
         { 'bbupcase.bmp','maybe-upcase-selection','Translates characters in current word or current selection to upper case'},
         { 'bbreflow.bmp','reflow-selection','Word wraps current paragraph or selection'},
         { 'bbspell.bmp','spell-check M','Spell checks from cursor or selected text'},
         { 'bbbkshfl.bmp','shift-selection-left','Left shifts selection'},
         { 'bbbkshfr.bmp','shift-selection-right','Right shifts selection'},
         { 'bbt2s.bmp','convert_tabs2spaces','Converts tabs to spaces'},
         { 'bbs2t.bmp','convert_spaces2tabs','Converts indentation spaces to tabs'},
         { 'bbbeauty.bmp','c_beautify_selection','Beautify selection or entire buffer'}
      }
   },
   { "Files and Buffers",
      {
         { 'bbopen.bmp','gui-open','Opens a file for editing'},
         { 'bbnew.bmp','new','Creates an empty file to edit'},
         { 'bbsave.bmp','save','Saves current file'},
         { 'bbnxtbuf.bmp','next-doc','Switches to next buffer'},
         { 'bbprvbuf.bmp','prev-doc','Switches to previous buffer'},
         { 'bbbuflst.bmp','list-buffers','Lists all buffers'},
         { 'bbdiff.bmp','diff','Runs the diff editor on two files you choose'},
         { 'bbmerge.bmp','merge','Merge two sets of changes made to a file'},
         { 'bbfilcmp.bmp','compare','Compares two files'},
         { 'bbnxtwin.bmp','next-window','Switches to next edit window'},
         { 'bbprvwin.bmp','prev-window','Switches to previous edit window'},
         { 'bbprint.bmp','gui-print','Prints current file'},
         { 'bbffile.bmp','find-file','Searches for file'},
         { 'bbt2s.bmp','convert_tabs2spaces','Converts all tabs to spaces'},
         { 'bbs2t.bmp','convert_spaces2tabs','Converts indentation spaces to tabs'}
      }
   },
   { "Searching",
      {
         { 'bbfind.bmp','gui-find','Searches for a string you specify'},
         { 'bbfindn.bmp','find-next','Searches for the next occurence of the string you last searched'},
         { 'bbfword.bmp','quick-search','Searches for word at cursor'},
         { 'bbffile.bmp','find-file','Searches for file'},
         { 'bbnexter.bmp','next-error','Processes the next compile or make error message'},
         { 'bbnfunc.bmp','next-proc','Places cursor on next function definition'},
         { 'bbpfunc.bmp','prev-proc','Places cursor on previous function definition'},
         { 'bbptag.bmp','push-tag','Pushes a bookmark at the cursor and places the cursor on the tag definition'},
         { 'bbpoptag.bmp','pop-bookmark','Pops the last bookmark'},
         { 'bbreplac.bmp','gui-replace','Searches for a string and replace it with another string'},
         { 'bbpmatch.bmp','find-matching-paren','Finds the matching parenthesis or begin/end structure pairs'},
         { "\t_tbsearch_hist_etab",'',''},
      }
   },
   { "Windowing",
      {
         { 'bbcascd.bmp','cascade-windows','Cascades edit windows'},
         { 'bbtileh.bmp','tile-windows h','Horizontally tiles edit windows'},
         { 'bbtilev.bmp','tile-windows','Vertically tiles edit windows'},
         { 'bbmax.bmp','maximize-window','Maximizes current edit window'},
         { 'bbminall.bmp','iconize-all','Minimizes all edit windows'}
      }
   },
   { "Project",
      {
         { 'bbexec.bmp','project-execute','Runs the execute command in the current project'},
         { 'bbcomp.bmp','project-compile','Runs the compile command for the current project'},
         { 'bbmake.bmp','project-make','Runs the make command for the current project'},
         { 'bbnexter.bmp','next-error','Processes the next compile or make error message'},
         { 'bbdebug.bmp','project-debug','Runs the debug command for the current project'},
         { 'bbchkin.bmp','checkin','Checks files into version control system'},
         { 'bbchkout.bmp','checkout','Checks out files from version control system'}
      }
   },
   { "Selective Display",
      {
         { 'bbseldis.bmp','selective-display','Displays Selective Display dialog box'},
         { 'bbfnhdr.bmp','show-procs','Outlines current file with function headings'},
         { 'bbhidcbk.bmp','hide-code-block','Hides lines inside current code block'},
         { 'bbhidsel.bmp','hide-selection','Hides selected lines'},
         { 'bbshall.bmp','show-all','Ends selective display.  All lines are displayed and outline bitmaps are removed.'}
      }
   },
   { "Bookmarks and Tags",
      {
         { 'bbsetbmk.bmp','set-bookmark','Displays Bookmark dialog box'},
         { 'bbgobmk.bmp','goto-bookmark','Displays Go To Bookmark dialog box'},
         { 'bbpoptag.bmp','pop-bookmark','Pops the last bookmark'},
         { 'bbptag.bmp','push-tag','Pushes a bookmark at the cursor and places the cursor on the tag definition'},
         { 'bbfcthlp.bmp','function-argument-help','Display prototype(s) and highlights current argument'},
         { 'bblstmem.bmp','list-symbols','Lists valid symbols for current context'},
         { 'bbcbfind.bmp','cb-find','Find the symbol under the cursor and display in class browser'},
         { 'bbmktags.bmp','gui-make-tags','Builds tag files for use by the class browser and other tagging features'},
         { "\t_tbcontext_combo_etab",'',''},
      }
   },
   { "Macros",
      {
         { 'bbmrec.bmp','record-macro-toggle','Starts macro recording'},
         //{ 'bbsmrec.bmp','end-recording','Stops macro recording'},
         { 'bbmplay.bmp','record-macro-end-execute','Runs the last recorded macro'}
      }
   },
   { "Tools",
      {
         { 'bbcalc.bmp','calculator','Displays calculator dialog box'},
         { 'bbspell.bmp','spell-check M','Spell checks from cursor or selected text'},
         { 'bbhexed.bmp','hex','Toggles hex editing'},
         { 'bbmenued.bmp','open-menu','Edits menus'},
         { 'bbtbed.bmp','toolbars','Edits toolbars'},
         { 'bbbeauty.bmp','gui_beautify','Displays C/C++/Java Beautify dialog box'},
         { 'bbapi.bmp','api-index','API Apprentice help on current word'}
      }
   },
   { "Miscellaneous",
      {
         { 'bbqmark.bmp','wh','SDK or Slick-C help on word at cursor'},
         { 'bbapi.bmp','api-index','API Apprentice help on current word'},
         { 'bbcprmt.bmp','dos','Runs the operating system command shell'},
         { 'bbexit.bmp','safe-exit','Prompts to save files if necessary and exits the editor'},
         { 'bbhtview.bmp','html-preview','Brings up WEB browser or displays HTML file in WEB browser'},
      }
   },
   { "Space",
      {
         { "\tspace1",'',''},
         { "\tspace2",'',''},
         { "\tspace3",'',''},
         { "\tspace4",'',''},
         { "\tspace5",'',''},
         { "\tspace6",'',''},
      }
   },
};

static boolean gIgnoreInsertRestoreRow;
definit()
{
   gIgnoreInsertRestoreRow=false;
   //def_toolbartab._makeempty();
   //gbbdockinfo._makeempty();
   if (arg(1)!='L') {
		gbbdockinfo._makeempty();
      //old_gbbdocinfo._makeempty();
   }
}
int _bbdockQRestoreRow(int bbside,int i)
{
   for (;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         return(0);
      }
      if (gbbdockinfo[bbside][i].wid==BBDOCKINFO_ROWBREAK) {
         if (gbbdockinfo[bbside][i].docked_row) {
            return(gbbdockinfo[bbside][i].docked_row);
         }
      }
   }
}
int _tbQMaxRestoreRow(int bbside)
{
   max_restore_row=0;
   for (i=gbbdockinfo[bbside]._length()-1;i>=0;--i) {
      if (gbbdockinfo[bbside][i].wid==BBDOCKINFO_ROWBREAK) {
         if(gbbdockinfo[bbside][i].docked_row) {
            max_restore_row=gbbdockinfo[bbside][i].docked_row;
            break;
         }
      }
   }
   for (i=0;i<def_toolbartab._length();++i) {
      if (def_toolbartab[i].docked_bbside==bbside) {
         if (def_toolbartab[i].docked_row>max_restore_row) {
            max_restore_row=def_toolbartab[i].docked_row;
         }
      }
   }
   return(max_restore_row);
}
static void _tbInsertRestoreRow(int bbside,int docked_row)
{
   if (gIgnoreInsertRestoreRow) {
      return;
   }
   //_message_box('_tbInsertRestoreRow docked_row='docked_row' len='gbbdockinfo[bbside]._length());
   for (i=0;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         break;
      }
      if (gbbdockinfo[bbside][i].wid==BBDOCKINFO_ROWBREAK) {
         if (gbbdockinfo[bbside][i].docked_row>=docked_row) {
            ++gbbdockinfo[bbside][i].docked_row;
            //_message_box('adjust i='i' new row='gbbdockinfo[bbside][i].docked_row);
         } else {
            //_message_box('no adjust i='i' row='gbbdockinfo[bbside][i].docked_row' docked_row='docked_row);
         }
      }
   }
   //_message_box('tbInsertRestoreRow: docked_row='docked_row);
   for (i=0;i<def_toolbartab._length();++i) {
      if (def_toolbartab[i].docked_bbside==bbside) {
         if (def_toolbartab[i].docked_row>=docked_row) {
            ++def_toolbartab[i].docked_row;
         }
      }
   }
}
static int _tbLoadTemplate(int tbflags,int resource_index,int bbside_wid)
{
   orig_view_id=p_view_id;
   NoBorder="N";
   wid=_load_template(resource_index, bbside_wid,'HP':+NoBorder);
   if (!(tbflags &TBFLAG_SIZEBARS)) {
      wid.p_ToolbarBorder=VSTBBORDER_BORDER|VSTBBORDER_GRABBARS;
   }
   p_view_id=orig_view_id;
   return(wid);
}
/*
   This method operates on MDI objects only

   Insert a docable tool bar at the index position specified.
      i== 0  inserts before first tool bar
      I== -1  Inserts after last tool bar
*/
int _bbdockInsert(int bbside,int i,boolean doRowBreakBefore,boolean doRowBreakAfter,
                  int resource_index,int tbflags,int twspaceBefore)
{
   //_tbSetRefreshBy(VSTBREFRESHBY_USER);
   //say('insert i='i' doRowBreakBefore='doRowBreakBefore' 'doRowBreakAfter);
   if (i== (-1)) {
      i=gbbdockinfo[bbside]._length();
      if (i-1>=0 && gbbdockinfo[bbside][i-1].wid==BBDOCKINFO_ROWBREAK) {
         // Insert before the last row break
         if (doRowBreakBefore) {
            doRowBreakBefore=false
            doRowBreakAfter=true;
            //_message_box('got here');
         } else {
            --i;
         }
      }
   }
   if (doRowBreakBefore && doRowBreakAfter) {
      doRowBreakAfter=false;
      //_message_box('bad call');
   }
   ShiftAmount=0;
   if(doRowBreakBefore) ++ShiftAmount;
   ++ShiftAmount;
   if(doRowBreakAfter) ++ShiftAmount;

   /*if (doRowBreakBefore) {
      _message_box('doRowBreakBefore i='i);
   }
   if (doRowBreakAfter) {
      _message_box('doRowBreakAfter i='i);
   }
   */

   /*
       When we insert a row break before, current row break becomes
       the this rows row break, and the new row break is for the
       previous row.
   */
   //_message_box('bbdockinsert i='i' docked_row='_bbdockQRestoreRow(bbside,i)' len='gbbdockinfo[bbside]._length());
   if (doRowBreakBefore) {
      before_restore_row=_bbdockQRestoreRow(bbside,i);
      if (!before_restore_row) {
         //_message_box('odd case');
         before_restore_row=_tbQMaxRestoreRow(bbside)+1;
      } else {
         //_message_box('Normal case');
         _tbInsertRestoreRow(bbside,before_restore_row);
      }
   }

   for (j=gbbdockinfo[bbside]._length()-1;j>=i;--j) {
      gbbdockinfo[bbside][j+ShiftAmount]=gbbdockinfo[bbside][j];
   }
   bbside_wid=_GetButtonBar(bbside);
   // If the _bbside_form has not been loaded for this side
   if(!bbside_wid) {
      index=find_index("_bbside_form",oi2type(OI_FORM));
      _LoadButtonBar(index,bbside);
      bbside_wid=_GetButtonBar(bbside);
   }
   wid=0;

   if (doRowBreakBefore) {

      //docked_row=_bbdockAllocRestoreRow(bbside,i);
      gbbdockinfo[bbside][i].wid=BBDOCKINFO_ROWBREAK;
      gbbdockinfo[bbside][i].twspace=0;
      gbbdockinfo[bbside][i].docked_row=before_restore_row;
      ++i;
   }

   resource_i=i;
   wid=_tbLoadTemplate(tbflags,resource_index,bbside_wid);
   //messageNwait("_bbdockInsert: object="wid.p_object" wid="wid);
   gbbdockinfo[bbside][i].wid=wid;
   gbbdockinfo[bbside][i].twspace=twspaceBefore;
   gbbdockinfo[bbside][i].sizebarAfterWid=0;
   gbbdockinfo[bbside][i].tbflags=tbflags;
   ++i;

   if (doRowBreakAfter) {
      gbbdockinfo[bbside][i].wid=BBDOCKINFO_ROWBREAK;
      gbbdockinfo[bbside][i].twspace=0;
      docked_row=_bbdockQRestoreRow(bbside,i+1);
      //_message_box('doRowBreakAfter i='i' docked_row='docked_row' len='gbbdockinfo[bbside]._length());
      gbbdockinfo[bbside][i].docked_row=0;
      if (!docked_row) {
         gbbdockinfo[bbside][i].docked_row=_tbQMaxRestoreRow(bbside)+1;
      } else {
         _tbInsertRestoreRow(bbside,docked_row);
         gbbdockinfo[bbside][i].docked_row=docked_row;
      }

   }


   _bbdockAdjustRowBreaks(bbside);
   _bbdockAddRemoveSizeBars(bbside);
   return(wid);
}
/*
   Returns true if wid is found in the list of side button bars.
   bbside and are i are set so that _bbdockRemove may be called to
   delete the button bar.
*/
boolean _bbdockFindWid(int wid,int &bbside,int &i)
{
   for (bbside=1;bbside<=4;++bbside) {
      count=gbbdockinfo[bbside]._length();
      for (i=0;i<count;++i) {
         wid2=gbbdockinfo[bbside][i].wid;
         if (wid2==wid ||
             (wid2>0 && gbbdockinfo[bbside][i].sizebarAfterWid==wid) ||
             (wid2==BBDOCKINFO_ROWBREAK && gbbdockinfo[bbside][i].twspace==wid)
             ) {
            return(true);
         }
      }
   }
   return(false);
}
static void _bbdockAddRemoveSizeBars(bbside)
{
   count=gbbdockinfo[bbside]._length();
   for (i=0;i<count;++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid>0) {
         // IF there is a tool bar after this one which requires SIZEBARS
         // Now make sure the row breaks for this side have the correct
         // SIZEBAR settings.
         j=i+1;
         // If there is a tool bar after this one that is sizeable
         if (j>=0 && j<gbbdockinfo[bbside]._length() &&
             gbbdockinfo[bbside][j].wid>0 ){
            if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
               if (gbbdockinfo[bbside][j].tbflags & TBFLAG_SIZEBARS) {
                  if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
                     style=PSPIC_SIZEVERT;
                     mp=MP_SIZEVERT;
                  } else {
                     style=PSPIC_SIZEHORZ;
                     mp=MP_SIZEHORZ;
                  }
                  border_style=BDS_NONE;
               } else {
                  style=PSPIC_DEFAULT;
                  border_style=BDS_FIXED_SINGLE;
                  mp=MP_DEFAULT;
               }
               sizebarAfterWid=gbbdockinfo[bbside][i].sizebarAfterWid;
               if (!sizebarAfterWid) {
                  orig_wid=p_window_id;
                  wid=_create_window(OI_IMAGE,_GetButtonBar(bbside),"",0,0,0,0,CW_HIDDEN|CW_CHILD);
                  p_window_id=orig_wid;
                  wid.p_style=style;
                  wid.p_mouse_pointer=mp;
                  wid.p_border_style=border_style;

                  //messageNwait("_bbdockAdjustRowBreaks: style="wid.p_style" wid="wid);
                  gbbdockinfo[bbside][i].sizebarAfterWid=wid;
               } else if (sizebarAfterWid.p_style!=style) {
                  sizebarAfterWid.p_style=style;
                  sizebarAfterWid.p_mouse_pointer=mp;
                  sizebarAfterWid.p_border_style=border_style;
               }
            } else if ((gbbdockinfo[bbside][j].tbflags & TBFLAG_SIZEBARS) &&
                !(gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS)) {
               if (!gbbdockinfo[bbside][i].sizebarAfterWid) {
                  orig_wid=p_window_id;
                  wid=_create_window(OI_IMAGE,_GetButtonBar(bbside),"",0,0,0,0,CW_HIDDEN|CW_CHILD);
                  p_window_id=orig_wid;
                  wid.p_style=PSPIC_DEFAULT;
                  wid.p_mouse_pointer=MP_DEFAULT;
                  wid.p_border_style=BDS_FIXED_SINGLE;
                  //messageNwait("_bbdockAdjustRowBreaks: style="wid.p_style" wid="wid);
                  gbbdockinfo[bbside][i].sizebarAfterWid=wid;
               }
            }
         } else if (gbbdockinfo[bbside][i].sizebarAfterWid) {
            gbbdockinfo[bbside][i].sizebarAfterWid._delete_window();
            gbbdockinfo[bbside][i].sizebarAfterWid=0;
         }
      }
   }
}
/*
    Make sure we don't have two row breaks in a row.

    Add/remove row break SIZEBAR where necessary.

    Add a row break at the end if the last row has
    a tool bar which requires a SIZEBAR
*/
static void _bbdockAdjustRowBreaks(bbside)
{
   //messageNwait("_bbdockAdjustRowBreaks: IN");
#if 1
   // Remove leading row breaks
   for (j=0;j<gbbdockinfo[bbside]._length() &&
        gbbdockinfo[bbside][j].wid==BBDOCKINFO_ROWBREAK;++j) {
      if (gbbdockinfo[bbside][j].twspace) {
         gbbdockinfo[bbside][j].twspace._delete_window();
      }
      gbbdockinfo[bbside]._deleteel(j);--j;
   }
   // Now make sure the row breaks for the entire button bar have the correct
   // SIZEBAR settings.
   RowNeedsSizeBar=false;
   bbside_wid=0;
   for (j=0;j<gbbdockinfo[bbside]._length();++j) {
      wid=gbbdockinfo[bbside][j].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         // Delete duplicate row breaks
         while (j+1<gbbdockinfo[bbside]._length() &&
                gbbdockinfo[bbside][j+1].wid==BBDOCKINFO_ROWBREAK) {
            if (gbbdockinfo[bbside][j+1].twspace) {
               gbbdockinfo[bbside][j+1].twspace._delete_window();
            }
            gbbdockinfo[bbside]._deleteel(j+1);
         }
         wid=gbbdockinfo[bbside][j].twspace
         if (!wid) {
            // Add a row break SIZEBAR
            orig_wid=p_window_id;
            wid=_create_window(OI_IMAGE,bbside_wid,"",0,0,0,0,CW_HIDDEN|CW_CHILD);
            p_window_id=orig_wid;
         }
         if (RowNeedsSizeBar) {
            if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
               style=PSPIC_SIZEHORZ;
               mp=MP_SIZEHORZ;
            } else {
               style=PSPIC_SIZEVERT;
               mp=MP_SIZEVERT;
            }
            border_style=BDS_NONE;
         } else {
            style=PSPIC_DEFAULT;
            border_style=BDS_FIXED_SINGLE;
            mp=MP_DEFAULT;
         }
         // Here we sometimes make the image control invisible to prevent paint
         // problems
         if(wid.p_style!=style) {
            wid.p_visible=0;
            wid.p_style=style;
         }
         wid.p_mouse_pointer=mp;
         if(wid.p_border_style!=border_style) {
            wid.p_visible=0;
            wid.p_border_style=border_style;
         }

         gbbdockinfo[bbside][j].twspace=wid;
         if (j+1<gbbdockinfo[bbside]._length()) {
            RowNeedsSizeBar=false;
         }
         // IF this wid is a valid object handle and tool bar requires SIZEBARS
      } else if (wid>0) {
         bbside_wid=_GetButtonBar(bbside);
         if (gbbdockinfo[bbside][j].tbflags & TBFLAG_SIZEBARS) {
            RowNeedsSizeBar=true;
         }
      }
   }
   {
      j=gbbdockinfo[bbside]._length()-1;
      // IF there are any tool bars
      if (j>=0) {
         // Always place a row break after the last tool bar
         if (gbbdockinfo[bbside][j].wid!=BBDOCKINFO_ROWBREAK) {
            // Add row break at end
            j=gbbdockinfo[bbside]._length();
            gbbdockinfo[bbside][j].wid=BBDOCKINFO_ROWBREAK;
            gbbdockinfo[bbside][j].twspace=0;
            //_message_box('added row break after last toolbar!!');
            gbbdockinfo[bbside][j].docked_row=0;
            gbbdockinfo[bbside][j].docked_row=_tbQMaxRestoreRow(bbside)+1;
         }
         wid=gbbdockinfo[bbside][j].twspace;
         if (!wid) {
            orig_wid=p_window_id;
            wid=_create_window(OI_IMAGE,bbside_wid,"",0,0,0,0,CW_HIDDEN|CW_CHILD);
            p_window_id=orig_wid;
            gbbdockinfo[bbside][j].twspace=wid;
         }
         if (RowNeedsSizeBar) {
            if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
               style=PSPIC_SIZEHORZ;
               mp=MP_SIZEHORZ;
            } else {
               style=PSPIC_SIZEVERT;
               mp=MP_SIZEVERT;
            }
            border_style=BDS_NONE;
            //messageNwait("_bbdockAdjustRowBreaks: RowNeedsSizeBar");
         } else {
            style=PSPIC_DEFAULT;
            border_style=BDS_FIXED_SINGLE;
            mp=MP_DEFAULT;
            //messageNwait("_bbdockAdjustRowBreaks: BDS_FIXED_SINGLE");
         }
         // Here we sometimes make the image control invisible to prevent paint
         // problems
         if (wid.p_style!=style) {
            wid.p_style=style;
            //messageNwait("_bbdockAdjustRowBreaks: change rowbreak style");
            wid.p_visible=0;
         }
         wid.p_mouse_pointer=mp;
         if (wid.p_border_style!=border_style) {
            wid.p_border_style=border_style;
            wid.p_visible=0;
         }
      }
   }

#endif
}
/*
   This method operates on MDI objects only

   Use the _bbdockFindWid function to set bbside and i.

   This function deletes a tool bar from a button bar side.  It also removes
   space to the left and SIZEBARS if necessary.
*/
void _bbdockRemove(int bbside,int i)
{
   /*wid=gbbdockinfo[bbside][i].wid;
   messageNwait("gbbdockinfo[bbside][i].wid="wid);
   wid._delete_window(); */
   gbbdockinfo[bbside][i].wid._delete_window();

   sizebarAfterWid=gbbdockinfo[bbside][i].sizebarAfterWid;
   if(sizebarAfterWid) {
      sizebarAfterWid._delete_window();
   }
   gbbdockinfo[bbside]._deleteel(i);
   _bbdockAdjustRowBreaks(bbside);
   _bbdockAddRemoveSizeBars(bbside);
}
/*
   This method operates on MDI objects only
*/
void _bbdockMaybeRemoveButtonBar(bbside)
{
   if (!gbbdockinfo[bbside]._length() ||
       (gbbdockinfo[bbside]._length()==1 && gbbdockinfo[bbside][0].wid==BBDOCKINFO_ROWBREAK)
       ) {
      bbside_wid=_GetButtonBar(bbside);
      if (bbside_wid) {
         bbside_wid._delete_window();
      }
   }
}
static void _bbdockSetMakeAllVisible(int bbside)
{
   CMDUI cmdui;
   cmdui.menu_handle=0;
   if (_no_child_windows()) {
      target_wid=0;
   } else {
      target_wid=_mdi.p_child;
   }
   cmdui.button_wid=1;

   _OnUpdateInit(cmdui,target_wid);

   count=gbbdockinfo[bbside]._length();
   tab_index=1;
   for (i=0;i<count;++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid>0) {
         wid.p_tab_index=tab_index;++tab_index;
         if (!wid.p_visible) {
            _tbSetToolbarEnable(wid);
            wid.p_visible=1;
         }
         sizebarAfterWid=gbbdockinfo[bbside][i].sizebarAfterWid;
         if (sizebarAfterWid && !sizebarAfterWid.p_visible) {
            sizebarAfterWid.p_visible=1;
         }
      } else {
         wid=gbbdockinfo[bbside][i].twspace;
         if (wid && !wid.p_visible) {
            wid.p_visible=1;
         }
      }
   }
}
void _bbdockRefresh(int bbside)
{
   _bbdockRefresh2(bbside);
   _bbdockSetMakeAllVisible(bbside);
}
static void _bbdockAdjustLeadingSpace(int bbside)
{
   last_wid=0;
   for (i=0;i<gbbdockinfo[bbside]._length();++i) {
      if (!last_wid) {
         RemoveSpace=false;
         if (_bbdockRowHasSizeBars(bbside,i)) {
            RemoveSpace=true;
         }
      }
      wid=gbbdockinfo[bbside][i].wid;
      if (wid>0 && RemoveSpace && !(gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS)) {
         gbbdockinfo[bbside][i].twspace=0;
      }
      last_wid=wid;
   }
}
int _bbdockRowStart(int bbside,int i)
{
   // Make sure we are at the start of this row.
   while (i!=0 && gbbdockinfo[bbside][i-1].wid!=BBDOCKINFO_ROWBREAK) {
      --i;
   }
   return(i);
}
boolean _bbdockRowHasSizeBars(int bbside,int i)
{
   // Make sure we are at the start of this row.
   while (i!=0 && gbbdockinfo[bbside][i-1].wid!=BBDOCKINFO_ROWBREAK) {
      --i;
   }
   for (;i<gbbdockinfo[bbside]._length();++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         break;
      }
      if ((gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS)) {
         return(true);
      }
   }
   return(false);
}
/*
   Return height of tallest tool box between i and end of row
*/
static int _bbdockRowHeight(int bbside,int i)
{
   LastRow=false;
   if (bbside==BBSIDE_BOTTOM/* || bbside==BBSIDE_RIGHT*/) {
      // Check if this is the last row
      j=i;
      for (;j<gbbdockinfo[bbside]._length();++j) {
         wid=gbbdockinfo[bbside][j].wid;
         if (wid==BBDOCKINFO_ROWBREAK) {
            ++j;
            LastRow=(j>=gbbdockinfo[bbside]._length());
            break;
         }
      }
   }

   largest_height=0;
   for (;i<gbbdockinfo[bbside]._length();++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         break;
      }
      if ((gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS)) {
         height=wid.p_height;
      } else {
         // Place border on top of SIZEBAR or picture box border above
         height=wid.p_height; //-_twips_per_pixel_y();
         /*if (LastRow) {
            height-=_twips_per_pixel_y();
         } */
         if (height<0) height=0;
      }
      // Just to be safe. Make sure this aligns exactly on pixels
      height=_ly2dy(wid.p_xyscale_mode,height);height=_dy2ly(wid.p_xyscale_mode,height);
      if (height>largest_height) {
         largest_height=height;
      }
   }
   return(largest_height);
}
/*
   Return width of largest tool box between i and end of row
*/
static int _bbdockRowWidth(int bbside,int i)
{
   LastRow=false;
   if (bbside==BBSIDE_RIGHT) {
      // Check if this is the last row
      j=i;
      for (;j<gbbdockinfo[bbside]._length();++j) {
         wid=gbbdockinfo[bbside][j].wid;
         if (wid==BBDOCKINFO_ROWBREAK) {
            ++j;
            LastRow=(j>=gbbdockinfo[bbside]._length());
            break;
         }
      }
   }

   largest_width=0;
   for (;i<gbbdockinfo[bbside]._length();++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         break;
      }
      if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
         width=wid.p_width;
      } else {
         // Place border on top of SIZEBAR or picture box border above
         width=wid.p_width; //-_twips_per_pixel_x();
         /*if (LastRow) {
            width-=_twips_per_pixel_x();
         } */
         if (width<0) width=0;
      }
      // Just to be safe. Make sure this aligns exactly on pixels
      width=_lx2dx(wid.p_xyscale_mode,width);width=_dx2lx(wid.p_xyscale_mode,width);
      if (width>largest_width) {
         largest_width=width;
      }
   }
   return(largest_width);
}
static void _bbdockResetRowAdjustable(
    int bbside,int i
   )
{
   for (;i<gbbdockinfo[bbside]._length();++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         break;
      }
      if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
         gbbdockinfo[bbside][i].twspace=0;
      }
   }
}
static void _bbdockAdjustRowWidth(
    int bbside,int i,int ExtraWidth,
    int AdjustableWidth,int NofAdjustable,boolean AdjustAll
   )
{
   RowWidth=0;
   WidthLeft=ExtraWidth;
   start_i=i;
   for (;i<gbbdockinfo[bbside]._length();++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         break;
      }
      if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
         width=wid.p_width;
         width=_lx2dx(SM_TWIP,width);width=_dx2lx(wid.p_xyscale_mode,width);
         if (AdjustAll || !gbbdockinfo[bbside][i].twspace) {
            if (!AdjustableWidth) {
               Adjust=(ExtraWidth) intdiv NofAdjustable;
            } else {
               Adjust=(width*ExtraWidth) intdiv AdjustableWidth;
               //messageNwait("_bbdockAdjustRowWidth: Adjust="Adjust);
            }
            Adjust=_lx2dx(SM_TWIP,Adjust);Adjust=_dx2lx(wid.p_xyscale_mode,Adjust);
            if (Adjust+width<0) {
               Adjust= -width;
            }
            width+=Adjust;
            //wid.p_visible=1;messageNwait("_bbdockAdjustRowWidth: b4 width="wid.p_width" "width);
            wid.p_visible=0;
            wid.p_width=width;
            //wid.p_visible=1;messageNwait("_bbdockAdjustRowWidth: after width="wid.p_width" "width);
            WidthLeft-=Adjust;
         }
      }
   }
   if (WidthLeft<0) {
      // Add the WidthLeft to one of the SIZEBAR tool bars
      for (i=start_i;i<gbbdockinfo[bbside]._length();++i) {
         wid=gbbdockinfo[bbside][i].wid;
         if (wid==BBDOCKINFO_ROWBREAK) {
            break;
         }
         if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
            width=wid.p_width;
            if (width+WidthLeft>=0) {
               wid.p_visible=0;
               wid.p_width=width+WidthLeft;
               break;
            }
         }
      }
   } else {
      if (WidthLeft) {
         // Add the WidthLeft to one of the SIZEBAR tool bars
         for (i=start_i;i<gbbdockinfo[bbside]._length();++i) {
            wid=gbbdockinfo[bbside][i].wid;
            if (wid==BBDOCKINFO_ROWBREAK) {
               break;
            }
            if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
               width=wid.p_width;
               if (width>0) {
                  wid.p_visible=0;
                  wid.p_width=width+WidthLeft;
                  WidthLeft=0;
                  break;
               }
            }
         }
      }
      if (WidthLeft) {
         // Add the WidthLeft to one of the SIZEBAR tool bars
         for (i=start_i;i<gbbdockinfo[bbside]._length();++i) {
            wid=gbbdockinfo[bbside][i].wid;
            if (wid==BBDOCKINFO_ROWBREAK) {
               break;
            }
            if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
               wid.p_visible=0;
               wid.p_width=width+WidthLeft;
               break;
            }
         }
      }
   }

}
static void _bbdockAdjustRowHeight(
    int bbside,int i,int ExtraHeight,
    int AdjustableHeight,int NofAdjustable,boolean AdjustAll
   )
{
   RowHeight=0;
   HeightLeft=ExtraHeight;
   start_i=i;
   for (;i<gbbdockinfo[bbside]._length();++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         break;
      }
      if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
         height=wid.p_height;
         height=_ly2dy(SM_TWIP,height);height=_dy2ly(wid.p_xyscale_mode,height);
         if (AdjustAll || !gbbdockinfo[bbside][i].twspace) {
            if (!AdjustableHeight) {
               Adjust=(ExtraHeight) intdiv NofAdjustable;
            } else {
               Adjust=(height*ExtraHeight) intdiv AdjustableHeight;
               //messageNwait("_bbdockAdjustRowHeight: Adjust="Adjust);
            }
            Adjust=_ly2dy(SM_TWIP,Adjust);Adjust=_dy2ly(wid.p_xyscale_mode,Adjust);
            if (height+Adjust<0) {
               Adjust=-height;
            }
            height+=Adjust;
            //wid.p_visible=1;messageNwait("_bbdockAdjustRowHeight: b4 height="wid.p_height" "height);
            wid.p_visible=0;
            wid.p_height=height;
            //wid.p_visible=1;messageNwait("_bbdockAdjustRowHeight: after height="wid.p_height" "height);
            HeightLeft-=Adjust;
            //wid.p_visible=1;messageNwait("HeightLeft="HeightLeft" Adjust="Adjust" height="height);
         }
      }
   }
   if (HeightLeft<0) {
      // Add the HeightLeft to one of the SIZEBAR tool bars
      for (i=start_i;i<gbbdockinfo[bbside]._length();++i) {
         wid=gbbdockinfo[bbside][i].wid;
         if (wid==BBDOCKINFO_ROWBREAK) {
            break;
         }
         if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
            height=wid.p_height;
            if (height+HeightLeft>=0) {
               wid.p_visible=0;
               wid.p_height=height+HeightLeft;
               break;
            }
         }
      }
   } else {
      if (HeightLeft) {
         // Add the HeightLeft to one of the SIZEBAR tool bars
         for (i=start_i;i<gbbdockinfo[bbside]._length();++i) {
            wid=gbbdockinfo[bbside][i].wid;
            if (wid==BBDOCKINFO_ROWBREAK) {
               break;
            }
            if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
               width=wid.p_width;
               if (width>0) {
                  wid.p_visible=0;
                  wid.p_height=height+HeightLeft;
                  HeightLeft=0;
                  break;
               }
            }
         }
      }
      if (HeightLeft) {
         // Add the WidthLeft to one of the SIZEBAR tool bars
         for (i=start_i;i<gbbdockinfo[bbside]._length();++i) {
            wid=gbbdockinfo[bbside][i].wid;
            if (wid==BBDOCKINFO_ROWBREAK) {
               break;
            }
            if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
               wid.p_visible=0;
               wid.p_height=height+HeightLeft;
               break;
            }
         }
      }
   }

}
static void _bbdockGetRowAdjustableWidth(
    int bbside,int i,int &ExtraWidth,
    int &TotalAdjustableWidth,int &AdjustableWidth,int &NofAdjustable
   )
{
   next_x=0;
   TotalAdjustableWidth=0;AdjustableWidth=0;
   RowNeedsSizeBar=false;NofAdjustable=0;
   for (;i<gbbdockinfo[bbside]._length();++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         break;
      }
      new_x=next_x;
      new_width=wid.p_width;
      new_width=_lx2dx(SM_TWIP,new_width);new_width=_dx2lx(SM_TWIP,new_width);
      if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
         ++NofAdjustable;
         RowNeedsSizeBar=true;
         TotalAdjustableWidth+=new_width;
         if(!gbbdockinfo[bbside][i].twspace) {
            AdjustableWidth+=new_width;
         }
      } else {
         // IF previous tool box needs SIZEBARS
         if (i>0 && gbbdockinfo[bbside][i-1].wid>0 &&
             (gbbdockinfo[bbside][i-1].tbflags & TBFLAG_SIZEBARS)) {
         } else {
            // IF there is space before this tool box
            if (gbbdockinfo[bbside][i].twspace) {
               new_x=next_x+gbbdockinfo[bbside][i].twspace;
               new_x=_lx2dx(SM_TWIP,new_x);new_x=_dx2lx(SM_TWIP,new_x);
            } else {
               // Place left border on top of right border of previous tool bar
               new_x=next_x; //-_twips_per_pixel_x();
            }
         }
      }
      next_x=new_x+new_width;
      sizebarAfterWid=gbbdockinfo[bbside][i].sizebarAfterWid;
      if (sizebarAfterWid) {
         /*if(sizebarAfterWid.p_style==PSPIC_DEFAULT) {
             IF this SIZEBAR tool box followed by non-SIZEBAR tool box
            if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
               next_x+=_twips_per_pixel_x();
            }
         } else {
            next_x+=sizebarAfterWid.p_width;
         } */
         next_x+=sizebarAfterWid.p_width;
      }
   }
   if (!RowNeedsSizeBar) {
      ExtraWidth=0;
      return;
   }
   --i;
   // IF the last tool box has a border
   if (i>=0 && i<gbbdockinfo[bbside]._length() &&
      gbbdockinfo[bbside][i].wid>0 && !(gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS)) {
      // Place the border be off the screen
      next_x-=_twips_per_pixel_x();
   }
   bbside_wid=_GetButtonBar(bbside);
   ExtraWidth=bbside_wid.p_width-next_x;
}
static void _bbdockGetRowAdjustableHeight(
    int bbside,int i,int &ExtraHeight,
    int &TotalAdjustableHeight,int &AdjustableHeight,int &NofAdjustable
   )
{
   next_y=0;
   TotalAdjustableHeight=0;AdjustableHeight=0;
   RowNeedsSizeBar=false;NofAdjustable=0;
   for (;i<gbbdockinfo[bbside]._length();++i) {
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         break;
      }
      new_y=next_y;
      new_height=wid.p_height;
      new_height=_ly2dy(SM_TWIP,new_height);new_height=_dy2ly(wid.p_xyscale_mode,new_height);
      if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
         ++NofAdjustable;
         RowNeedsSizeBar=true;
         TotalAdjustableHeight+=new_height;
         if(!gbbdockinfo[bbside][i].twspace) {
            AdjustableHeight+=new_height;
         }
      } else {
         // IF previous tool box needs SIZEBARS
         if (i>0 && gbbdockinfo[bbside][i-1].wid>0 &&
             (gbbdockinfo[bbside][i-1].tbflags & TBFLAG_SIZEBARS)) {
         } else {
            // IF there is space before this tool box
            if (gbbdockinfo[bbside][i].twspace) {
               new_y=next_y+gbbdockinfo[bbside][i].twspace;
               new_y=_ly2dy(SM_TWIP,new_y);new_y=_ly2dy(wid.p_xyscale_mode,new_y);
            } else {
               // Place left border on top of right border of previous tool bar
               new_y=next_y; //-_twips_per_pixel_y();
            }
         }
      }
      next_y=new_y+new_height;
      sizebarAfterWid=gbbdockinfo[bbside][i].sizebarAfterWid;
      if (sizebarAfterWid) {
         /*
         if(sizebarAfterWid.p_style==PSPIC_DEFAULT) {
            // IF this SIZEBAR tool box followed by non-SIZEBAR tool box
            if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
               next_y+=_twips_per_pixel_y();
            }
         } else {
            next_y+=sizebarAfterWid.p_height;
         }
         */
         next_y+=sizebarAfterWid.p_height;
      }
   }
   if (!RowNeedsSizeBar) {
      ExtraHeight=0;
      return;
   }
   --i;
   // IF the last tool box has a border
   if (i>=0 && i<gbbdockinfo[bbside]._length() &&
      gbbdockinfo[bbside][i].wid>0 && !(gbbdockinfo[bbside][i].tbflags&TBFLAG_SIZEBARS)) {
      // Place the border be off the screen
      next_y-=_twips_per_pixel_y();
   }
   bbside_wid=_GetButtonBar(bbside);
   ExtraHeight=bbside_wid.p_height-next_y;
}
static void ProcessRowBreak(int bbside,int next_y,int wid,boolean RowNeedsSizeBar,int &line_height)
{
   wid._get_window(x,y,width,height);
   // Just to be safe. Make sure this aligns exactly on pixels
   _lxy2dxy(SM_TWIP,x,y);_dxy2lxy(wid.p_xyscale_mode,x,y);
   _lxy2dxy(SM_TWIP,width,height);_dxy2lxy(wid.p_xyscale_mode,width,height);
   new_x=0;;
   new_width=_GetButtonBar(bbside).p_width;
   //messageNwait("_bbdockRefresh2: new_width="new_width);

   if (RowNeedsSizeBar) {
      new_height=wid.p_height;
      new_y=next_y;
      line_height=new_height;
   } else {
      line_height=0;
      new_y=next_y; //-_twips_per_pixel_y();
      new_height=0; //=_twips_per_pixel_y();
      if (new_y<0) {
         new_y=0;
         line_height=new_height;
      }
      //messageNwait("1 pixel row");
   }
   if (new_x!=x || new_y!=y || new_width!=width || new_height!=height) {
      //messageNwait("_bbdockRefresh2: move row break new_y="new_y" new_width="new_width);
      wid.p_visible=0;
      wid._move_window(new_x,new_y,new_width,new_height);
   }
}
static void ProcessRowBreakWidth(int bbside,int next_x,int wid,boolean RowNeedsSizeBar,int &line_width)
{
   wid._get_window(x,y,width,height);
   // Just to be safe. Make sure this aligns exactly on pixels
   _lxy2dxy(SM_TWIP,x,y);_dxy2lxy(wid.p_xyscale_mode,x,y);
   _lxy2dxy(SM_TWIP,width,height);_dxy2lxy(wid.p_xyscale_mode,width,height);
   new_y=0;
   new_height=_GetButtonBar(bbside).p_height;
   //messageNwait("ProcessRowBreakWidth: ");
   //messageNwait("_bbdockRefresh2: new_width="new_width);

   if (RowNeedsSizeBar) {
      new_width=wid.p_width;
      new_x=next_x;
      line_width=new_width;
   } else {
      line_width=0;
      new_x=next_x; //-_twips_per_pixel_x();
      new_width=0; //_twips_per_pixel_x();
      if (new_x<0) {
         new_x=0;
         line_width=new_width;
      }
      //messageNwait("1 pixel row");
   }
   if (new_x!=x || new_y!=y || new_width!=width || new_height!=height) {
      //messageNwait("_bbdockRefresh2: move row break new_y="new_y" new_width="new_width);
      wid.p_visible=0;
      wid._move_window(new_x,new_y,new_width,new_height);
      //wid.p_visible=1;messageNwait("ProcessRowBreakWidth: move row break new_x="new_x" new_heigth="new_height);
   }
}
static int dcount;
static void _bbdockRefresh2(int bbside)
{
   // If this side has no button bar
   if (!_GetButtonBar(bbside)) {
      return;
   }
   ++dcount;
   if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
      // Start from upper left corner
      next_x=0;next_y=0;
      last_wid=0;
      line_height=0;
      for (i=0;;++i) {
         if (i>=gbbdockinfo[bbside]._length()) {
            next_y+=line_height;
            break;
         }
         if (!last_wid) {
            next_y+=line_height;
            next_x=0;
            line_height=_bbdockRowHeight(bbside,i);
            RowNeedsSizeBar=false;
            _bbdockGetRowAdjustableWidth(bbside,i,ExtraWidth,TotalAdjustableWidth,AdjustableWidth,NofAdjustable);
            // IF the are any controls with SIZEBARS AND some widths need
            //    to be adjusted
            //messageNwait("dcount="dcount" NofA="NofAdjustable" TotalAW="TotalAdjustableWidth" ExtraW="ExtraWidth" AW="AdjustableWidth);
            if (NofAdjustable) {
               if(ExtraWidth) {
                  // If sum is too small. (Resized MDI window,controls deleted, new screen res)
                  if (ExtraWidth>0) {
                     _bbdockAdjustRowWidth(bbside,i,ExtraWidth,TotalAdjustableWidth,NofAdjustable,true/* AdjustAll*/);
                  } else {
                     // Tool bars don't fit
                     if (-ExtraWidth>AdjustableWidth) {
                        _bbdockAdjustRowWidth(bbside,i,ExtraWidth,TotalAdjustableWidth,NofAdjustable,true/* AdjustAll*/);
                     } else {
                        _bbdockAdjustRowWidth(bbside,i,ExtraWidth,AdjustableWidth,NofAdjustable,false/* AdjustAll*/);
                     }
                  }
               }
               _bbdockResetRowAdjustable(bbside,i);
            }
            if (bbside==BBSIDE_BOTTOM) {
               // Look ahead for ROWBREAK info and draw
               // SIZEBAR here
               j=i;
               for (;j<gbbdockinfo[bbside]._length();++j) {
                  wid=gbbdockinfo[bbside][j].wid
                  if (wid==BBDOCKINFO_ROWBREAK) {
                     wid=gbbdockinfo[bbside][j].twspace;
                     ProcessRowBreak(bbside,next_y,wid,RowNeedsSizeBar,RowBreakLineHeight);
                     //messageNwait("_bbdockRefresh2: RowBreakLineHeight="RowBreakLineHeight);
                     next_y+=RowBreakLineHeight;
                     break;
                  } else if (wid>0 && (gbbdockinfo[bbside][j].tbflags&TBFLAG_SIZEBARS)) {
                     RowNeedsSizeBar=true;
                  }
               }
            }
         }
         wid=gbbdockinfo[bbside][i].wid;
         last_wid=wid;
         if (wid>0) {
            wid._get_window(x,y,width,height);
            // Just to be safe. Make sure this aligns exactly on pixels
            _lxy2dxy(SM_TWIP,x,y);_dxy2lxy(wid.p_xyscale_mode,x,y);
            _lxy2dxy(SM_TWIP,width,height);_dxy2lxy(wid.p_xyscale_mode,width,height);
            new_width=width;new_height=height;
            new_y=next_y;
            if (gbbdockinfo[bbside][i].tbflags &TBFLAG_SIZEBARS) {
               new_x=next_x;
               RowNeedsSizeBar=true;
               new_height=line_height;
            } else {
               //_GetButtonBar(bbside).p_height+=200;
               //messageNwait("wid.p_height="wid.p_height" frmh=",_GetButtonBar(BBSIDE_TOP).p_height);
               // Place border on top of SIZEBAR or picture box border above
               // IF previous tool box need SIZEBARS
               if (i>0 && gbbdockinfo[bbside][i-1].wid>0 &&
                   (gbbdockinfo[bbside][i-1].tbflags &TBFLAG_SIZEBARS)) {
                  new_x=next_x;//-_twips_per_pixel_x();
               } else {
                  // IF there is space before this tool box
                  if (gbbdockinfo[bbside][i].twspace) {
                     new_x=next_x+gbbdockinfo[bbside][i].twspace;
                     new_x=_lx2dx(SM_TWIP,new_x);new_x=_dx2lx(wid.p_xyscale_mode,new_x);
                  } else {
                     // IF this is the first toolbar in this row
                     if (i==0 || gbbdockinfo[bbside][i-1].wid==BBDOCKINFO_ROWBREAK) {
                        new_x=next_x-_twips_per_pixel_x();
                     } else {
                        // The previous tool box on this row CAN'T need SIZEBARS
                        // Place left border on top of right border of previous tool bar
                        new_x=next_x;//-_twips_per_pixel_x();
                     }
                  }
               }

            }
            if (new_x!=x || new_y!=y || new_width!=width || new_height!=height) {
               //messageNwait("_bbdockRefresh2: move tool box");
               wid.p_visible=0;
               wid._move_window(new_x,new_y,new_width,new_height);
               //wid.p_visible=1;messageNwait("new_height="new_height" line_height="line_height);
            }
            next_x=new_x+new_width;
            sizebarAfterWid=gbbdockinfo[bbside][i].sizebarAfterWid;
            if (sizebarAfterWid) {
               new_width=sizebarAfterWid.p_width;
               if (sizebarAfterWid.p_style==PSPIC_DEFAULT) {
                  new_width=_twips_per_pixel_x();
                  if (new_width!=sizebarAfterWid.p_width) {
                     sizebarAfterWid.p_visible=0;
                     sizebarAfterWid.p_width=new_width;
                  }
                  if (gbbdockinfo[bbside][i].tbflags & TBFLAG_SIZEBARS) {
                     new_x=next_x;
                  } else {
                     new_x=next_x; //-_twips_per_pixel_x();
                  }
                  //new_x+=_twips_per_pixel_x()*2;
               } else {
                  new_x=next_x;
               }
               if (sizebarAfterWid.p_x!=new_x) {
                  sizebarAfterWid.p_visible=0;
                  //messageNwait("_bbdockRefresh2: move SIZEBAR");
                  sizebarAfterWid.p_x=new_x;
               }
               if (sizebarAfterWid.p_y!=next_y) {
                  sizebarAfterWid.p_visible=0;
                  sizebarAfterWid.p_y=next_y;
               }
               if (sizebarAfterWid.p_height!=line_height) {
                  sizebarAfterWid.p_visible=0;
                  //messageNwait("_bbdockRefresh2: move SIZEBAR");
                  sizebarAfterWid.p_height=line_height;
                  //messageNwait("_bbdockRefresh2: line_height="line_height" height="sizebarAfterWid.p_height" wid="sizebarAfterWid);
               }
               /*if (!sizebarAfterWid.p_visible) {
                  sizebarAfterWid.p_visible=1;
               } */
               next_x=new_x+sizebarAfterWid.p_width;
            }
         } else {
            // Process row break
            wid=gbbdockinfo[bbside][i].twspace;
            if (wid && bbside==BBSIDE_TOP) {
               ProcessRowBreak(bbside,next_y+line_height,wid,RowNeedsSizeBar,RowBreakLineHeight);
               next_y+=RowBreakLineHeight;
               //messageNwait("_bbdockRefresh2: b4 next_y="next_y);
               /*if (!wid.p_visible) {
                  wid.p_visible=1;
               } */
               //messageNwait("row break rect="wid.p_x" "wid.p_y" "wid.p_width" "wid.p_height" style="wid.p_style);
            }
         }
      }
      //next_y+=RowBreakLineHeight;
      height=_GetButtonBar(bbside).p_height;
      height=_ly2dy(SM_TWIP,height);height=_dy2ly(SM_TWIP,height);

      // IF the last row of toolbars has a row break
      j=gbbdockinfo[bbside]._length()-1;
      if (j>=0) {
         if (gbbdockinfo[bbside][j].wid==BBDOCKINFO_ROWBREAK) {
            if (!RowNeedsSizeBar) {
               next_y-=_twips_per_pixel_y();;
               //say('No sizebars');
            } else {
               next_y-=_twips_per_pixel_y()*2;
            }
         }
      }
      if (height!=next_y) {
         //messageNwait("_bbdockRefresh2: Adjust bbside height next_y="next_y" h="_GetButtonBar(bbside).p_height);
         //_GetButtonBar(bbside).p_height=(next_y+10)-_twips_per_pixel_y()*2;
         //messageNwait("_bbdockRefresh2: h1");
         _GetButtonBar(bbside).p_height=next_y;
         //messageNwait("_bbdockRefresh2: h2");
         //messageNwait("_bbdockRefresh2: h2 Adjust bbside height next_y="next_y" h="_GetButtonBar(bbside).p_height);
      }
      return;
   }
   //messageNwait("_bbdockRefresh2: h1");
   // Start from upper left corner
   next_x=0;next_y=0;
   last_wid=0;
   line_height=0;
   for (i=0;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         next_x+=line_height;
         break;
      }
      if (!last_wid) {
         next_x+=line_height;
         next_y=0;
         line_height=_bbdockRowWidth(bbside,i);
         RowNeedsSizeBar=false;
         _bbdockGetRowAdjustableHeight(bbside,i,ExtraWidth,TotalAdjustableWidth,AdjustableWidth,NofAdjustable);
         // IF the are any controls with SIZEBARS AND some widths need
         //    to be adjusted
         //++dcount;
         //messageNwait(" len="gbbdockinfo[bbside]._length()" dcount="dcount" NofA="NofAdjustable" TotalAW="TotalAdjustableWidth" ExtraW="ExtraWidth" AW="AdjustableWidth);
         if (NofAdjustable) {
            if(ExtraWidth) {
               // If sum is too small. (Resized MDI window,controls deleted, new screen res)
               if (ExtraWidth>0) {
                  _bbdockAdjustRowHeight(bbside,i,ExtraWidth,TotalAdjustableWidth,NofAdjustable,true/* AdjustAll*/);
               } else {
                  // Tool bars don't fit
                  if (-ExtraWidth>AdjustableWidth) {
                     _bbdockAdjustRowHeight(bbside,i,ExtraWidth,TotalAdjustableWidth,NofAdjustable,true/* AdjustAll*/);
                  } else {
                     _bbdockAdjustRowHeight(bbside,i,ExtraWidth,AdjustableWidth,NofAdjustable,false/* AdjustAll*/);
                  }
               }
            }
            _bbdockResetRowAdjustable(bbside,i);
         }
         if (bbside==BBSIDE_RIGHT) {
            // Look ahead for ROWBREAK info and draw
            // SIZEBAR here
            j=i;
            for (;j<gbbdockinfo[bbside]._length();++j) {
               wid=gbbdockinfo[bbside][j].wid;
               if (wid==BBDOCKINFO_ROWBREAK) {
                  wid=gbbdockinfo[bbside][j].twspace;
                  ProcessRowBreakWidth(bbside,next_x,wid,RowNeedsSizeBar,RowBreakLineHeight);
                  //messageNwait("_bbdockRefresh2: RowBreakLineHeight="RowBreakLineHeight);
                  next_x+=RowBreakLineHeight;
                  break;
               } else if (wid>0 && (gbbdockinfo[bbside][j].tbflags & TBFLAG_SIZEBARS)) {
                  RowNeedsSizeBar=true;
               }
            }
         }
      }
      wid=gbbdockinfo[bbside][i].wid;
      if (wid>0) {
         wid._get_window(x,y,width,height);
         // Just to be safe. Make sure this aligns exactly on pixels
         _lxy2dxy(SM_TWIP,x,y);_dxy2lxy(SM_TWIP,x,y);
         _lxy2dxy(SM_TWIP,width,height);_dxy2lxy(SM_TWIP,width,height);
         new_width=width;new_height=height;
         new_x=next_x;
         if (gbbdockinfo[bbside][i].tbflags& TBFLAG_SIZEBARS) {
            new_y=next_y;
            RowNeedsSizeBar=true;
            new_width=line_height;
         } else {
            //_GetButtonBar(bbside).p_height+=200;
            //messageNwait("wid.p_height="wid.p_height" frmh=",_GetButtonBar(BBSIDE_TOP).p_height);
            // Place border on top of SIZEBAR or picture box border above
            // IF previous tool box need SIZEBARS
            if (i>0 && gbbdockinfo[bbside][i-1].wid>0 &&
                (gbbdockinfo[bbside][i-1].tbflags &TBFLAG_SIZEBARS)) {
               new_y=next_y;//-_twips_per_pixel_y();
            } else {
               // IF there is space before this tool box
               if (gbbdockinfo[bbside][i].twspace) {
                  new_y=next_y+gbbdockinfo[bbside][i].twspace;
                  new_y=_ly2dy(SM_TWIP,new_y);new_y=_dy2ly(SM_TWIP,new_y);
               } else {
                  // IF this is the first toolbar in this row
                  if (i==0 || gbbdockinfo[bbside][i-1].wid==BBDOCKINFO_ROWBREAK) {
                     new_y=next_y-_twips_per_pixel_y();
                  } else {
                     // The previous tool box on this row CAN'T need SIZEBARS
                     // Place left border on top of right border of previous tool bar
                     new_y=next_y; //-_twips_per_pixel_y();
                  }
               }
            }

         }
         if (new_x!=x || new_y!=y || new_width!=width || new_height!=height) {
            wid.p_visible=0;
            wid._move_window(new_x,new_y,new_width,new_height);
            //wid.p_visible=1;messageNwait("new_height="new_height" line_height="line_height);
            //wid.p_visible=1;messageNwait("_bbdockRefresh2: move tool box wid="wid" height="new_height);
         }
         if (!wid.p_visible) {
            //wid.p_visible=1;
         }
         next_y=new_y+new_height;
         sizebarAfterWid=gbbdockinfo[bbside][i].sizebarAfterWid;
         if (sizebarAfterWid) {
            new_height=sizebarAfterWid.p_height;
            if (sizebarAfterWid.p_style==PSPIC_DEFAULT) {
               new_height=0; //_twips_per_pixel_y();
               if (new_height!=sizebarAfterWid.p_height) {
                  sizebarAfterWid.p_visible=0;
                  sizebarAfterWid.p_height=new_height;
               }
               if (gbbdockinfo[bbside][i].tbflags &TBFLAG_SIZEBARS) {
                  new_y=next_y;
               } else {
                  new_y=next_y;//-_twips_per_pixel_y();
               }
               //new_x+=_twips_per_pixel_x()*2;
            } else {
               new_y=next_y;
            }
            if (sizebarAfterWid.p_y!=new_y) {
               sizebarAfterWid.p_visible=0;
               //messageNwait("_bbdockRefresh2: move SIZEBAR");
               sizebarAfterWid.p_y=new_y;
            }
            if (sizebarAfterWid.p_x!=next_x) {
               sizebarAfterWid.p_visible=0;
               sizebarAfterWid.p_x=next_x;
            }
            if (sizebarAfterWid.p_width!=line_height) {
               sizebarAfterWid.p_visible=0;
               //messageNwait("_bbdockRefresh2: move SIZEBAR");
               sizebarAfterWid.p_width=line_height;
               //messageNwait("_bbdockRefresh2: line_height="line_height" height="sizebarAfterWid.p_height" wid="sizebarAfterWid);
            }
            /*if (!sizebarAfterWid.p_visible) {
               sizebarAfterWid.p_visible=1;
            } */
            next_y=new_y+sizebarAfterWid.p_height;
         }
      } else {
         // Process row break
         temp_wid=gbbdockinfo[bbside][i].twspace;
         // IF this is a SIZEBAR on the left
         if (temp_wid && bbside==BBSIDE_LEFT) {
            ProcessRowBreakWidth(bbside,next_x+line_height,temp_wid,RowNeedsSizeBar,RowBreakLineHeight);
            next_x+=RowBreakLineHeight;
            //messageNwait("_bbdockRefresh2: b4 next_y="next_y);
            /*if (!wid.p_visible) {
               wid.p_visible=1;
            } */
            //messageNwait("row break rect="wid.p_x" "wid.p_y" "wid.p_width" "wid.p_height" style="wid.p_style);
         }
      }
      last_wid=wid;
   }
   //next_y+=RowBreakLineHeight;
   width=_GetButtonBar(bbside).p_width;
   width=_lx2dx(SM_TWIP,width);width=_dx2lx(SM_TWIP,width);
   //next_x=next_x*2;
   // IF the last row of toolbars has a row break
   j=gbbdockinfo[bbside]._length()-1;
   if (j>=0) {
      if (gbbdockinfo[bbside][j].wid==BBDOCKINFO_ROWBREAK) {
         if (!RowNeedsSizeBar) {
            next_x-=_twips_per_pixel_x();
            //say('No sizebars');
         } else {
            next_x-=_twips_per_pixel_x()*2;
         }
      }
   }
   if (width!=next_x) {
      //messageNwait("_bbdockRefresh2: Adjust bbside height next_y="next_y" h="_GetButtonBar(bbside).p_height);
      //_GetButtonBar(bbside).p_height=(next_y+10)-_twips_per_pixel_y()*2;
      //messageNwait("_bbdockRefresh2: h1");
      _GetButtonBar(bbside).p_width=next_x;
      //messageNwait("_bbdockRefresh2: h2");
      //messageNwait("_bbdockRefresh2: h2 Adjust bbside height next_y="next_y" h="_GetButtonBar(bbside).p_height);
   }
   return;
}
defeventtab _bbside_form
_bbside_form.rbutton_up()
{
   tbNewVersion();
   orig_wid=p_window_id;
   index=find_index("_toolbar_menu",oi2type(OI_MENU))
   if (!index) {
      return(STRING_NOT_FOUND_RC);
   }
   DeleteBindingMenuItem=true;
   if(p_object==OI_IMAGE && !_ImageIsSpace() && !p_eventtab) {
      DeleteBindingMenuItem=false;
   }

   menu_handle=p_active_form._menu_load(index,'P');
   _menu_get_state(menu_handle,0,mf_flags,'p',caption,command,
                   categories,help_command,help_message);
   if (command=="tbControlProperties") {
      if (DeleteBindingMenuItem) {
         _menu_delete(menu_handle,0);
      } else {
         _menu_set_state(menu_handle,0,mf_flags,'p',caption,"tbControlProperties "orig_wid,
                   categories,help_command,help_message);
      }
   }

   _menu_insert(menu_handle,-1,MF_ENABLED,"-");
   // Append tool bars
   for (i=0;i<def_toolbartab._length();++i) {
      _TOOLBAR *ptb;
      ptb= &def_toolbartab[i];
      flag=MF_ENABLED;
      wid=_tbIsVisible(ptb->FormName);
      if (wid) {
         //messageNwait("_bbside_form.rbutton_up: N="ptb->FormName" wid="wid" n="wid.p_name);
         _menu_insert(menu_handle,-1,MF_ENABLED|MF_CHECKED,wid.p_caption,"tbClose "wid);
      } else {
         index=find_index(ptb->FormName,oi2type(OI_FORM));
         if (index) {
            _menu_insert(menu_handle,-1,MF_ENABLED,index.p_caption,"tbShow "ptb->FormName);
         }
      }
   }
   x=100;y=100;
   x=mou_last_x('M')-x;y=mou_last_y('M')-y;
   _lxy2dxy(p_scale_mode,x,y);
   _map_xy(p_window_id,0,x,y,SM_PIXEL);
   flags=VPM_LEFTALIGN|VPM_RIGHTBUTTON;
   _KillToolTipMessages();
   status=_menu_show(menu_handle,flags,x,y)
   _menu_destroy(menu_handle);
}
void _bbside_form.on_create()
{
   switch (p_isbutton_bar) {
   case BBSIDE_TOP:
   case BBSIDE_BOTTOM:
      p_height=700;
      break;
   default:
      p_width=700;
   }
   p_old_width=p_width;
   p_old_height=p_height;
   //messageNwait("_bbside_form.on_create: width="p_width" height="p_height);
   p_user=1;  // Did on create
}
// Constants which effect SIZEBAR tool bars
void _bbside_form.on_resize()
{
   // If on_create not processed
   if (p_user=="" || !p_isbutton_bar) return;
   mdi=_mdi;
   mdi._bbdockRefresh(p_isbutton_bar);
}
void _bbside_form.lbutton_double_click()
{
   toolbars();
}
void _bbside_form.lbutton_down()
{
   focus_wid=_get_focus();
   //_restore_draw_setup(draw_setup)
   // User clicked on line or SIZEBAR
   if (p_object==OI_IMAGE && p_style==PSPIC_SIZEVERT || p_style==PSPIC_SIZEHORZ) {
      _mdi._MDIClientGetWindow(mdiclient_x,mdiclient_y,mdiclient_width,mdiclient_height);
      tb=p_isbutton_bar==BBSIDE_TOP || p_isbutton_bar==BBSIDE_BOTTOM;
      wid=_bbdockFindWid(p_window_id,bbside,i);
      // IF user clicked on row SIZEBAR
      style=p_style;
      selected_wid=orig_wid=p_window_id
      /* Limit the range of movement of the mouse to form or frame. */
      p_window_id=selected_wid.p_parent;
      if (style==PSPIC_SIZEVERT && tb) {
         // Don't let mouse move before left control or
         // after right control
         x1=gbbdockinfo[bbside][i].wid.p_x;
         wid=gbbdockinfo[bbside][i+1].wid;
         x2=wid.p_x+wid.p_width;
         x1=_lx2dx(SM_TWIP,x1);x2=_lx2dx(SM_TWIP,x2);
         mou_limit(x1,0,x2,p_client_height);
      } else if (style==PSPIC_SIZEHORZ  && !tb) {
         // Don't let mouse move before left control or
         // after right control
         y1=gbbdockinfo[bbside][i].wid.p_y;
         wid=gbbdockinfo[bbside][i+1].wid;
         y2=wid.p_y+wid.p_height;
         y1=_ly2dy(SM_TWIP,y1);y2=_ly2dy(SM_TWIP,y2);
         mou_limit(0,y1,p_client_width,y2);
      } else if (style==PSPIC_SIZEVERT && !tb) {
         p_window_id=_mdi;
      } else if (style==PSPIC_SIZEHORZ  && tb) {
         p_window_id=_mdi;
      } else {
         return;
      }

      p_fill_style=PSFS_TRANSPARENT;
      p_draw_width=0;
      p_draw_style=PSDS_INSIDE_SOLID;p_draw_mode=PSDM_XORPEN
      if (machine()=='OS2386') {
         color=_rgb(0xcc,0xcc,0xcc);
      } else {
         color=_rgb(0x80,0x80,0x80)  /* Gray */
      }
      mou_mode(1);
      mou_capture();
      _KillToolTipMessages();
      morig_x=mou_last_x('M');morig_y=mou_last_y('M');rectangle_drawn=0;
      done=0;
      selected_wid._get_window(orig_x,orig_y,orig_width,orig_height);
      if (p_object==OI_MDI_FORM) {
         _lxy2dxy(selected_wid.p_xyscale_mode,orig_x,orig_y);
         _lxy2dxy(selected_wid.p_xyscale_mode,orig_width,orig_height);
         //_lxy2dxy(selected_wid.p_xyscale_mode,morig_x,morig_y);
         _map_xy(selected_wid.p_parent,_mdi,orig_x,orig_y,SM_PIXEL);
      }
      x1=orig_x;y1=orig_y;x2=x1+orig_width;y2=y1+orig_height;
      orig_x1=x1;orig_y1=y1;orig_x2=x2;orig_y2=y2;
      //grid_x=60;grid_y=60;
      //mou_limit 0,0,p_client_width,p_client_height
      for (;;) {
         event=get_event()
         switch (event) {
         case MOUSE_MOVE:
            new_x1=x1;new_y1=y1;new_x2=x2;new_y2=y2;
            if (style==PSPIC_SIZEVERT) {
               width=x2-x1;
               new_x1=orig_x1+mou_last_x('M')-morig_x;
               new_x2=new_x1+width;
            } else {
               height=y2-y1;
               new_y1=orig_y1+mou_last_y('M')-morig_y;
               new_y2=new_y1+height;
            }
            /*if (new_x2-new_x1<smallest_width) {
               new_x1=x1;new_x2=x2;
            }
            if (new_y2-new_y1<smallest_height) {
               new_y1=y1;new_y2=y2;
            } */
            if (rectangle_drawn) {
               if (x1==new_x1 && y1==new_y1 && x2==new_x2 && y2==new_y2) {
                  break;
               }
               /* Erase the rectangle. */
               _draw_rect(x1,y1,x2,y2,color,'ed');
            }
            rectangle_drawn=1
            x1=new_x1;y1=new_y1;x2=new_x2;y2=new_y2;
            //message("y1="y1);
            _draw_rect(x1,y1,x2,y2,color,'ed')
            break;
         case LBUTTON_UP:
         case ESC:
            done=1
         }
         if( done) break;
      }
      mou_limit(0,0,0,0);
      mou_mode(0)
      mou_release();
      if (rectangle_drawn) {
         /* Erase the rectangle. */
         _draw_rect(x1,y1,x2,y2,color,'ed');
         if (event!=ESC) {
            if (style==PSPIC_SIZEVERT && tb) {
               wid1=gbbdockinfo[bbside][i].wid;
               wid2=gbbdockinfo[bbside][i+1].wid;
               adjust_x=x1-orig_x1;
               adjust_x=_lx2dx(SM_TWIP,adjust_x);adjust_x=_dx2lx(SM_TWIP,adjust_x);
               if (wid1.p_width+adjust_x<0) {
                  adjust_x=-wid1.p_width;
               }
               if (wid2.p_width-adjust_x<0) {
                  adjust_x=wid2.p_width;
               }
               wid1.p_width=wid1.p_width+adjust_x;
               wid2.p_x=wid2.p_x+adjust_x;
               wid2.p_width=wid2.p_width-adjust_x;
               selected_wid.p_x+=adjust_x;
            } else if (style==PSPIC_SIZEHORZ  && !tb) {
               wid1=gbbdockinfo[bbside][i].wid;
               wid2=gbbdockinfo[bbside][i+1].wid;
               adjust_y=y1-orig_y1;
               adjust_y=_ly2dy(SM_TWIP,adjust_y);adjust_y=_dy2ly(SM_TWIP,adjust_y);
               if (wid1.p_height+adjust_y<0) {
                  adjust_y=-wid1.p_height;
               }
               if (wid2.p_height-adjust_y<0) {
                  adjust_y=wid2.p_height;
               }
               wid1.p_height=wid1.p_height+adjust_y;

               wid2.p_y=wid2.p_y+adjust_y;
               wid2.p_height=wid2.p_height-adjust_y;
               selected_wid.p_y+=adjust_y;
            } else if (style==PSPIC_SIZEVERT && !tb) {
               adjust_x=x1-orig_x1;
               adjust_x=_dx2lx(SM_TWIP,adjust_x);
               // Find the beginning of this row
               row_start=i-1;
               sizebar_wid=0;
               for (;row_start>=0 && gbbdockinfo[bbside][row_start].wid!=BBDOCKINFO_ROWBREAK;--row_start) {
                  wid=gbbdockinfo[bbside][row_start].wid;
                  if (wid>0 &&
                      (gbbdockinfo[bbside][row_start].tbflags&TBFLAG_SIZEBARS)
                      ) {
                     sizebar_wid=wid;
                  }
               }
               ++row_start;
               RowHeight=_bbdockRowWidth(bbside,row_start);
               if (sizebar_wid) {
                  //adjust_x=_lx2dx(SM_TWIP,adjust_x);adjust_x=_dx2lx(SM_TWIP,adjust_x);
                  if (bbside==BBSIDE_RIGHT) {
                     adjust_x= -adjust_x;
                  }
                  if (RowHeight+adjust_x<0) {
                     adjust_x=-RowHeight;
                  }
                  // Make sure there is some client area left
                  if (adjust_x>0 && _lx2dx(SM_TWIP,adjust_x)>mdiclient_width) {
                     //message("got here "_lx2dx(SM_TWIP,adjust_x)" "mdiclient_height);
                     adjust_x=_dx2lx(SM_TWIP,mdiclient_width)
                  }
                  RowHeight+=adjust_x;
                  for (j=row_start;gbbdockinfo[bbside][j].wid!=BBDOCKINFO_ROWBREAK;++j) {
                     wid=gbbdockinfo[bbside][j].wid;
                     if (wid>0 &&
                         (gbbdockinfo[bbside][j].tbflags&TBFLAG_SIZEBARS)
                         ) {
                        wid.p_width=RowHeight;
                     }
                  }
                  _mdi._bbdockRefresh(bbside);
               }
            } else if (style==PSPIC_SIZEHORZ  && tb) {
               adjust_y=y1-orig_y1;
               adjust_y=_dy2ly(SM_TWIP,adjust_y);
               // Find the beginning of this row
               row_start=i-1;
               sizebar_wid=0;
               for (;row_start>=0 && gbbdockinfo[bbside][row_start].wid!=BBDOCKINFO_ROWBREAK;--row_start) {
                  wid=gbbdockinfo[bbside][row_start].wid;
                  if (wid>0 &&
                      (gbbdockinfo[bbside][row_start].tbflags &TBFLAG_SIZEBARS)
                      ) {
                     sizebar_wid=wid;
                  }
               }
               ++row_start;
               RowHeight=_bbdockRowHeight(bbside,row_start);
               if (sizebar_wid) {
                  //adjust_y=_ly2dy(SM_TWIP,adjust_y);adjust_y=_dy2ly(SM_TWIP,adjust_y);
                  if (bbside==BBSIDE_BOTTOM) {
                     adjust_y= -adjust_y;
                  }
                  if (RowHeight+adjust_y<0) {
                     adjust_y=-RowHeight;
                  }
                  // Make sure there is some client area left
                  if (adjust_y>0 && _ly2dy(SM_TWIP,adjust_y)>mdiclient_height) {
                     //message("got here "_ly2dy(SM_TWIP,adjust_y)" "mdiclient_height);
                     adjust_y=_dy2ly(SM_TWIP,mdiclient_height)
                  }
                  RowHeight+=adjust_y;
                  for (j=row_start;gbbdockinfo[bbside][j].wid!=BBDOCKINFO_ROWBREAK;++j) {
                     wid=gbbdockinfo[bbside][j].wid;
                     if (wid>0 &&
                         (gbbdockinfo[bbside][j].tbflags & TBFLAG_SIZEBARS)
                         ) {
                        wid.p_height=RowHeight;
                     }
                  }
                  _mdi._bbdockRefresh(bbside);
               }
            } else {
               return;
            }
            //selected_wid._move_window(x1,y1,x2-x1,y2-y1)
         }
      }
   }
   if (focus_wid) {
      focus_wid._set_focus();
   }
}
_command void toolbars(...)
{
   show("-mdi _toolbars_prop_form");
}
_command void tbResetAll(...)
{
   def_toolbartab._makeempty();
   def_toolbartab=init_toolbartab;
   gbbdockinfo._makeempty();
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_TOOLBAR_DOCKING)) {
      return;
   }
   for (i=1;i<=4;++i) {
      wid=_mdi._GetButtonBar(i);
      if (wid) {
         wid._delete_window();
      }
   }
   focus_wid=_get_focus();
   _mdi._bbdockInsert(BBSIDE_TOP,-1,false,false,
                             find_index("_tbstandard_form",oi2type(OI_FORM)),
                             TBFLAG_NEW_TOOLBAR,0);
   _mdi._bbdockRefresh(BBSIDE_TOP);
   _mdi._bbdockInsert(BBSIDE_LEFT,-1,false,false,
                             find_index("_tbproject_form",oi2type(OI_FORM)),
                             TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0);
   _mdi._bbdockRefresh(BBSIDE_LEFT);
   _mdi._bbdockInsert(BBSIDE_BOTTOM,-1,false,false,
                             find_index("_tboutput_form",oi2type(OI_FORM)),
                             TBFLAG_ALWAYS_ON_TOP|TBFLAG_ALLOW_DOCKING|TBFLAG_SIZEBARS,0);
   _mdi._bbdockRefresh(BBSIDE_BOTTOM);
   if (focus_wid) {
      focus_wid._set_focus();
   }

}
_command void tbControlProperties(...) name_info(FORM_ARG',')
{
   wid=arg(1);
   if (isinteger(wid) && _iswindow_valid(wid)) {
      show("-modal _ToolBarProperties_form",wid);
   }
}
_command void tbClose(...) name_info(FORM_ARG',')
{
   tbNewVersion();
   wid=arg(1);
   if (wid.p_isbutton_bar) {
      _bbdockFindWid(wid,bbside,i);
      _mdi._bbdockRespaceAndRemove(bbside,i);
      _mdi._bbdockMaybeRemoveButtonBar(bbside);
      _mdi._bbdockRefresh(bbside);
      return;
   }
   wid.p_active_form._delete_window();
}
static void tbShowFinishUp(int wid,boolean HasSizeBars,_TOOLBAR *ptb,int bbside,int docked_row)
{
   _mdi._bbdockFindWid(wid,bbside,i);
   if (HasSizeBars) {
      height=ptb->docked_height;width=ptb->docked_width;
      wid.p_height=height;wid.p_width=width;
      if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
         gbbdockinfo[bbside][i].twspace= width;
      } else {
         gbbdockinfo[bbside][i].twspace= height;
      }
   }
   gbbdockinfo[bbside][i].docked_row= docked_row;
   for (;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         break;
      }
      if (gbbdockinfo[bbside][i].wid==BBDOCKINFO_ROWBREAK) {
         //_message_box('restore docked_row='docked_row);
         gbbdockinfo[bbside][i].docked_row=docked_row;
         break;
      }
   }

   _bbdockAdjustLeadingSpace(bbside);
   _mdi._bbdockRefresh(bbside);
}
static void _tbShowDocked(_str FormName,int default_bbside= -1)
{
   tbNewVersion();
   _TOOLBAR *ptb;
   ptb=_tbFind(FormName);
   index=find_index(FormName,oi2type(OI_FORM));
   if (!ptb || !index) {
      _message_box('Form 'FormName' not found');
      return;
   }
   //_tbSetRefreshBy(VSTBREFRESHBY_USER);
   wid=_find_object(FormName,"n");
   if (wid) {
      if (wid.p_isbutton_bar) {
         // This is already docked
         return;
      }
      tbClose(wid);
   }
   HasSizeBars=ptb->tbflags & TBFLAG_SIZEBARS;
   bbside=ptb->docked_bbside;
   if (!bbside) {
      if (default_bbside<0) {
         if (HasSizeBars) {
            bbside=BBSIDE_BOTTOM;
         } else {
            bbside=BBSIDE_TOP;
         }
      } else {
         bbside=default_bbside;
      }
   }
   adjust_docked_x=0;
   adjust_docked_y=0;
   if (HasSizeBars) {
      if (!ptb->docked_bbside) {
         tb_width=TBDEFAULT_DOCK_WIDTH*_twips_per_pixel_x(); //index.p_width;
         tb_height=TBDEFAULT_DOCK_HEIGHT*_twips_per_pixel_y(); //index.p_height;
         ptb->docked_width=tb_width;
         ptb->docked_height=tb_height;
      } else {
         // Add one side of border
         ptb->docked_width-=_twips_per_pixel_x();
         ptb->docked_height-=_twips_per_pixel_y();
      }
      adjust_docked_x=-_twips_per_pixel_x();;
      adjust_docked_y=-_twips_per_pixel_y();;
   } else {
      if (!ptb->docked_bbside) {
         tb_width=TBDEFAULT_DOCK_WIDTH*_twips_per_pixel_x(); //index.p_width;
         tb_height=TBDEFAULT_DOCK_HEIGHT*_twips_per_pixel_y(); //index.p_height;
      } else {
         // Remove one side of border
         tb_width=ptb->docked_width-_twips_per_pixel_x();
         tb_height=ptb->docked_height-_twips_per_pixel_y();
      }
      ptb->docked_width=tb_width;
      ptb->docked_height=tb_height;
   }
   if (!ptb->docked_bbside) {
      ptb->docked_bbside=bbside;
      ptb->docked_row=_tbQMaxRestoreRow(bbside)+1;
      ptb->docked_x=0;
      ptb->docked_y=0;
      ptb->docked_width=tb_width;
      ptb->docked_height=tb_height;
   }
   bbside=ptb->docked_bbside;
   // IF there is nothing docked on this side
   if (!_mdi._GetButtonBar(bbside)) {
      docked_row=ptb->docked_row;
      ptb->docked_bbside=0;
      gIgnoreInsertRestoreRow=true;
      wid=_mdi._bbdockInsert(bbside,-1,false,false,
                                index,
                                ptb->tbflags,0);
      gIgnoreInsertRestoreRow=false;
      _bbdockFindWid(wid,bbside,i);
      if (!HasSizeBars) {
         if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
            gbbdockinfo[bbside][i].twspace=ptb->docked_x;
         } else {
            gbbdockinfo[bbside][i].twspace=ptb->docked_y;
         }
      }
      tbShowFinishUp(wid,HasSizeBars,ptb,bbside,docked_row);
      return;
   }
   // Find the row
   max_restore_row=0;
   for (i=gbbdockinfo[bbside]._length()-1;i>=0;--i) {
      if (gbbdockinfo[bbside][i].wid==BBDOCKINFO_ROWBREAK) {
         if (gbbdockinfo[bbside][i].docked_row) {
            max_restore_row=gbbdockinfo[bbside][i].docked_row;
            break;
         }
      }
   }
   if (ptb->docked_row>max_restore_row) {
      docked_row=ptb->docked_row;
      gIgnoreInsertRestoreRow=true;
      wid=_mdi._bbdockInsert(bbside,-1,true,false,
                                index,
                                ptb->tbflags,0);
      gIgnoreInsertRestoreRow=false;
      _bbdockFindWid(wid,bbside,i);
      if (!HasSizeBars) {
         if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
            gbbdockinfo[bbside][i].twspace=ptb->docked_x;
         } else {
            gbbdockinfo[bbside][i].twspace=ptb->docked_y;
         }
      }
      tbShowFinishUp(wid,HasSizeBars,ptb,bbside,docked_row);
      return;
   }

   // This row already exists. Determine where
   // to insert this toolbar

   orig_bbside= 0;orig_i= -1;


   wid=_mdi._GetButtonBar(bbside);
   if (wid) {
      wid._get_window(x,y,width,height);
      _lxy2dxy(wid.p_xyscale_mode,x,y);
      _lxy2dxy(wid.p_xyscale_mode,width,height);
      _map_xy(_mdi,0,x,y,SM_PIXEL);
      bbsiderect_x1=x;bbsiderect_y1=y;
      bbsiderect_x2=bbsiderect_x1+width;
      bbsiderect_y2=bbsiderect_y1+height;
   }
   new_x1=0;new_y1=0;new_x2=0;new_y2=0;

   RowBreakAfter=false;RowBreakBefore=false;
   new_i= -2;  // Nothing to do
   if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
      new_x1=_lx2dx(SM_TWIP,ptb->docked_x);
      junk_y=0;_map_xy(wid,0,new_x1,junk_y);
      new_x2=_lx2dx(SM_TWIP,ptb->docked_x+ptb->docked_width);
      _map_xy(wid,0,new_x2,junk_y);
      _mdi._bbdockPositionTB(bbside,bbsiderect_x2,bbsiderect_y1,
          orig_bbside,orig_i,HasSizeBars,
          new_i,new_twspace,new_twspace2,
          new_x1+adjust_docked_x,new_y1,new_x2+adjust_docked_x,new_y2,ptb->docked_row,PutInRowBreakAfter);
   } else {
      new_y1=wid._ly2dy(SM_TWIP,ptb->docked_y);
      junk_x=0;_map_xy(wid,0,junk_x,new_y1);
      new_y2=wid._ly2dy(SM_TWIP,ptb->docked_y+ptb->docked_height);
      _map_xy(wid,0,junk_x,new_y2);
      _mdi._bbdockPositionLR(bbside,bbsiderect_y2,bbsiderect_x1,
          orig_bbside,orig_i,HasSizeBars,
          new_i,new_twspace,new_twspace2,
          new_x1,new_y1+adjust_docked_y,new_x2,new_y2+adjust_docked_y,ptb->docked_row,PutInRowBreakAfter);
   }
   //_message_box('new_i='new_i' new_twspace='new_twspace' 2='new_twspace2);
   if (new_i<-1) {
      _message_box('toolbar internal error');
      return;
   }
   if (new_twspace2>=0) {
      gbbdockinfo[bbside][new_i].twspace=new_twspace2;
   }
   if (PutInRowBreakAfter) {
      //_message_box('PutInRowBreakAfter new_i='new_i' RowBreakBefore='RowBreakBefore);
      if (!HasSizeBars) {
         if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
            new_twspace=ptb->docked_x;
         } else {
            new_twspace=ptb->docked_y;
         }
      }
   }
   docked_row=ptb->docked_row;
   gIgnoreInsertRestoreRow=true;
   wid=_mdi._bbdockInsert(bbside,new_i,
                RowBreakBefore, //doRowBreakBefore
                PutInRowBreakAfter,  //doRowBreakAfter
                index,
                ptb->tbflags,  // tbflags,
                new_twspace   // twspaceBefore
                );
   gIgnoreInsertRestoreRow=false;
   tbShowFinishUp(wid,HasSizeBars,ptb,bbside,docked_row);
}
_command void tbShow(_str FormName="") name_info(FORM_ARG',')
{
   tbNewVersion();
   _TOOLBAR *ptb;
   ptb=_tbFind(FormName);
   index=find_index(FormName,oi2type(OI_FORM));
   if (!ptb || !index) {
      _message_box('Form 'FormName' not found');
      return;
   }
   wid=_find_object(FormName,"n");
   //say('ptb->restore_docked='ptb->restore_docked);
   if (wid || !ptb->docked_bbside || !ptb->restore_docked) {
      if (ptb->show_width) {
         //say('case1 show 'ptb->show_x' 'ptb->show_y' 'ptb->show_width' 'ptb->show_height);
         _tbShow(FormName,ptb->show_x,ptb->show_y,ptb->show_width,ptb->show_height);
      } else {
         //say('case2 show 'ptb->show_x' 'ptb->show_y' 'ptb->show_width' 'ptb->show_height);
         _tbShow(FormName,0,0,0,0);
      }
      return;
   }
   _tbShowDocked(FormName);
}
void _tbVisible(boolean Show)
{
   wid=_get_focus();
   for (i=1;i<=_last_window_id();++i) {
      if (_iswindow_valid(i) && i.p_object==OI_FORM &&
          !i.p_isbutton_bar &&
          i.p_name!="" && _tbFind(i.p_name)) {
         i.p_visible=Show;
      }
   }
   if (wid) {
      wid._set_focus();
   }
}
int _tbShow(_str FormName,int x,int y,int width,int height)
{
   // _isloaded does not work for tool bar attatched to mdi side
   wid=_tbIsVisible(FormName);
   if(wid) {
      return(wid);
   }
   //_tbSetRefreshBy(VSTBREFRESHBY_USER);
   _TOOLBAR *ptb;
   ptb=_tbFind(FormName);
   tbflags=TBFLAG_NEW_TOOLBAR;
   if (ptb) {
      tbflags=ptb->tbflags;
   }
   if (tbflags & TBFLAG_ALWAYS_ON_TOP) {
      owner=" -mdi ";
   } else {
      owner=" -app ";
   }
   index=find_index(FormName,oi2type(OI_FORM));
   if (width>0 && height>0) {
      //wid=_mdi.show("-new -hidden "owner:+FormName);
      wid=_mdi.show("-xy -hidden "owner:+FormName);
      if (wid) {
         //messageNwait("_tbShow: rect="x" "y" "width" "height);
         wid._move_window(x,y,width,height);
#if __UNIX__
         if (tbflags & TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED) {
            wid.p_ToolbarBorder=VSTBBORDER_GRABBARS;
         }
#endif
         wid.p_visible=true;
      }
   } else {
      wid=_mdi.show("-hidden -xy "owner:+FormName);
#if __UNIX__
      if (tbflags & TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED) {
         wid.p_ToolbarBorder=VSTBBORDER_GRABBARS;
      }
#endif
      wid.p_visible=true;
   }
   return(wid);
}
_TOOLBAR *_tbFind2(_str name,int &i)
{
   for (i=0;i<def_toolbartab._length();++i) {
      if (name==def_toolbartab[i].FormName) {
         return(&def_toolbartab[i]);
      }
   }
   return(0);
}
_TOOLBAR *_tbFind(_str name)
{
   return(_tbFind2(name,i));
}
_TOOLBAR *_tbFindCaption(_str name,int &index)
{
   for (i=0;i<def_toolbartab._length();++i) {
      index=find_index(def_toolbartab[i].FormName,oi2type(OI_FORM));
      if (index && !stricmp(index.p_caption,name)) {
         return(&def_toolbartab[i]);
      }
   }
   return(0);
}
#define BBFIRST_XINDENT 60
#define BBFIRST_YINDENT 40
void _tbResizeButtonBar2(int client_width,boolean SetWindow,int &new_width,int &new_height,int bbside)
{
   tb=(bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM);
   lr=false;
   NofControlsInRow=0;  // Throw away leading spaces
   if (bbside==BBSIDE_LEFT || bbside==BBSIDE_RIGHT) {
      lr=true;
   }
   FirstRow=true;
   SkipLeadingFirstRowSpaces=(bbside==0);
   new_width=p_width;
   new_height=p_height;
   client_width=_dx2lx(p_scale_mode,client_width);


   first_child=child=p_child;
   if (!child) return;
   y=BBFIRST_YINDENT;
   x=BBFIRST_XINDENT;
   _lxy2lxy(p_scale_mode,p_scale_mode,x,y);
   // Round to pixel
   //message(dcount" _tbResizeButtonBar: client_width="client_width);
   first_x=x;
   first_y=y;
   if (bbside || __UNIX__) {
      if (bbside==BBSIDE_LEFT || bbside==BBSIDE_RIGHT) {
         y=12*_twips_per_pixel_y();
      } else {
         x=12*_twips_per_pixel_x();
      }
   }
   max_x=0;
   line_height=0;
   trailing_space=0;
   TwoControlsInAnyRow=false;
   //RowAllImageControls=true;
   //PreviousRowAllImageControls=false;
loop1:
   for (;;) {
      if (NofControlsInRow>=2 && !FirstRow) {
         TwoControlsInAnyRow=true;
      }
      leading_space=0;
      NofSpaceControls=0;
      while (child.p_object==OI_IMAGE && !child.p_picture) {
         if ((TwoControlsInAnyRow ||(SkipLeadingFirstRowSpaces && !NofControlsInRow))
              && !tb && !lr) {
            if (SetWindow) {
               child._move_window(child.p_x,child.p_y,0,0);
               if (!child.p_visible) child.p_visible=1;
            }
         } else {
            ++NofSpaceControls;
            SPECIALCONTROL *psc;
            psc=gtwSpecialControlTab._indexin(child.p_message);
            if (!psc) {
               child_width=BB_XSPACE;
            } else {
               child_width=psc->width;
            }
            leading_space+=child_width;
            if (SetWindow) {
               if (bbside==BBSIDE_LEFT || bbside==BBSIDE_RIGHT) {
                  child.p_style=PSPIC_TOOLBAR_DIVIDER_HORZ;
               } else {
                  child.p_style=PSPIC_TOOLBAR_DIVIDER_VERT;
               }
            }
         }
         child=child.p_next;
         if (child==first_child) break loop1;
      }
      child._get_window(child_x,child_y,child_width,child_height);
      _lxy2lxy(p_xyscale_mode,p_scale_mode,child_width,child_height);
      /*if (child.p_object==OI_IMAGE ) {
         if (child.p_caption!="") {
            if (child.p_style!=PSPIC_FLAT_BUTTON) {
               child.p_style=PSPIC_FLAT_BUTTON;
            }
         } else if( child.p_picture) {
            pb=file_eq(substr(name_name(child.p_picture),1,2),"pb");
            if (!pb && child.p_style==PSPIC_AUTO_BUTTON) {
               child.p_style=PSPIC_FLAT_BUTTON;
            } else if (pb && child.p_style==PSPIC_FLAT_BUTTON) {
               child.p_style=PSPIC_AUTO_BUTTON;
            }
         }
      } */

#if 0
      if (child.p_next!=first_child &&
          child.p_object==OI_IMAGE && child.p_picture &&
           child.p_next.p_object==OI_IMAGE &&
          child.p_next.p_picture) {
         xprintf("did subtract");
         child_width-=_dx2lx(p_scale_mode,1);
      }
#endif
      if ((leading_space && (!NofControlsInRow || lr) && !tb)||
          (x!=first_x &&
          x+leading_space+child_width+first_x>client_width)) {
         //say("x="x" ls="leading_space" cw="child_width" fx="first_x);
         if (x==first_x && leading_space) {
            count=NofSpaceControls;
            wid=child;
            while (count--) {
               wid=wid.p_prev;
            }
            child_y=y;
            while (NofSpaceControls--) {
               SPECIALCONTROL *psc;
               psc=gtwSpecialControlTab._indexin(wid.p_message);
               if (!psc) {
                  child_height=BB_XSPACE;
               } else {
                  child_height=psc->width;
               }
               if (SetWindow) {
                  wid._move_window(x,y,max_x,child_height);
                  if (!child.p_visible) child.p_visible=1;
               }
               wid=wid.p_next;
               y+=child_height;
            }
         } else {
            while (NofSpaceControls--) {
               child=child.p_prev;
            }
         }
         FirstRow=false;
         SkipLeadingFirstRowSpaces=false;
         x=first_x;
         //messageNwait("_tbResizeButtonBar2: line_height="line_height);
         y+=line_height/*-_dx2lx(p_scale_mode,1)*/;
         line_height=0;
         NofControlsInRow=0;
         //PreviousRowAllImageControls=RowAllImageControls;
         //RowAllImageControls=true;
         continue;
      }

      /*if (child.p_object!=OI_IMAGE) {
         RowAllImageControls=false;
      } */
      child_x=x;
      //adjust_y=(PreviousRowAllImageControls && child.p_object==OI_IMAGE)?_dx2lx(p_scale_mode,1):0;
      //messageNwait("_tbResizeButtonBar2: adjust_y="adjust_y);
      adjust_y=0;
      child_y=y-adjust_y;

      if (child.p_object==OI_IMAGE && child.p_caption!="") {
         if (child_height<line_height) {
            child_y+=(line_height-child_height) intdiv 2;
         }
      }
      if (child_height-adjust_y>line_height) {
         line_height=child_height-adjust_y;
      }
      if (child.p_object!=OI_IMAGE || child.p_picture) {
         ++NofControlsInRow;
      }
      x+=leading_space+child_width;
      if (x>max_x) max_x=x;
      if (SetWindow) {
         child._move_window(child_x+leading_space,child_y,child_width,child_height);
         if (!child.p_visible) child.p_visible=1;
      }
      if (NofSpaceControls) {
         count=NofSpaceControls;
         wid=child;
         while (count--) {
            wid=wid.p_prev;
         }
         while (NofSpaceControls--) {
            SPECIALCONTROL *psc;
            psc=gtwSpecialControlTab._indexin(wid.p_message);
            if (!psc) {
               child_width=BB_XSPACE;
            } else {
               child_width=psc->width;
            }
            if (SetWindow) {
               wid._move_window(child_x,child_y,child_width,line_height);
               if (!child.p_visible) child.p_visible=1;
            }
            wid=wid.p_next;
            child_x+=child_width;
         }

      }
      child=child.p_next;
      if (child==first_child) break;
   }
   if (SetWindow) {
      lewidth=_left_width()*2;
      if (machine()=='OS2386') {
         if (!bbside) {
            lewidth=GetSystemMetrics(VSM_CXFRAME)*2;
         } else {
            lewidth=1;
         }
         lewidth=_dx2lx(p_xyscale_mode ,lewidth);
      }
      DecorationHeight=_top_height()+_bottom_height();
#if __UNIX__
      lewidth=0;
      DecorationHeight=0;
#endif
      new_width=max_x+first_x+lewidth;
      new_height=y+line_height+first_y+DecorationHeight;
      if (new_width!=p_width || new_height!=p_height) {
         p_user="";  // Don't recurse on_resize event
         _move_window(p_x,p_y,new_width,new_height);
         p_user=1;
      }
   } else {
      new_width=max_x+first_x;
      new_height=y+line_height+first_y;
   }
   //message("y="y"line_height="line_height" th="_top_height());
}
void _tbResizeButtonBar(int bbside)
{
   if (!bbside) {
      _tbResizeButtonBar2(p_client_width,true,junk1,junk2,bbside);
      return;
   }
   if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
      _tbResizeButtonBar2(_screen_width()*10,true,junk1,junk2,bbside);
      return;
   }
   _tbResizeButtonBar2(0,true,junk1,junk2,bbside);
}
/*
    Define lbutton_down and default on_resize event
*/
defeventtab _toolbar_etab2
void _toolbar_etab2.on_create()
{
   _tbSetToolbarEnable(p_window_id);
   child=p_child;
   if (child) {
      for (first_child=child;;) {
         if (child.p_object==OI_IMAGE) {
            if (child.p_caption!="") {
               if (child.p_style!=PSPIC_FLAT_BUTTON) {
                  child.p_style=PSPIC_FLAT_BUTTON;
               }
            } else if( child.p_picture) {
               pb=file_eq(substr(name_name(child.p_picture),1,2),"pb");
               if (!pb && (child.p_style==PSPIC_AUTO_BUTTON || child.p_style==PSPIC_BUTTON)) {
                  child.p_style=PSPIC_FLAT_BUTTON;
               } else if (pb && child.p_style==PSPIC_FLAT_BUTTON) {
                  child.p_style=PSPIC_BUTTON;
               }
            }
         }
         child=child.p_next;
         if (child==first_child) {
            break;
         }
      }
   }
}
void _toolbar_etab2.on_destroy()
{
   _TOOLBAR *ptb;
   ptb=_tbFind(p_name);
   if (ptb) {
      if (!p_isbutton_bar) {
         ptb->restore_docked=false;
         ptb->show_x=p_x;
         ptb->show_y=p_y;
         ptb->show_width=p_width;
         ptb->show_height=p_height;
      } else {
         ptb->restore_docked=true;

         _mdi._bbdockFindWid(p_window_id,bbside,sidei);

         ptb->docked_bbside=p_isbutton_bar;

         bbside=p_isbutton_bar;
         count=gbbdockinfo[bbside]._length();
         row=1;
         for (i=0;i<count;++i) {
            wid=gbbdockinfo[bbside][i].wid;
            if (p_window_id==wid ) {
               break;
            }
            if (wid==BBDOCKINFO_ROWBREAK) {
               ++row;
            }
         }
         if (i>=count) {
            ptb->docked_bbside=0;
         }
         ptb->docked_row=_bbdockQRestoreRow(bbside,sidei);
         ptb->docked_x=p_x;
         ptb->docked_y=p_y;
         ptb->docked_width=p_width;
         ptb->docked_height=p_height;
      }
      //say('show 'ptb->show_x' 'ptb->show_y' 'ptb->show_width' 'ptb->show_height);
   }
   if (p_isbutton_bar) {
      return;
   }
   list=_find_object("_toolbars_prop_form.list1",'n');
   if (list) {
      list.call_event(CHANGE_SELECTED,1,list,ON_CHANGE,'');
   }
}
void _toolbar_etab2.on_load()
{
   p_old_width=0;p_old_height=0;
   call_event(p_window_id,on_resize);
   _TOOLBAR *ptb;
   ptb=_tbFind(p_name);
   //if (!ptb ) return;

   p_user=1;
   if (ptb && !(ptb->tbflags & TBFLAG_SIZEBARS)) {
      _tbResizeButtonBar(p_isbutton_bar);
   }


   list=_find_object("_toolbars_prop_form.list1",'n');
   if (list) {
      list.call_event(CHANGE_SELECTED,list,ON_CHANGE,'');
   }
}
void _toolbar_etab2.on_resize()
{
   // If on_load not processed
   if (p_user=="" || p_isbutton_bar || p_object!=OI_FORM) return;
   if (p_width==p_old_width && p_height==p_old_height) {
      return;
   }
   p_old_width=p_width;p_old_height=p_height;
   _TOOLBAR *ptb;
   ptb=_tbFind(p_name);
   //if (!ptb ) return;

   if (ptb && (ptb->tbflags & TBFLAG_SIZEBARS)) return;
   //say("resize "p_name" isbb="p_isbutton_bar);
   p_active_form._tbResizeButtonBar(p_isbutton_bar);
   p_old_width=p_width;p_old_height=p_height;
}
static boolean RectsInterect(int ax1,int ay1,int ax2,int ay2,
                         int bx1,int by1,int bx2,int by2)
{
   return(bx1<ax2 && bx2>ax1 && by1<ay2 && by2>ay1);
}
static int gDragMousePointerTab[]={
   MP_LEFTARROW,
   MP_LEFTARROW_DROP_LEFT,
   MP_LEFTARROW_DROP_TOP,
   MP_LEFTARROW_DROP_RIGHT,
   MP_LEFTARROW_DROP_BOTTOM,
};
struct RECT {
   int wid;
   int x1,y1;
   int x2,y2;
};
void _toolbar_etab2."c-lbutton_down"()
{
   call_event(0,p_window_id,LBUTTON_DOWN,"");
}
#define CXDRAG_MIN  (40 intdiv _twips_per_pixel_x())
#define CYDRAG_MIN  (40 intdiv _twips_per_pixel_y())
void _toolbar_etab2.lbutton_down()
{
   if (p_object==OI_FORM || _ImageIsSpace()) {
      tbNewVersion();
      _mdi._MDIClientGetWindow(mdiclient_x,mdiclient_y,mdiclient_width,mdiclient_height);
      p_window_id=p_active_form;
      CheckMinDrag=!p_isbutton_bar;
      CheckMinDrag=1; //!p_isbutton_bar;
      // Rectangles for all tool bars for a particular side
      // If the tool bar is not present, then a side is till computed.
      RECT bbsiderect[/* 1..4*/];
      // Width when tool bar dropped
      int bbsidewidth[/*0..4*/];
      // Height when tool bar dropped
      int bbsideheight[/*0..4*/];
      for (i=1;i<=4;++i) {
         bbsiderect[i].wid=wid=_mdi._GetButtonBar(i);
         if (wid) {
            wid._get_window(x,y,width,height);
            _lxy2dxy(wid.p_xyscale_mode,x,y);
            _lxy2dxy(wid.p_xyscale_mode,width,height);
            _map_xy(_mdi,0,x,y,SM_PIXEL);
            bbsiderect[i].x1=x;bbsiderect[i].y1=y;
            bbsiderect[i].x2=bbsiderect[i].x1+width;
            bbsiderect[i].y2=bbsiderect[i].y1+height;
         } else {
            switch(i) {
            case BBSIDE_TOP:
               x=mdiclient_x;
               junk=0;_map_xy(_mdi,0,x,junk,SM_PIXEL);
               width=mdiclient_width;
               y=_mdi.p_y;
               height=_mdi._top_height();
               break;
            case BBSIDE_BOTTOM:
               x=mdiclient_x;
               width=mdiclient_width;
               y=mdiclient_y+mdiclient_height;
               _map_xy(_mdi,0,x,y,SM_PIXEL);
               height=(_mdi.p_y+_mdi.p_height)-y;
               break;
            case BBSIDE_LEFT:
               x=_mdi.p_x;
               width=_mdi._left_width();
               y=mdiclient_y;
               junk=0;_map_xy(_mdi,0,junk,y,SM_PIXEL);
               height=mdiclient_height;
               break;
            case BBSIDE_RIGHT:
               x=mdiclient_x+mdiclient_width;
               width=_mdi._left_width();
               y=mdiclient_y;
               _map_xy(_mdi,0,x,y,SM_PIXEL);
               height=mdiclient_height;
               break;
            }
            if (width<0) width=0;
            if (height<0) height=0;
            bbsiderect[i].x1=x;bbsiderect[i].y1=y;
            bbsiderect[i].x2=bbsiderect[i].x1+width;
            bbsiderect[i].y2=bbsiderect[i].y1+height;
         }
      }
#if 1
      orig_bbside=p_isbutton_bar;
      if (!orig_bbside) {
         OrigHasEntireRow=false;
         //OrigEntireFirstRow=false;
         //OrigEntireLastRow=false;
         _TOOLBAR *ptb;
         ptb=_tbFind(p_name);
         orig_tbflags=TBFLAG_NEW_TOOLBAR;
         if (ptb) {
            orig_tbflags=ptb->tbflags;
         }
      } else {
         _bbdockFindWid(p_window_id,orig_bbside,orig_i);
         orig_tbflags=gbbdockinfo[orig_bbside][orig_i].tbflags;
         OrigHasEntireRow=(orig_i==0 || gbbdockinfo[orig_bbside][orig_i-1].wid==BBDOCKINFO_ROWBREAK) &&
             orig_i+1<gbbdockinfo[orig_bbside]._length() &&
            gbbdockinfo[orig_bbside][orig_i+1].wid==BBDOCKINFO_ROWBREAK
         /*OrigEntireFirstRow=(orig_i==0) && orig_i+1<gbbdockinfo[orig_bbside]._length() &&
            gbbdockinfo[orig_bbside][orig_i+1]==BBDOCKINFO_ROWBREAK;*/
         last_i=gbbdockinfo[orig_bbside]._length()-1;
         /*OrigEntireLast= (last_i-2>=0 && gbbdockinfo[orig_bbside][last_i]==BBDOCKINFO_ROWBREAK &&
             last_i-1==orig_i && gbbdockinfo[orig_bbside][last_i-2]==BBDOCKINFO_ROWBREAK
             ); */
      }
      AllowDocking=(arg(1)=="") && (orig_tbflags &TBFLAG_ALLOW_DOCKING);
      if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_TOOLBAR_DOCKING)) {
         AllowDocking=0;
      }

#if __UNIX__
      // Decoration padding for UNIX:
      // Other platforms should be 0.
      int padX, padY;
      padX = 0;
      padY = 0;
#endif

      //message("_toolbar_etab2.lbutton_down: AllowDocking="AllowDocking);
      //AllowDocking=false;
      HasSizeBars=orig_tbflags & TBFLAG_SIZEBARS;
      if (HasSizeBars) {
         if (!orig_bbside) {
#if __UNIX__
            // Not sure if this is correct for UNIX
            padX = GetSystemMetrics(VSM_CXFRAME)*2;
            padY = GetSystemMetrics(VSM_CYSMCAPTION)+GetSystemMetrics(VSM_CYFRAME)*2;
            //say( "obj="p_object" padX="padX" padY="padY" x="p_x" y="p_y );
            bbsidewidth[0]=_lx2dx(p_xyscale_mode,p_width) + padX;
            bbsideheight[0]=_ly2dy(p_xyscale_mode,p_height) + padY;
#else
            // This works for Windows and OS/2
            bbsidewidth[0]=_lx2dx(p_xyscale_mode,p_width);
            bbsideheight[0]=_ly2dy(p_xyscale_mode,p_height);
#endif
            // Reused current width when docking on top and
            // on bottom
            bbsidewidth[BBSIDE_TOP]=bbsidewidth[BBSIDE_BOTTOM]=p_client_width;

            // Reused current height when docking on left and
            // on right
            bbsideheight[BBSIDE_LEFT]=bbsideheight[BBSIDE_RIGHT]=p_client_height;


            bbsidewidth[BBSIDE_LEFT]=bbsidewidth[BBSIDE_RIGHT]=TBDEFAULT_DOCK_WIDTH;
            bbsideheight[BBSIDE_TOP]=bbsideheight[BBSIDE_BOTTOM]=TBDEFAULT_DOCK_HEIGHT;
         } else if (orig_bbside==BBSIDE_TOP || orig_bbside==BBSIDE_BOTTOM) {
            bbsidewidth[0]=TBDEFAULT_UNDOCK_WIDTH+GetSystemMetrics(VSM_CXFRAME)*2;
            bbsideheight[0]=TBDEFAULT_UNDOCK_HEIGHT+GetSystemMetrics(VSM_CYSMCAPTION)+GetSystemMetrics(VSM_CYFRAME)*2;
            //message("_toolbar_etab2.lbutton_down: bbsideheight[0]="bbsideheight[0]);
            // Reused width and height opposite side.
            bbsidewidth[BBSIDE_TOP]=bbsidewidth[BBSIDE_BOTTOM]=TBDEFAULT_DOCK_WIDTH;

            // Reused current height when docking on left and
            // on right
            bbsideheight[BBSIDE_TOP]=bbsideheight[BBSIDE_BOTTOM]=p_client_height;


            bbsidewidth[BBSIDE_LEFT]=bbsidewidth[BBSIDE_RIGHT]=TBDEFAULT_DOCK_WIDTH;
            bbsideheight[BBSIDE_LEFT]=bbsideheight[BBSIDE_RIGHT]=TBDEFAULT_DOCK_HEIGHT;
         } else {
            bbsidewidth[0]=TBDEFAULT_UNDOCK_WIDTH;
            bbsideheight[0]=TBDEFAULT_UNDOCK_HEIGHT;
            // Reused width and height opposite side.
            bbsidewidth[BBSIDE_LEFT]=bbsidewidth[BBSIDE_RIGHT]=p_client_width;

            // Reused current height when docking on left and
            // on right
            bbsideheight[BBSIDE_LEFT]=bbsideheight[BBSIDE_RIGHT]=TBDEFAULT_DOCK_HEIGHT;


            bbsidewidth[BBSIDE_TOP]=bbsidewidth[BBSIDE_BOTTOM]=TBDEFAULT_DOCK_WIDTH;
            bbsideheight[BBSIDE_TOP]=bbsideheight[BBSIDE_BOTTOM]=TBDEFAULT_DOCK_HEIGHT;
         }
      } else {
         _tbResizeButtonBar2(_screen_width()*10,false,tb_width,tb_height,0);
         _lxy2dxy(p_xyscale_mode,tb_width,tb_height);
         if (!orig_bbside) {
            //width=_lx2dx(p_xyscale_mode,p_width)+GetSystemMetrics(VSM_CXFRAME)*2;
            //height=_ly2dy(p_xyscale_mode,p_height)+GetSystemMetrics(VSM_CYSMCAPTION)+GetSystemMetrics(VSM_CYFRAME)*2;
#if __UNIX__
            // Not sure if this is correct for UNIX
            padX = GetSystemMetrics(VSM_CXFRAME)*2;
            padY = GetSystemMetrics(VSM_CYSMCAPTION)+GetSystemMetrics(VSM_CYFRAME)*2;
            //say( "obj="p_object" padX="padX" padY="padY" x="p_x" y="p_y );
            bbsidewidth[0]=_lx2dx(p_xyscale_mode,p_width) + padX;
            bbsideheight[0]=_ly2dy(p_xyscale_mode,p_height) + padY;
#else
            // This works for Windows and OS/2
            bbsidewidth[0]=_lx2dx(p_xyscale_mode,p_width);
            bbsideheight[0]=_ly2dy(p_xyscale_mode,p_height);
#endif
         } else {
            width=tb_width+GetSystemMetrics(VSM_CXFRAME)*2;
            height=tb_height+GetSystemMetrics(VSM_CYSMCAPTION)+GetSystemMetrics(VSM_CYFRAME)*2;
            bbsidewidth[0]=width;
            bbsideheight[0]=height;
         }
         _tbResizeButtonBar2(_screen_width()*10,false,tb_width,tb_height,BBSIDE_TOP);
         _lxy2dxy(p_xyscale_mode,tb_width,tb_height);
         // Add one side of border
         tb_width+=1;tb_height+=1;
         bbsidewidth[BBSIDE_TOP]=bbsidewidth[BBSIDE_BOTTOM]=tb_width;
         bbsideheight[BBSIDE_TOP]=bbsideheight[BBSIDE_BOTTOM]=tb_height;
         //say("tb_height="tb_height" selected_wid="p_window_id" h="_ly2dy(p_xyscale_mode,p_height));

         _tbResizeButtonBar2(0,false,width,height,BBSIDE_LEFT);
         _lxy2dxy(p_xyscale_mode,width,height);
         // Add one side of border
         width+=1;height+=1;
         bbsidewidth[BBSIDE_LEFT]=bbsidewidth[BBSIDE_RIGHT]=width;
         bbsideheight[BBSIDE_LEFT]=bbsideheight[BBSIDE_RIGHT]=height;

      }
      selected_wid=orig_wid=p_window_id
      p_window_id=_desktop;

      DragOption="D";
      p_fill_style=PSFS_TRANSPARENT;
      p_draw_width=0;
      p_draw_style=PSDS_INSIDE_SOLID;p_draw_mode=PSDM_XORPEN;
      /*if (machine()=='OS2386') {
         color=_rgb(0xcc,0xcc,0xcc);
      } else {
         color=_rgb(0x80,0x80,0x80)  /* Gray */
      } */
      color=_rgb(0xff,0xff,0xff);

      mou_mode(1);
      selected_wid.mou_capture(1);  // UNIX only: 1=capture X server
      _KillToolTipMessages();
      newbbside=orig_bbside;

      old_mouse_pointer=selected_wid.p_mouse_pointer;

      mp=gDragMousePointerTab[newbbside];
      mou_set_pointer(mp);selected_wid.p_mouse_pointer=mp;
      orig_mouse_x=mou_last_x();
      orig_mouse_y=mou_last_y();

#if __UNIX__
      // Need to use GetSystemMetrics() here because _left_width() returns different values at different times.
      //mx=selected_wid.mou_last_x()+GetSystemMetrics(VSM_CXFRAME);
      //my=selected_wid.mou_last_y()+GetSystemMetrics(VSM_CYSMCAPTION)+GetSystemMetrics(VSM_CYFRAME);
      mx=selected_wid.mou_last_x()+_lx2dx(selected_wid.p_xyscale_mode,selected_wid._left_width());
      my=selected_wid.mou_last_y()+_ly2dy(selected_wid.p_xyscale_mode,selected_wid._top_height());
#else
      mx=selected_wid.mou_last_x()+_lx2dx(selected_wid.p_xyscale_mode,selected_wid._left_width());
      my=selected_wid.mou_last_y()+_ly2dy(selected_wid.p_xyscale_mode,selected_wid._top_height());
#endif
      rectangle_drawn=0;draw_width=0;
      //morig_x=mou_last_x('M');morig_y=mou_last_y('M');rectangle_drawn=0;
      done=0;
      selected_wid._get_window(orig_x,orig_y,orig_width,orig_height);
      _lxy2dxy(selected_wid.p_xyscale_mode,orig_x,orig_y);
      _lxy2dxy(selected_wid.p_xyscale_mode,orig_width,orig_height);
      _map_xy(selected_wid,0,orig_x,orig_y,SM_PIXEL);
      x1=orig_x;y1=orig_y;x2=x1+orig_width;y2=y1+orig_height;
      orig_x1=x1;orig_y1=y1;orig_x2=x2;orig_y2=y2;
      event=MOUSE_MOVE;

      for (;;) {
         switch (event) {
         case MOUSE_MOVE:
            prev_bbside=newbbside;
            newbbside=0;
            x=mou_last_x();y=mou_last_y();
            if (CheckMinDrag) {
               if (abs(orig_mouse_x-x)>CXDRAG_MIN) {
                  CheckMinDrag=false;
               }
               if (abs(orig_mouse_y-y)>CYDRAG_MIN) {
                  CheckMinDrag=false;
               }
            }
            if (CheckMinDrag) {
               break;
            }
            if (AllowDocking) {
               // Check if the mouse is touching one of the sides
               for (i=1;i<=4;++i) {
                  if(x>=bbsiderect[i].x1 && x<bbsiderect[i].x2 &&
                     y>=bbsiderect[i].y1 && y<bbsiderect[i].y2) {
                     newbbside=i;
                     //message("mouse in side="newbbside);
                     break;
                  }
               }
               if (!newbbside) {
                  width=x2-x1;height=y2-y1;
                  // Check if current and new rectangles touches side
                  if (prev_bbside) {
                     i=prev_bbside;
                  } else {
                     i=1;
                  }
                  for (;;) {
                     if (i==BBSIDE_TOP || i==BBSIDE_BOTTOM) {
                        new_y1=y-my;new_y2=new_y1+height;
                        if(
                            (x>=bbsiderect[i].x1 && x<bbsiderect[i].x2) &&
                            new_y1<bbsiderect[i].y2 && new_y2>bbsiderect[i].y1
                           ) {
                           newbbside=i;
                           height=bbsideheight[newbbside];
                           if (y<bbsiderect[newbbside].y1) {
                              diff=bbsiderect[newbbside].y1-y;
                              if (diff>height) {
                                 //say("OUT got here diff="diff" height="height);
                                 newbbside=0;
                              }
                           } else if (y>=bbsiderect[newbbside].y2) {
                              diff=y-bbsiderect[newbbside].y2+1;
                              if (diff>=height) {
                                 newbbside=0;
                              }
                           }
                           if (newbbside) {
                              break;
                           }
                        }
                     } else {
                        new_x1=x-mx;new_x2=new_x1+width;
                        if(
                            (y>=bbsiderect[i].y1 && y<bbsiderect[i].y2) &&
                            new_x1<bbsiderect[i].x2 && new_x2>bbsiderect[i].x1
                           ) {
                           newbbside=i;
                           width=bbsidewidth[newbbside];
                           if (x<bbsiderect[newbbside].x1) {
                              diff=bbsiderect[newbbside].x1-x;
                              if (diff>width) {
                                 //say("OUT got here diff="diff" width="width);
                                 newbbside=0;
                              }
                           } else if (x>=bbsiderect[newbbside].x2) {
                              diff=x-bbsiderect[newbbside].x2+1;
                              if (diff>=width) {
                                 newbbside=0;
                              }
                           }
                           if (newbbside) {
                              break;
                           }
                        }
                     }
                     ++i;
                     if (prev_bbside) {
                        if (i>4) {
                           i=1;
                        }
                        if (i==prev_bbside) {
                           break;
                        }
                     } else {
                        if (i>4) {
                           break;
                        }
                     }
                  }
               }
               //say("newbbside="newbbside);
               if (newbbside) {
                  RowBreakAfter=false;RowBreakBefore=false;new_twspace=0;
                  new_twspace2= -1;
                  new_i= -2;  // Nothing to do
                  // Determine how this tool bar will be inserted
                  if (newbbside==BBSIDE_TOP || newbbside==BBSIDE_BOTTOM) {
                     // Make sure mouse pointer is inside new rectangle.
                     height=bbsideheight[newbbside];
                     new_y1=y-my;

                     if (my>=height) {
                        my=height-1;
                        new_y1=y-my;
                     }
                     if (new_y1+height<=bbsiderect[newbbside].y1) {
                        // say("IN got here diff="diff" height="height);
                        new_y1=bbsiderect[newbbside].y1-height+1;
                        my=y-new_y1;
                     } else if (new_y1>=bbsiderect[newbbside].y2) {
                        new_y1=bbsiderect[newbbside].y2-1;
                        my=y-new_y1;
                     }

                     new_y2=new_y1+height;
                     NewRow=false;
                     if (_mdi._GetButtonBar(newbbside)) {
                        // Determine whether this will create a new row
                        // New row means 1/2 or more of rect inside
                        // or entire side inside rect
                        ty1=new_y1;
                        if (ty1<bbsiderect[newbbside].y1) {
                           ty1=bbsiderect[newbbside].y1;
                        }
                        ty2=new_y2;
                        if (ty2>bbsiderect[newbbside].y2) {
                           ty2=bbsiderect[newbbside].y2;
                        }
                        NewRow=!(ty2-ty1>=(new_y2-new_y1) intdiv 2 ||
                                 (ty1<=bbsiderect[newbbside].y1&&
                                  ty2>=bbsiderect[newbbside].y2
                                 )
                                );
                     } else {
                        NewRow=true;
                     }
                     if (!NewRow || !HasSizeBars) {
                        width=bbsidewidth[newbbside];
                        if (mx>=width) {
                           mx=width-1;
                        }
                        new_x1=x-mx;
                        new_x2=new_x1+width;
                     } else {
                        new_x1=bbsiderect[newbbside].x1;
                        new_x2=bbsiderect[newbbside].x2;
                     }
                     if (NewRow) {
                        if ((new_y1+new_y2)/2<
                            (bbsiderect[newbbside].y1+bbsiderect[newbbside].y2)/2
                            ){
                           new_i=0;RowBreakAfter=true;
                        } else {
                           new_i=-1;RowBreakBefore=true;
                        }
                     } else {
                        _mdi._bbdockPositionTB(newbbside,bbsiderect[newbbside].x2,bbsiderect[newbbside].y1,
                            orig_bbside,orig_i,HasSizeBars,
                            new_i,new_twspace,new_twspace2,
                            new_x1,new_y1,new_x2,new_y2,0,PutInRowBreakAfter);
                        if (HasSizeBars && orig_bbside==newbbside &&
                            (new_i-1)==orig_i &&
                             OrigHasEntireRow) {
                           //say("got here");
                           new_x1=bbsiderect[newbbside].x1;
                           new_x2=bbsiderect[newbbside].x2;
                        } else if (HasSizeBars &&
                                   orig_bbside==newbbside &&
                            _bbdockRowStart(newbbside,new_i)==_bbdockRowStart(newbbside,orig_i)
                            ) {
                           width=_lx2dx(SM_TWIP,selected_wid.p_width);
                           if (mx>=width) {
                              mx=width-1;
                           }
                           new_x1=x-mx;
                           new_x2=new_x1+width;
                        }
                     }
                  } else {
                     // Make sure mouse pointer is inside new rectangle.
                     width=bbsidewidth[newbbside];
                     new_x1=x-mx;

                     if (mx>=width) {
                        mx=width-1;
                        new_x1=x-mx;
                     }

                     if (new_x1+width<=bbsiderect[newbbside].x1) {
                        new_x1=bbsiderect[newbbside].x1-width+1;
                        mx=x-new_x1;
                     } else if (new_x1>=bbsiderect[newbbside].x2) {
                        new_x1=bbsiderect[newbbside].x2-1;
                        mx=x-new_x1;
                     }

                     new_x2=new_x1+width;
                     NewRow=false;
                     if (_mdi._GetButtonBar(newbbside)) {
                        // Determine whether this will create a new row
                        // New row means 1/2 or more of rect inside
                        // or entire side inside rect
                        tx1=new_x1;
                        if (tx1<bbsiderect[newbbside].x1) {
                           tx1=bbsiderect[newbbside].x1;
                        }
                        tx2=new_x2;
                        if (tx2>bbsiderect[newbbside].x2) {
                           tx2=bbsiderect[newbbside].x2;
                        }
                        NewRow=!(tx2-tx1>=(new_x2-new_x1) intdiv 2 ||
                                 (tx1<=bbsiderect[newbbside].x1&&
                                  tx2>=bbsiderect[newbbside].x2
                                 )
                                );
                     } else {
                        NewRow=true;
                     }
                     if (!NewRow || !HasSizeBars) {
                        height=bbsideheight[newbbside];
                        if (my>=height) {
                           my=height-1;
                        }
                        new_y1=y-my;
                        new_y2=new_y1+height;
                     } else {
                        new_y1=bbsiderect[newbbside].y1;
                        new_y2=bbsiderect[newbbside].y2;
                     }
                     if (NewRow) {
                        if ((new_x1+new_x2)/2<
                            (bbsiderect[newbbside].x1+bbsiderect[newbbside].x2)/2
                            ){
                           new_i=0;RowBreakAfter=true;
                        } else {
                           new_i=-1;RowBreakBefore=true;
                        }
                        /*if (newbbside==orig_bbside &&
                            (OrigEntireFirstRow && new_i==0) ||
                            (OrigEntireLastRow && new_i== -1)
                            ) {
                           new_i=(-2);
                        } */
                     } else {
                        _mdi._bbdockPositionLR(newbbside,bbsiderect[newbbside].y2,bbsiderect[newbbside].x1,
                            orig_bbside,orig_i,HasSizeBars,
                            new_i,new_twspace,new_twspace2,
                            new_x1,new_y1,new_x2,new_y2,0,PutInRowBreakAfter);
                        if (HasSizeBars && orig_bbside==newbbside &&
                            (new_i-1)==orig_i &&
                            OrigHasEntireRow) {
                           //say("got here");
                           new_y1=bbsiderect[newbbside].y1;
                           new_y2=bbsiderect[newbbside].y2;
                        } else if (HasSizeBars &&
                                   orig_bbside==newbbside &&
                            _bbdockRowStart(newbbside,new_i)==_bbdockRowStart(newbbside,orig_i)
                            ) {
                           height=_ly2dy(SM_TWIP,selected_wid.p_height);
                           if (my>=height) {
                              my=height-1;
                           }
                           new_y1=y-my;
                           new_y2=new_y1+height;
                        }
                     }
                  }
               }
            }
            if (!newbbside) {
               width=bbsidewidth[newbbside];
               height=bbsideheight[newbbside];
               if (mx>width) {
                  mx=width-1;
               }
               if (my>height) {
                  my=height-1;
               }
               new_x1=x-mx;new_y1=y-my;
               new_x2=new_x1+width;new_y2=new_y1+height;
               //new_x2=new_x1+width+leftWidth*2;new_y2=new_y1+height+topHeight+leftWidth;
               if (prev_bbside) {
                  // Make sure we don't intersect with side we
                  // just moved out of
                  if (y<bbsiderect[prev_bbside].y1) {
                     if (new_y2>bbsiderect[prev_bbside].y1) {
                        new_y2=bbsiderect[prev_bbside].y1;
                        new_y1=new_y2-height;
                        my=y-new_y1;
                     }
                  }
                  if (y>=bbsiderect[prev_bbside].y2) {
                     if (new_y1<bbsiderect[prev_bbside].y2) {
                        new_y1=bbsiderect[prev_bbside].y2;
                        new_y2=new_y1+height;
                        my=y-new_y1;
                     }
                  }
               }
            }
            if (newbbside!=prev_bbside) {
               mp=gDragMousePointerTab[newbbside];
               mou_set_pointer(mp);selected_wid.p_mouse_pointer=mp;
            }
            //say("newbbside="newbbside);
            if (!newbbside) {
               new_draw_width=0;
               NewDragOption="D";
            } else {
               //new_draw_width=2;NewDragOption="D";
               NewDragOption="";new_draw_width=1;
            }
            /*RECT r;
            r=bbsiderect[BBSIDE_BOTTOM];
            _draw_rect(r.x1,r.y1,r.x2,r.y2,color,'d');
            done=1;break;*/

            if (rectangle_drawn) {
               if (x1==new_x1 && y1==new_y1 && x2==new_x2 && y2==new_y2) {
                  break;
               }
               /* Erase the rectangle. */
               p_draw_width=draw_width;
               _draw_rect(x1,y1,x2,y2,color,DragOption);
            }
            rectangle_drawn=1
            x1=new_x1;y1=new_y1;x2=new_x2;y2=new_y2;
            //message("y1="y1);
            p_draw_width=new_draw_width;
            _draw_rect(x1,y1,x2,y2,color,NewDragOption);
            draw_width=new_draw_width;
            DragOption=NewDragOption;
            break;
         case ON_KEYSTATECHANGE:
            if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_TOOLBAR_DOCKING)) {
               AllowDocking=0;
               continue;
            } else {
               if (_IsKeyDown(CTRL)) {
                  AllowDocking=false;
                  event=MOUSE_MOVE;
                  continue;
               } else {
                  AllowDocking=(orig_tbflags &TBFLAG_ALLOW_DOCKING);
                  event=MOUSE_MOVE;
                  continue;
               }
            }
         case LBUTTON_UP:
         case ESC:
            done=1;
         }
         if( done) break;
         event=get_event();
      }
      mou_mode(0)
      if (rectangle_drawn) {
         /* Erase the rectangle. */
         p_draw_width=draw_width;
         _draw_rect(x1,y1,x2,y2,color,DragOption);
      }
      mou_release();
      selected_wid.p_mouse_pointer=old_mouse_pointer;
      if (CheckMinDrag) {
         event=ESC;
      }
      if (rectangle_drawn) {
         if (event!=ESC) {
            FormName=selected_wid.p_name;
            if (!newbbside) {
               _dxy2lxy(selected_wid.p_xyscale_mode,x1,y1);
               _dxy2lxy(selected_wid.p_xyscale_mode,x2,y2);
               if (orig_bbside) {
                  _mdi._bbdockRespaceAndRemove(orig_bbside,orig_i);
                  _mdi._bbdockMaybeRemoveButtonBar(orig_bbside);
                  _mdi._bbdockRefresh(orig_bbside);
                  _tbShow(FormName,x1,y1,x2-x1,y2-y1);
               } else {
#if __UNIX__
                  selected_wid._move_window(x1,y1,
                                            x2-x1-_dx2lx(SM_TWIP,padX),
                                            y2-y1-_dy2ly(SM_TWIP,padY));
#else
                  selected_wid._move_window(x1,y1,x2-x1,y2-y1);
#endif
               }
            } else {
               if (orig_bbside) {
                  // IF we are docking this toolbar in the same place.

                  if (orig_bbside==newbbside && orig_i+1==new_i &&
                      !RowBreakBefore && !RowBreakAfter &&
                      (orig_i==0 || gbbdockinfo[orig_bbside][orig_i-1].wid==BBDOCKINFO_ROWBREAK) &&
                      (orig_i+1==gbbdockinfo[orig_bbside]._length() ||
                        gbbdockinfo[orig_bbside][orig_i+1].wid==BBDOCKINFO_ROWBREAK)
                      ) {
                     RowBreakAfter=true;
                  }
                  _mdi._bbdockRespaceAndRemove(orig_bbside,orig_i);
                  if (orig_bbside!=newbbside) {
                     _mdi._bbdockRefresh(orig_bbside);
                     _mdi._bbdockMaybeRemoveButtonBar(orig_bbside);
                  } else if(new_i>orig_i){
                     --new_i;
                  }
               } else {
                  selected_wid._delete_window();
               }
               if (new_twspace2>=0) {
                  gbbdockinfo[newbbside][new_i].twspace=new_twspace2;
               }
               index=find_index(FormName,oi2type(OI_FORM));
               wid=_mdi._bbdockInsert(newbbside,new_i,
                            RowBreakBefore, //doRowBreakBefore
                            RowBreakAfter,  //doRowBreakAfter
                            index,
                            orig_tbflags,  // tbflags,
                            new_twspace   // twspaceBefore
                            );
               if (HasSizeBars) {
                  _mdi._bbdockFindWid(wid,bbside,i);
                  height=_dy2ly(SM_TWIP,y2-y1);width=_dx2lx(SM_TWIP,x2-x1);
                  wid.p_height=height;wid.p_width=width;
                  if (newbbside==BBSIDE_TOP || newbbside==BBSIDE_BOTTOM) {
                     gbbdockinfo[newbbside][i].twspace= width;
                  } else {
                     gbbdockinfo[newbbside][i].twspace= height;
                  }
               }
               _bbdockAdjustLeadingSpace(newbbside);
               _mdi._bbdockRefresh(newbbside);
            }
         }
      }
      if (rectangle_drawn && event!=ESC) {
         wid=_get_focus();
         if (wid && wid.p_isbutton_bar) {
            if (_mdi._no_child_windows()) {
               _cmdline._set_focus();
            } else {
               _mdi.p_child._set_focus();
            }
         }
      }
#endif
   }
}
/*
    i   Index of tool bar to delete
*/
static void _bbdockRespaceAndRemove(int bbside,int i)
{
   if (!_bbdockRowHasSizeBars(bbside,i) &&
        (i+1<gbbdockinfo[bbside]._length() && gbbdockinfo[bbside][i+1].wid!=BBDOCKINFO_ROWBREAK)
       ) {
      // Add this tool bar space to next tool bar in this row
      if (bbside==BBSIDE_TOP || bbside==BBSIDE_BOTTOM) {
         twspace=0;
         if (!gbbdockinfo[bbside][i].twspace && gbbdockinfo[bbside][i].wid.p_x<0) {
            twspace-=_twips_per_pixel_x();
         }
         twspace+=gbbdockinfo[bbside][i].wid.p_width+
            gbbdockinfo[bbside][i].twspace;
         /*if (!gbbdockinfo[bbside][i+1].twspace) {
            twspace-=_twips_per_pixel_x();
         } */
         twspace=_lx2lx(SM_TWIP,SM_TWIP,twspace);
         gbbdockinfo[bbside][i+1].twspace+=twspace;
      } else {
         twspace=0;
         if (!gbbdockinfo[bbside][i].twspace &&
             gbbdockinfo[bbside][i].wid.p_y<0) {
            twspace-=_twips_per_pixel_y();
         }
         twspace+=gbbdockinfo[bbside][i].wid.p_height+
            gbbdockinfo[bbside][i].twspace;
         /*if (!gbbdockinfo[bbside][i+1].twspace) {
            twspace-=_twips_per_pixel_y();
         } */
         twspace=_ly2ly(SM_TWIP,SM_TWIP,twspace);
         gbbdockinfo[bbside][i+1].twspace+=twspace;
      }
   }
   _mdi._bbdockRemove(bbside,i);
}

void _bbdockPositionTB(int bbside,int bbside_x2,int bbside_y1,
                      int orig_bbside,int orig_i,boolean HasSizeBars,
                      int &new_i,int &new_twspace,int &new_twspace2,int x1,int y1,int x2,int y2,
                       int PutInRow, /* 0 specifies NULL */
                       boolean &PutInRowBreakAfter
                       )
{
   //say('positionTB: x1='x1' width='(x2-x1));
   new_twspace=0;
   new_twspace2= -1;

   // Determine which row rect will go in
   middle=(y1+y2) intdiv 2;
   RowStart=0;
   next_y=bbside_y1;
   last_wid=0;
   PutInRowBreakAfter=0;
   line_height=0;
   docked_row=_bbdockQRestoreRow(bbside,0);
   if (!docked_row) {
      docked_row=_tbQMaxRestoreRow(bbside);
   }
   for (i=0;;++i) {
      if (PutInRow && docked_row>PutInRow) {
         // Insert this tool before this toolbar.
         new_i=i;
         PutInRowBreakAfter=true;
         return;
      }
      if (i>=gbbdockinfo[bbside]._length()) {
         next_y+=line_height;
         break;
      }
      if (!last_wid) {
         RowStart=i;
         next_y+=line_height;
         line_height=_ly2dy(SM_TWIP,_bbdockRowHeight(bbside,i));
         if (PutInRow) {
            if (PutInRow==docked_row) {
               break;
            }
         } else {
            if (middle<next_y+line_height) {
               break;
            }
         }
      }
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         //_message_box('i='i' count='count);
         docked_row=_bbdockQRestoreRow(bbside,i+1);
         if (!docked_row) {
            docked_row=_tbQMaxRestoreRow(bbside);
         }
      }
      last_wid=wid;
   }
   // The row this will go in is RowStart
   // Determine where in this row and what the new spacing
   // will be.
   RowHasSizeBars=_bbdockRowHasSizeBars(bbside,RowStart);
   for (i=RowStart;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         break;
      }
      wid=gbbdockinfo[bbside][i].wid;
      if (wid>0) {
         x=_lx2dx(wid.p_xyscale_mode,wid.p_x);junk=0;
         _map_xy(wid.p_xyparent,0,x,junk,SM_PIXEL);
         if (x1<x && !(bbside==orig_bbside && i==orig_i)) {
            new_i=i;
            // The original tool bar is seen as leading space
            add_space=0;
            if (bbside==orig_bbside && i-1==orig_i && !HasSizeBars) {
               add_space+=_lx2dx(wid.p_xyscale_mode,gbbdockinfo[bbside][orig_i].twspace);
               add_space+=_lx2dx(wid.p_xyscale_mode,gbbdockinfo[bbside][orig_i].wid.p_width);
            }
            // IF this tool bar has leading space
            if (!HasSizeBars && !RowHasSizeBars &&
                 (gbbdockinfo[bbside][i].twspace+add_space)
                ) {
               space=_lx2dx(wid.p_xyscale_mode,gbbdockinfo[bbside][i].twspace);
               space+=add_space;
               space_x=x-space;
               if (x1<space_x) {
                  adjust=space_x-x1;
                  x1+=adjust;x2+=adjust;
               }
               // IF this new tool bar fits totally in this space
               if (x2<=x) {
                  new_twspace=x1-space_x;
                  new_twspace2=x-x2-1;
                  if (!new_twspace) {
                     ++new_twspace2;
                  } else if (add_space && new_twspace && gbbdockinfo[bbside][orig_i].twspace==0) {
                     --new_twspace2;
                     //say("got here");
                  }
                  if (new_twspace2<0) new_twspace2=0;
                  if (new_twspace2 && add_space && gbbdockinfo[bbside][i].twspace==0) {
                     --new_twspace2;
                  }
                  if (add_space && gbbdockinfo[bbside][orig_i].wid.p_x<0) {
                     tempx=_lx2dx(SM_TWIP,gbbdockinfo[bbside][orig_i].wid.p_x);
                     tempy=0;
                     _map_xy(gbbdockinfo[bbside][orig_i].wid,0,tempx,tempy,SM_PIXEL);
                     // If this control has not moved.
                     if (tempx==x1) {
                        if (new_twspace>0) {
                           --new_twspace;
                        } else {
                           --new_twspace2;
                        }
                     }
                  }
                  //say("new_twspace="new_twspace" new_twspace2="new_twspace2);
               } else {
                  new_twspace=x1-space_x;
                  new_twspace2=0;
               }
               new_twspace=_dx2lx(SM_TWIP,new_twspace);
               new_twspace2=_dx2lx(SM_TWIP,new_twspace2);
            }
            break;
         }
         if (i+1>=gbbdockinfo[bbside]._length() ||
             gbbdockinfo[bbside][i+1].wid==BBDOCKINFO_ROWBREAK) {
            //We are inserting after the last control.
            new_i=i+1;
            if (!HasSizeBars && !RowHasSizeBars) {
               if (bbside==orig_bbside && new_i-1==orig_i && !HasSizeBars) {
                  space_x=_lx2dx(wid.p_xyscale_mode,gbbdockinfo[bbside][orig_i].wid.p_x-gbbdockinfo[bbside][orig_i].twspace);
                  //say("APPEND leading space from self");
               } else {
                  //say("APPEND case");
                  wid=gbbdockinfo[bbside][i].wid;
                  space_x=_lx2dx(wid.p_xyscale_mode,wid.p_x+wid.p_width);
               }
               junk=0;
               _map_xy(wid.p_xyparent,0,space_x,junk,SM_PIXEL);
               if (x2>bbside_x2) {
                  diff=x2-bbside_x2;
                  x1-=diff;x2-=diff;
               }
               if (x1>space_x) {
                  new_twspace=_dx2lx(SM_TWIP,x1-space_x);
               }
            }
            break;
         }
      }
   }
}
void _bbdockPositionLR(int bbside,int bbside_y2,int bbside_x1,
                      int orig_bbside,int orig_i,boolean HasSizeBars,
                      int &new_i,int &new_twspace,int &new_twspace2,int x1,int y1,int x2,int y2,
                       int PutInRow, /* 0 specifies NULL */
                       boolean &PutInRowBreakAfter
                       )
{
   new_twspace=0;
   new_twspace2= -1;

   // Determine which row rect will go in
   middle=(x1+x2) intdiv 2;
   RowStart=0;
   next_x=bbside_x1;
   last_wid=0;
   PutInRowBreakAfter=0;
   line_width=0;
   docked_row=_bbdockQRestoreRow(bbside,0);
   if (!docked_row) {
      docked_row=_tbQMaxRestoreRow(bbside);
   }
   for (i=0;;++i) {
      if (PutInRow && docked_row>PutInRow) {
         // Insert this tool before this toolbar.
         new_i=i;
         PutInRowBreakAfter=true;
         return;
      }
      if (i>=gbbdockinfo[bbside]._length()) {
         next_x+=line_width;
         break;
      }
      if (!last_wid) {
         RowStart=i;
         next_x+=line_width;
         line_width=_lx2dx(SM_TWIP,_bbdockRowWidth(bbside,i));
         if (PutInRow) {
            if (PutInRow==docked_row) {
               break;
            }
         } else {
            if (middle<next_x+line_width) {
               break;
            }
         }
      }
      wid=gbbdockinfo[bbside][i].wid;
      if (wid==BBDOCKINFO_ROWBREAK) {
         //_message_box('i='i' count='count);
         docked_row=_bbdockQRestoreRow(bbside,i+1);
         if (!docked_row) {
            docked_row=_tbQMaxRestoreRow(bbside);
         }
      }
      last_wid=wid;
   }
   // The row this will go in is RowStart
   // Determine where in this row and what the new spacing
   // will be.
   RowHasSizeBars=_bbdockRowHasSizeBars(bbside,RowStart);
   for (i=RowStart;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         break;
      }
      wid=gbbdockinfo[bbside][i].wid;
      if (wid>0) {
         y=_ly2dy(wid.p_xyscale_mode,wid.p_y);junk=0;
         _map_xy(wid.p_xyparent,0,junk,y,SM_PIXEL);
         if (y1<y && !(bbside==orig_bbside && i==orig_i)) {
            new_i=i;
            // The original tool bar is seen as leading space
            add_space=0;
            if (bbside==orig_bbside && i-1==orig_i && !HasSizeBars) {
               add_space+=_ly2dy(wid.p_xyscale_mode,gbbdockinfo[bbside][orig_i].twspace);
               add_space+=_ly2dy(wid.p_xyscale_mode,gbbdockinfo[bbside][orig_i].wid.p_height);
            }
            // IF this tool bar has leading space
            if (!HasSizeBars && !RowHasSizeBars &&
                 (gbbdockinfo[bbside][i].twspace+add_space)
                ) {
               space=_ly2dy(wid.p_xyscale_mode,gbbdockinfo[bbside][i].twspace);
               space+=add_space;
               space_y=y-space;
               if (y1<space_y) {
                  adjust=space_y-y1;
                  y1+=adjust;y2+=adjust;
               }
               // IF this new tool bar fits totally in this space
               if (y2<=y) {
                  new_twspace=y1-space_y;
                  new_twspace2=y-y2-1;
                  if (!new_twspace) {
                     ++new_twspace2;
                  } else if (add_space && new_twspace && gbbdockinfo[bbside][orig_i].twspace==0) {
                     --new_twspace2;
                  }
                  if (new_twspace2<0) new_twspace2=0;
                  if (new_twspace2 && add_space && gbbdockinfo[bbside][i].twspace==0) {
                     --new_twspace2;
                  }
                  if (add_space && gbbdockinfo[bbside][orig_i].wid.p_y<0) {
                     tempy=_ly2dy(SM_TWIP,gbbdockinfo[bbside][orig_i].wid.p_y);
                     tempx=0;
                     _map_xy(gbbdockinfo[bbside][orig_i].wid,0,tempx,tempy,SM_PIXEL);
                     // If this control has not moved.
                     if (tempy==y1) {
                        if (new_twspace>0) {
                           --new_twspace;
                        } else {
                           --new_twspace2;
                        }
                     }
                  }
#if 0
                  new_twspace=y1-space_y;
                  new_twspace2=y-y2-1;
                  if (!new_twspace) {
                     new_twspace2-=2;
                     //++new_twspace2;
                  } else if (add_space && new_twspace && gbbdockinfo[bbside][orig_i].twspace==0) {
                     new_twspace2-=4;
                  } else {
                     new_twspace2-=3;
                  }
                  if (new_twspace2<0) new_twspace2=0;
                  if (new_twspace2 && add_space && gbbdockinfo[bbside][i].twspace==0) {
                     --new_twspace2;
                  }
                  if (add_space && gbbdockinfo[bbside][orig_i].wid.p_y<0) {
                     tempy=_ly2dy(SM_TWIP,gbbdockinfo[bbside][orig_i].wid.p_y);
                     tempx=0;
                     _map_xy(gbbdockinfo[bbside][orig_i].wid,0,tempx,tempy,SM_PIXEL);
                     // If this control has not moved.
                     if (tempy==y1) {
                        if (new_twspace>0) {
                           --new_twspace;
                        } else {
                           --new_twspace2;
                        }
                     }
                  }
                  if (new_twspace2) {
                     new_twspace2+=3;
                  }
#endif
               } else {
                  new_twspace=y1-space_y;
                  new_twspace2=0;
               }
               new_twspace=_dy2ly(SM_TWIP,new_twspace);
               new_twspace2=_dy2ly(SM_TWIP,new_twspace2);
            }
            break;
         }
         if (i+1>=gbbdockinfo[bbside]._length() ||
             gbbdockinfo[bbside][i+1].wid==BBDOCKINFO_ROWBREAK) {
            //We are inserting after the last control.
            new_i=i+1;
            if (!HasSizeBars && !RowHasSizeBars) {
               if (bbside==orig_bbside && new_i-1==orig_i && !HasSizeBars) {
                  space_y=_ly2dy(wid.p_xyscale_mode,gbbdockinfo[bbside][orig_i].wid.p_y-gbbdockinfo[bbside][orig_i].twspace);
                  //say("APPEND leading space from self");
               } else {
                  //say("APPEND case");
                  wid=gbbdockinfo[bbside][i].wid;
                  space_y=_ly2dy(wid.p_xyscale_mode,wid.p_y+wid.p_height);
               }
               junk=0;
               _map_xy(wid.p_xyparent,0,junk,space_y,SM_PIXEL);
               if (y2>bbside_y2) {
                  diff=y2-bbside_y2;
                  y1-=diff;y2-=diff;
               }
               if (y1>space_y) {
                  new_twspace=_dy2ly(SM_TWIP,y1-space_y);
               }
            }
            break;
         }
      }
   }
}
void _toolbar_etab2.lbutton_double_click()
{
   tbNewVersion();
   if (p_window_id!=p_active_form && !_ImageIsSpace()) {
      return;
   }
   wid=p_active_form;
   FormName=wid.p_name;
   _TOOLBAR *ptb;
   ptb=_tbFind(FormName);
   if (!ptb) {
      return;
   }
   was_docked=wid.p_isbutton_bar;
   tbClose(wid);
   if (was_docked) {
      ptb->restore_docked=false;
      tbShow(FormName);
      return;
   }
   ptb->restore_docked=true;
   _tbShowDocked(FormName);
}
void _toolbar_etab2.rbutton_up()
{
   call_event(defeventtab _bbside_form,RBUTTON_UP,'e');
}
int _tbIsVisible(_str FormName)
{
   return(_find_object(FormName,"n"));
}

void _tbexiting_editor()
{
   // _append_retrieve changes the active view in
   // the hidden window.  Here we save and restore
   // the active view.
   get_view_id(view_id);
   Noftoolbars=0;
   for (i=0;i<def_toolbartab._length();++i) {
      wid=_find_object(def_toolbartab[i].FormName,"N");
      if (wid) {
         wid.call_event(wid,ON_DESTROY);
      }
   }
   activate_view(view_id);
}
int _srg_toolbars3()
{
   tbNewVersion();
   arg1=lowcase(arg(1));
   if (arg1=='r'||arg1=='n') {
      parse arg(2) with . version Noftoolbars bbdockNoflines tbrestoreNoflines;
      focus_wid=_get_focus();
      max_restore_row=0;
      while (Noftoolbars--) {
         down();
         get_line(line);
         parse line with form_name x y width height;
         orig_view_id=p_view_id;
         wid=_tbShow(form_name,x,y,width,height);
         p_view_id=orig_view_id;
      }
      if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_TOOLBAR_DOCKING)) {
         down(bbdockNoflines);
         if (focus_wid) {
            focus_wid._set_focus();
         }
         return(0);
      }
      if (tbrestoreNoflines!='') {
         while (tbrestoreNoflines--) {
            down();
            get_line(line);
            parse line with form_name restore_docked show_x show_y show_width show_height docked_bbside docked_row docked_x docked_y docked_width docked_height .;
            _TOOLBAR *ptb;
            ptb=_tbFind(form_name);
            if (ptb) {
               ptb->restore_docked=restore_docked;
               ptb->show_x=show_x;
               ptb->show_y=show_y;
               ptb->show_width=show_width;
               ptb->show_height=show_height;
               ptb->docked_bbside=docked_bbside;
               ptb->docked_row=docked_row;
               ptb->docked_x=docked_x;
               ptb->docked_y=docked_y;
               ptb->docked_width=docked_width;
               ptb->docked_height=docked_height;
               if (docked_bbside && docked_row>max_restore_row) {
                  max_restore_row=docked_row;
               }
            }
         }
      }
      for (i=1;i<=4;++i) {
         if (_mdi._GetButtonBar(i)) {
            _mdi._GetButtonBar(i)._delete_window();
         }
      }
      error=0;
      gbbdockinfo._makeempty();
      old_bbside=0;
      while (bbdockNoflines--) {
         down();
         get_line(line);
         if (error) {
            continue;
         }
         parse line with bbside i FormNameOrIntInfo twspace tbflags width height docked_row .;
         if (old_bbside!=bbside && old_bbside) {
            _mdi._bbdockAdjustRowBreaks(old_bbside);
            _mdi._bbdockAddRemoveSizeBars(old_bbside);
            _mdi._bbdockRefresh(old_bbside);
         }
         old_bbside=bbside;
         BBDOCKINFO *pbbdockinfo;
         bbside_wid=_mdi._GetButtonBar(bbside);
         // If the _bbside_form has not been loaded for this side
         if(!bbside_wid) {
            index=find_index("_bbside_form",oi2type(OI_FORM));
            _mdi._LoadButtonBar(index,bbside);
            bbside_wid=_mdi._GetButtonBar(bbside);
         }
         if (isinteger(FormNameOrIntInfo)) {
            pbbdockinfo=&gbbdockinfo[bbside][i];
            pbbdockinfo->wid=FormNameOrIntInfo;
            if (!pbbdockinfo->wid && docked_row>max_restore_row) {
               max_restore_row=docked_row;
            }
            twspace=0;  //Zap window id
         } else {
            resource_index=find_index(FormNameOrIntInfo,oi2type(OI_FORM));
            if (!resource_index) {
               error=1;
               continue;
            }
            pbbdockinfo=&gbbdockinfo[bbside][i];
            /*if (tbflags &TBFLAG_SIZEBARS) {
               NoBorder="N";
            } else {
               NoBorder="";
            }
            */
            //messageNwait("resource="name_name(resource_index)" bo="bbside_wid.p_object" options="'HP':+NoBorder);
            wid=_tbLoadTemplate(tbflags,resource_index,bbside_wid);
            pbbdockinfo->wid=wid;
            if (tbflags &TBFLAG_SIZEBARS) {
               wid.p_width=width;wid.p_height=height;
            }
         }
         pbbdockinfo->twspace=twspace;
         pbbdockinfo->sizebarAfterWid=0;
         pbbdockinfo->tbflags=tbflags;
         pbbdockinfo->docked_row=docked_row;
      }
      if (error) {
         tbResetAll();
      } else {
         if (old_bbside) {
            _mdi._bbdockAdjustRowBreaks(old_bbside);
            _mdi._bbdockAddRemoveSizeBars(old_bbside);
            _mdi._bbdockRefresh(old_bbside);
         }
         // IF the docked_row numbers are getting large
         //_message_box('max_restore_row='max_restore_row);
         if (max_restore_row>1000) {
            _tbShrinkRestoreRowNumbers();
         }
      }
      //_message_box('h2 max_restore_row='max_restore_row);


      if (focus_wid) {
         focus_wid._set_focus();
      }
   }else{
      save_pos(p);
      Noftoolbars=0;
      for (i=0;i<def_toolbartab._length();++i) {
         wid=_find_object(def_toolbartab[i].FormName,"N");
         if (wid && !wid.p_isbutton_bar) {
            ++Noftoolbars;
            wid._get_window(x,y,width,height);
            insert_line(def_toolbartab[i].FormName" "x" "y" "width" "height);
         }
      }
      tbrestoreNoflines=0;
      for (i=0;i<def_toolbartab._length();++i) {
         ++tbrestoreNoflines;
         _TOOLBAR *ptb;
         ptb=&def_toolbartab[i];
         insert_line(ptb->FormName" "ptb->restore_docked" ":+
                     ptb->show_x" "ptb->show_y" "ptb->show_width" "ptb->show_height" ":+
                     ptb->docked_bbside" "ptb->docked_row" "ptb->docked_x" "ptb->docked_y" "ptb->docked_width" "ptb->docked_height);
      }

      bbdockNoflines=0;
      for (bbside=1;bbside<=4;++bbside) {
         wid=_mdi._GetButtonBar(bbside);
         if (wid) {
            for (i=0;i<gbbdockinfo[bbside]._length();++i) {
               BBDOCKINFO *pbbdockinfo;
               pbbdockinfo=&gbbdockinfo[bbside][i];
               wid=pbbdockinfo->wid;
               if (wid>0) {
                  width=wid.p_width;height=wid.p_height;
                  wid=wid.p_name;
                  tbflags=pbbdockinfo->tbflags;
                  twspace=pbbdockinfo->twspace;
                  docked_row=0;
               } else {
                  tbflags=0;
                  twspace=0;
                  width=height=0;
                  if (wid==BBDOCKINFO_ROWBREAK) {
                     docked_row=pbbdockinfo->docked_row;
                  }
               }
               ++bbdockNoflines;
               insert_line(bbside" "i" "wid" "twspace" "tbflags" "width" "height" "docked_row);
            }
         }
      }
      //if (Noftoolbars || bbdockNoflines) {
         orig_line=p_line;
         restore_pos(p);
         //messageNwait('tbrestoreNoflines='tbrestoreNoflines);
         insert_line('TOOLBARS3: '(Noftoolbars+bbdockNoflines+tbrestoreNoflines)" 1 "Noftoolbars" "bbdockNoflines" "tbrestoreNoflines);
         p_line=orig_line+1;
      //}
   }
   return(0);
}
static void _tbShrinkRestoreRowNumbers()
{
   for (bbside=1;bbside<=4;++bbside) {
      max_restore_row=_tbQMaxRestoreRow(bbside);
      int xlat[];
      for (i=0;i<=max_restore_row;++i) {
         xlat[i]=0;
      }
      for (i=0;i<gbbdockinfo[bbside]._length();++i) {
         BBDOCKINFO *pbbdockinfo;
         pbbdockinfo=&gbbdockinfo[bbside][i];
         wid=pbbdockinfo->wid;
         if (wid==BBDOCKINFO_ROWBREAK) {
            xlat[pbbdockinfo->docked_row]=1;
         }
      }
      for (i=0;i<def_toolbartab._length();++i) {
         _TOOLBAR *ptb;
         ptb=&def_toolbartab[i];
         if (ptb->docked_bbside==bbside) {
            xlat[ptb->docked_row]=1;
         }
      }
      restore_row=1;
      for (i=0;i<=max_restore_row;++i) {
         if (xlat[i]) {
            xlat[i]=restore_row;
            ++restore_row;
         }
      }
      for (i=0;i<gbbdockinfo[bbside]._length();++i) {
         BBDOCKINFO *pbbdockinfo;
         pbbdockinfo=&gbbdockinfo[bbside][i];
         wid=pbbdockinfo->wid;
         if (wid==BBDOCKINFO_ROWBREAK) {
            pbbdockinfo->docked_row=xlat[pbbdockinfo->docked_row];
         }
      }
      for (i=0;i<def_toolbartab._length();++i) {
         _TOOLBAR *ptb;
         ptb=&def_toolbartab[i];
         if (ptb->docked_bbside==bbside) {
            ptb->docked_row=xlat[ptb->docked_row];
         }
      }

   }
}
#define PropertiesOfWid ctlok.p_user
#define OriginalCommand ctlcommandlabel.p_user
#define OriginalMessage ctlmessage.p_user
#define OriginalBitmap  ctlbitmap.p_user
#define OriginalCaption ctlcaption.p_user

defeventtab _ToolBarProperties_form
void ctlcommand.on_change(reason)
{
   if (p_text=="") {
      _auto_enable.p_enabled=0;
      return;
   }
   parse p_text with cmdname .;
   index=find_index(cmdname,COMMAND_TYPE);
   if (index && !(name_type(index) &DLLCALL_TYPE) ) {
      enabled=true;
   } else {
      enabled=false;
   }
   if (enabled!=_auto_enable.p_enabled) {
      _auto_enable.p_enabled=enabled;
   }
}
void _auto_enable.lbutton_up()
{
   parse ctlcommand.p_text with cmdname .;
   show('-modal _autoenable_form',cmdname);
}
ctlcommand.on_drop_down(reason)
{
   if (p_user=='') {
      wid=p_window_id;p_window_id=p_cb_list_box;
      //_lbadd_item('(space)')
      //_lbadd_item('(row break)')
      //insert_special_controls();
      _insert_name_list(COMMAND_TYPE);
      _lbtop();
      _lbsort('i')
      p_window_id=wid;
      p_user=1;
   }
}
void ctlok.lbutton_up()
{
   wid=PropertiesOfWid;
   if (OriginalCommand!=ctlcommand.p_text ||
       OriginalMessage!=ctlmessage.p_text ||
       (OriginalBitmap!=ctlbitmap.p_text && !(wid.p_object==OI_IMAGE &&wid.p_caption!=""))||
       (OriginalCaption!=ctlcaption.p_text && ctlcaption.p_enabled)
       ) {
      name=strip(ctlbitmap.p_text,'B','"');
      name=strip_filename(name,'P');
      if (!file_eq(name_name(ctlbitmappic.p_picture),name)) {
         //_message_box("loading bitmap");
         if(load_bitmap(name)) return;
      }
      //_message_box("changed");
      if (isinteger(wid) && _iswindow_valid(wid)) {
         first_child=child=wid.p_active_form.p_child;
         count=1;
         for (;;++count) {
            if (child==wid) {
               break;
            }
            child=child.p_next;
            if (child==first_child) {
               p_active_form._delete_window(0);
            }
         }
         index=find_index(wid.p_active_form.p_name,oi2type(OI_FORM));
         if (index) {
            first_child=child=index.p_child;
            while (--count) {
               child=child.p_next;
               if (!child || child==first_child) {
                  p_active_form._delete_window(0);
                  return;
               }
            }
            child.p_command=ctlcommand.p_text;
            wid.p_command=ctlcommand.p_text;
            if (wid.p_object==OI_IMAGE) {
               child.p_message=ctlmessage.p_text;
               wid.p_message=ctlmessage.p_text;
               if (wid.p_object==OI_IMAGE && wid.p_caption=="") {
                  child.p_picture=ctlbitmappic.p_picture;
                  wid.p_picture=ctlbitmappic.p_picture;
               }else if (ctlcaption.p_enabled) {
                  child.p_caption=ctlcaption.p_text;
                  wid.p_caption=ctlcaption.p_text;
               }
               wid.p_active_form._tbResizeButtonBar(wid.p_isbutton_bar);
               if (wid.p_isbutton_bar) {
                  _mdi._bbdockRefresh(wid.p_isbutton_bar);
               }
            }
            _set_object_modify(index);
         }
      }
   }
   p_active_form._delete_window(0);
}
void ctlcaption.on_change()
{
   if (ctlcaption.p_enabled) {
      ctlok.p_enabled=ctlcaption.p_text!="";
   }
}
void ctlok.on_create()
{
   _KillToolTipMessages();
   wid=arg(1);
   PropertiesOfWid=wid;
   if (isinteger(wid) && _iswindow_valid(wid)) {
      if (wid.p_object==OI_IMAGE) {
         ctlcommand.p_text=wid.p_command;
         ctlmessage.p_text=wid.p_message;
         if (wid.p_caption!="") {
            ctlbitmap.p_enabled=ctlbitmaplabel.p_enabled=0;
            ctlcaptionlabel.p_enabled=ctlcaption.p_enabled=TRUE;
            ctlcaption.p_text=wid.p_caption;
         } else {
            ctlbitmappic.p_picture=wid.p_picture;
            ctlbitmap.p_text=name_name(ctlbitmappic.p_picture);
         }
      } else {
         ctlmessage.p_enabled=ctlmessagelabel.p_enabled=0;
         ctlbitmap.p_enabled=ctlbitmaplabel.p_enabled=0;
      }
   }
   OriginalCommand=ctlcommand.p_text;
   OriginalMessage=ctlmessage.p_text;
   OriginalBitmap=ctlbitmap.p_text;
   OriginalCaption=ctlcaption.p_text;
   ctlbitmap.p_cb_picture.p_picture=_pic_cbdots;
}
static int load_bitmap(result)
{
   result=strip(result,'B','"');
   /* Find existing picture. */
   old_index= find_index(strip_filename(result,'p'),PICTURE_TYPE)
   index= _update_picture(-1,result)
   if (index<0) {
      p_window_id=ctlbitmap;
      _set_sel(1,length(p_text)+1);_set_focus();
      if (index==FILE_NOT_FOUND_RC) {
         _message_box(nls("File %s not found.\n\nBitmap file must be in search PATH",result));
         return(1);
      }
      _message_box(get_message(index));
      return(1);
   } else {
      ctlbitmap.p_text=strip_filename(result,'P');
      ctlbitmappic.p_picture=index;
   }
   return(0);
}
void ctlbitmap.on_change(reason)
{
   name=strip(p_text,'B','"');
   name=strip_filename(name,'P');
   ctlbitmappic.p_picture=find_index(name,PICTURE_TYPE);
}
void ctlbitmap.lbutton_down()
{
   if (p_cb_active==p_cb_picture) {
      if (!p_cb_picture._push_button()) {
         return;
      }
      // Open existing .bmp file
      result=_OpenDialog(_stdform('_open_form')' -modal',
           'Open picture',
#if __UNIX__
              '*.xpm;*.bmp',
              "Bitmaps (*.xpm;*.bmp),All Files ("ALLFILES_RE")",
#else
              '*.bmp',
              "Bitmaps (*.bmp),All Files ("ALLFILES_RE")",
#endif
           OFN_FILEMUSTEXIST,
           'bmp',      // Default extensions
           '',         // Initial filename
           '',         // Initial directory
           'bmp'       // Retrieve name
           )
      if (result!='') {
         load_bitmap(result);
      }
      return;
   }
   call_event(defeventtab  _ul2_combobx,LBUTTON_DOWN,'E')
}
#if 0
void _tbChangeButton(_str FromBitmapName,_str ToBitmapName,
                     _str ToCommand,_str ToMessage)
{
   index=find_index(FromBitmapName,PICTURE_TYPE);
   if (!index) return;
   for (i=1;i<=_last_window_id();++i) {
      if (_iswindow_valid(i) && i.p_object==OI_IMAGE) {
         if (index==i.p_picture) {//Found the record button
            //11:34am 8/27/1997
            //Changed this so that there is not a problem if a bitmap is missing
            index=find_index(ToBitmapName,PICTURE_TYPE);
            if (index) {
               i.p_picture=index;
               i.p_command=ToCommand;
               i.p_message=ToMessage;
            }
         }
      }
   }
}
#endif

defeventtab _ToolBarNew_form
void ctlformname.on_drop_down(reason)
{
   if (p_user=='') {
      wid=p_window_id;p_window_id=p_cb_list_box;

      //match_fun_index=match_prefix2index(completion,match_flags,multi_select, last_arg2)
      match_name=_form_match('tb',1);
      for (;;) {
         if (match_name=='') {
            break;
         }
         _lbadd_item(match_name);
         match_name=_form_match('',0);
      }
      match_name=_form_match('_tb',1);
      for (;;) {
         if (match_name=='') {
            break;
         }
         _lbadd_item(match_name);
         match_name=_form_match('',0);
      }
      _lbsort('e');
      _UnderScoresToBottom();
      top();
      p_window_id=wid;

      p_user=1;
   }
}
ctladvanced.lbutton_up()
{
   _dmmoreless();
}
void ctlok.on_create()
{
   for (i=1;;++i) {
      caption="User Toolbox "i;
      if(!_tbFindCaption(caption,index)) {
         break;
      }
   }
   ctlname.p_text=caption;

   ctladvanced._dmless();
   tbflags=(TBFLAG_NEW_TOOLBAR)&(TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED|TBFLAG_SIZEBARS);
   ctladdcontrols.p_value=(tbflags&TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED);
   ctlsizebars.p_value=(tbflags &TBFLAG_SIZEBARS);
}
void ctlok.lbutton_up()
{
   formname=ctlformname.p_text;
   if (ctlname.p_text=="" && formname=="") {
      _message_box("No toolbar name specified");
      ctlname._set_focus();
      return;
   }
   index=0;
   if (formname!="") {
      index=find_index(formname,oi2type(OI_FORM));
      if (!index) {
         _message_box("Form name not found");
         ctlformname._set_focus();
         return;
      }
      ff=name_info(index);
      if (!isinteger(ff)) ff=0;
      if (ff & FF_SYSTEM) {
         // User can destroy a caption.
         // AND.  Ok and cancel may do weird stuff.
         // AND.  Who knows what might happen.
         _message_box("System dialog boxes are not allows as tool bars");
         ctlformname._set_focus();
         return;
      }
   }
   _param1=ctlname.p_text;
   _param2=index;
   tbflags=(TBFLAG_NEW_TOOLBAR)&(TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED|TBFLAG_SIZEBARS);
   if (ctladdcontrols.p_value) {
      tbflags|=TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED;
   } else {
      tbflags&=~TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED;
   }
   if (ctlsizebars.p_value) {
      tbflags|=TBFLAG_SIZEBARS;
   } else {
      tbflags&=~TBFLAG_SIZEBARS;
   }
   _param3=tbflags;
   p_active_form._delete_window(1);
}

#define ORIGINAL_SHOWTOOLTIPS ctltooltips.p_user
#define ORIGINAL_HIDE ctlhide.p_user
defeventtab _toolbars_prop_form

//Added this so that double clicking in the list will toggle a toolbar on/off
void list1.lbutton_double_click()
{
   ctlvisible.p_value=(int)(!ctlvisible.p_value);
   ctlvisible.call_event(ctlvisible,LBUTTON_UP);
}
static int _TBDefaultsSupported(_str FormName, int &tbIndex )
{
   for ( i = 0; i < gToolbarDefaultTab._length(); i++ ) {
      if ( FormName == gToolbarDefaultTab[i].FormName) {
         tbIndex = i;
         return( 1 );
      }
   }
   return( 0 );
}
static void _tbResetToDefaults(_str FormName)
{
   int tbIndex;
   if ( !_TBDefaultsSupported( FormName, tbIndex ) ) return;

   orig_form_wid=p_active_form;orig_wid=p_window_id;
   old_form_index=find_index(FormName,oi2type(OI_FORM));
   if (!old_form_index) return;
   VisibleWid=_tbIsVisible(FormName);

   form_wid=_create_window(OI_FORM,orig_form_wid,"",0,0,2000,900,CW_PARENT|CW_HIDDEN,BDS_SIZABLE);
   form_wid.p_name=FormName;
   form_wid.p_caption=old_form_index.p_caption;
   form_wid.p_tool_window=true;
   form_wid.p_CaptionClick=true;
   form_wid.p_eventtab2=find_index("_toolbar_etab2",EVENTTAB_TYPE);

   int count;
   count = gToolbarDefaultTab[tbIndex].CtrlList._length();
   for ( i = 0; i < count; ++i) {
      picname = gToolbarDefaultTab[tbIndex].CtrlList[i].name;
      special_control=0;
      if ( substr(picname,1,1):=="\t") {
         SPECIALCONTROL *psc;
         picname=substr(picname,2);
         psc=&gtwSpecialControlTab:[picname];
         wid=_create_window(psc->object,form_wid,"",0,0,0,0,CW_CHILD);
         wid.p_tab_index=i+1;
         if (psc->eventtab_name!="") {
            wid.p_eventtab=find_index(psc->eventtab_name,EVENTTAB_TYPE);
         }
         switch (psc->object) {
         case OI_IMAGE:
            wid.p_message=picname;
            break;
         default:
            _message_box("Internal bug.  Control not supported");
            break;
         }
         continue;
      }
      wid=_create_window(OI_IMAGE,form_wid,"",0,0,0,0,CW_CHILD);
      wid.p_tab_index=i+1;
      picindex = find_index( strip_filename( picname,'p' ), PICTURE_TYPE );
      if ( !picindex ) continue;
      wid.p_picture=picindex;
      wid.p_command = gToolbarDefaultTab[tbIndex].CtrlList[i].command;
      wid.p_message=gToolbarDefaultTab[tbIndex].CtrlList[i].msg;
      wid.p_style=PSPIC_AUTO_BUTTON;
      wid.p_Nofstates=2;
      wid.p_eventtab2=defeventtab _ul2_picture;
   }
   delete_name(old_form_index);

   form_wid._tbResizeButtonBar2(_screen_width()*10,true,junk1,junk2,BBSIDE_TOP);
   status=form_wid._update_template();
   set_name_info(status,FF_SYSTEM);
   _set_object_modify(status);
   form_wid._delete_window();
   if (VisibleWid) {
      _tbRedisplay(VisibleWid);
   }
   p_window_id=orig_wid;
}
void ctlreset.lbutton_up()
{
   _TOOLBAR *ptb;
   i=list1.p_line-1;
   ptb=&def_toolbartab[i];
   _tbResetToDefaults(ptb->FormName);
}

void ctlrename.lbutton_up()
{
   result = show('-modal _textbox_form',
                 'New Toolbar Name',	// Form caption
                 0,	//flags
                 '',	//use default textbox width
                 '',	//Help item.
                 '',	//Font (not yet supported)
                 '',	//Retrieve Name
                 'New Toolbar Name:'list1._lbget_text()
                 );
   if (result=='') {
      return;
   }
   newname=_param1;

   if(_tbFindCaption(newname,index)) {
      _message_box("This toolbar name already exists");
      return;
   }
   _TOOLBAR *ptb;
   i=list1.p_line-1;
   ptb=&def_toolbartab[i];
   wid=_tbIsVisible(ptb->FormName);
   if (wid) {
      wid.p_caption=newname;
   }
   index=find_index(ptb->FormName,oi2type(OI_FORM));
   if (index) {
      index.p_caption=newname;
      _set_object_modify(index);
   }

   list1._lbset_item(newname);
   list1._lbselect_line();
}
void ctldelete.lbutton_up()
{
   caption=list1._lbget_text();
   id=_message_box(nls("Are you sure you want to delete toolbar '%s'?",caption), '', MB_YESNOCANCEL|MB_ICONQUESTION);
   if (id!=IDYES) {
      return;
   }
   _TOOLBAR *ptb;
   i=list1.p_line-1;
   ptb=&def_toolbartab[i];
   wid=_tbIsVisible(ptb->FormName);
   if (wid) {
      tbClose(wid);
   }
   if (substr(ptb->FormName,1,length(USER_FORM_PREFIX))==USER_FORM_PREFIX) {
      index=find_index(ptb->FormName,oi2type(OI_FORM));
      if (index) {
         delete_name(index);
      }
   }
   _config_modify|=CFGMODIFY_SYSRESOURCE|CFGMODIFY_RESOURCE;
   def_toolbartab._deleteel(i);
   list1._lbdelete_item();
   list1._lbselect_line();
   list1.call_event(CHANGE_SELECTED,list1,ON_CHANGE,'');
}
void ctlnew.lbutton_up()
{
   orig_form_wid=p_active_form;
   result=show("-modal _ToolBarNew_form");
   if (result!="") {
      if (_param1!="") {
         // Make sure this title is not already used.
         if(_tbFindCaption(_param1,index)) {
            _message_box("This toolbar name already exists");
            return;
         }
      }
      _TOOLBAR *ptb;
      ptb=0;
      // Have index to form?
      FormName="";
      index=_param2;
      if (index) {
         FormName=_param2.p_name;
         ptb=_tbFind2(FormName,linenum);
         ++linenum;
         if (_param1!="") {
            index.p_caption=_param1;
         }
         index.p_tool_window=true;
         index.p_CaptionClick=true;
         index.p_border_style=BDS_SIZABLE;
         index.p_eventtab2=find_index("_toolbar_etab2",EVENTTAB_TYPE);
         _set_object_modify(index);
      }
      if (!ptb) {
         linenum=def_toolbartab._length();
         ptb=&def_toolbartab[linenum];
         ++linenum;
         ptb->tbflags=TBFLAG_NEW_TOOLBAR;
         ptb->restore_docked=false;
         ptb->show_x=0;
         ptb->show_y=0;
         ptb->show_width=0;
         ptb->show_height=0;

         ptb->docked_bbside=0;
         ptb->docked_row=0;
         ptb->docked_x=0;
         ptb->docked_y=0;
         ptb->docked_width=0;
         ptb->docked_height=0;

         if (FormName=="") {
            for (i=1;;++i) {
               FormName=USER_FORM_PREFIX:+i;
               index=find_index(FormName,oi2type(OI_FORM));
               if (!index) break;
            }
            form_wid=_create_window(OI_FORM,orig_form_wid,"",0,0,2000,900,CW_PARENT|CW_HIDDEN,BDS_SIZABLE);
            form_wid.p_name=FormName;
            form_wid.p_caption=_param1;
            form_wid.p_tool_window=true;
            form_wid.p_CaptionClick=true;
            form_wid.p_eventtab2=find_index("_toolbar_etab2",EVENTTAB_TYPE);
            status=form_wid._update_template();
            form_wid._delete_window();
            _set_object_modify(status);
         }
      }
      ptb->FormName=FormName;
      tbflags=ptb->tbflags&~(TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED|TBFLAG_SIZEBARS);
      ptb->tbflags= tbflags|_param3;
      _config_modify|=CFGMODIFY_DEFVAR;
      p_window_id=orig_form_wid;
      list1._lbclear();
      list1.tbListBoxAddToolbars();
      list1.p_line=linenum;
      list1._lbselect_line();
      list1.call_event(CHANGE_SELECTED,list1,ON_CHANGE,'');
      ctlvisible.p_value=1;
      ctlvisible.call_event(ctlvisible,LBUTTON_UP);
   }
}
void ctlallowdocking.lbutton_up()
{
   caption=list1._lbget_text();
   _TOOLBAR *ptb;
   ptb=_tbFindCaption(caption,index);
   if (!ptb) return;
   if (p_value) {
      ptb->tbflags|=TBFLAG_ALLOW_DOCKING;
   } else {
      ptb->tbflags&=~TBFLAG_ALLOW_DOCKING;
   }
   _config_modify|=CFGMODIFY_DEFVAR;
}
void ctlontop.lbutton_up()
{
   caption=list1._lbget_text();
   _TOOLBAR *ptb;
   ptb=_tbFindCaption(caption,index);
   if (!ptb) return;
   if (p_value) {
      ptb->tbflags|=TBFLAG_ALWAYS_ON_TOP;
   } else {
      ptb->tbflags&=~TBFLAG_ALWAYS_ON_TOP;
   }
   _config_modify|=CFGMODIFY_DEFVAR;
   wid=_tbIsVisible(ptb->FormName);
   // Make form visible?
   if (wid && !wid.p_isbutton_bar) {
      tbClose(wid);
      _tbShow(ptb->FormName,0,0,0,0);
   }

}
void ctlvisible.lbutton_up()
{
   caption=list1._lbget_text();
   _TOOLBAR *ptb;
   ptb=_tbFindCaption(caption,index);
   if (!ptb) return;
   wid=_tbIsVisible(ptb->FormName);
   // Make form visible?
   if (p_value) {
      if (!wid) {
         wid=tbShow(ptb->FormName);
      }
   } else {
      if (wid) {
         tbClose(wid);
      }
   }
}
void list1.on_change(reason)
{
   if (reason==CHANGE_SELECTED) {
      item=_lbget_text();
      _TOOLBAR *ptb;
      ptb=_tbFindCaption(item,index);
      if (ptb) {
         // If this is a system dialog box
         ff=name_info(index);
         if (!isinteger(ff)) ff=0;
         enable=!(ff & FF_SYSTEM);
         ctldelete.p_enabled=ctlrename.p_enabled=enable;
         if (ptb->tbflags & TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED) {
            ctlreset.p_enabled=!enable;
         } else {
            ctlreset.p_enabled=0;
         }


         wid=_tbIsVisible(ptb->FormName);
         if (wid) {
            ctlvisible.p_value=(int)(wid && arg(2)=="");
         } else {
            ctlvisible.p_value=wid;
         }

         ctlontop.p_value=(ptb->tbflags & TBFLAG_ALWAYS_ON_TOP);
         ctlallowdocking.p_value=(ptb->tbflags & TBFLAG_ALLOW_DOCKING);
      } else {
         message("Tool bar not found?");
      }
   }
}
static int okToolbars()
{
   if (ORIGINAL_SHOWTOOLTIPS!=ctltooltips.p_value) {
      _default_option(VSOPTION_SHOWTOOLTIPS,ctltooltips.p_value);
      _config_modify|=CFGMODIFY_OPTION;
   }
   if (ORIGINAL_HIDE!=ctlhide.p_value) {
      def_hidetoolbars=ctlhide.p_value!=0;
      _config_modify|=CFGMODIFY_DEFVAR;
   }
   return( 0 );
}
static void tbListBoxAddToolbars()
{
   for (i=0;i<def_toolbartab._length();++i) {
      _TOOLBAR *ptb;
      ptb= &def_toolbartab[i];
      index=find_index(ptb->FormName,oi2type(OI_FORM));
      if (index) {
         _lbadd_item(index.p_caption);
      }
   }
}
static void oncreateToolbars()
{
   if (!(_default_option(VSOPTION_APIFLAGS) & VSAPIFLAG_TOOLBAR_DOCKING)) {
      ctlallowdocking.p_visible=false;
   }
   ctltooltips.p_value=(int)(_default_option(VSOPTION_SHOWTOOLTIPS)!=0);
   ORIGINAL_SHOWTOOLTIPS=ctltooltips.p_value;
   ctlhide.p_value=(int)def_hidetoolbars;
   ORIGINAL_HIDE=ctlhide.p_value;
   list1.tbListBoxAddToolbars();
   list1._lbtop();
   list1._lbselect_line();
   list1.call_event(CHANGE_SELECTED,list1,ON_CHANGE,'');
}

void ctlcatlist.on_change(reason)
{
   if (reason==CHANGE_SELECTED) {
      ShowControls( ctlcatlist.p_line - 1 );
   }

}
void ctlclose.lbutton_up()
{
   fid = p_active_form;
   result = fid.okToolbars();
   if (result) return;
   //_save_form_response();
   value = _toolbars_prop_sstab.p_ActiveTab;
   _append_retrieve( _toolbars_prop_sstab, value );
   fid._delete_window();
}
void ctlclose.on_create()
{
   tbNewVersion();
   //_retrieve_prev_form();
   _toolbars_prop_sstab._retrieve_value();
   fid = p_active_form;
   fid.oncreateToolbars();
   fid.InitCategories();
}
static void InitCategories()
{
   // Fill the category list and select the first category:
   int i;
   for ( i = 0; i < gToolbarCatTab._length(); i++ ) {
      ctlcatlist._lbadd_item( gToolbarCatTab[i].name );
   }
   //ctlcatlist.p_line = _bbe_cLastCategory + 1;
   ctlcatlist._lbtop();
   ctlcatlist._lbselect_line();
   ShowControls( ctlcatlist.p_line - 1 );
}
static void ShowControls( int cIndex )
{
   //ctldescription.p_caption="";
   firstChild = ctlpicture.p_child;
   child = firstChild;
   if (child) {
      for ( ;; ) {
         //messageNwait( "child="child" name="child.p_name );
         prevchild=child;
         child = child.p_next;
         if ( child.p_next==child ) {
            prevchild._delete_window();
            break;
         }
         prevchild._delete_window();
      }
   }


   cName = gToolbarCatTab[cIndex].name;
   NofControls = gToolbarCatTab[cIndex].CtrlList._length();
   ctlcontrols.p_caption = cName" Controls";
   frame_wid=_control ctlpicture;

   first_x=x=0;y=0;
   _lxy2lxy(SM_TWIP,SM_TWIP,x,y);

   client_width=_dx2lx(SM_TWIP,frame_wid.p_client_width);
   line_height=0;
   for ( i = 0; i < NofControls; ++i) {
      picname = gToolbarCatTab[cIndex].CtrlList[i].name;
      if ( substr(picname,1,1):=="\t") {
         SPECIALCONTROL *psc;
         picname=substr(picname,2);
         psc=&gtwSpecialControlTab:[picname];
         wid=_create_window(psc->object,frame_wid,"",0,0,0,0,CW_CHILD);
         wid.p_tab_index=i+1;
         if (psc->eventtab_name!="") {
            wid.p_eventtab=frame_wid.p_eventtab;
         }
         switch (psc->object) {
         case OI_IMAGE:
            wid.p_picture=find_index('bbfind.bmp',PICTURE_TYPE);
            wid.p_eventtab=defeventtab _toolbars_prop_form.ctlpicture;
            wid.p_eventtab2=defeventtab _ul2_picture;
            if (picname=='button') {
               wid.p_message=psc->description;
               wid.p_style=PSPIC_FLAT_BUTTON;
               wid.p_caption='Sample Button';
               width=wid.p_width;
               height=wid.p_height;
            } else {
               height=wid.p_height;
               width=psc->width;
               wid.p_picture=0;
               wid.p_message=picname;
               wid.p_border_style=BDS_FIXED_SINGLE;
            }
            break;
         case OI_COMBO_BOX:
            wid.p_name=picname;
            wid.p_width=psc->width;
            wid.p_eventtab=defeventtab _toolbars_prop_form.ctlpicture;
            wid.p_eventtab2=defeventtab _ul2_picture;
            wid.p_message=psc->description;
            //wid.p_eventtab=find_index(psc->eventtab,EVENTTAB_TYPE);
            //wid.p_eventtab2=defeventtab _ul2_combobx;
            width=wid.p_width;
            height=wid.p_height;
            break;
         default:
            _message_box("Internal bug.  Control not supported");
            width=0;
            height=0;
         }
      } else {
         wid=_create_window(OI_IMAGE,frame_wid,"",0,0,0,0,CW_HIDDEN|CW_CHILD);
         wid.p_tab_index=i+1;
         picindex = find_index( strip_filename( picname,'p' ), PICTURE_TYPE );
         if ( !picindex ) continue;
         wid.p_picture=picindex;
         wid.p_command = gToolbarCatTab[cIndex].CtrlList[i].command;
         wid.p_message=gToolbarCatTab[cIndex].CtrlList[i].msg;;
         wid.p_style=PSPIC_FLAT_BUTTON;
         wid.p_Nofstates=2;
         wid.p_eventtab=defeventtab _toolbars_prop_form.ctlpicture;
         wid.p_eventtab2=defeventtab _ul2_picture;
         width=wid.p_width;
         height=wid.p_height;
      }
      if (x+width>client_width) {
         x=first_x;
         y+=line_height;
      }
      wid._move_window(x,y,width,height);
      wid.p_visible=1;
      //messageNwait("w="client_width" width="width" height="height" line_height="line_height);
      if (height>line_height) {
         line_height=height;
      }
      x+=width;
   }
}
#define DRAGDROP_MODE_FORM_STR "_toolbars_prop_form"
#define DRAGDROP_MODE_FORM      _toolbars_prop_form
boolean _tbInDragDropMode()
{
   if (!_find_object(DRAGDROP_MODE_FORM_STR,"n")) {
      return(0);
   }
   _TOOLBAR *ptb;
   ptb=_tbFind(p_parent.p_name);
   if (!ptb || !(ptb->tbflags && TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED)) {
      return(0);
   }
   return(1);
}
void _tbDragDrop()
{
   call_event(defeventtab DRAGDROP_MODE_FORM.ctlpicture,LBUTTON_DOWN,'e');
}
void ctlpicture.lbutton_down()
{
   if (p_active_form.p_name==DRAGDROP_MODE_FORM_STR && p_name=='ctlpicture') {
      return;
   }
   DraggingFromToolbar=false;
   if (p_parent.p_object==OI_FORM && _tbFind(p_parent.p_name)) {
      DraggingFromToolbar=true;
   }
   //say("DraggingFromToolbar="DraggingFromToolbar);
   new_bbside=0;
   selected_wid=orig_wid=p_window_id
   p_window_id=_desktop;

   DragOption="D";
   p_fill_style=PSFS_TRANSPARENT;
   p_draw_width=0;
   p_draw_style=PSDS_INSIDE_SOLID;p_draw_mode=PSDM_XORPEN;
   color=_rgb(0xff,0xff,0xff);

   mou_mode(1);
   selected_wid.mou_capture();
   _KillToolTipMessages();

   old_mouse_pointer=selected_wid.p_mouse_pointer;
   doCopy=_IsKeyDown(CTRL);

   /*mp=MP_LEFTARROW;
   mou_set_pointer(mp);selected_wid.p_mouse_pointer=mp;*/

   mx=selected_wid.mou_last_x()+_lx2dx(selected_wid.p_xyscale_mode,selected_wid._left_width());
   my=selected_wid.mou_last_y()+_ly2dy(selected_wid.p_xyscale_mode,selected_wid._top_height());
   rectangle_drawn=0;
   //morig_x=mou_last_x('M');morig_y=mou_last_y('M');rectangle_drawn=0;
   done=0;
   selected_wid._get_window(orig_x,orig_y,orig_width,orig_height);
   _lxy2dxy(selected_wid.p_xyscale_mode,orig_x,orig_y);
   _lxy2dxy(selected_wid.p_xyscale_mode,orig_width,orig_height);
   _map_xy(selected_wid.p_xyparent,0,orig_x,orig_y,SM_PIXEL);
   x1=orig_x;y1=orig_y;x2=x1+orig_width;y2=y1+orig_height;
   orig_x1=x1;orig_y1=y1;orig_x2=x2;orig_y2=y2;
   event=MOUSE_MOVE;
   for (;;) {
      switch (event) {
      case MOUSE_MOVE:
         toolbar_wid= 0;
         prev_bbside=new_bbside;
         x=mou_last_x();y=mou_last_y();
         new_x1=x-mx;
         new_y1=y-my;
         new_x2=new_x1+(x2-x1);
         new_y2=new_y1+(y2-y1);

         new_bbside=0;
         // Check if we are dragging this control onto a floating
         // tool bar.  For now, we assume tool bar is on top of
         // MDI frame.
         {
            for (j=0;j<def_toolbartab._length();++j) {
               wid=_find_object(def_toolbartab[j].FormName,'n');
               if (wid) {
                  wid._get_window(sx1,sy1,swidth,sheight);
                  _lxy2dxy(wid.p_xyscale_mode,sx1,sy1);
                  _lxy2dxy(wid.p_xyscale_mode,swidth,sheight);
                  _map_xy(wid.p_xyparent,0,sx1,sy1,SM_PIXEL);
                  sy2=sy1+sheight;
                  sx2=sx1+swidth;
               }
               if (wid && !wid.p_isbutton_bar &&
                   (def_toolbartab[j].tbflags & TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED) &&
                   new_x1<sx2 && new_x2>sx1 &&
                   new_y1<sy2 && new_y2>sy1
                   ) {
                  toolbar_wid=wid;
                  _tbFindDropPosition(toolbar_wid,tab_index,
                                      new_x1,new_y1,new_x2,new_y2
                                      );
                  break;
               }
            }
         }
         if (!toolbar_wid) {
            if (prev_bbside) {
               i=prev_bbside;
            } else {
               i=1;
            }
            for (;;) {
               // IF there are some button bars on this side,
               wid=_mdi._GetButtonBar(i);
               if (wid) {
                  wid._get_window(sx1,sy1,swidth,sheight);
                  _lxy2dxy(wid.p_xyscale_mode,sx1,sy1);
                  _lxy2dxy(wid.p_xyscale_mode,swidth,sheight);
                  _map_xy(wid.p_xyparent,0,sx1,sy1,SM_PIXEL);
                  sy2=sy1+sheight;
                  sx2=sx1+swidth;
                  // If this rectangle intersects this side.
                  if (
                      new_x1<sx2 && new_x2>sx1 &&
                      new_y1<sy2 && new_y2>sy1
                      ) {
                     newbbside=i;
                     if (i==BBSIDE_TOP || i==BBSIDE_BOTTOM) {
                        _mdi._tbInsertControlPositionTB(newbbside,
                                                            sy1,
                                                            new_x1,new_y1,new_x2,new_y2,
                                                            toolbar_wid,
                                                            tab_index
                                                            );
                     } else {
                        _mdi._tbInsertControlPositionLR(newbbside,
                                                            sy1,
                                                            new_x1,new_y1,new_x2,new_y2,
                                                            toolbar_wid,
                                                            tab_index
                                                            );
                     }
                  }
               }
               ++i;
               if (prev_bbside) {
                  if (i>4) {
                     i=1;
                  }
                  if (i==prev_bbside) {
                     break;
                  }
               } else {
                  if (i>4) {
                     break;
                  }
               }
            }
         }

         if (toolbar_wid>0) {
            mp=(doCopy && DraggingFromToolbar)?MP_ALLOWCOPY:MP_ALLOWDROP;
         } else {
            mp=MP_NODROP; //LEFTARROW;
         }
         if (selected_wid.p_mouse_pointer!=mp) {
            mou_set_pointer(mp);selected_wid.p_mouse_pointer=mp;
         }
         if (rectangle_drawn) {
            if (x1==new_x1 && y1==new_y1 && x2==new_x2 && y2==new_y2) {
               break;
            }
            /* Erase the rectangle. */
            //p_draw_width=draw_width;
            _draw_rect(x1,y1,x2,y2,color,DragOption);
         }
         rectangle_drawn=1
         x1=new_x1;y1=new_y1;x2=new_x2;y2=new_y2;
         //message("y1="y1);
         //p_draw_width=new_draw_width;
         _draw_rect(x1,y1,x2,y2,color,DragOption);
         //draw_width=new_draw_width;
         //DragOption=NewDragOption;
         break;
      case ON_KEYSTATECHANGE:
         doCopy=_IsKeyDown(CTRL);
         event=MOUSE_MOVE;
         continue;
      case LBUTTON_UP:
      case ESC:
         done=1
      }
      if( done) break;
      event=get_event();
   }
   mou_mode(0)
   mou_release();
   selected_wid.p_mouse_pointer=old_mouse_pointer;
   if (rectangle_drawn) {
      /* Erase the rectangle. */
      //p_draw_width=draw_width;
      _draw_rect(x1,y1,x2,y2,color,DragOption);
      if (event!=ESC) {
         if (toolbar_wid>0) {
            // Insert the new control
            _tbAdjustTabIndexes(toolbar_wid,tab_index,1);
            wid=_create_window(selected_wid.p_object,
                           toolbar_wid,"",0,0,0,0,CW_HIDDEN|CW_CHILD,BDS_NONE /*selected_wid.p_border_style*/);
            wid.p_tab_index=tab_index;
            wid.p_width=selected_wid.p_width;
            wid.p_height=selected_wid.p_height;
            wid.p_name=selected_wid.p_name;
            switch (selected_wid.p_object) {
            case OI_IMAGE:
               wid.p_caption=selected_wid.p_caption;
               wid.p_picture=selected_wid.p_picture;
               if (wid.p_caption=="" && !wid.p_picture) {
                  wid.p_visible=1;
               }
               wid.p_command =selected_wid.p_command;
               wid.p_message=selected_wid.p_message;
               wid.p_style=selected_wid.p_style;
               wid.p_Nofstates=selected_wid.p_Nofstates;
               wid.p_eventtab=0;
               wid.p_eventtab2=defeventtab _ul2_picture;
               break;
            case OI_COMBO_BOX:
               SPECIALCONTROL *psc;
               psc=gtwSpecialControlTab._indexin(selected_wid.p_name);
               if (psc) {
                  wid.p_eventtab=find_index(psc->eventtab_name,EVENTTAB_TYPE);
                  wid.p_eventtab2=find_index(psc->eventtab2_name,EVENTTAB_TYPE);
               }
            }

            // If we are not inserting into the same toolbar
            //    we just deleted from
            if (doCopy || toolbar_wid!=selected_wid.p_parent) {
               //wid.p_visible=true;
               status=toolbar_wid._update_template();
               //set_name_info(status,FF_SYSTEM);
               _set_object_modify(status);
               _tbRedisplay(toolbar_wid);
            }
         }
         // If we are dragging this control from a toolbar
         if (DraggingFromToolbar && !doCopy) {
            toolbar_wid=selected_wid.p_parent;
            _tbAdjustTabIndexes(toolbar_wid,selected_wid.p_tab_index,-1);
            selected_wid._delete_window();
            status=toolbar_wid._update_template();
            //set_name_info(status,FF_SYSTEM);
            _set_object_modify(status);
            _tbRedisplay(toolbar_wid);
         }
      }
   }
   if (_iswindow_valid(orig_wid)) {
      p_window_id=orig_wid;
   }
   wid=_get_focus();
   if (wid && wid.p_isbutton_bar) {
      if (_mdi._no_child_windows()) {
         _cmdline._set_focus();
      } else {
         _mdi.p_child._set_focus();
      }
   }

}
void _tbInsertControlPositionTB(
                       int bbside,int bbside_y1,
                       int x1,int y1,int x2,int y2,
                       int &toolbar_wid,
                       int &tab_index /* 1 means insert before first*/)
{
   toolbar_wid= 0;
   tab_index=0;

   // Determine which row rect will go in
   middle=(y1+y2) intdiv 2;
   RowStart=0;
   next_y=bbside_y1;
   last_wid=0;
   line_height=0;
   for (i=0;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         next_y+=line_height;
         break;
      }
      if (!last_wid) {
         RowStart=i;
         next_y+=line_height;
         line_height=_ly2dy(SM_TWIP,_bbdockRowHeight(bbside,i));
         if (middle<next_y+line_height) {
            break;
         }
      }
      wid=gbbdockinfo[bbside][i].wid;
      last_wid=wid;
   }
   // The row this will go in is RowStart
   for (i=RowStart;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         break;
      }
      wid=gbbdockinfo[bbside][i].wid;
      if (wid>0 && (gbbdockinfo[bbside][i].tbflags & TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED)) {

         wid._get_window(sx1,sy1,swidth,sheight);
         _lxy2dxy(wid.p_xyscale_mode,sx1,sy1);
         _lxy2dxy(wid.p_xyscale_mode,swidth,sheight);
         _map_xy(wid.p_xyparent,0,sx1,sy1,SM_PIXEL);
         sy2=sy1+sheight;
         sx2=sx1+swidth;
         // IF left side of rect of this rect inside this toolbar OR
         //    right side of rect of this rect inside this toolbar
         if ((x1>=sx1&& x1<sx2)||
             (x2>sx1&& x2<sx2)) {
            toolbar_wid=wid;
            // Now determine where in this tool bar to insert this control
            first_child=child=wid.p_child;
            tab_index=1;
            if (child) {
               for(; ;++tab_index) {
                  child._get_window(sx1,sy1,swidth,sheight);
                  _lxy2dxy(child.p_xyscale_mode,sx1,sy1);
                  _lxy2dxy(child.p_xyscale_mode,swidth,sheight);
                  _map_xy(child.p_xyparent,0,sx1,sy1,SM_PIXEL);
                  sy2=sy1+sheight;
                  sx2=sx1+swidth;
                  // IF left side of rect to left of this control
                  if (x1<=sx1) {
                     break;
                  }
                  // IF left side of rect inside this control
                  if (x1>=sx1&& x1<sx2) {
                     // Insert after last child
                     ++tab_index;
                     break;
                  }
                  // IF right side of rect of this rect inside this toolbar
                  if ((x2>sx1&& x2<sx2)) {
                     // Insert after last child
                     ++tab_index;
                     break;
                  }
                  child=child.p_next
                  if (child==first_child) {
                     // Insert after last child
                     ++tab_index;
                     break;
                  }

               }
            }
            break;

         }
      }
   }
   //say("toolbar_wid="toolbar_wid" tab_index="tab_index);
}
void _tbInsertControlPositionLR(
                       int bbside,int bbside_x1,
                       int x1,int y1,int x2,int y2,
                       int &toolbar_wid,
                       int &tab_index /* 1 means insert before first*/)
{
   toolbar_wid= 0;
   tab_index=0;

   // Determine which row rect will go in
   middle=(x1+x2) intdiv 2;
   RowStart=0;
   next_x=bbside_x1;
   last_wid=0;
   line_width=0;
   for (i=0;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         next_x+=line_width;
         break;
      }
      if (!last_wid) {
         RowStart=i;
         next_x+=line_width;
         line_width=_lx2dx(SM_TWIP,_bbdockRowWidth(bbside,i));
         if (middle<next_x+line_width) {
            break;
         }
      }
      wid=gbbdockinfo[bbside][i].wid;
      last_wid=wid;
   }
   // The row this will go in is RowStart
   for (i=RowStart;;++i) {
      if (i>=gbbdockinfo[bbside]._length()) {
         break;
      }
      wid=gbbdockinfo[bbside][i].wid;
      if (wid>0 && (gbbdockinfo[bbside][i].tbflags & TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED)) {

         wid._get_window(sx1,sy1,swidth,sheight);
         _lxy2dxy(wid.p_xyscale_mode,sx1,sy1);
         _lxy2dxy(wid.p_xyscale_mode,swidth,sheight);
         _map_xy(wid.p_xyparent,0,sx1,sy1,SM_PIXEL);
         sy2=sy1+sheight;
         sx2=sx1+swidth;
         // IF left side of rect of this rect inside this toolbar OR
         //    right side of rect of this rect inside this toolbar
         if ((y1>=sy1&& y1<sy2)||
             (y2>sy1&& y2<sy2)) {
            toolbar_wid=wid;
            // Now determine where in this tool bar to insert this control
            first_child=child=wid.p_child;
            tab_index=1;
            if (child) {
               for(; ;++tab_index) {
                  child._get_window(sx1,sy1,swidth,sheight);
                  _lxy2dxy(child.p_xyscale_mode,sx1,sy1);
                  _lxy2dxy(child.p_xyscale_mode,swidth,sheight);
                  _map_xy(child.p_xyparent,0,sx1,sy1,SM_PIXEL);
                  sy2=sy1+sheight;
                  sx2=sx1+swidth;
                  // IF left side of rect to left of this control
                  if (y1<=sy1) {
                     break;
                  }
                  // IF left side of rect inside this control
                  if (y1>=sy1&& y1<sy2) {
                     // Insert after last child
                     ++tab_index;
                     break;
                  }
                  // IF right side of rect of this rect inside this toolbar
                  if ((y2>sy1&& y2<sy2)) {
                     // Insert after last child
                     ++tab_index;
                     break;
                  }
                  child=child.p_next
                  if (child==first_child) {
                     // Insert after last child
                     ++tab_index;
                     break;
                  }

               }
            }
            break;

         }
      }
   }
   //say("toolbar_wid="toolbar_wid" tab_index="tab_index);
}
static void _tbFindDropPosition(int &toolbar_wid,int &tab_index,
                                int x1,int y1,int x2,int y2
                                )
{
   first_child=child=toolbar_wid.p_child;
   if (!child) {
      tab_index=1;
      //toolbar_wid=0;
      return;
   }
   middle_y=(y1+y2) intdiv 2;
   tab_index=1;
   FoundOne=false;
   for(; ;++tab_index) {
      child._get_window(sx1,sy1,swidth,sheight);
      _lxy2dxy(child.p_xyscale_mode,sx1,sy1);
      _lxy2dxy(child.p_xyscale_mode,swidth,sheight);
      _map_xy(child.p_xyparent,0,sx1,sy1,SM_PIXEL);
      sy2=sy1+sheight;
      sx2=sx1+swidth;
      if (middle_y>=sy1 && middle_y<=sy2) {
         // IF left side of rect to left of this control
         if (x1<=sx1) {
            FoundOne=true;
            break;
         }
         // IF left side of rect inside this control
         if (x1>=sx1&& x1<sx2) {
            FoundOne=true;
            // Insert after last child
            ++tab_index;
            break;
         }
         // IF right side of rect of this rect inside this toolbar
         if ((x2>sx1&& x2<sx2)) {
            FoundOne=true;
            // Insert after last child
            ++tab_index;
            break;
         }
         child=child.p_next
         if (child==first_child) {
            FoundOne=true;
            // Insert after last child
            ++tab_index;
            break;
         }
      } else {
         child=child.p_next
         if (child==first_child) {
            break;
         }
      }
   }
   if (!FoundOne) {
      toolbar_wid=0;
   }
   //say("floating toolbar_wid "toolbar_wid" tab_index="tab_index);
}
void _tbAdjustTabIndexes(int toolbar_wid,int tab_index,int adjust)
{
   first_child=child=toolbar_wid.p_child;
   if (child) {
      // Adjust tab indexes
      for (;;) {
         if (child.p_tab_index>=tab_index) {
            child.p_tab_index+=adjust;
         }
         child=child.p_next;
         if(child==first_child) break;
      }
   }
}
void _tbRedisplay(int toolbar_wid)
{
   FormName=toolbar_wid.p_name;
   if (toolbar_wid.p_isbutton_bar) {
      bbside_wid=_mdi._GetButtonBar(toolbar_wid.p_isbutton_bar);
      if(_bbdockFindWid(toolbar_wid,bbside,i)) {
         toolbar_wid.p_visible=false;toolbar_wid._delete_window();
         tbflags=gbbdockinfo[bbside][i].tbflags;


         resource_index=find_index(FormName,oi2type(OI_FORM));
         /*if (tbflags &TBFLAG_SIZEBARS) {
            NoBorder="N";
         }*/
         wid=_tbLoadTemplate(tbflags,resource_index,bbside_wid);

         gbbdockinfo[bbside][i].wid=wid;

         _mdi._bbdockRefresh(bbside);
      }
   } else {
      toolbar_wid._delete_window();
      // Correct the parent
      _tbShow(FormName,0,0,0,0);
   }
}
boolean _tbIsCustomizeableToolbar(int index)
{
   if (!def_localsta) {
      return(0);
   }
   name=name_name(index);
   if (substr(name,1,3)!='-tb') {
      return(0);
   }
   name=translate(name,'_','-');
   for (i=0;i<init_toolbartab._length();++i) {
      if (init_toolbartab[i].FormName==name &&
          (init_toolbartab[i].tbflags & TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED)) {
         return(1);
      }
   }
   return(0);
}
static void activate_output_tab(_str find_this_caption,_str find_this_control)
{

   toolbar='_tboutput_form';
   wid=_find_object(toolbar,'n');
   if (!wid) {
      dock('output');
   }
   _nocheck _control _output_sstab;

   wid=_GetTagwinWID();
   if( wid ) {
      tabid=wid._output_sstab;
      for( i=0;i<tabid.p_NofTabs;++i ) {
         text=tabid._getTabInfo(i);
         parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
         caption = stranslate(extractCaption(theRest),'','&');
         if( caption==find_this_caption ) {
            tabid.p_ActiveTab=i;

            p_window_id=tabid;
            ctlwid=wid._find_control(find_this_control);
            if( ctlwid ) ctlwid._set_focus();
         }
      }
   }
}

_command activate_search()  name_info(','VSARG2_EDITORCTL)
{
   activate_output_tab('Search','list1');
}

_command activate_symbol()  name_info(','VSARG2_EDITORCTL)
{
   activate_output_tab('Symbol','edit1');
}

_command activate_build()  name_info(','VSARG2_EDITORCTL)
{
   activate_output_tab('Build','_shellEditor');
}

_command void dock(...)  name_info(','VSARG2_EDITORCTL)
{
   tbNewVersion();
   focus_wid=_get_focus();
   ToolbarCaption=lowcase(arg(1));
   side=arg(2);

   index=0;
   _TOOLBAR *ptb;
   for (i=0;i<def_toolbartab._length();++i) {
      ptb= &def_toolbartab[i];
      index=find_index(ptb->FormName,oi2type(OI_FORM));
      if (index) {
         if (!stricmp(index.p_caption,ToolbarCaption)) {
            break;
         }
      }
   }
   if (!index) {
      _message_box('Toolbar 'ToolbarCaption' not found');
      return;
   }
   toolbar=index.p_name;

   wid=_find_object(toolbar,'n');
   if (wid) {
      if (!wid.p_isbutton_bar) {
         wid._delete_window();
      } else {
         if (wid.p_isbutton_bar) {
            _message_box("This toolbar is already visible");
            return;
         }
      }
   }
   if (!isinteger(side)) {
      if (toolbar:=='_tbproject_form') {
         side=BBSIDE_LEFT;
      } else if (toolbar=='_tboutput_form') {
         side=BBSIDE_BOTTOM;
      } else {
         side=BBSIDE_TOP;
      }
   }
   _mdi._bbdockInsert(side,-1,0,0,index,ptb->tbflags,0);
   _mdi._bbdockRefresh(side);
   if (focus_wid && _iswindow_valid(focus_wid)) {
      focus_wid._set_focus();
   }
}
_command void hide(...)  name_info(','VSARG2_EDITORCTL)
{
   focus_wid=_get_focus();
   ToolbarCaption=lowcase(arg(1));
   index=0;
   for (i=0;i<def_toolbartab._length();++i) {
      _TOOLBAR *ptb;
      ptb= &def_toolbartab[i];
      index=find_index(ptb->FormName,oi2type(OI_FORM));
      if (index) {
         if (!stricmp(index.p_caption,ToolbarCaption)) {
            break;
         }
      }
   }
   if (!index) {
      _message_box('Toolbar 'ToolbarCaption' not found');
      return;
   }
   toolbar=index.p_name;
   wid=_find_object(toolbar,'n');
   if (!wid) {
      _message_box("This toolbar is visible");
      return;
   }
   tbClose(wid);
   if (focus_wid && _iswindow_valid(focus_wid)) {
      focus_wid._set_focus();
   }
}
static int tbToggleToolbar(_str ToolbarCaption,...)
{

   _TOOLBAR *ptb;
   ptb=_tbFindCaption(ToolbarCaption,index);
   if (!ptb) return(1);
   wid=_find_object(index.p_name,"n");
   if (!wid) {
      tbShow(index.p_name);
      return(0);
   }
   hide(ToolbarCaption);
   return(0);
}

_command void toggle_ftp()  name_info(','VSARG2_EDITORCTL)
{
   tbToggleToolbar('FTP Client');
}

_command void toggle_stack()  name_info(','VSARG2_EDITORCTL)
{
   tbToggleToolbar('Slick-C Stack');
}

_command void toggle_properties()  name_info(','VSARG2_EDITORCTL)
{
   tbToggleToolbar('Tag Properties');
}
_command void toggle_output()  name_info(','VSARG2_EDITORCTL)
{
   tbToggleToolbar('output');
}

_command void toggle_project() name_info(','VSARG2_EDITORCTL)
{
   tbToggleToolbar('project');
}
_command void toggle_standard() name_info(','VSARG2_EDITORCTL)
{
   tbToggleToolbar('standard');
}
static void tbNewVersion()
{
   boolean FormName_hashtab:[];
   for (i=0;i<def_toolbartab._length();++i) {
      // IF we have multiple occurrences of the same toolbar
      if (FormName_hashtab._indexin(def_toolbartab[i].FormName)) {
         def_toolbartab._deleteel(i);
         continue;
      }
      FormName_hashtab:[def_toolbartab[i].FormName]=true;
      if (!isinteger(def_toolbartab[i].restore_docked)) {
         //say('fixed it i='i);
         def_toolbartab[i].restore_docked=false;
         def_toolbartab[i].show_x=0;
         def_toolbartab[i].show_y=0;
         def_toolbartab[i].show_width=0;
         def_toolbartab[i].show_height=0;

         def_toolbartab[i].docked_bbside=0;
         def_toolbartab[i].docked_row=0;
         def_toolbartab[i].docked_x=0;
         def_toolbartab[i].docked_y=0;
         def_toolbartab[i].docked_width=0;
         def_toolbartab[i].docked_height=0;
      }
   }
   // Make sure all available toolbars are in the users
   // list of toolbars
   for (i=0;i<init_toolbartab._length();++i) {
      if (!FormName_hashtab._indexin(init_toolbartab[i].FormName)) {
         def_toolbartab[def_toolbartab._length()]=init_toolbartab[i];
      }
   }
}
/*
 *Function Name:  activate_project_tab
 *
 *Parameters:     find_this_caption:  The tab to set focus on
 *                find_this_control:  The Treeview to set focus on
 *
 *Description:    Activate_project_tab sets focus on the tab listed and
 *                sets focus on the treeview indicated.  If the project
 *                toolbar is not active, it is opened and docked.
 *
 *Author:         Dan Henry, Rodney Bloom
 *
 *Returns:        None
 *
 */

static void activate_project_tab(_str find_this_caption,_str find_this_control)
{

   toolbar='_tbproject_form';
   wid=_find_object(toolbar,'n');
   if (!wid) {
      dock('project');
   }
   _nocheck _control _output_sstab;

   wid=_find_formobj(toolbar,'N');
   if( wid ) {
      _nocheck _control _proj_toolbar_sstab;
      tabid=wid._proj_toolbar_sstab;
      for( i=0;i<tabid.p_NofTabs;++i ) {
         text=tabid._getTabInfo(i);
         parse text with enabled order pic partialCaption x1 y1 x2 y2 fa minW maxW theRest;
         caption = stranslate(extractCaption(theRest),'','&');
         //say('caption='caption ' find_this_caption='find_this_caption);
         if( caption==find_this_caption ) {
            tabid.p_ActiveTab=i;

            p_window_id=tabid;
            ctlwid=wid._find_control(find_this_control);
            if( ctlwid ){
                ctlwid._set_focus();
            }
         }
      }
   }
}

_command activate_project_files()  name_info(','VSARG2_EDITORCTL)
{
   activate_project_tab('Files','_proj_tooltab_tree');
}
_command activate_project_procs()  name_info(','VSARG2_EDITORCTL)
{
   activate_project_tab('Procs','_proc_tree');
}
_command activate_project_classes()  name_info(','VSARG2_EDITORCTL)
{
   activate_project_tab('Classes','ctl_class_tree_view');
}
_command activate_project_open()  name_info(','VSARG2_EDITORCTL)
{
   activate_project_tab('Open','_openfile_list');
}
void _tbSetToolbarEnable(int wid,CMDUI &cmdui=null)
{
   get_view_id(orig_view_id);
   if (_no_child_windows()) {
      target_wid=0;
   } else {
      target_wid=_mdi.p_child;
   }
   if (cmdui._isempty()) {
      cmdui.menu_handle=0;
      cmdui.button_wid=1;

      _OnUpdateInit(cmdui,target_wid);
   }
   //say('found 'wid.p_name);
   first_child=child=wid.p_child;
   if (child) {
      for (;;) {
         if (child.p_object==OI_IMAGE &&
             (child.p_caption!="" ||child.p_picture)) {
            cmdui.button_wid=child;
            //say('got here target_wid='target_wid);
            mfflags=_OnUpdate(cmdui,target_wid,child.p_command);
            if (mfflags) {
               if (mfflags & MF_GRAYED) {
                  value=false;
               } else {
                  value=true;
               }
               if (child.p_enabled!=value) {
                  child.p_enabled=value;
                  //_tbSetRefreshBy(0);
                  //return;
               }
            }
            /*if (child.p_caption!="") {
               say("child.p_enabled="child.p_enabled);
            }  */
         }
         child=child.p_next;
         if (child==first_child) break;
      }
      // Update image controls
      //wid.refresh('w');
   }
   activate_view(orig_view_id);
}
void _tbOnUpdate()
{
   if (_idle_time_elapsed()<50 /*100*/ || !_tbQRefreshBy()) {
      return;
   }
   /*
        _tbQRefreshBy and the VSTBREFRESHBY_??? constants
        for debugging a problem where _tbOnUpdate does
        processing where no processing should be necessary.

        The undo, redo, and switching buffers cause _tbOnUpdate
        processing on every key stroke.  There are other commands
        where processing is required but they are more obvious
        and less important.

        The idle time check correct performance problems
        where a particular keystroke cause _tbOnUpdate
        processing.
   */
   //say('RefreshBy='_tbQRefreshBy());
   boolean hashtab:[];
   for (i=0;i<def_toolbartab._length();++i) {
      if (def_toolbartab[i].tbflags & TBFLAG_ALLOW_CONTROLS_TO_BE_ADDED) {
         hashtab:[def_toolbartab[i].FormName]=true;
      }
   }
   CMDUI cmdui;
   cmdui.menu_handle=0;
   if (_no_child_windows()) {
      target_wid=0;
   } else {
      target_wid=_mdi.p_child;
   }
   cmdui.button_wid=1;

   _OnUpdateInit(cmdui,target_wid);
   for (wid=1;wid<=_last_window_id();++wid) {
      if (_iswindow_valid(wid)) {
         if (wid.p_object==OI_FORM &&
             hashtab._indexin(wid.p_name)
             ) {
            _tbSetToolbarEnable(wid,cmdui);
         }
      }
   }
   _tbSetRefreshBy(0);
}
