/*
$VerboseHistory: util.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:20a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:20a
 * Comment:
 * Change message box to display question mark icon.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:36p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'
/* This module contains commands of procedures that are not used */
/* frequently. */
_command void scroll_up() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   old_scroll=_scroll_style();
   _scroll_style('S 0');
  cursor_y= p_cursor_y;
  left_edge= p_left_edge;
  old_updown_col=def_updown_col;def_updown_col=0;
  cursor_up();
  def_updown_col=old_updown_col;
  set_scroll_pos(left_edge,cursor_y);
#if 0
  if ( cursor_y>p_cursor_y ) {
     down();
  }
#endif
   _scroll_style(old_scroll);


}
_command void scroll_down() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   old_scroll=_scroll_style();
   _scroll_style('S 0');
  cursor_y= p_cursor_y;
  left_edge= p_left_edge;
  last=last_index('','C');
  old_updown_col=def_updown_col;def_updown_col=0;
  cursor_down();
  def_updown_col=old_updown_col;
  last_index(last,'C');
  if ( rc==BOTTOM_OF_FILE_RC ) {
     cursor_y=cursor_y-1;
  }
  set_scroll_pos(left_edge,cursor_y);
   _scroll_style(old_scroll);

}
_command void scroll_left() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   old_scroll=_scroll_style();
   _scroll_style('S 0');
   if ( p_left_edge>0 ) {
      old_left_edge=p_left_edge;old_cursor_x=p_cursor_x;
      p_cursor_x=p_windent_x;
      if (p_left_edge==old_left_edge) {
         p_col=p_col-1;
         _refresh_scroll2('s');
      }
      p_cursor_x=old_cursor_x;
   } else {
      left();
   }
   _scroll_style(old_scroll);
}
_refresh_scroll2(style)
{
   old_style=_scroll_style();
   _scroll_style(style);
   _refresh_scroll();
   _scroll_style(old_style);
}
_command void scroll_right() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   old_scroll=_scroll_style();
   _scroll_style('S 0');
   old_left_edge=p_left_edge;old_cursor_x=p_cursor_x;
   col=mou_col(p_client_width);
   if (p_fixed_font) {
      p_col=col-1;
      while (p_left_edge==old_left_edge) {
         p_col=p_col+1;
      }
   } else {
      p_col=col;
      if (p_left_edge==old_left_edge) {
         p_col=p_col+1;
         _refresh_scroll2('s');
      }
   }
   p_cursor_x=old_cursor_x;
   _scroll_style(old_scroll);
}
_command void center_line() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
	if (_argument !='') {
		set_scroll_pos(p_left_edge,(p_client_height intdiv p_char_height)*_argument);
		_argument='';		//so argument won't call it again
	} else {
		set_scroll_pos(p_left_edge,p_client_height intdiv 2);
	}
}
_command sort_buffer(...) name_info(','VSARG2_REQUIRES_EDITORCTL)
{
   if ( _process_info('B') ) {
      message nls("You can't mean this");
      return(1);
   }
   mark=_alloc_selection();
   if ( mark>=0 ) {
     bottom;_select_line(mark);
     top;_select_line(mark);
     status=_sort_selection(arg(1),mark);
     if ( status ) {
        _free_selection(mark);
        return(status);
     }
     _delete_selection(mark);
     _free_selection(mark);
     return(status);
   }
   return(mark);
}
_command sort_on_selection(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)
{
   was_in_current_buffer=select_active();
   _sort_selection(arg(1));
   if ( rc ) {
      return(rc);
   }
   if (!was_in_current_buffer) {
      return(0);
   }
   if ( _select_type()=='BLOCK' ) {
      mark=_alloc_selection();
      if ( mark<0 ) return(mark);
      _begin_select();_select_line(mark);_end_select();_select_line(mark);
      _delete_selection(mark);
      status=rc;
      _free_selection(mark);
      return(status);
   } else {
      if (_select_type()=='CHAR') {
         _select_type('','t','line');
      }
      _delete_selection();
      return(rc);
   }

}
_command sort_within_selection(...) name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)
{
   if ( _select_type()!='BLOCK' ) {
      return(sort_on_selection(arg(1)));    /* Handle char mark,line mark, or null mark */
   }
   mark=_alloc_selection();
   if ( mark<0 ) { return(mark) }
   load_files('+c +v');   /* Copy the users current position. */
   if ( rc ) { return(rc) }
   get_view_id(view_id);
   load_files('+c +t');   /* start a temp file. Only need one view. */
   if ( rc ) {
      _free_selection(mark);
      _quit_view();
      return(rc);
   }
   _delete_line(); /* remove first line of temp file. */
   _sort_selection(arg(1));
   status=rc;
   if ( status ) {
      /* Quit temp file and copy of user position. */
      _delete_buffer();_quit_view();_quit_view();
      _free_selection(mark);
      message(get_message(status));
      return(status);
   }
   _get_selinfo(first_col,last_col,junk);
   top;p_col=first_col;_select_block(mark);bottom;p_col=last_col;_select_block(mark);
   _prev_view();_begin_select();   /* Back to a view with the mark in it. */
   _overlay_block_selection(mark);
   status=rc;
   activate_view(view_id);             /* Now at copy of user position. */
   _next_view();
   _delete_buffer();_quit_view();_quit_view();
   _free_selection(mark);
   if ( status ) {
      message get_message(status);
   }
   return(status)

}
_command asc()
{
  if ( arg(1)=='' ) {
    ch= substr(get_text(),1,1);
  } else {
    parse arg(1) with ch '=';
    if ( ch=='' ) { ch='='; }
  }
  if ( length(ch)>1 ) {
    message(nls('Character must be of length 1'));
    return(1)
  }
  msg='asc 'ch'='_asc(ch);
  msg=translate(msg,' ',_chr(0));
  //_cmdline.set_command(msg);_cmdline._set_focus();
  sticky_message(msg);
}
_command void chr()
{
  if ( arg(1)=='' ) {
    _message_box(nls('Specify an ascii code number'));
    return;
  }
  parse arg(1) with number '=';
  if ( eval_exp(result,number,'') ) {
     return;
  }
  msg='chr 'number'='_chr(result);
  command_put(msg);
  //message(msg);
}
_command execute_selection() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
{
  if ( _select_type()=='' ) {
     get_line(line);
     status=execute(line,'');
  } else {
     filter_init();
     for (;;) {
       status= filter_get_string(string)
       if ( status ) { status=0;break; }
       execute(string,"");
       if ( rc ) { status=rc;break; }
     }
     filter_restore_pos();
  }
  refresh();  /* Don't want message to go to shell window. */
              /* Refresh will close shell window and redraw editor screen. */
  if ( status ) {
    if ( status<0 && isinteger(status) ) {   /* return code internal ? */
      message(nls('Command returned error code %s',status)'. 'get_message(status));
    } else {
      message(nls('Command returned error code %s',status));
    }
  } else {
    message(nls('Command(s) executed successfully'));
  }
  return(status);
}
_command void resume()
{
   rc=1;_resume();

}
// If arg(1)!='' translated key is returned.  Otherwise '' is returned.
_command case_indirect() name_info(','VSARG2_EDITORCTL|VSARG2_CMDLINE)
{
   _macro_delete_line();
   key=arg(1)
   if ( key:=='' ) {
      key=last_event();
   }
   if ( isalpha(key) ) {
      if ( key>='a' && key<='z' ) {
         key=upcase(key);
      } else {
         key=lowcase(key);
      }
   } else {
      return('');
   }
   if ( arg(1):!='' ) {
      return(key);
   }
   _macro('m',_macro())
   call_key key,last_index('','p');   /* Continue last key sequence */

}

#if __UNIX__
defeventtab _unixman_form
void ctlfindnext.lbutton_up()
{
   ctleditorctl.find_next();
   ctleditorctl._set_focus();
}
#define BUTTON2FORMDY 100
#define EDITCTL2BUTTONDY 100
_unixman_form.on_resize()
{
   y=_dy2ly(SM_TWIP,p_active_form.p_client_height)-ctlclose.p_height-BUTTON2FORMDY;
   ctlclose.p_y=ctlfind.p_y=ctlfindnext.p_y= y;
   height=y-EDITCTL2BUTTONDY-ctleditorctl.p_y;
   if (height<0) height=100;
   ctleditorctl.p_height=height;
   width=_dy2ly(SM_TWIP,p_active_form.p_client_width)-ctleditorctl.p_x*2;
   if (width<0) width=100;
   ctleditorctl.p_width=width;
}
void ctlfind.on_create()
{
   manword=arg(1);
   reinit=arg(2);
   p_window_id=_control ctleditorctl;
   orig_buf_id=p_buf_id;
   orig_buf_flags=p_buf_flags;
   man(manword);
   // IF no man page was found
   if (p_buf_id==orig_buf_id) {
      _message_box(nls("Man page for %s not found",manword));
      if (!reinit) {
         p_active_form._delete_window();
      }
      return;
   }
   man_buf_id=p_buf_id;
   p_buf_id=orig_buf_id;_delete_buffer();
   p_buf_id=man_buf_id;
   p_buf_flags=orig_buf_flags;
   p_active_form.p_caption=p_buf_name;
   parse _default_font(CFG_WINDOW_TEXT) with font_name","font_size","font_flags",";

   p_redraw=false;
   p_font_name=font_name;
   p_font_size=font_size;
   _font_flags2props(font_flags);
   p_redraw=true;
}
void ctlfind.lbutton_up()
{
   ctleditorctl.gui_find();
   ctleditorctl._set_focus();
}

/*
    This command has only been testing on LINUX.  It might require
    some minor changes to work for other UNIXs.

    One small bug in this command is that a menu item is added to the
    file menu even though the buffer name was changed.  This menu item
    needs to be deleted.
*/
_command man()
{
   param=arg(1);
   _macro_delete_line();
   if ( param=='' ) {
      result = show('-modal _textbox_form',
                    'Man',          // Form caption
                    TB_RETRIEVE_INIT,     //flags
                    '',             //use default textbox width
                    'man',          //Help item.
                    '',             //Font (not yet supported)
                    'man',          //Retieve Name
                    'Man Help Item:'
                    );
      if (result=='') {
         return(COMMAND_CANCELLED_RC);
      }
      param=_param1;
   }
   _macro('m',_macro('s'))
   _macro_call('man',param);
   temp_file=mktemp();
   message(nls('Searching man pages for %s',param));

   program_name=file_match('-p /usr/bin/man',1);
   if ( program_name=='' ) {
      program_name=file_match('-p /usr/bin/help',1);
   }
   if ( program_name=='' ) {
      program_name=path_search('man','','P');
   }
   if ( program_name=='' ) {
      message nls('Program "%s" not found','man');
      return(1)
   }
   alternate_shell=file_match('-p /bin/sh',1);
   if ( alternate_shell=='' ) {
      alternate_shell=path_search('sh');
   }
   line=program_name' 'param' >'temp_file' 2>&1';
   mou_hour_glass(1);
   status=shell(line,'pq',alternate_shell);
   mou_hour_glass(0);
   // man return code is unreliable on some UNIX's like LINUX
   unreliable=(machine()=='LINUX') /*|| (machine()=='???')*/;
   if (!unreliable && status) {
      delete_file(temp_file);
      message nls('man page for %s not found',param);
      return(status);
   }
   // Don't want temp file name add to file menu.
   old_max_filehist=def_max_filehist;
   def_max_filehist=0;
   if (p_mdi_child) {
      status=edit('+l -n 'temp_file);
   } else {
      // Current buffer may be hidden.  So we need to restore it later.
      orig_buf_id=p_buf_id;
      status=load_files('+l -n 'temp_file);
   }
   def_max_filehist=old_max_filehist;

   // Filter out garbage characters.  Might need to change this
   // for another OS
   top();search('?\8','@r','');top();p_modify=0;

   name_file2('man page(s) for 'param);
   delete_file(temp_file);
   if (unreliable && p_Noflines<5) {
      if (p_mdi_child) {
         quit();
      } else {
         _delete_buffer();
         p_buf_id=orig_buf_id;
      }
      message(nls('man page for %s not found',param));
      return(status)
   }
   if ( status ) {
      message nls('Unable to edit temp file')'. 'get_message(status)
      return(status);
   }
   clear_message();
   return(0)
}
#endif


_str _create_config_path()
{
   local_dir=_config_path();
   /* make sure the local directory is created. */
   if ( ! isdirectory(local_dir) ) {
      status=make_path(local_dir,'0');  /* Give no shell messages options. */
      if ( status ) {  /* Error trying to create path. */
         popup_message(nls('Unable to create directory "%s"',local_dir)'.  'get_message(status));
         return(1);
      }
   }
   return(0);
/*
   Input filename should be in absolute form.

   This function returns non-zero value if the _config_path()
   should be used instead of the path of the filename given.
*/
}
_str _use_config_path(filename)
{
#if __UNIX__
   /* Since UNIX user always have a HOME directory. */
   /* Must allow for null configuration directory. */
   path=get_env(_SLICKCONFIG);
   if ( ! rc && path=='' ) {
      /* Don't use configuration directory. */
      return(0);
   }
#endif
   path=_config_path('n');
   if ( path=='' ) {
      /*  No local configuration directory. Say that file is user config file. */
      return(0);
   }
   if ( last_char(path)!=FILESEP ) {
      path=path:+FILESEP;
   }
   path=absolute(path);
   return ! file_eq(path,substr(filename,1,pathlen(filename)));

}
#if __UNIX__
/*
  Kludge to work around bug in RS6000 operating system.  Could not determine
  the exact version of the OS or machine configuration which causes the
  problem.  Can't safely kill or exit the concurrent process buffer.
  must exit editor before kill process buffer.
*/
_str _rsprocessbug()
{
   /* If running on RS6000 AND concurrent process buffer is still running */
   /* AND "rs" script executed */
   if ( machine()=='RS6000' && _process_info() && get_env('RSPROCESSBUG')!='' ) {
      return(1);
   }
   return(0);

}
void _exit_rspbug()
{
   if ( _rsprocessbug() ) {
      filename=get_env('RSPROCESSBUG')'/kill.slk';
      load_files('+t 'filename);
      if ( ! rc ) {
         _delete_line();
         insert_line('kill -9 '" "_process_info('p'));
         /* If any of these commands fail, we are going to exit any way */
         _save_file('+o');
         _chmod('+x 'filename);
         _delete_buffer();
      }
   }
}
#endif
_save_pos2(typeless &p)
{
   p=_alloc_selection('B');
   if (p>=0) {
      _select_char(p);
   }
   return(p=='');
}
void _restore_pos2(typeless p)
{
   if (p!='') {
      _begin_select(p);
      _free_selection(p);
   }
}
_command '-','_'() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
  plus_or_minus('Up',arg(1));

}
_command '+'() name_info(','VSARG2_REQUIRES_EDITORCTL)
{
  plus_or_minus('Down',arg(1));

}
static void plus_or_minus(option,param)
{
  param=prompt(translate(param,'  ','+-'),option);
  if ( ! isinteger(param) ) {
     message(nls('Invalid number'));
     return;
  }
  old_scroll_style=_scroll_style();
  _scroll_style('c');
  if ( option=='Up' ) {
     up(param);
  } else {
     down(param);
  }
  _scroll_style(old_scroll_style)

}
_command '0'() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   goto_line(arg(1));

}
_command goto_line() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   arg1=prompt(arg(1));
   status=eval_exp(result,arg1,10);
   arg1=result;
   if (status || !isinteger(arg1) ) {
      message(nls('Invalid number'));
      return(1);
   }
   old_scroll_style=_scroll_style();
   _scroll_style('c');
   p_line=arg1;
   //p_RLine= arg1;
   _scroll_style(old_scroll_style);
   return(0);
}
_command gui_goto_line() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   was_recording=_macro();
   _macro_delete_line();
   result=show('-modal _textbox_form',
        'Go to line',          // Caption
         TB_RETRIEVE,          // flags
         0,                    // Default text box width
         'gui_goto_line',      // help item
         '',                   // (reserved)
         'gui_goto_line',      // retrieve name
         '-r 0,2147483647 Line Number:'p_line
         );
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   _macro('m',was_recording);
   _macro_call('goto_line', _param1);
   goto_line(_param1);
}
_command void gui_goto_col() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   if (arg(1)!="") {
      p_col=arg(1);
      return;
   }
   was_recording=_macro();
   _macro_delete_line();
   result=show('-modal _textbox_form',
        'Go To Column',       // Caption
         TB_RETRIEVE,         // flags
         0,                   // Default text box width
         'gui_goto_col',      // help item
         '',                  // (reserved)
         'gui_goto_col',      // retrieve name
         '-r 1,2147483647 Column:'p_col
         );
   if (result=='') {
      return;
   }
   _macro('m',was_recording);
   _macro_append('p_col='_param1";");
   p_col=_param1;
}
_command void select_mode() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_EDITORCTL)
{
   cur_mode_name=p_mode_name;
   cur_ext=get_extension(p_buf_name,1);
   was_recording=_macro();
   _macro_delete_line();
   ff=1;
   index=1;
   orig_view_id=_create_temp_view(temp_view_id);
   p_view_id=temp_view_id;
   while (index) {
      index=name_match('def-setup-',ff,MISC_TYPE);
      ni=name_info(index);
      if (ni!='' && substr(ni,1,1)!='@') {
         parse ni with junk'MN='modename',';
         if (modename=='') {
            parse name_name(index) with 'def-setup-'ext;
            insert_line(' .'ext);
         } else {
            // If user was not a smart-aleck
            if (substr(modename,1,1)!='.') {
               insert_line(' 'modename);
            }
         }
      }
      ff=0;
   }
   _lbsort();
   _remove_duplicates();
   _lbtop();
   if (cur_mode_name=='') {
      status=search('^ 'cur_ext'$','@r');
   } else {
      status=search('^ 'cur_mode_name'$','@r');
   }
   if (status) {
      _lbtop();
   }
   p_view_id=orig_view_id;
   result=show('-modal _sellist_form',
               "Select Mode",
               SL_NOTOP|SL_VIEWID|SL_SELECTCLINE,
               temp_view_id,
               "",//Buttons
               "Select Mode dialog box"//Help Item
               );
   if (result=='') {
      return;
   }
   result=strip(result);
   if (substr(result,1,1)=='.') {
      ext=substr(result,2);
   } else {
      index=0;
      ext=_modename2ext(result,index);
   }
   if (ext!='') {
      select_edit_mode(ext);
      _macro('m',was_recording);
      _macro_call('select_edit_mode',ext);
   }
}
_command gui_sort() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_MARK)
{
   _macro_delete_line();
   result = show('-modal _sort_form',
                 p_window_id
                 );
   if (result=='') {
      return(COMMAND_CANCELLED_RC);
   }
   _macro('m',_macro('s'))
   parse result with type options;
   switch (type) {
   case 'B':
      _macro_append("sort_buffer('"options"');");
      status=sort_buffer(options);
      break;
   case 'O':
      _macro_append("sort_on_selection('"options"');");
      status=sort_on_selection(options);
      break;
   case 'W':
      _macro_append("sort_within_selection('"options"');");
      status=sort_within_selection(options);
      break;
   }
   if (status) {
      _message_box(nls('Sort failed.')'  'get_message(status));
   }
   return(status);
}

defeventtab _sort_form

_ok.on_create()
{
   wid = arg(1)
   if (wid.select_active()) {//User may want a selection sort
      if((_select_type(_duplicate_selection(''), 'T') != 'BLOCK')
       &&(_select_type(_duplicate_selection(''), 'T') != 'LINE')){
  /*Selection sorts can only be performed on Block and Line marks*/
          //_on_selection.p_enabled = 0;
          _within_selection.p_enabled = 0;
          //_on_selection.p_caption='Sort Lines Selected'
          //message 'Block or Line Marks Must be used for Selection Sorts';
/*Give the user a message in case they had intended to do a
  selection sort on a character mark.  Disable those radio buttons
  too.*/
       }
       _on_selection.p_value = 1;//Turn Selection Sort on
   }else{
      _on_selection.p_enabled =
      _within_selection.p_enabled = 0;
   }//Disable the Buttons if there is no selection
}

_ok.lbutton_up()
{
   if (_on_buffer.p_value) {
      ret_val = 'B';//Sort-on-Buffer Sort
   }
   if (_on_selection.p_value) {
      ret_val = 'O';//Sort-on-Selection Sort
   }
   if (_within_selection.p_value) {
      ret_val = 'W';//Sort-Within-Selection Sort
   }
   if (_ascending.p_value) {
      ret_val = ret_val' A';//Ascending Sort
   }else{
      ret_val = ret_val' D';//Descending Sort
   }
   if (_numeric.p_value) {
      ret_val = ret_val' -N';//Numeric Sort
   }
   p_active_form._delete_window(ret_val);
}

// This command is used when updating to a new version of
// Visual SlickEdit
_command install_update()
{
   if (arg(1)=='') {
      return(1);
   }
   cmdline=arg(1);
   output_dir=strip(parse_file(cmdline),'B','"');
   //parse arg(1) with output_dir .
   status=install_update2(output_dir);
   semaphore_dir=output_dir:+'semaphor';
   status=mkdir(semaphore_dir);
   if (status) {
      _message_box(nls("Unable to create semaphore directory '%s'\n\n",semaphore_dir)get_message(status),"Visual SlickEdit Installation");
   }
   return(0);
}

static install_update2(output_dir)
{
   if (!isdirectory(output_dir)) {
      return(1);
   }
   if (last_char(output_dir)!=FILESEP) {
      output_dir=output_dir:+FILESEP;
   }
   filename=output_dir:+USERDEFS_FILE;
   delete_file(filename);
   filename=output_dir:+USEROBJS_FILE;
   delete_file(filename);
   filename=output_dir:+USERSYSO_FILE;
   delete_file(filename);

   old_value=get_env(_SLICKCONFIG);
   old_value2=get_env(_SLICKPATH);
   set(_SLICKCONFIG'='output_dir);

   status=list_source();
   if (status) {
      _message_box(nls("See manual for information on transferring your configuration changes"),"Visual SlickEdit Installation");
      set(_SLICKCONFIG'='old_value);
      return(1);
   }
   status=save('',SV_OVERWRITE);
   if (status) {
      // Message box already displayed.
      _message_box(nls("See manual for information on transferring your configuration changes"),"Visual SlickEdit Installation");
      set(_SLICKCONFIG'='old_value);
      return(1);
   }

   status=list_objects();
   if (status!=1) {
      if (status) {
         _message_box(nls("See manual for information on transferring your configuration changes"),"Visual SlickEdit Installation");
         set(_SLICKCONFIG'='old_value);
         return(1);
      }
      status=save('',SV_OVERWRITE);
      if (status) {
         // Message box already displayed.
         _message_box(nls("See manual for information on transferring your configuration changes"),"Visual SlickEdit Installation");
         set(_SLICKCONFIG'='old_value);
         return(1);
      }
   }

   status=list_usersys_objects();
   if (status) {
      set(_SLICKCONFIG'='old_value);
      // If no forms defined
      if (status==1) {
         return(0);
      }
      _message_box(nls("See manual for information on manually updating your configuration changes"),"Visual SlickEdit Installation");
      return(1);
   }
   filename=p_buf_name;
#if 0
   _message_box(nls("Template source code for user modified system dialog boxes has been placed in the file '%s'\n\nYou must manually apply these changes yourself by typing \"%s\" on the Visual SlickEdit command line",filename,filename),
                "Visual SlickEdit Installation");
#endif
    status=save('',SV_OVERWRITE);
   if (status) {
      // Message box already displayed.
      set(_SLICKCONFIG'='old_value);
      _message_box(nls("See manual for information on manually updating your configuration changes"),"Visual SlickEdit Installation");
      return(1);
   }

   set(_SLICKCONFIG'='old_value);
   return(0);
}
static void adjust_filespec(_str &vslickpathfilename)
{
#if !__UNIX__
   comspec=get_env("COMSPEC")" /c";
   if (file_eq(substr(vslickpathfilename,1,length(comspec)),comspec)) {
      vslickpathfilename=strip(substr(vslickpathfilename,length(comspec)+1));
      if (machine()!="OS2386") {
          if (file_match("-p "vslickpathfilename".bat",1)!="") {
             vslickpathfilename=vslickpathfilename".bat";
             return;
          }
      }
      if (file_match("-p "vslickpathfilename".cmd",1)!="") {
         vslickpathfilename=vslickpathfilename".cmd";
         return;
      }
   }
#endif
}
_command void which()
{
   filename=arg(1);
   if (filename=="") {
      return;
   }
   // We want this one to act like user typed command on command line
   // except we don't look for internal editor commands.
   vslickpathfilename=slick_path_search(filename,"M");
   // We want this one to act like user is at shell prompt.
   pathfilename=path_search(filename,"","P");
   adjust_filespec(vslickpathfilename);
   adjust_filespec(pathfilename);
   msg="VSLICKPATH found <"vslickpathfilename">   PATH found <"pathfilename">";
   sticky_message(msg);
}



static typeless cs_ori_position;

// Desc:  Convert indentations from spaces to tabs.
_command void convert_spaces2tabs() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)
{
   // If current selection is not in the same buffer, do nothing:
   hasselection = 0;
   if ( !_get_selinfo( start_col, end_col, buf_id ) ) {
      if ( buf_id == p_buf_id ) {
         hasselection=1;
      }
   }
   clear_message();

   // Determine lines to convert:
   if ( hasselection ) {
      saved_mark_id = _duplicate_selection();
      old_mark_id = _duplicate_selection( '' );
      _end_select();
      esline = p_line;
      _begin_select();
      bsline = p_line;
   } else {
      ln=p_line;col=p_col;left_edge=p_left_edge;cursor_y=p_cursor_y;
      top();
      bsline = p_line;
      bottom();
      esline = p_line;
   }

   // For every line in the selection, convert indent spaces to tabs:
   old_value = p_indent_with_tabs;
   p_indent_with_tabs = TRUE;
   _str line;
   for ( i = bsline; i <= esline; i++ ) {
      p_line = i;
      get_line( line );
      non_blank = verify( line," ");
      if ( non_blank ) {
         replace_line( indent_string(text_col(line,non_blank,'I')-1) :+
                      substr(line,non_blank) );
      }
   }
   p_indent_with_tabs = old_value;
   if ( hasselection) {
      _show_selection( saved_mark_id );
      _free_selection( old_mark_id );
   } else {
      p_line=ln;p_col=col;set_scroll_pos(left_edge,cursor_y);
   }
}


// Desc:  Convert all tabs to spaces.
_command void convert_tabs2spaces() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL)
{
   // If current selection is not in the same buffer, do nothing:
   hasselection = 0;
   if ( !_get_selinfo( start_col, end_col, buf_id ) ) {
      if ( buf_id == p_buf_id ) {
         hasselection=1;
      }
   }
   clear_message();

   // Determine lines to convert:
   if ( hasselection ) {
      saved_mark_id = _duplicate_selection();
      old_mark_id = _duplicate_selection( '' );
      _end_select();
      esline = p_line;
      _begin_select();
      bsline = p_line;
   } else {
      ln=p_line;col=p_col;left_edge=p_left_edge;cursor_y=p_cursor_y;
      top();
      bsline = p_line;
      bottom();
      esline = p_line;
   }

   // For every line in the selection, convert tabs to spaces:
   _str line;
   for ( i = bsline; i <= esline; i++ ) {
      p_line = i;
      get_line( line );
      newline = expand_tabs( line );
      //messageNwait( newline );
      replace_line( newline );
   }
   if ( hasselection) {
      _show_selection( saved_mark_id );
      _free_selection( old_mark_id );
   } else {
      p_line=ln;p_col=col;set_scroll_pos(left_edge,cursor_y);
   }
}

/* FORMATCOLUMNSFLAG_NOCOMPRESS
 *   Do not compress inter-column whitespace
 */
#define FORMATCOLUMNSFLAG_NOCOMPRESS (0x1)
int def_format_columns_flags=0;
_command int format_columns() name_info(','VSARG2_MARK|VSARG2_REQUIRES_EDITORCTL|VSARG2_REQUIRES_AB_SELECTION)
{
   if( !select_active() ) {
      _message_box('No selection active');
      return(1);
   }

   nocompress= (def_format_columns_flags&FORMATCOLUMNSFLAG_NOCOMPRESS);

   stype=_select_type();
   if( stype=='CHAR' ) {
      // Convert char selections to line selections
      _select_type('','L','LINE');
      stype='LINE';
   }
   if( stype=='LINE' ) {
      width=longest_line_in_selection();
      start_col=1;end_col=width;
   } else {
      // stype=='BLOCK'
      _get_selinfo(start_col,end_col,dummy);
      width=end_col-start_col+1;
   }

   save_pos(p);
   _begin_select();

   // Find the first non-blank line
   status=0;
   for( ;; ) {
      if( _end_select_compare()>0 ) break;
      if( _expand_tabsc(start_col,width)!='' ) break;
      status=down();
      if( status ) break;
   }
   if( status || _end_select_compare()>0 ) {
      restore_pos(p);
      return(0);   // No non-blank lines to columnize
   }

   // Get the column stops
   cols._makeempty();
   line=strip(_expand_tabsc(),'T');
   nofcols=1;
   // 'temp_end_col' is shrunk if we shift a line to the left in the case of a block selection
   temp_end_col=end_col;
   if( stype=='LINE' ) {
      cols[nofcols]=pos('[~ ]',line,1,'r');   // First column stop is first-non-blank-col of first line
   } else {
      // stype=='BLOCK'
      col=pos('[~ ]',line,start_col,'r');   // First column stop is first non-blank after leftcol of block selection
      if( col>start_col ) {
         // Adjust the text in the selection to start at 'start_col' and shrink 'temp_end_col' by the difference
         before=substr(line,1,start_col-1);
         middle=strip(substr(line,start_col,width),'L');
         after=substr(line,end_col+1);
         line=before:+middle:+after;
         temp_end_col-=col-start_col;
      }
      cols[nofcols]=col;
   }
   col=cols[nofcols];
   colstop=1;
   for( ;; ) {
      for( ;; ) {
         ++colstop;
         col=pos(' ',line,col);
         non_blank_col=0;
         if( !col ) {
            // At the end of the line
            col=length(line)+2;
         } else {
            if( stype!='LINE' && col>temp_end_col ) {
               // Beyond the adjusted right edge of the block selection
               col=temp_end_col+2;
            } else if( nocompress ) {
               col=pos('[~ \t]',line,col,'r');
               if( stype!='LINE' && col>temp_end_col ) col=temp_end_col+2;
               non_blank_col=col;
            } else {
               ++col;
               non_blank_col=pos('[~ \t]',line,col,'r');
               if( non_blank_col>temp_end_col ) non_blank_col=0;
            }
         }
         if( cols[colstop]._isempty() || cols[colstop]<col ) {
            if( cols[colstop]._isempty() ) {
               ++nofcols;
            } else {
               // Readjust following column stops by the difference
               diff=col-cols[colstop];
               for( i=colstop+1;i<=nofcols;++i ) cols[i]+=diff;
            }

            if( col<non_blank_col ) {
               // Adjust the right edge of block selection back accordingly
               temp_end_col-=non_blank_col-col;
            }
            cols[colstop]=col;
            //messageNwait('cols['colstop']='cols[colstop]);
         }
         //if( !cols[7]._isempty() ) messageNwait('cols[7]='cols[7]);
         if( stype=='LINE' ) {
            if( col>length(line) ) break;   // End of the line
         } else {
            if( col>length(line) || col>temp_end_col || cols[colstop]>temp_end_col ) {
               //messageNwait('line='translate(line,'+',' '));
               //messageNwait('col='col'  length='length(line)'  temp_end_col='temp_end_col'  cols['colstop']='cols[colstop]);
               break;   // End of the line or selection
            }
         }

         // Now readjust this line to conform with latest column-stops
         before=strip(substr(line,1,col-1),'T');
         middle=substr('',1,cols[colstop]-length(before)-1);
         after=strip(substr(line,col),'L');
         line=strip(before:+middle:+after,'T');
         col=cols[colstop];
      }

      // Find the next non-blank line
      status=0;
      for( ;; ) {
         status=down();
         if( status ) break;
         if( _end_select_compare()>0 ) break;
         if( _expand_tabsc(start_col,width)!='' ) break;
      }
      if( status || _end_select_compare()>0 ) break;   // No more non-blank lines to columnize
      temp_end_col=end_col;
      if( stype=='LINE' ) {
         line=substr('',1,cols[1]-1):+strip(_expand_tabsc());
      } else {
         line=_expand_tabsc(1,start_col-1,'S'):+_expand_tabsc(start_col,width):+_expand_tabsc(end_col+1,-1,'S');
         col=pos('[~ ]',line,start_col,'r');   // First column stop is first non-blank after leftcol of block selection
         if( col>start_col ) {
            // Adjust the text in the selection to start at 'temp_start_col' and shrink 'end_col' by the difference
            before=substr(line,1,start_col-1);
            middle=strip(substr(line,start_col,width),'L');
            after=substr(line,end_col+1);
            line=before:+middle:+after;
            temp_end_col-=col-start_col;
         }
      }
      col=cols[1];  // Always start at first column stop of first line
      colstop=1;
   }

   #if 0
   msg='';
   for( i._makeempty();; ) {
      cols._nextel(i);
      if( i._isempty() ) break;
      msg=msg' 'cols[i];
   }
   messageNwait('cols='msg);
   #endif

   // Columnize
   _begin_select();
   for( ;; ) {
      if( stype=='LINE' ) {
         line=_expand_tabsc();
      } else {
         line=_expand_tabsc(start_col,width);
      }
      if( line!='' ) {
         i=0;
         // The first column stop is a special case
         if( stype=='LINE' ) {
            new_line=indent_string(cols[++i]-1);
         } else {
            new_line=_expand_tabsc(1,start_col-1,'S');
            ++i;
         }
         parse line with before line;
         before=strip(before);
         new_line=new_line:+before;
         while( line!='' ) {
            parse line with '[~ ]','r' +0 before ':b','r' +0 line;
            before=strip(before);
            //messageNwait('cols['(i+1)']='cols[i+1]'  text_col='text_col(new_line)'  before='translate(before,'+',' '));
            new_line=new_line:+substr('',1,cols[++i]-text_col(new_line)-1):+before;
            if( stype!='LINE' && cols[i]>end_col ) break;   // We are now outside the block selection
         }
         if( stype!='LINE' && text_col(new_line)<end_col ) {
            /* This will pad the block-selected portion with trailing spaces
             * out to the width of the block selection.
             */
            diff=end_col-text_col(new_line);
            new_line=substr(new_line,1,length(new_line)+diff);
         }

         // There might be some line left, so tack it on
         new_line=new_line:+line;

         new_line=new_line:+_expand_tabsc(end_col+1,-1,'S');
         // Trailing whitespace will throw off finding the next column, so strip it
         new_line=strip(new_line,'T');
         replace_line(new_line);
      } else {
         new_line='';
         if( stype!='LINE' ) {
            new_line=_expand_tabsc(1,start_col-1,'S'):+substr('',1,width):+_expand_tabsc(end_col+1,-1,'S');
            if( new_line=='' ) new_line='';
         }
         replace_line(new_line);
      }
      if( down() ) break;
      if( _end_select_compare()>0 ) break;
   }

   _begin_select();

   return(0);
}

#if !__UNIX__

/*
 *Function Name:_ntGetRegistryValue
 *
 *Parameters: 
 *
 *Description: _ntGetRegistryValue, if version specifc, searches for the latest
 *             subkey in path and the retrieves the contents of the valuename.
 *
 *Returns:
 *
 */

_str _ntGetRegistryValue(int rootKey, _str prefixPath /* no trailing backslash here*/,
                           _str suffixPath /* no leading \ here*/, 
                           _str valuename, boolean versionSpecific)
{
   _str version;
   _str contents;
   _str path;
   path    = '';
   version = '';
   contents   = '';

   if (prefixPath == '') {
      message(nls("No prefix path."));
      return('');
   }
   //If version specific
   if (versionSpecific) {
      //Find the latest subkey
      status = _ntRegFindLatestKey(rootKey, prefixPath, version);
      if (status) {
         return('');
      }
      //Add the latest subkey to the path
      prefixPath = prefixPath:+FILESEP:+version;
   }
   prefixPath=prefixPath:+FILESEP:+suffixPath;
   if (valuename=="") {
      contents = _ntRegQueryValue(rootKey,prefixPath,"");
   } else {
      status = _ntRegFindValue(rootKey,prefixPath,valuename,contents);
      if (status) {
         return('');
      }
   }
   return(contents);
}

_command void cmdtrace() 
{
   trace();
}
/*
 *Function Name:_ntRegFindLatestKey
 *
 *Parameters:   
 *
 *Description: Searches the Path's version specific subkeys for the latest
 *             and returns that subkey
 *
 *Returns:     1 if an error
 *             0 if successful
 *
 */
int _ntRegFindLatestKey(int RootKey, _str Path, _str &subkey,int requiredMajor=0) 
{
   _str Val;
   //Find the first Subkey
   int status = _ntRegFindFirstSubKey(RootKey,Path,Val,1);
   subkeyMajor=0;
   subkeyMinor=0;
   boolean found_one=false;
   while (!status) {
      //Check to see if Val is greater than the current Value
      parse Val with major '.' minor '(';
      if (!isinteger(minor)) {
         minor=0;
      }
      if (requiredMajor) {
         if (isnumber(major) && major==requiredMajor) {
            found_one=true;
            subkey= Val; 
            subkeyMajor=major;
            if (minor>subkeyMinor) {
               subkeyMinor=minor;
            }
         }
      }else{
         if (isnumber(major) && 
             (major >subkeyMajor || (major==subkeyMajor && minor>subkeyMinor))) {
            found_one=true;
            //If so, Value is replaced
            subkey= Val;
            subkeyMajor=major;
            subkeyMinor=minor;
         }
      }
      //Find the next Subkey
      status = _ntRegFindFirstSubKey(RootKey,Path,Val,0);
   }
   //Close the key
   _ntRegFindFirstSubKey(0,'','',-1);
   if (status == 1) {
      /*if (isinteger(status)) {
         fsay("_ntRegFindFirstSubKey: error "status);
      } else {
         fsay("_ntRegFindFirstSubKey: error ????");
      } */
      return(status)
   }
   if (!found_one) return(1);
   //fsay("_ntRegFindFirstSubKey: 0 "status);
   return(0);
}
/* Returns 0      on success and fills ValueName with value name
 *                AND Value with the actual value
 *         1      on failure
 *         2      on no more items to process
 */
int _ntRegFindValue(int RootKey,_str Path,_str ValueName,_str &contents)
{
   typeless name,val;

   name='';
   val='';

   contents="";
   // Find the first value listed
   status=_ntRegFindFirstValue(RootKey,Path,name,val,1);

   while ( !status ) {
      //If it matches what we want, copy and break
      if ( name==ValueName ) {
         ValueName=name;
         contents=val;
         break;
      }
      //Otherwise, get the next value listed
      status=_ntRegFindFirstValue(0,'',name,val,0);
   }
   //Close the key
   _ntRegFindFirstValue(0,'','','',-1);

   return(status);
}

/*
   root is one of the HKEY_* constants...
      #define HKEY_CLASSES_ROOT           ( 0x80000000 )
      #define HKEY_CURRENT_USER           ( 0x80000001 )
      #define HKEY_LOCAL_MACHINE          ( 0x80000002 )
      #define HKEY_USERS                  ( 0x80000003 )
      #define HKEY_PERFORMANCE_DATA       ( 0x80000004 )
      #define HKEY_CURRENT_CONFIG         ( 0x80000005 )
      #define HKEY_DYN_DATA               ( 0x80000006 )
      
   Prefix is the name of the key before the version part. 
      Ex: if you want to find "Software\Microsoft\DevStudio\6.0\Tools"
          Prefix="SOFTWARE\Microsoft\DevStudio".  
          Do not use leading or trailing backslashes in Prefix
           
   Version is the number of the major version to find
  
      Ex: if you want to find "Software\Microsoft\DevStudio\6.0\Tools"
          Version=6.  The latest version will be found(this means that 
          a version like "6.0a" might actually be returned).
          
   Suffix is remaining part of the keyname after the version 
   
      Ex: if you want to find "Software\Microsoft\DevStudio\6.0\Tools"
          Suffix="Tools".
          Do not use leading or trailing backslashes in Prefix
          
   Name returns the complete name of the key found
   
   returns 0 if succesful.  For other return codes see _ntRegFindLatestKey, 
           and _ntRegFindFirstValue.
*/
int _ntRegFindVersionKeyName(int root,_str Prefix,int Version,
                             _str Suffix,_str &Name)
{     
   Name='';
   status=_ntRegFindLatestKey(root,Prefix,subkey,Version);
   if (status) {
      return(status);
   }
   _str WholeName=Prefix'\'subkey;
   if (Suffix=='') {
      //If this happens the user should have just called _ntRegFindLatestKey
      Name=WholeName;
      return(status);
   }
   if (last_char(WholeName)!='\') {
      WholeName=WholeName:+'\';
   }
   WholeName=WholeName:+Suffix;
   status=_ntRegFindFirstValue(root,WholeName,junk1,junk2,1);
   if (status) {
      return(status);
   }
   Name=WholeName;
   //Close the key
   _ntRegFindFirstValue(0,'','','',-1);
   return(status);
}

#endif
#define DEMO_PATH     'demo'
#define DEMO_PROGRAM  'demo32.exe'
#define DEMO_FILE     'vslick.dbd'

_command void demo()
{
   // Path passed from instal program?
   path=arg(1);
   if (path!="") {
      if (last_char(path)!=FILESEP) {
         path=path:+FILESEP;
      }
      if (file_match('-p 'maybe_quote_filename(path:+DEMO_PROGRAM),1)=="") {
         return;
      }
   } else {
outer:
      for (;;) {
         orig_view_id=_create_temp_view(temp_view_id);
         _insert_drive_list();
         top();up();
         for (;;) {
            if (down()) {
               break;
            }
            text=_lbget_text();
            if(_drive_type(text)==DRIVE_CDROM) {
               path=text;
               if (last_char(path)!=FILESEP) {
                  path=path:+FILESEP;
               }
               path=path:+DEMO_PATH;
               if (last_char(path)!=FILESEP) {
                  path=path:+FILESEP;
               }
               if (file_match('-p 'maybe_quote_filename(path:+DEMO_PROGRAM),1)!="") {
                  break outer;
               }
            }
         }
         _delete_temp_view(temp_view_id);
         activate_view(orig_view_id);
         result=_message_box("Insert the Visual SlickEdit CD-ROM","",MB_OKCANCEL);
         if (result!=IDOK) {
            return;
         }
      }
   }
   cwd=getcwd();
   chdir(path,1);
   cmdline=maybe_quote_filename(path:+DEMO_PROGRAM)" ":+DEMO_FILE;
   shell(cmdline,"A");
   chdir(cwd,1);
}
