/*
$VerboseHistory: vi.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:25a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:25a
 * Comment:
 * Added editor control support.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:36p
 * Comment:
 * Adding new 3.0 stuff
*/

#include "slick.sh"
#include "ex.sh"


_str     def_vi_mode;
boolean  def_vi_start_in_insert_mode=false;
boolean  def_vi_always_preview_change;   // Even if the 'c' command changes multiple lines, preview them
boolean  def_vi_left_on_escape;
_str     def_vi_insertion_pos;
boolean  def_vi_show_msg;
boolean  def_vi_ignore_process_keys;   // 1 = enable vi command-mode in the '.process' buffer
_str     def_vi_chars='A-Za-z0-9_';
_str     def_vi_chars2='\!\@\#\$\%\^\&\*\(\)\-\+\|\=\\\{\}\[\]\"\39\`\:\;\~\?\/\,\.\>\<';
_str     vi_old_search_string;
int      vi_old_search_flags;
_str     vi_old_word_re;
_str     old_search_string;
typeless old_search_flags;
_str     old_word_re;
_str     _vi_prev_context;

boolean def_vi_ignore_process_keys;   // Non-zero = when in vi emulation, put concurrent process buffer into command mode

_str _vi_repeat_info='';     // Holds the index of the command to repeat, lastkey pressed, a repeat count, and additional arguments to pass to the command
_str _vi_repeat_info0='';    // Holds the index of the insert command to repeat, lastkey pressed, a repeat count, and additional arguments to pass to the command


#define VI_COMMAND_MODE_MSG "COMMAND MODE"
#define VI_INSERT_MODE_MSG  "INSERT MODE"


definit()
{
   show_message=1;
   if ( arg(1)=='L' ) {
      show_message=0;   // This is handy when changing emulations
   }
   //messageNwait('def_keys='def_keys'  def_vi_mode='def_vi_mode);
   if ( upcase(strip(translate(def_keys,'-','_'))):=='VI-KEYS' ) {
      if( !isinteger(def_vi_start_in_insert_mode) || !def_vi_start_in_insert_mode ) {
         vi_switch_mode('C',show_message);   // Make sure we are in command mode
      } else {
         vi_switch_mode('I',show_message);   // Make sure we are in command mode
      }
      def_show_cb_name=true;    // We want named clipboards
   }
   if( !isinteger(def_vi_always_preview_change) ) {
      def_vi_always_preview_change=false;
   }
   def_vi_insertion_pos='';  // The beginning of an insertion
   if ( !isinteger(def_vi_show_msg) ) {
      def_vi_show_msg=true;
   }
   if ( !isinteger(def_vi_ignore_process_keys) ) {
      def_vi_ignore_process_keys=false;
   }
   if ( ! isinteger(def_vi_left_on_escape) ) {
      def_vi_left_on_escape=true;
   }
   vi_old_search_string='';
   vi_old_replace_string='';
   vi_old_search_flags=0;
   vi_old_word_re='['def_word_chars']';
   if ( _search_case()=='I' ) {
      vi_old_search_flags=IGNORECASE_SEARCH;
   }
   _vi_prev_context=p_line' 'p_col' 'p_buf_id' 'p_buf_name;

   // Initialize static variables used in VI-REPEAT-INFO
   _vi_repeat_info='';
   _vi_repeat_info0='';

   // Abort any vi keyboard macro currently being recorded
   _macro('KA');

   rc=0;
}


/* By default this command handles ESC pressed */
_command vi_escape() name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_READ_ONLY)
{
   in_process=(substr(p_buf_name,1,length(".process"))==".process"  || _process_info('B'));
   in_fileman=(p_mode_name=="Fileman");
   if( in_process || in_fileman ) return(0);

   // Put editor into command mode
   status=0;
   mode=upcase(vi_get_vi_mode());
   if ( mode=='C' ) {
      // Already in command mode
      vi_switch_mode('');   // However, call VI-SWITCH-MODE to loop through the buffers and make sure
      vi_message('Already in command mode')
   } else if ( mode=='I' ) {
      if( vi_repeat_info('I') ) {
         repeat_idx=vi_repeat_info('X');
         cmdname=vi_name_eq_translate(name_name(repeat_idx));
         is_posted_cmd=pos(' 'cmdname' ',POSTED_INSERT_CMDS);
         if( is_posted_cmd ) {
            vi_repeat_info('D');
            vi_repeat_info('E');
            last_index(repeat_idx,'C');
            count=vi_repeat_info('C');
            if( isinteger(count) && count>1 ) {
               if( cmdname=='vi-replace-line' ) _insert_state('1');
               vi_repeat_info('Z2',count-1);   /* Pass (count-1) as a playback
                                                * count
                                                */
               return(0);
            }
         }
      }
      col=p_col;
      status=vi_switch_mode('C');
      if ( !status ) {
         def_vi_insertion_pos='';   // Clear the beginning insertion pos marker
         if( def_vi_left_on_escape && p_col==col ) {
            left();
         }
      }
   }
   vi_repeat_info('E');   // End keyboard recording
   return(status);
}


int vi_message(msg)
{
#if 1
   this_idx=find_index('vi-message',PROC_TYPE);
   if ( last_index()==this_idx ) {
      flush_repeats(last_event());
   }
   last_index(this_idx);
#endif
   arg2=upcase(strip(arg(2)));
   do_beep=pos('B',arg2);
   show_msg=pos('M',arg2);
   if ( do_beep || def_vi_or_ex_errorbells ) {
      _beep();
      flush_repeats(last_event());
   }
   if ( show_msg || def_vi_show_msg ) {
      if( _default_option(VSOPTION_HAVEMESSAGELINE)) {
         message(msg);
      } else {
         _beep();
         //_message_box(msg,'vi',MB_OK|MB_ICONNONE);
      }
   }

   return(0);
}


_command vi_maybe_normal_character () name_info(','VSARG2_REQUIRES_EDITORCTL|VSARG2_LASTKEY|VSARG2_CMDLINE)
{
   if ( command_state() ) {
      key=last_event();
      if ( isnormal_char(key) ) {
         keyin(key);
      }
   }

   return(0);
}


/* This function switches to command or insert mode */
int vi_switch_mode(_str mode)
{
   // Don't change the mode of the .process buffer or the Fileman
   in_process=(substr(p_buf_name,1,length(".process"))==".process"  || _process_info('B'));
   in_fileman=(p_mode_name=="Fileman");
   if( in_process || in_fileman ) return(0);

   show_message=(arg(2)=="" || arg(2));
   mode=upcase(strip(mode));
   def_vi_mode=upcase(strip(def_vi_mode));
   showmode=__ex_set_showmode();
   showmode=(isinteger(showmode) && showmode>0);
   if ( mode:=='I' ) {
      def_vi_mode='I';
      if ( show_message && showmode ) {
         sticky_message(VI_INSERT_MODE_MSG);
      }
   } else if ( mode:=='C' ) {
      // This will also reset the mode if 'mode' is invalid
      def_vi_mode='C';
      if ( show_message && showmode ) {
         sticky_message(VI_COMMAND_MODE_MSG);
      }
   } else if ( mode=='' ) {
      // Don't change the mode, but loop through all the buffers and reset their modes
   } else {
      if ( show_message ) {
         vi_message('Invalid mode');
      }
      return(1);
   }
   call_list('_vi_switchmode_');
   //messageNwait('switching');
   if (arg(3)=='') {
      select_edit_mode(p_extension,'1');
      return(0);
   } else {
      first_buf_id=p_buf_id;
      for (;;) {
         select_edit_mode('','1');
         _next_buffer('H');   /* 11/24/1997 - 'H' because might be an editor control */
         for( ;p_buf_id!=first_buf_id && p_buf_flags&HIDE_BUFFER; ) _next_buffer('H');
         if ( p_buf_id==first_buf_id ) break;
      }
      return(0);
   }
}


/* This function returns the command name bound to 'key' OR the keytable name */
_str vi_name_on_key(key)
{
   option=upcase(strip(arg(2)))   /* 'R' = return root key binding,
                                   *       otherwise return mode
                                   *       key binding
                                   *
                                   * 'I' = return mode key binding
                                   *       as if user were in INSERT
                                   *       mode
                                   *
                                   * 'IK'= return the keytable name
                                   *       as if user were in INSERT
                                   *       mode
                                   */
   if ( option:=='R' ) {
      return(name_name(eventtab_index(_default_keys,_default_keys,event2index(key))));
   } else if( option:=='I' || option:=='IK' ) {
      setup_idx=find_index('def-setup-'p_extension,MISC_TYPE);
      if ( setup_idx ) {
         parse name_info(setup_idx) with . ',' . ',' . ',' 'KEYTAB=' keytab_name ',' .;
         insert_mode_keytab_idx=find_index(keytab_name,EVENTTAB_TYPE);
         if( !insert_mode_keytab_idx ) insert_mode_keytab_idx=_default_keys;
         if( option:=='IK' ) {
            return(keytab_name);
         } else {
            return(name_name(eventtab_index(_default_keys,insert_mode_keytab_idx,event2index(key))));
         }
      } else {
         return(name_name(eventtab_index(_default_keys,p_mode_eventtab,event2index(key))));
      }
   } else {
      return(name_name(eventtab_index(_default_keys,p_mode_eventtab,event2index(key))));
   }
}


/* This function returns the current mode of the current buffer */
_str vi_get_vi_mode()
{
   return(upcase(strip(def_vi_mode)));
}


/* This function sets the previous context in the current buffer */
void vi_set_prev_context()
{
   prev_context=arg(1);
   if ( prev_context!='' ) {
      _vi_prev_context=prev_context;
   } else {
      _vi_prev_context=p_line' 'p_col' 'p_buf_id' 'p_buf_name;
   }
}


/* This function gets the previous context */
_str vi_get_prev_context()
{
   return(_vi_prev_context);
}


/* This function goes to the previous context set by vi_set_prev_context() */
int vi_goto_prev_context()
{
   cur_line=p_line;cur_col=p_col;
   parse _vi_prev_context with prev_line prev_col buf_id buf_name;
   if ( p_buf_id==buf_id && p_buf_name==buf_name ) {
      if ( isinteger(prev_line) && prev_line>0 ) {
         p_line=prev_line;
         if ( p_line!=prev_line ) {
            p_line=cur_line;
            return(1);
         }
         if ( prev_col>_text_colc() ) {
            p_col=_text_colc();
         } else {
            p_col=prev_col;
         }
      }
   } else {
      top();   // If not known make the previous context line1,column1
   }
   _vi_prev_context=cur_line' 'cur_col' 'p_buf_id' 'p_buf_name;

   return(0);
}


/* This function handles default searching in vi */
int vi_search(re,options)
{
   status=search(re,options);
   save_search(old_search_string,old_search_flags,old_word_re);

   return(status);
}


/* This function is called by other functions (like NEXT-BUFFER,PREV-BUFFER) */
/* This will display the current mode if the SHOWMODE option is turned ON */
int _switchbuf_vi()
{
   keys=upcase(strip(translate(def_keys,'-','_')));
   if( keys=="VI-KEYS" ) {
      mode=vi_get_vi_mode();
      if ((mode=='C' && p_mode_eventtab!=find_index('vi-command-keys',EVENTTAB_TYPE)) ||
          (mode!='C' && p_mode_eventtab==find_index('vi-command-keys',EVENTTAB_TYPE))
          ) {
          //messageNwait('_switchbuf_vi');
          vi_switch_mode(vi_get_vi_mode());
      }
      read_only="Read only";
      showmode=__ex_set_showmode();
      showmode=(isnumber(showmode) && showmode>0);
      if( showmode && upcase(arg(2))!='W' ) {
         if( p_readonly_mode) {
            sticky_message(VI_COMMAND_MODE_MSG);
         } else {
            mode=upcase(vi_get_vi_mode());
            if( mode=='C' ) {
               sticky_message(VI_COMMAND_MODE_MSG);
            } else {
               sticky_message(VI_INSERT_MODE_MSG);
            }
         }
      }
   }

   return(0);
}

/* This function copies marked text to the clipboard and to clipboard '0' */
int vi_cut(copy_option,cb_name)
{
   stack_push=(arg(3)!='' && arg(3));
   if ( cb_name!='' && (length(cb_name)!=1 || ! isalnum(cb_name)) ) {
      vi_message('Invalid clipboard name: "'cb_name'"');
      return(1);
   }
   replace_mark_option=1;
   if ( cb_name!='' && _asc(cb_name)>=_asc('A') && _asc(cb_name)<=_asc('Z') ) {
      // If 'cb_name' is upper-case then append to the named clipboard
      replace_mark_option=0;
      cb_name=lowcase(cb_name);
   }
   if( !select_active() ) {
      vi_message('There is no selection active');
      return(1);
   }
   mark=_duplicate_selection();   // Make an exact copy of the mark
   if( (stack_push || cb_name!='') && cb_name!=VI_CB0 ) {   // Are we pushing the clipboard on the stack AND is the name of the clipboard != '0' already?
      status=cut(1,'C',VI_CB0);   // First copy to clipboard '0'
      old_mark=_duplicate_selection('');
      _show_selection(mark);   // Must show this again so we can copy to normal clipboard
      status=cut(replace_mark_option,copy_option,cb_name);
      _show_selection(old_mark);   // Show 'old_mark' so we can free 'mark'
   } else {
      status=cut(1,copy_option,VI_CB0);
   }
   _free_selection(mark);

   return(status);
}


_str _vi_repeat_info_count;
_str old_vi_repeat_info='';
_str old_vi_repeat_info0='';

/* This function exists to remember the last insert/delete/modification */
/* Keyboard macro:  '0' is for insert commands
 *                  '1' is for non-insert commands
 */
int vi_repeat_info(repeat_idx)
/*
   IF arg(1)=='' THEN
      repeat_idx    = ''
      arg(2)        = repeat count which overrides the count saved with the original command (usually from VI-COUNT)
      arg(3)        = clipboard name which overrides the clipboard name save with the original command
   ELSE
      repeat_idx    = index of the command to repeat
      arg(2)        = last key pressed; MUST have this for playing back delete/modification sequences where the first key is not recorded
      arg(3)        = repeat count from the command
      arg(4)        = clipboard name from the command (if any)
      arg(5)        = callback index of command to call after playback is done (if any)
*/
{
   status=0;
   if( repeat_idx=='' ) {
      if( _vi_repeat_info=='' ) {
         vi_message('Nothing to repeat');
         return(1);
      }
      parse _vi_repeat_info with repeat_idx ',' lkey ',' count ',' cb_name ',' callback_idx;
      if( !index_callable(repeat_idx) ) {
         message('Invalid index');
         return(1);
      }
      override_count=arg(2);
      override_cb_name=arg(3);
      name=vi_name_eq_translate(name_name(repeat_idx));
      is_playback_cmd=pos(' 'name' ',PLAYBACK_CMDS);
      if( isinteger(override_count) && override_count>0 ) {
         count=override_count;
      }
      if( isalnum(override_cb_name) ) {
         cb_name=override_cb_name;
      }
      _vi_repeat_info=repeat_idx','lkey','count','cb_name','callback_idx;   // Reset with (possibly) new count and clipboard name
      if( is_playback_cmd ) {
         is_posted_cmd=pos(' 'name' ',POSTED_INSERT_CMDS);
         if( is_posted_cmd ) {
            _vi_repeat_info0=_vi_repeat_info;   // Just in case its been updated
            status=vi_repeat_info('Z2');
         } else {
            _macro('KP');   // Play back the last recorded keyboard macro
         }
      }
   } else if( !isinteger(repeat_idx) ) {
      option=upcase(strip(repeat_idx));
      switch(option) {
      case 'A':   // Abort the currently recording keyboard macro?
         _vi_repeat_info=old_vi_repeat_info;
         _vi_repeat_info0=old_vi_repeat_info0;
         status=_macro('KA');
         break;
      case 'C':   // Return the repeat count for the command being played back?
         arg2=arg(2);   // This is the count passed in from the command currently being recorded
         if( _macro('KI') ) {
            status=arg2;
         } else {
            parse _vi_repeat_info with repeat_idx ',' . ',' count ',' .;
            if( last_index('','C')==repeat_idx ) {
               status=count;
            } else {
               status=arg2;
            }
         }
         break;
      case 'D':   // Delete the last key sequence of the currently recording keyboard macro
         status=_macro('KD');
         break;
      case 'E':   // End the recording of the currently recording keyboard macro
         status=_macro('KE');
         break;
      case 'I':   // Are we currently recording a keyboard macro?
         status=_macro('KI');
         break;
      case 'N':   // Return the clipboard name for the command being played back?
         arg2=arg(2);   // This is the clipboard name passed in from the command currently being recorded
         if( _macro('KI') ) {
            status=arg2;
         } else {
            parse _vi_repeat_info with . ',' . ',' . ',' cb_name ',' .;
            status=cb_name;
         }
         break;
      case 'R':   // Are we currently playing back a keyboard macro?
         status=_macro('KR');
         break;
      case 'X':   // Return the index which started the recording?
         if( _vi_repeat_info=='' ) {
            status=0;
         } else {
            parse _vi_repeat_info with repeat_idx ',' .;
            if( !repeat_idx || !index_callable(repeat_idx) ) {
               status=0;
            } else {
               status=repeat_idx;
            }
         }
         break;
      case 'Z2':   // Play back the last insertion
         if( _vi_repeat_info0=='' ) {
            _vi_repeat_info_count='';
            vi_message('Nothing to repeat');
            return(1);
         }
         if( arg(2)!='' ) {
            count=arg(2);
         } else {
            parse _vi_repeat_info0 with . ',' . ',' count ',' .;
         }
         if( isinteger(count) && count>0 ) {
            _vi_repeat_info_count=count;
         } else {
            _vi_repeat_info_count=1;
         }
         idx=find_index('vi_repeat_info',PROC_TYPE);
         if( idx && index_callable(idx) ) {
            _vi_repeat_info=_vi_repeat_info0;
            parse _vi_repeat_info0 with repeat_idx ',' lkey ',' . ',' . ',' callback_idx;
            if( repeat_idx && index_callable(repeat_idx) ) {
               for(;;) {
                  last_index(repeat_idx);
                  if( lkey:!='' ) last_event(lkey);
                  if( !isinteger(_vi_repeat_info_count) || _vi_repeat_info_count<1 ) {
                     _vi_repeat_info_count='';
                     if( isinteger(callback_idx) && index_callable(callback_idx) ) {
                        call_index(callback_idx);
                     }
                     return(0);
                  }
                  --_vi_repeat_info_count;
                  _macro('KP','0');
               }
            }
         } else {
            message('Invalid index for vi-repeat-info');
            status=1;
         }
         break;
      }
   } else {
      if( _macro('KR') || _macro('KI') ) {   // Are we playing back OR recording a keyboard macro
         // We are recursing, so get out!
         return(0);
      }
      //dmessage('repeat_idx='repeat_idx);
      if( index_callable(repeat_idx) ) {
         name=vi_name_eq_translate(name_name(repeat_idx));
         if( vi_name_in_list(name,PLAYBACK_CMDS) ) {
            lkey=arg(2);   // This is the last key pressed
            count=arg(3);  // This is a repeat count
            cb_name=arg(4);   // This is the clipboard name
            callback_idx=arg(5);   // This is an index to a callback function

            // Save copies of these incase the macro recording is aborted
            old_vi_repeat_info=_vi_repeat_info;
            old_vi_repeat_info0=_vi_repeat_info0;

            _vi_repeat_info=repeat_idx','lkey','count','cb_name','callback_idx;
            if( pos(' 'name' ',INSERT_CMDS) ) {
               _vi_repeat_info0=_vi_repeat_info;   // Make a copy for the last insertion
               _macro('KB','0');   // Begin keyboard recording for insert commands
            } else {
               _macro('KB','1');   // Begin keyboard recording for non-insert commands
            }
            if( lkey:!='' ) {
               _macro('KK',lkey);  // Insert the key pressed which executed the last command into the keyboard macro
            }
         }
      } else {
         message('Invalid index');
         status=1;
      }
   }

   return(status);
}

int vi_name_in_list(name,string)
{
   temp=vi_name_eq_match('-p 'name,'1',string);
   if( temp=='' ) {
      return(0);
   } else {
      return(1);
   }
}

static _str _vi_eq_string;

_str vi_name_eq_match(prefix_name,find_first,string)
{
   if ( find_first ) {
     _vi_eq_string=string;
   }
   exact_match=0;
   if( pos('-p',lowcase(strip(prefix_name)))==1 ) {
      exact_match=1;
      parse prefix_name with . prefix_name;
   }
   for (;;) {
     if ( _vi_eq_string=='' ) return('');
     parse _vi_eq_string with name _vi_eq_string;
     if( exact_match ) {
        if( name==prefix_name ) {
           return(strip(name));
        }
     } else {
        if ( substr(name,1,length(prefix_name)):==prefix_name ) {
          return(strip(name));
        }
     }
   }

}

_str vi_name_eq_translate(name)
{
   return(strip(translate(name,'-','_')));
}

_str _vi_search_type()
{
   if( def_re_search&UNIXRE_SEARCH ) {
      return('u');
   } else if( def_re_search&BRIEFRE_SEARCH ) {
      return('b');
   } else {
      return('r');
   }
   //return((def_re_search&UNIXRE_SEARCH)?('u'):('r'));
}

