/*
$VerboseHistory: window.e$
 *
 * *****************  Version 1  *****************
 * User: Clark       Date: 01/08/1998  Time:10:27a
 * Updated in \vault\vsship30a\
 * Last Modified: 01/08/1998 10:27a
 * Comment:
 * Change message box to display question mark icon.
 *
 * *****************  Version 1  *****************
 * User: Dan         Date: 10/09/1997  Time:02:35p
 * Updated in \vault\vsship30\
 * Last Modified: 10/07/1997 01:43p
 * Comment:
 * Adding new 3.0 stuff
*/
#include 'slick.sh'

  static typeless Nofwindows_count;

int _OnUpdate_next_window(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   if (!target_wid.p_mdi_child) {
      return(MF_GRAYED);
   }
   orig_wid=p_window_id;
   _next_window('fR' /* no setfocus */);
   next_wid=p_window_id;
   p_window_id=orig_wid;
   if (next_wid!=target_wid) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command void next_window(...) name_info(','VSARG2_ICON|VSARG2_READ_ONLY|VSARG2_CMDLINE|VSARG2_MARK|VSARG2_REQUIRES_MDI_EDITORCTL)
{
#if 0
   // If currently in output toolbar, put focus back to previous edit window:
   if (outputIsInTabShell()) {
      p_window_id=_mdi.p_child;
      _set_focus();
      return;
   }
#endif
   if (p_window_id!=_cmdline) {
      if (!p_mdi_child || (_mdi.p_child.p_window_flags & HIDE_WINDOW_OVERLAP)) {
         return;
      }
   }
   get_view_id orig_view_id
   p_window_id=_mdi.p_child;
   _next_window  arg(1)
   if (orig_view_id==_cmdline) {
      activate_view orig_view_id;
      _set_focus();
   }
}

int _OnUpdate_prev_window(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdate_next_window(cmdui,target_wid,command));
}
_command void prev_window(...) name_info(','VSARG2_ICON|VSARG2_READ_ONLY|VSARG2_MARK|VSARG2_REQUIRES_MDI_EDITORCTL)
{
#if 0
   // If currently in output toolbar, put focus back to previous edit window:
   if (outputIsInTabShell()) {
      p_window_id=_mdi.p_child;
      _set_focus();
      return;
   }
#endif
   if (p_window_id!=_cmdline) {
      if (!p_mdi_child || (_mdi.p_child.p_window_flags & HIDE_WINDOW_OVERLAP)) {
         return;
      }
   }
   get_view_id orig_view_id
   p_window_id=_mdi.p_child;
   _prev_window  arg(1)
   if (orig_view_id==_cmdline) {
      activate_view orig_view_id;
      _set_focus();
   }
}
int _OnUpdate_next_buffer(CMDUI &cmdui,int target_wid,_str command)
{
   if ( !target_wid || !target_wid._isEditorCtl()) {
      return(MF_GRAYED);
   }
   if(_Nofbuffers(2)>=2) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command void next_buffer(...) name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_MARK|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   old_buffer_name=(p_DocumentName!="")?p_DocumentName:p_buf_name;
   orig_buf_id=p_buf_id;
   _next_buffer arg(1);
   switch_buffer(old_buffer_name)
   if (def_one_file!='') {
      _correct_window(orig_buf_id)
   }
}
int _OnUpdate_prev_buffer(CMDUI &cmdui,int target_wid,_str command)
{
   return(_OnUpdate_next_buffer(cmdui,target_wid,command));
}
_command void prev_buffer(...) name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_MARK|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   old_buffer_name=(p_DocumentName!="")?p_DocumentName:p_buf_name;
   orig_buf_id=p_buf_id;
   _prev_buffer arg(1)
   switch_buffer(old_buffer_name)
   if (def_one_file!='') {
      _correct_window(orig_buf_id)
   }
}
_command void next_doc() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_MARK|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   if (def_one_file=='') {
      next_buffer(arg(1));
   } else {
      next_window(arg(1))
   }
}
_command void prev_doc() name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_MARK|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   if (def_one_file=='') {
      prev_buffer(arg(1));
   } else {
      prev_window(arg(1))
   }
}
/* quit all views with the same buf_id as the current buffer.
  If buffer is modified and only one view is left, ask user what to do.

  argument 1 if =='', delete_edit_windows is called to deleted all remaining
                      mdi windows viewing this buffer if it is the last
                      buffer.
  argument 2 if !='', Buffer pos should be saved if buffer is deleted.
  argument 3 if !='', Indicates that you can quit buffer in hidden windows
  argument 4 if !='', Just save file if necessary. Don't delete buffer.

*/
typeless _window_quit()
{
   //if (p_mode_name=='Fileman') {return(1);}
   if (_isdiffed(p_buf_id)) {
      _message_box(nls("You cannot close this file because it is being diffed."));
      return(1);
   }
   noquit_hidden=arg(3);
   just_save_buffer=arg(4);
   // Don't allow buffers in a hidden window to be quit unless override given.
   if ( (p_window_flags&HIDE_WINDOW_OVERLAP) && noquit_hidden) {
      return(1);
   }
  if ( _process_info('b') ) {  /* does this buffer have a concurrent process? */
#if __UNIX__
      if ( _rsprocessbug() ) {
         message "Sorry, can't quit process buffer on RS6000"
         return(1)
      }
#endif
     if ( def_exit_process ) {
        exit_process();
     } else {
        message nls('Please exit concurrent process.')
        return(1);
     }
  }
  changes_written=1;
  if (just_save_buffer=='' && !(p_buf_flags&KEEP_ON_QUIT)) {
     if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
        if ( delphiIsRunning() && delphiIsBufInDelphi(p_buf_name) ) {
           delphiCloseBuffer( p_buf_name );
           return( 0 );
        }
     }
  }
  if ( p_modify && ! (p_buf_flags&THROW_AWAY_CHANGES) ) {
     flush_keyboard();
     result=_message_box(nls("Save changes to '%s'?",_build_buf_name()),'',MB_ICONQUESTION|MB_YESNOCANCEL)
     if (result==IDCANCEL) {
        return(COMMAND_CANCELLED_RC);
     }
     if (result==IDYES) {
         status=save();
         if ( status ) { return(status) }
     }
     if (result==IDNO) {
        changes_written=0;
     }
  }
#if !_MDI_INTERFACE
  if (last_buffer()) {
     exit_list();
  }
#endif
  if ( p_modify && p_buf_flags&REVERT_ON_THROW_AWAY ) {
     buf_flags=p_buf_flags;
     status=load_files(def_load_options' -l -E +r +d 'p_buf_name)
     if ( status ) {
        message(nls('Warning: could not revert to saved'));
     }
     p_buf_flags=buf_flags;
  }
  // IF just save buffer but do not delete buffer.
  if (just_save_buffer!='') {
     if (arg(2)!='' && changes_written) _add_filepos_info(p_buf_name);
     return(0);
  }
  if (last_buffer() && arg(1)=='') {
     /* If deleting last buffer. Delete all mdi child windows but hidden window. */
     if (arg(2)!='' && changes_written) _add_filepos_info(p_buf_name);
     if ( !(p_buf_flags&KEEP_ON_QUIT)) {
        if (_DialogViewingBuffer(p_buf_id,p_window_id)) {
           p_buf_flags=p_buf_flags|HIDE_BUFFER|DELETE_BUFFER_ON_CLOSE;
           call_list('_cbmdibuffer_hidden_');
        } else {
           quit_file();
        }
     } else {
        p_buf_flags=p_buf_flags|HIDE_BUFFER;
        call_list('_cbmdibuffer_hidden_');
     }
     _MDIDeleteWindows();
  } else {
     if ( p_buf_flags&KEEP_ON_QUIT) {
        p_buf_flags=p_buf_flags|HIDE_BUFFER;
        call_list('_cbmdibuffer_hidden_');
        _MDIKeepQuit(p_buf_id);
     } else {
        if (arg(2)!=''&& changes_written) _add_filepos_info(p_buf_name);
        if (_DialogViewingBuffer(p_buf_id,p_window_id)) {
           p_buf_flags=p_buf_flags|HIDE_BUFFER|DELETE_BUFFER_ON_CLOSE;
           call_list('_cbmdibuffer_hidden_');
           _MDIKeepQuit(p_buf_id);
        } else {
           quit_file();
        }
     }
  }
  return(0)

}
/*
  Some case analysis
    assertion:  IF an mdi child is viewing a buffer, p_buf_flags 
                must not have the HIDE_BUFFER flag!
    assertion:  no views of a buffer created by _open_temp_view can
                hang around such the user has time to do delete the buffer.
   
    It is safe for an MDI child to delete a buffer if no other
    dialog box is viewing the buffer.
    
   

*/
boolean _DialogViewingBuffer(int buf_id,int skip_wid /* 0 for null. */)
{
   for (i=1;i<=_last_window_id();++i) {
      if (i!=skip_wid && _iswindow_valid(i) && !i.p_mdi_child && 
          i.p_view_id<0 && i.p_buf_id==buf_id && i!=HIDDEN_WINDOW_ID
          ) {
         return(true);
      }
   }
   return(false);
}

#if 0
/* Find view in the current buffer with the given buffer name */
boolean _TempViewOf(int buf_id /*, int skip_view_id */)
{
   skip_view_id=arg(2);
   get_view_id(orig_view_id);
   activate_view(HIDDEN_VIEW_ID);
   get_view_id(orig_hidden_view_id);
   get_view_id(first_view_id);
   for (;;) {
      _next_view();
      get_view_id(view_id);
      /* messageNwait('p_buf_name='p_buf_name' file_spec='file_spec) */
      if ( view_id!=HIDDEN_VIEW_ID && view_id!=RETRIEVE_VIEW_ID &&
           view_id!=skip_view_id && p_buf_id==buf_id) {
         activate_view(orig_hidden_view_id);
         activate_view(orig_view_id);
         return(true);
      }
      if ( view_id==first_view_id ) break;
   }
   activate_view(orig_hidden_view_id);
   activate_view(orig_view_id);
   return(false)
}
#endif
/*
    Delete all the mdi children with edit buffers
*/
void _MDIDeleteWindows()
{
   // Just incase being called from list box (list-buffers),
   // save and restore the current window
   orig_wid=p_window_id;

   for (wid=1;wid<=_last_window_id();++wid) {
      if (_iswindow_valid(wid) && wid.p_mdi_child && wid!=HIDDEN_WINDOW_ID) {
         wid._delete_window();
         if (wid==orig_wid) {
            orig_wid='';
         }

      }
   }
   if (orig_wid!='') {
      p_window_id=orig_wid;
   }
}
static void _MDIKeepQuit(int buf_id)
{
   for (wid=1;wid<=_last_window_id();++wid) {
      if (_iswindow_valid(wid) && wid.p_mdi_child && wid!=HIDDEN_WINDOW_ID &&
          wid.p_buf_id==buf_id) {
         wid._prev_buffer();
      }
   }
}
int _OnUpdate_arrange_icons(CMDUI &cmdui,int target_wid,_str command)
{
   if (_Noficons()) {
      return(MF_ENABLED);
   }
   return(MF_GRAYED);
}
_command void arrange_icons()  name_info(','VSARG2_READ_ONLY|VSARG2_ICON|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   _mdi._arrange_icons();

}
void _countwindows()
{
   if ( ! (p_window_flags&(HIDE_WINDOW_OVERLAP)) ) {
      Nofwindows_count=Nofwindows_count+1
   }

}
typeless Nofwindows()
{
   if (_no_child_windows()) {
      return(0);
   }
   Nofwindows_count=0;
   for_each_mdi_child('-countwindows','',1)
   return(Nofwindows_count)

}
typeless for_each_mdi_child(command,...)
{
   if (_no_child_windows()) {
      return(0);
   }
  _prev_window 'HF';lastwindow_id=p_window_id;_next_window 'HF'
  /* for each window in the active ring of windows. */
  done=0
  parse command with cmdname cmdline
  if ( arg(2)=='' ) {
     index= find_index(cmdname,PROC_TYPE|COMMAND_TYPE);
     if ( ! index_callable(index) ) {
       messageNwait(nls("Command '%s' not found",cmdname)". "get_message(rc));
       return(rc)
     }
  }
  for (;;) {
    if ( p_window_id== lastwindow_id ) {
      done=1
    }
    if ( ! (p_window_flags&(HIDE_WINDOW_OVERLAP)) || arg(3)!='' ) {
       if ( arg(2)=='' ) {
          call_index(cmdline,index)
       } else {
          execute(command);
       }
    }
    if ( done ) {
      _next_window  'HR'
      break
    }
    _next_window  'HR'
  }
  return(0)

}


typeless for_each_window(index)
{
   if (!isinteger(index)) {
      index=find_index(index,PROC_TYPE|COMMAND_TYPE)
   }
   last=_last_window_id()
   for (i=1;i<=last;++i) {
      if (_iswindow_valid(i) ) {
         status=call_index(i,arg(2),arg(3),arg(4),arg(5),arg(6),index)
         if (status) {
            return(status);
         }
      }
   }
   return(0)
}

typeless for_each_buffer(command)
{
  load_files '+c +v'
  if ( rc ) {
     return(rc)
  }
  if (p_window_flags & HIDE_WINDOW_OVERLAP) {
     // +m option does not set old buffer information
     load_files '+m +bi 'RETRIEVE_BUF_ID
  }
  first_buf_id=p_buf_id
  parse command with cmdname cmdline
  status=0
  if ( arg(2)=='' ) {
     index= find_index(cmdname,PROC_TYPE|COMMAND_TYPE)
     /* messageNwait('index='index' is callable='index_callable(index)' cmdname='cmdname) */
     if ( ! index_callable(index) ) {
       messageNwait(nls("Command '%s' not found",cmdname)". "get_message(rc));
       return(rc)
     }
  }
  for (;;) {
    _next_buffer 'HNR'     /* Must include hidden buffers, because */
                           /* active buffer could be a hidden buffer */
    buf_id=p_buf_id;
    if ( ! (p_buf_flags & HIDE_BUFFER) ) {
       if ( arg(2)=='' ) {
          status=call_index(cmdline,index)
       } else {
          execute(command);
          status=rc
       }
       if ( status ) {
          break
       }
    }
    if ( buf_id== first_buf_id ) {
      break
    }
  }
  _quit_view
  return(status)

}
_command save_all_forms()
{
   orig_wid=p_window_id;
   need_to_save_config=0;
   last=_last_window_id()
   for (i=1;i<=last;++i) {
      if (_iswindow_valid(i) && i.p_edit && i.p_object==OI_FORM &&
           i.p_object_modify) {
         p_window_id=i;refresh();_set_focus();
         result=_message_box(nls("Save changes to form '%s'?",p_name),'',MB_ICONQUESTION|MB_YESNOCANCEL)
         if (result==IDCANCEL) {
            return(COMMAND_CANCELLED_RC);
         }
         if (result==IDYES) {
            form_wid=i;
            status=form_wid._update_template()
            if (status<0) {
               _message_box(nls("Failed to update form '%s'.\n",form_wid.p_name)get_message(status))
               return(status)
            }
            form_wid.p_object_modify=0;
            _set_object_modify(status);
            need_to_save_config=1;
         }
      }
   }
   if (need_to_save_config) {
      status=save_config();
      if (status) {
         return(status);
      }
   }
   p_window_id=orig_wid
   return(0);
}
_command save_all() name_info(','VSARG2_NOEXIT_SCROLL|VSARG2_REQUIRES_MDI_EDITORCTL)
{
#if 1
   get_view_id(orig_view_id);
   orig_buf_id='';
   if (!_no_child_windows() && def_one_file=='') {
      orig_buf_id=_mdi.p_child.p_buf_id;
   }

   orig_mdi_child=_mdi.p_child;
   focus_wid=_get_focus();
   status=_open_temp_view('.command',temp_view_id,junk_view_id,'+b');
   if (status) {
      return(status);
   }
   _TagDelayCallList();
   sv_flags=arg(1);
   skip_unnamed_files=arg(2)!='' && arg(2);
   first_buf_id=p_buf_id;
   for (;;) {
      modify=p_modify;
      if (modify &&  _need_to_save() && (!skip_unnamed_files || p_buf_name!='')) {
         if (def_one_file!='') {
            if (orig_mdi_child!=HIDDEN_WINDOW_ID &&
                orig_mdi_child.p_buf_name==p_buf_name) {
               wid=orig_mdi_child;
            } else {
               wid=window_match(p_buf_name,1,'xn');
            }
            buf_name=p_buf_name;
            if (!wid) {
               status=_mdi.p_child.edit('+q +bi 'p_buf_id)
               if (status) {
                  _sv_message_box(sv_flags,nls("Unable to active file '%s'\n",buf_name)get_message(status))
                  break;
               }
            } else {
               // don't set focus here. _save_status function will set the
               // focus if there is an error.
               p_window_id=wid;
            }
            status=save('',sv_flags)
            if (status) {
               break;
            }
         } else {
            // -bp Don't reinsert buffer.
            buf_name=p_buf_name;
            status=_mdi.p_child.edit('-bp +q +bi 'p_buf_id);
            if (status) {
               _sv_message_box(sv_flags,nls("Unable to active file '%s'\n",buf_name)get_message(status));
               break;
            }
            status=_mdi.p_child.save('',sv_flags);
            if (status) {
               break;
            }
         }
      }
      activate_view(temp_view_id);
      // Include hidden, No old view info updating,
      // No refresh flag updating,
      _next_buffer('HNR');
      if ( p_buf_id==first_buf_id ) {
         status=0;
         break
      }
   }
   _delete_temp_view(temp_view_id);
   if (!status && focus_wid) {
      focus_wid._set_focus();
   }
   if (!status && orig_buf_id!='') {
      _mdi.p_child.p_buf_id=orig_buf_id;
   }
   _TagProcessCallList();
   return(status);
   // return(for_each_buffer('_maybe_save'))
#else
   _TagDelayCallList();
   sv_flags=arg(1);
   skip_unnamed_files=arg(2)!='' && arg(2);
   orig_wid=p_window_id;
   orig_view_id='';
   if (def_one_file!='') {
      orig_view_id=p_view_id
      activate_view HIDDEN_VIEW_ID
   }
   _safe_hidden_window();
   save_pos(p)
   first_buf_id=p_buf_id;
   do_delete_window=0;
   for (;;) {
      modify=p_modify;
      if (modify &&  _need_to_save() && (!skip_unnamed_files || p_buf_name!='')) {
         buf_name=p_buf_name
         if (def_one_file!='') {
            if (orig_wid.p_buf_name==p_buf_name) {
               wid=orig_wid;
            } else {
               wid=window_match(p_buf_name,1,'xn');
            }
            if (!wid) {
               status=orig_wid.edit('+q +bi 'p_buf_id)
               if (status) {
                  _sv_message_box(sv_flags,nls("Unable to active file '%s'\n",buf_name)get_message(status))
                  break;
               }
            } else {
               // don't set focus here. _save_status function will set the
               // focus if there is an error.
               p_window_id=wid;
            }
            status=save('',sv_flags)
            if (status) {
               break;
            }
            if (!wid) {
               _delete_window
            }
            activate_view HIDDEN_VIEW_ID
         } else {
            if (p_window_flags &HIDE_WINDOW_OVERLAP) {
               status=edit('+q +bi 'p_buf_id)
               if (status) {
                  _sv_message_box(sv_flags,nls("Unable to active file '%s'\n",buf_name)get_message(status))
                  break;
               }
               do_delete_window=1
            }
            status=save('',sv_flags)
            if (status) {
               break;
            }
         }

      }
      // Include hidden, No old view info updating,
      // No refresh flag updating,
      _next_buffer 'HNR'
      if ( p_buf_id==first_buf_id ) {
         status=0;
         break
      }
   }
   if (status) {
      // Force refresh flag updating.
      _next_buffer 'H';_prev_buffer 'H';
      buf_id=p_buf_id
      p_buf_id=first_buf_id
      restore_pos(p);
      p_buf_id=buf_id;
   } else if (do_delete_window) {
      _delete_window
      activate_view HIDDEN_VIEW_ID
   } else if (def_one_file==''){
      restore_pos(p);
   }
   if (p_view_id==HIDDEN_VIEW_ID && orig_view_id!='') {
      p_view_id=orig_view_id
   }
   _TagProcessCallList();
   return(status);
   // return(for_each_buffer('_maybe_save'))
#endif
}

#if 0
typeless _fast_call_list(list)
{
   for (;;) {
      parse list with index list
      if ( index=='' ) {
         break
      }
      if ( index_callable(index) ) {
         call_index(arg(2),arg(3),arg(4),arg(5),index)
      }
   }
}
#endif
void exit_list()
{
   // Don't want on_got_focus to call switchbuf list durring exit_list
   call_list('-exit-')

}
_command safe_exit(...) name_info(','VSARG2_EDITORCTL|VSARG2_REQUIRES_MDI)
{
   if (!p_mdi_child && !p_isbutton_bar && p_object==OI_EDITOR && 
          p_active_form.p_object==OI_FORM) {
      if (last_event():==A_F4) {
         call_event(defeventtab _ainh_dlg_manager,last_event(),'e');
      }
      return(1);
   }
   wid=_find_formobj('_diff_form','N');
   _nocheck _control _ctlfile1;
   _nocheck _control _ctlfile2;
   if (wid&&
       (wid._ctlfile1.p_modify ||
        wid._ctlfile2.p_modify) ) {
      _message_box(nls("Please close diff first"));
      wid._set_foreground_window();
      return(1);
   }
   if( index_callable(find_index('_ftpInProgress',PROC_TYPE)) && _ftpInProgress() ) {
      result=_message_box("There is an FTP operation in progress.\n\nDo you really want to exit?","",MB_YESNO|MB_ICONQUESTION);
      if( result!=IDYES ) return(1);
   }
   if (index_callable(find_index('_QueryEndSession',PROC_TYPE)) && _QueryEndSession()) {
      return(1);
   }
   // Under OS/2 Menu font can be changed by droping configured ICON onto
   // editor
   if (def_exit_flags&EXIT_CONFIRM) {
      result=_message_box(nls("Exit Visual SlickEdit?"),'',MB_YESNOCANCEL|MB_ICONQUESTION);
      if (result!=IDYES) return(1);
   }
   if (machine()=='OS2386' && _origMdiMenuFont!='' && _origMdiMenuFont!=_default_font(CFG_MENU)) {
      _config_modify|=CFGMODIFY_OPTION;
   }
   status=save_all_forms();
   if (status) {
      return(status);
   }
   status=list_modified(nls('Exiting with Modified Buffers'));
   if (status) {
      return(status);
   }
   if (def_exit_flags&EXIT_CONFIG_PROMPT) {
      status=gui_save_config();
      if (status) {
         return(status);
      }
   }else {  //if (def_exit_flags&EXIT_CONFIG_ALWAYS)
      status=save_config();
      if (status) {
         _message_box(nls("Could not save configuration.\n%s",get_message(status)));
         return(status);
      }
   }
   p_window_id=_mdi.p_child;
   if ( _process_info() ) {  /* is a process running ? */
      if ( def_exit_process ) {
         exit_process();
      } else {
         message nls('Please exit concurrent process.')
         return(1);
      }
   }
   // Update all Delphi buffers:
   // Need to do this before saving the window configuration file!
   if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
      if ( delphiIsRunning() ) { delphiUpdateCloseAll(0); }
   }
   {
      status=save_window_config('','','','',1 /* exiting editor */)
      if ( status ) {
         message get_message(status)
         return(status)
      }
   }
   exit_list();
   if ( machine() != "OS2386" && index_callable(find_index("delphiIsRunning",PROC_TYPE)) ) {
      if (delphiIsRunning()) { delphi_stop(); }
   }
   if (arg(1)=='') {
      exit(0);
   }
   return(0);
}
boolean last_buffer()
{
   info=buf_match('',1,'V')
   for (;;) {
      if ( rc ) { return(1) }
      parse info with buf_id modify buf_flags buf_name
      if ( p_buf_id!=buf_id ) {
         return(0)
      }
      info=buf_match('',0,'V')
   }
}
/*void _delete_tile_id()
{
   if ( !(p_window_flags & HIDE_WINDOW_OVERLAP ) && p_tile_id==arg(1) ) {
      quit_window()
   }
} */
void one_tile()
{
  if ( p_window_state=='M' && def_one_file=='') {
     if ( p_tile_id>0 ) {
        p_tile_id=-p_tile_id
     }
     /* remove tiled windows */
     //for_each_mdi_child('_delete_tile_id '(-p_tile_id),'',1)

     orig_wid=p_window_id;
     tile_id= -p_tile_id;
  
     for (wid=1;wid<=_last_window_id();++wid) {
        if (_iswindow_valid(wid) && wid.p_mdi_child && wid!=HIDDEN_WINDOW_ID &&
            wid.p_tile_id==tile_id && wid!=orig_wid) {
           wid._delete_window();
        }
     }
     p_window_id=orig_wid;

     p_tile_id=-p_tile_id;
  }

}
static typeless cv_key(key)
{
    name=name_on_key(key)
    if ( name=='cursor-left' ) {
       key=LEFT
    } else if ( name=='cursor-right' ) {
       key=RIGHT
    } else if ( name=='cursor-down' ) {
       key=DOWN
    } else if ( name=='cursor-up' ) {
       key=UP
    }
    return(key)

}
_command duplicate_window() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   status=edit('+i +bi 'p_buf_id)
   return(status);
}
_command create_tile() name_info(','VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
{
  message nls('Point to edge for new window with cursor keys')
  one_tile();
  mou_capture
  old_mouse_pointer=p_mouse_pointer;
  p_mouse_pointer=MP_SIZE;

  mou_get_xy mx,my
  x=p_x+p_width intdiv 2
  y=p_y+p_height intdiv 2
  _map_xy _mdi,0,x,y
  mou_set_xy x,y

  for (;;) {
    key=get_event()
    if ( iscancel(key) ) {
      cancel()
      p_mouse_pointer=old_mouse_pointer;
      mou_release
      mou_set_xy mx,my
      return(COMMAND_CANCELLED_RC)
    }
    key=cv_key(key)
    if ( key:==LEFT || key:==RIGHT ) {
      p_mouse_pointer=old_mouse_pointer;
      clear_message
      status=vsplit_window()
      if ( ! status && key:==LEFT ) {
         _prev_window 'H'
      }
      mou_release
      mou_set_xy mx,my
      return(status)
    } else if ( key:==UP || key:==DOWN ) {
      p_mouse_pointer=old_mouse_pointer;
      clear_message
      status=hsplit_window()
      if ( ! status && key:==UP ) {
         _prev_window 'H'
      }
      mou_release
      mou_set_xy mx,my
      return(status)
    }
  }


}
_command void one_window() name_info(','VSARG2_ICON|VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   if ( p_window_id==HIDDEN_WINDOW_ID ) {
      return;
   }
   /* quit all windows but the active window. */
   window_id= p_window_id
   for (;;) {
     _next_window('HF');
     if ( p_window_id== window_id ) { break }
     if ( p_window_id!=HIDDEN_WINDOW_ID ) {
        quit_window()
        if ( p_window_id==HIDDEN_WINDOW_ID ) {
           p_window_id=p_next;
           if ( p_window_id==HIDDEN_WINDOW_ID ) {
              break;
           }
        }
     }
   }
   /* Zoom the one window left. */
   p_window_state='M'

}
static void quit_window()
{
   window_id=p_window_id
   for (;;) {
      get_view_id start_view_id
      _quit_view
      get_view_id view_id
      if ( p_window_id!=window_id || start_view_id==view_id ) {
         break
      }
   }

}
_command void zoom_window() name_info(','VSARG2_ICON|VSARG2_READ_ONLY|VSARG2_REQUIRES_MDI_EDITORCTL)
{
   if ( p_window_state:=='M' ) {
      p_window_state='N'
   } else {
      p_window_state='M'
   }
}
void _on_close()
{
   // Save non active buffer cursor position information
   _next_buffer 'H';_prev_buffer 'H'
   close_window('',1 /* save buffer position */);
}
typeless _on_exit()
{
   status=safe_exit(1);
   return(status);
}
void _on_drop_files()
{
   if( upcase(_mdi.p_window_state)=='I' ) _mdi.p_window_state='N';
   for (;;) {
      filename=_next_drop_file();
      if (filename=='') break;
      status=edit(maybe_quote_filename(filename),VCF_AUTO_CHECKOUT|EDIT_RESTOREPOS);
      if (status) break;
   }
}

_str winlist_callback(event, var return_value, data);

static typeless curr_window_name;

//_command winlist() name_info(','VSARG2_READ_ONLY)
// This function is not called under windows.
_command void on_more_windows()
{
   _on_more_windows();
}
void _on_more_windows()
{
   curr_window_name=p_caption;
   _str awinname[];
   int awinid[];
#if 1
   orig_view_id=p_view_id;
   first_wid=p_window_id=_mdi.p_child;

   if (_no_child_windows()) {
      // This should never happen
      return;
   }
   for (;;) {
      if (p_window_id!=HIDDEN_WINDOW_ID) {
         inserted=1;
         if (p_DocumentName!='') {
            line=p_DocumentName;
         } else {
            line=p_buf_name;
         }
         awinname[awinname._length()]=line"\t"p_window_id;
      }
      _next_window('hf');
      if (p_window_id==first_wid) {
         break;
      }
   }
   p_view_id=orig_view_id;
#else
   last=_last_window_id();
   for (i=1;i<=last;++i) {
      if (_iswindow_valid(i) && i.p_window_id!=HIDDEN_WINDOW_ID
           && i.p_mdi_child /*&& !(i._mdi_child_in_menu()) */
           /*((option=='' || (option=='E' && i.p_edit) ||
                   (option=='N' && !i.p_edit)
           )*/
         ) {
         inserted=1;
         if (p_DocumentName!='') {
            awinname[awinname._length()]=i.p_DocumentName;
         } else {
            awinname[awinname._length()]=i.p_buf_name;
         }
         awinid[awinid._length()]=i;
      }
   }
#endif
   if (inserted==1) {
      awinname._sort(_fpos_case);
      for (i=0;i<awinname._length();++i) {
         parse awinname[i] with awinname[i] "\t" wid;
         awinid[awinid._length()]=wid;
      }
      result=show('-modal _sellist_form',
                  'Select Window',
                  SL_DEFAULTCALLBACK,
                  //SL_VIEWID|SL_DEFAULTCALLBACK,
                  //winname_view_id,
                  awinname,
                  '',//Buttons
                  '',//Help Item
                  '',//Font
                  winlist_callback);
      if (result!='') {
         NextWindow_wid=_mdi.p_child;
         final_wid=awinid[result-1];
         if (!(final_wid.p_window_flags & HIDE_WINDOW_OVERLAP) && 
              (_iswindow_valid(NextWindow_wid) && NextWindow_wid.p_mdi_child) &&
             final_wid!=NextWindow_wid) {
            if (_default_option(VSOPTION_NEXTWINDOWSTYLE)==1) {
               final_wid._MDIReorder(NextWindow_wid);
            } else if (_default_option(VSOPTION_NEXTWINDOWSTYLE)==0){
               NextWindow_wid._MDIReorder(final_wid);
            }
         }

         final_wid._set_focus();
      }
   }
   //_delete_temp_view(winid_view_id);
}

_str winlist_callback(event, var return_value, data)
{
   switch (event) {
   case SL_ONINIT:
      _sellist._lbsearch(curr_window_name);
      line=_sellist.p_line;
      _sellist._lbtop();_sellist._lbup();
      while (!_sellist._lbdown()) {
         if (line==_sellist.p_line) {
            break;
         }
      }
      _sellist._lbselect_line();
      return('');
   case SL_ONDEFAULT:
      return_value=_sellist.p_line;
      return(0);
   }
   return("");
}
