/*
ͻ
 What's it called: EPMGCC  V3.20                                              
                                                                              
 What does it do:  The E source code for the GCC-Interface for EPM.           
                   This file contains the command definitions for the         
                   toolbar-support for EPMGCC.                                
                   Note: Add the line                                         
                           gccactn                                            
                         to your ACTIONS.LST file.                            
                                                                              
 Who and When:     B. Bablok 12/93 - 07/96                                    
                                                                              
ͼ
*/

CONST
   WANT_DYNAMIC_PROMPTS = 1  -- Force definition of menu prompts in ENGLISH.E.
   GCC_ACTION = 'GCC Actions'

INCLUDE 'stdconst.e'
INCLUDE 'gccconst.e'
INCLUDE 'english.e'
INCLUDE 'menuhelp.h'
/*
Ŀ
  Building actionlist lines                                                   

*/
DEFC gccactn_actionlist
   UNIVERSAL ActionsList_FileID  -- This is the fileid that gets the line(s)

INSERTLINE "gccOpenProject"GCC_OPEN__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccSelectProject"GCC_SEL__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccEditProject"GCC_EDIT__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccCloseProject"GCC_CLOSE__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccSetCompOptions"GCC_COMP_OPT__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccCompileFile"GCC_COMP__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccSetMakeOptions"GCC_BUILD_OPT__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccBuildProject"GCC_BUILD__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccViewResults"GCC_VIEW__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccRunExe"GCC_RUN__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccDebugExe"GCC_DEBUG__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccToggleDebugMode"GCC_DEBUGMODE__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccToggleAutosaveMode"GCC_AUTOSAVE__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccToggleVerboseMode"GCC_VERBOSE__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccToggleRemoveMode"GCC_REMOVE__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccPrevErr"GCC_PREV_ERR__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccCurrErr"GCC_CURR_ERR__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
INSERTLINE "gccNextErr"GCC_NEXT_ERR__MSG"gccactn", ActionsList_FileID.last+1, ActionsList_FileID
/*
Ŀ
  Command definitions (toolbar commands)                                      

*/
DEFC gccOpenProject =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_OPEN__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_open_project'                -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_OPEN__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccSelectProject =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_SEL__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_select_project'                -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_SEL__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccEditProject =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_EDIT__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_edit_project'                -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_EDIT__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccCloseProject =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_CLOSE__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_close_project'                -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_CLOSE__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccSetCompOptions =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_COMP_OPT__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      IF gcc_is_cc_file() THEN
        'gcc_set_comp_options'
      ELSE
        SAYERROR 'No c/cc-file'
      ENDIF
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_COMP_OPT__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccCompileFile =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_COMP__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      IF gcc_is_cc_file() THEN
        'gcc_compile_file'
      ELSE
        SAYERROR 'cannot compile' .filename
      ENDIF
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_COMP__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccSetMakeOptions =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_BUILD_OPT__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      IF gcc_project_open() THEN
        'gcc_set_make_options'
      ELSE
        SAYERROR 'no project open'
      ENDIF
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_BUILD_OPT__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccBuildProject =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_BUILD__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      IF gcc_project_file_exists() THEN
        'gcc_build_project'
      ELSE
        SAYERROR 'project file does not exist'
      ENDIF
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_BUILD__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccViewResults =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_VIEW__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_view_results'          -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_VIEW__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccRunExe =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_RUN__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_run_exe'          -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_RUN__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccDebugExe =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_DEBUG__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_debug_exe'          -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_DEBUG__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccToggleDebugMode =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_DEBUGMODE__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_toggle_debug_mode'          -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_DEBUGMODE__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccToggleAutosaveMode =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_AUTOSAVE__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_toggle_autosave_mode'          -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_AUTOSAVE__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccToggleVerboseMode =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_VERBOSE__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_toggle_verbose_mode'          -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_VERBOSE__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccToggleRemoveMode =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_REMOVE__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_toggle_remove_mode'          -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_REMOVE__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccPrevErr =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_PREV_ERR__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_prev_err'                    -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_PREV_ERR__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccCurrErr =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_CURR_ERR__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_curr_err'                    -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_CURR_ERR__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF

DEFC gccNextErr =
   PARSE ARG action_letter parms
   IF action_letter = 'I' THEN       -- button Initialized
      DISPLAY -8
      SAYERROR GCC_NEXT_ERR__MSG
      DISPLAY 8
   ELSEIF action_letter = 'S' THEN   -- button Selected
      SAYERROR 0                        -- Clear prompt
      'gcc_next_err'                    -- execute action
   ELSEIF action_letter = 'H' THEN   -- button Help
      CALL WINMESSAGEBOX(GCC_ACTION,GCC_NEXT_ERR__MSG,
                                               MB_OK+MB_INFORMATION+MB_MOVEABLE)
   ELSEIF action_letter = 'E' THEN   -- button End
;;    SAYERROR 0
   ENDIF
