/*
ͻ
 What's it called: EPMGCC  V3.00                                              
                                                                              
 What does it do:  The E source code for the GCC-Interface for EPM.           
                   This file contains the code for the error parser of        
                   compile time errors issued by ICC.                         
                   This module is linked seperately to allow the user to      
                   change the error-parser during runtime. See the            
                   documentation for details.                                 
                                                                              
 Who and When:     B. Bablok 12/93 - 07/96                                    
                                                                              
ͼ
*/
DEFC gcc_parse_error =
   UNIVERSAL gcc_error_file_id, gcc_other_file_id, gcc_error_file,
             gcc_line2index, gcc_index2err, gcc_error_index

   parse_all = ARG(1) <> ''
   error_no = 0

   WHILE (.line <= .last) DO           -- iterate until a "true" error is found
     GETLINE  line

      IF POS(":",WORD(line,1)) = 0 THEN
         lineno = 'junk'
      ELSEIF SUBSTR(line,2,1) = ":" THEN
         PARSE VALUE line WITH drive ":" filename "(" lineno ":"  col ")" ":" . ":" gcc_message
         filename = drive":"filename
      ELSE
         PARSE VALUE line WITH filename "(" lineno ":"  col ")" ":" . ":" gcc_message
      ENDIF

     IF NOT ISNUM(lineno) THEN
       IF .line = .last THEN
          IF NOT parse_all THEN
             ACTIVATEFILE gcc_other_file_id
             SAYERROR "No more errors!"
          ELSE
             DO_ARRAY 2, gcc_line2index, 0, error_no
             DO_ARRAY 2, gcc_index2err, 0, error_no
          ENDIF
          RETURN
       ELSE                           -- try the next line
         "+1"
       ENDIF

     ELSEIF NOT parse_all THEN                              -- found an error
       "EDIT" TRANSLATE(filename,'\','/') "'gcc_setpos "lineno col"'"
       SAYERROR gcc_message
       RETURN

     ELSE
       error_no = error_no + 1
       DO_ARRAY 2, gcc_line2index, .line, error_no
       DO_ARRAY 2, gcc_index2err, 'line.'error_no, lineno
       DO_ARRAY 2, gcc_index2err, 'col.'error_no, col
       DO_ARRAY 2, gcc_index2err, 'file.'error_no, filename
       DO_ARRAY 2, gcc_index2err, 'msg.'error_no, gcc_message
       line = .line
       DO_ARRAY 2, gcc_index2err, 'orig.'error_no, line
       IF .line = .last THEN
          DO_ARRAY 2, gcc_line2index, 0, error_no
          DO_ARRAY 2, gcc_index2err, 0, error_no
          RETURN
       ELSE
         "+1"
       ENDIF
     ENDIF
   ENDWHILE
