/*
                   ͻ
                     Tiled  WINDOWING   
                   ͼ
                            and
                 ͻ
                   Messy desk WINDOWING   
                 ͼ
*/
compile if WANT_WINDOWS                           -- <<<<<<<<<<<<<<<<<<<<<<<<<<<

;  Note:  This file is not used at all by EPM.

/**********************   KEYS  **********************************************/
;  The following definitions occur in STDKEYS.E
; def c_w = call pnextwindow()
; def c_z= call pzoom()
; def c_a =call pnextwindowstyle()
; def f10= call pnextfile()
; def a_f10=call pprevfile()
; def c_v=call psplitv()
; def c_h=call psplith()
; def a_4=call psplit4()

/**********************   PROCEDURES   ***************************************/
defproc start_screen
   universal stage
   universal ZoomWindowStyle
   universal messy

   stage = 1
   call remove_all_but_one()
   call setzoomwindow(ZoomWindowStyle,1,1,screenheight(),screenwidth())
compile if JHwindow
   if not messy then
      .boxheight=screenheight()+10
   endif
compile else
   if messy then
      call sizepopup(1,1,screenwidth(),screenheight()-1)
   else
      .boxheight=screenheight()+10
   endif
compile endif

defproc set_window(x,y,w,h)
   call init_window(x+1,y+1,w-2,h-2)
   .box          = 1
   .boxheight    = h
   .messagex     = 1
   .messagey     = screenheight()
   .commandy     = screenheight()-1
   .commandx     = 1
   .commandwidth = screenwidth()
   .filenamey    = y
   .filenamex    = x+2
   .filenamewidth= min(w-4,screenwidth()%2)
   .statuswidth  = .filenamewidth         /* min(w-4,screenwidth()%2) */
   .statusy      = y+h-1
   .statusx      = .filenamex             /* x+2            */
   call make_status_fit()

defproc vertical2
   universal messy
   wdiv2=screenwidth()%2
   call remove_all_but_one()
   call set_window(1,1,wdiv2,screenheight()-2)
   newwindow 'A'
   call set_window(wdiv2+1,1,wdiv2,screenheight()-2)
   if messy then prevwindow; .box=2
   else call pnextwindow() endif
compile if SHOW_MODIFY_METHOD
   correct_modify_color()
compile endif

defproc horizontal2
   universal messy
   hdiv2=(screenheight()-1)%2
   call remove_all_but_one()
   call set_window(1,1,screenwidth(),hdiv2)
   newwindow 'A'
   call set_window(1,hdiv2+1,screenwidth(),screenheight()-hdiv2-2)
   if messy then prevwindow; .box=2
   else call pnextwindow() endif
compile if SHOW_MODIFY_METHOD
   correct_modify_color()
compile endif

defproc four_guys
   universal messy
   wdiv2=screenwidth()%2
   hdiv2=(screenheight()-1)%2
   call remove_all_but_one()
   call set_window(1,1,wdiv2,hdiv2)
   newwindow 'A'
   call set_window(wdiv2+1,1,wdiv2,hdiv2)
   newwindow 'A'
   call set_window(wdiv2+1,hdiv2+1,wdiv2,screenheight()-hdiv2-2)
   newwindow 'A'
   call set_window(1,hdiv2+1,wdiv2,screenheight()-hdiv2-2)
   if messy then prevwindow; prevwindow; prevwindow; .box=2
   else call pnextwindow() endif
compile if SHOW_MODIFY_METHOD
   correct_modify_color()
compile endif

defproc make_status_fit
   sw = .statuswidth
   if sw>38 then
         /* Sample:                                        */
         /*' Line nnnnnn  Col nnn  Replace  E vvvv  '      */
         /* 0*1*2*3*4      */
         /* 0         0         0         0         0      */
      .linex        = .statusx+6
      .colx         = .statusx+18
      .insertx      = .statusx+23
      .insertwidth  = 7
      .statustext=' Line         Col                E 'EVERSION' '
   elseif sw>22 then
      .linex        = .statusx+6
      .colx         = .statusx+18
      .insertx      = .statusx+23
      .statustext   = ' Line        Col '
      if sw>29 then
         .insertwidth=7
      elseif sw>25 then
         .insertwidth=3
      else
         .insertwidth=1
      endif
   elseif sw >15 then             /* 0123456789ABCDEF */
     .linex        = .statusx+2   /* L nnnnnn C nnn R */
     .colx         = .statusx+11
     .insertx      = .statusx+15
     .statustext   = 'L        C  '
     .insertwidth=1
   elseif sw>9 then
      .linex        = .statusx
      .colx         = .statusx+7
      .insertx      = 0
      .statustext   = ''
   endif

defproc remove_all_but_one
   /* delete multiple views of all files in all windows but current */
   startw=.windowid
   nextwindow
   loop        /* for all windows */
      getfileid s
      w=.windowid
      /* done? */
      if w=startw then leave endif
      /* get the first file in the next window in case we delete
         this window */
      nextwindow
      getfileid nextw
      activatefile s
      loop       /* for all files in the window */
         if .views > 1 then
            quitview
            /* quitting changes window if it's the last file */
            if .windowid<> w then
               /* next window before the quitview */
               activatefile nextw
               leave
            endif
            getfileid s
            iterate
         endif
         nextfile
         getfileid n
         /* done? */
         if n==s then nextwindow; leave endif
      endloop
   endloop
compile if SHOW_MODIFY_METHOD
   correct_modify_color()
compile endif

defproc pnextwindow()   /* next window */
   .box = 1
   nextwindow
   .box =2
   call select_edit_keys()

defproc pzoom()   /* zoom window */
   call start_screen()
compile if SHOW_MODIFY_METHOD
   correct_modify_color()
compile endif

defproc pnextwindowstyle()
   universal stage
   if  stage=1 then
      stage=2
      call vertical2()
   elseif stage=2 then
      stage=3
      call four_guys()
   elseif stage=3 then
      stage=4
      call horizontal2()
   else
      call start_screen()
   endif

defproc pnextfile()  -- Ver. 4.11:  Optional argument says to skip select_edit_keys
   universal ZoomWindowStyle,messy
   if messy then
      .box = 1
      nextwindow
      .box=2
   else
      next_file
   endif
   if arg(1) then return; endif
   call select_edit_keys()
compile if JHwindow
   if messy & (ZoomWindowStyle=5) then   -- Make sure filename is displayed
      refresh
      command_toggle; command_toggle
   endif
compile endif

defproc pprevfile()  -- Ver. 4.11:  Optional argument says to skip select_edit_keys
   universal ZoomWindowStyle,messy
   if messy then
      .box = 1
      prevwindow
      .box=2
   else
      prevfile
   endif
   if arg(1) then return; endif
   call select_edit_keys()
compile if JHwindow
   if messy & (ZoomWindowStyle=5) then   -- Make sure filename is displayed
      refresh
      command_toggle; command_toggle
   endif
compile endif

defproc psplitv()
   universal stage
   stage=2
   call vertical2()

defproc psplith()
   universal stage
   stage=4
   call horizontal2()

defproc psplit4()
   universal stage
   stage=3
   call four_guys()

defproc setzoomwindow(style,x,y,scrheight,scrwidth)
    universal messy
   .messagewidth= scrwidth

   if style=1 then
      call windowstyle1(x,y,scrheight,scrwidth)
      .filenamecolor=FILENAMECOLOR;.monofilenamecolor=MONOFILENAMECOLOR
      .statuscolor=STATUSCOLOR;.monostatuscolor=MONOSTATUSCOLOR
   elseif style=2 then
      call windowstyle1(x,y,scrheight,scrwidth)
      .windowheight=.windowheight+1
      .commandy=.commandy+1
      .commandwidth=scrwidth-.statuswidth
      .filenamecolor=.commandcolor;.monofilenamecolor=.monocommandcolor
      .statuscolor=.commandcolor;.monostatuscolor=.monocommandcolor
   elseif style=3 then
      /* how about filename and status at the top */
      call setzoomwindow(2,x,y,scrheight,scrwidth)
      .windowy=.windowy+1
      .windowheight=.windowheight-1
      .commandwidth=scrwidth
      .filenamey=y;.statusy=y
      .filenamecolor=FILENAMECOLOR;.monofilenamecolor=MONOFILENAMECOLOR
      .statuscolor=STATUSCOLOR;.monostatuscolor=MONOSTATUSCOLOR
   elseif style=4 then
      /* how about filename and status at the top */
      /* and the command line at the top */
      call setzoomwindow(3,x,y,scrheight,scrwidth)
      .windowy=.windowy+1
      .commandy=2
   elseif style=5 then          -- Minimalist style from Jim Hurley
; Only one display line used for non-file display.  Messages may be truncated.
      call windowstyle1(x,y,scrheight,scrwidth)
      .windowheight=.windowheight+2
      .commandy=.commandy+2
      .statusy=.statusy+1
      .filenamey=.filenamey+1
      .commandwidth=scrwidth-.statuswidth
      .messagewidth=.commandwidth
      .messagex=.commandx;.messagey=.commandy
      .filenamecolor=.commandcolor;.monofilenamecolor=.monocommandcolor
      .statuscolor=.commandcolor;.monostatuscolor=.monocommandcolor
      .functionkeytextcolor=.commandcolor
      .monofunctionkeytextcolor=.monocommandcolor
      .messagecolor=.commandcolor;.monomessagecolor=.monocommandcolor
      /* We want only a single display line */
      .functionkeytextheight=0
   endif

; Ver. 4.11:  Optional fifth argument (box style).  Normally, this routine is
; called to create an E window.  If the fifth argument is present, this routine
; will act like sizelist:  pops up a window, omitting status line stuff.
defproc sizepopup(x,y,w,h)     /*box */
   universal ZoomWindowStyle,messy
   sw=screenwidth()
   sh=screenheight()
   oldboxwidth=.boxwidth
   oldboxx = .boxx
   .boxx         = max(min(x,sw-3),0)  -- JHWindow
   .boxwidth     = max(10,min(w,sw+2 - .boxx))  -- JHWindow
   if arg(5)='' then
      if .boxwidth<17 then
        .boxx = oldboxx
        .boxwidth=oldboxwidth
        return ''
      endif
      .box          = 2
   else
      .box          = arg(5)
   endif
   .boxy         = max(min(y,sh-5),0)
compile if JHwindow
   minboxheight= sh-.boxy
   if messy & arg(5)='' then
      if ZoomWindowStyle<>2 and ZoomWindowStyle<>5 then
         minboxheight=minboxheight-1
      elseif ZoomWindowStyle=5 then
         minboxheight=minboxheight+1
      endif
   endif
   .boxheight    = max(3,min(h,minboxheight))  -- JHWindow
compile else
   .boxheight    = max(3,min(h,sh-1 - .boxy - (ZoomWindowStyle=1)))
compile endif
   .windowx      = .boxx+1
   .windowy      = .boxy+1
   .windowwidth  = .boxwidth-2
   .windowheight = .boxheight-2
   if arg(5)<>'' then
      .linex        = 0
      .colx         = 0
      .insertx      = 0
      .statusx      = 0
      .filenamex    = 0
      return
   endif
compile if JHwindow
   .filenamey    = .boxy+.boxheight-1   /* put name   on bottom of box */ -- JHW
compile else
   .filenamey    = .boxy
compile endif
   .filenamex    = .boxx+2
   .filenamewidth= min(.boxwidth-4,40)
   .statuswidth  =.filenamewidth
   .statusx      =.filenamex
compile if JHwindow
   .statusy      = .boxy                /* put status on top    of box */ -- JHW
compile else
   .statusy      =.boxy+.boxheight-1    /* put status on bottom of box */
compile endif
   call make_status_fit()
   if .commandy<screenheight()-1 then
      .commandy=screenheight()-1
   endif
   .commandwidth=sw; .messagewidth=sw
   .filenamecolor = FILENAMECOLOR; .monofilenamecolor = MONOFILENAMECOLOR
   .statuscolor=STATUSCOLOR;.monostatuscolor=MONOSTATUSCOLOR
   if ZoomWindowStyle=1 and not messy then
      .commandy=.commandy-1
   endif

defproc windowstyle1(x,y,scrheight,scrwidth)
   call init_window(x,y,scrwidth,scrheight-3)
   .box          = 0
   .boxheight    = .windowheight +4
   .commandy     = scrheight-2
   .commandx     = x
   .commandwidth = scrwidth
   .filenamey    = scrheight-1
   .filenamex    = x
   .filenamewidth= scrwidth%2
   .statusy      = .filenamey         /* scrheight-1  */
   .statusx      = .filenamewidth+1   /* scrwidth%2+1 */
   .statuswidth  = .filenamewidth     /* scrwidth%2   */
   .statuscolor  = STATUSCOLOR; .monostatuscolor = MONOSTATUSCOLOR
   .commandcolor = COMMANDCOLOR;.monocommandcolor=MONOCOMMANDCOLOR
   .functionkeytextheight=1
   call make_status_fit()

/**********************   COMMANDS  ******************************************/

defc windowstyle,ws=
   universal ZoomWindowStyle,messy
   w=arg(1)
   if w=1 or w=2 or w=3 or w=4 or w=5 then
      ZoomWindowStyle=w
      call start_screen()
   else
      sayerror ZOOM_PROMPT__MSG ZoomWindowStyle'. 'CHOICES_ARE__MSG '1,2,3,4,5'
   endif


defc drag=
   universal messy

   if messy then
      sayerror DRAG__MSG
      loop
        hit_key = getkey()
        if hit_key=enter or hit_key=esc then
          leave
        endif
        if hit_key=right then
          call sizepopup(.boxx+1,.boxy,.boxwidth,.boxheight)
        elseif hit_key=left then
          call sizepopup(.boxx-1,.boxy,.boxwidth,.boxheight)
        elseif hit_key=up then
          call sizepopup(.boxx,max(.boxy-1,1),.boxwidth,.boxheight)
        elseif hit_key=down then
          call sizepopup(.boxx,.boxy+1,.boxwidth,.boxheight)
        endif
        refresh
        while testkey()<>'' do
          k=getkey()
        endwhile
      endloop
      sayerror 0
   else
      sayerror 'DRAG' MESSY_ONLY__MSG
   endif

defc size=
   universal messy

   if messy then
      sayerror DRAG__MSG
compile if JHwindow
      if not .boxy then .boxy=1; endif
compile endif
      loop
         hit_key = getkey()
         if hit_key=enter or hit_key=esc then
            leave
         endif
         if hit_key=right then
            call sizepopup(.boxx,.boxy,.boxwidth+1,.boxheight)
         elseif hit_key=left then
            call sizepopup(.boxx,.boxy,.boxwidth-1,.boxheight)
         elseif hit_key=up then
            call sizepopup(.boxx,.boxy,.boxwidth,.boxheight-1)
         elseif hit_key=down then
            call sizepopup(.boxx,.boxy,.boxwidth,.boxheight+1)
         endif
         refresh
         while testkey()<>'' do
            k=getkey()
         endwhile
      endloop
      sayerror 0
   else
      sayerror 'SIZE' MESSY_ONLY__MSG
   endif


;  SZOOM   This command gets executed automatically by E, whenever E detects
;          that the screen size (rows or columns) has changed after a DOS
;          shell.  This does automatic resizing.
;          It tries to preserve whatever window configuration the user had.
defc szoom
   universal stage                /* window type */
   universal ZoomWindowStyle      /* 4 different window style types */
   universal messy                /* messy or tiled windows */

      -- 4.10:  make sure ALL windows get resized, in case editing multiple
      -- files in messy mode.  Go around the windows till return to start.
      -- Note:  This has the effect of zooming ALL windows to full-screen (as
      -- if you pressed Ctrl-Z), even if you'd resized them with SIZE/DRAG.
   call remove_all_but_one()    -- Don't start on a window that gets deleted.
   startwindowid = .windowid
compile if JHWindow
   if messy then stage = 1; endif
compile endif
   loop
compile if JHWindow=0
      if messy then                  /* messy windows */
         call setzoomwindow(ZoomWindowStyle,1,1,screenheight(),screenwidth())
         sizepopup(1,1,screenwidth(),screenheight()-1)   -- This sets .box=2.
;;       if .windowid <> startwindowid then .box=1; endif
      else                                      /* tiled windows */
compile endif
         if stage=1 then        /* what type of window ? */
            call start_screen() /* regular */
         elseif stage=2 then
            call vertical2()    /* vertical window (2 view boxes) */
         elseif stage=3 then
            call four_guys()    /* four view boxes */
         elseif stage=4 then
            call horizontal2()  /* horizontal window (2 view boxes) */
         else
            call start_screen() /* default regular */
         endif
compile if JHWindow=0
      endif
compile endif
      nextwindow
      if .windowid = startwindowid then leave endif
      .box = 1              -- Only the active window should get .box=2.
   endloop


; jbl 2/5/89:  The DEFMODIFY method of setting color to show modified status
; works fine in EPM, which doesn't have split-screen windowing.  But in EOS2
; the user can hit a key like Ctrl-Z which does not change the fileid nor the
; modified state, but does change the screen colors.  So the DEFMODIFY event
; does not get invoked afterward and the colors are not corrected.
; This procedure checks for this situation (.modify > 0 but color wrong)
; and should be called after any split- or zoom-screen operation.
; LAM 2/10/89: For E3, there's no DEFMODIFY, but we do handle SHOW_MODIFY_METHOD
; in SELECT.E, so the following is needed for E3 and EOS2FAM, also.
;
; Remember that this file is not used at all by EPM, so no need to check that.
;
 compile if SHOW_MODIFY_METHOD
defproc correct_modify_color()
   if .modify then
  compile if SHOW_MODIFY_METHOD = 'FKTEXTCOLOR'
      .functionkeytextcolor= MODIFIED_FKTEXTCOLOR
  compile elseif SHOW_MODIFY_METHOD = 'COLOR'
      .markcolor= MODIFIED_MARKCOLOR
      .windowcolor= MODIFIED_WINDOWCOLOR
  compile elseif SHOW_MODIFY_METHOD = 'TITLE'
      .filenamecolor= MODIFIED_FILENAMECOLOR
      .monofilenamecolor= MODIFIED_MONOFILENAMECOLOR
  compile endif
   endif
 compile endif


compile else        -- Don't want windows, so give minimum support:  <<<<<<<<<<<

;  SZOOM   This command gets executed automatically by E, whenever E detects
;          that the screen size (rows or columns) has changed after a DOS
;          shell.  This does automatic resizing.
defc szoom
   startwindowid = .windowid
   loop
      call start_screen()
      nextwindow
      if .windowid = startwindowid then leave; endif
   endloop

defproc start_screen
   scrheight=screenheight(); scrwidth=screenwidth()
   .messagewidth= scrwidth
   call init_window(1,1,scrwidth,scrheight-3)
   .box          = 0
   .boxheight    = .windowheight +4
   .commandy     = scrheight-2
   .commandx     = 1
   .commandwidth = scrwidth
   .filenamey    = scrheight-1
   .filenamex    = 1
   .filenamewidth= scrwidth%2
   .statusy      = .filenamey         /* scrheight-1  */
   .statusx      = .filenamewidth+1   /* scrwidth%2+1 */
   .statuswidth  = .filenamewidth     /* scrwidth%2   */
   .statuscolor  = STATUSCOLOR; .monostatuscolor =MONOSTATUSCOLOR
   .commandcolor = COMMANDCOLOR;.monocommandcolor=MONOCOMMANDCOLOR
   .functionkeytextheight=1
;    make_status_fit --Limited version; just support 80 or 40 byte wide screen
   if .statuswidth>38 then
         /* Sample:                                        */
         /*' Line nnnnnn  Col nnn  Replace  E vvvv  '      */
         /* 0*1*2*3*4      */
         /* 0         0         0         0         0      */
      .linex        = .statusx+6
      .colx         = .statusx+18
      .insertx      = .statusx+23
      .insertwidth  = 7
      .statustext=' Line         Col                E 'EVERSION' '
    else                             /* 0123456789ABCDEF */
       .linex        = .statusx+2    /* L nnnnnn C nnn R */
       .colx         = .statusx+11
       .insertx      = .statusx+15
       .statustext   = 'L        C  '
       .insertwidth=1
    endif
   .boxheight=screenheight()+10
   .filenamecolor=FILENAMECOLOR; .monofilenamecolor=MONOFILENAMECOLOR

defproc pnextfile()
   next_file
   if arg(1) then return; endif
   call select_edit_keys()

defproc pprevfile()
   prevfile
   if arg(1) then return; endif
   call select_edit_keys()

compile endif                                     -- <<<<<<<<<<<<<<<<<<<<<<<<<<<

defproc init_window(x,y,w,h)
   .functionkeytextcolor=FUNCTIONKEYTEXTCOLOR
   .monofunctionkeytextcolor=MONOFUNCTIONKEYTEXTCOLOR
   .windowcolor     =WINDOWCOLOR
   .monowindowcolor =MONOWINDOWCOLOR
   .boxcolor        =BOXCOLOR
   .monoboxcolor    =MONOBOXCOLOR
   .cursorcolor     =CURSORCOLOR
   .monocursorcolor =MONOCURSORCOLOR
   .markcolor       =MARKCOLOR
   .monomarkcolor   =MONOMARKCOLOR
   .messagecolor    =MESSAGECOLOR
   .monomessagecolor=MONOMESSAGECOLOR
   .messagey        =screenheight()
   .windowx         =x
   .windowy         =y
   .windowwidth     =w
   .windowheight    =h
   .boxx            =x-1
   .boxwidth        =w+2
   .boxy            =y-1


