/*ͻ
 What's it called: ERES.H                                                               
                                                                                        
 What does it do : bindings to ETKRxxx.DLL: Protypes and structures                     
                                                                                        
 Who and When    : Gennaro A. Cuomo                              10 -88                 
                                                                                        
*/

#if OS2VERSION == 20
   #define MSG ULONG
#else
   #define MSG USHORT
#endif

/*ͻ
 The following are Structures used to Communicated with ERES.DLL    GC 9-89 
*/
// For testing, we use 10 items & 513 bytes (must be > MAXRETRIEVESTR)
#define RETRIEVENUM  40              // number of items in a retrieve list
#define MAXFILENAME  260
#define MAXRETRIEVESTR 512           // maximum size of string
#define MAXRETRIEVEBUFFER 1500 // 0x50   // 0x1000     // size of retrieve list data area
// Total space = (RETRIEVENUM * 4 + MAXRETRIEVEBUFFER) * 3
//  *4 is 4 bytes/pointer; *3 is for the 3 structures - cmdline, msgbox, file dialog
/*Ŀ
 List structure used to store various types of retrieve box entries         
*/

// The Oldest element in the retrieve list always one greater than MostRecent
#define  RETRIEVE_OLDEST(pList) (pList->MostRecent+1) % pList->Size
typedef struct LISTDLG_TYPE {
   SHORT       MostRecent;            // index of the item most recently added
   SHORT       Size;                  // last legal index
                                      // pointers to retrievable list
   PSZ         pListBuffer;           // pointer to a buffer of null terminated
                                      //   strings
   PSZ         pNextItem;             // pointer to the next free item in the
                                      //   List buffer
   PSZ         Retrieve[RETRIEVENUM]; // pointers into the pListBuffer

   //---------- Items needed for PM List Box Searching

   USHORT     LastSearchItem, EntryChange;

} LISTDLG;
typedef LISTDLG  *PLISTDLG;
typedef LISTDLG  DLGLIST;
typedef LISTDLG  *PDLGLIST;

/*Ŀ
 Shared Data Between EPM and ERES.                                          
*/
typedef struct EPMRES_TYPE {
   HWND    hwndAppFrame;            // application window frame  handle
   HWND    hwndAppClient;           // application window client handle
   HWND    hwndActiveEdit;          // current edit window handle
   HWND    hwndSearchReplaceBox;    // search replace dialog handle, modeless
   HWND    hwndCommandDlg;          // command line dialog handle, modeless
   CHAR    exfilename[MAXFILENAME]; // pointer to main ex file (configure option)
   LISTDLG cmd;                     // command line structure
   LISTDLG msgbox;                  // message box dialog structure
   LISTDLG open1;                   // message box dialog structure
   BOOL    skipopen1;               // if set file list dialog will be displayed first.
   CHAR    IniApplicationName[20];  // used to save and retrieve 'ini' data
   CHAR    searchpath[MAXFILENAME]; // path used to search for profile data
   HINI    hini;                    // handle to an opened INI profile
} EPMRES;
typedef EPMRES  *PEPMRES;        // pointer to the EPM resource shared structure

typedef struct {
   HWND hwndESrv;
   USHORT count;
} SHRSEM, *PSHRSEM;

//E Window Linked List Node
typedef struct _EWINDOWLLNODE {
   HWND                    hwnd;  //handle of the edit window
   HWND                    hwndWPSObject;  // handle of the WPS Object
   struct _EWINDOWLLNODE   *next;
} EWINDOWLLNODE;
typedef EWINDOWLLNODE *PEWINDOWLLNODE;
typedef EWINDOWLLNODE WNDLIST;
typedef WNDLIST *HWNDLIST;
typedef HWNDLIST *PHWNDLIST;

typedef HWND       EXPENTRY WINFILEDLG(HWND h1, HWND h2, PVOID p3);
typedef WINFILEDLG * PWINFILEDLG;
/*Ŀ
 Main Info structure                                                        
*/
typedef struct {
    USHORT      size;
    HAB         hAB;                 // application anchor block
    EPMRES      eres;                // pointer to shared buffer w ERES.DL
    HMODULE     eresModule;          // module handle of ETKRnnn.DLL
    PFNWP       DefFrameProc;        // address of the default frame proc
    PSHRSEM     pShrSem;             // pointer to EPM's shared msg buffer
    SWP         swp;                 // edit window rectangle
    USHORT      stagcount;           // stagger window count
    CHAR        LastCmdLine[256];    // last command line used2 open ewnd
    CHAR        EPMClass[32];        // EPM window class name
    CHAR        EWFrameClass[32];    // Edit Window Frame Class Name
    CHAR        AllowMultProcesses;
    HWND        hwndHelpInstance;    // hooks for info pres facil
    HELPINIT    hmiHelpData;
    USHORT      ApplicationID;
    CHAR        ApplicationName[20];     // Name of application */
    ULONG       EditWindowListStyle;
    CHAR        ExePath[MAXFILENAME+1];
    ULONG       ProfileFlags;
    ULONG       SaveFileType;
    // The following are functions that can be found in the E???.DLL
    // These functions are used to create, manipulate, and destroy edit windows.
    VOID       PFUNC(ETKENTRY, EpmEditVersion)(PSZ);
    PSZ        PFUNC(ETKENTRY, EpmRegisterEditWindow)(HAB);
    PSZ        PFUNC(ETKENTRY, EpmRegisterEditWindowFrame)(HAB);
    USHORT     CodePage;
    BOOL       onDBCS;
    PHELPTABLE HelpTable;
    BOOL       InputHookReleased;
    BOOL       PFUNC(EXPENTRY, InputHook)(HAB, PQMSG, USHORT);
    PEWINDOWLLNODE EWindowLL;
    HWND       hwndmem;
    BOOL       EditWndSubclassed;
    ULONG      DialogFlags;
    CHAR       WFErrorFileName[MAXFILENAME+1];
} GLOBDATA;
typedef GLOBDATA *PGLOBDATA;

#define DF_CMDBOX_UP    1
#define DF_MSGBOX_UP    2

/* Constants used to set the EditWindowStyle bits */
#define EWindow_List_Window_Middle      1
#define EWindow_List_Window_Corner      2
#define EWindow_List_System_Menu_Item   4
#define EWindow_List_No_Scrollbars      8
#define EWindow_List_No_Sysmenu         16
#define EWindow_List_No_Minmax          32
#define EWindow_List_PWB                64
#define EWindow_List_DDE                128
#define EWindow_List_Open_In_Ring       256


#define ERES_OEW_FLG_PWB    64
#define ERES_OEW_FLG_COUNT  128
#define ERES_OEW_FLG_INRING 256   //Open given file in the active ring
                                  //if one is available
#define ERES_OEW_FLG_NEWWND  512  //Open give file in a new edit window

  /*Ŀ
  Quitbox information structure used for the quit box dialog 
  */

typedef struct _QUITBOXINFO {
   ULONG  Size;
   PSZ     FileName;
   PSZ     DlgTitle;
   PSZ     DlgMessage;
   HWND    HwndApp;
   } QUITBOXINFO;

typedef QUITBOXINFO  *PQUITBOXINFO;

  /*Ŀ
  Listbox information structure used for the listbox dialog 
  */

typedef struct _LISTBOXINFO {
   USHORT size;
   PSZ    title;                 /* pointer to list box title     */
   SHORT  flags;
//   SHORT  listlen;               /* total length of items in list */
   LONG  listlen;               /* total length of items in list */
   PSZ    list;                  /* pointer to list of items      */
   SHORT  nb;                    /* number of buttons             */
   PSZ    b1,b2,b3,b4,b5,b6,b7;  /* button text                   */
   ULONG  x,y;                   /* x,y coordinate of list box    */
   ULONG  row,col;
   PSZ    inputdata;
   HINI   Hini;
} LISTBOXINFO;
typedef LISTBOXINFO *PLISTBOXINFO;

#define LIST_FLAG_DISPLAYBELOWPOINT 1
#define LIST_FLAG_POINTSTODESKTOP   2
#define LIST_FLAG_DETAILSBUTTON     4
#define LIST_FLAG_MODELESS          8
#define LIST_FLAG_MONOFONT         16
#define LIST_FLAG_ITEMHANDLES      32



typedef struct {
   USHORT size;  // size of the structure
   HINI   Hini;
   HWND   HwndApp;
   HWND   HwndEdit;
   BOOL   AutoSuggest;
   PSZ    AppName;
}  PROOFBOXINFO;
typedef PROOFBOXINFO *PPROOFBOXINFO;



  /*Ŀ
  Entrybox information structure used for the entrybox dialog box 
  */

typedef struct _ENTRYBOXINFO {
   USHORT size;
   USHORT entryboxid;
   PSZ    title;                 /* pointer to list of items      */
   ULONG  x,y;                   /* x,y coordinate of list box    */
   ULONG  cols;
   ULONG  max;
   PSZ    entrytext;
   PSZ    b1,b2,b3,b4;
   USHORT nb;
   USHORT flags;
   PSZ    entry;
} ENTRYBOXINFO;
typedef ENTRYBOXINFO  *PENTRYBOXINFO;

typedef struct _GETPROFILEBOXINFO {
   USHORT size;
   PSZ  IniName;
   PSZ  ApplicationName;
   HWND hwndHelpInstance;
} GETPROFILEBOXINFO;
typedef GETPROFILEBOXINFO *PGETPROFILEBOXINFO;


typedef struct _OPENBOXINFO {
   ULONG    Size;
   LONG     Mode;
   PLISTDLG List;
   HINI     Hini;
   #ifdef BUGFIX00130
      UCHAR    Files[MAXFILENAME*2];
   #else
      UCHAR    Files[MAXFILENAME];
   #endif
   PSZ      *MultipleFilesArray;
   HWND     HwndEdit;
   HWND     HwndApp;
   ULONG    Style;
   PSZ      AppName;
   PSZ      KeyName;
} OPENBOXINFO;
typedef OPENBOXINFO *POPENBOXINFO;

#define  OPENF_ISSUE_OPEN      1
#define  OPENF_DISABLE_MULTSEL 2

#define  OPEN_MODE 0
#define  EDIT_MODE 1
#define  GET_MODE  2
#define  EPMSHELL_OPEN_MODE 3

typedef struct _COMMANDBOXINFO {
  ULONG   Size;
  HINI     Hini;
  PSZ      CmdText;
  PLISTDLG List;
  PSZ      Command;
  HWND     HwndApp;
  HWND     HwndEdit;
  ULONG    Style;
  PSZ      AppName;
  PSZ      KeyName;
} COMMANDBOXINFO;
typedef COMMANDBOXINFO *PCOMMANDBOXINFO;

#define CB_ISSUE_COMMAND    1
#define CB_RETURN_COMMAND   2


typedef struct _MSGBOXINFO {
   ULONG    Size;
   HWND     HwndApp;
   PSZ      MsgText;
   PLISTDLG List;
   HINI     Hini;
   HWND     HwndEdit;
   PSZ      AppName;
   PSZ      KeyName;
} MSGBOXINFO;
typedef MSGBOXINFO *PMSGBOXINFO;

typedef struct _FINDBOXINFO {
   ULONG  Size;
   HINI    Hini;
   PSZ     FindText;
   HWND    HwndApp;
   HWND    HwndEdit;
} FINDBOXINFO;
typedef FINDBOXINFO *PFINDBOXINFO;

typedef struct _CONFIGBOXINFO {
   USHORT  size;
   HINI    hini;
   HWND    hwndApp;
   HWND    hwndEdit;
   ULONG   type;
   USHORT  *options;
   HWND    owner;
} CONFIGBOXINFO;
typedef CONFIGBOXINFO *PCONFIGBOXINFO;
#define CONFIGDLG_SAVE    WM_USER + 1
#define POPHELPPANEL      WM_USER + 2
#define SHOWDEFAULTS      WM_USER + 3
#define GIVE_NB_FOCUS     WM_USER + 4
#define GIVE_PB_FOCUS     WM_USER + 5
#define SHOW_DLG          WM_USER + 6
#define GETTING_FOCUS     WM_USER + 7
#define LOSING_FOCUS      WM_USER + 8
#define TURN_NB_PAGE      WM_USER + 9
#define NB_SAVESETTINGS   WM_USER + 10
#define NB_QUERYSAVESETTINGS WM_USER + 11

typedef struct _UNDOBOXINFO {
   ULONG Size;
   HINI   Hini;
   HWND   HwndApp;
   HWND   HwndEdit;
} UNDOBOXINFO;
typedef UNDOBOXINFO *PUNDOBOXINFO;

typedef struct _PRINTBOXINFO {
   ULONG  Size;
   HINI   Hini;
   HWND   HwndApp;
   HWND   HwndEdit;
   ULONG  Flags;
   PSZ    DfltPrinter;
} PRINTBOXINFO;
typedef PRINTBOXINFO *PPRINTBOXINFO;

#if 0  // No longer used.
   typedef struct _AVIOFONTBOXINFO {
      USHORT cur_height;
      USHORT cur_width;
      HINI   hini;
      HWND   hwndApp;
      HWND   hwndEdit;
      USHORT type;
      HWND   hwndHelpInstance;
   } AVIOFONTBOXINFO;
   typedef AVIOFONTBOXINFO *PAVIOFONTBOXINFO;
   #define AFONT_DIALOG  1
   #define AFONT_PAGE    2
   #define AFONT_SAVE    WM_USER +1
#endif

typedef struct _ENTERKEYSBOXINFO {
   USHORT size;
   HWND hwndEdit;
   HWND hwndApp;
   HWND hwndHelpInstance;
   HWND owner;
   BOOL BlockPaintMsg;
} ENTERKEYSBOXINFO;
typedef ENTERKEYSBOXINFO *PENTERKEYSBOXINFO;

#define ENTERKEYS_SAVE WM_USER +1


typedef struct _RINGBOXINFO {
   ULONG Size;
   HINI   Hini;
   HWND   HwndApp;
   HWND   HwndEdit;
} RINGBOXINFO;
typedef RINGBOXINFO *PRINGBOXINFO;

typedef struct _STYLEBOXINFO {
   ULONG  Size;
   HINI   Hini;
   HWND   HwndApp;
   HWND   HwndEdit;
   ULONG  Type;
   HWND   Owner;
   BOOL   BlockPaintMsg;
} STYLEBOXINFO;
typedef STYLEBOXINFO *PSTYLEBOXINFO;
#define STYLEDLG_DIALOG 1
#define STYLEDLG_PAGE   2
#define STYLEDLG_SAVE WM_USER +1

typedef struct _EPMCONFIGBOXINFO {
  USHORT size;
  HINI  hini;
  HWND  hwndApp;
  ULONG ProfileFlags;
  HWND  hwndHelpInstance;
} EPMCONFIGBOXINFO;
typedef EPMCONFIGBOXINFO *PEPMCONFIGBOXINFO;

typedef struct _INTERFACEBOXINFO {
  HINI  hini;
  PSZ  *InterfaceNames;
  ULONG Num_of_interfaces;
  ULONG Current_Interface;
  ULONG Interface_Selected;
  HWND  hwndApp;
  HWND  hwndHelpInstance;
} INTERFACEBOXINFO;
typedef INTERFACEBOXINFO *PINTERFACEBOXINFO;

typedef struct _FILETYPEBOXINFO {
  HINI   hini;
  HWND   hwndApp;
  USHORT TypeSelected;
} FILETYPEBOXINFO;
typedef FILETYPEBOXINFO *PFILETYPEBOXINFO;

typedef struct _SETBOXINFO {
  ULONG  Size;
  HWND   HwndApp;
  HWND   HwndEdit;
  HINI   Hini;
  ULONG  Pages;
  USHORT *Options;
  ULONG  Mode;
} SETBOXINFO;
typedef SETBOXINFO *PSETBOXINFO;

#define SETBOX_APPLY  0
#define SETBOX_SET    1

typedef struct _ABOUTBOXINFO {
  ULONG Size;
  PSZ   EditorVersion;
  PSZ   MacroVersion;
} ABOUTBOXINFO;
typedef ABOUTBOXINFO *PABOUTBOXINFO;


#define MARGINS_FL       1
#define COLORS_FL        2
#define PATHS_FL         4
#define AUTOSAVE_FL      8
#define FONTS_FL         16
#define EKEYS_FL         32
#define FRAMECNTRLS_FL   64
#define MISC_FL          128
#define TOOLBAR_FL       256
#define TOOLBAR0_FL      512
#define MODULES_FL       1024

#define CONFIGDLG_FULL       1
#define CONFIGDLG_TABS       2
#define CONFIGDLG_COLORS     4
#define CONFIGDLG_MARGINS    8
#define CONFIGDLG_PATHS      16
#define CONFIGDLG_AUTOSAVE   32


typedef struct {
   ULONG  Size;
   HWND   HwndEdit;
   HWND   HwndApp;
   BOOL   BlockPaintMsg;
} FCBOXINFO;
typedef FCBOXINFO *PFCBOXINFO;

typedef struct {
   ULONG  Size;
   HWND   HwndEdit;
   HWND   HwndApp;
   BOOL   BlockPaintMsg;
} MFBOXINFO;
typedef MFBOXINFO *PMFBOXINFO;

typedef struct {
   ULONG  Size;
   HWND   HwndEdit;
   HWND   HwndApp;
   BOOL   BlockPaintMsg;
} MF2BOXINFO;
typedef MF2BOXINFO *PMF2BOXINFO;

typedef struct {
  ULONG Size;
  HWND  HwndEdit;
  HWND  HwndApp;
  BOOL  BlockPaintMsg;
}MACCNFBOXINFO;
typedef MACCNFBOXINFO *PMACCNFBOXINFO;

typedef struct {
   ULONG Size;
   HWND  HwndEdit;
   HWND  HwndApp;
} CTAGSBOXINFO;
typedef CTAGSBOXINFO *PCTAGSBOXINFO;

typedef struct {
   ULONG Size;
   HWND  HwndEdit;
   HWND  HwndApp;
} STARTOPTBOXINFO;
typedef STARTOPTBOXINFO *PSTARTOPTBOXINFO;

/*Ŀ
 Other Misso structures                                                     
                                                                            
*/
typedef struct _WINDOWSIZE {
                 // x and y must be signed values
   SHORT  x;     // horizontal origin can be to the right of position 0
   SHORT  y;     // vertical origin can be below position 0
   USHORT  cx;
   USHORT  cy;
} WINDOWSIZE;

typedef WINDOWSIZE *PWINDOWSIZE;

/*Ŀ
 Structure used to save window's to an INI profile.                         
*/
typedef struct _PROFILEPOS {
   ULONG        chksum;
   WINDOWSIZE   ws;
} PROFILEPOS;
typedef PROFILEPOS *PPROFILEPOS;

/*ͻ
 EPM custom Winodw Messages:                                       GC. 1-89 
                                                                            
 Note:  When these values are changed REMEMBER to change the editor macros  
        especially STDCTRLS.E.    STDCTRLS.E has hard coded message numbers 
        that correspond to the constants below.                             
*/
#define   EPM_MSGID            WM_USER        +  0x400  // = 5120
#define   EPM_BOOK_ID          EPM_MSGID      +  1
#define   EPM_OPEN_EDITWINDOW  EPM_MSGID      +  2
#define   EPM_DLGBOXACTIVATE   EPM_MSGID      +  3
#define   EPM_POPCMDLINE       EPM_MSGID      +  4
#define   EPM_POPMSGBOX        EPM_MSGID      +  5
#define   EPM_POPOPENDLG       EPM_MSGID      +  6
#define   EPM_POPFINDDLG       EPM_MSGID      +  7
#define   EPM_POPCHANGEDLG     EPM_MSGID      +  8
#define   EPM_POPCONFIGDLG     EPM_MSGID      +  9
#define   EPM_POPFONTDLG       EPM_MSGID      +  10
#define   EPM_POPUNDODLG       EPM_MSGID      +  11
#define   EPM_POPHELPBROWSER   EPM_MSGID      +  12
#define   EPM_POPHELPMGRPANEL  EPM_MSGID      +  13
#define   EPM_SAVE_LISTS       EPM_MSGID      +  15
#define   EPM_RETRIEVE_LISTS   EPM_MSGID      +  16
#define   EPM_QUIT             EPM_MSGID      +  17
#define   EPM_POPAVIOFONTDLG   EPM_MSGID      +  18
#define   EPM_QHELPINSTANCE    EPM_MSGID      +  19
#define   EPM_MODELESS_DIALOG_DESTROY EPM_MSGID      +  20
#define   EPM_POPRINGDLG       EPM_MSGID      +  21
#define   EPM_POP_BOOK_ICON    EPM_MSGID      +  22
#define   EPM_POPSAVEASDLG     EPM_MSGID      +  23
#define   EPM_POPPRINTDLG      EPM_MSGID      +  24
#define   EPM_REGPAGEPROC      EPM_MSGID      +  25
#define   EPM_POPABOUTBOX      EPM_MSGID      +  26
#define   EPM_POPSYSCONFIGDLG  EPM_MSGID      +  27
#define   EPM_ADDFILETORETRIEVELIST EPM_MSGID +  28
#define   EPM_XXXSEMOPENEDIT   EPM_MSGID      +  29
#define   EPM_POPPROOFDLG      EPM_MSGID      +  30
#define   EPM_POP2ABOUTBOX     EPM_MSGID      +  31
#define   EPM_QUERY_CONFIG     EPM_MSGID      +  32
#define   EPM_REFRESH_CONFIG   EPM_MSGID      +  33
#define   EPM_WPS_POPOPENDLG   EPM_MSGID      +  34
#define   EPM_EDIT_NEWFILE_WPS   EPM_MSGID      +  35
#define   EPM_EDIT_NEWFILES_WPS  EPM_MSGID      +  36
#define   EPM_WPS_POPOPENDLG_SEM EPM_MSGID      +  37
#define   EPM_POPCTAGSDLG        EPM_MSGID      +  38
#define   EPM_WPS_OPENNEWFILE    EPM_MSGID      +  39
#define   EPM_WPS_OPENFILEDLG    EPM_MSGID      +  40
#define   EPM_WPS_SETTINGS       EPM_MSGID      +  41
#define   EPM_WPS_POPOPENDLG_SEM_ADD EPM_MSGID  +  42


#define NUM_OF_EA_TYPES   9

/*ͻ
 Application Window Definitions                                    GC.10-88 
*/
#define   ID_EPMWND            10
#define   ID_EPMMARKPTR        11
#define   ID_EPMICON           12

/*ͻ
 Misc Constants shared with EXE                                    GC.10-88 
*/
#define   MAXCMDLINE              512
#define   CLASSLEN                32
#define   MAXLEN                  260

#define   MAX_E_WINDOWS           32

#define   MAXLEN                  260
#define   STAGGER                 4

/*ͻ
 System Menu Definitions      200-299                              GC.10-88 
*/
#define   MAXITEMSIZE          80

#define   IDM_COMMANDS        200
#define   IDM_EDITFILE        201
#define   IDM_MSGBOX          202
#define   IDM_EDITWNDS        203
#define   IDM_HELP            206
#define   IDM_SAVEAS          207
#define   IDM_ABOUTBOX        208
#define   IDM_CTAGS           209

//******* USED FOR ERESReparentEwindows ***************** */
#define   E_ICONS               1
#define   E_WINDOWS             2


/*ͻ
 Function Prototypes.                                               GC 4-88 
*/

/*Ŀ
 Dynalink function Prototypes.                                              
*/

//******************* Dialog Box Related Functions ***************************
VOID    ETKENTRY  ERESCenterWindow( HINI hini, USHORT dlgid, HWND hwnd, BOOL move );
VOID    ETKENTRY  ERESSaveDlgPosition(HINI hini, USHORT dlgid, HWND hwnd );
MRESULT EXPENTRY  ERESOpenDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 ) ;
MRESULT EXPENTRY  ERESCommandDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESMsgBoxDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESFindChangeDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESConfigDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESStyleDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESAvioFontDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESRingDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESUndoDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESProofDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESCTagsDlgProc( HWND hDlg, MSG msg, MPARAM mp1, MPARAM mp2 );
MRESULT EXPENTRY  ERESQuitDlgProc( HWND, MSG , MPARAM, MPARAM);
BOOL    ETKENTRY  ERESDlgBoxValid(GLOBDATA *);
#if OS2VERSION < 20
   VOID    EXPENTRY  ENTRYBOX(HWND hwnd,PSZ title,USHORT  x, USHORT y,USHORT cols,USHORT max, PSZ entrytext,USHORT nb, PSZ  b1, PSZ b2, PSZ b3, PSZ b4,PSZ entry);
   VOID    EXPENTRY  LISTBOX(HWND,USHORT, USHORT, USHORT, USHORT, USHORT, SHORT, PSZ, PSZ, PSZ, PSZ, PSZ, PSZ, PSZ, PSZ, SHORT, PSZ, PSZ);
#else
   VOID    EXPENTRY  ENTRYBOX(HWND hwnd,PSZ title,ULONG  x, ULONG y,ULONG cols,ULONG max, PSZ entrytext,ULONG nb, PSZ  b1, PSZ b2, PSZ b3, PSZ b4,PSZ entry);
   VOID    EXPENTRY  LISTBOX(HWND,ULONG, ULONG, ULONG, ULONG, ULONG, LONG, PSZ, PSZ, PSZ, PSZ, PSZ, PSZ, PSZ, PSZ, LONG, PSZ, PSZ, HINI);
#endif
MRESULT EXPENTRY  ERESGetProfilePathDlgProc( HWND hwndDlg, MSG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY  ERESEPMConfigDlgProc(HWND, MSG, MPARAM, MPARAM);
MRESULT EXPENTRY  ERESFileTypeDlgProc(HWND, MSG, MPARAM, MPARAM);
MRESULT EXPENTRY  ERESInterfaceDlgProc(HWND, MSG, MPARAM, MPARAM);
MRESULT EXPENTRY  ERESFontSubClassWndProc(HWND, MSG, MPARAM, MPARAM);


//**************** Miscellaneous Functions ************************************
MRESULT EXPENTRY ERESCommonWndProc(HWND, MSG, MPARAM, MPARAM);
VOID    ETKENTRY ERESSaveDlgList(HINI hini, PLISTDLG ListDlg, PSZ AppName, PSZ KeyName);
VOID    ETKENTRY ERESSaveLists(GLOBDATA *);
VOID    ETKENTRY ERESRetrieveLists(GLOBDATA *);
VOID    ETKENTRY ERESRetrieveDlgList(HINI hini, PLISTDLG ListDlg, PSZ AppName, PSZ KeyName);
void    ETKENTRY ERESHelp(ULONG, GLOBDATA *);
VOID    ETKENTRY ERESProcessCommands( MPARAM, MPARAM, MPARAM, GLOBDATA *);
HWND    ETKENTRY ERESOpenEditWindow( PSZ , GLOBDATA *, USHORT, ULONG, PSZ *, HWND hwndWPSObject);
USHORT  ETKENTRY ERESCountWndList(PEWINDOWLLNODE);
BOOL    ETKENTRY ERESIsAnEditWin(HWND, GLOBDATA*);
BOOL    ETKENTRY ERESEwindowValid(GLOBDATA *);
VOID    ETKENTRY ERESShowWndList(HWND,PEWINDOWLLNODE);
USHORT  ETKENTRY ERESShutDown(GLOBDATA *);
VOID    ETKENTRY ERESInitEResStruct(HWND, GLOBDATA *);
VOID    ETKENTRY ERESInitEresGlob(GLOBDATA *, PFN *);
USHORT  ETKENTRY ERESCheckVersion(GLOBDATA *, PSZ);
VOID    ETKENTRY ERESResolveIniPath(PSZ, PSZ, PSZ, HWND, HAB );
VOID    ETKENTRY ERESFlushError(HAB);
MRESULT EXPENTRY ERESSettingsDlgProc(HWND, MSG, MPARAM, MPARAM);
MRESULT EXPENTRY ERESEnterKeysDlgProc(HWND, MSG, MPARAM, MPARAM);
USHORT  EXPENTRY ERESSaveas(HWND hwndowner, HWND hwndshell, PSZ buffer, PSZ type );
MRESULT EXPENTRY ERESPrintDlgProc(HWND hwnd,MSG usMsg,MPARAM mp1,MPARAM mp2);
MRESULT EXPENTRY DDEWndProc(HWND hwnd, MSG  msg, MPARAM mp1, MPARAM mp2);
BOOL    ETKENTRY ERESDeleteFromWndList(PEWINDOWLLNODE *EWindowLL, HWND hwnd);
BOOL    ETKENTRY ERESAddToWndList(PEWINDOWLLNODE *EWindowLL, HWND hwnd, HWND hwndWPSObject);
USHORT  ETKENTRY ERESRetrieveListInsert( PLISTDLG pList, PSZ cmd, BOOL AllowDuplicate);

VOID    ETKENTRY ERESHelpBrowser(PSZ, GLOBDATA *);
VOID    ETKENTRY ERESShowHelp(GLOBDATA *);
VOID    ETKENTRY ERESErrorHandler(MPARAM, MPARAM, GLOBDATA *);
VOID    ETKENTRY ERESSaveDefaultWindowSize(GLOBDATA *);
USHORT  ETKENTRY ERESRetrieveDefaultWindowSize(GLOBDATA *, PWINDOWSIZE);
VOID    ETKENTRY ERESFindDataFile(GLOBDATA *, PSZ , PSZ , PSZ );
MRESULT EXPENTRY SetProfilePathDlgProc(HWND, USHORT, MPARAM, MPARAM);
HINI    ETKENTRY ERESGetProfileHandle(PEPMRES);
PVOID   ETKENTRY ERESMalloc(unsigned int);
VOID    ETKENTRY ERESFree(PVOID);
#ifdef TRACE_ERESMALLOC2
PVOID   ERESMalloc2(ULONG size);
#else
 #define ERESMalloc2 malloc
#endif
#ifdef TRACE_ERESFREE2
VOID    ERESFree2(PVOID p);
#else
 #define ERESFree2 free
#endif
VOID    ETKENTRY ERESFreeMem(PVOID);
PVOID   ETKENTRY ERESRealloc(PVOID p, ULONG size);
#ifdef TRACE_ERESREALLOC2
PVOID   ERESRealloc2(PVOID p, ULONG size);
#else
 #define ERESRealloc2 realloc
#endif

PSZ     ETKENTRY ERESmsg2(HAB,  USHORT, PSZ, USHORT);
// LAM:  Most of the calls to ERESmsg will now load the string from ETKCnnn.DLL:
#define ERESmsg(hab, id, strbuf)   ERESmsg2((hab), (id), (strbuf), 0)

HINI    EXPENTRY ERESQueryHini(HWND HwndEdit);

#if OS2VERSION >= 20
   #define EXPENTRY _System
#endif


