/*=========================================================================*\
|* GPMSTAT v1.0.beta4.                                                     *|
|* Log analyzer for General Purpose Mailer.                                *|
|* Written by Igor Vanin (2:5030/448@fidonet, vanin@gpmail.spb.ru).        *|
|* Small changes by Alex Batickii (2:5054/8@fidonet).                      *|
\*=========================================================================*/

/* rexxutil.dll initialization */
call rxfuncadd 'sysloadfuncs','rexxutil','sysloadfuncs'
call sysloadfuncs

say 'GPMSTAT v1.0.beta4 - Log analyzer for General Purpose Mailer. 01.05.1999.'
say 'Written by Igor Vanin (2:5030/448@fidonet, vanin@gpmail.spb.ru).'
say 'Small changes by Alex Batickii (2:5054/8@fidonet).'
say

/* name of configuration file */
configfile='GPMSTAT.CFG'

/* default settings */
lines=1
inlog.1='GPMail.Log'
outstat='GPMSTAT.TXT'

/* reading configuration file */
say 'Reading configuration file 'configfile'.'
call stream configfile,'c','open read'
do until lines(configfile)=0
   st=space(linein(configfile))
   if length(st)=0 then iterate
   if substr(st,1,1)=';' then iterate
   interpret st
end
call stream configfile,'c','close'
if symbol('inlog')='VAR' then inlog.1=inlog

call sysfiledelete outstat
call stream outstat,'c','open write'

total.sessions=0; total.size.in=0; total.size.out=0
total.hr=0; total.mn=0; total.sc=0; total.cps=0
total.addrs=0

do c=1 to lines
   drop data.
   drop adrlist
   inlog=inlog.c
   call stream inlog,'c','open read'
   say 'Working with log #'c': "'inlog'".'

   do until lines(inlog)=0
      st=linein(inlog)
      if length(st)>=17 then do
         firsttime=substr(st,3,15)
         leave
      end
   end

   line.c.addrs=0; line.c.sessions=0; line.c.size.in=0; line.c.size.out=0
   line.c.hr=0; line.c.mn=0; line.c.sc=0; line.c.cps=0
   if lines(inlog)=0 then do
      say 'No data in log.'
      if lines>1 then call charout outstat,'Line #'c': '
      call lineout outstat,'No data in log'
      call lineout outstat,''
      iterate
   end

   say 'Analyzing log...'
   mlr='[unknown]'

   call stream inlog,'c','seek =0'
   do until lines(inlog)=0
      st=linein(inlog)

      if substr(st,24,16)='Remote software:' then do
         mlr=substr(st,41,21)
         ptr1=pos('/',mlr)
         if ptr1>0 then mlr=substr(mlr,1,ptr1-1)
      end
      else if substr(st,1,1)='>' then if datatype(substr(st,24,1),number) then do
         lasttime=substr(st,3,15)
         ptr1=pos(', bytes ',st)
         adr=substr(st,24,ptr1-24); ptr1=ptr1+8
         ptr2=pos('@',adr); if ptr2>0 then adr=substr(adr,1,ptr2-1)
         ptr2=pos('/',substr(st,ptr1))+ptr1-1
         bytes_in=substr(st,ptr1,ptr2-ptr1)
         ptr1=pos(', t',st); bytes_out=substr(st,ptr2+1,ptr1-ptr2-1)
         time=substr(st,ptr1+7)
         ptr1=pos(':',time); ptr2=lastpos(':',time)
         hr2=substr(time,1,ptr1-1);
         mn2=substr(time,ptr1+1,ptr2-ptr1-1); sc2=substr(time,ptr2+1)

         if data.adr.check\='1' then do
            data.adr.check='1'
            data.adr.size.in=0; data.adr.size.out=0
            data.adr.sessions=0
            data.adr.hr=0; data.adr.mn=0; data.adr.sc=0; data.adr.cps=0
            data.adr.mailer=mlr
            a=line.c.addrs
            adrlist.a=adr
            line.c.addrs=a+1
         end
         else if data.adr.mailer='[unknown]' then data.adr.mailer=mlr
         data.adr.sessions=data.adr.sessions+1
         data.adr.size.in=data.adr.size.in+bytes_in
         data.adr.size.out=data.adr.size.out+bytes_out
         /*data.adr.hr=data.adr.hr+hr2*/
         /*data.adr.mn=data.adr.mn+mn2*/
         tt=sc2+60*mn2+3600*hr2
         data.adr.sc=data.adr.sc+tt
         total.sessions=total.sessions+1
         total.size.in=total.size.in+bytes_in; total.size.out=total.size.out+bytes_out
         /*total.hr=total.hr+hr2; total.mn=total.mn+mn2; total.sc=total.sc+sc2*/
         total.sc=total.sc+tt
         line.c.sessions=line.c.sessions+1
         line.c.size.in=line.c.size.in+bytes_in; line.c.size.out=line.c.size.out+bytes_out
         /*line.c.hr=line.c.hr+hr2; line.c.mn=line.c.mn+mn2; line.c.sc=line.c.sc+sc2*/
         line.c.sc=line.c.sc+tt
      end
   end
   
   if (line.c.addrs=0) then do
      if lines>1 then call charout outstat,'Line #'c': '
      call lineout outstat,'No data in log'
      call lineout outstat,''
      iterate
   end

   if symbol('sortmode')='VAR' then call sort
   
   say 'Writing output to 'outstat'.'
   if lines>1 then call charout outstat,'Line #'c': '
   call lineout outstat,'Statistics since 'firsttime' to 'lasttime
   call lineout outstat,''
   if tabletype=1 then do
      call lineout outstat,'ͻ'
      call lineout outstat,' Address         Sess Bytes IN   Bytes OUT  Time    Mailer              '
      call lineout outstat,'Ķ'
   end
   else do
      call lineout outstat,'ͻ'
      call lineout outstat,' Address            Sess  Bytes IN   Bytes OUT  Time OnlineAvg.CPS'
      call lineout outstat,'Ķ'
   end
   do i=0 to line.c.addrs-1
      a=adrlist.i
      if data.a.sc>0 then data.a.cps=trunc((data.a.size.in+data.a.size.out)/data.a.sc)
      do while data.a.sc>=60; data.a.sc=data.a.sc-60; data.a.mn=data.a.mn+1; end
      do while data.a.mn>=60; data.a.mn=data.a.mn-60; data.a.hr=data.a.hr+1; end

      if tabletype=1 then w=11; else w=12
      data.a.size.in = ''Right(COMMA(data.a.size.in),w)
      data.a.size.out = ''Right(COMMA(data.a.size.out),w)

      if tabletype=1 then w=17; else w=20
      call charout outstat,''a''copies(' ',w-length(a))
      call charout outstat,''data.a.sessions''copies(' ',4-length(data.a.sessions))
      call charout outstat, data.a.size.in
      call charout outstat, data.a.size.out
      if tabletype=1 then w=8; else w=11
      tmp=twodig(data.a.hr,' ')':'twodig(data.a.mn)':'twodig(data.a.sc)
      if length(tmp)<w then tmp=copies(' ',w-length(tmp))''tmp
      call charout outstat,''tmp
      if tabletype=1 then do
         call lineout outstat,''data.a.mailer''copies(' ',21-length(data.a.mailer))''
      end
      else do
         call lineout outstat,''right(data.a.cps,7)''
      end
   end
   if tabletype=1 then call lineout outstat,'Ķ'
   else call lineout outstat,'Ķ'

   if line.c.sc>0 then line.c.cps=trunc((line.c.size.in+line.c.size.out)/line.c.sc)
   do while line.c.sc>=60; line.c.sc=line.c.sc-60; line.c.mn=line.c.mn+1; end
   do while line.c.mn>=60; line.c.mn=line.c.mn-60; line.c.hr=line.c.hr+1; end
   if tabletype=1 then w=10; else w=13
   call charout outstat,'Total: 'line.c.addrs''copies(' ',w-length(line.c.addrs))
   call charout outstat,''line.c.sessions''copies(' ',4-length(line.c.sessions))
   if tabletype=1 then w=11; else w=12
   call charout outstat,''Right(COMMA(line.c.size.in),w)
   call charout outstat,''Right(COMMA(line.c.size.out),w)
   
   if tabletype=1 then w=8; else w=11
   tmp=twodig(line.c.hr,' ')':'twodig(line.c.mn)':'twodig(line.c.sc)
   if length(tmp)<w then tmp=copies(' ',w-length(tmp))''tmp
   call charout outstat,''tmp''
   if tabletype=1 then call lineout outstat,'G.P.Mail - rulez :-) '
   else call lineout outstat,right(line.c.cps,7)''
   
   
   if tabletype=1 then call lineout outstat,'ͼ'
   else call lineout outstat,'ͼ'
   call lineout outstat,''

   call stream inlog,'c','close'
end

if lines>1 then do
   if total.sc>0 then total.cps=trunc((total.size.in+total.size.out)/total.sc)
   do while total.sc>=60; total.sc=total.sc-60; total.mn=total.mn+1; end
   do while total.mn>=60; total.mn=total.mn-60; total.hr=total.hr+1; end
   call lineout outstat,'Summary statistics for all 'lines' lines'
   call lineout outstat,'ͻ'
   call lineout outstat,'Line        SessAddrs Bytes IN   Bytes OUT   Time  Avg.CPS'
   call lineout outstat,'Ķ'

   do c=1 to lines
      call charout outstat,'Line #'Left(c,6)
      call charout outstat,''line.c.sessions''copies(' ',4-length(line.c.sessions))
      call charout outstat,''line.c.addrs''copies(' ',5-length(line.c.addrs))
      call charout outstat,''Right(COMMA(line.c.size.in),11)
      call charout outstat,''Right(COMMA(line.c.size.out),11)
      call charout outstat,''twodig(line.c.hr,' ')':'twodig(line.c.mn)':'twodig(line.c.sc)
      call charout outstat,''right(line.c.cps,7)
      call lineout outstat,''
      /*total.addrs = total.addrs + line.c.addrs*/ /*   ⠪! */
   end

   call lineout outstat,'Ķ'
   call charout outstat,'Total: 'Left(lines,5)
   call charout outstat,''total.sessions''copies(' ',4-length(total.sessions))
   /*call charout outstat,''total.addrs''copies(' ',5-length(total.addrs))*/
   call charout outstat,'     '
   call charout outstat,''Right(COMMA(total.size.in),11)
   call charout outstat,''Right(COMMA(total.size.out),11)
   call charout outstat,''twodig(total.hr,' ')':'twodig(total.mn)':'twodig(total.sc)
   call charout outstat,''right(total.cps,7)
   call lineout outstat,''
   call lineout outstat,'ͼ'
   call lineout outstat,''
end

call lineout outstat,'                                      Generated by GPMSTAT ('date(e)' 'time(n)')'
call stream outstat,'c','close'

exit


twodig: procedure
   if length(arg(1))>1 then return arg(1)
   if arg()<2'' then thischar='0'
   else thischar=arg(2)
   tmpstr=copies(thischar,2-length(arg(1)))arg(1)
   return tmpstr
end


comma: procedure
   sOUT = strip(arg(1))
   if Length(sOUT) > 9 then sOUT = Insert(',',sOUT,Length(sOUT)-9)
   if Length(sOUT) > 6 then sOUT = Insert(',',sOUT,Length(sOUT)-6)
   if Length(sOUT) > 3 then sOUT = Insert(',',sOUT,Length(sOUT)-3)
   return sOUT
end


sort: procedure expose line. c adrlist. data. sortmode sortdir
   if sortdir=d then s='<'
   else s='>'
   
   if      sortmode=address then operation = 'result=a's'b'
   else if sortmode=size    then operation = 'result=data.a.size.in+data.a.size.out's'data.b.size.in+data.b.size.out'
   else if sortmode=sizein  then operation = 'result=data.a.size.in's'data.b.size.in'
   else if sortmode=sizeout then operation = 'result=data.a.size.out's'data.b.size.out'
   else if sortmode=time    then operation = 'result=data.a.sc's'data.b.sc'
   else if sortmode=sess    then operation = 'result=data.a.sessions's'data.b.sessions'
   else if sortmode=mailer  then operation = 'result=translate(data.a.mailer)'s'translate(data.b.mailer)'
   else return
   
   say 'Sorting...'
   /* say 'operation is "'operation'"' */ /* debug */
   
   do i=0 to line.c.addrs-2
      do j=i+1 to line.c.addrs-1
         a=adrlist.i; b=adrlist.j
         interpret operation
         if result then do
            tmpstr=adrlist.i
            adrlist.i=adrlist.j
            adrlist.j=tmpstr
         end
      end
   end
   return
end

