/**********************************************************************/
/* Change the details and sort class of the specified folder(s) and   */
/* subfolders to use CWMailFile instead of the standard WPFileSystem  */
/**********************************************************************/

signal on Halt /* handle [Ctrl][C] */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs' /* Q&D way to load the REXX utils lib */
call SysLoadFuncs  /* Q&D way to load the REXX utils lib */

parse arg FolderSpec /* get the argument */

if (FolderSpec = '') then /* if there is none */
do
 call beep 333,333 /* signal */
 say 'SetFolder: sets folder sorting and details to CWMailFile class' /* report */
 say 'Usage : setfolder <folder_spec>' /* report */
 say '        <folder_spec> may include wildcards (*,?)' /* report */
 call Halt /* and quit */
end

GotCWMFC = 0  /* we have no CWMailFile class yet */

call sysqueryclasslist('ClassList.')  /* get the class list */

do Index = 1 to ClassList.0  /* look at each entry */
 if (word(ClassList.Index,1) = 'CWMailFile') then  /* if it is what we want */
 do
  GotCWMFC = 1  /* we have a CWMailFile class */
 end
end

if (\GotCWMFC) then  /* if the CWMailFile class is not registered */
do
 call beep 333,333 /* signal */
 say 'Please register the CWMailFile class before using this program' /* report */
 call Halt /* and quit */
end

FolderSpec = strip(FolderSpec,'B','"') /* get rid of any quotation marks */

call sysfiletree FolderSpec,'Folders.','DOS' /* look for the folder(s) */

do Index = 1 to Folders.0 /* for each one we found */
 if (syssetobjectdata(Folders.Index,'DETAILSCLASS=CWMailFile;SORTCLASS=CWMailFile')) then /* if we can set the class */
 do
  say 'Processed  "'||Folders.Index||'"' /* report success */
 end
 else /* if we cannot set the class */
 do
  say 'Error processing "'||Folders.Index||'"'  /* report failure */
 end
end

call Halt /* that's all, folks! */

/**********************************************************************/
Halt:  /* quits */
/**********************************************************************/

say 'Press [Enter] to quit' /* report */
parse pull /* wait for [Enter] */

exit /* and quit */
