/*
 * Filename: ns2rxml.cmd
 *   Author: Michael DeBusk <m_debusk@despammed.com>
 *  Created: Tue Apr  9 2002
 *  Purpose: Converts a Netscape Messenger address book, exported
 *           to an LDIF file, to a RexxMail mailaddr.txt file. Note
 *           well that the script assumes the LDIF file is in the
 *           current directory unless you give it a full pathname,
 *           and if you feed it a file that isn't a valid LDIF file,
 *           it will probably just recreate the default mailaddr.txt
 *  Changes: 
 */

/* Get parameter from arg or from prompt */
PARSE ARG ldif
IF ldif = '' THEN
DO
    SAY ''
    SAY 'This script converts a Netscape Messenger address book,'
    SAY 'exported to an LDIF file, to a RexxMail MAILADDR.TXT.'
    SAY ''
    CALL CharOut , 'Name of LDIF file (or ENTER to quit): '
    PARSE PULL ldif
    IF ldif = '' THEN
        EXIT
    /* Is this an existing file? If not, quit. */
    result = Stream(ldif, 'C', 'QUERY EXISTS')
    IF result = '' THEN
    DO
        SAY 'File' ldif 'does not exist. Exiting...'
        EXIT
    END
END

/* Some necessary variables */
outFile = mailaddr.txt /* Default address file */
keys.   = ''           /* Needed to process LDIF */

result = Stream(outFile, 'C', 'QUERY EXISTS')
IF result <> '' THEN
DO
    SAY ''
    SAY outFile 'exists. ENTER to overwrite or CTRL-C to quit.'
    PULL .
    '@del' outFile
END

/* contains default mailaddr.txt */
headline.0  = 46
headline.1  = 'This text file describes the contents of the RexxMail Addresses folder.'
headline.2  = 'It can be created by means of the RexxMail "Addresses - Export " option,'
headline.3  = 'and it can be used to recreate the Addresses Folder contents by means of'
headline.4  = 'the "Addresses - Import " function.'
headline.5  = ''
headline.6  = 'Each mail message template object in the Addresses folder or one of its'
headline.7  = 'subfolders is represented by a group of text lines subdivided by <...>'
headline.8  = 'tags separating the sections of data making up the object contents.'
headline.9  = 'A group of lines must start with a <TITLE> line and end with an <END>'
headline.10 = 'line. Text on the line(s) following the <TITLE> tag and preceding the'
headline.11 = 'next tag will be used for the title of the mail message template object.'
headline.12 = 'Titles are relative to the RexxMail Addresses folder; simply include'
headline.13 = 'backslash markers to create subfolders.'
headline.14 = ''
headline.15 = 'The other possible tags are <TEXT> and <KEYWORDS>. Text on the line(s)'
headline.16 = 'following the <TEXT> tag and preceding the next tag will be written as'
headline.17 = 'text content to the message file. Text on the line(s) following the'
headline.18 = '<KEYWORDS> tag and preceding the next tag (which must be the <END> tag)'
headline.19 = 'will be written to the "Keywords" Extended Attribute field of the'
headline.20 = 'message file (on the "File" page in the "Properties" notebook).'
headline.21 = ''
headline.22 = 'Tags within a text line block must appear in the following order:'
headline.23 = '  <TITLE>'
headline.24 = '  <TEXT>'
headline.25 = '  <KEYWORDS>'
headline.26 = '  <END>'
headline.27 = '________________________________________________________________________'
headline.28 = ''
headline.29 = '<TITLE>'
headline.30 = 'New Message'
headline.31 = '<TEXT>'
headline.32 = 'To: '
headline.33 = 'Subject: '
headline.34 = '<KEYWORDS>'
headline.35 = 'Empty New Message'
headline.36 = '<END>'
headline.37 = ''
headline.38 = '<TITLE>'
headline.39 = 'RexxMail\Marcus de Geus'
headline.40 = '<TEXT>'
headline.41 = 'To: Marcus de Geus <marcus@degeus.com>'
headline.42 = 'Subject: '
headline.43 = '<KEYWORDS>'
headline.44 = 'RexxMail author'
headline.45 = '<END>'
headline.46 = ''

/* Write default mailaddr.txt from stem */
DO i = 1 TO headline.0
    CALL LineOut outFile, headline.i
END

/* Parse ldif and write data to outFile */
DO WHILE Lines(ldif)
    line = LineIn(ldif)
    parse var line key ': ' value
    key = translate(key)
    keys.key = value
    IF key = '' THEN
    DO
        CALL LineOut outFile, '<TITLE>'
        /* Following line writes title as "lastname.firstname" */
        CALL LineOut outFile, keys.SN || '.' || keys.GIVENNAME
        CALL LineOut outFile, '<TEXT>'
        /* Following line writes To: line as "firstname lastname <e-mail@address>" */
        CALL LineOut outFile, 'To: ' || keys.GIVENNAME || ' ' || keys.SN || ' <' || keys.MAIL || '>'
        CALL LineOut outFile, 'Subject: '
        IF keys.O <> '' THEN /* Uses "organization" as keyword, and */
        DO                   /* only if it isn't blank              */
            CALL LineOut outFile, '<KEYWORDS>'
            CALL LineOut outFile, keys.O
        END
        CALL LineOut outFile, '<END>'
        CALL LineOut outFile, ''
        keys. = '' /* Blank all the keys to start over */
    END
END

SAY 'Finished processing' outfile 'from' ldif

EXIT
