/*****************************************************************************/
/* FA Partners - Created by Flemming Bregnvig bregnvig@usa.net               */
/* Copyright (c) FA Partners 1997                                            */
/*---------------------------------------------------------------------------*/
/* File        : keyMessages.cpp                                             */
/* Description : Contains the implementation of the keyMessages class.       */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-12-22  | Created                                 | FB                */
/* 1997-XX-XX  |                                         |                   */
/*---------------------------------------------------------------------------*/
/* Compile     :                                                             */
/*****************************************************************************/

#include "..\..\BanditTagger\Tagger\keyMessage.hpp"
#include <IFrame.hpp>
#include <Iexcbase.hpp>
#include <IWindow.hpp>
#include <ITitle.hpp>
#include <icursor.h>
#include <ihandle.hpp>

extern "C" {
  #include <hookdll.h>
}

//***************************************************************************
// BANKeyMessages::getSwitchBlock
// Input parameters :
// The member get the correct SwitchBlock based on the taskName
// Returncodes : Boolean
//***************************************************************************

Boolean BANKeyMessage::getSwitchEntry()
{
  unsigned long noOfItems(
                WinQuerySwitchList(IThread::current().anchorBlock(), NULL, 0));
  Boolean found(false);
  if (noOfItems != 0) {
    PSWBLOCK  pswBlock(NULL);
    unsigned long bufferSize(noOfItems*sizeof(SWENTRY) + sizeof(unsigned long));
    DosAllocMem((PPVOID)&pswBlock, bufferSize,
                PAG_READ | PAG_WRITE | PAG_COMMIT);
    WinQuerySwitchList(IThread::current().anchorBlock(), pswBlock, bufferSize);
    IString tempTaskName;
    for (short i = 0; i <= pswBlock->cswentry; i++) {
      tempTaskName = pswBlock->aswentry[i].swctl.szSwtitle;
      if (tempTaskName.size() > _taskName.length())
        tempTaskName.remove(_taskName.length()+1);
      if (tempTaskName == _taskName) {
        _pswEntry = new SWENTRY;
        memcpy((PVOID) _pswEntry, (PVOID) &pswBlock->aswentry[i], sizeof(SWENTRY));
        i = pswBlock->cswentry;
        found = true;
      }
    }
    DosFreeMem(pswBlock);
  }
  return found;
}

//***************************************************************************
// BANKeyMessages::sendMessage
// Input parameters :
// The member sends a message to the window handle.
// Returncodes : Boolean
//***************************************************************************

Boolean BANKeyMessage::postCommand(unsigned long eventId, const IEventData& mp1, const IEventData& mp2)
{
  // Just to make it open class compatible
  PSWCNTRL  pswControl(&_pswEntry->swctl);

  IWindowHandle  windowHandle(pswControl->hwnd);
  windowHandle.postEvent(eventId, mp1, mp2);
  return true;
}
