/*****************************************************************************/
/* FA Partners - Created by Flemming Bregnvig bregnvig@stealthmail.com       */
/* Copyright (c) FA Partners 1997, 1998                                      */
/*---------------------------------------------------------------------------*/
/* File        : commandDef.hpp                                              */
/* Contains    : This file contains the common definitions.                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-06-16  | Created                                 | FB                */
/* 1997-11-05  | Inspected for Win32 comp.               | FB                */
/*****************************************************************************/

#ifndef _COMMON_DEF_HPP_
#define _COMMON_DEF_HPP_

#include <istring.hpp>

#ifndef __TOS_OS2__     // !!!! NOT OS/2
  #define  DID_OK     1
#endif

// Non visual defines.

    // Default values.
const char    MANUAL_TAG[]      ="MANUAL.TAG"                        ;
#ifdef __TOS_OS2__
const char    XMAILER_TAG[]     ="PMMail 1.95a for OS/2 with Bandit Tagger v2.03" ;
const char    PMM_XNEWS_TAG[]    ="PMINews 1.01a For OS/2 with Bandit Tagger v2.03";
const char    IA_XNEWS_TAG[]    ="Internet Adventurer v1.20 for OS/2 with Bandit Tagger v2.03";
const char    IA_XMAILER_TAG[]  ="Internet Adventurer v1.20 for OS/2 with Bandit Tagger v2.03";
const char    MRICE_XMAILER_TAG[]
                                ="MR/2 Internet Cruiser Edition for OS/2 v1.38 with Bandit Tagger v2.03";
const char    X_TAG[]           ="X-Tag: Bandit Tagger v2.03 - Registered to : ";
const char    X_TAG_ANONYMOUS[] ="X-Tag: Bandit Tagger v2.03 - Registered user";
const char    BANDIT_ADVERTISE[]="\n \n** Tag(s) inserted by Bandit Tagger v2.03 - http://www.gbar.dtu.dk/~c918704";
const char    HTML_BANDIT_ADVERTISE[]="<BR> <BR>** Tag(s) inserted by Bandit Tagger 2.03 - http://www.gbar.dtu.dk/~c918704";
const char    WITH_BANDIT_TAGGER[]
                                =" with Bandit Tagger v2.03";
#else
const char    XMAILER_TAG[]     ="PMMail98 with Bandit Tagger98";
const char    X_TAG[]           ="X-Tag: Bandit Tagger98 - Registered to : [UNREGISTERED]";
const char    X_TAG_REMOVE[]    = "[UNREGISTERED]";
const char    X_TAG_ANONYMOUS[] ="X-Tag: Bandit Tagger98 - Registered user";
const char    BANDIT_ADVERTISE[]     ="\n \n** Tag(s) inserted by Bandit Tagger98 - http://www.gbar.dtu.dk/~c918704";
const char    HTML_BANDIT_ADVERTISE[]="<BR> <BR>** Tag(s) inserted by Bandit Tagger98 - http://www.gbar.dtu.dk/~c918704";
const char    WITH_BANDIT_TAGGER[]
                                =" with Bandit Tagger98";
#endif

const char    NEWLINE[]            ="\"^\""                                              ;
const char    TAG_FILE_MASK[]   ="*.TAG"                                              ;
const char    INI_FILE_MASK[]   ="*.INI"                                              ;
const char    ANONYMOUS[]        ="!ANONYMOUS"                                              ;
// The keys, app name & name for the inifile..
#ifdef __TOS_OS2__
const char    INI_FILE[]           ="bandit.ini"                                         ;
#else
const char    INI_FILE[]           ="Bandit Tagger"                                      ;
#endif
const char    APP_FILE[]           ="BANDIT"                                             ;
const char    APP_USER[]           ="BANDIT_USER"                                        ;
const char    APP_SEQUENCE[]       ="BANDIT_SEQUENTIAL"                                  ;
const char    APP_BANDIT_ADDER[]   ="BANDIT_ADDER"                                       ;
const char    KEY_TAGFILES[]       ="TAG_FILES"                                          ;
const char    KEY_MANUAL_TAG[]     ="MANUAL_TAG"                                         ;
const char    KEY_PAUSE[]          ="PAUSE"                                              ;
const char    KEY_XMAILER[]        ="X_MAILER"                                           ;
const char    KEY_XNEWS  []        ="X_NEWS"                                             ;
const char    KEY_REMOVE_XMAILER[] ="Remove X-Mailer"                                    ;
const char    KEY_REMOVE_XNEWS  [] ="Remove X-News"                                      ;
const char    KEY_ADVERTISE     [] ="Advertise"                                          ;
const char    KEY_WINDOWLIST    [] ="windowList"                                         ;
const char    KEY_NO_REPLACE    [] ="noReplace"                                         ;
const char    KEY_NEWLINE[]        ="NEWLINE"                                            ;
const char    KEY_WYSIWYG[]        ="WYSIWYG"                                            ;
const char    KEY_PREVIOUS_SEL[]   ="Previous selection"                                 ;
const char    KEY_DEFAULT_SEL[]    ="Default selection"                                  ;
const char    KEY_DEFAULT_FILE[]   ="Default tagfile"                                    ;
const char    KEY_SEQUENTIAL[]     ="SEQUENTIAL"                                         ;
const char    KEY_NAME[]           ="Register name"                                      ;
const char    KEY_KEY[]            ="Register key"                                       ;
const char    KEY_NETSCAPEINI[]    ="Netscape Ini-file"                                       ;
const char    KEY_ANONYMOUS_NAME[] ="Anonymous name"                                       ;
const char    KEY_ANONYMOUS_EMAIL[]="Anonymous e-mail"                                       ;
const char    UNREGISTRED[]        ="UNREGISTERED"                                       ;
const char    XMAILER[]            ="X-Mailer"                                           ;
const char    XNEWS  []            ="X-Newsreader"                                       ;
const char    SUBJECT[]            ="Subject:"                                           ;
const char    DEMONSTRATION[]      ="DEMONSTRATION"                                      ;
const char    TAG_TITLE_FILEDLG[]  ="Select one tag file."                               ;
const char    INI_TITLE_FILEDLG[]  ="Select ini file."                               ;
const char    TXT_UNREGISTERED[]   ="This version of Bandit Tagger is unregistered."     ;
const char    TXT_REGISTERED_TO[]  ="Registered"                                         ;
const char    TXT_LISTBOX_NOT_REG[]="Only 2 lists avaliable in the unregistered version.";

const char    NETSCAPE_SIGNATURE[] ="SigFile"                                            ;
const char    NETSCAPE_USER[]      ="User"                                               ;

const char    PATH[]               ="PATH"                                               ;
const char    NETSCAPE_INI[]       ="\\Netscape.ini"                                     ;
const char    SEARCH_NETSCAPE[]    ="NETSCAPE"                                           ;
const char    RANDOM_TAG[]         ="!RANDOM.TAG"                                        ;
const char    HTML_START[]         ="<HTML>"                                             ;
const char    HTML_END[]           ="</HTML>"                                            ;
const char    IMA_ID[]             ="IMA.BOUNDARY.HTML_"                                 ;
#endif
