/*****************************************************************************/
/* FA Partners - Created by Flemming Bregnvig bregnvig@usa.net               */
/* Copyright (c) FA Partners 1997                                            */
/*---------------------------------------------------------------------------*/
/* File        : hookApplication.hpp                                         */
/* Contains    : This class extract a hwnd from a foreign application and    */
/*               sets up a command hook with an ID.                          */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-12-22  | Created                                 | FB                */
/* 199X-XX-XX  |                                         |                   */
/*****************************************************************************/

#ifndef _INTERCEPT_HPP_
#define _INTERCEPT_HPP_

#include <istring.hpp>
#include <ihandle.hpp>

#define INCL_DOS
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_WIN
#include <os2.h>

class BANIntercept{
    //* Privat members.     ****************************************************
    IString         _taskName;
    PSWENTRY        _pswEntry;
    //* Prvate functions *****************************************************
  public:
    //* Constuctor ***********************************************************
    BANIntercept(const IString& taskName)
    : _taskName(taskName)
    {}
    //* Destructor ***********************************************************
    virtual ~BANIntercept() {}
    //* Public functions *****************************************************
    Boolean       getSwitchEntry();
    Boolean       postCommand(unsigned long eventId, const IEventData& mp1, const IEventData& mp2);
    IWindowHandle handle() {return IWindowHandle(((PSWCNTRL)&_pswEntry->swctl)->hwnd);}
};

#endif
