/*****************************************************************************/
/* FA Partners - Created by Flemming Bregnvig bregnvig@usa.net               */
/* Copyright (c) FA Partners 1997, 1998                                      */
/*---------------------------------------------------------------------------*/
/* Name        : netscape.hpp                                                */
/* Description : Handles all the stuff related to netscape.                  */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1998-01-28  | Created                                 | FB                */
/*****************************************************************************/

#ifndef _NETSCAPE_HPP_
#define _NETSCAPE_HPP_

#include <ihandler.hpp>

#include "..\..\BanditTagger\Tagger\tagini.hpp"
#include "..\..\BanditTagger\tagger\mailmain.hpp"

extern "C" {
  #include <hookdll.h>
}


// Defines the procedures that the Dll offers.
typedef void EXPENTRY _INITDLL (HAB hab, ULONG id, HWND hwnd);
typedef _INITDLL* PINITDLL;
typedef void EXPENTRY _STARTINPUTHOOK(void);
typedef _STARTINPUTHOOK* PSTARTINPUTHOOK;
typedef void EXPENTRY _STOPINPUTHOOK(void);
typedef _STOPINPUTHOOK* PSTOPINPUTHOOK;
typedef void EXPENTRY _DESTROYDLL(void);
typedef _DESTROYDLL* PDESTROYDLL;

class IObjectWindow;
class IClipboard;
class IBitmapHandle;
class BANNetscapeHandler;

class BANNetscape
{
  //* Private ***********************************************************
  private:
  IClipboard*         _pclipboard;
  IWindowHandle*      _pmleHandle;
  MailHandler*        _pmail;
  MailTagger*         _ptagger;
  IObjectWindow*      _pobjectWindow;
  BANNetscapeHandler* _pnetscapeHandler;
  TAGUserIni&         _userIni;

  IString             _mleContents;
  IString             _clipboardText;
  IBitmapHandle*      _pclipboardBitmap;
  long                _iptPrevAnchor;
  long                _iptPrevCursor;
  HMODULE             _hmod;

  //* Private functions *************************************************
  Boolean       insertTags();
  Boolean       createTags();
  Boolean       getMailText();
  Boolean       setMailText();
  Boolean       saveClipboard();
  Boolean       restoreClipboard();
  Boolean       loadDLL();

  //* Public  ***********************************************************
  // Constructor
  public:
  BANNetscape(TAGUserIni& userIni)
  : _userIni(userIni)
  , _pclipboardBitmap(0) {};
  ~BANNetscape();
  Boolean start();
  Boolean handleTags(const IWindowHandle& frameHandle);
};

class BANNetscapeHandler : public IHandler
{
  //* Private ***********************************************************
  private:
  BANNetscape&   _netscape;
  IObjectWindow* _pobjectWindow;

  //* Protected ***********************************************************
  protected:
    virtual Boolean dispatchHandlerEvent(IEvent& event);
  //* Public *************************************************************
  public:
  BANNetscapeHandler(IObjectWindow* objectWindow, BANNetscape& netscape);
};

class BANCommandHandler : public ICommandHandler
{
  //* Private ***********************************************************
  private:
  IObjectWindow*    _pobjectWindow;
  public:
  BANCommandHandler(IObjectWindow* objectWindow)
  : _pobjectWindow(objectWindow) {};
  protected:
  virtual Boolean systemCommand(ICommandEvent& cmdEvent);
};

#endif
