/*****************************************************************************/
/* FA Partners - Created by Flemming Bregnvig bregnvig@stealthmail.com       */
/* Copyright (c) FA Partners 1997                                            */
/*---------------------------------------------------------------------------*/
/* File        :                                                             */
/* Description :                                                             */
/*                                                                           */
/*---------------------------------------------------------------------------*/
/* History                                                                   */
/*---------------------------------------------------------------------------*/
/* Date        | Event                                   | Person            */
/*---------------------------------------------------------------------------*/
/* 1997-08-13  | Created                                 | FB                */
/* 1997-11-05  | Inspected for Win32 comp.               | FB                */
/*---------------------------------------------------------------------------*/
/* Compile     :                                                             */
/*****************************************************************************/

#include "..\..\BanditTagger\Tagger\commonDef.hpp"
#include "..\..\BanditTagger\tagger\tagini.hpp"
#include "..\..\BanditTagger\tagger\register.hpp"

#ifdef __TOS_OS2__
 #include <stdlib.h>
#endif
//***************************************************************************
// TAGUserIni::TAGUserIni
// Input parameters : const IString&
// The constructs the TAGUserIni
// Returncodes :
//***************************************************************************

TAGUserIni::TAGUserIni(const IString& exename)
#ifdef __TOS_OS2__
:_profile(exename.subString(1, exename.lastIndexOf("\\"))+INI_FILE)
,_xMailer(IA_XMAILER_TAG)
,_xNews(IA_XNEWS_TAG)
#else
:_profile(INI_FILE)
,_xMailer(XMAILER_TAG)
#endif
,_pause(2000)
,_tagfiles(exename.subString(1, exename.lastIndexOf("\\")))
,_manualTag(MANUAL_TAG)
,_newline(NEWLINE)
,_removeXMailer(false)
,_removeXNews(false)
,_advertise(false)
,_wysiwyg(false)
,_sequential(false)
,_defaultSelection(false)
,_previousSelection(0)
,_windowList(true)
,_noReplace(false)
{

  _profile.setDefaultApplicationName(APP_USER);

  if (_profile.containsKeyName(KEY_TAGFILES))
    _tagfiles  = _profile.elementWithKey(KEY_TAGFILES);

  if (_profile.containsKeyName(KEY_MANUAL_TAG))
    _manualTag = _profile.elementWithKey(KEY_MANUAL_TAG);

  if (_profile.containsKeyName(KEY_PAUSE))
    _pause     = _profile.integerWithKey(KEY_PAUSE);

  if (_profile.containsKeyName(KEY_XMAILER))
    _xMailer   = _profile.elementWithKey(KEY_XMAILER);

  if (_profile.containsKeyName(KEY_XNEWS))
    _xNews     = _profile.elementWithKey(KEY_XNEWS);

  if (_profile.containsKeyName(KEY_REMOVE_XMAILER))
    _removeXMailer = _profile.integerWithKey(KEY_REMOVE_XMAILER);

  if (_profile.containsKeyName(KEY_REMOVE_XNEWS))
    _removeXNews   = _profile.integerWithKey(KEY_REMOVE_XNEWS);

  if (_profile.containsKeyName(KEY_ADVERTISE))
    _advertise     = _profile.integerWithKey(KEY_ADVERTISE);

  if (_profile.containsKeyName(KEY_WINDOWLIST))
    _windowList    = _profile.integerWithKey(KEY_WINDOWLIST);

  if (_profile.containsKeyName(KEY_NO_REPLACE))
    _noReplace     = _profile.integerWithKey(KEY_NO_REPLACE);

  if (_profile.containsKeyName(KEY_NEWLINE))
    _newline   = _profile.elementWithKey(KEY_NEWLINE);

  if (_profile.containsKeyName(KEY_NAME))
    _name      = _profile.elementWithKey(KEY_NAME);

  if (_profile.containsKeyName(KEY_KEY))
    _key       = _profile.elementWithKey(KEY_KEY);

  if (_profile.containsKeyName(KEY_WYSIWYG))
    _wysiwyg   = _profile.integerWithKey(KEY_WYSIWYG);

  if (_profile.containsKeyName(KEY_SEQUENTIAL))
    _sequential = _profile.integerWithKey(KEY_SEQUENTIAL);

  if (_profile.containsKeyName(KEY_ANONYMOUS_NAME))
    _anonymousName  = _profile.elementWithKey(KEY_ANONYMOUS_NAME);
  if (_profile.containsKeyName(KEY_ANONYMOUS_EMAIL))
    _anonymousEmail = _profile.elementWithKey(KEY_ANONYMOUS_EMAIL);

  if (_profile.containsKeyName(KEY_DEFAULT_SEL, APP_BANDIT_ADDER))
    _defaultSelection = _profile.integerWithKey(KEY_DEFAULT_SEL, APP_BANDIT_ADDER);

  if (_profile.containsKeyName(KEY_PREVIOUS_SEL, APP_BANDIT_ADDER))
    _previousSelection = _profile.integerWithKey(KEY_PREVIOUS_SEL, APP_BANDIT_ADDER);

  if (_profile.containsKeyName(KEY_DEFAULT_FILE, APP_BANDIT_ADDER))
    _defaultTagfile = _profile.elementWithKey(KEY_DEFAULT_FILE, APP_BANDIT_ADDER);



}

//***************************************************************************
// TAGUserIni::registered
// Input parameters :
// This procedure test the reg code.
// Returncodes : Boolean.
//***************************************************************************

Boolean TAGUserIni::registered() const
{
  return Boolean(TestRegistration(_name, _key));
}

//***************************************************************************
// TAGUserIni::save
// Input parameters :
// The save the new user preference.
// Returncodes : Boolean.
//***************************************************************************

Boolean TAGUserIni::save()
{
  _profile.setDefaultApplicationName(APP_USER);

  _profile.addOrReplaceElementWithKey(KEY_TAGFILES       , _tagfiles)
          .addOrReplaceElementWithKey(KEY_MANUAL_TAG     , _manualTag)
          .addOrReplaceElementWithKey(KEY_PAUSE          , _pause)
          .addOrReplaceElementWithKey(KEY_XMAILER        , _xMailer)
          .addOrReplaceElementWithKey(KEY_XNEWS          , _xNews)
          .addOrReplaceElementWithKey(KEY_REMOVE_XMAILER , _removeXMailer)
          .addOrReplaceElementWithKey(KEY_REMOVE_XNEWS   , _removeXNews)
          .addOrReplaceElementWithKey(KEY_ADVERTISE      , _advertise)
          .addOrReplaceElementWithKey(KEY_WINDOWLIST     , _windowList)
          .addOrReplaceElementWithKey(KEY_NO_REPLACE     , _noReplace)
          .addOrReplaceElementWithKey(KEY_NEWLINE        , _newline)
          .addOrReplaceElementWithKey(KEY_NAME           , _name)
          .addOrReplaceElementWithKey(KEY_KEY            , _key)
          .addOrReplaceElementWithKey(KEY_WYSIWYG        , _wysiwyg)
          .addOrReplaceElementWithKey(KEY_SEQUENTIAL     , _sequential)
          .addOrReplaceElementWithKey(KEY_ANONYMOUS_NAME , _anonymousName)
          .addOrReplaceElementWithKey(KEY_ANONYMOUS_EMAIL, _anonymousEmail)
          .addOrReplaceElementWithKey(KEY_PREVIOUS_SEL   , _previousSelection, APP_BANDIT_ADDER)
          .addOrReplaceElementWithKey(KEY_DEFAULT_SEL    , _defaultSelection, APP_BANDIT_ADDER)
          .addOrReplaceElementWithKey(KEY_DEFAULT_FILE   , _defaultTagfile, APP_BANDIT_ADDER);

  return true;
}

//***************************************************************************
// TAGUserIni::~TAGUserIni
// Input parameters :
// The destructs the TAGUserIni object.
// Returncodes :
//***************************************************************************

TAGUserIni::~TAGUserIni()
{
//  if (this->result() == DID_OK)
//     this->save();
}
