#include "hookdll.h"

/***********************************************************************/
/*  Global variables.                                                  */
/***********************************************************************/
HAB     habDLL;
HMODULE hMod;
PFN     pfnInput;
ULONG   commandId;
HWND    hwndReceiver;
APIRET  rc;

/***********************************************************************/
/*  InitDLL: This function sets up the DLL and sets all variables      */
/***********************************************************************/
void EXPENTRY InitDLL(HAB hab,  ULONG id, HWND hwnd)
{
    habDLL = hab;

/***********************************************************************/
/*  Load the DLL - actually, just get our module handle.               */
/***********************************************************************/
    rc = DosLoadModule(NULL, 0, "HOOKDLL", &hMod);

/***********************************************************************/
/*  Find the address of the input hook procedure.                      */
/***********************************************************************/
    rc = DosQueryProcAddr(hMod, 0, "InputProc", &pfnInput);

/***********************************************************************/
/*  Tells the hook what to respond to.                                 */
/***********************************************************************/

  commandId = id;
  hwndReceiver = hwnd;
}

/***********************************************************************/
/*  StartInputHook: This function starts the hook filtering.           */
/***********************************************************************/
void EXPENTRY StartInputHook(void)
{
/***********************************************************************/
/*  Set a hook to our input filter routine.                            */
/***********************************************************************/
  BOOL    rc =
  WinSetHook(habDLL, NULLHANDLE, HK_INPUT, pfnInput, hMod);
}

/***********************************************************************/
/*  StopInputHook: This function stops the hook filtering.             */
/***********************************************************************/
void EXPENTRY StopInputHook(void)
{

/***********************************************************************/
/*  Drop a hook to our input filter routine.                           */
/***********************************************************************/
    WinReleaseHook(habDLL, NULLHANDLE, HK_INPUT, pfnInput, hMod);
}
/***********************************************************************/
/*  DestroyDLL   : This function decrements the DDL usage.             */
/***********************************************************************/
void EXPENTRY DestroyDLL(void)
{
/***********************************************************************/
/*  Decrement the DLL usage count.                                     */
/***********************************************************************/
    rc = DosFreeModule(hMod);
}

/***********************************************************************/
/*  InputProc: This is the input filter routine.                       */
/*  While the hook is active, all messages come here                   */
/*  before being dispatched.                                           */
/***********************************************************************/
BOOL EXPENTRY InputProc(HAB hab, PQMSG pqMsg, ULONG fs)
{
    // Sends a WM_QUIT to the hwndReceiver.
    #if 0
    if (pqMsg->msg == WM_QUIT || pqMsg->msg == WM_CLOSE ||
        (pqMsg->msg == WM_SYSCOMMAND && SHORT1FROMMP(pqMsg->mp1) == SC_CLOSE))
      WinPostMsg(hwndReceiver, UM_QUIT, MPFROMHWND(pqMsg->hwnd), 0L);
    #endif

/***********************************************************************/
/*  Check for WM_COMMAND messages.                                     */
/***********************************************************************/
/***********************************************************************/
/*  Passes all WM_COMMAND messages except for the specified commandId  */
/***********************************************************************/
    if (pqMsg->msg == WM_COMMAND && commandId == SHORT1FROMMP(pqMsg->mp1)) {
      // Since the commandId is already know by the receiver, I send the hwnd
      // instead
      WinPostMsg(hwndReceiver, UM_COMMANDID_RECEIVED, MPFROMHWND(pqMsg->hwnd), pqMsg->mp2);
      return TRUE;
    } else
      return FALSE;


/***********************************************************************/
/*  Pass the message on to the next hook in line.                      */
/***********************************************************************/
   return FALSE;
}

