/* RBLtest.cmd v1.0 */
/* Part of RBLcheck */
/* Copyright (C) 2005 Jeroen Besse */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
rc= RxFuncAdd("SockLoadFuncs","RxSock","SockLoadFuncs")
rc= SockLoadFuncs()

numberofchecks= 3

Profile="default"
inifile="RBLcheck.ini"
parse arg parameters
do while parameters<> ""
  lparameter= left(parameters, 1)
  if pos(lparameter, '-/"')> 0 then
  do
    if lparameter= '"' then
    do
      tweede= pos('"', parameters, 2)
      inifile= strip(left(parameters,tweede))
      parameters= strip(substr(parameters, tweede+1))
    end
    else
    do
      parse var parameters parameter parameters
      if pos("P:", translate(parameter))= 2 then
        Profile= substr(parameter,4)
    end
  end
  else
  do
    parse var parameters inifile parameters
  end
end
inifile = strip(inifile,'B','"')
RBLnames= ''
RBLs= ''
LookupTimeout= 30

/* read ini file */
ThisProfile= 1
call linein inifile,1,0
do while lines(inifile)
  iniline= linein(inifile)
  if left(iniline, 1)="[" then
  do
    if iniline= "["Profile"]" then
      ThisProfile= 1
    else
      ThisProfile= 0
  end
  if ThisProfile= 1 then
  do
    iniline= space(translate(iniline,' ','	'))
    parse var iniline iniword1 iniword2 iniword3 iniword4 iniword5
    iniwordt= translate(iniword1)
    select
      when iniwordt= 'RBL' then
      do
        RBLs= RBLs' 'iniword2' 'iniword3' 'iniword4
        RBLnames= RBLnames' 'iniword2
      end
      when iniwordt= 'LOOKUPTIMEOUT' then
        LookupTimeout= iniword2
      otherwise
        nop
    end /* select */
  end
end  
call stream inifile,'c','close'
RBLs= space(RBLs)
RBLnames= space(RBLnames)

say '--- RBLtest started'
say 'Ini: 'inifile
say 'Profile: 'Profile
say 'RBLs: 'RBLnames
say 'LookupTimeout: 'LookupTimeout

/* create random IP addresses */
IPaddresses= ''
do numberofchecks
  IPaddresses= IPaddresses random(1,254)'.'random(1,254)'.'random(1,254)'.'random(1,254)
end
IPaddresses= space(IPaddresses)

/* check IP addresses */
do while words(IPaddresses)> 0
  RBLrun= RBLs
  parse var IPaddresses IPaddress IPaddresses

  do while words(RBLrun)> 0
    parse var RBLrun qName qDNS qWeight RBLrun
    /* reverse bytes of IP address */
    parse var IPaddress byte1 '.' byte2 '.' byte3 '.' byte4
    rIP= byte4'.'byte3'.'byte2'.'byte1
    GHBNhost.!addr= '-'
    rDNS= ""
    /* check at RBL */
    /* say "Query "rIP"."qDNS" ..." */
    dummy= time("R")
    rc=SockGetHostByName(rIP'.'qDNS, "GHBNhost.!")
    lookuptime= time("R")
    lookuptime= left(lookuptime, length(lookuptime)-4)
    if errno<> 0 then
    do
      rDNS= "ERROR: "errno
    end
    drop GHBNhost.
    say qName '('rIP'.'qDNS'): ' lookuptime 's' rDNS
  end
  if words(IPaddresses)> 0 then
  do
    call charout ,"  "
    "@pause"
  end
end

exit
