/*

 Sparkles!

 Another Useless REXX by Tim Middleton (as544@torfree.net)

*/

delay  = 0
Height = 25
Width  = 80

/***************************************************************************/

chrs = '++oO**=....@'
bkch = '..+'

/* foreground colours */
Black  = D2C(27)||'[30m'; Red   = D2C(27)||'[31m'; Green   = D2C(27)||'[32m';
Yellow = D2C(27)||'[33m'; Blue  = D2C(27)||'[34m'; Magenta = D2C(27)||'[35m';
Cyan   = D2C(27)||'[36m'; White = D2C(27)||'[37m';

/* background colours */
bgBlack  = D2C(27)||'[40m'; bgRed     = D2C(27)||'[41m';
bgGreen  = D2C(27)||'[42m'; bgYellow  = D2C(27)||'[43m';
bgBlue   = D2C(27)||'[44m'; bgMagenta = D2C(27)||'[45m';
bgCyan   = D2C(27)||'[46m'; bgWhite   = D2C(27)||'[47m';

/* colour attributes (note: NORMAL resets everything to gray on black) */
Normal = D2C(27)||'[0m'; Bright = D2C(27)||'[1m';Blink  = D2C(27)||'[5m';

/* cursor position (see fuctions way down at the end) */
SavePos  = D2C(27)||'[s'; RestorePos = D2C(27)||'[u';

/* ansi clear screen (change colour first to change screen colour) */
AnsiClear  = D2C(27)||'[2J'; 

/* erase from current position to end of current screen line */
ClearEOL = D2C(27)||'[K';

call rxFuncAdd 'syssleep', 'rexxutil', 'syssleep'

signal on novalue
signal on halt

chrs = left(chrs,length(chrs) * 4 - length(bkch))||bkch
nchrs = length(chrs)
if height // 2 = 0 then height = height - 1
mx = (width+2) % 2
my = (height+2) % 2

clr.0 = 12
clr.1 = normal||cyan
clr.2 = normal||blue
clr.3 = normal||white
clr.4 = bright||white
clr.5 = bright||yellow
clr.6 = normal||red
clr.7 = bright||black
clr.8 = bright||blue
clr.9 = bright||cyan
clr.10= normal||white
clr.11= normal||cyan
clr.12= normal||blue

ret = charout(,ansiclear)
ret = charout(,ansi_xy(1,height+1)||bgBlue||bright||blue||' Sparkles!'||cleareol);
ret = charout(,bgBlack);

do forever
    cl = random(1,clr.0)
    ax = random(0,mx-1)
    ay = random(0,my-1)
    ac = random(1,nchrs)
    ret = charout(,ansi_xy(mx+ax,my+ay)||clr.cl||substr(chrs,ac,1))
    ret = charout(,ansi_xy(mx-ax,my-ay)||clr.cl||substr(chrs,ac,1))
    ret = charout(,ansi_xy(mx+ax,my-ay)||clr.cl||substr(chrs,ac,1))
    ret = charout(,ansi_xy(mx-ax,my+ay)||clr.cl||substr(chrs,ac,1))
    ret = charout(,ansi_xy(72,height+1)||bgBlue||bright||blue||time()||bgBlack)
    call syssleep delay;
end


EXIT

/* position cursor where ansi_xy(1,1) is top left of screen */
ansi_xy : procedure
x = arg(1) - 1;
y = arg(2) - 1;
return D2C(27)||'['||y||';'||x||'H';


/* cursor moves - AnsiUp() moves up one line. AnsiUp(10) moves up 10 lines */
AnsiUp : Procedure
x = arg(1);
return D2C(27)'['||x||'A'; 

AnsiDown : Procedure
x = arg(1);
return D2C(27)'['||x||'B'; 

AnsiRight : Procedure
x = arg(1);
return D2C(27)'['||x||'C'; 

AnsiLeft  : Procedure
x = arg(1);
return D2C(27)'['||x||'D'; 

halt:
    /* ret = charout(,D2C(27)||'[0;'||height-1||'H'||bgblack||normal||white); */
    /* ret = charout(,ansi_xy(1,height)||bgblack||normal||white); */
    ret = charout(,D2C(27)||'['||(height-1)||';'||0||'H'||bgblack||normal||white);
    exit
    

