// ---------------------------------------------------------------------------
//  PC-8801 emulator
//  Copyright (C) cisc 1999.
// ---------------------------------------------------------------------------
//  荞݃Rg[(PD8214)
// ---------------------------------------------------------------------------
//  $Id: intc.cpp,v 1.8 1999/03/28 06:55:59 cisc Exp $
//

#include "headers.h"
#include "misc.h"
#include "pc88/intc.h"

//#define LOGNAME "intc"
#include "diag.h"

using namespace PC8801;

#ifdef __OS2__
inline int Min(int x, int y) { return (x < y) ? x : y; }
#endif

// ---------------------------------------------------------------------------
//  \zj
//
INTC::INTC(const ID& id)
: Device(id)
{
}

INTC::~INTC()
{
}

// ---------------------------------------------------------------------------
//  Init
//
bool INTC::Init(IOBus* b, uint ip)
{
    bus = b;
    irqport = ip;
    irq = mask = mask2 = 0;
    return true;
}

// ---------------------------------------------------------------------------
//  荞ݏ󋵂̍XV
//
inline void INTC::IRQ(bool flag)
{
    bus->Out(irqport, flag);
}

// ---------------------------------------------------------------------------
//  Reset
//
void INTC::Reset(uint, uint)
{
    irq = mask = mask2 = 0;
    IRQ(false);
}

// ---------------------------------------------------------------------------
//  荞ݗv
//  |[gԍ̉RP^荞ݔԍ
//
void INTC::Request(uint port, uint en)
{
    uint bit = 1 << (port & 7);
    if (en)
    {
        bit &= mask2;
        // request
        if (!(irq & bit))
        {
            irq |= bit;
            IRQ((irq & mask & mask2) != 0);
        }
    }
    else
    {
        // cancel
        if (irq & bit)
        {
            irq &= ~bit;
            IRQ((irq & mask & mask2) != 0);
        }
    }
}

// ---------------------------------------------------------------------------
//  CPU 荞݂󂯎
//
uint INTC::IntAck(uint)
{
    uint ai = irq & mask & mask2;
    for (int i=0; i<8; i++, ai>>=1)
    {
        if (ai & 1)
        {
            irq &= ~(1 << i);
            mask = 0;
            IRQ(false);

            return i * 2;
        }
    }
    return 0;
}

// ---------------------------------------------------------------------------
//  }XNݒ(porte6)
//
void INTC::SetMask(uint, uint data)
{
//  const static int8 table[8] = { ~0, ~4, ~2, ~6, ~1, ~5, ~3, ~7 };
    const static int8 table[8] = { ~7, ~3, ~5, ~1, ~6, ~2, ~4, ~0 };
    mask2 = table[data & 3];
    irq &= mask2;
    IRQ((irq & mask & mask2) != 0);
    LOG1("p[e6] = %.2x\n", data);
}

// ---------------------------------------------------------------------------
//  WX^ݒ(porte4)
//
void INTC::SetRegister(uint, uint data)
{
    mask = ~(-1 << Min(8, data));
//  mode = (data & 7) != 0;
    IRQ((irq & mask & mask2) != 0);
    LOG1("p[e4] = %.2x\n", data);
}

// ---------------------------------------------------------------------------
//  device description
//
const Device::Descriptor INTC::descriptor =
{
    INTC::indef, INTC::outdef
};

const Device::OutFuncPtr INTC::outdef[] =
{
#ifndef __OS2__
    static_cast<OutFuncPtr> (Reset),
    static_cast<OutFuncPtr> (Request),
    static_cast<OutFuncPtr> (SetMask),
    static_cast<OutFuncPtr> (SetRegister),
#else
    (Device::OutFuncPtr) (Reset),
    (Device::OutFuncPtr) (Request),
    (Device::OutFuncPtr) (SetMask),
    (Device::OutFuncPtr) (SetRegister),
#endif
};

const Device::InFuncPtr INTC::indef[] =
{
#ifndef __OS2__
    static_cast<InFuncPtr> (IntAck),
#else
    (Device::InFuncPtr) (IntAck),
#endif
};
