// ---------------------------------------------------------------------------
//	M88 - PC-88 Emulator.
//	Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//   ROM
// ---------------------------------------------------------------------------
//	$Id: kanjirom.h,v 1.3 1999/03/16 13:13:38 cisc Exp $

#if !defined(pc88_kanjirom_h)
#define pc88_kanjirom_h

#include "device.h"

namespace PC8801
{

class KanjiROM : public Device  
{
public:
	enum
	{
		setl = 0, seth
	};
	
	enum
	{
		readl = 0, readh
	};

public:
	KanjiROM(const ID& id);
	~KanjiROM();

	bool Init(const char* filename);

	void SetL(uint p, uint d);
	void SetH(uint p, uint d);
	uint ReadL(uint p);
	uint ReadH(uint p);

	const Descriptor* GetDesc() const { return &descriptor; } 
	
private:
	uint adr;
	uint8* image;

	static const Descriptor descriptor;
	static const InFuncPtr indef[];
	static const OutFuncPtr outdef[];
};

};

#endif // !defined(pc88_kanjirom_h)
