// ---------------------------------------------------------------------------
//  M88 - PC-8801 Emulator.
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  CriticalSection Class for Win32
// ---------------------------------------------------------------------------
//  $Id: CritSect.h,v 1.2 1999/03/21 01:41:40 cisc Exp $

#ifndef Win32_CriticalSection_h
#define Win32_CriticalSection_h

#ifndef __OS2__
class CriticalSection
{
    CRITICAL_SECTION css;
public:
    class Lock
    {
        CRITICAL_SECTION* css;
    public:
        Lock(CriticalSection& cs) : css(&cs.css) { EnterCriticalSection(css); }
        ~Lock() { LeaveCriticalSection(css); }
    };
    friend class Lock;

    CriticalSection() { InitializeCriticalSection(&css); }
    ~CriticalSection() { DeleteCriticalSection(&css); }
};
#else
class CriticalSection
{
public:
    class Lock
    {
    public:
        Lock(CriticalSection& ) {
//            DosEnterCritSec();
        }
        ~Lock() {
//            DosExitCritSec();
        }
    };
    friend class Lock;

    CriticalSection() {
    }
    ~CriticalSection() {
    }
};
#endif
#endif // Win32_CriticalSection_h
