// ---------------------------------------------------------------------------
//  M88 - PC88 emulator
//  Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//  GDI ɂʕ` (HiColor ȏ)
// ---------------------------------------------------------------------------
//  $Id: DrawGDI.cpp,v 1.3 1999/03/28 06:56:41 cisc Exp $

//  bug:pbg`(T-T

#include "headers.h"
#include "WinDraw.h"
#include "DrawGDI.h"

//  ʍ heap Ŋ蓖ĂgH
static const bool imageinheap = false;

// ---------------------------------------------------------------------------
//  \z/
// ---------------------------------------------------------------------------

WinDrawGDI::WinDrawGDI()
{
    hwnd = 0;
    hbitmap = 0;
    updatepal = false;
    bitmapimage = 0;
    bpl = 640;
}

WinDrawGDI::~WinDrawGDI()
{
    Cleanup();
}

// ---------------------------------------------------------------------------
//  
// ---------------------------------------------------------------------------

bool WinDrawGDI::Init(HWND hwindow)
{
    hwnd = hwindow;
    height = 400;

    if (!MakeBitmap()) return false;

    if (imageinheap)
    {
        image = new uint8[640*400];
        if (!image) return false;
    }
    else
        image = bitmapimage;
    memset(image, 0x40, 640*400);
    return true;
}

// ---------------------------------------------------------------------------
//  Еt
// ---------------------------------------------------------------------------

#ifdef __OS2__
bool WinDrawGDI::Cleanup()
{
    if (hbitmap)
    {
        GpiDeleteBitmap( hbitmap );  hbitmap = 0;
    }
    if (imageinheap)
    {
        delete[] image; image = 0;
    }
    return true;
}
#else
bool WinDrawGDI::Cleanup()
{
    if (hbitmap)
    {
        DeleteObject(hbitmap); hbitmap = 0;
    }
    if (imageinheap)
    {
        delete[] image; image = 0;
    }

    return true;
}
#endif

// ---------------------------------------------------------------------------
//  BITMAP 쐬
// ---------------------------------------------------------------------------

#ifdef __OS2__
bool WinDrawGDI::MakeBitmap()
{
/* ݂񂹂 */
    memset( &binfo.header, 0, sizeof(BITMAPINFOHEADER2) );
    binfo.header.cbFix           = sizeof(BITMAPINFOHEADER2);
    binfo.header.cx              = 640;
    binfo.header.cy              = 400;
    binfo.header.cPlanes         = 1;
    binfo.header.cBitCount       = 8;


    memset(binfo.colors, 0, sizeof(RGB2) * 256);

    if (!hbitmap)
        return false;

    return true;
}
#else
bool WinDrawGDI::MakeBitmap()
{
    binfo.header.biSize          = sizeof(BITMAPINFOHEADER);
    binfo.header.biWidth         = 640;
    binfo.header.biHeight        = -400;
    binfo.header.biPlanes        = 1;
    binfo.header.biBitCount      = 8;
    binfo.header.biCompression   = BI_RGB;
    binfo.header.biSizeImage     = 0;
    binfo.header.biXPelsPerMeter = 0;
    binfo.header.biYPelsPerMeter = 0;
    binfo.header.biClrUsed       = 256;
    binfo.header.biClrImportant  = 0;

    // pbgȂꍇ

    HDC hdc = GetDC(hwnd);
    memset(binfo.colors, 0, sizeof(RGBQUAD) * 256);

    hbitmap = CreateDIBSection( hdc,
                                (BITMAPINFO*) &binfo,
                                DIB_RGB_COLORS,
                                (void**)(&bitmapimage),
                                NULL,
                                0 );

    ReleaseDC(hwnd, hdc);

    if (!hbitmap)
        return false;

    return true;
}
#endif

// ---------------------------------------------------------------------------
//  pbgݒ
//  index Ԗڂ̃pbg pe Zbg
// ---------------------------------------------------------------------------

#ifdef __OS2__
void WinDrawGDI::SetPalette(PALETTEENTRY* pe)
{
    for (int i=0; i<0x90; i++)
    {
        binfo.colors[i+0x40].bRed = pe[i].peRed;
        binfo.colors[i+0x40].bBlue = pe[i].peBlue;
        binfo.colors[i+0x40].bGreen = pe[i].peGreen;
    }
    updatepal = true;
}
#else
void WinDrawGDI::SetPalette(PALETTEENTRY* pe)
{
    for (int i=0; i<0x90; i++)
    {
        binfo.colors[i+0x40].rgbRed = pe[i].peRed;
        binfo.colors[i+0x40].rgbBlue = pe[i].peBlue;
        binfo.colors[i+0x40].rgbGreen = pe[i].peGreen;
    }
    updatepal = true;
}
#endif
// ---------------------------------------------------------------------------
//  WM_QUERYNEWPALETTE
// ---------------------------------------------------------------------------

void WinDrawGDI::QueryNewPalette()
{
}

// ---------------------------------------------------------------------------
//  `
// ---------------------------------------------------------------------------

#ifdef __OS2__
void WinDrawGDI::DrawScreen(int top, int bottom, bool refresh)
{
    if (imageinheap && top <= bottom)
    {
        uint8* src = image + top * 640;
        uint8* dest = bitmapimage + top * 640;
        memcpy(dest, src, 640 * (bottom - top+ 1));
    }

    if (refresh)
    {
        refresh = false;
        top = 0;
        bottom = 399;
    }
}
#else
void WinDrawGDI::DrawScreen(int top, int bottom, bool refresh)
{
    if (imageinheap && top <= bottom)
    {
        uint8* src = image + top * 640;
        uint8* dest = bitmapimage + top * 640;
        memcpy(dest, src, 640 * (bottom - top+ 1));
    }

    if (refresh)
    {
        refresh = false;
        top = 0;
        bottom = 399;
    }

    if (top <= bottom || updatepal)
    {
        HDC hdc = GetDC(hwnd);
        HDC hmemdc = CreateCompatibleDC(hdc);
        HBITMAP oldbitmap = (HBITMAP) SelectObject(hmemdc, hbitmap);
        if (updatepal)
        {
            updatepal = false;
            SetDIBColorTable(hmemdc, 64, 144, &binfo.colors[64]);
            top = 0; bottom = height - 1;
        }
        BitBlt(hdc, 0, top, 640, Min(height, bottom) - top + 1, hmemdc, 0, top, SRCCOPY);
        if (bottom >= height)
        {
            HBRUSH hbrush = CreateSolidBrush(RGB(0, 0, 0));
            hbrush = (HBRUSH) SelectObject(hdc, hbrush);
            PatBlt(hdc, 0, height, 640, bottom-height+1, PATCOPY);
            SelectObject(hdc, hbrush);
        }

        SelectObject(hmemdc, oldbitmap);
        DeleteDC(hmemdc);
        ReleaseDC(hwnd, hdc);
    }
}
#endif

// ---------------------------------------------------------------------------
//  ʃC[W̎gpv
// ---------------------------------------------------------------------------

bool WinDrawGDI::Lock(uint8** pimage, int* pbpl)
{
    *pimage = image;
    *pbpl = bpl;
    return true;
}

// ---------------------------------------------------------------------------
//  ʃC[W̎gpI
// ---------------------------------------------------------------------------

bool WinDrawGDI::Unlock()
{
    return true;
}

// ---------------------------------------------------------------------------
//
//
void WinDrawGDI::Resize(uint w, uint h)
{
    height = h;
}