#!/bin/sh

rm -f config-host.h config-host.mak

# oops, sdl output is not worked on qemu-os2...what's wrong about it?
audiodrvs="sdl wav"
#audiodrvs="wav"

targets="i386-softmmu x86_64-softmmu"
#targets="i386-softmmu"

# use upper memory only for *huge* blocks
# by using API (DosAllocMem) directly (in qemu_memalign/qemu_valloc)
LDFLAGS="-Zno-high-mem -Zstack 0x4000"

./configure \
  --prefix="." \
  --target-list="$targets" \
  --audio-drv-list="$audiodrvs" \
  --audio-card-list="ac97 es1370 cs4231a gus sb16 adlib" \
  --enable-mixemu \
  --disable-aio \
  --disable-ipv6 \
  --disable-blobs \
  --extra-cflags="-O4 -mtune=pentium4 -march=pentium -I/usr/local/include" \
  --extra-ldflags="-s -L/usr/local/lib $LDFLAGS" \
  
