/*
 * Auto WGet Daemon Termination
 * Copyright (C) 1999-2005 Dmitry A.Steklenev
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * 4. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by Dmitry A.Steklenev".
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR OR CONTRIBUTORS "AS IS"
 * AND ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * AUTHOR OR THE CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id$
 */

globals = "cfg. local. msg. sys. color. dir. jobs. job. plugins. ico."

if translate( value( "AWGET_TRACE",, "OS2ENVIRONMENT" )) == "YES" then do
   call  value "AWGET_TRACE", "", "OS2ENVIRONMENT"
   trace intermediate
   trace results
end

call AwInit

cls
say  color.bold  || "Auto WGet Daemon " || color.usual || "Version" "1.9.4" "Termination"
say  color.usual || "Copyright (C) 1999-2005 Dmitry A.Steklenev"
say  color.usual || ""

call NlsLoad "awgmsg"
call CfgLoad
call AwStop

exit 0

/*------------------------------------------------------------------
 * $Id$
 * Initialization
 *------------------------------------------------------------------*/
AwInit: procedure expose (globals)

  if RxFuncQuery('SysLoadFuncs') then do
     call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
     call SysLoadFuncs
  end

  parse source os what program tail
  lpath = substr( program, 1, lastpos( "\", program )) ||,
          value( "BEGINLIBPATH",, "OS2ENVIRONMENT"  )

  "@SET BEGINLIBPATH="lpath

  if RxFuncQuery('AwLoadFuncs') then do
     call RxFuncAdd  'AwLoadFuncs', 'awget.dll', 'AwLoadFuncs'
     call AwLoadFuncs
  end

  "@ECHO OFF"

  sys.config_file   = value( "ETC",, "OS2ENVIRONMENT" )"\awget.cfg"
  sys.connected     = 1
  sys.active_time   = 0
  sys.clpmon_handle = ""
  sys.todo_stamp    = ""

  /* enable ANSI extended screen and keyboard control */
  '@ansi on > nul'

  color.brown   = "1B"x"[0;33m"
  color.red     = "1B"x"[1;31m"
  color.green   = "1B"x"[1;32m"
  color.yellow  = "1B"x"[1;33m"
  color.blue    = "1B"x"[1;34m"
  color.magenta = "1B"x"[1;35m"
  color.cyan    = "1B"x"[1;36m"
  color.white   = "1B"x"[1;37m"
  color.gray    = "1B"x"[0m"

  color.usual   = color.gray
  color.bold    = color.white
  color.error   = color.red
  color.info    = color.green
  color.debug   = color.brown

  /* known download utilites */

  sys.utils.0      = 2
  sys.utils.1.prog = wget.exe
  sys.utils.1.name = "GNU WGet"
  sys.utils.1.parm = '-c -t 10 -w 30 --referer=%h --progress=bar:force -P "%p" "%u"'
  sys.utils.2.prog = curl.exe
  sys.utils.2.name = "cURL"
  sys.utils.2.parm = '-y 300 -Y 1 -v -C - -o "%p/%f" "%u"'

  sys.utils.default.prog = sys.utils.1.prog
  sys.utils.default.name = sys.utils.1.name
  sys.utils.default.parm = sys.utils.1.parm

  /* service semaphores */

  sys.running = "$live$"
  sys.killing = "$stop$"
  sys.pushing = "$push$"
  sys.rebuild = "$init$"
  sys.tqueue  = "$term$"

  /* stream's open modes */

  parse version version .
  if version = "OBJREXX" then do
     sys.open_read  = "OPEN READ  SHAREREAD"
     sys.open_write = "OPEN WRITE SHAREREAD"
     end
  else do
     sys.open_read  = "OPEN READ"
     sys.open_write = "OPEN WRITE"
  end

  /* determine a command prefix for use */

  sys.shell = value( "COMSPEC",, "OS2ENVIRONMENT" )
  if sys.shell == "" then sys.shell = "cmd.exe"

  shellname = translate( filespec( "n", sys.shell  ))

  select
    when shellname == "CMD.EXE"  then
         sys.command = ""
    when shellname == "4OS2.EXE" then
         sys.command = "*"
    otherwise do
         shellname = SysSearchPath( "PATH", "CMD.EXE" )
         if shellname \= "" then
            sys.command = "cmd.exe /c "
         else
            sys.command = ""
    end
  end
return

/*------------------------------------------------------------------
 * $Id$
 * Stop Auto WGet Daemon
 *------------------------------------------------------------------*/
AwStop: procedure expose (globals)

  sys_running  = cfg.home'\'sys.running
  sys_killing  = cfg.home'\'sys.killing

  call Os2Delete sys_running
  call lineout   sys_killing, "Must die!"
  call charout,  color.info || " "msg.wait_stopped"..."

  do 20 while stream( sys_running, 'c', 'query exist' ) \= ""
     call SysSleep  2
     call charout, "."
     call Os2Delete sys_running
  end
  say
  say color.info || " "msg.stopped || color.usual
  say

  call stream    sys_killing, 'c', 'close'
  call Os2Delete sys_killing

return

/*------------------------------------------------------------------
 * $Id$
 * Delete file
 *------------------------------------------------------------------*/
Os2Delete: procedure expose (globals)

  parse arg file

  if stream( file, "C", "QUERY EXISTS" ) \= "" then do
     sys.command'del "'file'" /F 1>nul 2>nul'
     return rc
     end
  else
     return 1

/*------------------------------------------------------------------
 * $Id$
 * Load messages catalog
 *------------------------------------------------------------------*/
NlsLoad: procedure expose (globals)

  parse arg msgfile
  parse source OS2 what msgpath

  msgfile = filespec( "disk", msgpath ) ||,
            filespec( "path", msgpath ) || "NLS\" || msgfile

  country = NlsCountryID()

  if stream( msgfile"."country, "c", "query exists" ) == "" then
     country = "001"

  msgfile = msgfile"."country
  rc = stream( msgfile, "C", sys.open_read )

  if rc \= "READY:" then do
     say  color.error || " Error on open NLS file: "msgfile
     exit 1
  end

  do while lines(msgfile) > 0
     line = strip(linein(msgfile))

     do while right(line,1) == "\"
        line = left( line, length(line)-1 )
        line = line || strip(linein(msgfile))
     end

     if line \= "" & left(line,1) \= "#" then do
        parse value line with id "=" msg

        id  = strip(id )
        msg = strip(msg)

        i = pos( "\n", msg )
        do while i > 0
           msg = substr( msg, 1, i-1 ) || '0D0A'x || substr( msg, i+2 )
           i = pos( "\n", msg )
        end

        msg.id = msg
     end
  end

  rc = stream( msgfile, "C", "CLOSE" )
return

/*------------------------------------------------------------------
 * $Id$
 * Returns Country Identifier
 *------------------------------------------------------------------*/
NlsCountryID: procedure expose (globals)

  parse upper value VALUE( "LANG",, "OS2ENVIRONMENT" ) with lang "_" .

  select
    when lang == "RU" then country = "007" /* Use russian */
    when lang == "EN" then country = "001" /* Use english */
    when lang == "ES" then country = "034" /* Use spanish */
    when lang == "FR" then country = "033" /* Use french  */
    when lang == "SV" then country = "046" /* Use swedish */
    when lang == "DE" then country = "049" /* Use german  */
    when lang == "ZH" then country = "088" /* Use chinese */
    otherwise
       country = strip( SysIni( "BOTH", "PM_National", "iCountry" ),, '0'x )
  end

  if country == "ERROR:" then
     country =  "001"
  else
     country =  right( country, 3, "0" )


return country

/*------------------------------------------------------------------
 * $Id$
 * Load configuration
 *------------------------------------------------------------------*/
CfgLoad: procedure expose (globals)

  call CfgInit
  rc = stream( sys.config_file, "c", sys.open_read )

  do while lines(sys.config_file) > 0
     parse value linein(sys.config_file) with keyword "=" argument

     keyword  = translate(strip(keyword))
     argument = strip(argument)
     keypos   = wordpos( keyword, cfg.keys )

     if keypos > 0 then do
        keytype = substr( word( cfg.keys, keypos + 1 ), 1, 1 )
        select
          when keytype == "S" then
               cfg.keyword = argument
          when keytype == "N" then
               cfg.keyword = argument
          when keytype == "B" then
               cfg.keyword = (argument \= "0")
          otherwise
        end
     end
  end

  rc = stream( sys.config_file, "c", "close" )
  cfg.file_date = stream( sys.config_file, "c", "query datetime" )
return

/*------------------------------------------------------------------
 * $Id$
 * Initialize configuration
 *------------------------------------------------------------------*/
CfgInit: procedure expose (globals)

  cfg.home                     = "."
  cfg.download                 = "."
  cfg.downloads_simultaneously = 3
  cfg.downloads_from_same_host = 0
  cfg.downloads_window         = "hidden,80,12"
  cfg.downloads_attempts       = 15
  cfg.downloads_utility        = sys.utils.default.prog
  cfg.downloads_parameters     = sys.utils.default.parm
  cfg.clipboard_monitor        = 0
  cfg.clipboard_exclude        = "HTML HTM SHTML PHTML PHP STML ASP GIF JPG JPEG " ||,
                                 "PNG MNG CAB JAVA CLASS"
  cfg.scan_interval            = 30
  cfg.log_file                 = "nul"
  cfg.error_log                = "nul"
  cfg.log_keep                 = 15
  cfg.message_done             = 'start /n pmpopup2.exe "%m:~~%u" "Auto WGet Daemon" /BELL /B1:"OK" /T:900 /F:"8.Helv"'
  cfg.message_error            = 'start /n pmpopup2.exe "%m:~~%u~%i" "Auto WGet Daemon" /BELL /B1:"OK" /T:900 /F:"8.Helv"'
  cfg.messages                 = 1
  cfg.check_connection         = 0
  cfg.use_desktop              = 0
  cfg.keep_failed_url          = 1
  cfg.keep_done_url            = 0
  cfg.file_date                = ""

  cfg.keys = "HOME"                      || " SN " ||,
             "DOWNLOAD"                  || " SY " ||,
             "DOWNLOADS_SIMULTANEOUSLY"  || " NY " ||,
             "DOWNLOADS_FROM_SAME_HOST"  || " NY " ||,
             "DOWNLOADS_ATTEMPTS"        || " NY " ||,
             "DOWNLOADS_UTILITY"         || " NY " ||,
             "DOWNLOADS_PARAMETERS"      || " SN " ||,
             "DOWNLOADS_WINDOW"          || " SY " ||,
             "CLIPBOARD_MONITOR"         || " BY " ||,
             "CLIPBOARD_EXCLUDE"         || " SN " ||,
             "SCAN_INTERVAL"             || " NY " ||,
             "LOG_FILE"                  || " SN " ||,
             "ERROR_LOG"                 || " SN " ||,
             "LOG_KEEP"                  || " NN " ||,
             "MESSAGE_DONE"              || " SN " ||,
             "MESSAGE_ERROR"             || " SN " ||,
             "MESSAGES"                  || " BN " ||,
             "CHECK_CONNECTION"          || " BN " ||,
             "USE_DESKTOP"               || " BY " ||,
             "KEEP_FAILED_URL"           || " BY " ||,
             "KEEP_DONE_URL"             || " BY "
return

