; FTPBrowser Patch - Y2K formatting
; 25 Feb 2009
; 07 Apr 2009 Container sorting

; Date logic fails for Y2K because
; dates passed as yy-mm-dd string and not compared with this in mind

; Build ftpbrowsepatch.lst with
;   wasm ftpbbrowsepatch.asm
;   wdis -l -s ftpbbrowsepatch.obj

; Use output to prepare ftpbbrowsepatch.pat

; Patch with
;  lxlite -X+ -B- ftpbbrows.exe
;  patch /a ftpbbrowsepatch.pat
;  lxlite -X- -B- ftpbbrows.exe

; Packed original

;  7-23-97  19:27         136,854         296  ftpbrows.exe

; 6a1b9b56b7f5b71044542dfe52fccbac *ftpbrows.exe

; Unpacked original

;  7-23-97  19:27         236,731         296  ftpbrows.exe

; 054900b88830bd3950b13ac6e20b4ba6 *ftpbrows.exe

;==========================================================================

; Patch subroutines placed in available space of object 1, page 45
; after expanding page to 400h bytes and expanding object to match
; Code located at 3c260..3c3ff

; =========================================
; Expand object 1 from 2C258 to 2C300 bytes

; From lxlite -c:exemap

; ObjTable offs:     00000144
; Page shift:               9, 1 << 9 = 200
; MapTable offs:     000001BC		(page table descriptors)
; PageData offs:     00001E00

;  ##  Base  Size RWEResDisShrPreInvSwpRsdLocA1632BCnfIOP
;   1 00010000 0002C258                                         
;    Index  FileOffs  Size  Attribute 
;     00000042  00031400  1000    Valid   
;     00000043  00032400  1000    Valid   
;     00000044  00030400  1000    Valid   
;     00000045  00030000  0258    Valid   

; Object 1 size in file

; 00000140  00 00 00 00  58 C2 02 00  00 00 01 00  15 20 00 00
;                        -----------
;			 00 c4 02 00

; patch 2C258 -> 2C400


; =================================================
; Expand object 1, page 45 from 258 to 400 bytes

; object page table entry in file
; page 45 (2dh), index = 2c
; 1bc + 2c * 8 = 31c

; 00000310  00 10 00 00  73 01 00 00  00 10 00 00  71 01 00 00
;                                                  -----------
; 00000320  58 02 00 00  6C 01 00 00  9A 09 00 00  00 00 00 00
;           -----------
;           00 04 00 00

; patch 258h -> 400h

; object 1 page 45 in file
; offset = 171
; size = 258
; flags = 0

; 171 * 1 << 9 = 2e200
; page base 2e200 + 1e00 = 30000

;==========================================================================

	TITLE   ftpbrowser patch
	.586p
_TEXT	SEGMENT  BYTE PUBLIC USE32 'CODE'
_TEXT	ENDS
_DATA	SEGMENT  DWORD PUBLIC USE32 'DATA'
_DATA	ENDS
CONST	SEGMENT  DWORD PUBLIC USE32 'CONST'
CONST	ENDS
_BSS	SEGMENT  DWORD PUBLIC USE32 'BSS'
_BSS	ENDS

DGROUP	GROUP	CONST, _BSS, _DATA
	ASSUME DS: DGROUP, SS: DGROUP

_TEXT      SEGMENT
	ASSUME	CS: _TEXT

	PUBLIC	_Patch
Patch	PROC NEAR
	ASSUME DS: DGROUP
	ASSUME CS: Patch

Zero:

;=============================================
; Patch_1 @ 16fa8 - Y2K dates show as 3 digits

; patch location in file

; page = (16fa8 - 10000) / 1000 + 1 = 7
; offset = fa8

;    Index  FileOffs  Size  Attribute 
;     00000007  0000C600  1000    Valid   

; C600 + FA8 = D5A8

; originally

; 16FA8 66 8B 45 A6     mov     ax, [ebp-5Ah]
; 16FAC 25 FF 07 00 00  and     eax, 7FFh
; 16FB1 C1 E8 05        shr     eax, 5
; 16FB4 50              push    eax             ; min
; 16FB5 8A 45 A7        mov     al, [ebp-59h]
; 16FB8 25 FF 00 00 00  and     eax, 0FFh
; 16FBD C1 E8 03        shr     eax, 3
; 16FC0 50              push    eax             ; hour

; 16FC1 8A 45 A4        mov     al, [ebp-5Ch]   ; day?
; 16FC4 83 E0 1F        and     eax, 1Fh
; 16FC7 50              push    eax
; 16FC8 66 8B 45 A4     mov     ax, [ebp-5Ch]   ; month?
; 16FCC 25 FF 01 00 00  and     eax, 1FFh
; 16FD1 C1 E8 05        shr     eax, 5
; 16FD4 50              push    eax
; 16FD5 8A 45 A5        mov     al, [ebp-5Bh]   ; year since 1980
; 16FD8 25 FF 00 00 00  and     eax, 0FFh
; 16FDD D1 E8           shr     eax, 1
; 16FDF 83 C0 50        add     eax, 80
; 16FE2 50              push    eax

; 16FE3 8B 43 50        mov     eax, [ebx+50h]  ; buf?
; 16FE6 83 EC 08        sub     esp, 8
; 16FE9 BA 38 1B 05 00  mov     edx, offset aYMDHM_3
; 16FE3

; 16FE3 - 16FA8 = 3B bytes

; D5A0  89 B0 00 00  00 89 4B 18  66 8B 45 A6  25 FF 07 00
; D5B0  00 C1 E8 05  50 8A 45 A7  25 FF 00 00  00 C1 E8 03
; D5C0  50 8A 45 A4  83 E0 1F 50  66 8B 45 A4  25 FF 01 00
; D5D0  00 C1 E8 05  50 8A 45 A5  25 FF 00 00  00 D1 E8 83
; D5E0  C0 50 50 8B  43 50 83 EC  08 BA 38 1B  05 00 E8 C1

;       typedef struct _FTIME           /* ftime */
;       {
;          UINT   twosecs : 5;		bit 0
;          UINT   minutes : 6;
;          UINT   hours   : 5;
;       } FTIME;

	; org	16fa8h
	db 0a8h - ($ - Zero) and 0ffh dup (90h)	; align

	mov     eax, [ebp-5Ah]	; FTIME
	mov	edx, eax
	shr     eax, 5
	and     eax, 3Fh
	push    eax             ; min
	shr     edx, 11
	and     edx, 01Fh
	push    eax             ; hour

;       typedef struct _FDATE           /* fdate */
;       {
;          UINT   day     : 5;		; bit 0
;          UINT   month   : 4;
;          UINT   year    : 7;
;       } FDATE;

	mov     eax, [ebp-5Ch]   ; FDATE
	mov	edx, eax
	and     edx, 1Fh
	push    edx		; day
	mov     edx, eax
	shr     edx, 5
	and     edx, 0Fh
	push    edx		; month
	shr     eax, 9
	and     eax, 07Fh	; year since 1980
	add     eax, 80
	cmp	edx, 100
	jb	@p1_1
	sub	edx, 100
@p1_1:
	push    edx		; day

; from wdis a8h -> 16fa8

; A8    8B 45 A6                  mov         eax,dword ptr -0x5a[ebp]
; AB    8B D0                     mov         edx,eax
; AD    C1 E8 05                  shr         eax,0x05
; B0    83 E0 3F                  and         eax,0x0000003f
; B3    50                        push        eax
; B4    C1 EA 0B                  shr         edx,0x0b
; B7    83 E2 1F                  and         edx,0x0000001f
; BA    50                        push        eax
; BB    8B 45 A4                  mov         eax,dword ptr -0x5c[ebp]
; BE    8B D0                     mov         edx,eax
; C0    83 E2 1F                  and         edx,0x0000001f
; C3    52                        push        edx
; C4    8B D0                     mov         edx,eax
; C6    C1 EA 05                  shr         edx,0x05
; C9    83 E2 0F                  and         edx,0x0000000f
; CC    52                        push        edx
; CD    C1 E8 09                  shr         eax,0x09
; D0    83 E0 7F                  and         eax,0x0000007f
; D3    83 C0 50                  add         eax,0x00000050
; D6    83 FA 64                  cmp         edx,0x00000064
; D9    72 03                     jb          L$1
; DB    83 EA 64                  sub         edx,0x00000064
; DE                          L$1:
; DE    52                        push        edx
; DF

;=============================
; Patch_2 @ 17c41 - reference?

; originally

; 17C41 BA EC 19 05 00           mov     edx, offset aYMDHM_2
; 17C46 0F BF 9C 24 8E 00 00 00  movsx   ebx, word ptr [esp+8Eh]; min
; 17C4E 53                       push    ebx
; 17C4F 0F BF 9C 24 94 00 00 00  movsx   ebx, word ptr [esp+94h]; hour
; 17C57 53                       push    ebx
; 17C58 0F BF 9C 24 9C 00 00 00  movsx   ebx, word ptr [esp+9Ch]; day
; 17C60 53                       push    ebx
; 17C61 0F BF 9C 24 A2 00 00 00  movsx   ebx, word ptr [esp+0A2h]; mon
; 17C69 53                       push    ebx
; 17C6A 0F BF 9C 24 A2 00 00 00  movsx   ebx, word ptr [esp+0A2h]; year
; 17C72 53                       push    ebx
; 17C73 83 EC 08                 sub     esp, 8
; 17C76 8B 84 24 D0 00 00 00     mov     eax, [esp+0D0h] ; buf?
; 17C7D E8 32 44 01 00           call    sprintf?_2C0B4

	; org	17c41h
	; db 41h - ($ - Zero) and 0ffh dup (90h)	; align

;=============================================
; Patch_3 @ 1a24a - Y2K dates show as 3 digits

; page = (1a24a - 10000) / 1000 + 1 = 11
; offset = 24a

;    Index  FileOffs  Size  Attribute 
;     00000011  00010600  0FFE    Valid   

; 10600 + 24A = 1084A

; originally

; 1A24A 66 8B 95 D2 FE FF FF  mov     dx, [ebp-12Eh]  ; min
; 1A251 81 E2 FF 07 00 00     and     edx, 7FFh
; 1A257 C1 EA 05              shr     edx, 5
; 1A25A 52                    push    edx
; 1A25B 8A 95 D3 FE FF FF     mov     dl, [ebp-12Dh]  ; hour
; 1A261 81 E2 FF 00 00 00     and     edx, 0FFh
; 1A267 C1 EA 03              shr     edx, 3
; 1A26A 52                    push    edx
; 1A26B 8A 95 D0 FE FF FF     mov     dl, [ebp-130h]  ; day
; 1A271 83 E2 1F              and     edx, 1Fh
; 1A274 52                    push    edx
; 1A275 66 8B 95 D0 FE FF FF  mov     dx, [ebp-130h]  ; month
; 1A27C 81 E2 FF 01 00 00     and     edx, 1FFh
; 1A282 C1 EA 05              shr     edx, 5
; 1A285 52                    push    edx
; 1A286 8A 95 D1 FE FF FF     mov     dl, [ebp-12Fh]  ; year since 1980
; 1A28C 81 E2 FF 00 00 00     and     edx, 0FFh
; 1A292 D1 EA                 shr     edx, 1
; 1A294 83 C2 50              add     edx, 80
; 1A297 52                    push    edx

; 1A298 8B 43 44              mov     eax, [ebx+44h]  ; buf?
; 1A29B 83 EC 08              sub     esp, 8
; 1A29E BA 44 17 05 00        mov     edx, offset aYMDHM
; 1A2A3 E8 0C 1E 01 00        call    sprintf?_2C0B4
; 1A298

; 1A298 - 1A24A = 4E bytes

; 10840  02 F3 A5 8B  C8 83 E1 03  F3 A4 66 8B  95 D2 FE FF
; 10850  FF 81 E2 FF  07 00 00 C1  EA 05 52 8A  95 D3 FE FF
; 10860  FF 81 E2 FF  00 00 00 C1  EA 03 52 8A  95 D0 FE FF
; 10870  FF 83 E2 1F  52 66 8B 95  D0 FE FF FF  81 E2 FF 01
; 10880  00 00 C1 EA  05 52 8A 95  D1 FE FF FF  81 E2 FF 00
; 10890  00 00 D1 EA  83 C2 50 52  8B 43 44 83  EC 08 BA 44
; 108A0  17 05 00 E8  0C 1E 01 00  83 C4 1C C7  43 38 00 00

;       typedef struct _FTIME           /* ftime */
;       {
;          UINT   twosecs : 5;		bit 0
;          UINT   minutes : 6;
;          UINT   hours   : 5;
;       } FTIME;

	; org	1a24ah
	db 4ah - ($ - Zero) and 0ffh dup (90h)	; align

	mov     eax, [ebp-12Eh]	; FTIME
	mov	edx, eax
	shr     eax, 5
	and     eax, 3Fh
	push    eax             ; min
	shr     edx, 11
	and     edx, 01Fh
	push    edx             ; hour

;       typedef struct _FDATE           /* fdate */
;       {
;          UINT   day     : 5;		; bit 0
;          UINT   month   : 4;
;          UINT   year    : 7;
;       } FDATE;

	mov     eax, [ebp-130h]   ; FDATE
	mov	edx, eax
	and     edx, 1Fh
	push    edx		; day
	mov     edx, eax
	shr     edx, 5
	and     edx, 0Fh
	push    edx		; month
	shr     eax, 9
	and     eax, 07Fh	; year since 1980
	add     eax, 80
	cmp	eax, 100
	jb	@p3_1
	sub	eax, 100
@p3_1:
	push    eax		; year

; from wdis 14a -> 1a24a

; 14A    8B 85 D2 FE FF FF         mov         eax,dword ptr -0x12e[ebp]
; 150    8B D0                     mov         edx,eax
; 152    C1 E8 05                  shr         eax,0x05
; 155    83 E0 3F                  and         eax,0x0000003f
; 158    50                        push        eax
; 159    C1 EA 0B                  shr         edx,0x0b
; 15C    83 E2 1F                  and         edx,0x0000001f
; 15F    52                        push        edx
; 160    8B 85 D0 FE FF FF         mov         eax,dword ptr -0x130[ebp]
; 166    8B D0                     mov         edx,eax
; 168    83 E2 1F                  and         edx,0x0000001f
; 16B    52                        push        edx
; 16C    8B D0                     mov         edx,eax
; 16E    C1 EA 05                  shr         edx,0x05
; 171    83 E2 0F                  and         edx,0x0000000f
; 174    52                        push        edx
; 175    C1 E8 09                  shr         eax,0x09
; 178    83 E0 7F                  and         eax,0x0000007f
; 17B    83 C0 50                  add         eax,0x00000050
; 17E    83 F8 64                  cmp         eax,0x00000064
; 181    72 03                     jb          L$2
; 183    83 E8 64                  sub         eax,0x00000064
; 186                          L$2:
; 186    50                        push        eax
; 187

;=========================================
; Patch_4 @ 1a581 - local asc date compare

; page = (1a581 - 10000) / 1000 + 1 = 0bh = 11t
; offset = 581

;    Index  FileOffs  Size  Attribute 
;     00000011  00010600  0FFE    Valid   

; 10600 + 581 = 10b81

; originally

; 1A578                          mov     edx, [ebp+0Ch]
; 1A57B 8B 4D 08                 mov     ecx, [ebp+8]
; 1A57E 8B 52 44                 mov     edx, [edx+44h]

; 1A581 8B 49 44                 mov     ecx, [ecx+44h]
; 1A584 33 C0                    xor     eax, eax
; 1A586 33 DB                    xor     ebx, ebx

; 1A588
; 1A588          loc_1A588:                              ;
; 1A588 8A 01                    mov     al, [ecx]
; 1A58A 8A 1A                    mov     bl, [edx]
; 1A58C 41                       inc     ecx
; 1A58D 42                       inc     edx

	; org	1a581h
	db 81h - ($ - Zero) and 0ffh dup (90h)	; align

XPatch_4	equ	1a581h
XPatch_20	equ	3c260h

Patch_4:
	call	$ + (XPatch_20 - XPatch_4) - ($ - Patch_4)
	jmp	@p4_1
	mov     al, [ecx]
	mov     bl, [edx]
@p4_1:
	inc     ecx

; wdis 281 -> 1a581h

;	     0282		; The label referred to here is an undefined location
; 281    E8 DA 1C 02 00            call        0x00021f60
; 286    EB 04                     jmp         L$3

; 288    8A 01                     mov         al,byte ptr [ecx]
; 28A    8A 1A                     mov         bl,byte ptr [edx]
; 28C                          L$3:
; 28C    41                        inc         ecx

;==========================================
; Patch_8 @ 1a5ac - local desc date compare

; page = (1A5AC - 10000) / 1000 + 1 = B = 11t
; offset = 5AC

;    Index  FileOffs  Size  Attribute 
;     00000011  00010600  0FFE    Valid   

; 10600 + 5AC = 10bac

; originally

; 1A5A3 8B 55 08                                         ;
; 1A5A3                          mov     edx, [ebp+8]
; 1A5A6 8B 4D 0C                 mov     ecx, [ebp+0Ch]
; 1A5A9 8B 52 44                 mov     edx, [edx+44h]

; 1A5AC 8B 49 44                 mov     ecx, [ecx+44h]
; 1A5AF 33 C0                    xor     eax, eax
; 1A5B1 33 DB                    xor     ebx, ebx

; 1A5B3 8A 01                    mov     al, [ecx]
; 1A5B5 8A 1A                    mov     bl, [edx]
; 1A5B7 41                       inc     ecx

	; org	1A5ach
	db 0ach - ($ - Zero) and 0ffh dup (90h)	; align

XPatch_8	equ	1a5ach
; XPatch_20	equ	3c260h

Patch_8:
	call	$ + (XPatch_20 - XPatch_8) - ($ - Patch_8)
	jmp	@p8_1
	mov     al, [ecx]
	mov     bl, [edx]
@p8_1:
	inc     ecx

; wdis 2ac -> 1a5ach

;	     02AD		; The label referred to here is an undefined location
; 2AC    E8 AF 1C 02 00            call        0x00021f60
; 2B1    EB 04                     jmp         L$4

; 2B3    8A 01                     mov         al,byte ptr [ecx]
; 2B5    8A 1A                     mov         bl,byte ptr [edx]
; 2B7                          L$4:
; 2B7    41                        inc         ecx

;===========================================
; Patch_10 @ 1a7f9 - remote asc date compare

; page = (1a7f9 - 10000) / 1000 + 1 = 0bh = 11t
; offset = 7f9

;    Index  FileOffs  Size  Attribute 
;     00000011  00010600  0FFE    Valid   

; 10600 + 7f9 = 10df9

; originally

; 1A7F0 8B 55 0C
; 1A7F0                          mov     edx, [ebp+0Ch]
; 1A7F3 8B 4D 08                 mov     ecx, [ebp+8]
; 1A7F6 8B 52 50                 mov     edx, [edx+50h]

; 1A7F9 8B 49 50                 mov     ecx, [ecx+50h]
; 1A7FC 33 C0                    xor     eax, eax
; 1A7FE 33 DB                    xor     ebx, ebx

; 1A800          loc_1A800:
; 1A800 8A 01                    mov     al, [ecx]
; 1A802 8A 1A                    mov     bl, [edx]
; 1A804 41                       inc     ecx
; 1A805 42                       inc     edx

	; org	1a7f9h
	db 0f9h - ($ - Zero) and 0ffh dup (90h)	; align

XPatch_10	equ	1a7f9h
XPatch_30	equ	3c280h

Patch_10:
	call	$ + (XPatch_30 - XPatch_10) - ($ - Patch_10)
	jmp	@p10_1
	mov     al, [ecx]
	mov     bl, [edx]
@p10_1:
	inc     ecx

; wdis 2f9 -> 1a7f9h

; 	     02FA		; The label referred to here is an undefined location
; 2F9    E8 82 1A 02 00            call        0x00021d80 
; 2FE    EB 04                     jmp         L$5 

; 300    8A 01                     mov         al,byte ptr [ecx] 
; 302    8A 1A                     mov         bl,byte ptr [edx] 
; 304                          L$5:
; 304    41                        inc         ecx 

;=============================================
; Patch_12 @ 1a824 - desc date compare, remote

; page = (1a824 - 10000) / 1000 + 1 = B = 11t
; offset = 824

;    Index  FileOffs  Size  Attribute 
;     00000011  00010600  0FFE    Valid   

; 10600 + 824 = 10e24

; originally

; 1A81B 8B 55 08
; 1A81B                          mov     edx, [ebp+8]
; 1A81E 8B 4D 0C                 mov     ecx, [ebp+0Ch]
; 1A821 8B 52 50                 mov     edx, [edx+50h]

; 1A824 8B 49 50                 mov     ecx, [ecx+50h]
; 1A827 33 C0                    xor     eax, eax
; 1A829 33 DB                    xor     ebx, ebx

; 1A82B          loc_1A82B:
; 1A82B 8A 01                    mov     al, [ecx]
; 1A82D 8A 1A                    mov     bl, [edx]
; 1A82F 41                       inc     ecx
; 1A830 42                       inc     edx

	; org	1a824h
	db 024h - ($ - Zero) and 0ffh dup (90h)	; align

XPatch_12	equ	1a824h
; XPatch_30	equ	3c280h

Patch_12:
	call	$ + (XPatch_30 - XPatch_12) - ($ - Patch_12)
	jmp	@p12_1
	mov     al, [ecx]
	mov     bl, [edx]
@p12_1:
	inc     ecx

; wdis 324 -> 1a824h

; 	     0325		; The label referred to here is an undefined location
; 324    E8 57 1A 02 00            call        0x00021d80 
; 329    EB 04                     jmp         L$6 
; 32B    8A 01                     mov         al,byte ptr [ecx] 
; 32D    8A 1A                     mov         bl,byte ptr [edx] 
; 32F                          L$6:
; 32F    41                        inc         ecx 

;==========================================
; Patch_20 @ 3c260 - Date compare assist #1

; page = (3c260 - 10000) / 1000 + 1 = 2dh = 45t
; offset = 260

;    Index  FileOffs  Size  Attribute 
;     00000045  00030000  0258    Valid   

; 30000 + 260 = 30260

; originally zeros

	; org	3c260
	db 60h - ($ - Zero) and 0ffh dup (90h)	; align

Patch_20:
	 mov	 ecx, [ecx+44h]
	 xor	 eax, eax
	 xor	 ebx, ebx
	 mov	 al, [ecx]
	 cmp     al, '8'
	 jge     @p20_1
	 add     al, 10
@p20_1:
	 mov	 bl, [edx]
	 cmp     bl, '8'
	 jge     @p20_2
	 add     bl, 10
@p20_2:
	 ret

; wdis 360 -> 3c260

; 360    8B 49 44                  mov         ecx,dword ptr 0x44[ecx]
; 363    33 C0                     xor         eax,eax
; 365    33 DB                     xor         ebx,ebx
; 367    8A 01                     mov         al,byte ptr [ecx]
; 369    3C 38                     cmp         al,0x38
; 36B    7D 02                     jge         L$3
; 36D    04 0A                     add         al,0x0a
; 36F                          L$3:
; 36F    8A 1A                     mov         bl,byte ptr [edx]
; 371    80 FB 38                  cmp         bl,0x38
; 374    7D 03                     jge         L$4
; 376    80 C3 0A                  add         bl,0x0a
; 379                          L$4:
; 379    C3                        ret
; 37A

;==========================================
; Patch_30 @ 3c260 - Date compare assist #2

; page = (3c280 - 10000) / 1000 + 1 = 2dh = 45t
; offset = 280

;    Index  FileOffs  Size  Attribute 
;     00000045  00030000  0258    Valid   

; 30000 + 260 = 30280

; originally zeros

	; org	3c280h
	db 80h - ($ - Zero) and 0ffh dup (90h)	; align

Patch_30:
	 mov	 ecx, [ecx+50h]
	 xor	 eax, eax
	 xor	 ebx, ebx
	 mov	 al, [ecx]
	 cmp     al, '8'
	 jge     @p30_1
	 add     al, 10
@p30_1:
	 mov	 bl, [edx]
	 cmp     bl, '8'
	 jge     @p30_2
	 add     bl, 10
@p30_2:
	 ret

; wdis 380 -> 3c280

; 380    8B 49 50                  mov         ecx,dword ptr 0x55[ecx]
; 383    33 C0                     xor         eax,eax
; 385    33 DB                     xor         ebx,ebx
; 387    8A 01                     mov         al,byte ptr [ecx]
; 389    3C 38                     cmp         al,0x38
; 38B    7D 02                     jge         L$3
; 38D    04 0A                     add         al,0x0a
; 38F                          L$3:
; 38F    8A 1A                     mov         bl,byte ptr [edx]
; 391    80 FB 38                  cmp         bl,0x38
; 394    7D 03                     jge         L$4
; 396    80 C3 0A                  add         bl,0x0a
; 399                          L$4:
; 399    C3                        ret
; 39A


;===========

Patch	ENDP
_TEXT	ENDS
END
