/* INSTALL.CMD */
/* This program places a HOUSE2 folder on the
   desktop and fills it with all the HOUSE2
   program objects.
*/

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

SAY 'Installing HOUSE/2...'
SAY ''

objerror = 0
folder.name = 'HOUSE2'

pwd = Directory()
execs.0 = 2
execs.1.spec = pwd || '\*.exe'
execs.1._title = ''
execs.2.spec = pwd || '\*.cmd'
execs.2._title = '0A'x || 'HOUSE/2'


folder.objId = Translate(folder.name, '__', '^ ')
folder.title  = Translate(folder.name, '0A'x, '^')

rc = SysCreateObject('WPFolder', folder.title,,
    '<WP_DESKTOP>',,
    'OBJECTID=<' || folder.objId || '>;' ||,
    'ICONVIEW=NORMAL;ICONFONT=8.Helv;',,
    'ReplaceIfExists')

IF rc = 0 THEN
  DO
    SAY ''
    SAY 'Could not create folder' folder.name
    EXIT
  END

DO i = 1 TO execs.0
  CALL SysFileTree execs.i.spec, 'files.', 'FO'
  DO j = 1 TO files.0
    title = Reverse(FileSpec('Name', files.j))
    PARSE VAR title 5 title
    title = Reverse(title) || execs.i._title

    IF title = 'HOUS2UTL' then
      title = 'HOUSE/2^Utility'
    IF title = 'HOUSE2' then
      title = 'HOUSE/2^Program'
    IF title = 'X10TEST' then
      title = 'X10 Com^Tester'

    rc = SysCreateObject('WPProgram', title,,
	'<'folder.objId'>',,
	'EXENAME=' || files.j || ';' ||,
	'STARTUPDIR=' || pwd || ';',,
	'ReplaceIfExists')
    IF rc = 0 THEN
      DO
        SAY 'Could not create program object for' files.j
        objerror = objerror + 1
      END
  END
END

SAY ''
IF objerror = 0 then
  DO
    SAY 'HOUSE/2 folder and program objects successfully created.'
    SAY ''
    SAY 'To run the program, open HOUSE/2 folder'
    SAY 'and double-click on HOUSE/2 object.'
  END
ELSE
  DO
    SAY 'Could not install one or more HOUSE/2 objects.'
    SAY ''
    SAY 'Make sure all HOUSE/2 files are present'
    SAY 'and run INSTALL again.'
  END

EXIT

