
/* CUSeeMe/2 by Kim Kruse Hansen */


/* c/c++ header files */

#include <stdio.h>
#include <stdlib.h>
#include <types.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <process.h>
#include <io.h>

/* tcp/ip header files */

#include <netdb.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <net/route.h>
#include <net/if.h>
#include <netinet/in.h>

#define INCL_DOS
#define INCL_PM
#define INCL_DOSDEVIOCTL
#define INCL_MCIOS2
#include <os2.h>
#include <os2me.h>

#define USE_DIVE

#ifdef USE_DIVE
#include <mmioos2.h>                    /* It is from MMPM toolkit           */
#include <dive.h>
#include <fourcc.h>
#include <builtin.h>
#include <pmddim.h>
#endif

#define DEBUG

#include "kkhcpp.hpp"

#include "plugininterface.hpp"

#include "kkhplug4.hpp"

#include "kkhplug4.h"

#include "modesettings.hpp"

BOOL bColor;

#include "modesettings.cppi"


/*


*/

ULONG QueryInformation(ULONG ulCmd,PVOID pvIN,ULONG ulIn,PVOID pvOut,ULONG ulOut)

{
PPLUGIN_QUERYINFORMATION pplug = (PPLUGIN_QUERYINFORMATION) pvOut;
PPLUGIN_GENEREL pgen = (PPLUGIN_GENEREL) pvIN;
ULONG rc = 87;

  if (pvOut && ulOut >= sizeof(PLUGIN_QUERYINFORMATION))
  {
    pplug->cbFix     = sizeof(PLUGIN_QUERYINFORMATION);
    pplug->ulVersion = 1;
    pplug->ulFlags   = (bColor) ? FLAG_COLOR : FLAG_GRAY;

    pplug->hIcon     =     WinLoadPointer(HWND_DESKTOP,pgen->hmodule,IDI_KKHPLUG4);
    strcpy(pplug->title,"Pattern Generator v2.0");

    pplug->fourcc = FOURCC_BGR3;

    rc = 0;
  }
  return rc;
}

/*

  Initialize DLL

*/

ULONG Initialize(ULONG ulCmd,PVOID pvIN,ULONG ulIn,PVOID pvOut,ULONG ulOut)

{
PPLUGIN_INITIALIZE pplug = (PPLUGIN_INITIALIZE) pvIN;
ULONG rc = 87;

  if (pvIN && ulIn >= sizeof(PLUGIN_INITIALIZE))
  {

    ULONG cnt = sizeof(bColor);


    if (!PrfQueryProfileData(pplug->hini,"KKHPLUG4","Mode",&bColor,&cnt))
    {
      bColor = FALSE;
    }

    rc = 0;
  }
  return rc;
}

/*

  Terminate DLL

*/

ULONG Terminate(ULONG ulCmd,PVOID pvIN,ULONG ulIn,PVOID pvOut,ULONG ulOut)

{
PPLUGIN_TERMINATE pplug = (PPLUGIN_TERMINATE) pvIN;
ULONG rc = 87;

  if (pvIN && ulIn >= sizeof(PLUGIN_TERMINATE))
  {

    rc = 0;
  }
  return rc;
}

/*

  Get Frame

*/

ULONG GetFrame(ULONG ulCmd,PVOID pvIN,ULONG ulIn,PVOID pvOut,ULONG ulOut)

{
PPLUGIN_GETFRAME pplug = (PPLUGIN_GETFRAME) pvIN;
ULONG rc = 87;
static char f = 0;

  if (pvIN && ulIn >= sizeof(PLUGIN_GETFRAME))
  {
    if (bColor)
    {
//      memset(pplug->pBuffer,f,pplug->ulLen);
      PCHAR p = (PCHAR) pplug->pBuffer;

      for (int y = 0;y < 120;y++)
      {
        for (int x = 0;x < 160;x++)
        {
          *p = x +f ;
          ++p;
          *p = y - x + f ;
          ++p;
          *p = x+y +f;
          ++p;

       }
     }
   }
   else
    memset(pplug->pBuffer,f,pplug->ulLen);


   ++f;
    rc = 0;
  }
  return rc;
}

/*

  Setup

*/

ULONG Setup(ULONG ulCmd,PVOID pvIN,ULONG ulIn,PVOID pvOut,ULONG ulOut)

{
PPLUGIN_GENEREL pplug = (PPLUGIN_GENEREL) pvIN;
ULONG rc = 87;

  if (pvIN && ulIn >= sizeof(PLUGIN_GENEREL))
  {
     ModeSettings dialog(desktop);

     if (dialog.Process(NULL,pplug->hmodule) == DISMISS_OK)
     {

       // are we running in another mode ?

       if (bColor != dialog.bNewMode)
       {
         PrfWriteProfileData(pplug->hini,"KKHPLUG4","Mode",&dialog.bNewMode,sizeof(dialog.bNewMode));

         rc = PLUGIN_MUST_RELOAD;
       }
     }
     else
       rc = 0;
  }
  return rc;
}

/*

  dispatch incoming command to handlers

*/

APIRET PlugInCommand(ULONG ulCmd,PVOID pvIN,ULONG ulIn,PVOID pvOut,ULONG ulOut)

{
ULONG rc = 87;

  switch (ulCmd)
  {
    case PLUGIN_CMD_GET_FRAME        : rc = GetFrame(ulCmd,pvIN,ulIn,pvOut,ulOut);
                                    break;
    case PLUGIN_CMD_QUERYINFORMATION : rc = QueryInformation(ulCmd,pvIN,ulIn,pvOut,ulOut);
                                    break;
    case PLUGIN_CMD_INITIALIZE       : rc = Initialize(ulCmd,pvIN,ulIn,pvOut,ulOut);
                                    break;
    case PLUGIN_CMD_TERMINATE        : rc = Terminate(ulCmd,pvIN,ulIn,pvOut,ulOut);
                                    break;
    case PLUGIN_CMD_SETUP        : rc = Setup(ulCmd,pvIN,ulIn,pvOut,ulOut);
                                    break;
  }

  return rc;
}

