/* REXX installation script for iceCQ
 * version 1.1
 * (c) os2.ru
 */

call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

/*------------------------------------------------------------------
 * Initialization 
 *------------------------------------------------------------------*/

I.Folder = 'IceCQ/2'
U.Folder = 'Utilities'
D.Folder = 'Documentation'

T.Program = 'IceCQ/2'
D.Program = 'IceCQ.EXE'

D.Readme = 'doc\readme.en.txt'
T.Readme = 'Readme (en)'

D.Readmer = 'doc\readme.ru.txt'
T.Readmer = 'Readme (ru)'

D.His = 'doc\history.en.txt'
T.His = 'History changes (en)'
D.Hisr = 'doc\history.ru.txt'
T.Hisr = 'History changes (ru)'

D.ssc = 'Sound Scheme Converter'
T.ssc = 'utilities\UNSCM.EXE'
D.cvt = 'History (old format) convertor'
T.cvt = 'utilities\HISTCVRT.EXE'


installdir = directory()"\"
installlog = installdir"install.log"

if GetYesNo( "Install" D.Folder "in" installdir ) == 0 then
   exit

/*------------------------------------------------------------------
 * Create folder
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPFolder",I.Folder,"<WP_DESKTOP>",,
                      "OBJECTID=<IceFolder>;ALWAYSSORT=Yes" ,"REPLACE" )
if rc then call log I.Folder "folder successfully created on desktop..."
else       call log "ERROR:" I.Folder "folder creating failed!"

rc = SysCreateObject( "WPFolder",D.Folder,"<IceFolder>",,
                      "OBJECTID=<IceFolderdoc>;ALWAYSSORT=Yes" ,"REPLACE" )
if rc then call log D.Folder "folder successfully created on desktop..."
else       call log "ERROR:" D.Folder "folder creating failed!"

rc = SysCreateObject( "WPFolder",U.Folder,"<IceFolder>",,
                      "OBJECTID=<IceFolderut>;ALWAYSSORT=Yes" ,"REPLACE" )
if rc then call log U.Folder "folder successfully created on desktop..."
else       call log "ERROR:" U.Folder "folder creating failed!"

/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/

rc = SysCreateObject( "WPProgram", T.Program, "<IceFolder>",,
                      "OBJECTID=<MINITUN>;EXENAME="installdir""D.Program";STARTUPDIR="installdir";REPLACE" )

if rc then
   call log T.Program "object successfully created..."
else 
   call log "ERROR:" T.Program "object creating failed!"




/*------------------------------------------------------------------
 * Create object
 *------------------------------------------------------------------*/


rc =SysCreateObject("WPProgram",  T.Readme , "<IceFolderdoc>", "EXENAME=E.EXE;PARAMETERS=" || installdir || "" || D.Readme, "replace")
if rc then   call log T.Readme " object successfully created..."
     else    call log "ERROR:" D.Readme "object creating failed!"

rc =SysCreateObject("WPProgram",  T.Readmer , "<IceFolderdoc>", "EXENAME=E.EXE;PARAMETERS=" || installdir || "" || D.Readmer, "replace")
if rc then   call log T.Readmer " object successfully created..."
     else    call log "ERROR:" T.Readmer  "object creating failed!"

rc =SysCreateObject("WPProgram",  T.His , "<IceFolderdoc>", "EXENAME=E.EXE;PARAMETERS=" || installdir || "" || D.His, "replace")
if rc then   call log T.His " object successfully created..."
     else    call log "ERROR:" D.His "object creating failed!"

rc =SysCreateObject("WPProgram",  T.Hisr , "<IceFolderdoc>", "EXENAME=E.EXE;PARAMETERS=" || installdir || "" || D.Hisr, "replace")
if rc then   call log T.Hisr " object successfully created..."
     else    call log "ERROR:" D.His "object creating failed!"

rc =SysCreateObject("WPProgram",  D.ssc , "<IceFolderut>", "EXENAME=" installdir || T.ssc ";PARAMETERS=[]"  , "replace")
if rc then   call log T.ssc " object successfully created..."
     else    call log "ERROR:" D.ssc "object creating failed!"

rc =SysCreateObject("WPProgram",  D.cvt , "<IceFolderut>", "EXENAME=" installdir || T.cvt ";PARAMETERS=[]"  , "replace")
if rc then   call log T.cvt " object successfully created..."
     else    call log "ERROR:" D.cvt "object creating failed!"



/*------------------------------------------------------------------
 * Creating shadow on Startup
 *------------------------------------------------------------------*/

if GetYesNo( "Create IceCQ Shadow in OS/2 Startup Folder ? " ) == 0 then
   do
   'start /b e.exe' Installdir || D.Readme
   exit
   end
   else
   do
   rc = SysCreateObject( "WPShadow", T.Program, "<WP_START>",,
                      "SHADOWID=<MINITUN>",,
                      "REPLACE" )
   if rc then  call log T.Program "object added in Startup folder..."
 	else call log "ERROR:" T.Program "object adding in Startup folder failed!"
   end


   'start /b e.exe' Installdir || D.Readme


Exit

/*------------------------------------------------------------------
 * Get Yes or No
 *------------------------------------------------------------------*/
GetYesNo: procedure

   ok = 0

   do until ok
      call charout, arg(1) || "? "
      pull reply
      reply = left(reply, 1)
      ok = (reply = "Y") | (reply = "N")
      if \ok then do
         say 'Huh? Please enter "Y" or "N".'
      end
   end

return (reply = "Y")

/*------------------------------------------------------------------
 * Write log message
 *------------------------------------------------------------------*/
Log: procedure expose installlog; parse arg msg

   say  " "msg
   call lineout installlog, "INSTALL: "msg

return
