#include "jabber.h"

int mode = MODE_NORMAL;
conn *cli = NULL;
conn *server = NULL;

conn *dispatch(char *p, conn *c)
{
	static tap tp = {NULL,&handle_packet,0};
	conn *c_new = NULL;
	int tty;

	if(strcmp(p,"REMOVE") == 0)
	{
		DBUG("Removing connection at handler level for ",c->name)
		return NULL;
	}

	if(strcmp(p,"INIT") == 0)
	{
		DBUG("Initialization from IO loop","")
		tty = open("/dev/tty",O_RDWR | O_NONBLOCK);
		c_new = conn_add(NULL,tty);
		c_new->type = CONN_SPECIAL;
		c_new->name = strdup("/dev/tty");
		c_new->packets = packet_add(NULL,"jabber>",NULL);
		cli = c_new;
		return c_new;
	}

	if(c->type == CONN_SPECIAL)
	{
		return handle_command(p,c);
	}else{
		tag_parse(&tp,p,c);
	}

	return NULL;
}

conn *handle_command(char *line, conn *c)
{
	char *arg;
	static char *lastarg = NULL;
	static char *buff = NULL;
	int s, flag;
	conn *c_new;

	DBUG("Handle command",line)


	switch(mode)
	{
		case MODE_NORMAL:
			line = strrepl(line,"\r"," ");
			line = strrepl(line,"\n"," ");
			line = strrepl(line,"\t"," ");
			arg = strstr(line," ");
			if(arg != NULL)
			{
				arg[0] = '\0';
				++arg;
				arg = strrepl(arg," ","");
			}/* now we have a pointer to the command and to the argument */


			flag = pair_getflag(cmdtable,line);
			if(flag == CMD_LOGIN || flag == CMD_LOGOUT || flag == CMD_MESSAGE || flag == CMD_STATUS || flag == CMD_WHO || flag == CMD_ADD)
			{
				if(server == NULL)
				{
					c->packets = packet_add(c->packets,"Error, not connected to a server!\n",NULL);
					break;
				}
			}
			switch(flag)
			{
				case CMD_CONNECT:
					printf("Recieved Connect Command\n");
					if(arg == NULL || strlen(arg) <= 0)
					{
						c->packets = packet_add(c->packets,"Please enter a server name to connect to\n",NULL);
						break;
					}
					s = make_netsocket(5222,arg,1);
					if(s < 0)
					{
						c->packets = packet_add(c->packets,"Couldn't connect to server!\n",NULL);
						break;
					}
					mode = MODE_CONNECT;
					c_new = conn_add(NULL,s);
					c_new->name = strdup(arg);
					server = c_new;
					deliver_connection();
					return c_new;
					break;
				case CMD_LOGIN:
					printf("Recieved Login Command\n");
					lastarg = strdup(arg);
					mode = MODE_LOGIN;
					c->packets = packet_add(c->packets,"Password:",NULL);
					break;
				case CMD_LOGOUT:
					printf("Recieved Logout Command\n");
					break;
				case CMD_MESSAGE:
					printf("Recieved Message Command\n");
					lastarg = strdup(arg);
					mode = MODE_MESSAGE;
					c->packets = packet_add(c->packets,"Type your message, ending it with a period '.' by itself on a line:\n",NULL);
					break;
				case CMD_STATUS:
					printf("Recieved Status Command\n");
					break;
				case CMD_WHO:
					printf("Recieved Who Command\n");
					mode = MODE_WHO;
					break;
				case CMD_ADD:
					printf("Recieved Add Command\n");
					break;
				case CMD_HELP:
					printf("Recieved HELP Command\n");
					c->packets = packet_add(c->packets,"Commands:\n\tconnect server.com\n\tlogin username\n\tmessage userid@server.com\n\thelp (this command)\n",NULL);
					break;
				case CMD_EXIT:
					printf("Recieved Exit Command!\n");
					raise(SIGTERM);
					break;
				default:
					printf("Recieved UNKNOWN Command\n");
					break;
			}
			break;
		case MODE_CONNECT:
			c->packets = packet_add(c->packets,"Please wait, attempting to connect to server...\n",NULL);
			break;
		case MODE_WHO:
			c->packets = packet_add(c->packets,"Please wait, attempting to retrieve list from server...\n",NULL);
			break;
		case MODE_LOGIN:
			line = strrepl(line,"\r"," ");
			line = strrepl(line,"\n"," ");
			line = strrepl(line," ","");
			if(buff == NULL)
			{
				buff = strdup(line);
				c->packets = packet_add(c->packets,"Nickname:",NULL);
			}else{
				deliver_login(lastarg,buff,line);
				free(lastarg);
				free(buff);
				buff = lastarg = NULL;
				mode = MODE_NORMAL;
			}
			break;
		case MODE_MESSAGE:
			if(strcspn(line,common_whitespace) == 1 && line[0] == '.')
			{
				printf("I got your message to [%s]:\n%s",lastarg,buff);
				deliver_message(NULL,NULL,lastarg,NULL,NULL,buff,NULL,NULL,0);
				free(buff);
				free(lastarg);
				buff = lastarg = NULL;
				mode = MODE_NORMAL;
			}else{
				buff = strgrow(buff,line,1,0);
			}
			break;
		default:
			printf("In UNKNOWN mode!\n");
			mode = MODE_NORMAL;
			break;
	}

	if(mode == MODE_NORMAL)
		c->packets = packet_add(c->packets,"jabber>",NULL);

	return NULL;
}

void handle_packet(tag *t, conn *c)
{
	char *type;
	tap tp;
	package *p;

	DBUG("Handling packet from ",c->name)

	type = pair_getval(t->attributes,"type");
	if(type == NULL) /* not a valid incoming packet */
	{
		return;
	}

	tp.h_char = NULL;
	tp.whitespace = 0;
	p = package_init(c);

	if(strcmp(type,"connection") == 0)
	{
		tp.h_tag = &handle_connection;
		p->type = PACK_CONNECTION;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"message") == 0)
	{
		tp.h_tag = &handle_message;
		p->type = PACK_MESSAGE;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"status") == 0)
	{
		tp.h_tag = &handle_status;
		p->type = PACK_STATUS;
		p->flag_type = STATUS_NORMAL;
		tag_parse(&tp,t->contents,p);
	}
	if(strcmp(type,"roster") == 0)
	{
		tp.h_tag = &handle_roster;
		p->type = PACK_ROSTER;
		tag_parse(&tp,t->contents,p);
	}

	handle_package(p);

	free_package(p);
}


void handle_package(package *p)
{
	char *buff = NULL;
	char intbuff[20];
	pair *par;

	if(etc.debug)
		package_print(p);

	switch(p->type)
	{
		case PACK_CONNECTION:
			DBUG("Handling package ","PACK_CONNECTION")
			buff = strgrow(NULL,"Connected.\n",0,0);
			if(p->c->name != NULL)
			{
				buff = strgrow(buff,"Server: ",1,0);
				buff = strgrow(buff,p->c->name,1,0);
				buff = strgrow(buff,"\n",1,0);
			}
			if(p->version != NULL)
			{
				buff = strgrow(buff,"Version: ",1,0);
				buff = strgrow(buff,p->version,1,0);
				buff = strgrow(buff,"\n",1,0);
			}
			if(p->protocol != NULL)
			{
				buff = strgrow(buff,"Protocol: ",1,0);
				buff = strgrow(buff,p->protocol,1,0);
				buff = strgrow(buff,"\n",1,0);
			}
			buff = strgrow(buff,"jabber>",1,0);
			cli->packets = packet_add(cli->packets,buff,NULL);
			free(buff);
			mode = MODE_NORMAL;
			break;
		case PACK_STATUS:
			DBUG("Handling package ","PACK_STATUS")
			break;
		case PACK_ROSTER:
			DBUG("Handling package ","PACK_ROSTER")
			par = p->par;
			buff = strgrow(NULL,"Current Roster:\n",0,0);
			while(par != NULL)
			{
				buff = strgrow(buff,"User: ",1,0);
				buff = strgrow(buff,par->key,1,0);
				buff = strgrow(buff,"\tGroup: ",1,0);
				buff = strgrow(buff,par->val,1,0);
				buff = strgrow(buff,"\n",1,0);
				par = par->next;
			}
			buff = strgrow(buff,"jabber>",1,0);
			cli->packets = packet_add(cli->packets,buff,NULL);
			free(buff);
			mode = MODE_NORMAL;
			break;
		case PACK_MESSAGE:
			DBUG("Handling package ","PACK_MESSAGE")
			sprintf(intbuff,"%d",p->priority);
			buff = strgrow(NULL,"\n===== Incoming Message =====\n",0,0);
			buff = strgrow(buff,"From: ",1,0);
			buff = strgrow(buff,p->user,1,0);
			buff = strgrow(buff," <",1,0);
			buff = strgrow(buff,p->id,1,0);
			buff = strgrow(buff,">\nThread: ",1,0);
			buff = strgrow(buff,p->thread,1,0);
			buff = strgrow(buff,"\nPriority: ",1,0);
			buff = strgrow(buff,intbuff,1,0);
			buff = strgrow(buff,"\nSubject: ",1,0);
			buff = strgrow(buff,p->subject,1,0);
			buff = strgrow(buff,"\n\n",1,0);
			buff = strgrow(buff,p->say,1,0);
			buff = strgrow(buff,"\n======= End  Message =======\njabber>",1,0);
			cli->packets = packet_add(cli->packets,buff,NULL);
			free(buff);
			break;
		default:
			DBUG("Handling package ","ERROR - Unknown Package")
			break;
	}
}


void handle_connection(tag *t, package *p)
{
	DBUG("Processing Packet","connection")

	if(strcmp(t->name,"ver") == 0)
	{
		p->version = tag_descape(t->contents);
	}
	if(strcmp(t->name,"protocol") == 0)
	{
		p->protocol = tag_descape(t->contents);
	}
}

void handle_message(tag *t, package *p)
{
	DBUG("Processing Packet","message")

	if(strcmp(t->name,"from") == 0)
	{
		p->id = tag_descape(t->contents);
		p->user = pair_getvalnew(t->attributes,"name");
	}
	if(strcmp(t->name,"thread") == 0)
	{
		p->thread = tag_descape(t->contents);
	}
	if(strcmp(t->name,"priority") == 0)
	{
		sscanf(t->contents,"%d",&(p->priority));
	}
	if(strcmp(t->name,"ext") == 0)
	{
		p->ext = strdup(t->contents);
	}
	if(strcmp(t->name,"subject") == 0)
	{
		p->subject = tag_descape(t->contents);
	}
	if(strcmp(t->name,"say") == 0)
	{
		p->say = tag_descape(t->contents);
	}
}



void handle_status(tag *t, package *p)
{
	char *str;

	DBUG("Processing Packet","status")

	if(strcmp(t->name,"from") == 0)
	{
		p->id = tag_descape(t->contents);
		p->user = pair_getvalnew(t->attributes,"name");
	}
	if(strcmp(t->name,"say") == 0)
	{
		p->say = tag_descape(t->contents);
		str = pair_getval(t->attributes,"type");
		if(str != NULL)
		{
			if(strcmp(str,"online") == 0)
				p->flag_type = STATUS_ONLINE;
			if(strcmp(str,"offline") == 0)
				p->flag_type = STATUS_OFFLINE;
		}
	}
	if(strcmp(t->name,"status") == 0)
	{
		p->status = tag_descape(t->contents);
	}
}


void handle_roster(tag *t, package *p)
{
	DBUG("Processing Packet","roster")

	p->par = pair_add(p->par,tag_descape(t->contents),pair_getvalnew(t->attributes,"name"));
}



/* for debugging */
void package_print(package *p)
{
	pair *par;
	switch(p->type)
	{
		case PACK_CONNECTION:
			printf("PC: ver[%s] proto[%s]\n",p->version,p->protocol);
			break;
		case PACK_LOGIN:
			printf("PL: user[%s] pass[%s] nick[%s]\n",p->id,p->pass,p->user);
			break;
		case PACK_MESSAGE:
			printf("PM: from[%s <%s>] ",p->user,p->id);
			par = p->par;
			while(par != NULL)
			{
				printf("to[%s <%s>] ",par->key,par->val);
				par = par->next;
			}
			printf("pri[%d] thr[%s] sub[%s] say[%s]\n",p->priority,p->thread,p->subject,p->say);
			break;
		case PACK_STATUS:
			printf("PS: type[%d] pri[%d] status[%s] say[%s]\n",p->flag_type,p->priority,p->status,p->say);
			break;
		case PACK_ROSTER:
			printf("PR: ");
			par = p->par;
			while(par != NULL)
			{
				if(par->flag == ROSTER_ADD)
					printf("add[%s <%s>] ",par->key,par->val);
				if(par->flag == ROSTER_REMOVE)
					printf("del[%s <%s>] ",par->key,par->val);
				if(par->flag == ROSTER_GET)
					printf("get[%s <%s>] ",par->key,par->val);
				par = par->next;
			}
			printf("\n");
			break;
		case PACK_LOGOUT:
			printf("PL: LOGOUT\n");
			break;
	}
}


package *package_init(conn *c)
{
	package *p;

	p = malloc(sizeof(package));
	p->c = c;
	p->par = NULL;
	p->type = PACK_UNKNOWN;
	p->version = NULL;
	p->protocol = NULL;
	p->id = NULL;
	p->pass = NULL;
	p->user = NULL;
	p->thread = NULL;
	p->subject = NULL;
	p->ext = NULL;
	p->say = NULL;
	p->status = NULL;
	p->priority = 0;
	p->flag_type = 0;
	p->flag_misc = 0;
	p->raw = NULL;
	p->raw_type = NULL;

	return p;
}

void free_package(package *p)
{
	free(p->version);
	free(p->protocol);
	free(p->id);
	free(p->pass);
	free(p->user);
	free(p->thread);
	free(p->subject);
	free(p->ext);
	free(p->say);
	free(p->status);
	free(p->raw);
	free(p->raw_type);
	free_pair(p->par);
	free(p);
}

