#include <strings.h>
#include <stdlib.h>
#include <sys/types.h>
#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>
#include <setjmp.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <sys/un.h>

#define CONN_LISTEN 0
#define CONN_SPECIAL 1
#define CONN_NORMAL 2

#define MAXMSG  1024

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#define DBUG(x,y) \
	if(etc.debug == 1) \
	{ \
		if(y == NULL) \
			printf("+++ %s - [(null)]\n",x); \
		else \
			printf("+++ %s - [%s]\n",x,y); \
	} \

jmp_buf env_io;
extern char common_whitespace[];

void h_err(int check, char *err); /* crap to be removed */


/************************************************************/
/*
 *	Common simple linked list structure and util functions
 */
typedef struct pair_struct
{
	char *key;
	char *val;
	int flag;
	struct pair_struct *next;
} pair;

pair *pair_add(pair *p, char *key, char *val); /* !!! key and val must have been malloc'd!!! */
pair *pair_new(pair *p, char *key, char *val, int flag); /* !!! key and val will be copied into new memory */
pair *pair_get(pair *p, char *key);
char *pair_getval(pair *p, char *key);
char *pair_getvalnew(pair *p, char *key);
int pair_getflag(pair *p, char *key);
pair *pair_dup(pair *p);
void free_pair(pair *p);
pair *arg2pair(int argc, char **argv);
pair *str2pair(char *str); /* turns xml attributes(TEST='asdf' foo='b a r') into pairs */
void pair_print(pair *p); /*debug function*/

/************************************************************/
/*
 *	global environment variables
 */
struct config
{
	pair *arg;
	pair *vars;
	pair *transports;
	char *packet_start;
	char *packet_end;
	int debug;
};

extern struct config etc;


/************************************************************/
/*
 *	Common structures used for processing tagged strings
 */
typedef struct
{
	void (* h_char)();
	void (* h_tag)();
	int whitespace; /* 1 = preserve */
} tap; /* tag application pointers */

typedef struct
{
	char *name;
	pair *attributes;
	char *contents;
} tag;


/************************************************************/
/*
 *	Common structures used to pass client/socket data between functions
 */
typedef struct packet_struct
{
	char *data;
	char *error_to;
	int sent;
	struct packet_struct *next;
} packet;

typedef struct conn_struct
{
	int id;
	char *buff;
	char *ver;
	char *name;
	int type;
	packet *packets;
	struct conn_struct *next;
} conn;

/************************************************************/
/*
 *	Takes string "This is a test string"
 *	and start "This"
 *	and end "string"
 *	returning a pointer to a new string consisting of
 *	" is a test "
 */
char *substr(char *s, char *start, char *end);

/*
 *	Takes string
 *	"This is a test string"
 *	 ^             ^
 *	 s             end
 *	returning a pointer to a new string consisting of
 *	"This is a test"
 */
char *subpstr(char *s, char *end);

/*
 *	Counts the number of times sub appears in the string
 */
int strstrcount(char *s, char *sub);

/*
 *	Returns a new string with all occurences of old replaced with new
 *	(laymans regular expressions)
 */
char *strrepl(char *s, char *old, char *new);

/*
 *	Grows old to contain new, can free the given old/new strings(convenient).
 *	Buffered mallocs at 100 characters, maybe it will be faster...?
 */
char *strgrow(char *old, char *new, int old_free, int new_free);

/************************************************************/
/*
 *	Takes simple tap structure of handlers and a string
 *	and parses the tags out of the string calling the handlers
 *	where appropriate.
 */
void tag_parse(tap *handlers, char *tags, void *pass);

/*
 *	turns a tag structure into a string again, can escape the contents
 */
char *tag2str(tag *t, int escape);

/*
 *	escape/unescape special characters in the tagged string
 */
char *tag_escape(char *s);
char *tag_descape(char *s);

/*
 *	utils to create tags and free memory from common tsp structures
 */
tag *tag_new(char *name, pair *attributes, char *contents, int new);
void free_tag(tag *del);

/************************************************************/
/*
 *      Create new listen sockets for IP or unix files
 */
int make_netsocket(u_short port, char *host, int type);
int make_filesocket(char *file, int type);
struct in_addr *make_addr(char *host);

/*
 *	Utils to maintain conn/packet structures
 */
conn *conn_append(conn *c1, conn *c2);
conn *conn_add(conn *c, int s);
conn *conn_del(conn *c, int s);
packet *packet_add(packet *p, char *data, char *error_to);
void free_conn(conn *c);
void free_packet(packet *p);

/*
 *	Process new data from socket
 */
conn *conn_buffer(conn *c, char *buffer, conn *(*handle_packet)());

/*
 *	Starts the io collection loop... main hearbeat
 */
void collect_packets(conn *(*handle_packet)());



