#include "common.h"

/* some crap to be removed when error checking is done correctly */
void h_err(int check, char *err)
{
	if(check < 0)
	{
		perror(err);
		exit(1);
	}
}

void collect_packets(conn *(*handle_packet)())
{
	char buffer[MAXMSG];
	int new, nbytes, err, first = 1;
	fd_set active_fd_set, read_fd_set, write_fd_set;
	struct sockaddr_in sa;
	size_t size = sizeof(sa);
	conn *c_new, *c, *c_count;
	packet *p;

	c_new = c = c_count = NULL;

	DBUG("IO: collecting packets ","")

	FD_ZERO(&active_fd_set);
	FD_ZERO(&write_fd_set);

	err = setjmp(env_io);

	while(err == 0)
	{
		/* first time through we initialize the IO routine */
		if(!first)
		{
			read_fd_set = active_fd_set;
			DBUG("IO: waiting ","")
			h_err(select(FD_SETSIZE, &read_fd_set, &write_fd_set, NULL, NULL),"select");

			FD_ZERO(&active_fd_set);
		}else{
			c = (*handle_packet)("INIT",NULL);
			first = 0;
		}

		/*
		 * Loop through all of the connections to read
		 */
		c_count = c;
		while(c_count != NULL)
		{
			if(FD_ISSET(c_count->id, &read_fd_set))
			{
		 		if(c_count->type == CONN_LISTEN)
				{ /* Accept new connections from a listen socket */
					/* put a while loop here?  can there be multiple connections waiting? */
					new = accept(c_count->id,(struct sockaddr *) &sa, &size);
					h_err(new,"accept");
					DBUG("IO: new connection",inet_ntoa(sa.sin_addr))
					/*printf("Connecting socket [%d] from host [%s], source port [%hd]\n",new,inet_ntoa(sa.sin_addr),ntohs(sa.sin_port));*/
					c = conn_add(c,new);
					c->name = strdup(inet_ntoa(sa.sin_addr));
					c->ver = strdup(c_count->name); /* express the parent socket that it was created from */
					FD_SET(new, &active_fd_set);
				}else{
					DBUG("IO: reading data from ",c_count->name)
					nbytes = read(c_count->id, buffer, MAXMSG-1);
					h_err(nbytes,"read");
					if(nbytes == 0)
					{
						DBUG("IO: dropping connection ",c_count->name)
						FD_CLR(c_count->id, &active_fd_set); 	/* remove it from the select */
						c_new = c_count->next; 		/* make sure we contine with the next one in the chain */
						(*handle_packet)("REMOVE",c_count);	/* !!!!!!!!!tell the world that it's gone, handle_packet should take care of waiting packets too */
						c = conn_del(c,c_count->id); 		/* make sure the main list has it removed and delete it forever */
						c_count = c_new;
						continue;
					}else{
						buffer[nbytes] = '\0';
						if(c_count->type == CONN_SPECIAL)
							c = conn_append(c,(*handle_packet)(buffer,c_count));
						else
							c = conn_append(c,conn_buffer(c_count,buffer,handle_packet));
					}
				}
			}
			FD_SET(c_count->id, &active_fd_set);
			c_count = c_count->next;
		}

		/*
		 * Loop through all of the connections to write
		 */
		c_count = c;
		while(c_count != NULL)
		{
			if(c_count->packets != NULL)
			{
				DBUG("IO: writing data to ",c_count->name)
				nbytes = write(
					c_count->id,
					c_count->packets->data + c_count->packets->sent,
					strlen(c_count->packets->data) - c_count->packets->sent);
				if(nbytes < 0)
				{ /* connection broken, return it to the select to let the main loop remove it */
					c_count = c_count->next;
					continue;
				}
				h_err(nbytes,"write");
				if((nbytes + c_count->packets->sent) == strlen(c_count->packets->data))
				{
					/* this packets empty, crush and move on */
					p = c_count->packets->next;
					free_packet(c_count->packets);
					c_count->packets = p;
					if(c_count->packets == NULL && FD_ISSET(c_count->id,&write_fd_set))
					{
						/* there's nothing left to write, dont wait anymore */
						FD_CLR(c_count->id,&write_fd_set);
						c_count = c_count->next;
						continue;
					}
				}else{
					c_count->packets->sent += nbytes;
				}
				/* if theres still stuff waiting, come back and get it later */
				if(c_count->packets != NULL)
					FD_SET(c_count->id,&write_fd_set);
			}
			c_count = c_count->next;
		}
	}

	/* shutdown */

	c_count = c;
	while(c_count != NULL)
	{
		close(c_count->id);
		c_count = c_count->next;
	}
	DBUG("EXITING, sockets closed","")
}


conn *conn_buffer(conn *c, char *buffer, conn *(*handle_packet)())
{
	char *p_start, *p_end, *p_str, *next, *old;
	conn *c_new = NULL;

DBUG("BUFFER:",buffer);

	if(c->buff == NULL)
	{
		c->buff = malloc(1);
		c->buff[0] = '\0';
	}
	/* there has GOT to be a better way to do this! */
	old = c->buff;
	c->buff = malloc(strlen(c->buff) + strlen(buffer) + 1);
	c->buff[0] = '\0';
	strcpy(c->buff,old);
	free(old);
	strcat(c->buff,buffer);

	p_start = strstr(c->buff, etc.packet_start);
	p_end = strstr(c->buff, etc.packet_end);
	while(p_start != NULL && p_end != NULL)
	{
		next = p_end + strlen(etc.packet_end);
		p_str = (char *)subpstr(p_start,next);
		old = c->buff;
		c->buff = strdup(next);
		free(old);

		DBUG("IO: Extracted packet ",p_str)

		c_new = conn_append(c_new,(*handle_packet)(p_str,c));
		free(p_str);
		p_start = strstr(c->buff, etc.packet_start);
		p_end = strstr(c->buff, etc.packet_end);
	}
	return c_new;
}


conn *conn_add(conn *c, int s)
{
	conn *c_new;

	c_new = malloc(sizeof(conn));
	c_new->id = s;
	c_new->buff = NULL;
	c_new->packets = NULL;
	c_new->ver = NULL;
	c_new->name = NULL;
	c_new->type = CONN_NORMAL;
	c_new->next = c;

	return c_new;
}

conn *conn_append(conn *c1, conn *c2)
{
	conn *c_count = c1;

	if(c1 == NULL)
		return c2;
	if(c2 == NULL)
		return c1;
	while(c_count->next != NULL)
		c_count = c_count->next;
	c_count->next = c2;
	return c1;
}

conn *conn_del(conn *c, int s)
{
	conn *next, *prev, *curr;
	int first_flag = 1;

	curr = prev = c;

	while(curr != NULL)
	{
		if(curr->id == s)
		{
			next = curr->next;
			close(curr->id);	/* make sure the socket is closed */
			free_conn(curr);
			if(first_flag)
				c = next;
			else
				prev->next = next;
			return c;
		}
		first_flag = 0;
		prev = curr;
		curr = curr->next;
	}
	return c;
}

void free_conn(conn *c)
{
	packet *next, *curr;

	next = c->packets;

	while(next != NULL)
	{
		curr = next;
		next = curr->next;
		free(curr->data);
		free(curr->error_to);
		free(curr);
	}

	free(c->buff);
	free(c->ver);
	free(c->name);
	free(c);
}


packet *packet_add(packet *p, char *data, char *error_to)
{
	packet *p_new, *p_count;

	DBUG("IO: Creating new packet ",data);

	p_new = malloc(sizeof(packet));

	if(data == NULL)
	{
		p_new->data = malloc(1);
		p_new->data[0] = '\0';
	}else{
		p_new->data = strdup(data);
	}

	if(error_to == NULL)
		p_new->error_to = NULL;
	else
		p_new->error_to = strdup(error_to);

	p_new->sent = 0;
	p_new->next = NULL;
	if(p == NULL)
	{
		return p_new;
	}else{
		p_count = p;
		while(p_count != NULL)
		{
			if(p_count->next == NULL)
			{
				p_count->next = p_new;
				break;
			}
			p_count = p_count->next;
		}
	}

	return p;
}

void free_packet(packet *p)
{
	free(p->data);
	free(p->error_to);
	free(p);
}

