#include "common.h"

int make_netsocket(u_short port, char *host, int type)
{
	int s, flag = 1;
	struct sockaddr_in sa;
	struct in_addr *saddr;

	bzero((void *)&sa,sizeof(struct sockaddr_in));

	if((s = socket(AF_INET,SOCK_STREAM,0)) < 0)
		return(-1);
	if(setsockopt(s, SOL_SOCKET, SO_REUSEADDR, (char*)&flag, sizeof(flag)) < 0)
		return(-1);

	saddr = make_addr(host);
	if(saddr == NULL)
		return(-1);
	sa.sin_family = AF_INET;
	sa.sin_port = htons(port);
	if(host != NULL) /* bind to all local addresses unless instructed to do otherwise */
		sa.sin_addr.s_addr = saddr->s_addr;

	if(type == 0)
	{
		if(bind(s,(struct sockaddr*)&sa,sizeof sa) < 0)
		{
			close(s);
			return(-1);
		}
	}else{
		if (connect(s,(struct sockaddr*)&sa,sizeof sa) < 0)
		{
			close(s);
			return(-1);
		}
	}


	DBUG("Created parent net socket","");

	return(s);
}


int make_filesocket(char *file, int type)
{
	int s;
	struct sockaddr_un sa;

	DBUG("File Socket",file);

	bzero((void *)&sa,sizeof(struct sockaddr_un));

	if((s = socket(AF_UNIX,SOCK_STREAM,0)) < 0)
		return(-1);

	sa.sun_family = AF_UNIX;
	strcpy(sa.sun_path, file);

	if(type == 0)
	{
		unlink(file);
		if(bind(s,(struct sockaddr*)&sa,sizeof sa) < 0)
		{
			close(s);
			return(-1);
		}
	}else{
		if (connect(s,(struct sockaddr*)&sa,sizeof sa) < 0)
		{
			close(s);
			return(-1);
		}
	}


	DBUG("Created parent file socket","");

	return(s);
}


struct in_addr *make_addr(char *host)
{
	struct hostent *hp;
	static struct in_addr addr;
	char myname[MAXHOSTNAMELEN + 1];

	if(host == NULL || strlen(host) == 0)
	{
		gethostname(myname,MAXHOSTNAMELEN);
		hp = gethostbyname(myname);
		if(hp != NULL)
		{
			return (struct in_addr *) *hp->h_addr_list;
		}
	}else{
		addr.s_addr = inet_addr(host);
		if(addr.s_addr != -1)
		{
			return &addr;
		}
		hp = gethostbyname(host);
		if(hp != NULL)
		{
			return (struct in_addr *) *hp->h_addr_list;
		}
	}
	return NULL;
}
