      program overlap_test

      parameter (n=100)

      real a(n)
      call cmf_random (a)
      call test_left1 (a,n)
      call test_right2 (a,n)
      end

      subroutine test_left1 (a, n)

      integer n

      real a(n), b(n[1:0])    ! b overlaps a with [1:1]
      real a1(n)
      logical equal (n)
      integer errors

      b = a
      forall (i=1:n)
         a1 (i) = b (i-1)
      end forall

      a = cshift (a, 1, -1)

      equal = (a1 .eq. a)
      errors = count (equal)
      errors = n - errors

      print *, errors, ' Errors for left overlapping'
      end

      subroutine test_right2 (a, n)

      integer n

      real a(n), b(n[0:2])    ! b overlaps a on the right side with 2
      real a1(n)
      logical equal (n)
      integer errors

c     call print_a (a, n)

      b = a
      forall (i=1:n)
         a1 (i) = b (i+2)
      end forall

c     call print_a (a1, n)
      a = cshift (a, 1, 2)
c     call print_a (a, n)

      equal = (a1 .eq. a)
      errors = count (equal)
      errors = n - errors

      print *, errors, ' Errors for right overlapping'
      end

      subroutine print_a (a, n)
      real a(n)
      integer i, n
      do i = 1, n
        print *, 'A(',i,')  =  ', a(i)
      end do
      end
