/*********************************************************************
*                                                                    *
*  Author      : Dr. Thomas Brandes, GMD, I1.HR                      *
*  Date        : Mar 93                                              *
*  Last Update : Mar 93                                              *
*                                                                    *
*  Module      : permutations.c                                      *
*                                                                    *
*********************************************************************/

# if defined __STDC__ | defined __cplusplus
# define ARGS(parameters)       parameters
# else
# define ARGS(parameters)       ()
# endif

# include "Tree.h"

       /*************************************************
       *                                                *
       *  Type definition for a Permutation             *
       *                                                *
       *    1  -> Permutation.pa[0]                     *
       *    2  -> Permutation.pa[1]                     *
       *                                                *
       *    n  -> Permutation.pa[n-1]                   *
       *                                                *
       *   where n is Permutation.n                     *
       *                                                *
       *************************************************/

typedef struct {
  int n; 
  int pa [MAX_DIMENSIONS];
  }  Permutation;

       /*************************************************
       *                                                *
       *  some operations on Permutations               *
       *                                                *
       *  make_id_permuatation (5)  :  1 2 3 4 5        *
       *                                                *
       *************************************************/

Permutation make_id_permutation ARGS((int n));

bool is_id_permutation ARGS((Permutation perm));

int new_perm_position ARGS((Permutation perm, int pos));

       /****************************************************
       *                                                   *
       *       1  2  3  4  5                               *
       *  p :  3  4  5  2  1                               *
       *                                                   *
       *   olddim = 4     newdim = 2                       *
       *                                                   *
       *  n :  3  4  2  1                                  *
       *                                                   *
       ****************************************************/

Permutation reduce_permutation ARGS((Permutation p, int olddim, int newdim));

bool equal_permutations ARGS((Permutation perm1, Permutation perm2));

bool conform_permutations ARGS((Permutation perm1, Permutation perm2));

bool transpose_permutations ARGS((Permutation perm1, Permutation perm2));

Permutation merge_permutation ARGS((Permutation perm1, Permutation perm2));

void print_permutation ARGS((Permutation perm));

       /****************************************************
       *                                                   *
       *  make permutation from the current distribution   *
       *                                                   *
       *  A (N1,N2,N3,N4,N5)  (*,BLOCK,*,BLOCK,*)          *
       *                                                   *
       *  ->      1, 3, 5, 2, 4                            *
       *                                                   *
       ****************************************************/

Permutation implied_distribution_permutation ARGS((DistributedDimensions dist));

       /****************************************************
       *                                                   *
       *  index_list returns a sequence of ranks of index  *
       *                                                   *
       *  [1:n,A,I,J,B] ->  1  2  0  0  3                  *
       *                                                   *
       ****************************************************/

Permutation index_list ARGS((tTree indexes));


       /****************************************************
       *                                                   *
       *  get_rank_permutation :                           *
       *                                                   *
       *  index_vector  :   1  0  2  0  3                  *
       *  perm          :   4  1  5  2  3                  *
       *                                                   *
       *  results in    :   0  1  3  0  2                  *
       *                                                   *
       *  compressed    :   1  3  2  0  0                  *
       *                                                   *
       ****************************************************/

Permutation get_rank_permutation ARGS((Permutation index_vector, 
                                       	Permutation perm));

       /****************************************************
       *                                                   *
       *  switch_index_types :                             *
       *  switch_indexes     :                             *
       *                                                   *
       *     perm = 4  2  3  1  5                          *
       *                                                   *
       *  (N1,N2,N3,N4,N5)  -> (N4,N2,N3,N1,N5)            *
       *                                                   *
       ****************************************************/

void switch_index_types ARGS((tTree typelist, Permutation perm));

void switch_indexes ARGS((tTree indexlist, Permutation perm));

void switch_parameters ARGS((tTree paramlist, Permutation perm));

