/*************************************************************************
*                                                                        *
*  Name : labels.c                                                       *
*                                                                        *
*  Purpose : Data Structures for Label Tables                            *
*                                                                        *
*  Author : Dr. Thomas Brandes, GMD, Z1.HR                               *
*                                                                        *
*  Date   : 15. 4. 1993                                                  *
*                                                                        *
*************************************************************************/

#include "labels.h"
#include "Scanner.h"  /* MakeEndDos */

int LabelCounter;

typedef struct
 { int name, used, defined, inDos ;
 } label_info;

label_info Labels [MAX_LABELS];

void InitLabels ()
{ LabelCounter = 0;
}

int SearchLabel (label)
int label;
{  int found, i;
   i = 0;
   found = 0;
   while ((i < LabelCounter) && (found == 0))
     { if (Labels[i].name == label)
          found = 1;
        else
          i++;
     }
   /* printf ("Search: Position of Label %d is %d\\n",label,i); */
   return (i);
}

void NewLabel (name, used, defined, inDos)
int name, used, defined, inDos;

{ if (LabelCounter == MAX_LABELS)
    { printf ("Maximal number of labels (%d) reached\n", MAX_LABELS);
      printf ("Internal Error\n");
      exit (-1);
    }
  Labels[LabelCounter].name = name;
  Labels[LabelCounter].used = used;
  Labels[LabelCounter].defined = defined;
  Labels[LabelCounter].inDos = inDos;
  LabelCounter += 1;
}

void LabelDo (label)
int label;
{  int pos;
   /* printf ("%d will be a Do Label \\n", label); */
   pos = SearchLabel (label);
   if (pos == LabelCounter) /* not found, define */
     NewLabel (label, 1, 0, 1);
    else
     { Labels[pos].used = 1;
       Labels[pos].inDos += 1;  }
}

int LabelDefine (label)
int label;
{ int pos;
  pos = SearchLabel (label);
  /* printf ("Label %d will be defined \\n", label); */
  if (pos < LabelCounter)  /* found */
   { if (Labels[pos].defined > 0)
       printf ("Label %d defined twice\\n", label);
     MakeEndDos = Labels[pos].inDos;
     /* printf ("%d EndDos inserted\\n", MakeEndDos); */
   }
   else
     NewLabel (label, 0, 1, 0);
  return (pos+1);
}
           
int LabelUse (label)
int label;
{  int pos;
   pos = SearchLabel (label);
   /* printf ("Label %d is used\\n", label); */
   if (pos < LabelCounter)  /* found */
    { Labels[pos].used = 1;
    }
    else
      NewLabel (label, 1, 0, 0);
  return (pos+1);
} /* LabelUse */
