/**************************************************************************
*                                                                         *
**************************************************************************/

#include <stdio.h>
#include "protocol.h" 
#include "Unparse.h"
#include "ShowDefs.h"

#undef DEBUG

char protocol_name[200];
char unit_name [100];
FILE *protocol;
int error_counter;
int warning_counter;
tTree last_stmt;     /* is always ACF_NODE (label, line, ...) */

void open_protocol (name)
char name[];
{
  protocol = fopen (name,"w");
  if (protocol == (FILE *) NULL)
    { printf ("Adaptor failed to open protocol file %s\n", name);
      printf ("Please check permissions\n");
      exit (-1);
    }
  strcpy (protocol_name, name);
  last_stmt = NoTree;
  error_counter = 0;
  warning_counter = 0;
}

void close_protocol ()
{
  if (error_counter + warning_counter == 0)
     printf ("Protocol written in File %s\n", protocol_name);
  else if (error_counter == 0)
     printf ("Protocol written in File %s (%d warnings)\n", 
              protocol_name, warning_counter);
  else
     printf ("Protocol written in File %s (%d errors)\n", 
              protocol_name, error_counter);
  fclose (protocol);
}

int protocol_errors ()
{
  return (error_counter);
}

void set_protocol_unit (t)
tTree t;
{ tIdent Name;
  char s[100];
  int i;

  last_stmt = NoTree;    /* make sure there is no statement from last unit */

  sprintf (unit_name, "");

  if (t->Kind == kPROGRAM_DECL)
    { Name = t->PROGRAM_DECL.Name; 
      GetString (Name, s);
      sprintf (unit_name, "PROGRAM %s", s);
    }
  if (t->Kind == kPROC_DECL)
    { Name = t->PROC_DECL.Name; 
      GetString (Name, s);
      sprintf (unit_name, "SUBROUTINE %s", s);
    }
  if (t->Kind == kFUNC_DECL)
    { Name = t->FUNC_DECL.Name; 
      GetString (Name, s);
      sprintf (unit_name, "FUNCTION %s", s);
    }
  if (t->Kind == kMODULE_DECL)
    { Name = t->MODULE_DECL.Name; 
      GetString (Name, s);
      sprintf (unit_name, "MODULE %s", s);
    }
  if (t->Kind == kBLOCK_DATA_DECL)
    { Name = t->BLOCK_DATA_DECL.Name; 
      GetString (Name, s);
      sprintf (unit_name, "BLOCK DATA %s", s);
    }
  fprintf (protocol, "%s\n", unit_name);
#ifdef DEBUG
  printf ("protocol of %s\n", unit_name);
#endif
  for (i=0; i < strlen (unit_name); i++)
     fprintf (protocol, "=");
  fprintf (protocol, "\n\n");
}

void set_protocol_stmt (t)
tTree t;
{
  last_stmt = t;
}

void print_protocol (s)
char s[];
{ fprintf (protocol, "%s\n", s);
#ifdef DEBUG
  printf ("%s\n", s);
#endif
}

void tree_protocol (s, t)
char s[];
tTree t;
{ fprintf (protocol, "%s",s);
  FileUnparse (protocol, t);
  fprintf (protocol, "\n");
}

void obj_protocol (s, o)
char s[];
tObject o;
{ fprintf (protocol, "%s",s);
  SemFile = protocol;
  ShowDeclarations (o);
  fprintf (protocol, "\n");
}

void simple_error_protocol (s)
char s[];
{ error_counter += 1;
  fprintf (protocol, "ERROR : %s\n",s);
#ifdef DEBUG
  printf ("ERROR : %s\n",s);
#endif
}

void simple_warning_protocol (s)
char s[];
{ warning_counter += 1;
  fprintf (protocol, "WARNING : %s\n",s);
#ifdef DEBUG
  printf ("WARNING : %s\n",s);
#endif
}

void tree_error_protocol (s, t)
char s[];
tTree t;
{ error_counter += 1;
  fprintf (protocol, "ERROR : %s\n",s);
  FileUnparse (protocol, t);
  fprintf (protocol, "\n");
#ifdef DEBUG
  printf ("ERROR : %s\n",s);
  FileUnparse (stdout, t);
  printf ("\n");
#endif
}

void obj_error_protocol (s, o)
char s[];
tObject o;
{ error_counter += 1;
  fprintf (protocol, "ERROR : %s\n",s);
  SemFile = protocol;
  ShowDeclarations (o);
  fprintf (protocol, "\n");
#ifdef DEBUG
  printf ("ERROR : %s\n",s);
  SemFile = stdout;
  ShowDeclarations (o);
  printf ("\n");
#endif
}

void tree_warning_protocol (s, t)
char s[];
tTree t;
{ warning_counter += 1;
  fprintf (protocol, "WARNING : %s",s);
  FileUnparse (protocol, t);
  fprintf (protocol, "\n");
#ifdef DEBUG
  printf ("WARNING : %s",s);
  FileUnparse (stdout, t);
  printf ("\n");
#endif
}

void error_protocol (message)
char message[];
{ error_counter += 1;
  if (last_stmt != NoTree)
     { fprintf (protocol, "ERROR : %s (Line = %d)\n", 
                           message, last_stmt->ACF_NODE.Line);
       FileUnparse (protocol, last_stmt);
     }
   else
     fprintf (protocol, "ERROR : %s\n", message);
#ifdef DEBUG
  if (last_stmt != NoTree)
     { printf ("ERROR : %s (Line = %d)\n", 
                           message, last_stmt->ACF_NODE.Line);
       FileUnparse (stdout, last_stmt);
     }
   else
     printf ("ERROR : %s\n", message);
#endif
}

void stmt_protocol (message)
char message[];
{
  if (last_stmt != NoTree)
     { fprintf (protocol, "%s (Line = %d)\n", 
                           message, last_stmt->ACF_NODE.Line);
       FileUnparse (protocol, last_stmt);
     }
   else
     fprintf (protocol, "O.K. : %s\n", message);
#ifdef DEBUG
  if (last_stmt != NoTree)
     { printf ("%s (Line = %d)\n", 
                           message, last_stmt->ACF_NODE.Line);
       FileUnparse (stdout, last_stmt);
     }
   else
     printf ("O.K. : %s\n", message);
#endif
}

void kill_in_protocol ()
{ printf ("INTERNAL ERROR, will stop\n");
  close_protocol ();
  exit (-1);
}

void failure_protocol (module, proc, t)

char module[];
char proc[];
tTree t;

{ printf ("INTERNAL ERROR: failure in module  = %s\n", module);
  printf ("                procedure/function = %s\n", proc);
  printf ("Tree = "); FileUnparse (stdout, t); printf ("\n");
  WriteTree (stdout, t);
  error_protocol ("stop for internal ERROR");
  close_protocol ();
  exit (-1);
}

