#!/usr/bin/perl -w
# this script reads output from lsdvd and transfers it to list of chapters accepted by dvdauthour
#usage: lsdvd2chapter.pl lsdvd.txt > chapters.txt
# where lsdvd.txt - the lsdvd output excerpt containing info about main movie title.

use strict;

my @chaps = ();
my $time = 0;
while (<>)
{
	next if !/Chapter: \d+, Length: (\d{2}):(\d{2}):(\d{2}), Start Cell:/;
	$time += $1 * 3600 + $2 * 60 + $3;
	push @chaps, $time;
}
my $f = 0;
foreach (@chaps)
{
	my $min = int($_ / 60);
	my $sec = $_ % 60;
	print "," if $f;
	printf("%d:%02d", $min, $sec);
	$f = 1;
}
print "\n";