/*
 * ttaenc.h (non_unicode version)
 *
 * Description:	 TTAv1 encoder definitions and prototypes
 * Developed by: Alexander Djourik <ald@true-audio.com>
 *               Pavel Zhilin <pzh@true-audio.com>
 *
 * Copyright (c) 1999-2005 Alexander Djourik. All rights reserved.
 *
 */

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * aint with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Please see the file COPYING in this directory for full copyright
 * information.
 */
#ifndef TTAENC_H
#define TTAENC_H

#include <stdio.h>
#include <stdlib.h>

#if 0
#include <wchar.h>
#include <wctype.h>
#endif

#include <limits.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <errno.h>
#include <locale.h>

#ifdef _WIN32
#include <direct.h>
#include <io.h>
#include <conio.h>
#else
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#endif

#if defined(_WIN32) || defined(__WATCOMC__) || defined(__EMX__)
#pragma pack(1)
#define __ATTRIBUTE_PACKED__
#else
#define __ATTRIBUTE_PACKED__	__attribute__((packed))
#endif

/* little or big-endian */
#if defined(_BYTE_ORDER) && defined(_LITTLE_ENDIAN) && defined(_BIG_ENDIAN)
	#if _BYTE_ORDER == _BIG_ENDIAN
	#define TTAENC_PLATFORM_BIG_ENDIAN
	#else
	#define TTAENC_PLATFORM_LITTLE_ENDIAN
	#endif
#elif defined(_BIG_ENDIAN)
#define TTAENC_PLATFORM_BIG_ENDIAN
#else
#define TTAENC_PLATFORM_LITTLE_ENDIAN
#endif

#if !defined(MAX_PATHNAME)
    #if defined(MSDOS)
        #if defined(__DJGPP__)
        #define MAX_PATHNAME 260
        #else
        #define MAX_PATHNAME 64
        #endif
    #elif defined(_WIN32)
    #define MAX_PATHNAME _MAX_PATH
    #elif defined(OS2) || defined(__OS2__) || defined(__EMX__)
    #define MAX_PATHNAME 260
    #else
    #define MAX_PATHNAME 1024
    #endif
#endif

#define COPYRIGHT		"Copyright (c) 2005 Alexander Djourik. All rights reserved."

#define MYNAME			"ttaenc"
#define VERSION			"3.3"
#define BUILD			"20050517"
#define PROJECT_URL		"http://tta.sourceforge.net"

#define MAX_BPS			32
#define FRAME_TIME		(long double)1.04489795918367346939L

#define TTA1_SIGN		0x31415454
#define RIFF_SIGN		0x46464952
#define WAVE_SIGN		0x45564157
#define fmt_SIGN		0x20746D66
#define data_SIGN		0x61746164

#define MAX_ORDER		16
#define BIT_BUFFER_SIZE (1024*1024)

#define WAVE_FORMAT_PCM	1
#define WAVE_FORMAT_IEEE_FLOAT 3
#define WAVE_FORMAT_EXTENSIBLE 0xFFFE

#define COMMAND_ERROR	0
#define FORMAT_ERROR	1
#define FILE_ERROR		2
#define FIND_ERROR		3
#define CREATE_ERROR	4
#define OPEN_ERROR		5
#define MEMORY_ERROR	6
#define WRITE_ERROR		7
#define READ_ERROR		8

#ifdef TTAENC_PLATFORM_BIG_ENDIAN
#define	ENDSWAP_INT16(x)	(((((x)>>8)&0xFF)|(((x)&0xFF)<<8)))
#define	ENDSWAP_INT32(x)	(((((x)>>24)&0xFF)|(((x)>>8)&0xFF00)|(((x)&0xFF00)<<8)|(((x)&0xFF)<<24)))
#else
#define	ENDSWAP_INT16(x)	(x)
#define	ENDSWAP_INT32(x)	(x)
#endif

#define SWAP16(x) (\
(((x)&(1<< 0))?(1<<15):0) | \
(((x)&(1<< 1))?(1<<14):0) | \
(((x)&(1<< 2))?(1<<13):0) | \
(((x)&(1<< 3))?(1<<12):0) | \
(((x)&(1<< 4))?(1<<11):0) | \
(((x)&(1<< 5))?(1<<10):0) | \
(((x)&(1<< 6))?(1<< 9):0) | \
(((x)&(1<< 7))?(1<< 8):0) | \
(((x)&(1<< 8))?(1<< 7):0) | \
(((x)&(1<< 9))?(1<< 6):0) | \
(((x)&(1<<10))?(1<< 5):0) | \
(((x)&(1<<11))?(1<< 4):0) | \
(((x)&(1<<12))?(1<< 3):0) | \
(((x)&(1<<13))?(1<< 2):0) | \
(((x)&(1<<14))?(1<< 1):0) | \
(((x)&(1<<15))?(1<< 0):0))

#define LINE "------------------------------------------------------------"

#define PREDICTOR1(x, k)	((long)((((uint64)x << k) - x) >> k))

#define ENC(x)  (((x)>0)?((x)<<1)-1:(-(x)<<1))
#define DEC(x)  (((x)&1)?(++(x)>>1):(-(x)>>1))

#if defined(_WIN32) || defined(__OS2__) || defined(MSDOS) || defined(__EMX__)
    #define _SEP L'\\'
    #define ERASE_STDERR fprintf (stderr, "%78c\r", 0x20)
#else
    #define _SEP L'/'
    #define ERASE_STDERR fprintf (stderr, "\033[2K")
#endif

#if defined(_WIN32) || defined(__WATCOMC__)
	typedef unsigned __int64 uint64;
    #define strcasecmp	stricmp
#else
	#if defined(__EMX__)
		#define strcasecmp	stricmp
	#endif
	typedef unsigned long long uint64;
#endif

typedef struct {
	unsigned long k0;
	unsigned long k1;
	unsigned long sum0;
	unsigned long sum1;
} adapt;

typedef struct {
	long shift;
	long round;
	long error;
	long mutex;
	long qm[MAX_ORDER];
	long dx[MAX_ORDER];
	long dl[MAX_ORDER];
} fltst;

typedef struct {
	fltst fst;
	adapt rice;
	long last;
} encoder;

#endif	/* TTAENC_H */
