/* A REXX Script to create a playlist */
call RxFuncAdd 'SysFileTree', 'RexxUtil', 'SysFileTree'

/* Take input either from the command line */
/* or a folder dropped onto our icon */
playList = list     /* The name of our playlist */
parse arg folder       /* The folder to search for the playlist */

folder = strip(folder);
/* Strip any quotation marks at the beginning or the end */
if (POS('"', folder) = 1) then do
    folder = substr(folder, 2, length(folder));
end

if (POS('"', folder) = length(folder) - 1) then do
    folder = substr(folder, 1, length(folder) - 2);
end

/* gather the list of files and write it out */
If STREAM(folder,'C','QUERY EXISTS') <> "" THEN DO
    fileList.0 = 1;
    fileList.1 = folder;
END
else do
    rc = SysFileTree(folder||'\*.*', fileList., 'FSO');
END


say "Found "||fileList.0||" entires in "||folder;

do n=1 to fileList.0
    rc = LINEOUT(playList, fileList.n)
    say "Adding -> "||fileList.n;
end

/* Now close the file */
rc = LINEOUT(playList)

say "Playlist creation complete.";
