/* Z-Play V0.93                                                          */
/*                                                                       */
/* (c) 2000 Dirk Schulz                                                  */
/* WinSuxx@gmx.net || @WinSuxx on #os/2ger [ircnet]                      */
/*                                                                       */
/* enjoy this little tool!                                               */
/*                                                                       */
/* you can get best use of it by making it the default                   */
/* association with .mp3 files, a simple double-click                    */
/* then adds the file to Z!'s playlist                                   */
/* If Z! is not running it is launched for you!                          */
/*************************************************************************/
/* Please adjust line 44 to your needs!! (global.path2z)                 */
/*************************************************************************/
/* history: V0.01 first version, never published      (2000-01-10)       */
/*          V0.1  second version, beautified code     (2000-01-12)       */
/*          V0.9  complete rewrite, no longer needs external dlls        */
/*                                                    (2000-01-26)       */
/*          V0.91 bugfix: no longer starts multiple instances of Z!      */
/*                        when more than five instances of Z-Play        */
/*                        are started at a time                          */
/*          V0.92 bugfix: setup should now work correct (worked with     */
/*                        4OS/2, but not with cmd...)                    */
/*                        filenames may now contains blanks (thanks to   */
/*                        goffena@bellsouth.net for his solution)        */
/*          V0.93 added:  new file associations (*mp3, *mp2, *wav)       */
/*                        red icon file for playlists                    */
/*                bugfix: zp.cmd now starts z with absolute path         */
/*                                                                       */
/*                                                                       */


/* load RexxUtils                                                        */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

call on halt name CTRL_C                        /* to disable CTRL-C     */

/* set variables                                                         */
/* adjust the settings to your local setup!!!!                           */

global.PipeName = '\PIPE\ZMP3'                       /* leave this alone */
global.PipeTimeOut = 50000                              /* may be raised */
global.debug = 0                                /* if =1 be more verbose */
global.z.0 = 3                                 /* number of names for Z! */
global.z.1 = 'Z - The MP3 Player'                /* names in the tasklist*/
global.z.2 = 'z.exe'                           /* first one is used if Z!*/
global.z.3 = 'z!'                                /* is started by z-play */
global.lockfile = 'z-play.lck'
global.startargs = '/c'                    /* arguments for starting cmd */
global.waitforZ = 3    /* increase this if you get errors (pipe error 3) */
/*************************************************************************/
global.path2z = 'F:\Daten\Rexx\Z-Play\v0.92\z.exe'  /* path to Z! please adjust!!!     */
/*************************************************************************/
parse arg args
args=translate(args,' ','"')
args=(space(args))

parse source op . global.me
global.path = filespec('drive',global.me) || filespec('path',global.me)
global.path = global.path || global.lockfile

rt = CheckMultiple()

say '================================================================'
say '= Z-Play v0.93                                                 ='
say '=                                                              ='
say '= Easily add mp3-files to the actual Z! playlist               ='
say '=                                                              ='
say '= brought to you by Dirk Schulz, WinSuxx on #os/2ger [ircnet]  ='
say '=                   WinSuxx@gmx.net                            ='
say '=                                                              ='
say '= written january 2000                                         ='
say '= Thanx to dink for his great Z!                               ='
say '================================================================'


if length(args) < 1 then
do 
  say 'You should give me a filename to play!!!'
  say ' '
  say 'something like: z-play track01.mp3'
  exit 1
end

/*
rt = translate(filespec('name',args))
if right(rt,4) \= '.MP3' then
do
  say 'Sorry! I only accept *.mp3 as valid filenames!'
  say 'If you need other extensions please modify the code!'
  exit 1
end
*/
say '   Trying to add song' args 'to the playlist...'

rt = CheckRunning()

rt = SysWaitNamedPipe(global.PipeName,global.PipeTimeOut)
if rt \= 0 then
do 
  if rt = 231 then
  do 10
    rt = SysWaitNamedPipe(global.PipeName,global.PipeTimeOut)
    if rt = 0  then leave
  end
  else
  do
    say 'Unable to open pipe after' global.PipeTimeOut/1000000 'second(s)'
    say 'Errornr:' rt
    say 'perhaps Z! is not running... if the problem pertains,'
    say 'please contact the author of z-play!'
    exit 1
  end
end /* do */

rt = CommPipe('*play' args)
if global.debug then say 'CommPipe returns:' rt
rt = SysSleep(1)                                 /* leave this here!!!!! */
rt = CommPipe('*status tag')
if global.debug then say 'Status:' rt 'length(Status):' length(rt)
if (rt = 1) | (length(rt) = 0) then
  say '   Z! is idling at the moment...'
else
  say '   Z! is playing:' rt

say ' '
say '   Added song' args 'to the playlist'
say ' '
say '   Enjoy listening with Z! and Z-Play'

call CloseLockFile

/* rt=SysDropFuncs() */
exit 0

CTRL_C:
  say "Sorry, can't interrupt program..."
  return

/* CommPipe open a named pipe, sends the string given as argument to the */
/* pipe and returns the answer of the pipe                               */
/* A procedure CloseError is required, it is called in case of any       */
/* error.                                                                */
CommPipe: PROCEDURE expose global.
parse arg comm
  rt = stream(global.PipeName,C,'OPEN')
  if global.debug then say 'open returns:' rt
  if rt \= 'READY:' then call CloseError

  rt = lineout(global.PipeName,comm)
  rv = linein(global.PipeName)

  rt = stream(global.PipeName,C,'CLOSE')
  if global.debug then say 'close returns:' rt
  if rt \= 'READY:' then call CloseError
return rv

CloseError: PROCEDURE
  say 'An error occured while opening/closing the named pipe'
  say 'If this error occurs more often, please contact the'
  say 'author of z-play!'
  exit 1

/* check whether z! is running, if not: fire it up                       */
/* uses SysQuerySwitchList() from RexxUtil (available with Warp 4, FP ?) */
/* otherwise tries to connect to the named pipe of Z! (slow method...)   */
CheckRunning: PROCEDURE expose global.
running = 0
  if \Rxfuncquery('SysQuerySwitchList') then
    do
      do 5
        rt = SysWaitNamedPipe(global.PipeName,global.PipeTimeOut)
        if rt = 0 then
         do
           running = 1
           return 0
         end
      end
    end
  else
  do 
    rc = SysQuerySwitchList(tl)
    do i = 1 to tl.0
      do j = 1 to global.z.0
        rt = lastpos(global.z.j,tl.i)
        if rt > 0 then
          running = 1
      end
    end
  end
  if global.debug then say 'Z! running:' running
  if \running then
    do
      say '   Launching Z! - please stand by'
      say ' '
      '@start "'||global.z.1||'"'global.startargs global.path2z 
      rt = SysSleep(global.waitforZ)
    end
return running

CheckMultiple: PROCEDURE expose global.
  rt = stream(global.path,'c','OPEN')
  if global.debug then say 'stream(open) =' rt
  i = 0
  if rt \= 'READY:' then
   do until (rt = 'READY:') | (i = 145)
     if global.debug then say 'other process running... waiting!' i
     rt = SysSleep(1)
     rt = stream(global.path,'c','OPEN')
     i = i + 1
   end
  if i = 145 then
    call OpenFileError
return 0

CloseLockFile: PROCEDURE expose global.
  rt = stream(global.path,'C','CLOSE')
  ret = SysFileDelete(global.path)
  if rt \= 'READY:' then
    return 1
return 0

OpenFileError: PROCEDURE
  say 'Sorry! Unable to open lockfile...'
  say 'Contact the author of Z-Play!!!'
  exit 1
return
