/* tmidi rexx caller for NN/2 helper */

/* On S keyhit or played-through-to-end midi file is saved to saveto path */
/* To -not- save, press any key other than S/s before the end of play */

/*
 * To setup Navigator:
 *
 *  Select OPTIONS/General preferences.../Helpers
 *
 *  If you do not already have a mid helper do the following:
 *
 *  1. Create New Type
 *     a. MIME Type:    audio
 *     b. MIME Subtype: midi
 *
 *  2. File extensions
 *     Set to "mid"  (no dot, no quotes)
 *
 *  3. Action:
 *     "Launch the Application"
 *
 *  4. In the entry field for the application, enter
 *     "d:\path\tmidigm.cmd"  (use actual d:\path\)
 *
 *  5. Select OK
 *
 * You may need to repeat the procedure for File/MIME type of "audio/x-midi"
 * since you may get this at some sites.  Enter the same data, except use
 * "x-midi" in 1b.
 *
 */

/*
 * This is not a plugin.  This is a helper (more reliable as far as the
 * current NN goes).  Plus, it's very easy/simple to modify this file to
 * suit whatever requirements you may have.
 */

/* change the following: saveto, logfile, deftype to whatever you want */

saveto = "f:\mids\saves\"
logfile = saveto||"saves.log"
deftype = "-gm"

parse arg midifile

basefile = filespec("name",midifile)
savefile = saveto||basefile

tmidi midifile deftype
if rc = 255 then do
   tStr = date('O') time('N') "Saving" savefile
   say tStr
   call lineout logfile,tStr

   "@"copy midifile savefile "> nul"
   if rc <> 0 then call lineout logfile,"copy failed, err:" rc

end






